/*************************************************************
 *
 *  MathJax/config/readium-iframe.js
 *
 *  Configuration file for Readium project
 *
 *  ---------------------------------------------------------------------
 *
 *  Copyright (c) 2013 MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
window.MathJax = {
    jax: ["input/MathML", "output/SVG"],
    extensions: ["mml2jax.js", "MathEvents.js"],
    MathML: {
        extensions: ["content-mathml.js"]
    },
    SVG: {
        font: "STIX-Web",
        mtextFontInherit: true,
        linebreaks: { automatic: true }
    },
    MathMenu: {
        showRenderer: false
    },
    menuSettings: {
        zoom: "none"
    },
    MatchWebFonts: {
        matchFor: {
            SVG: true
        },
        fontCheckDelay: 500,
        fontCheckTimeout: 15 * 1000
    },
    messageStyle: "none",
    AuthorInit: function () {
        MathJax.Hub.Register.StartupHook("SVG Jax Ready", function () {
            var SVG = MathJax.OutputJax.SVG, GLYPH = SVG.BBOX.GLYPH;
            GLYPH.Augment({
                Init: function (scale, id, h, d, w, l, r, p) {
                    var t = SVG.config.blacker,
                        def = {"stroke-width": t};
                    if (p !== "") {
                        def.d = "M" + p + "Z"
                    }
                    if (scale !== 1) {
                        def.transform = "scale(" + scale + ")"
                    }
                    this.SUPER(arguments).Init.call(this, def);
                    this.h = (h + t) * scale;
                    this.d = (d + t) * scale;
                    this.w = (w + t / 2) * scale;
                    this.l = (l + t / 2) * scale;
                    this.r = (r + t / 2) * scale;
                    this.H = Math.max(0, this.h);
                    this.D = Math.max(0, this.d);
                    this.x = this.y = 0;
                    this.scale = scale;
                }
            });
        });
    }
};
/*
 *  /MathJax.js
 *
 *  Copyright (c) 2009-2014 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
if(document.getElementById&&document.childNodes&&document.createElement){if(!(window.MathJax&&MathJax.Hub)){if(window.MathJax){window.MathJax={AuthorConfig:window.MathJax}}else{window.MathJax={}}MathJax.isPacked=true;MathJax.version="2.4.0";MathJax.fileversion="2.4.0";MathJax.cdnVersion="2.4-beta-2";MathJax.cdnFileVersions={};(function(d){var b=window[d];if(!b){b=window[d]={}}var e=[];var c=function(f){var g=f.constructor;if(!g){g=function(){}}for(var h in f){if(h!=="constructor"&&f.hasOwnProperty(h)){g[h]=f[h]}}return g};var a=function(){return function(){return arguments.callee.Init.call(this,arguments)}};b.Object=c({constructor:a(),Subclass:function(f,h){var g=a();g.SUPER=this;g.Init=this.Init;g.Subclass=this.Subclass;g.Augment=this.Augment;g.protoFunction=this.protoFunction;g.can=this.can;g.has=this.has;g.isa=this.isa;g.prototype=new this(e);g.prototype.constructor=g;g.Augment(f,h);return g},Init:function(f){var g=this;if(f.length===1&&f[0]===e){return g}if(!(g instanceof f.callee)){g=new f.callee(e)}return g.Init.apply(g,f)||g},Augment:function(f,g){var h;if(f!=null){for(h in f){if(f.hasOwnProperty(h)){this.protoFunction(h,f[h])}}if(f.toString!==this.prototype.toString&&f.toString!=={}.toString){this.protoFunction("toString",f.toString)}}if(g!=null){for(h in g){if(g.hasOwnProperty(h)){this[h]=g[h]}}}return this},protoFunction:function(g,f){this.prototype[g]=f;if(typeof f==="function"){f.SUPER=this.SUPER.prototype}},prototype:{Init:function(){},SUPER:function(f){return f.callee.SUPER},can:function(f){return typeof this[f]==="function"},has:function(f){return typeof this[f]!=="undefined"},isa:function(f){return f instanceof Object&&this instanceof f}},can:function(f){return this.prototype.can.call(this,f)},has:function(f){return this.prototype.has.call(this,f)},isa:function(g){var f=this;while(f){if(f===g){return true}else{f=f.SUPER}}return false},SimpleSUPER:c({constructor:function(f){return this.SimpleSUPER.define(f)},define:function(f){var h={};if(f!=null){for(var g in f){if(f.hasOwnProperty(g)){h[g]=this.wrap(g,f[g])}}if(f.toString!==this.prototype.toString&&f.toString!=={}.toString){h.toString=this.wrap("toString",f.toString)}}return h},wrap:function(i,h){if(typeof h!=="function"||!h.toString().match(/\.\s*SUPER\s*\(/)){return h}var g=function(){this.SUPER=g.SUPER[i];try{var f=h.apply(this,arguments)}catch(j){delete this.SUPER;throw j}delete this.SUPER;return f};g.toString=function(){return h.toString.apply(h,arguments)};return g}})})})("MathJax");(function(BASENAME){var BASE=window[BASENAME];if(!BASE){BASE=window[BASENAME]={}}var CALLBACK=function(data){var cb=function(){return arguments.callee.execute.apply(arguments.callee,arguments)};for(var id in CALLBACK.prototype){if(CALLBACK.prototype.hasOwnProperty(id)){if(typeof data[id]!=="undefined"){cb[id]=data[id]}else{cb[id]=CALLBACK.prototype[id]}}}cb.toString=CALLBACK.prototype.toString;return cb};CALLBACK.prototype={isCallback:true,hook:function(){},data:[],object:window,execute:function(){if(!this.called||this.autoReset){this.called=!this.autoReset;return this.hook.apply(this.object,this.data.concat([].slice.call(arguments,0)))}},reset:function(){delete this.called},toString:function(){return this.hook.toString.apply(this.hook,arguments)}};var ISCALLBACK=function(f){return typeof f==="function"&&f.isCallback};var EVAL=function(code){return eval.call(window,code)};var TESTEVAL=function(){EVAL("var __TeSt_VaR__ = 1");if(window.__TeSt_VaR__){try{delete window.__TeSt_VaR__}catch(error){window.__TeSt_VaR__=null}}else{if(window.execScript){EVAL=function(code){BASE.__code=code;code="try {"+BASENAME+".__result = eval("+BASENAME+".__code)} catch(err) {"+BASENAME+".__result = err}";window.execScript(code);var result=BASE.__result;delete BASE.__result;delete BASE.__code;if(result instanceof Error){throw result}return result}}else{EVAL=function(code){BASE.__code=code;code="try {"+BASENAME+".__result = eval("+BASENAME+".__code)} catch(err) {"+BASENAME+".__result = err}";var head=document.getElementsByTagName("head")[0];if(!head){head=document.body}var script=document.createElement("script");script.appendChild(document.createTextNode(code));head.appendChild(script);head.removeChild(script);var result=BASE.__result;delete BASE.__result;delete BASE.__code;if(result instanceof Error){throw result}return result}}}TESTEVAL=null};var USING=function(args,i){if(arguments.length>1){if(arguments.length===2&&!(typeof arguments[0]==="function")&&arguments[0]instanceof Object&&typeof arguments[1]==="number"){args=[].slice.call(args,i)}else{args=[].slice.call(arguments,0)}}if(args instanceof Array&&args.length===1){args=args[0]}if(typeof args==="function"){if(args.execute===CALLBACK.prototype.execute){return args}return CALLBACK({hook:args})}else{if(args instanceof Array){if(typeof args[0]==="string"&&args[1]instanceof Object&&typeof args[1][args[0]]==="function"){return CALLBACK({hook:args[1][args[0]],object:args[1],data:args.slice(2)})}else{if(typeof args[0]==="function"){return CALLBACK({hook:args[0],data:args.slice(1)})}else{if(typeof args[1]==="function"){return CALLBACK({hook:args[1],object:args[0],data:args.slice(2)})}}}}else{if(typeof args==="string"){if(TESTEVAL){TESTEVAL()}return CALLBACK({hook:EVAL,data:[args]})}else{if(args instanceof Object){return CALLBACK(args)}else{if(typeof args==="undefined"){return CALLBACK({})}}}}}throw Error("Can't make callback from given data")};var DELAY=function(time,callback){callback=USING(callback);callback.timeout=setTimeout(callback,time);return callback};var WAITFOR=function(callback,signal){callback=USING(callback);if(!callback.called){WAITSIGNAL(callback,signal);signal.pending++}};var WAITEXECUTE=function(){var signals=this.signal;delete this.signal;this.execute=this.oldExecute;delete this.oldExecute;var result=this.execute.apply(this,arguments);if(ISCALLBACK(result)&&!result.called){WAITSIGNAL(result,signals)}else{for(var i=0,m=signals.length;i<m;i++){signals[i].pending--;if(signals[i].pending<=0){signals[i].call()}}}};var WAITSIGNAL=function(callback,signals){if(!(signals instanceof Array)){signals=[signals]}if(!callback.signal){callback.oldExecute=callback.execute;callback.execute=WAITEXECUTE;callback.signal=signals}else{if(signals.length===1){callback.signal.push(signals[0])}else{callback.signal=callback.signal.concat(signals)}}};var AFTER=function(callback){callback=USING(callback);callback.pending=0;for(var i=1,m=arguments.length;i<m;i++){if(arguments[i]){WAITFOR(arguments[i],callback)}}if(callback.pending===0){var result=callback();if(ISCALLBACK(result)){callback=result}}return callback};var HOOKS=MathJax.Object.Subclass({Init:function(reset){this.hooks=[];this.reset=reset},Add:function(hook,priority){if(priority==null){priority=10}if(!ISCALLBACK(hook)){hook=USING(hook)}hook.priority=priority;var i=this.hooks.length;while(i>0&&priority<this.hooks[i-1].priority){i--}this.hooks.splice(i,0,hook);return hook},Remove:function(hook){for(var i=0,m=this.hooks.length;i<m;i++){if(this.hooks[i]===hook){this.hooks.splice(i,1);return}}},Execute:function(){var callbacks=[{}];for(var i=0,m=this.hooks.length;i<m;i++){if(this.reset){this.hooks[i].reset()}var result=this.hooks[i].apply(window,arguments);if(ISCALLBACK(result)&&!result.called){callbacks.push(result)}}if(callbacks.length===1){return null}if(callbacks.length===2){return callbacks[1]}return AFTER.apply({},callbacks)}});var EXECUTEHOOKS=function(hooks,data,reset){if(!hooks){return null}if(!(hooks instanceof Array)){hooks=[hooks]}if(!(data instanceof Array)){data=data==null?[]:[data]}var handler=HOOKS(reset);for(var i=0,m=hooks.length;i<m;i++){handler.Add(hooks[i])}return handler.Execute.apply(handler,data)};var QUEUE=BASE.Object.Subclass({Init:function(){this.pending=0;this.running=0;this.queue=[];this.Push.apply(this,arguments)},Push:function(){var callback;for(var i=0,m=arguments.length;i<m;i++){callback=USING(arguments[i]);if(callback===arguments[i]&&!callback.called){callback=USING(["wait",this,callback])}this.queue.push(callback)}if(!this.running&&!this.pending){this.Process()}return callback},Process:function(queue){while(!this.running&&!this.pending&&this.queue.length){var callback=this.queue[0];queue=this.queue.slice(1);this.queue=[];this.Suspend();var result=callback();this.Resume();if(queue.length){this.queue=queue.concat(this.queue)}if(ISCALLBACK(result)&&!result.called){WAITFOR(result,this)}}},Suspend:function(){this.running++},Resume:function(){if(this.running){this.running--}},call:function(){this.Process.apply(this,arguments)},wait:function(callback){return callback}});var SIGNAL=QUEUE.Subclass({Init:function(name){QUEUE.prototype.Init.call(this);this.name=name;this.posted=[];this.listeners=HOOKS(true)},Post:function(message,callback,forget){callback=USING(callback);if(this.posting||this.pending){this.Push(["Post",this,message,callback,forget])}else{this.callback=callback;callback.reset();if(!forget){this.posted.push(message)}this.Suspend();this.posting=true;var result=this.listeners.Execute(message);if(ISCALLBACK(result)&&!result.called){WAITFOR(result,this)}this.Resume();delete this.posting;if(!this.pending){this.call()}}return callback},Clear:function(callback){callback=USING(callback);if(this.posting||this.pending){callback=this.Push(["Clear",this,callback])}else{this.posted=[];callback()}return callback},call:function(){this.callback(this);this.Process()},Interest:function(callback,ignorePast,priority){callback=USING(callback);this.listeners.Add(callback,priority);if(!ignorePast){for(var i=0,m=this.posted.length;i<m;i++){callback.reset();var result=callback(this.posted[i]);if(ISCALLBACK(result)&&i===this.posted.length-1){WAITFOR(result,this)}}}return callback},NoInterest:function(callback){this.listeners.Remove(callback)},MessageHook:function(msg,callback,priority){callback=USING(callback);if(!this.hooks){this.hooks={};this.Interest(["ExecuteHooks",this])}if(!this.hooks[msg]){this.hooks[msg]=HOOKS(true)}this.hooks[msg].Add(callback,priority);for(var i=0,m=this.posted.length;i<m;i++){if(this.posted[i]==msg){callback.reset();callback(this.posted[i])}}return callback},ExecuteHooks:function(msg){var type=msg instanceof Array?msg[0]:msg;if(!this.hooks[type]){return null}return this.hooks[type].Execute(msg)}},{signals:{},find:function(name){if(!SIGNAL.signals[name]){SIGNAL.signals[name]=new SIGNAL(name)}return SIGNAL.signals[name]}});BASE.Callback=BASE.CallBack=USING;BASE.Callback.Delay=DELAY;BASE.Callback.After=AFTER;BASE.Callback.Queue=QUEUE;BASE.Callback.Signal=SIGNAL.find;BASE.Callback.Hooks=HOOKS;BASE.Callback.ExecuteHooks=EXECUTEHOOKS})("MathJax");(function(e){var a=window[e];if(!a){a=window[e]={}}var d=navigator.vendor==="Apple Computer, Inc."&&typeof navigator.vendorSub==="undefined";var g=0;var h=function(i){if(document.styleSheets&&document.styleSheets.length>g){g=document.styleSheets.length}if(!i){i=document.getElementsByTagName("head")[0];if(!i){i=document.body}}return i};var f=[];var c=function(){for(var k=0,j=f.length;k<j;k++){a.Ajax.head.removeChild(f[k])}f=[]};var b={};b[e]="";a.Ajax={loaded:{},loading:{},loadHooks:{},timeout:15*1e3,styleDelay:1,config:{root:"",path:b},STATUS:{OK:1,ERROR:-1},fileURL:function(j){var i=j.match(/^\[([-._a-z0-9]+)\]/i);if(i&&i[1]in b){j=(b[i[1]]||this.config.root)+j.substr(i[1].length+2)}return j},fileName:function(j){var i=this.config.root;if(j.substr(0,i.length)===i){j="["+e+"]"+j.substr(i.length)}else{for(var k in b){if(b.hasOwnProperty(k)&&b[k]){if(j.substr(0,b[k].length)===b[k]){j="["+k+"]"+j.substr(b[k].length);break}}}}return j},fileRev:function(j){var i=a.cdnFileVersions[name]||a.cdnVersion;if(i){i="?rev="+i}return i},urlRev:function(i){return this.fileURL(i)+this.fileRev(i)},Require:function(k,n){n=a.Callback(n);var l;if(k instanceof Object){for(var j in k){if(k.hasOwnProperty(j)){l=j.toUpperCase();k=k[j]}}}else{l=k.split(/\./).pop().toUpperCase()}k=this.fileURL(k);if(this.loaded[k]){n(this.loaded[k])}else{var m={};m[l]=k;this.Load(m,n)}return n},Load:function(k,m){m=a.Callback(m);var l;if(k instanceof Object){for(var j in k){if(k.hasOwnProperty(j)){l=j.toUpperCase();k=k[j]}}}else{l=k.split(/\./).pop().toUpperCase()}k=this.fileURL(k);if(this.loading[k]){this.addHook(k,m)}else{this.head=h(this.head);if(this.loader[l]){this.loader[l].call(this,k,m)}else{throw Error("Can't load files of type "+l)}}return m},LoadHook:function(l,m,k){m=a.Callback(m);if(l instanceof Object){for(var j in l){if(l.hasOwnProperty(j)){l=l[j]}}}l=this.fileURL(l);if(this.loaded[l]){m(this.loaded[l])}else{this.addHook(l,m,k)}return m},addHook:function(j,k,i){if(!this.loadHooks[j]){this.loadHooks[j]=MathJax.Callback.Hooks()}this.loadHooks[j].Add(k,i)},Preloading:function(){for(var l=0,j=arguments.length;l<j;l++){var k=this.fileURL(arguments[l]);if(!this.loading[k]){this.loading[k]={preloaded:true}}}},loader:{JS:function(k,m){var j=this.fileName(k);var i=document.createElement("script");var l=a.Callback(["loadTimeout",this,k]);this.loading[k]={callback:m,timeout:setTimeout(l,this.timeout),status:this.STATUS.OK,script:i};this.loading[k].message=a.Message.File(j);i.onerror=l;i.type="text/javascript";i.src=k+this.fileRev(j);this.head.appendChild(i)},CSS:function(j,l){var i=this.fileName(j);var k=document.createElement("link");k.rel="stylesheet";k.type="text/css";k.href=j+this.fileRev(i);this.loading[j]={callback:l,message:a.Message.File(i),status:this.STATUS.OK};this.head.appendChild(k);this.timer.create.call(this,[this.timer.file,j],k)}},timer:{create:function(j,i){j=a.Callback(j);if(i.nodeName==="STYLE"&&i.styleSheet&&typeof i.styleSheet.cssText!=="undefined"){j(this.STATUS.OK)}else{if(window.chrome&&i.nodeName==="LINK"){j(this.STATUS.OK)}else{if(d){this.timer.start(this,[this.timer.checkSafari2,g++,j],this.styleDelay)}else{this.timer.start(this,[this.timer.checkLength,i,j],this.styleDelay)}}}return j},start:function(j,i,k,l){i=a.Callback(i);i.execute=this.execute;i.time=this.time;i.STATUS=j.STATUS;i.timeout=l||j.timeout;i.delay=i.total=k||0;if(k){setTimeout(i,k)}else{i()}},time:function(i){this.total+=this.delay;this.delay=Math.floor(this.delay*1.05+5);if(this.total>=this.timeout){i(this.STATUS.ERROR);return 1}return 0},file:function(j,i){if(i<0){a.Ajax.loadTimeout(j)}else{a.Ajax.loadComplete(j)}},execute:function(){this.hook.call(this.object,this,this.data[0],this.data[1])},checkSafari2:function(i,j,k){if(i.time(k)){return}if(document.styleSheets.length>j&&document.styleSheets[j].cssRules&&document.styleSheets[j].cssRules.length){k(i.STATUS.OK)}else{setTimeout(i,i.delay)}},checkLength:function(i,l,n){if(i.time(n)){return}var m=0;var j=l.sheet||l.styleSheet;try{if((j.cssRules||j.rules||[]).length>0){m=1}}catch(k){if(k.message.match(/protected variable|restricted URI/)){m=1}else{if(k.message.match(/Security error/)){m=1}}}if(m){setTimeout(a.Callback([n,i.STATUS.OK]),0)}else{setTimeout(i,i.delay)}}},loadComplete:function(i){i=this.fileURL(i);var j=this.loading[i];if(j&&!j.preloaded){a.Message.Clear(j.message);clearTimeout(j.timeout);if(j.script){if(f.length===0){setTimeout(c,0)}f.push(j.script)}this.loaded[i]=j.status;delete this.loading[i];this.addHook(i,j.callback)}else{if(j){delete this.loading[i]}this.loaded[i]=this.STATUS.OK;j={status:this.STATUS.OK}}if(!this.loadHooks[i]){return null}return this.loadHooks[i].Execute(j.status)},loadTimeout:function(i){if(this.loading[i].timeout){clearTimeout(this.loading[i].timeout)}this.loading[i].status=this.STATUS.ERROR;this.loadError(i);this.loadComplete(i)},loadError:function(i){a.Message.Set(["LoadFailed","File failed to load: %1",i],null,2e3);a.Hub.signal.Post(["file load error",i])},Styles:function(k,l){var i=this.StyleString(k);if(i===""){l=a.Callback(l);l()}else{var j=document.createElement("style");j.type="text/css";this.head=h(this.head);this.head.appendChild(j);if(j.styleSheet&&typeof j.styleSheet.cssText!=="undefined"){j.styleSheet.cssText=i}else{j.appendChild(document.createTextNode(i))}l=this.timer.create.call(this,l,j)}return l},StyleString:function(n){if(typeof n==="string"){return n}var k="",o,m;for(o in n){if(n.hasOwnProperty(o)){if(typeof n[o]==="string"){k+=o+" {"+n[o]+"}\n"}else{if(n[o]instanceof Array){for(var l=0;l<n[o].length;l++){m={};m[o]=n[o][l];k+=this.StyleString(m)}}else{if(o.substr(0,6)==="@media"){k+=o+" {"+this.StyleString(n[o])+"}\n"}else{if(n[o]!=null){m=[];for(var j in n[o]){if(n[o].hasOwnProperty(j)){if(n[o][j]!=null){m[m.length]=j+": "+n[o][j]}}}k+=o+" {"+m.join("; ")+"}\n"}}}}}}return k}}})("MathJax");MathJax.HTML={Element:function(c,e,d){var f=document.createElement(c);if(e){if(e.style){var b=e.style;e.style={};for(var g in b){if(b.hasOwnProperty(g)){e.style[g.replace(/-([a-z])/g,this.ucMatch)]=b[g]}}}MathJax.Hub.Insert(f,e)}if(d){if(!(d instanceof Array)){d=[d]}for(var a=0;a<d.length;a++){if(d[a]instanceof Array){f.appendChild(this.Element(d[a][0],d[a][1],d[a][2]))}else{if(c==="script"){this.setScript(f,d[a])}else{f.appendChild(document.createTextNode(d[a]))}}}}return f},ucMatch:function(a,b){return b.toUpperCase()},addElement:function(b,a,d,c){return b.appendChild(this.Element(a,d,c))},TextNode:function(a){return document.createTextNode(a)},addText:function(a,b){return a.appendChild(this.TextNode(b))},setScript:function(a,b){if(this.setScriptBug){a.text=b}else{while(a.firstChild){a.removeChild(a.firstChild)}this.addText(a,b)}},getScript:function(a){var b=a.text===""?a.innerHTML:a.text;return b.replace(/^\s+/,"").replace(/\s+$/,"")},Cookie:{prefix:"mjx",expires:365,Set:function(a,e){var d=[];if(e){for(var g in e){if(e.hasOwnProperty(g)){d.push(g+":"+e[g].toString().replace(/&/g,"&&"))}}}var b=this.prefix+"."+a+"="+escape(d.join("&;"));if(this.expires){var f=new Date;f.setDate(f.getDate()+this.expires);b+="; expires="+f.toGMTString()}try{document.cookie=b+"; path=/"}catch(c){}},Get:function(a,d){if(!d){d={}}var g=new RegExp("(?:^|;\\s*)"+this.prefix+"\\."+a+"=([^;]*)(?:;|$)");var f;try{f=g.exec(document.cookie)}catch(c){}if(f&&f[1]!==""){var j=unescape(f[1]).split("&;");for(var e=0,b=j.length;e<b;e++){f=j[e].match(/([^:]+):(.*)/);var h=f[2].replace(/&&/g,"&");if(h==="true"){h=true}else{if(h==="false"){h=false}else{if(h.match(/^-?(\d+(\.\d+)?|\.\d+)$/)){h=parseFloat(h)}}}d[f[1]]=h}}return d}}};MathJax.Localization={locale:"en",directory:"[MathJax]/localization",strings:{ast:{menuTitle:"asturianu"},br:{menuTitle:"brezhoneg"},ca:{menuTitle:"català"},cdo:{menuTitle:"Mìng-dĕ̤ng-ngṳ̄"},cs:{menuTitle:"čeština"},da:{menuTitle:"dansk"},de:{menuTitle:"Deutsch"},en:{menuTitle:"English",isLoaded:true},eo:{menuTitle:"Esperanto"},es:{menuTitle:"español"},fa:{menuTitle:"فارسی"},fi:{menuTitle:"suomi"},fr:{menuTitle:"français"},gl:{menuTitle:"galego"},he:{menuTitle:"עברית"},ia:{menuTitle:"interlingua"},it:{menuTitle:"italiano"},ja:{menuTitle:"日本語"},kn:{menuTitle:"ಕನ್ನಡ"},ko:{menuTitle:"한국어"},lb:{menuTitle:"Lëtzebuergesch"},mk:{menuTitle:"македонски"},nl:{menuTitle:"Nederlands"},oc:{menuTitle:"occitan"},pl:{menuTitle:"polski"},pt:{menuTitle:"portugusê"},"pt-br":{menuTitle:"português do Brasil"},ru:{menuTitle:"русский"},sl:{menuTitle:"slovenščina"},sv:{menuTitle:"svenska"},tr:{menuTitle:"Türkçe"},uk:{menuTitle:"українська"},vi:{menuTitle:"Tiếng Việt"},"zh-hans":{menuTitle:"中文（简体）"}},pattern:/%(\d+|\{\d+\}|\{[a-z]+:\%\d+(?:\|(?:%\{\d+\}|%.|[^\}])*)+\}|.)/g,SPLIT:"axb".split(/(x)/).length===3?function(a,b){return a.split(b)}:function(c,e){var a=[],b,d=0;e.lastIndex=0;while(b=e.exec(c)){a.push(c.substr(d,b.index-d));a.push.apply(a,b.slice(1));d=b.index+b[0].length}a.push(c.substr(d));return a},_:function(b,a){if(a instanceof Array){return this.processSnippet(b,a)}return this.processString(this.lookupPhrase(b,a),[].slice.call(arguments,2))},processString:function(l,o,g){var j,e;for(j=0,e=o.length;j<e;j++){if(g&&o[j]instanceof Array){o[j]=this.processSnippet(g,o[j])}}var f=this.SPLIT(l,this.pattern);for(j=1,e=f.length;j<e;j+=2){var p=f[j].charAt(0);if(p>="0"&&p<="9"){f[j]=o[f[j]-1];if(typeof f[j]==="number"){f[j]=this.number(f[j])}}else{if(p==="{"){p=f[j].substr(1);if(p>="0"&&p<="9"){f[j]=o[f[j].substr(1,f[j].length-2)-1];if(typeof f[j]==="number"){f[j]=this.number(f[j])}}else{var k=f[j].match(/^\{([a-z]+):%(\d+)\|(.*)\}$/);if(k){if(k[1]==="plural"){var d=o[k[2]-1];if(typeof d==="undefined"){f[j]="???"}else{d=this.plural(d)-1;var h=k[3].replace(/(^|[^%])(%%)*%\|/g,"$1$2%").split(/\|/);if(d>=0&&d<h.length){f[j]=this.processString(h[d].replace(/\uEFEF/g,"|"),o,g)}else{f[j]="???"}}}else{f[j]="%"+f[j]}}}}}if(f[j]==null){f[j]="???"}}if(!g){return f.join("")}var a=[],b="";for(j=0;j<e;j++){b+=f[j];j++;if(j<e){if(f[j]instanceof Array){a.push(b);a=a.concat(f[j]);b=""}else{b+=f[j]}}}if(b!==""){a.push(b)}return a},processSnippet:function(g,e){var c=[];for(var d=0,b=e.length;d<b;d++){if(e[d]instanceof Array){var f=e[d];if(typeof f[1]==="string"){var h=f[0];if(!(h instanceof Array)){h=[g,h]}var a=this.lookupPhrase(h,f[1]);c=c.concat(this.processMarkdown(a,f.slice(2),g))}else{if(f[1]instanceof Array){c=c.concat(this.processSnippet.apply(this,f))}else{if(f.length>=3){c.push([f[0],f[1],this.processSnippet(g,f[2])])}else{c.push(e[d])}}}}else{c.push(e[d])}}return c},markdownPattern:/(%.)|(\*{1,3})((?:%.|.)+?)\2|(`+)((?:%.|.)+?)\4|\[((?:%.|.)+?)\]\(([^\s\)]+)\)/,processMarkdown:function(b,h,d){var j=[],e;var c=b.split(this.markdownPattern);var g=c[0];for(var f=1,a=c.length;f<a;f+=8){if(c[f+1]){e=this.processString(c[f+2],h,d);if(!(e instanceof Array)){e=[e]}e=[["b","i","i"][c[f+1].length-1],{},e];if(c[f+1].length===3){e=["b",{},e]}}else{if(c[f+3]){e=this.processString(c[f+4].replace(/^\s/,"").replace(/\s$/,""),h,d);if(!(e instanceof Array)){e=[e]}e=["code",{},e]}else{if(c[f+5]){e=this.processString(c[f+5],h,d);if(!(e instanceof Array)){e=[e]}e=["a",{href:this.processString(c[f+6],h),target:"_blank"},e]}else{g+=c[f];e=null}}}if(e){j=this.concatString(j,g,h,d);j.push(e);g=""}if(c[f+7]!==""){g+=c[f+7]}}j=this.concatString(j,g,h,d);return j},concatString:function(a,c,b,d){if(c!=""){c=this.processString(c,b,d);if(!(c instanceof Array)){c=[c]}a=a.concat(c)}return a},lookupPhrase:function(f,a,d){if(!d){d="_"}if(f instanceof Array){d=f[0]||"_";f=f[1]||""}var c=this.loadDomain(d);if(c){MathJax.Hub.RestartAfter(c)}var b=this.strings[this.locale];if(b){if(b.domains&&d in b.domains){var e=b.domains[d];if(e.strings&&f in e.strings){a=e.strings[f]}}}return a},loadFile:function(b,d,e){e=MathJax.Callback(e);b=d.file||b;if(!b.match(/\.js$/)){b+=".js"}if(!b.match(/^([a-z]+:|\[MathJax\])/)){var a=this.strings[this.locale].directory||this.directory+"/"+this.locale||"[MathJax]/localization/"+this.locale;b=a+"/"+b}var c=MathJax.Ajax.Require(b,function(){d.isLoaded=true;return e()});return c.called?null:c},loadDomain:function(c,e){var b,a=this.strings[this.locale];if(a){if(!a.isLoaded){b=this.loadFile(this.locale,a);if(b){return MathJax.Callback.Queue(b,["loadDomain",this,c]).Push(e||{})}}if(a.domains&&c in a.domains){var d=a.domains[c];if(!d.isLoaded){b=this.loadFile(c,d);if(b){return MathJax.Callback.Queue(b).Push(e)}}}}return MathJax.Callback(e)()},Try:function(a){a=MathJax.Callback(a);a.autoReset=true;try{a()}catch(b){if(!b.restart){throw b}MathJax.Callback.After(["Try",this,a],b.restart)}},resetLocale:function(a){if(!a){return}a=a.toLowerCase();while(!this.strings[a]){var c=a.lastIndexOf("-");if(c===-1){return}a=a.substring(0,c)}var b=this.strings[a].remap;this.locale=b?b:a},setLocale:function(a){this.resetLocale(a);if(MathJax.Menu){this.loadDomain("MathMenu")}},addTranslation:function(b,e,c){var d=this.strings[b],a=false;if(!d){d=this.strings[b]={};a=true}if(!d.domains){d.domains={}}if(e){if(!d.domains[e]){d.domains[e]={}}d=d.domains[e]}MathJax.Hub.Insert(d,c);if(a&&MathJax.Menu.menu){MathJax.Menu.CreateLocaleMenu()}},setCSS:function(b){var a=this.strings[this.locale];if(a){if(a.fontFamily){b.style.fontFamily=a.fontFamily}if(a.fontDirection){b.style.direction=a.fontDirection;if(a.fontDirection==="rtl"){b.style.textAlign="right"}}}return b},fontFamily:function(){var a=this.strings[this.locale];return a?a.fontFamily:null},fontDirection:function(){var a=this.strings[this.locale];return a?a.fontDirection:null},plural:function(b){var a=this.strings[this.locale];if(a&&a.plural){return a.plural(b)}if(b==1){return 1}return 2},number:function(b){var a=this.strings[this.locale];if(a&&a.number){return a.number(b)}return b}};MathJax.Message={ready:false,log:[{}],current:null,textNodeBug:navigator.vendor==="Apple Computer, Inc."&&typeof navigator.vendorSub==="undefined"||window.hasOwnProperty&&window.hasOwnProperty("konqueror"),styles:{"#MathJax_Message":{position:"fixed",left:"1px",bottom:"2px","background-color":"#E6E6E6",border:"1px solid #959595",margin:"0px",padding:"2px 8px","z-index":"102",color:"black","font-size":"80%",width:"auto","white-space":"nowrap"},"#MathJax_MSIE_Frame":{position:"absolute",top:0,left:0,width:"0px","z-index":101,border:"0px",margin:"0px",padding:"0px"}},browsers:{MSIE:function(a){MathJax.Message.msieFixedPositionBug=(document.documentMode||0)<7;if(MathJax.Message.msieFixedPositionBug){MathJax.Hub.config.styles["#MathJax_Message"].position="absolute"}MathJax.Message.quirks=document.compatMode==="BackCompat"},Chrome:function(a){MathJax.Hub.config.styles["#MathJax_Message"].bottom="1.5em";MathJax.Hub.config.styles["#MathJax_Message"].left="1em"}},Init:function(a){if(a){this.ready=true}if(!document.body||!this.ready){return false}if(this.div&&this.div.parentNode==null){this.div=document.getElementById("MathJax_Message");if(this.div){this.text=this.div.firstChild}}if(!this.div){var b=document.body;if(this.msieFixedPositionBug&&window.attachEvent){b=this.frame=this.addDiv(document.body);b.removeAttribute("id");b.style.position="absolute";b.style.border=b.style.margin=b.style.padding="0px";b.style.zIndex="101";b.style.height="0px";b=this.addDiv(b);b.id="MathJax_MSIE_Frame";window.attachEvent("onscroll",this.MoveFrame);window.attachEvent("onresize",this.MoveFrame);this.MoveFrame()}this.div=this.addDiv(b);this.div.style.display="none";this.text=this.div.appendChild(document.createTextNode(""))}return true},addDiv:function(a){var b=document.createElement("div");b.id="MathJax_Message";if(a.firstChild){a.insertBefore(b,a.firstChild)}else{a.appendChild(b)}return b},MoveFrame:function(){var a=MathJax.Message.quirks?document.body:document.documentElement;var b=MathJax.Message.frame;b.style.left=a.scrollLeft+"px";b.style.top=a.scrollTop+"px";b.style.width=a.clientWidth+"px";b=b.firstChild;b.style.height=a.clientHeight+"px"},localize:function(a){return MathJax.Localization._(a,a)},filterText:function(a,c,b){if(MathJax.Hub.config.messageStyle==="simple"){if(b==="LoadFile"){if(!this.loading){this.loading=this.localize("Loading")+" "}a=this.loading;this.loading+="."}else{if(b==="ProcessMath"){if(!this.processing){this.processing=this.localize("Processing")+" "}a=this.processing;this.processing+="."}else{if(b==="TypesetMath"){if(!this.typesetting){this.typesetting=this.localize("Typesetting")+" "}a=this.typesetting;this.typesetting+="."}}}}return a},Set:function(c,e,b){if(e==null){e=this.log.length;this.log[e]={}}var d="";if(c instanceof Array){d=c[0];if(d instanceof Array){d=d[1]}try{c=MathJax.Localization._.apply(MathJax.Localization,c)}catch(a){if(!a.restart){throw a}if(!a.restart.called){if(this.log[e].restarted==null){this.log[e].restarted=0}this.log[e].restarted++;delete this.log[e].cleared;MathJax.Callback.After(["Set",this,c,e,b],a.restart);return e}}}if(this.timer){clearTimeout(this.timer);delete this.timer}this.log[e].text=c;this.log[e].filteredText=c=this.filterText(c,e,d);if(typeof this.log[e].next==="undefined"){this.log[e].next=this.current;if(this.current!=null){this.log[this.current].prev=e}this.current=e}if(this.current===e&&MathJax.Hub.config.messageStyle!=="none"){if(this.Init()){if(this.textNodeBug){this.div.innerHTML=c}else{this.text.nodeValue=c}this.div.style.display="";if(this.status){window.status="";delete this.status}}else{window.status=c;this.status=true}}if(this.log[e].restarted){if(this.log[e].cleared){b=0}if(--this.log[e].restarted===0){delete this.log[e].cleared}}if(b){setTimeout(MathJax.Callback(["Clear",this,e]),b)}else{if(b==0){this.Clear(e,0)}}return e},Clear:function(b,a){if(this.log[b].prev!=null){this.log[this.log[b].prev].next=this.log[b].next}if(this.log[b].next!=null){this.log[this.log[b].next].prev=this.log[b].prev}if(this.current===b){this.current=this.log[b].next;if(this.text){if(this.div.parentNode==null){this.Init()}if(this.current==null){if(this.timer){clearTimeout(this.timer);delete this.timer}if(a==null){a=600}if(a===0){this.Remove()}else{this.timer=setTimeout(MathJax.Callback(["Remove",this]),a)}}else{if(MathJax.Hub.config.messageStyle!=="none"){if(this.textNodeBug){this.div.innerHTML=this.log[this.current].filteredText}else{this.text.nodeValue=this.log[this.current].filteredText}}}if(this.status){window.status="";delete this.status}}else{if(this.status){window.status=this.current==null?"":this.log[this.current].text}}}delete this.log[b].next;delete this.log[b].prev;delete this.log[b].filteredText;if(this.log[b].restarted){this.log[b].cleared=true}},Remove:function(){this.text.nodeValue="";this.div.style.display="none"},File:function(a){return this.Set(["LoadFile","Loading %1",a],null,null)},Log:function(){var b=[];for(var c=1,a=this.log.length;c<a;c++){b[c]=this.log[c].text}return b.join("\n")}};MathJax.Hub={config:{root:"",config:[],styleSheets:[],styles:{".MathJax_Preview":{color:"#888"}},jax:[],extensions:[],preJax:null,postJax:null,displayAlign:"center",displayIndent:"0",preRemoveClass:"MathJax_Preview",showProcessingMessages:true,messageStyle:"normal",delayStartupUntil:"none",skipStartupTypeset:false,elements:[],positionToHash:true,showMathMenu:true,showMathMenuMSIE:true,menuSettings:{zoom:"None",CTRL:false,ALT:false,CMD:false,Shift:false,discoverable:false,zscale:"200%",renderer:"",font:"Auto",context:"MathJax",locale:"en",mpContext:false,mpMouse:false,texHints:true,semantics:false},errorSettings:{message:["[",["MathProcessingError","Math Processing Error"],"]"],style:{color:"#CC0000","font-style":"italic"}}},preProcessors:MathJax.Callback.Hooks(true),inputJax:{},outputJax:{order:{}},processUpdateTime:250,processUpdateDelay:10,signal:MathJax.Callback.Signal("Hub"),Config:function(a){this.Insert(this.config,a);if(this.config.Augment){this.Augment(this.config.Augment)}},CombineConfig:function(c,f){var b=this.config,g,e;c=c.split(/\./);for(var d=0,a=c.length;d<a;d++){g=c[d];if(!b[g]){b[g]={}}e=b;b=b[g]}e[g]=b=this.Insert(f,b);return b},Register:{PreProcessor:function(){MathJax.Hub.preProcessors.Add.apply(MathJax.Hub.preProcessors,arguments)},MessageHook:function(){return MathJax.Hub.signal.MessageHook.apply(MathJax.Hub.signal,arguments)},StartupHook:function(){return MathJax.Hub.Startup.signal.MessageHook.apply(MathJax.Hub.Startup.signal,arguments)},LoadHook:function(){return MathJax.Ajax.LoadHook.apply(MathJax.Ajax,arguments)}},getAllJax:function(e){var c=[],b=this.elementScripts(e);for(var d=0,a=b.length;d<a;d++){if(b[d].MathJax&&b[d].MathJax.elementJax){c.push(b[d].MathJax.elementJax)}}return c},getJaxByType:function(f,e){var c=[],b=this.elementScripts(e);for(var d=0,a=b.length;d<a;d++){if(b[d].MathJax&&b[d].MathJax.elementJax&&b[d].MathJax.elementJax.mimeType===f){c.push(b[d].MathJax.elementJax)}}return c},getJaxByInputType:function(f,e){var c=[],b=this.elementScripts(e);for(var d=0,a=b.length;d<a;d++){if(b[d].MathJax&&b[d].MathJax.elementJax&&b[d].type&&b[d].type.replace(/ *;(.|\s)*/,"")===f){c.push(b[d].MathJax.elementJax)}}return c},getJaxFor:function(a){if(typeof a==="string"){a=document.getElementById(a)}if(a&&a.MathJax){return a.MathJax.elementJax}if(a&&a.isMathJax){while(a&&!a.jaxID){a=a.parentNode}if(a){return MathJax.OutputJax[a.jaxID].getJaxFromMath(a)}}return null},isJax:function(a){if(typeof a==="string"){a=document.getElementById(a)}if(a&&a.isMathJax){return 1}if(a&&a.tagName!=null&&a.tagName.toLowerCase()==="script"){if(a.MathJax){return a.MathJax.state===MathJax.ElementJax.STATE.PROCESSED?1:-1}if(a.type&&this.inputJax[a.type.replace(/ *;(.|\s)*/,"")]){return-1
}}return 0},setRenderer:function(d,c){if(!d){return}if(!MathJax.OutputJax[d]){this.config.menuSettings.renderer="";var b="[MathJax]/jax/output/"+d+"/config.js";return MathJax.Ajax.Require(b,["setRenderer",this,d,c])}else{this.config.menuSettings.renderer=d;if(c==null){c="jax/mml"}var a=this.outputJax;if(a[c]&&a[c].length){if(d!==a[c][0].id){a[c].unshift(MathJax.OutputJax[d]);return this.signal.Post(["Renderer Selected",d])}}return null}},Queue:function(){return this.queue.Push.apply(this.queue,arguments)},Typeset:function(e,f){if(!MathJax.isReady){return null}var c=this.elementCallback(e,f);var b=MathJax.Callback.Queue();for(var d=0,a=c.elements.length;d<a;d++){if(c.elements[d]){b.Push(["PreProcess",this,c.elements[d]],["Process",this,c.elements[d]])}}return b.Push(c.callback)},PreProcess:function(e,f){var c=this.elementCallback(e,f);var b=MathJax.Callback.Queue();for(var d=0,a=c.elements.length;d<a;d++){if(c.elements[d]){b.Push(["Post",this.signal,["Begin PreProcess",c.elements[d]]],arguments.callee.disabled?{}:["Execute",this.preProcessors,c.elements[d]],["Post",this.signal,["End PreProcess",c.elements[d]]])}}return b.Push(c.callback)},Process:function(a,b){return this.takeAction("Process",a,b)},Update:function(a,b){return this.takeAction("Update",a,b)},Reprocess:function(a,b){return this.takeAction("Reprocess",a,b)},Rerender:function(a,b){return this.takeAction("Rerender",a,b)},takeAction:function(g,e,h){var c=this.elementCallback(e,h);var b=MathJax.Callback.Queue(["Clear",this.signal]);for(var d=0,a=c.elements.length;d<a;d++){if(c.elements[d]){var f={scripts:[],start:(new Date).getTime(),i:0,j:0,jax:{},jaxIDs:[]};b.Push(["Post",this.signal,["Begin "+g,c.elements[d]]],["Post",this.signal,["Begin Math",c.elements[d],g]],["prepareScripts",this,g,c.elements[d],f],["Post",this.signal,["Begin Math Input",c.elements[d],g]],["processInput",this,f],["Post",this.signal,["End Math Input",c.elements[d],g]],["prepareOutput",this,f,"preProcess"],["Post",this.signal,["Begin Math Output",c.elements[d],g]],["processOutput",this,f],["Post",this.signal,["End Math Output",c.elements[d],g]],["prepareOutput",this,f,"postProcess"],["Post",this.signal,["End Math",c.elements[d],g]],["Post",this.signal,["End "+g,c.elements[d]]])}}return b.Push(c.callback)},scriptAction:{Process:function(a){},Update:function(b){var a=b.MathJax.elementJax;if(a&&a.needsUpdate()){a.Remove(true);b.MathJax.state=a.STATE.UPDATE}else{b.MathJax.state=a.STATE.PROCESSED}},Reprocess:function(b){var a=b.MathJax.elementJax;if(a){a.Remove(true);b.MathJax.state=a.STATE.UPDATE}},Rerender:function(b){var a=b.MathJax.elementJax;if(a){a.Remove(true);b.MathJax.state=a.STATE.OUTPUT}}},prepareScripts:function(h,e,g){if(arguments.callee.disabled){return}var b=this.elementScripts(e);var f=MathJax.ElementJax.STATE;for(var d=0,a=b.length;d<a;d++){var c=b[d];if(c.type&&this.inputJax[c.type.replace(/ *;(.|\n)*/,"")]){if(c.MathJax){if(c.MathJax.elementJax&&c.MathJax.elementJax.hover){MathJax.Extension.MathEvents.Hover.ClearHover(c.MathJax.elementJax)}if(c.MathJax.state!==f.PENDING){this.scriptAction[h](c)}}if(!c.MathJax){c.MathJax={state:f.PENDING}}if(c.MathJax.state!==f.PROCESSED){g.scripts.push(c)}}}},checkScriptSiblings:function(a){if(a.MathJax.checked){return}var b=this.config,f=a.previousSibling;if(f&&f.nodeName==="#text"){var d,e,c=a.nextSibling;if(c&&c.nodeName!=="#text"){c=null}if(b.preJax){if(typeof b.preJax==="string"){b.preJax=new RegExp(b.preJax+"$")}d=f.nodeValue.match(b.preJax)}if(b.postJax&&c){if(typeof b.postJax==="string"){b.postJax=new RegExp("^"+b.postJax)}e=c.nodeValue.match(b.postJax)}if(d&&(!b.postJax||e)){f.nodeValue=f.nodeValue.replace(b.preJax,d.length>1?d[1]:"");f=null}if(e&&(!b.preJax||d)){c.nodeValue=c.nodeValue.replace(b.postJax,e.length>1?e[1]:"")}if(f&&!f.nodeValue.match(/\S/)){f=f.previousSibling}}if(b.preRemoveClass&&f&&f.className===b.preRemoveClass){a.MathJax.preview=f}a.MathJax.checked=1},processInput:function(a){var b,i=MathJax.ElementJax.STATE;var h,e,d=a.scripts.length;try{while(a.i<d){h=a.scripts[a.i];if(!h){a.i++;continue}e=h.previousSibling;if(e&&e.className==="MathJax_Error"){e.parentNode.removeChild(e)}if(!h.MathJax||h.MathJax.state===i.PROCESSED){a.i++;continue}if(!h.MathJax.elementJax||h.MathJax.state===i.UPDATE){this.checkScriptSiblings(h);var g=h.type.replace(/ *;(.|\s)*/,"");b=this.inputJax[g].Process(h,a);if(typeof b==="function"){if(b.called){continue}this.RestartAfter(b)}b.Attach(h,this.inputJax[g].id);this.saveScript(b,a,h,i)}else{if(h.MathJax.state===i.OUTPUT){this.saveScript(h.MathJax.elementJax,a,h,i)}}a.i++;var c=(new Date).getTime();if(c-a.start>this.processUpdateTime&&a.i<a.scripts.length){a.start=c;this.RestartAfter(MathJax.Callback.Delay(1))}}}catch(f){return this.processError(f,a,"Input")}if(a.scripts.length&&this.config.showProcessingMessages){MathJax.Message.Set(["ProcessMath","Processing math: %1%%",100],0)}a.start=(new Date).getTime();a.i=a.j=0;return null},saveScript:function(a,d,b,c){if(!this.outputJax[a.mimeType]){b.MathJax.state=c.UPDATE;throw Error("No output jax registered for "+a.mimeType)}a.outputJax=this.outputJax[a.mimeType][0].id;if(!d.jax[a.outputJax]){if(d.jaxIDs.length===0){d.jax[a.outputJax]=d.scripts}else{if(d.jaxIDs.length===1){d.jax[d.jaxIDs[0]]=d.scripts.slice(0,d.i)}d.jax[a.outputJax]=[]}d.jaxIDs.push(a.outputJax)}if(d.jaxIDs.length>1){d.jax[a.outputJax].push(b)}b.MathJax.state=c.OUTPUT},prepareOutput:function(c,f){while(c.j<c.jaxIDs.length){var e=c.jaxIDs[c.j],d=MathJax.OutputJax[e];if(d[f]){try{var a=d[f](c);if(typeof a==="function"){if(a.called){continue}this.RestartAfter(a)}}catch(b){if(!b.restart){MathJax.Message.Set(["PrepError","Error preparing %1 output (%2)",e,f],null,600);MathJax.Hub.lastPrepError=b;c.j++}return MathJax.Callback.After(["prepareOutput",this,c,f],b.restart)}}c.j++}return null},processOutput:function(h){var b,g=MathJax.ElementJax.STATE,d,a=h.scripts.length;try{while(h.i<a){d=h.scripts[h.i];if(!d||!d.MathJax||d.MathJax.error){h.i++;continue}var c=d.MathJax.elementJax;if(!c){h.i++;continue}b=MathJax.OutputJax[c.outputJax].Process(d,h);d.MathJax.state=g.PROCESSED;h.i++;if(d.MathJax.preview){d.MathJax.preview.innerHTML=""}this.signal.Post(["New Math",c.inputID]);var e=(new Date).getTime();if(e-h.start>this.processUpdateTime&&h.i<h.scripts.length){h.start=e;this.RestartAfter(MathJax.Callback.Delay(this.processUpdateDelay))}}}catch(f){return this.processError(f,h,"Output")}if(h.scripts.length&&this.config.showProcessingMessages){MathJax.Message.Set(["TypesetMath","Typesetting math: %1%%",100],0);MathJax.Message.Clear(0)}h.i=h.j=0;return null},processMessage:function(d,b){var a=Math.floor(d.i/d.scripts.length*100);var c=b==="Output"?["TypesetMath","Typesetting math: %1%%"]:["ProcessMath","Processing math: %1%%"];if(this.config.showProcessingMessages){MathJax.Message.Set(c.concat(a),0)}},processError:function(b,c,a){if(!b.restart){if(!this.config.errorSettings.message){throw b}this.formatError(c.scripts[c.i],b);c.i++}this.processMessage(c,a);return MathJax.Callback.After(["process"+a,this,c],b.restart)},formatError:function(b,e){var d="Error: "+e.message+"\n";if(e.sourceURL){d+="\nfile: "+e.sourceURL}if(e.line){d+="\nline: "+e.line}b.MathJax.error=MathJax.OutputJax.Error.Jax(d,b);var f=this.config.errorSettings;var a=MathJax.Localization._(f.messageId,f.message);var c=MathJax.HTML.Element("span",{className:"MathJax_Error",jaxID:"Error",isMathJax:true},a);if(MathJax.Extension.MathEvents){c.oncontextmenu=MathJax.Extension.MathEvents.Event.Menu;c.onmousedown=MathJax.Extension.MathEvents.Event.Mousedown}else{MathJax.Ajax.Require("[MathJax]/extensions/MathEvents.js",function(){c.oncontextmenu=MathJax.Extension.MathEvents.Event.Menu;c.onmousedown=MathJax.Extension.MathEvents.Event.Mousedown})}b.parentNode.insertBefore(c,b);if(b.MathJax.preview){b.MathJax.preview.innerHTML=""}this.lastError=e;this.signal.Post(["Math Processing Error",b,e])},RestartAfter:function(a){throw this.Insert(Error("restart"),{restart:MathJax.Callback(a)})},elementCallback:function(c,f){if(f==null&&(c instanceof Array||typeof c==="function")){try{MathJax.Callback(c);f=c;c=null}catch(d){}}if(c==null){c=this.config.elements||[]}if(!(c instanceof Array)){c=[c]}c=[].concat(c);for(var b=0,a=c.length;b<a;b++){if(typeof c[b]==="string"){c[b]=document.getElementById(c[b])}}if(!document.body){document.body=document.getElementsByTagName("body")[0]}if(c.length==0){c.push(document.body)}if(!f){f={}}return{elements:c,callback:f}},elementScripts:function(d){if(d instanceof Array){var b=[];for(var c=0,a=d.length;c<a;c++){b.push.apply(b,this.elementScripts(d[c]))}return b}if(typeof d==="string"){d=document.getElementById(d)}if(!document.body){document.body=document.getElementsByTagName("body")[0]}if(d==null){d=document.body}if(d.tagName!=null&&d.tagName.toLowerCase()==="script"){return[d]}return d.getElementsByTagName("script")},Insert:function(c,a){for(var b in a){if(a.hasOwnProperty(b)){if(typeof a[b]==="object"&&!(a[b]instanceof Array)&&(typeof c[b]==="object"||typeof c[b]==="function")){this.Insert(c[b],a[b])}else{c[b]=a[b]}}}return c},SplitList:"trim"in String.prototype?function(a){return a.trim().split(/\s+/)}:function(a){return a.replace(/^\s+/,"").replace(/\s+$/,"").split(/\s+/)}};MathJax.Hub.Insert(MathJax.Hub.config.styles,MathJax.Message.styles);MathJax.Hub.Insert(MathJax.Hub.config.styles,{".MathJax_Error":MathJax.Hub.config.errorSettings.style});MathJax.Extension={};MathJax.Hub.Configured=MathJax.Callback({});MathJax.Hub.Startup={script:"",queue:MathJax.Callback.Queue(),signal:MathJax.Callback.Signal("Startup"),params:{},Config:function(){this.queue.Push(["Post",this.signal,"Begin Config"]);if(this.params.locale){MathJax.Localization.resetLocale(this.params.locale);MathJax.Hub.config.menuSettings.locale=this.params.locale}if(this.params.config){var c=this.params.config.split(/,/);for(var b=0,a=c.length;b<a;b++){if(!c[b].match(/\.js$/)){c[b]+=".js"}this.queue.Push(["Require",MathJax.Ajax,this.URL("config",c[b])])}}this.queue.Push(["Config",MathJax.Hub,MathJax.AuthorConfig]);if(this.script.match(/\S/)){this.queue.Push(this.script+";\n1;")}this.queue.Push(["ConfigDelay",this],["ConfigBlocks",this],[function(d){return d.loadArray(MathJax.Hub.config.config,"config",null,true)},this],["Post",this.signal,"End Config"])},ConfigDelay:function(){var a=this.params.delayStartupUntil||MathJax.Hub.config.delayStartupUntil;if(a==="onload"){return this.onload}if(a==="configured"){return MathJax.Hub.Configured}return a},ConfigBlocks:function(){var c=document.getElementsByTagName("script");var f=null,b=MathJax.Callback.Queue();for(var d=0,a=c.length;d<a;d++){var e=String(c[d].type).replace(/ /g,"");if(e.match(/^text\/x-mathjax-config(;.*)?$/)&&!e.match(/;executed=true/)){c[d].type+=";executed=true";f=b.Push(c[d].innerHTML+";\n1;")}}return f},Cookie:function(){return this.queue.Push(["Post",this.signal,"Begin Cookie"],["Get",MathJax.HTML.Cookie,"menu",MathJax.Hub.config.menuSettings],[function(d){if(d.menuSettings.locale){MathJax.Localization.resetLocale(d.menuSettings.locale)}var f=d.menuSettings.renderer,b=d.jax;if(f){var c="output/"+f;b.sort();for(var e=0,a=b.length;e<a;e++){if(b[e].substr(0,7)==="output/"){break}}if(e==a-1){b.pop()}else{while(e<a){if(b[e]===c){b.splice(e,1);break}e++}}b.unshift(c)}},MathJax.Hub.config],["Post",this.signal,"End Cookie"])},Styles:function(){return this.queue.Push(["Post",this.signal,"Begin Styles"],["loadArray",this,MathJax.Hub.config.styleSheets,"config"],["Styles",MathJax.Ajax,MathJax.Hub.config.styles],["Post",this.signal,"End Styles"])},Jax:function(){var f=MathJax.Hub.config,c=MathJax.Hub.outputJax;for(var g=0,b=f.jax.length,d=0;g<b;g++){var e=f.jax[g].substr(7);if(f.jax[g].substr(0,7)==="output/"&&c.order[e]==null){c.order[e]=d;d++}}var a=MathJax.Callback.Queue();return a.Push(["Post",this.signal,"Begin Jax"],["loadArray",this,f.jax,"jax","config.js"],["Post",this.signal,"End Jax"])},Extensions:function(){var a=MathJax.Callback.Queue();return a.Push(["Post",this.signal,"Begin Extensions"],["loadArray",this,MathJax.Hub.config.extensions,"extensions"],["Post",this.signal,"End Extensions"])},Message:function(){MathJax.Message.Init(true)},Menu:function(){var b=MathJax.Hub.config.menuSettings,a=MathJax.Hub.outputJax,d;for(var c in a){if(a.hasOwnProperty(c)){if(a[c].length){d=a[c];break}}}if(d&&d.length){if(b.renderer&&b.renderer!==d[0].id){d.unshift(MathJax.OutputJax[b.renderer])}b.renderer=d[0].id}},Hash:function(){if(MathJax.Hub.config.positionToHash&&document.location.hash&&document.body&&document.body.scrollIntoView){var d=document.location.hash.substr(1);var f=document.getElementById(d);if(!f){var c=document.getElementsByTagName("a");for(var e=0,b=c.length;e<b;e++){if(c[e].name===d){f=c[e];break}}}if(f){while(!f.scrollIntoView){f=f.parentNode}f=this.HashCheck(f);if(f&&f.scrollIntoView){setTimeout(function(){f.scrollIntoView(true)},1)}}}},HashCheck:function(b){if(b.isMathJax){var a=MathJax.Hub.getJaxFor(b);if(a&&MathJax.OutputJax[a.outputJax].hashCheck){b=MathJax.OutputJax[a.outputJax].hashCheck(b)}}return b},MenuZoom:function(){if(MathJax.Hub.config.showMathMenu){if(!MathJax.Extension.MathMenu){setTimeout(function(){MathJax.Callback.Queue(["Require",MathJax.Ajax,"[MathJax]/extensions/MathMenu.js",{}],["loadDomain",MathJax.Localization,"MathMenu"])},1e3)}else{setTimeout(MathJax.Callback(["loadDomain",MathJax.Localization,"MathMenu"]),1e3)}if(!MathJax.Extension.MathZoom){setTimeout(MathJax.Callback(["Require",MathJax.Ajax,"[MathJax]/extensions/MathZoom.js",{}]),2e3)}}},onLoad:function(){var a=this.onload=MathJax.Callback(function(){MathJax.Hub.Startup.signal.Post("onLoad")});if(document.body&&document.readyState){if(MathJax.Hub.Browser.isMSIE){if(document.readyState==="complete"){return[a]}}else{if(document.readyState!=="loading"){return[a]}}}if(window.addEventListener){window.addEventListener("load",a,false);if(!this.params.noDOMContentEvent){window.addEventListener("DOMContentLoaded",a,false)}}else{if(window.attachEvent){window.attachEvent("onload",a)}else{window.onload=a}}return a},Typeset:function(a,b){if(MathJax.Hub.config.skipStartupTypeset){return function(){}}return this.queue.Push(["Post",this.signal,"Begin Typeset"],["Typeset",MathJax.Hub,a,b],["Post",this.signal,"End Typeset"])},URL:function(b,a){if(!a.match(/^([a-z]+:\/\/|\[|\/)/)){a="[MathJax]/"+b+"/"+a}return a},loadArray:function(b,f,c,a){if(b){if(!(b instanceof Array)){b=[b]}if(b.length){var h=MathJax.Callback.Queue(),j={},e;for(var g=0,d=b.length;g<d;g++){e=this.URL(f,b[g]);if(c){e+="/"+c}if(a){h.Push(["Require",MathJax.Ajax,e,j])}else{h.Push(MathJax.Ajax.Require(e,j))}}return h.Push({})}}return null}};(function(d){var b=window[d],e="["+d+"]";var c=b.Hub,a=b.Ajax,f=b.Callback;var g=MathJax.Object.Subclass({JAXFILE:"jax.js",require:null,config:{},Init:function(i,h){if(arguments.length===0){return this}return this.constructor.Subclass(i,h)()},Augment:function(k,j){var i=this.constructor,h={};if(k!=null){for(var l in k){if(k.hasOwnProperty(l)){if(typeof k[l]==="function"){i.protoFunction(l,k[l])}else{h[l]=k[l]}}}if(k.toString!==i.prototype.toString&&k.toString!=={}.toString){i.protoFunction("toString",k.toString)}}c.Insert(i.prototype,h);i.Augment(null,j);return this},Translate:function(h,i){throw Error(this.directory+"/"+this.JAXFILE+" failed to define the Translate() method")},Register:function(h){},Config:function(){this.config=c.CombineConfig(this.id,this.config);if(this.config.Augment){this.Augment(this.config.Augment)}},Startup:function(){},loadComplete:function(i){if(i==="config.js"){return a.loadComplete(this.directory+"/"+i)}else{var h=f.Queue();h.Push(c.Register.StartupHook("End Config",{}),["Post",c.Startup.signal,this.id+" Jax Config"],["Config",this],["Post",c.Startup.signal,this.id+" Jax Require"],[function(j){return MathJax.Hub.Startup.loadArray(j.require,this.directory)},this],[function(j,k){return MathJax.Hub.Startup.loadArray(j.extensions,"extensions/"+k)},this.config||{},this.id],["Post",c.Startup.signal,this.id+" Jax Startup"],["Startup",this],["Post",c.Startup.signal,this.id+" Jax Ready"]);if(this.copyTranslate){h.Push([function(j){j.preProcess=j.preTranslate;j.Process=j.Translate;j.postProcess=j.postTranslate},this.constructor.prototype])}return h.Push(["loadComplete",a,this.directory+"/"+i])}}},{id:"Jax",version:"2.4.0",directory:e+"/jax",extensionDir:e+"/extensions"});b.InputJax=g.Subclass({elementJax:"mml",sourceMenuTitle:["Original","Original Form"],copyTranslate:true,Process:function(l,q){var j=f.Queue(),o;var k=this.elementJax;if(!(k instanceof Array)){k=[k]}for(var n=0,h=k.length;n<h;n++){o=b.ElementJax.directory+"/"+k[n]+"/"+this.JAXFILE;if(!this.require){this.require=[]}else{if(!(this.require instanceof Array)){this.require=[this.require]}}this.require.push(o);j.Push(a.Require(o))}o=this.directory+"/"+this.JAXFILE;var p=j.Push(a.Require(o));if(!p.called){this.constructor.prototype.Process=function(){if(!p.called){return p}throw Error(o+" failed to load properly")}}k=c.outputJax["jax/"+k[0]];if(k){j.Push(a.Require(k[0].directory+"/"+this.JAXFILE))}return j.Push({})},needsUpdate:function(h){var i=h.SourceElement();return h.originalText!==b.HTML.getScript(i)},Register:function(h){if(!c.inputJax){c.inputJax={}}c.inputJax[h]=this}},{id:"InputJax",version:"2.4.0",directory:g.directory+"/input",extensionDir:g.extensionDir});b.OutputJax=g.Subclass({copyTranslate:true,preProcess:function(j){var i,h=this.directory+"/"+this.JAXFILE;this.constructor.prototype.preProcess=function(k){if(!i.called){return i}throw Error(h+" failed to load properly")};i=a.Require(h);return i},Register:function(i){var h=c.outputJax;if(!h[i]){h[i]=[]}if(h[i].length&&(this.id===c.config.menuSettings.renderer||(h.order[this.id]||0)<(h.order[h[i][0].id]||0))){h[i].unshift(this)}else{h[i].push(this)}if(!this.require){this.require=[]}else{if(!(this.require instanceof Array)){this.require=[this.require]}}this.require.push(b.ElementJax.directory+"/"+i.split(/\//)[1]+"/"+this.JAXFILE)},Remove:function(h){}},{id:"OutputJax",version:"2.4.0",directory:g.directory+"/output",extensionDir:g.extensionDir,fontDir:e+(b.isPacked?"":"/..")+"/fonts",imageDir:e+(b.isPacked?"":"/..")+"/images"});b.ElementJax=g.Subclass({Init:function(i,h){return this.constructor.Subclass(i,h)},inputJax:null,outputJax:null,inputID:null,originalText:"",mimeType:"",sourceMenuTitle:["MathMLcode","MathML Code"],Text:function(i,j){var h=this.SourceElement();b.HTML.setScript(h,i);h.MathJax.state=this.STATE.UPDATE;return c.Update(h,j)},Reprocess:function(i){var h=this.SourceElement();h.MathJax.state=this.STATE.UPDATE;return c.Reprocess(h,i)},Update:function(h){return this.Rerender(h)},Rerender:function(i){var h=this.SourceElement();h.MathJax.state=this.STATE.OUTPUT;return c.Process(h,i)},Remove:function(h){if(this.hover){this.hover.clear(this)}b.OutputJax[this.outputJax].Remove(this);if(!h){c.signal.Post(["Remove Math",this.inputID]);this.Detach()}},needsUpdate:function(){return b.InputJax[this.inputJax].needsUpdate(this)},SourceElement:function(){return document.getElementById(this.inputID)},Attach:function(i,j){var h=i.MathJax.elementJax;if(i.MathJax.state===this.STATE.UPDATE){h.Clone(this)}else{h=i.MathJax.elementJax=this;if(i.id){this.inputID=i.id}else{i.id=this.inputID=b.ElementJax.GetID();this.newID=1}}h.originalText=b.HTML.getScript(i);h.inputJax=j;if(h.root){h.root.inputID=h.inputID}return h},Detach:function(){var h=this.SourceElement();if(!h){return}try{delete h.MathJax}catch(i){h.MathJax=null}if(this.newID){h.id=""}},Clone:function(h){var i;for(i in this){if(!this.hasOwnProperty(i)){continue}if(typeof h[i]==="undefined"&&i!=="newID"){delete this[i]}}for(i in h){if(!h.hasOwnProperty(i)){continue}if(typeof this[i]==="undefined"||this[i]!==h[i]&&i!=="inputID"){this[i]=h[i]}}}},{id:"ElementJax",version:"2.4.0",directory:g.directory+"/element",extensionDir:g.extensionDir,ID:0,STATE:{PENDING:1,PROCESSED:2,UPDATE:3,OUTPUT:4},GetID:function(){this.ID++;return"MathJax-Element-"+this.ID},Subclass:function(){var h=g.Subclass.apply(this,arguments);h.loadComplete=this.prototype.loadComplete;return h}});b.ElementJax.prototype.STATE=b.ElementJax.STATE;b.OutputJax.Error={id:"Error",version:"2.4.0",config:{},ContextMenu:function(){return b.Extension.MathEvents.Event.ContextMenu.apply(b.Extension.MathEvents.Event,arguments)},Mousedown:function(){return b.Extension.MathEvents.Event.AltContextMenu.apply(b.Extension.MathEvents.Event,arguments)},getJaxFromMath:function(h){return(h.nextSibling.MathJax||{}).error},Jax:function(j,i){var h=MathJax.Hub.inputJax[i.type.replace(/ *;(.|\s)*/,"")];return{inputJax:(h||{id:"Error"}).id,outputJax:"Error",sourceMenuTitle:["ErrorMessage","Error Message"],sourceMenuFormat:"Error",originalText:MathJax.HTML.getScript(i),errorText:j}}};b.InputJax.Error={id:"Error",version:"2.4.0",config:{},sourceMenuTitle:["Original","Original Form"]}})("MathJax");(function(n){var g=window[n];if(!g){g=window[n]={}}var c=g.Hub;var r=c.Startup;var v=c.config;var f=document.getElementsByTagName("head")[0];if(!f){f=document.childNodes[0]}var b=(document.documentElement||document).getElementsByTagName("script");var e=new RegExp("(^|/)"+n+"\\.js(\\?.*)?$");for(var p=b.length-1;p>=0;p--){if((b[p].src||"").match(e)){r.script=b[p].innerHTML;if(RegExp.$2){var s=RegExp.$2.substr(1).split(/\&/);for(var o=0,k=s.length;o<k;o++){var l=s[o].match(/(.*)=(.*)/);if(l){r.params[unescape(l[1])]=unescape(l[2])}}}v.root=b[p].src.replace(/(^|\/)[^\/]*(\?.*)?$/,"").replace(/^(https?:)\/\/[0-9a-f]+(-[0-9a-f]+)?.ssl.cf1.rackcdn.com\//,"$1//cdn.mathjax.org/");g.Ajax.config.root=v.root;break}}var h=navigator.userAgent;var a={isMac:navigator.platform.substr(0,3)==="Mac",isPC:navigator.platform.substr(0,3)==="Win",isMSIE:"ActiveXObject"in window&&"clipboardData"in window,isFirefox:h.match(/Gecko\//)&&!h.match(/like Gecko/),isSafari:h.match(/ (Apple)?WebKit\//)!=null&&(!window.chrome||window.chrome.loadTimes==null),isChrome:window.chrome!=null&&window.chrome.loadTimes!=null,isOpera:window.opera!=null&&window.opera.version!=null,isKonqueror:"konqueror"in window&&navigator.vendor=="KDE",versionAtLeast:function(x){var w=this.version.split(".");x=new String(x).split(".");for(var y=0,j=x.length;y<j;y++){if(w[y]!=x[y]){return parseInt(w[y]||"0")>=parseInt(x[y])}}return true},Select:function(j){var i=j[c.Browser];if(i){return i(c.Browser)}return null}};var d=h.replace(/^Mozilla\/(\d+\.)+\d+ /,"").replace(/[a-z][-a-z0-9._: ]+\/\d+[^ ]*-[^ ]*\.([a-z][a-z])?\d+ /i,"").replace(/Gentoo |Ubuntu\/(\d+\.)*\d+ (\([^)]*\) )?/,"");c.Browser=c.Insert(c.Insert(new String("Unknown"),{version:"0.0"}),a);for(var u in a){if(a.hasOwnProperty(u)){if(a[u]&&u.substr(0,2)==="is"){u=u.slice(2);if(u==="Mac"||u==="PC"){continue}c.Browser=c.Insert(new String(u),a);var q=new RegExp(".*(Version/| Trident/.*; rv:)((?:\\d+\\.)+\\d+)|.*("+u+")"+(u=="MSIE"?" ":"/")+"((?:\\d+\\.)*\\d+)|(?:^|\\(| )([a-z][-a-z0-9._: ]+|(?:Apple)?WebKit)/((?:\\d+\\.)+\\d+)");var t=q.exec(d)||["","","","unknown","0.0"];c.Browser.name=t[1]!=""?u:t[3]||t[5];c.Browser.version=t[2]||t[4]||t[6];break}}}c.Browser.Select({Safari:function(j){var i=parseInt(String(j.version).split(".")[0]);if(i>85){j.webkit=j.version}if(i>=534){j.version="5.1"}else{if(i>=533){j.version="5.0"}else{if(i>=526){j.version="4.0"}else{if(i>=525){j.version="3.1"}else{if(i>500){j.version="3.0"}else{if(i>400){j.version="2.0"}else{if(i>85){j.version="1.0"}}}}}}}j.isMobile=navigator.appVersion.match(/Mobile/i)!=null;j.noContextMenu=j.isMobile},Firefox:function(j){if((j.version==="0.0"||h.match(/Firefox/)==null)&&navigator.product==="Gecko"){var m=h.match(/[\/ ]rv:(\d+\.\d.*?)[\) ]/);if(m){j.version=m[1]}else{var i=(navigator.buildID||navigator.productSub||"0").substr(0,8);if(i>="20111220"){j.version="9.0"}else{if(i>="20111120"){j.version="8.0"}else{if(i>="20110927"){j.version="7.0"}else{if(i>="20110816"){j.version="6.0"}else{if(i>="20110621"){j.version="5.0"}else{if(i>="20110320"){j.version="4.0"}else{if(i>="20100121"){j.version="3.6"}else{if(i>="20090630"){j.version="3.5"}else{if(i>="20080617"){j.version="3.0"}else{if(i>="20061024"){j.version="2.0"}}}}}}}}}}}}j.isMobile=navigator.appVersion.match(/Android/i)!=null||h.match(/ Fennec\//)!=null||h.match(/Mobile/)!=null},Opera:function(i){i.version=opera.version()},MSIE:function(j){j.isIE9=!!(document.documentMode&&(window.performance||window.msPerformance));MathJax.HTML.setScriptBug=!j.isIE9||document.documentMode<9;var w=false;try{new ActiveXObject("MathPlayer.Factory.1");j.hasMathPlayer=w=true}catch(m){}try{if(w&&!r.params.NoMathPlayer){var i=document.createElement("object");i.id="mathplayer";i.classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987";document.getElementsByTagName("head")[0].appendChild(i);document.namespaces.add("m","http://www.w3.org/1998/Math/MathML");j.mpNamespace=true;if(document.readyState&&(document.readyState==="loading"||document.readyState==="interactive")){document.write('<?import namespace="m" implementation="#MathPlayer">');j.mpImported=true}}else{document.namespaces.add("mjx_IE_fix","http://www.w3.org/1999/xlink")}}catch(m){}}});c.Browser.Select(MathJax.Message.browsers);
/*
 *  /MathJax/config/MathML-SVG-TeX--complete.js
 *
 *  Copyright (c) 2010-2013 The MathJax Consortium
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 *
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */
MathJax.Ajax.Preloading("[MathJax]/jax/input/MathML/config.js","[MathJax]/jax/output/SVG/config.js","[MathJax]/extensions/mml2jax.js","[MathJax]/extensions/MathEvents.js","[MathJax]/extensions/MathZoom.js","[MathJax]/extensions/MathMenu.js","[MathJax]/jax/element/mml/jax.js","[MathJax]/extensions/toMathML.js","[MathJax]/jax/input/MathML/jax.js","[MathJax]/jax/output/SVG/jax.js","[MathJax]/jax/output/SVG/fonts/TeX/fontdata.js","[MathJax]/jax/output/SVG/fonts/TeX/fontdata-extra.js","[MathJax]/jax/output/SVG/autoload/mtable.js","[MathJax]/jax/output/SVG/autoload/mglyph.js","[MathJax]/jax/output/SVG/autoload/mmultiscripts.js","[MathJax]/jax/output/SVG/autoload/annotation-xml.js","[MathJax]/jax/output/SVG/autoload/maction.js","[MathJax]/jax/output/SVG/autoload/multiline.js","[MathJax]/jax/output/SVG/autoload/menclose.js","[MathJax]/jax/output/SVG/autoload/ms.js","[MathJax]/extensions/MathML/content-mathml.js","[MathJax]/jax/input/MathML/entities/scr.js","[MathJax]/jax/input/MathML/entities/opf.js","[MathJax]/jax/input/MathML/entities/z.js","[MathJax]/jax/input/MathML/entities/g.js","[MathJax]/jax/input/MathML/entities/r.js","[MathJax]/jax/input/MathML/entities/p.js","[MathJax]/jax/input/MathML/entities/m.js","[MathJax]/jax/input/MathML/entities/q.js","[MathJax]/jax/input/MathML/entities/t.js","[MathJax]/jax/input/MathML/entities/w.js","[MathJax]/jax/input/MathML/entities/f.js","[MathJax]/jax/input/MathML/entities/v.js","[MathJax]/jax/input/MathML/entities/e.js","[MathJax]/jax/input/MathML/entities/k.js","[MathJax]/jax/input/MathML/entities/x.js","[MathJax]/jax/input/MathML/entities/c.js","[MathJax]/jax/input/MathML/entities/n.js","[MathJax]/jax/input/MathML/entities/a.js","[MathJax]/jax/input/MathML/entities/j.js","[MathJax]/jax/input/MathML/entities/u.js","[MathJax]/jax/input/MathML/entities/b.js","[MathJax]/jax/input/MathML/entities/i.js","[MathJax]/jax/input/MathML/entities/l.js","[MathJax]/jax/input/MathML/entities/y.js","[MathJax]/jax/input/MathML/entities/fr.js","[MathJax]/jax/input/MathML/entities/o.js","[MathJax]/jax/input/MathML/entities/s.js","[MathJax]/jax/input/MathML/entities/d.js","[MathJax]/jax/input/MathML/entities/h.js","[MathJax]/jax/element/mml/optable/Arrows.js","[MathJax]/jax/element/mml/optable/MiscMathSymbolsA.js","[MathJax]/jax/element/mml/optable/Dingbats.js","[MathJax]/jax/element/mml/optable/GeneralPunctuation.js","[MathJax]/jax/element/mml/optable/SpacingModLetters.js","[MathJax]/jax/element/mml/optable/MiscTechnical.js","[MathJax]/jax/element/mml/optable/SupplementalArrowsA.js","[MathJax]/jax/element/mml/optable/GreekAndCoptic.js","[MathJax]/jax/element/mml/optable/LetterlikeSymbols.js","[MathJax]/jax/element/mml/optable/SupplementalArrowsB.js","[MathJax]/jax/element/mml/optable/BasicLatin.js","[MathJax]/jax/element/mml/optable/MiscSymbolsAndArrows.js","[MathJax]/jax/element/mml/optable/CombDiacritMarks.js","[MathJax]/jax/element/mml/optable/GeometricShapes.js","[MathJax]/jax/element/mml/optable/MathOperators.js","[MathJax]/jax/element/mml/optable/MiscMathSymbolsB.js","[MathJax]/jax/element/mml/optable/SuppMathOperators.js","[MathJax]/jax/element/mml/optable/CombDiactForSymbols.js","[MathJax]/jax/element/mml/optable/Latin1Supplement.js","[MathJax]/extensions/MatchWebFonts.js","[MathJax]/extensions/HelpDialog.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/LatinExtendedA.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/MiscSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/SpacingModLetters.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/GreekAndCoptic.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/LetterlikeSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/LatinExtendedB.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/GeometricShapes.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/MathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Regular/SuppMathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/Arrows.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/PUA.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/Dingbats.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/LatinExtendedA.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/GeneralPunctuation.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/MiscSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/SpacingModLetters.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/MiscTechnical.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/GreekAndCoptic.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/LetterlikeSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/BoxDrawing.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/GeometricShapes.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/MathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/MiscMathSymbolsB.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/SuppMathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/Latin1Supplement.js","[MathJax]/jax/output/SVG/fonts/TeX/AMS/Regular/EnclosedAlphanum.js","[MathJax]/jax/output/SVG/fonts/TeX/Typewriter/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Typewriter/Regular/Other.js","[MathJax]/jax/output/SVG/fonts/TeX/Typewriter/Regular/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Typewriter/Regular/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Regular/PUA.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Regular/Other.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Regular/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Bold/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Bold/PUA.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Bold/Other.js","[MathJax]/jax/output/SVG/fonts/TeX/Fraktur/Bold/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Math/BoldItalic/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Caligraphic/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Caligraphic/Bold/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/LatinExtendedA.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/GeneralPunctuation.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/GreekAndCoptic.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/LetterlikeSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/LatinExtendedB.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Italic/MathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/Arrows.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/MiscMathSymbolsA.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/LatinExtendedA.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/GeneralPunctuation.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/MiscSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/SpacingModLetters.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/MiscTechnical.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/SupplementalArrowsA.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/GreekAndCoptic.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/LetterlikeSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/LatinExtendedB.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/GeometricShapes.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/MathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/SuppMathOperators.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/CombDiactForSymbols.js","[MathJax]/jax/output/SVG/fonts/TeX/Main/Bold/Latin1Supplement.js","[MathJax]/jax/output/SVG/fonts/TeX/Size3/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Size2/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Script/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/Script/Regular/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/Size1/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Italic/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Italic/Other.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Italic/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Italic/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Regular/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Regular/Other.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Regular/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Regular/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Bold/Main.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Bold/Other.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Bold/BasicLatin.js","[MathJax]/jax/output/SVG/fonts/TeX/SansSerif/Bold/CombDiacritMarks.js","[MathJax]/jax/output/SVG/fonts/TeX/Size4/Regular/Main.js");MathJax.Hub.Config({"v1.0-compatible":false});MathJax.InputJax.MathML=MathJax.InputJax({id:"MathML",version:"2.4.0",directory:MathJax.InputJax.directory+"/MathML",extensionDir:MathJax.InputJax.extensionDir+"/MathML",entityDir:MathJax.InputJax.directory+"/MathML/entities",config:{useMathMLspacing:false}});MathJax.InputJax.MathML.Register("math/mml");MathJax.InputJax.MathML.loadComplete("config.js");MathJax.OutputJax.SVG=MathJax.OutputJax({id:"SVG",version:"2.4.0",directory:MathJax.OutputJax.directory+"/SVG",extensionDir:MathJax.OutputJax.extensionDir+"/SVG",autoloadDir:MathJax.OutputJax.directory+"/SVG/autoload",fontDir:MathJax.OutputJax.directory+"/SVG/fonts",config:{scale:100,minScaleAdjust:50,font:"TeX",blacker:10,mtextFontInherit:false,undefinedFamily:"STIXGeneral,'Arial Unicode MS',serif",addMMLclasses:false,EqnChunk:MathJax.Hub.Browser.isMobile?10:50,EqnChunkFactor:1.5,EqnChunkDelay:100,linebreaks:{automatic:false,width:"container"},merrorStyle:{fontSize:"90%",color:"#C00",background:"#FF8",border:"1px solid #C00",padding:"3px"},styles:{".MathJax_SVG_Display":{"text-align":"center",margin:"1em 0em"},".MathJax_SVG .MJX-monospace":{"font-family":"monospace"},".MathJax_SVG .MJX-sans-serif":{"font-family":"sans-serif"},"#MathJax_SVG_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",padding:"3px 4px","z-index":401}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.SVG.Register("jax/mml")}MathJax.OutputJax.SVG.loadComplete("config.js");MathJax.Extension.mml2jax={version:"2.4.0",config:{preview:"mathml"},MMLnamespace:"http://www.w3.org/1998/Math/MathML",PreProcess:function(e){if(!this.configured){this.config=MathJax.Hub.CombineConfig("mml2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.InitBrowser();this.configured=true}if(typeof e==="string"){e=document.getElementById(e)}if(!e){e=document.body}var h=[];this.PushMathElements(h,e,"math");this.PushMathElements(h,e,"math",this.MMLnamespace);var d,b;if(typeof document.namespaces!=="undefined"){try{for(d=0,b=document.namespaces.length;d<b;d++){var f=document.namespaces[d];if(f.urn===this.MMLnamespace){this.PushMathElements(h,e,f.name+":math")}}}catch(g){}}else{var c=document.getElementsByTagName("html")[0];if(c){for(d=0,b=c.attributes.length;d<b;d++){var a=c.attributes[d];if(a.nodeName.substr(0,6)==="xmlns:"&&a.nodeValue===this.MMLnamespace){this.PushMathElements(h,e,a.nodeName.substr(6)+":math")}}}}this.ProcessMathArray(h)},PushMathElements:function(f,d,a,c){var h,g=MathJax.Hub.config.preRemoveClass;if(c){if(!d.getElementsByTagNameNS){return}h=d.getElementsByTagNameNS(c,a)}else{h=d.getElementsByTagName(a)}for(var e=0,b=h.length;e<b;e++){var j=h[e].parentNode;if(j&&j.className!==g&&!h[e].prefix===!c){f.push(h[e])}}},ProcessMathArray:function(c){var b,a=c.length;if(a){if(this.MathTagBug){for(b=0;b<a;b++){if(c[b].nodeName==="MATH"){this.ProcessMathFlattened(c[b])}else{this.ProcessMath(c[b])}}}else{for(b=0;b<a;b++){this.ProcessMath(c[b])}}}},ProcessMath:function(e){var d=e.parentNode;if(!d||d.className===MathJax.Hub.config.preRemoveClass){return}var a=document.createElement("script");a.type="math/mml";d.insertBefore(a,e);if(this.AttributeBug){var b=this.OuterHTML(e);if(this.CleanupHTML){b=b.replace(/<\?import .*?>/i,"").replace(/<\?xml:namespace .*?\/>/i,"");b=b.replace(/&nbsp;/g,"&#xA0;")}MathJax.HTML.setScript(a,b);d.removeChild(e)}else{var c=MathJax.HTML.Element("span");c.appendChild(e);MathJax.HTML.setScript(a,c.innerHTML)}if(this.config.preview!=="none"){this.createPreview(e,a)}},ProcessMathFlattened:function(f){var d=f.parentNode;if(!d||d.className===MathJax.Hub.config.preRemoveClass){return}var b=document.createElement("script");b.type="math/mml";d.insertBefore(b,f);var c="",e,a=f;while(f&&f.nodeName!=="/MATH"){e=f;f=f.nextSibling;c+=this.NodeHTML(e);e.parentNode.removeChild(e)}if(f&&f.nodeName==="/MATH"){f.parentNode.removeChild(f)}b.text=c+"</math>";if(this.config.preview!=="none"){this.createPreview(a,b)}},NodeHTML:function(e){var c,b,a;if(e.nodeName==="#text"){c=this.quoteHTML(e.nodeValue)}else{if(e.nodeName==="#comment"){c="<!--"+e.nodeValue+"-->"}else{c="<"+e.nodeName.toLowerCase();for(b=0,a=e.attributes.length;b<a;b++){var d=e.attributes[b];if(d.specified&&d.nodeName.substr(0,10)!=="_moz-math-"){c+=" "+d.nodeName.toLowerCase().replace(/xmlns:xmlns/,"xmlns")+"=";var f=d.nodeValue;if(f==null&&d.nodeName==="style"&&e.style){f=e.style.cssText}c+='"'+this.quoteHTML(f)+'"'}}c+=">";if(e.outerHTML!=null&&e.outerHTML.match(/(.<\/[A-Z]+>|\/>)$/)){for(b=0,a=e.childNodes.length;b<a;b++){c+=this.OuterHTML(e.childNodes[b])}c+="</"+e.nodeName.toLowerCase()+">"}}}return c},OuterHTML:function(d){if(d.nodeName.charAt(0)==="#"){return this.NodeHTML(d)}if(!this.AttributeBug){return d.outerHTML}var c=this.NodeHTML(d);for(var b=0,a=d.childNodes.length;b<a;b++){c+=this.OuterHTML(d.childNodes[b])}c+="</"+d.nodeName.toLowerCase()+">";return c},quoteHTML:function(a){if(a==null){a=""}return a.replace(/&/g,"&#x26;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\"/g,"&quot;")},createPreview:function(f,b){var g=this.config.preview;if(g==="none"){return}var a=false;if(g==="mathml"){a=true;if(this.MathTagBug){g="alttext"}else{g=f.cloneNode(false)}}if(g==="alttext"||g==="altimg"){a=true;var c=this.filterPreview(f.getAttribute("alttext"));if(g==="alttext"){if(c!=null){g=MathJax.HTML.TextNode(c)}else{g=null}}else{var h=f.getAttribute("altimg");if(h!=null){var e={width:f.getAttribute("altimg-width"),height:f.getAttribute("altimg-height")};g=MathJax.HTML.Element("img",{src:h,alt:c,style:e})}else{g=null}}}if(g){var d;if(a){d=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass});d.appendChild(g)}else{d=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},g)}b.parentNode.insertBefore(d,b)}},filterPreview:function(a){return a},InitBrowser:function(){var b=MathJax.HTML.Element("span",{id:"<",className:"mathjax",innerHTML:"<math><mi>x</mi><mspace /></math>"});var a=b.outerHTML||"";this.AttributeBug=a!==""&&!(a.match(/id="&lt;"/)&&a.match(/class="mathjax"/)&&a.match(/<\/math>/));this.MathTagBug=b.childNodes.length>1;this.CleanupHTML=MathJax.Hub.Browser.isMSIE}};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.mml2jax],5);MathJax.Ajax.loadComplete("[MathJax]/extensions/mml2jax.js");(function(d,h,l,g,m,b,j){var q="2.4.0";var i=MathJax.Extension;var c=i.MathEvents={version:q};var k=d.config.menuSettings;var p={hover:500,frame:{x:3.5,y:5,bwidth:1,bcolor:"#A6D",hwidth:"15px",hcolor:"#83A"},button:{x:-4,y:-3,wx:-2,src:l.urlRev(b.imageDir+"/MenuArrow-15.png")},fadeinInc:.2,fadeoutInc:.05,fadeDelay:50,fadeoutStart:400,fadeoutDelay:15*1e3,styles:{".MathJax_Hover_Frame":{"border-radius":".25em","-webkit-border-radius":".25em","-moz-border-radius":".25em","-khtml-border-radius":".25em","box-shadow":"0px 0px 15px #83A","-webkit-box-shadow":"0px 0px 15px #83A","-moz-box-shadow":"0px 0px 15px #83A","-khtml-box-shadow":"0px 0px 15px #83A",border:"1px solid #A6D ! important",display:"inline-block",position:"absolute"},".MathJax_Hover_Arrow":{position:"absolute",width:"15px",height:"11px",cursor:"pointer"}}};var n=c.Event={LEFTBUTTON:0,RIGHTBUTTON:2,MENUKEY:"altKey",Mousedown:function(r){return n.Handler(r,"Mousedown",this)},Mouseup:function(r){return n.Handler(r,"Mouseup",this)},Mousemove:function(r){return n.Handler(r,"Mousemove",this)},Mouseover:function(r){return n.Handler(r,"Mouseover",this)},Mouseout:function(r){return n.Handler(r,"Mouseout",this)},Click:function(r){return n.Handler(r,"Click",this)},DblClick:function(r){return n.Handler(r,"DblClick",this)},Menu:function(r){return n.Handler(r,"ContextMenu",this)},Handler:function(u,s,t){if(l.loadingMathMenu){return n.False(u)}var r=b[t.jaxID];if(!u){u=window.event}u.isContextMenu=s==="ContextMenu";if(r[s]){return r[s](u,t)}if(i.MathZoom){return i.MathZoom.HandleEvent(u,s,t)}},False:function(r){if(!r){r=window.event}if(r){if(r.preventDefault){r.preventDefault()}else{r.returnValue=false}if(r.stopPropagation){r.stopPropagation()}r.cancelBubble=true}return false},ContextMenu:function(u,F,x){var C=b[F.jaxID],w=C.getJaxFromMath(F);var G=(C.config.showMathMenu!=null?C:d).config.showMathMenu;if(!G||k.context!=="MathJax"&&!x){return}if(c.msieEventBug){u=window.event||u}n.ClearSelection();f.ClearHoverTimer();if(w.hover){if(w.hover.remove){clearTimeout(w.hover.remove);delete w.hover.remove}w.hover.nofade=true}var v=MathJax.Menu;var H,E;if(v){if(v.loadingDomain){return n.False(u)}H=m.loadDomain("MathMenu");if(!H){v.jax=w;var s=v.menu.Find("Show Math As").menu;s.items[0].name=w.sourceMenuTitle;s.items[0].format=w.sourceMenuFormat||"MathML";s.items[1].name=j[w.inputJax].sourceMenuTitle;s.items[5].disabled=!j[w.inputJax].annotationEncoding;var B=s.items[2];B.disabled=true;var r=B.menu.items;annotationList=MathJax.Hub.Config.semanticsAnnotations;for(var A=0,z=r.length;A<z;A++){var t=r[A].name[1];if(w.root&&w.root.getAnnotation(t)!==null){B.disabled=false;r[A].hidden=false}else{r[A].hidden=true}}var y=v.menu.Find("Math Settings","MathPlayer");y.hidden=!(w.outputJax==="NativeMML"&&d.Browser.hasMathPlayer);return v.menu.Post(u)}v.loadingDomain=true;E=function(){delete v.loadingDomain}}else{if(l.loadingMathMenu){return n.False(u)}l.loadingMathMenu=true;H=l.Require("[MathJax]/extensions/MathMenu.js");E=function(){delete l.loadingMathMenu;if(!MathJax.Menu){MathJax.Menu={}}}}var D={pageX:u.pageX,pageY:u.pageY,clientX:u.clientX,clientY:u.clientY};g.Queue(H,E,["ContextMenu",n,D,F,x]);return n.False(u)},AltContextMenu:function(t,s){var u=b[s.jaxID];var r=(u.config.showMathMenu!=null?u:d).config.showMathMenu;if(r){r=(u.config.showMathMenuMSIE!=null?u:d).config.showMathMenuMSIE;if(k.context==="MathJax"&&!k.mpContext&&r){if(!c.noContextMenuBug||t.button!==n.RIGHTBUTTON){return}}else{if(!t[n.MENUKEY]||t.button!==n.LEFTBUTTON){return}}return u.ContextMenu(t,s,true)}},ClearSelection:function(){if(c.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(document.selection){setTimeout("document.selection.empty()",0)}},getBBox:function(t){t.appendChild(c.topImg);var s=c.topImg.offsetTop,u=t.offsetHeight-s,r=t.offsetWidth;t.removeChild(c.topImg);return{w:r,h:s,d:u}}};var f=c.Hover={Mouseover:function(t,s){if(k.discoverable||k.zoom==="Hover"){var v=t.fromElement||t.relatedTarget,u=t.toElement||t.target;if(v&&u&&(v.isMathJax!=u.isMathJax||d.getJaxFor(v)!==d.getJaxFor(u))){var r=this.getJaxFromMath(s);if(r.hover){f.ReHover(r)}else{f.HoverTimer(r,s)}return n.False(t)}}},Mouseout:function(t,s){if(k.discoverable||k.zoom==="Hover"){var v=t.fromElement||t.relatedTarget,u=t.toElement||t.target;if(v&&u&&(v.isMathJax!=u.isMathJax||d.getJaxFor(v)!==d.getJaxFor(u))){var r=this.getJaxFromMath(s);if(r.hover){f.UnHover(r)}else{f.ClearHoverTimer()}return n.False(t)}}},Mousemove:function(t,s){if(k.discoverable||k.zoom==="Hover"){var r=this.getJaxFromMath(s);if(r.hover){return}if(f.lastX==t.clientX&&f.lastY==t.clientY){return}f.lastX=t.clientX;f.lastY=t.clientY;f.HoverTimer(r,s);return n.False(t)}},HoverTimer:function(r,s){this.ClearHoverTimer();this.hoverTimer=setTimeout(g(["Hover",this,r,s]),p.hover)},ClearHoverTimer:function(){if(this.hoverTimer){clearTimeout(this.hoverTimer);delete this.hoverTimer}},Hover:function(r,v){if(i.MathZoom&&i.MathZoom.Hover({},v)){return}var u=b[r.outputJax],w=u.getHoverSpan(r,v),z=u.getHoverBBox(r,w,v),x=(u.config.showMathMenu!=null?u:d).config.showMathMenu;var B=p.frame.x,A=p.frame.y,y=p.frame.bwidth;if(c.msieBorderWidthBug){y=0}r.hover={opacity:0,id:r.inputID+"-Hover"};var s=h.Element("span",{id:r.hover.id,isMathJax:true,style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{className:"MathJax_Hover_Frame",isMathJax:true,style:{display:"inline-block",position:"absolute",top:this.Px(-z.h-A-y-(z.y||0)),left:this.Px(-B-y+(z.x||0)),width:this.Px(z.w+2*B),height:this.Px(z.h+z.d+2*A),opacity:0,filter:"alpha(opacity=0)"}}]]);var t=h.Element("span",{isMathJax:true,id:r.hover.id+"Menu",style:{display:"inline-block","z-index":1,width:0,height:0,position:"relative"}},[["img",{className:"MathJax_Hover_Arrow",isMathJax:true,math:v,src:p.button.src,onclick:this.HoverMenu,jax:u.id,style:{left:this.Px(z.w+B+y+(z.x||0)+p.button.x),top:this.Px(-z.h-A-y-(z.y||0)-p.button.y),opacity:0,filter:"alpha(opacity=0)"}}]]);if(z.width){s.style.width=t.style.width=z.width;s.style.marginRight=t.style.marginRight="-"+z.width;s.firstChild.style.width=z.width;t.firstChild.style.left="";t.firstChild.style.right=this.Px(p.button.wx)}w.parentNode.insertBefore(s,w);if(x){w.parentNode.insertBefore(t,w)}if(w.style){w.style.position="relative"}this.ReHover(r)},ReHover:function(r){if(r.hover.remove){clearTimeout(r.hover.remove)}r.hover.remove=setTimeout(g(["UnHover",this,r]),p.fadeoutDelay);this.HoverFadeTimer(r,p.fadeinInc)},UnHover:function(r){if(!r.hover.nofade){this.HoverFadeTimer(r,-p.fadeoutInc,p.fadeoutStart)}},HoverFade:function(r){delete r.hover.timer;r.hover.opacity=Math.max(0,Math.min(1,r.hover.opacity+r.hover.inc));r.hover.opacity=Math.floor(1e3*r.hover.opacity)/1e3;var t=document.getElementById(r.hover.id),s=document.getElementById(r.hover.id+"Menu");t.firstChild.style.opacity=r.hover.opacity;t.firstChild.style.filter="alpha(opacity="+Math.floor(100*r.hover.opacity)+")";if(s){s.firstChild.style.opacity=r.hover.opacity;s.firstChild.style.filter=t.style.filter}if(r.hover.opacity===1){return}if(r.hover.opacity>0){this.HoverFadeTimer(r,r.hover.inc);return}t.parentNode.removeChild(t);if(s){s.parentNode.removeChild(s)}if(r.hover.remove){clearTimeout(r.hover.remove)}delete r.hover},HoverFadeTimer:function(r,t,s){r.hover.inc=t;if(!r.hover.timer){r.hover.timer=setTimeout(g(["HoverFade",this,r]),s||p.fadeDelay)}},HoverMenu:function(r){if(!r){r=window.event}return b[this.jax].ContextMenu(r,this.math,true)},ClearHover:function(r){if(r.hover.remove){clearTimeout(r.hover.remove)}if(r.hover.timer){clearTimeout(r.hover.timer)}f.ClearHoverTimer();delete r.hover},Px:function(r){if(Math.abs(r)<.006){return"0px"}return r.toFixed(2).replace(/\.?0+$/,"")+"px"},getImages:function(){if(k.discoverable){var r=new Image;r.src=p.button.src}}};var a=c.Touch={last:0,delay:500,start:function(s){var r=(new Date).getTime();var t=r-a.last<a.delay&&a.up;a.last=r;a.up=false;if(t){a.timeout=setTimeout(a.menu,a.delay,s,this);s.preventDefault()}},end:function(s){var r=(new Date).getTime();a.up=r-a.last<a.delay;if(a.timeout){clearTimeout(a.timeout);delete a.timeout;a.last=0;a.up=false;s.preventDefault();return n.Handler(s.touches[0]||s.touch,"DblClick",this)}},menu:function(s,r){delete a.timeout;a.last=0;a.up=false;return n.Handler(s.touches[0]||s.touch,"ContextMenu",r)}};if(d.Browser.isMobile){var o=p.styles[".MathJax_Hover_Arrow"];o.width="25px";o.height="18px";p.button.x=-6}d.Browser.Select({MSIE:function(r){var t=document.documentMode||0;var s=r.versionAtLeast("8.0");c.msieBorderWidthBug=document.compatMode==="BackCompat";c.msieEventBug=r.isIE9;c.msieAlignBug=!s||t<8;if(t<9){n.LEFTBUTTON=1}},Safari:function(r){c.safariContextMenuBug=true},Opera:function(r){c.operaPositionBug=true},Konqueror:function(r){c.noContextMenuBug=true}});c.topImg=c.msieAlignBug?h.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):h.Element("span",{style:{width:0,height:0,display:"inline-block"}});if(c.operaPositionBug){c.topImg.style.border="1px solid"}c.config=p=d.CombineConfig("MathEvents",p);var e=function(){var r=p.styles[".MathJax_Hover_Frame"];r.border=p.frame.bwidth+"px solid "+p.frame.bcolor+" ! important";r["box-shadow"]=r["-webkit-box-shadow"]=r["-moz-box-shadow"]=r["-khtml-box-shadow"]="0px 0px "+p.frame.hwidth+" "+p.frame.hcolor};g.Queue(d.Register.StartupHook("End Config",{}),[e],["getImages",f],["Styles",l,p.styles],["Post",d.Startup.signal,"MathEvents Ready"],["loadComplete",l,"[MathJax]/extensions/MathEvents.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.Callback,MathJax.Localization,MathJax.OutputJax,MathJax.InputJax);(function(a,d,f,c,j){var k="2.4.0";var i=a.CombineConfig("MathZoom",{styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"},"#MathJax_ZoomFrame":{position:"relative",display:"inline-block",height:0,width:0},"#MathJax_ZoomEventTrap":{position:"absolute",left:0,top:0,"z-index":302,display:"inline-block",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var e,b,g;MathJax.Hub.Register.StartupHook("MathEvents Ready",function(){g=MathJax.Extension.MathEvents.Event;e=MathJax.Extension.MathEvents.Event.False;b=MathJax.Extension.MathEvents.Hover});var h=MathJax.Extension.MathZoom={version:k,settings:a.config.menuSettings,scrollSize:18,HandleEvent:function(n,l,m){if(h.settings.CTRL&&!n.ctrlKey){return true}if(h.settings.ALT&&!n.altKey){return true}if(h.settings.CMD&&!n.metaKey){return true}if(h.settings.Shift&&!n.shiftKey){return true}if(!h[l]){return true}return h[l](n,m)},Click:function(m,l){if(this.settings.zoom==="Click"){return this.Zoom(m,l)}},DblClick:function(m,l){if(this.settings.zoom==="Double-Click"||this.settings.zoom==="DoubleClick"){return this.Zoom(m,l)}},Hover:function(m,l){if(this.settings.zoom==="Hover"){this.Zoom(m,l);return true}return false},Zoom:function(o,u){this.Remove();b.ClearHoverTimer();g.ClearSelection();var s=MathJax.OutputJax[u.jaxID];var p=s.getJaxFromMath(u);if(p.hover){b.UnHover(p)}var q=this.findContainer(u);var l=Math.floor(.85*q.clientWidth),t=Math.max(document.body.clientHeight,document.documentElement.clientHeight);if(this.getOverflow(q)!=="visible"){t=Math.min(q.clientHeight,t)}t=Math.floor(.85*t);var n=d.Element("span",{id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale}},[["span",{style:{display:"inline-block","white-space":"nowrap"}}]]]]);var z=n.lastChild,w=z.firstChild,r=n.firstChild;u.parentNode.insertBefore(n,u);u.parentNode.insertBefore(u,n);if(w.addEventListener){w.addEventListener("mousedown",this.Remove,true)}var m=z.offsetWidth||z.clientWidth;l-=m;t-=m;z.style.maxWidth=l+"px";z.style.maxHeight=t+"px";if(this.msieTrapEventBug){var y=d.Element("span",{id:"MathJax_ZoomEventTrap",onmousedown:this.Remove});n.insertBefore(y,z)}if(this.msieZIndexBug){var v=d.addElement(document.body,"img",{src:"about:blank",id:"MathJax_ZoomTracker",width:0,height:0,style:{width:0,height:0,position:"relative"}});n.style.position="relative";n.style.zIndex=i.styles["#MathJax_ZoomOverlay"]["z-index"];n=v}var x=s.Zoom(p,w,u,l,t);if(this.msiePositionBug){if(this.msieSizeBug){z.style.height=x.zH+"px";z.style.width=x.zW+"px"}if(z.offsetHeight>t){z.style.height=t+"px";z.style.width=x.zW+this.scrollSize+"px"}if(z.offsetWidth>l){z.style.width=l+"px";z.style.height=x.zH+this.scrollSize+"px"}}if(this.operaPositionBug){z.style.width=Math.min(l,x.zW)+"px"}if(z.offsetWidth>m&&z.offsetWidth-m<l&&z.offsetHeight-m<t){z.style.overflow="visible"}this.Position(z,x);if(this.msieTrapEventBug){y.style.height=z.clientHeight+"px";y.style.width=z.clientWidth+"px";y.style.left=parseFloat(z.style.left)+z.clientLeft+"px";y.style.top=parseFloat(z.style.top)+z.clientTop+"px"}z.style.visibility="";if(this.settings.zoom==="Hover"){r.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}a.signal.Post(["math zoomed",p]);return e(o)},Position:function(p,r){p.style.display="none";var q=this.Resize(),m=q.x,s=q.y,l=r.mW;p.style.display="";var o=-l-Math.floor((p.offsetWidth-l)/2),n=r.Y;p.style.left=Math.max(o,10-m)+"px";p.style.top=Math.max(n,10-s)+"px";if(!h.msiePositionBug){h.SetWH()}},Resize:function(m){if(h.onresize){h.onresize(m)}var q=document.getElementById("MathJax_ZoomFrame"),l=document.getElementById("MathJax_ZoomOverlay");var o=h.getXY(q),n=h.findContainer(q);if(h.getOverflow(n)!=="visible"){l.scroll_parent=n;var p=h.getXY(n);o.x-=p.x;o.y-=p.y;p=h.getBorder(n);o.x-=p.x;o.y-=p.y}l.style.left=-o.x+"px";l.style.top=-o.y+"px";if(h.msiePositionBug){setTimeout(h.SetWH,0)}else{h.SetWH()}return o},SetWH:function(){var l=document.getElementById("MathJax_ZoomOverlay");l.style.display="none";var m=l.scroll_parent||document.documentElement||document.body;l.style.width=m.scrollWidth+"px";l.style.height=Math.max(m.clientHeight,m.scrollHeight)+"px";l.style.display=""},findContainer:function(l){l=l.parentNode;while(l.parentNode&&l!==document.body&&h.getOverflow(l)==="visible"){l=l.parentNode}return l},getOverflow:window.getComputedStyle?function(l){return getComputedStyle(l).overflow}:function(l){return(l.currentStyle||{overflow:"visible"}).overflow},getBorder:function(o){var m={thin:1,medium:2,thick:3};var n=window.getComputedStyle?getComputedStyle(o):o.currentStyle||{borderLeftWidth:0,borderTopWidth:0};var l=n.borderLeftWidth,p=n.borderTopWidth;if(m[l]){l=m[l]}else{l=parseInt(l)}if(m[p]){p=m[p]}else{p=parseInt(p)}return{x:l,y:p}},getXY:function(o){var l=0,n=0,m;m=o;while(m.offsetParent){l+=m.offsetLeft;m=m.offsetParent}if(h.operaPositionBug){o.style.border="1px solid"}m=o;while(m.offsetParent){n+=m.offsetTop;m=m.offsetParent}if(h.operaPositionBug){o.style.border=""}return{x:l,y:n}},Remove:function(n){var p=document.getElementById("MathJax_ZoomFrame");if(p){var o=MathJax.OutputJax[p.previousSibling.jaxID];var l=o.getJaxFromMath(p.previousSibling);a.signal.Post(["math unzoomed",l]);p.parentNode.removeChild(p);p=document.getElementById("MathJax_ZoomTracker");if(p){p.parentNode.removeChild(p)}if(h.operaRefreshBug){var m=d.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});
document.body.removeChild(m)}if(window.removeEventListener){removeEventListener("resize",h.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",h.Resize)}else{window.onresize=h.onresize;delete h.onresize}}}return e(n)}};a.Browser.Select({MSIE:function(l){var n=document.documentMode||0;var m=n>=9;h.msiePositionBug=!m;h.msieSizeBug=l.versionAtLeast("7.0")&&(!document.documentMode||n===7||n===8);h.msieZIndexBug=n<=7;h.msieInlineBlockAlignBug=n<=7;h.msieTrapEventBug=!window.addEventListener;if(document.compatMode==="BackCompat"){h.scrollSize=52}if(m){delete i.styles["#MathJax_Zoom"].filter}},Opera:function(l){h.operaPositionBug=true;h.operaRefreshBug=true}});h.topImg=h.msieInlineBlockAlignBug?d.Element("img",{style:{width:0,height:0,position:"relative"},src:"about:blank"}):d.Element("span",{style:{width:0,height:0,display:"inline-block"}});if(h.operaPositionBug||h.msieTopBug){h.topImg.style.border="1px solid"}MathJax.Callback.Queue(["StartupHook",MathJax.Hub.Register,"Begin Styles",{}],["Styles",f,i.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",f,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);(function(c,g,k,f,b){var q="2.4.0";var j=MathJax.Callback.Signal("menu");MathJax.Extension.MathMenu={version:q,signal:j};var o=function(r){return MathJax.Localization._.apply(MathJax.Localization,[["MathMenu",r]].concat([].slice.call(arguments,1)))};var n=c.Browser.isPC,l=c.Browser.isMSIE,e=(document.documentMode||0)>8;var i=n?null:"5px";var p=c.CombineConfig("MathMenu",{delay:150,closeImg:k.urlRev(b.imageDir+"/CloseX-31.png"),showRenderer:true,showMathPlayer:true,showFontMenu:false,showContext:false,showDiscoverable:false,showLocale:true,showLocaleURL:false,semanticsAnnotations:{TeX:["TeX","LaTeX","application/x-tex"],StarMath:["StarMath 5.0"],Maple:["Maple"],ContentMathML:["MathML-Content","application/mathml-content+xml"],OpenMath:["OpenMath"]},windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:400,height:300,left:Math.round((screen.width-400)/2),top:Math.round((screen.height-300)/3)},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:n?"2px":"5px 0px",border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":i,"-webkit-border-radius":i,"-moz-border-radius":i,"-khtml-border-radius":i,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:n?"2px 2em":"1px 2em",background:"transparent"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":l?"'Arial unicode MS'":null},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuArrow.RTL":{left:".5em",right:"auto"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":l?"'Arial unicode MS'":null},".MathJax_MenuCheck.RTL":{right:".7em",left:"auto"},".MathJax_MenuRadioCheck":{position:"absolute",left:n?"1em":".7em"},".MathJax_MenuRadioCheck.RTL":{right:n?"1em":".7em",left:"auto"},".MathJax_MenuLabel":{padding:n?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em","font-style":"italic"},".MathJax_MenuRule":{"border-top":n?"1px solid #CCCCCC":"1px solid #DDDDDD",margin:n?"4px 1px 0px":"4px 3px"},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":n?"Highlight":"#606872",color:n?"HighlightText":"white"},".MathJax_Menu_Close":{position:"absolute",width:"31px",height:"31px",top:"-15px",left:"-15px"}}});var h,d;c.Register.StartupHook("MathEvents Ready",function(){h=MathJax.Extension.MathEvents.Event.False;d=MathJax.Extension.MathEvents.Hover});var a=MathJax.Menu=MathJax.Object.Subclass({version:q,items:[],posted:false,title:null,margin:5,Init:function(r){this.items=[].slice.call(arguments,0)},With:function(r){if(r){c.Insert(this,r)}return this},Post:function(s,C,A){if(!s){s=window.event}var r=document.getElementById("MathJax_MenuFrame");if(!r){r=a.Background(this);delete m.lastItem;delete m.lastMenu;delete a.skipUp;j.Post(["post",a.jax]);a.isRTL=MathJax.Localization.fontDirection()==="rtl"}var t=g.Element("div",{onmouseup:a.Mouseup,ondblclick:h,ondragstart:h,onselectstart:h,oncontextmenu:h,menuItem:this,className:"MathJax_Menu"});if(!A){MathJax.Localization.setCSS(t)}for(var v=0,u=this.items.length;v<u;v++){this.items[v].Create(t)}if(a.isMobile){g.addElement(t,"span",{className:"MathJax_Menu_Close",menu:C,ontouchstart:a.Close,ontouchend:h,onmousedown:a.Close,onmouseup:h},[["img",{src:p.closeImg,style:{width:"100%",height:"100%"}}]])}r.appendChild(t);this.posted=true;t.style.width=t.offsetWidth+2+"px";var B=s.pageX,z=s.pageY;if(!B&&!z){B=s.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;z=s.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!C){if(B+t.offsetWidth>document.body.offsetWidth-this.margin){B=document.body.offsetWidth-t.offsetWidth-this.margin}if(a.isMobile){B=Math.max(5,B-Math.floor(t.offsetWidth/2));z-=20}a.skipUp=s.isContextMenu}else{var w="left",D=C.offsetWidth;B=a.isMobile?30:D-2;z=0;while(C&&C!==r){B+=C.offsetLeft;z+=C.offsetTop;C=C.parentNode}if(!a.isMobile){if(a.isRTL&&B-D-t.offsetWidth>this.margin||!a.isRTL&&B+t.offsetWidth>document.body.offsetWidth-this.margin){w="right";B=Math.max(this.margin,B-D-t.offsetWidth+6)}}if(!n){t.style["borderRadiusTop"+w]=0;t.style["WebkitBorderRadiusTop"+w]=0;t.style["MozBorderRadiusTop"+w]=0;t.style["KhtmlBorderRadiusTop"+w]=0}}t.style.left=B+"px";t.style.top=z+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return h(s)},Remove:function(r,s){j.Post(["unpost",a.jax]);var t=document.getElementById("MathJax_MenuFrame");if(t){t.parentNode.removeChild(t);if(this.msieFixedPositionBug){detachEvent("onresize",a.Resize)}}if(a.jax.hover){delete a.jax.hover.nofade;d.UnHover(a.jax)}return h(r)},Find:function(r){return this.FindN(1,r,[].slice.call(arguments,1))},FindId:function(r){return this.FindN(0,r,[].slice.call(arguments,1))},FindN:function(v,s,u){for(var t=0,r=this.items.length;t<r;t++){if(this.items[t].name[v]===s){if(u.length){if(!this.items[t].menu){return null}return this.items[t].menu.FindN(v,u[0],u.slice(1))}return this.items[t]}}return null},IndexOf:function(r){return this.IndexOfN(1,r)},IndexOfId:function(r){return this.IndexOfN(0,r)},IndexOfN:function(u,s){for(var t=0,r=this.items.length;t<r;t++){if(this.items[t].name[u]===s){return t}}return null}},{config:p,div:null,Close:function(r){return a.Event(r,this.menu||this.parentNode,this.menu?"Touchend":"Remove")},Remove:function(r){return a.Event(r,this,"Remove")},Mouseover:function(r){return a.Event(r,this,"Mouseover")},Mouseout:function(r){return a.Event(r,this,"Mouseout")},Mousedown:function(r){return a.Event(r,this,"Mousedown")},Mouseup:function(r){return a.Event(r,this,"Mouseup")},Touchstart:function(r){return a.Event(r,this,"Touchstart")},Touchend:function(r){return a.Event(r,this,"Touchend")},Event:function(t,v,r,u){if(a.skipMouseover&&r==="Mouseover"&&!u){return h(t)}if(a.skipUp){if(r.match(/Mouseup|Touchend/)){delete a.skipUp;return h(t)}if(r==="Touchstart"||r==="Mousedown"&&!a.skipMousedown){delete a.skipUp}}if(!t){t=window.event}var s=v.menuItem;if(s&&s[r]){return s[r](t,v)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(s){var t=g.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:s,onmousedown:this.Remove}]]);var r=t.firstChild;if(a.msieBackgroundBug){r.style.backgroundColor="white";r.style.filter="alpha(opacity=0)"}if(a.msieFixedPositionBug){t.width=t.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{r.style.position="fixed"}return t},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var r=document.getElementById("MathJax_MenuFrame");if(r){r=r.firstChild;r.style.width=r.style.height="1px";r.style.width=document.body.scrollWidth+"px";r.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){g.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=g.Cookie.Get("menu")},getImages:function(){if(a.isMobile){var r=new Image;r.src=p.closeImg}}});var m=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(s){if(!this.hidden){var r={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:a.Mousedown,ondragstart:h,onselectstart:h,onselectend:h,ontouchstart:a.Touchstart,ontouchend:a.Touchend,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){r.className+=" MathJax_MenuDisabled"}g.addElement(s,"div",r,this.Label(r,s))}},Name:function(){return o(this.name[0],this.name[1])},Mouseover:function(v,x){if(!this.disabled){this.Activate(x)}if(!this.menu||!this.menu.posted){var w=document.getElementById("MathJax_MenuFrame").childNodes,s=x.parentNode.childNodes;for(var t=0,r=s.length;t<r;t++){var u=s[t].menuItem;if(u&&u.menu&&u.menu.posted){u.Deactivate(s[t])}}r=w.length-1;while(r>=0&&x.parentNode.menuItem!==w[r].menuItem){w[r].menuItem.posted=false;w[r].parentNode.removeChild(w[r]);r--}if(this.Timer&&!a.isMobile){this.Timer(v,x)}}},Mouseout:function(r,s){if(!this.menu||!this.menu.posted){this.Deactivate(s)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(r,s){return this.Remove(r,s)},Touchstart:function(r,s){return this.TouchEvent(r,s,"Mousedown")},Touchend:function(r,s){return this.TouchEvent(r,s,"Mouseup")},TouchEvent:function(s,t,r){if(this!==m.lastItem){if(m.lastMenu){a.Event(s,m.lastMenu,"Mouseout")}a.Event(s,t,"Mouseover",true);m.lastItem=this;m.lastMenu=t}if(this.nativeTouch){return null}a.Event(s,t,r);return false},Remove:function(r,s){s=s.parentNode.menuItem;return s.Remove(r,s)},Activate:function(r){this.Deactivate(r);r.className+=" MathJax_MenuActive"},Deactivate:function(r){r.className=r.className.replace(/ MathJax_MenuActive/,"")},With:function(r){if(r){c.Insert(this,r)}return this},isRTL:function(){return a.isRTL},rtlClass:function(){return this.isRTL()?" RTL":""}});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(r,t,s){if(!(r instanceof Array)){r=[r,r]}this.name=r;this.action=t;this.With(s)},Label:function(r,s){return[this.Name()]},Mouseup:function(r,s){if(!this.disabled){this.Remove(r,s);j.Post(["command",this]);this.action.call(this,r)}return h(r)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:n&&!c.Browser.isSafari?"▶":"▸",markerRTL:n&&!c.Browser.isSafari?"▰":"◂",Init:function(r,t){if(!(r instanceof Array)){r=[r,r]}this.name=r;var s=1;if(!(t instanceof a.ITEM)){this.With(t),s++}this.menu=a.apply(a,[].slice.call(arguments,s))},Label:function(r,s){this.menu.posted=false;return[this.Name()+" ",["span",{className:"MathJax_MenuArrow"+this.rtlClass()},[this.isRTL()?this.markerRTL:this.marker]]]},Timer:function(r,s){if(this.timer){clearTimeout(this.timer)}r={clientX:r.clientX,clientY:r.clientY};this.timer=setTimeout(f(["Mouseup",this,r,s]),p.delay)},Touchend:function(s,u){var t=this.menu.posted;var r=this.SUPER(arguments).Touchend.apply(this,arguments);if(t){this.Deactivate(u);delete m.lastItem;delete m.lastMenu}return r},Mouseup:function(s,u){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(s,u,this.ltr)}else{var t=document.getElementById("MathJax_MenuFrame").childNodes,r=t.length-1;while(r>=0){var v=t[r];v.menuItem.posted=false;v.parentNode.removeChild(v);if(v.menuItem===this.menu){break}r--}}}return h(s)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:n?"●":"✓",Init:function(s,r,t){if(!(s instanceof Array)){s=[s,s]}this.name=s;this.variable=r;this.With(t);if(this.value==null){this.value=this.name[0]}},Label:function(s,t){var r={className:"MathJax_MenuRadioCheck"+this.rtlClass()};if(p.settings[this.variable]!==this.value){r={style:{display:"none"}}}return[["span",r,[this.marker]]," "+this.Name()]},Mouseup:function(u,v){if(!this.disabled){var w=v.parentNode.childNodes;for(var s=0,r=w.length;s<r;s++){var t=w[s].menuItem;if(t&&t.variable===this.variable){w[s].firstChild.style.display="none"}}v.firstChild.display="";p.settings[this.variable]=this.value;a.cookie[this.variable]=p.settings[this.variable];a.saveCookie();j.Post(["radio button",this])}this.Remove(u,v);if(this.action&&!this.disabled){this.action.call(a,this)}return h(u)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"✓",Init:function(s,r,t){if(!(s instanceof Array)){s=[s,s]}this.name=s;this.variable=r;this.With(t)},Label:function(s,t){var r={className:"MathJax_MenuCheck"+this.rtlClass()};if(!p.settings[this.variable]){r={style:{display:"none"}}}return[["span",r,[this.marker]]," "+this.Name()]},Mouseup:function(r,s){if(!this.disabled){s.firstChild.display=p.settings[this.variable]?"none":"";p.settings[this.variable]=!p.settings[this.variable];a.cookie[this.variable]=p.settings[this.variable];a.saveCookie();j.Post(["checkbox",this])}this.Remove(r,s);if(this.action&&!this.disabled){this.action.call(a,this)}return h(r)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(r,s){if(!(r instanceof Array)){r=[r,r]}this.name=r;this.With(s)},Label:function(r,s){delete r.onmouseover,delete r.onmouseout;delete r.onmousedown;r.className+=" MathJax_MenuLabel";return[this.Name()]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(r,s){delete r.onmouseover,delete r.onmouseout;delete r.onmousedown;r.className+=" MathJax_MenuRule";return null}});a.About=function(){var t=b["HTML-CSS"]||{};var s=(t.imgFonts?"image":t.fontInUse?(t.webFonts?"web":"local")+" "+t.fontInUse:b.SVG?"web SVG":"generic")+" fonts";var x=!t.webFonts||t.imgFonts?null:t.allowWebFonts.replace(/otf/,"woff or otf")+" fonts";var r=["MathJax.js v"+MathJax.fileversion,["br"]];r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(r,MathJax.InputJax,["InputJax","%1 Input Jax v%2"]);a.About.GetJax(r,MathJax.OutputJax,["OutputJax","%1 Output Jax v%2"]);a.About.GetJax(r,MathJax.ElementJax,["ElementJax","%1 Element Jax v%2"]);r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(r,MathJax.Extension,["Extension","%1 Extension v%2"],true);r.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[c.Browser+" v"+c.Browser.version+(x?" — "+o(x.replace(/ /g,""),x):"")]]);a.About.div=a.Background(a.About);var v=g.addElement(a.About.div,"div",{id:"MathJax_About"},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],o(s.replace(/ /g,""),"using "+s),["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","max-height":"20em",overflow:"auto","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},r],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]],["img",{src:p.closeImg,style:{width:"21px",height:"21px",position:"absolute",top:".2em",right:".2em"},onclick:a.About.Remove}]]);MathJax.Localization.setCSS(v);var w=document.documentElement||{};var u=window.innerHeight||w.clientHeight||w.scrollHeight||0;if(a.prototype.msieAboutBug){v.style.width="20em";v.style.position="absolute";v.style.left=Math.floor((document.documentElement.scrollWidth-v.offsetWidth)/2)+"px";v.style.top=Math.floor((u-v.offsetHeight)/3)+document.body.scrollTop+"px"}else{v.style.marginLeft=Math.floor(-v.offsetWidth/2)+"px";v.style.top=Math.floor((u-v.offsetHeight)/3)+"px"}};a.About.Remove=function(r){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(s,x,v,u){var w=[];for(var y in x){if(x.hasOwnProperty(y)&&x[y]){if(u&&x[y].version||x[y].isa&&x[y].isa(x)){w.push(o(v[0],v[1],x[y].id||y,x[y].version))}}}w.sort();for(var t=0,r=w.length;t<r;t++){s.push(w[t],["br"])}return s};a.Help=function(){k.Require("[MathJax]/extensions/HelpDialog.js",function(){MathJax.Extension.Help.Dialog()})};a.ShowSource=function(v){if(!v){v=window.event}var u={screenX:v.screenX,screenY:v.screenY};if(!a.jax){return}if(this.format==="MathML"){var s=MathJax.ElementJax.mml;if(s&&typeof s.mbase.prototype.toMathML!=="undefined"){try{a.ShowSource.Text(a.jax.root.toMathML("",a.jax),v)}catch(t){if(!t.restart){throw t}f.After([this,a.ShowSource,u],t.restart)}}else{if(!k.loadingToMathML){k.loadingToMathML=true;a.ShowSource.Window(v);f.Queue(k.Require("[MathJax]/extensions/toMathML.js"),function(){delete k.loadingToMathML;if(!s.mbase.prototype.toMathML){s.mbase.prototype.toMathML=function(){}}},[this,a.ShowSource,u]);return}}}else{if(this.format==="Error"){a.ShowSource.Text(a.jax.errorText,v)}else{if(p.semanticsAnnotations[this.format]){var r=a.jax.root.getAnnotation(this.format);if(r.data[0]){a.ShowSource.Text(r.data[0].toString())}}else{if(a.jax.originalText==null){alert(o("NoOriginalForm","No original form available"));return}a.ShowSource.Text(a.jax.originalText,v)}}}};a.ShowSource.Window=function(s){if(!a.ShowSource.w){var t=[],r=p.windowSettings;for(var u in r){if(r.hasOwnProperty(u)){t.push(u+"="+r[u])}}a.ShowSource.w=window.open("","_blank",t.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(v,t){var r=a.ShowSource.Window(t);delete a.ShowSource.w;v=v.replace(/^\s*/,"").replace(/\s*$/,"");v=v.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");var u=o("EqSource","MathJax Equation Source");if(a.isMobile){r.document.open();r.document.write("<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0' /><title>"+u+"</title></head><body style='font-size:85%'>");r.document.write("<pre>"+v+"</pre>");r.document.write("<hr><input type='button' value='"+o("Close","Close")+"' onclick='window.close()' />");r.document.write("</body></html>");r.document.close()}else{r.document.open();r.document.write("<html><head><title>"+u+"</title></head><body style='font-size:85%'>");r.document.write("<table><tr><td><pre>"+v+"</pre></td></tr></table>");r.document.write("</body></html>");r.document.close();var s=r.document.body.firstChild;setTimeout(function(){var A=r.outerHeight-r.innerHeight||30,z=r.outerWidth-r.innerWidth||30,w,D;z=Math.max(100,Math.min(Math.floor(.5*screen.width),s.offsetWidth+z+25));A=Math.max(40,Math.min(Math.floor(.5*screen.height),s.offsetHeight+A+25));if(a.prototype.msieHeightBug){A+=35}r.resizeTo(z,A);var C;try{C=t.screenX}catch(B){}if(t&&C!=null){w=Math.max(0,Math.min(t.screenX-Math.floor(z/2),screen.width-z-20));D=Math.max(0,Math.min(t.screenY-Math.floor(A/2),screen.height-A-20));r.moveTo(w,D)}},50)}};a.Scale=function(){var s=b["HTML-CSS"],r=b.NativeMML,v=b.SVG;var u=(s||r||v||{config:{scale:100}}).config.scale;var t=prompt(o("ScaleMath","Scale all mathematics (compared to surrounding text) by"),u+"%");if(t){if(t.match(/^\s*\d+(\.\d*)?\s*%?\s*$/)){t=parseFloat(t);if(t){if(t!==u){if(s){s.config.scale=t}if(r){r.config.scale=t}if(v){v.config.scale=t}a.cookie.scale=t;a.saveCookie();c.Reprocess()}}else{alert(o("NonZeroScale","The scale should not be zero"))}}else{alert(o("PercentScale","The scale should be a percentage (e.g., 120%%)"))}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){k.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var s=c.outputJax["jax/mml"];if(s[0]!==p.settings.renderer){var v=c.Browser,u,r=a.Renderer.Messages,t;switch(p.settings.renderer){case"NativeMML":if(!p.settings.warnedMML){if(v.isChrome&&v.version.substr(0,3)!=="24."){u=r.MML.WebKit}else{if(v.isSafari&&!v.versionAtLeast("5.0")){u=r.MML.WebKit}else{if(v.isMSIE){if(!v.hasMathPlayer){u=r.MML.MSIE}}else{u=r.MML[v]}}}t="warnedMML"}break;case"SVG":if(!p.settings.warnedSVG){if(v.isMSIE&&!e){u=r.SVG.MSIE}}break}if(u){u=o(u[0],u[1]);u+="\n\n";u+=o("SwitchAnyway","Switch the renderer anyway?\n\n(Press OK to switch, CANCEL to continue with the current renderer)");a.cookie.renderer=s[0].id;a.saveCookie();if(!confirm(u)){a.cookie.renderer=p.settings.renderer=g.Cookie.Get("menu").renderer;a.saveCookie();return}if(t){a.cookie.warned=p.settings.warned=true}a.cookie.renderer=p.settings.renderer;a.saveCookie()}c.Queue(["setRenderer",c,p.settings.renderer,"jax/mml"],["Rerender",c])}};a.Renderer.Messages={MML:{WebKit:["WebkitNativeMMLWarning","Your browser doesn't seem to support MathML natively, so switching to MathML output may cause the mathematics on the page to become unreadable."],MSIE:["MSIENativeMMLWarning","Internet Explorer requires the MathPlayer plugin in order to process MathML output."],Opera:["OperaNativeMMLWarning","Opera's support for MathML is limited, so switching to MathML output may cause some expressions to render poorly."],Safari:["SafariNativeMMLWarning","Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."],Firefox:["FirefoxNativeMMLWarning","Your browser's native MathML does not implement all the features used by MathJax, so some expressions may not render properly."]},SVG:{MSIE:["MSIESVGWarning","SVG is not implemented in Internet Explorer prior to IE9 or when it is emulating IE8 or below. Switching to SVG output will cause the mathematics to not display properly."]}};a.Font=function(){var r=b["HTML-CSS"];if(!r){return}document.location.reload()};a.Locale=function(){MathJax.Localization.setLocale(p.settings.locale);MathJax.Hub.Queue(["Reprocess",MathJax.Hub])};a.LoadLocale=function(){var r=prompt(o("LoadURL","Load translation data from this URL:"));if(r){if(!r.match(/\.js$/)){alert(o("BadURL","The URL should be for a javascript file that defines MathJax translation data.  Javascript file names should end with '.js'"))}k.Require(r,function(s){if(s!=k.STATUS.OK){alert(o("BadData","Failed to load translation data from %1",r))}})}};a.MPEvents=function(t){var s=p.settings.discoverable,r=a.MPEvents.Messages;if(!e){if(p.settings.mpMouse&&!confirm(o.apply(o,r.IE8warning))){delete a.cookie.mpContext;delete p.settings.mpContext;delete a.cookie.mpMouse;delete p.settings.mpMouse;a.saveCookie();return}p.settings.mpContext=p.settings.mpMouse;a.cookie.mpContext=a.cookie.mpMouse=p.settings.mpMouse;a.saveCookie();MathJax.Hub.Queue(["Rerender",MathJax.Hub])}else{if(!s&&t.name[1]==="Menu Events"&&p.settings.mpContext){alert(o.apply(o,r.IE9warning))}}};a.MPEvents.Messages={IE8warning:["IE8warning","This will disable the MathJax menu and zoom features, but you can Alt-Click on an expression to obtain the MathJax menu instead.\n\nReally change the MathPlayer settings?"],IE9warning:["IE9warning","The MathJax contextual menu will be disabled, but you can Alt-Click on an expression to obtain the MathJax menu instead."]};c.Browser.Select({MSIE:function(r){var s=document.compatMode==="BackCompat";var t=r.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:(document.documentMode||0)<9,msieFixedPositionBug:s||!t,msieAboutBug:s,msieHeightBug:(document.documentMode||0)<9});if(e){delete p.styles["#MathJax_About"].filter;delete p.styles[".MathJax_Menu"].filter}},Firefox:function(r){a.skipMouseover=r.isMobile&&r.versionAtLeast("6.0");a.skipMousedown=r.isMobile}});a.isMobile=c.Browser.isMobile;a.noContextMenu=c.Browser.noContextMenu;a.CreateLocaleMenu=function(){if(!a.menu){return}var w=a.menu.Find("Language").menu,t=w.items;var s=[],y=MathJax.Localization.strings;for(var x in y){if(y.hasOwnProperty(x)){s.push(x)}}s=s.sort();w.items=[];for(var u=0,r=s.length;u<r;u++){var v=y[s[u]].menuTitle;if(v){v+=" ("+s[u]+")"}else{v=s[u]}w.items.push(m.RADIO([s[u],v],"locale",{action:a.Locale}))}w.items.push(t[t.length-2],t[t.length-1])};a.CreateAnnotationMenu=function(){if(!a.menu){return}var t=a.menu.Find("Show Math As","Annotation").menu;var s=p.semanticsAnnotations;for(var r in s){if(s.hasOwnProperty(r)){t.items.push(m.COMMAND([r,r],a.ShowSource,{hidden:true,nativeTouch:true,format:r}))}}};c.Register.StartupHook("End Config",function(){p.settings=c.config.menuSettings;if(typeof p.settings.showRenderer!=="undefined"){p.showRenderer=p.settings.showRenderer}if(typeof p.settings.showFontMenu!=="undefined"){p.showFontMenu=p.settings.showFontMenu}if(typeof p.settings.showContext!=="undefined"){p.showContext=p.settings.showContext}a.getCookie();a.menu=a(m.SUBMENU(["Show","Show Math As"],m.COMMAND(["MathMLcode","MathML Code"],a.ShowSource,{nativeTouch:true,format:"MathML"}),m.COMMAND(["Original","Original Form"],a.ShowSource,{nativeTouch:true}),m.SUBMENU(["Annotation","Annotation"],{disabled:true}),m.RULE(),m.CHECKBOX(["texHints","Show TeX hints in MathML"],"texHints"),m.CHECKBOX(["semantics","Add original form as annotation"],"semantics")),m.RULE(),m.SUBMENU(["Settings","Math Settings"],m.SUBMENU(["ZoomTrigger","Zoom Trigger"],m.RADIO(["Hover","Hover"],"zoom",{action:a.Zoom}),m.RADIO(["Click","Click"],"zoom",{action:a.Zoom}),m.RADIO(["DoubleClick","Double-Click"],"zoom",{action:a.Zoom}),m.RADIO(["NoZoom","No Zoom"],"zoom",{value:"None"}),m.RULE(),m.LABEL(["TriggerRequires","Trigger Requires:"]),m.CHECKBOX(c.Browser.isMac?["Option","Option"]:["Alt","Alt"],"ALT"),m.CHECKBOX(["Command","Command"],"CMD",{hidden:!c.Browser.isMac}),m.CHECKBOX(["Control","Control"],"CTRL",{hidden:c.Browser.isMac}),m.CHECKBOX(["Shift","Shift"],"Shift")),m.SUBMENU(["ZoomFactor","Zoom Factor"],m.RADIO("125%","zscale"),m.RADIO("133%","zscale"),m.RADIO("150%","zscale"),m.RADIO("175%","zscale"),m.RADIO("200%","zscale"),m.RADIO("250%","zscale"),m.RADIO("300%","zscale"),m.RADIO("400%","zscale")),m.RULE(),m.SUBMENU(["Renderer","Math Renderer"],{hidden:!p.showRenderer},m.RADIO("HTML-CSS","renderer",{action:a.Renderer}),m.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"}),m.RADIO("SVG","renderer",{action:a.Renderer})),m.SUBMENU("MathPlayer",{hidden:!c.Browser.isMSIE||!p.showMathPlayer,disabled:!c.Browser.hasMathPlayer},m.LABEL(["MPHandles","Let MathPlayer Handle:"]),m.CHECKBOX(["MenuEvents","Menu Events"],"mpContext",{action:a.MPEvents,hidden:!e}),m.CHECKBOX(["MouseEvents","Mouse Events"],"mpMouse",{action:a.MPEvents,hidden:!e}),m.CHECKBOX(["MenuAndMouse","Mouse and Menu Events"],"mpMouse",{action:a.MPEvents,hidden:e})),m.SUBMENU(["FontPrefs","Font Preference"],{hidden:!p.showFontMenu},m.LABEL(["ForHTMLCSS","For HTML-CSS:"]),m.RADIO(["Auto","Auto"],"font",{action:a.Font}),m.RULE(),m.RADIO(["TeXLocal","TeX (local)"],"font",{action:a.Font}),m.RADIO(["TeXWeb","TeX (web)"],"font",{action:a.Font}),m.RADIO(["TeXImage","TeX (image)"],"font",{action:a.Font}),m.RULE(),m.RADIO(["STIXLocal","STIX (local)"],"font",{action:a.Font}),m.RADIO(["STIXWeb","STIX (web)"],"font",{action:a.Font}),m.RULE(),m.RADIO(["AsanaMathWeb","Asana Math (web)"],"font",{action:a.Font}),m.RADIO(["GyrePagellaWeb","Gyre Pagella (web)"],"font",{action:a.Font}),m.RADIO(["GyreTermesWeb","Gyre Termes (web)"],"font",{action:a.Font}),m.RADIO(["LatinModernWeb","Latin Modern (web)"],"font",{action:a.Font}),m.RADIO(["NeoEulerWeb","Neo Euler (web)"],"font",{action:a.Font})),m.SUBMENU(["ContextMenu","Contextual Menu"],{hidden:!p.showContext},m.RADIO("MathJax","context"),m.RADIO(["Browser","Browser"],"context")),m.COMMAND(["Scale","Scale All Math ..."],a.Scale),m.RULE().With({hidden:!p.showDiscoverable,name:["","discover_rule"]}),m.CHECKBOX(["Discoverable","Highlight on Hover"],"discoverable",{hidden:!p.showDiscoverable})),m.SUBMENU(["Locale","Language"],{hidden:!p.showLocale,ltr:true},m.RADIO("en","locale",{action:a.Locale}),m.RULE().With({hidden:!p.showLocaleURL,name:["","localURL_rule"]}),m.COMMAND(["LoadLocale","Load from URL ..."],a.LoadLocale,{hidden:!p.showLocaleURL})),m.RULE(),m.COMMAND(["About","About MathJax"],a.About),m.COMMAND(["Help","MathJax Help"],a.Help));if(a.isMobile){(function(){var s=p.settings;var r=a.menu.Find("Math Settings","Zoom Trigger").menu;r.items[0].disabled=r.items[1].disabled=true;if(s.zoom==="Hover"||s.zoom=="Click"){s.zoom="None"}r.items=r.items.slice(0,4);if(navigator.appVersion.match(/[ (]Android[) ]/)){a.ITEM.SUBMENU.Augment({marker:"»"})}})()}a.CreateLocaleMenu();a.CreateAnnotationMenu()});a.showRenderer=function(r){a.cookie.showRenderer=p.showRenderer=r;a.saveCookie();a.menu.Find("Math Settings","Math Renderer").hidden=!r};a.showMathPlayer=function(r){a.cookie.showMathPlayer=p.showMathPlayer=r;a.saveCookie();a.menu.Find("Math Settings","MathPlayer").hidden=!r};a.showFontMenu=function(r){a.cookie.showFontMenu=p.showFontMenu=r;a.saveCookie();a.menu.Find("Math Settings","Font Preference").hidden=!r};a.showContext=function(r){a.cookie.showContext=p.showContext=r;a.saveCookie();a.menu.Find("Math Settings","Contextual Menu").hidden=!r};a.showDiscoverable=function(r){a.cookie.showDiscoverable=p.showDiscoverable=r;a.saveCookie();a.menu.Find("Math Settings","Highlight on Hover").hidden=!r;a.menu.Find("Math Settings","discover_rule").hidden=!r};a.showLocale=function(r){a.cookie.showLocale=p.showLocale=r;a.saveCookie();a.menu.Find("Language").hidden=!r};MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){if(!MathJax.OutputJax["HTML-CSS"].config.imageFont){a.menu.Find("Math Settings","Font Preference","TeX (image)").disabled=true}});f.Queue(c.Register.StartupHook("End Config",{}),["getImages",a],["Styles",k,p.styles],["Post",c.Startup.signal,"MathMenu Ready"],["loadComplete",k,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.CallBack,MathJax.OutputJax);MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"2.4.0",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.attr&&this.root.attr.mode){if(!this.root.display&&this.root.attr.mode==="display"){this.root.display="block";this.root.attrNames.push("display")}delete this.root.attr.mode;for(var b=0,a=this.root.attrNames.length;b<a;b++){if(this.root.attrNames[b]==="mode"){this.root.attrNames.splice(b,1);break}}}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",UPDIAGONALARROW:"updiagonalarrow",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",PHASORANGLE:"phasorangle",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},TEXCLASSNAMES:["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"],copyAttributes:{fontfamily:true,fontsize:true,fontweight:true,fontstyle:true,color:true,background:true,id:true,"class":true,href:true,style:true},skipAttributes:{texClass:true,useHeight:true,texprimestyle:true},copyAttributeNames:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"],Error:function(d,e){var c=this.merror(d),b=MathJax.Localization.fontDirection(),a=MathJax.Localization.fontFamily();
if(e){c=c.With(e)}if(b||a){c=this.mstyle(c);if(b){c.dir=b}if(a){c.style.fontFamily="font-family: "+a}}return c}});(function(a){a.mbase=MathJax.Object.Subclass({type:"base",isToken:false,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT},noInherit:{},noInheritAttribute:{texClass:true},linebreakContainer:false,Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:true,notParent:true}))}this.Append.apply(this,arguments)},With:function(e){for(var f in e){if(e.hasOwnProperty(f)){this[f]=e[f]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var f=0,e=arguments.length;f<e;f++){this.SetData(this.data.length,arguments[f])}}},SetData:function(e,f){if(f!=null){if(!(f instanceof a.mbase)){f=this.isToken||this.isChars?a.chars(f):a.mtext(f)}f.parent=this;f.setInherit(this.inheritFromMe?this:this.inherit)}this.data[e]=f},Parent:function(){var e=this.parent;while(e&&e.notParent){e=e.parent}return e},Get:function(f,k){if(this[f]!=null){return this[f]}if(this.attr&&this.attr[f]!=null){return this.attr[f]}var g=this.Parent();if(g&&g["adjustChild_"+f]!=null){return g["adjustChild_"+f](this.childPosition(),k)}var j=this.inherit;var e=j;while(j){var i=j[f];if(i==null&&j.attr){i=j.attr[f]}if(i!=null&&j.noInheritAttribute&&!j.noInheritAttribute[f]){var h=j.noInherit[this.type];if(!(h&&h[f])){return i}}e=j;j=j.inherit}if(!k){if(this.defaults[f]===a.AUTO){return this.autoDefault(f)}if(this.defaults[f]!==a.INHERIT&&this.defaults[f]!=null){return this.defaults[f]}if(e){return e.defaults[f]}}return null},hasValue:function(e){return this.Get(e,true)!=null},getValues:function(){var f={};for(var g=0,e=arguments.length;g<e;g++){f[arguments[g]]=this.Get(arguments[g])}return f},adjustChild_scriptlevel:function(f,e){return this.Get("scriptlevel",e)},adjustChild_displaystyle:function(f,e){return this.Get("displaystyle",e)},adjustChild_texprimestyle:function(f,e){return this.Get("texprimestyle",e)},childPosition:function(){var h=this,g=h.parent;while(g.notParent){h=g;g=h.parent}for(var f=0,e=g.data.length;f<e;f++){if(g.data[f]===h){return f}}return null},setInherit:function(g){if(g!==this.inherit&&this.inherit==null){this.inherit=g;for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&this.data[f].setInherit){this.data[f].setInherit(g)}}}},setTeXclass:function(e){this.getPrevClass(e);return typeof this.texClass!=="undefined"?this:e},getPrevClass:function(e){if(e){this.prevClass=e.Get("texClass");this.prevLevel=e.Get("scriptlevel")}},updateTeXclass:function(e){if(e){this.prevClass=e.prevClass;delete e.prevClass;this.prevLevel=e.prevLevel;delete e.prevLevel;this.texClass=e.Get("texClass")}},texSpacing:function(){var f=this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE;var e=this.Get("texClass")||a.TEXCLASS.ORD;if(f===a.TEXCLASS.NONE||e===a.TEXCLASS.NONE){return""}if(f===a.TEXCLASS.VCENTER){f=a.TEXCLASS.ORD}if(e===a.TEXCLASS.VCENTER){e=a.TEXCLASS.ORD}var g=this.TEXSPACE[f][e];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&g>=0){return""}return this.TEXSPACELENGTH[Math.abs(g)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(e){return""},isSpacelike:function(){return false},isEmbellished:function(){return false},Core:function(){return this},CoreMO:function(){return this},hasNewline:function(){if(this.isEmbellished()){return this.CoreMO().hasNewline()}if(this.isToken||this.linebreakContainer){return false}for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&this.data[f].hasNewline()){return true}}return false},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"},getAnnotation:function(){return null}},{childrenSpacelike:function(){for(var f=0,e=this.data.length;f<e;f++){if(!this.data[f].isSpacelike()){return false}}return true},childEmbellished:function(){return this.data[0]&&this.data[0].isEmbellished()},childCore:function(){return this.data[0]},childCoreMO:function(){return this.data[0]?this.data[0].CoreMO():null},setChildTeXclass:function(e){if(this.data[0]){e=this.data[0].setTeXclass(e);this.updateTeXclass(this.data[0])}return e},setBaseTeXclasses:function(g){this.getPrevClass(g);this.texClass=null;if(this.data[0]){if(this.isEmbellished()||this.data[0].isa(a.mi)){g=this.data[0].setTeXclass(g);this.updateTeXclass(this.Core())}else{this.data[0].setTeXclass();g=this}}else{g=this}for(var f=1,e=this.data.length;f<e;f++){if(this.data[f]){this.data[f].setTeXclass()}}return g},setSeparateTeXclasses:function(g){this.getPrevClass(g);for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]){this.data[f].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT},autoDefault:function(f){if(f==="mathvariant"){var e=(this.data[0]||"").toString();return e.length===1||e.length===2&&e.charCodeAt(0)>=55296&&e.charCodeAt(0)<56320?a.VARIANT.ITALIC:a.VARIANT.NORMAL}return""},setTeXclass:function(f){this.getPrevClass(f);var e=this.data.join("");if(e.length>1&&e.match(/^[a-z][a-z0-9]*$/i)&&this.texClass===a.TEXCLASS.ORD){this.texClass=a.TEXCLASS.OP;this.autoOP=true}return this}});a.mn=a.mbase.Subclass({type:"mn",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:true,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:false,separator:false,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:false,symmetric:false,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:false,movablelimits:false,accent:false,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(g,n){var l=this.def;if(!l){if(g==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var k=this.data.join("");var f=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var h=0,e=f.length;h<e;h++){var j=this.OPTABLE[f[h]][k];if(j){l=this.makeDef(j);break}}if(!l){l=this.CheckRange(k)}if(!l&&n){l={}}else{if(!l){l=MathJax.Hub.Insert({},this.defaultDef)}l.form=f[0];this.def=l}}this.useMMLspacing&=~(this.SPACE_ATTR[g]||0);if(l[g]!=null){return l[g]}else{if(!n){return this.defaultDef[g]}}return""},CheckRange:function(j){var k=j.charCodeAt(0);if(k>=55296&&k<56320){k=(k-55296<<10)+(j.charCodeAt(1)-56320)+65536}for(var g=0,e=this.RANGES.length;g<e&&this.RANGES[g][0]<=k;g++){if(k<=this.RANGES[g][1]){if(this.RANGES[g][3]){var f=a.optableDir+"/"+this.RANGES[g][3]+".js";this.RANGES[g][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(f))}var h=a.TEXCLASSNAMES[this.RANGES[g][2]];h=this.OPTABLE.infix[j]=a.mo.OPTYPES[h==="BIN"?"BIN3":h];return this.makeDef(h)}}return null},makeDef:function(f){if(f[2]==null){f[2]=this.defaultDef.texClass}if(!f[3]){f[3]={}}var e=MathJax.Hub.Insert({},f[3]);e.lspace=this.SPACE[f[0]];e.rspace=this.SPACE[f[1]];e.texClass=f[2];if(e.texClass===a.TEXCLASS.REL&&(this.movablelimits||this.data.join("").match(/^[a-z]+$/i))){e.texClass=a.TEXCLASS.OP}return e},getForm:function(){var e=this,g=this.parent,f=this.Parent();while(f&&f.isEmbellished()){e=g;g=f.parent;f=f.Parent()}if(g&&g.type==="mrow"&&g.NonSpaceLength()!==1){if(g.FirstNonSpace()===e){return a.FORM.PREFIX}if(g.LastNonSpace()===e){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return true},hasNewline:function(){return this.Get("linebreak")===a.LINEBREAK.NEWLINE},setTeXclass:function(f){var e=this.getValues("form","lspace","rspace","fence");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}if(e.fence&&!this.texClass){if(e.form===a.FORM.PREFIX){this.texClass=a.TEXCLASS.OPEN}if(e.form===a.FORM.POSTFIX){this.texClass=a.TEXCLASS.CLOSE}}this.texClass=this.Get("texClass");if(this.data.join("")==="⁡"){if(f){f.texClass=a.TEXCLASS.OP;f.fnOP=true}this.texClass=this.prevClass=a.TEXCLASS.NONE;return f}return this.adjustTeXclass(f)},adjustTeXclass:function(e){if(this.texClass===a.TEXCLASS.NONE){return e}if(e){if(e.autoOP&&(this.texClass===a.TEXCLASS.BIN||this.texClass===a.TEXCLASS.REL)){e.texClass=a.TEXCLASS.ORD}this.prevClass=e.texClass||a.TEXCLASS.ORD;this.prevLevel=e.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){e.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:true,isSpacelike:function(){return true},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:true,isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},hasDimAttr:function(){return this.hasValue("width")||this.hasValue("height")||this.hasValue("depth")},hasNewline:function(){return!this.hasDimAttr()&&this.Get("linebreak")===a.LINEBREAK.NEWLINE}});a.ms=a.mbase.Subclass({type:"ms",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:true,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:false,notParent:false,isEmbellished:function(){var f=false;for(var g=0,e=this.data.length;g<e;g++){if(this.data[g]==null){continue}if(this.data[g].isEmbellished()){if(f){return false}f=true;this.core=g}else{if(!this.data[g].isSpacelike()){return false}}}return f},NonSpaceLength:function(){var g=0;for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&!this.data[f].isSpacelike()){g++}}return g},FirstNonSpace:function(){for(var f=0,e=this.data.length;f<e;f++){if(this.data[f]&&!this.data[f].isSpacelike()){return this.data[f]}}return null},LastNonSpace:function(){for(var e=this.data.length-1;e>=0;e--){if(this.data[0]&&!this.data[e].isSpacelike()){return this.data[e]}}return null},Core:function(){if(!this.isEmbellished()||typeof this.core==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!this.isEmbellished()||typeof this.core==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(g){var f,e=this.data.length;if((this.open||this.close)&&(!g||!g.fnOP)){this.getPrevClass(g);for(f=0;f<e;f++){if(this.data[f]){g=this.data[f].setTeXclass(g)}}this.texClass=a.TEXCLASS.INNER;return this}else{for(f=0;f<e;f++){if(this.data[f]){g=this.data[f].setTeXclass(g)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return g}},getAnnotation:function(e){if(this.data.length!=1){return null}return this.data[0].getAnnotation(e)}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,linebreakContainer:true,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:false},adjustChild_displaystyle:function(e){return false},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");if(!this.Get("displaystyle")||e>0){e++}return e},adjustChild_texprimestyle:function(e){if(e==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(e){return true}});a.mroot=a.mbase.Subclass({type:"mroot",linebreakContainer:true,texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(e){if(e===1){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");if(f===1){e+=2}return e},adjustChild_texprimestyle:function(e){if(e===0){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:true,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,dir:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(g){var f=this.scriptlevel;if(f==null){f=this.Get("scriptlevel")}else{if(String(f).match(/^ *[-+]/)){delete this.scriptlevel;var e=this.Get("scriptlevel");this.scriptlevel=f;f=e+parseInt(f)}}return f},inheritFromMe:true,noInherit:{mpadded:{width:true,height:true,depth:true,lspace:true,voffset:true},mtable:{width:true,height:true,depth:true,align:true}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:true,linebreakContainer:true,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:true,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(h){this.getPrevClass(h);var f=this.getValues("open","close","separators");f.open=f.open.replace(/[ \t\n\r]/g,"");f.close=f.close.replace(/[ \t\n\r]/g,"");f.separators=f.separators.replace(/[ \t\n\r]/g,"");if(f.open!==""){this.SetData("open",a.mo(f.open).With({fence:true,form:a.FORM.PREFIX,texClass:a.TEXCLASS.OPEN}));this.data.open.useMMLspacing&=~this.data.open.SPACE_ATTR.form;h=this.data.open.setTeXclass(h)}if(f.separators!==""){while(f.separators.length<this.data.length){f.separators+=f.separators.charAt(f.separators.length-1)}}if(this.data[0]){h=this.data[0].setTeXclass(h)}for(var g=1,e=this.data.length;g<e;g++){if(this.data[g]){if(f.separators!==""){this.SetData("sep"+g,a.mo(f.separators.charAt(g-1)).With({separator:true}));h=this.data["sep"+g].setTeXclass(h)}h=this.data[g].setTeXclass(h)}}if(f.close!==""){this.SetData("close",a.mo(f.close).With({fence:true,form:a.FORM.POSTFIX,texClass:a.TEXCLASS.CLOSE}));this.data.close.useMMLspacing&=~this.data.close.SPACE_ATTR.form;h=this.data.close.setTeXclass(h)}this.updateTeXclass(this.data.open);this.texClass=a.TEXCLASS.INNER;return h}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:true,linebreakContainer:true,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(e){if(e==="texClass"){return this.isEmbellished()?this.CoreMO().Get(e):a.TEXCLASS.ORD}return 0},adjustChild_displaystyle:function(e){if(e>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(f){var e=this.Get("scriptlevel");if(f>0){e++}return e},adjustChild_texprimestyle:function(e){if(e===this.sub){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(e){if(e%2===1){return true}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(e){if(e==="texClass"){return this.isEmbellished()?this.CoreMO().Get(e):a.TEXCLASS.ORD}if(e==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(e==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return false},adjustChild_displaystyle:function(e){if(e>0){return false}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");var e=this.data[this.base]&&!this.Get("displaystyle")&&this.data[this.base].CoreMO().Get("movablelimits");if(g==this.under&&(e||!this.Get("accentunder"))){f++}if(g==this.over&&(e||!this.Get("accent"))){f++}return f},adjustChild_texprimestyle:function(e){if(e===this.base&&this.data[this.over]){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:true,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:false,equalcolumns:false,displaystyle:false,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:true,noInherit:{mover:{align:true},munder:{align:true},munderover:{align:true},mtable:{align:true,rowalign:true,columnalign:true,groupalign:true,alignmentscope:true,columnwidth:true,width:true,rowspacing:true,columnspacing:true,rowlines:true,columnlines:true,frame:true,framespacing:true,equalrows:true,equalcolumns:true,side:true,minlabelspacing:true,texClass:true,useHeight:1}},linebreakContainer:true,Append:function(){for(var f=0,e=arguments.length;f<e;f++){if(!(arguments[f]instanceof a.mtr||arguments[f]instanceof a.mlabeledtr)){arguments[f]=a.mtd(arguments[f])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{rowalign:true,columnalign:true,groupalign:true},mtable:{rowalign:true,columnalign:true,groupalign:true}},linebreakContainer:true,Append:function(){for(var f=0,e=arguments.length;f<e;f++){if(!(arguments[f]instanceof a.mtd)){arguments[f]=a.mtd(arguments[f])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:true,linebreakContainer:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return true},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:true,noInherit:{mrow:{groupalign:true},mtable:{groupalign:true}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return true}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(e){if(this.Get("actiontype")===a.ACTIONTYPE.TOOLTIP&&this.data[1]){this.data[1].setTeXclass()}return this.selected().setTeXclass(e)}});a.semantics=a.mbase.Subclass({type:"semantics",notParent:true,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass,getAnnotation:function(g){var l=MathJax.Hub.config.MathMenu.semanticsAnnotations[g];if(l){for(var h=0,e=this.data.length;h<e;h++){var k=this.data[h].Get("encoding");if(k){for(var f=0,o=l.length;f<o;f++){if(l[f]===k){return this.data[h]}}}}}return null}});a.annotation=a.mbase.Subclass({type:"annotation",isChars:true,linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",linebreakContainer:true,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,dir:"ltr",scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:false},autoDefault:function(e){if(e==="displaystyle"){return this.Get("display")==="block"}return""},linebreakContainer:true,setTeXclass:a.mbase.setChildTeXclass,getAnnotation:function(e){if(this.data.length!=1){return null}return this.data[0].getAnnotation(e)}});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var e=this.value();if(e<=65535){return String.fromCharCode(e)}e-=65536;return String.fromCharCode((e>>10)+55296)+String.fromCharCode((e&1023)+56320)}});a.xml=a.mbase.Subclass({type:"xml",Init:function(){this.div=document.createElement("div");return this.SUPER(arguments).Init.apply(this,arguments)},Append:function(){for(var f=0,e=arguments.length;f<e;f++){var g=this.Import(arguments[f]);this.data.push(g);this.div.appendChild(g)}},Import:function(j){if(document.importNode){return document.importNode(j,true)}var f,g,e;if(j.nodeType===1){f=document.createElement(j.nodeName);for(g=0,e=j.attributes.length;g<e;g++){var h=j.attributes[g];if(h.specified&&h.nodeValue!=null&&h.nodeValue!=""){f.setAttribute(h.nodeName,h.nodeValue)}if(h.nodeName==="style"){f.style.cssText=h.nodeValue}}if(j.className){f.className=j.className}}else{if(j.nodeType===3||j.nodeType===4){f=document.createTextNode(j.nodeValue)}else{if(j.nodeType===8){f=document.createComment(j.nodeValue)}else{return document.createTextNode("")}}}for(g=0,e=j.childNodes.length;g<e;g++){f.appendChild(this.Import(j.childNodes[g]))}return f},value:function(){return this.div},toString:function(){return this.div.innerHTML}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:true,notParent:true,texClass:a.TEXCLASS.ORD,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,isEmbellished:a.mbase.childEmbellished,setTeXclass:function(e){this.data[0].setTeXclass();return this.adjustTeXclass(e)},adjustTeXclass:a.mo.prototype.adjustTeXclass});a.NULL=a.mbase().With({type:"null"});var b=a.TEXCLASS;var d={ORD:[0,0,b.ORD],ORD11:[1,1,b.ORD],ORD21:[2,1,b.ORD],ORD02:[0,2,b.ORD],ORD55:[5,5,b.ORD],OP:[1,2,b.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,b.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,b.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,b.OP,{largeop:true,symmetric:true}],BIN3:[3,3,b.BIN],BIN4:[4,4,b.BIN],BIN01:[0,1,b.BIN],BIN5:[5,5,b.BIN],TALLBIN:[4,4,b.BIN,{stretchy:true}],BINOP:[4,4,b.BIN,{largeop:true,movablelimits:true}],REL:[5,5,b.REL],REL1:[1,1,b.REL,{stretchy:true}],REL4:[4,4,b.REL],RELSTRETCH:[5,5,b.REL,{stretchy:true}],RELACCENT:[5,5,b.REL,{accent:true}],WIDEREL:[5,5,b.REL,{accent:true,stretchy:true}],OPEN:[0,0,b.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,b.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,b.INNER],PUNCT:[0,3,b.PUNCT],ACCENT:[0,0,b.ORD,{accent:true}],WIDEACCENT:[0,0,b.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,b.REL,"BasicLatin"],[160,255,b.ORD,"Latin1Supplement"],[256,383,b.ORD],[384,591,b.ORD],[688,767,b.ORD,"SpacingModLetters"],[768,879,b.ORD,"CombDiacritMarks"],[880,1023,b.ORD,"GreekAndCoptic"],[7680,7935,b.ORD],[8192,8303,b.PUNCT,"GeneralPunctuation"],[8304,8351,b.ORD],[8352,8399,b.ORD],[8400,8447,b.ORD,"CombDiactForSymbols"],[8448,8527,b.ORD,"LetterlikeSymbols"],[8528,8591,b.ORD],[8592,8703,b.REL,"Arrows"],[8704,8959,b.BIN,"MathOperators"],[8960,9215,b.ORD,"MiscTechnical"],[9312,9471,b.ORD],[9472,9631,b.ORD],[9632,9727,b.ORD,"GeometricShapes"],[9984,10175,b.ORD,"Dingbats"],[10176,10223,b.ORD,"MiscMathSymbolsA"],[10224,10239,b.REL,"SupplementalArrowsA"],[10496,10623,b.REL,"SupplementalArrowsB"],[10624,10751,b.ORD,"MiscMathSymbolsB"],[10752,11007,b.BIN,"SuppMathOperators"],[11008,11263,b.ORD,"MiscSymbolsAndArrows"],[119808,120831,b.ORD]],OPTABLE:{prefix:{"∀":d.ORD21,"∂":d.ORD21,"∃":d.ORD21,"∇":d.ORD21,"∏":d.OP,"∐":d.OP,"∑":d.OP,"−":d.BIN01,"∓":d.BIN01,"√":[1,1,b.ORD,{stretchy:true}],"∠":d.ORD,"∫":d.INTEGRAL,"∮":d.INTEGRAL,"⋀":d.OP,"⋁":d.OP,"⋂":d.OP,"⋃":d.OP,"⌈":d.OPEN,"⌊":d.OPEN,"⟨":d.OPEN,"⟮":d.OPEN,"⨀":d.OP,"⨁":d.OP,"⨂":d.OP,"⨄":d.OP,"⨆":d.OP,"¬":d.ORD21,"±":d.BIN01,"(":d.OPEN,"+":d.BIN01,"-":d.BIN01,"[":d.OPEN,"{":d.OPEN,"|":d.OPEN},postfix:{"!":[1,0,b.CLOSE],"&":d.ORD,"′":d.ORD02,"‾":d.WIDEACCENT,"⌉":d.CLOSE,"⌋":d.CLOSE,"⏞":d.WIDEACCENT,"⏟":d.WIDEACCENT,"♭":d.ORD02,"♮":d.ORD02,"♯":d.ORD02,"⟩":d.CLOSE,"⟯":d.CLOSE,"ˆ":d.WIDEACCENT,"ˇ":d.WIDEACCENT,"ˉ":d.WIDEACCENT,"ˊ":d.ACCENT,"ˋ":d.ACCENT,"˘":d.ACCENT,"˙":d.ACCENT,"˜":d.WIDEACCENT,"̂":d.WIDEACCENT,"¨":d.ACCENT,"¯":d.WIDEACCENT,")":d.CLOSE,"]":d.CLOSE,"^":d.WIDEACCENT,_:d.WIDEACCENT,"`":d.ACCENT,"|":d.CLOSE,"}":d.CLOSE,"~":d.WIDEACCENT},infix:{"":d.ORD,"%":[3,3,b.ORD],"•":d.BIN4,"…":d.INNER,"⁄":d.TALLBIN,"⁡":d.ORD,"⁢":d.ORD,"⁣":[0,0,b.ORD,{linebreakstyle:"after",separator:true}],"⁤":d.ORD,"←":d.WIDEREL,"↑":d.RELSTRETCH,"→":d.WIDEREL,"↓":d.RELSTRETCH,"↔":d.WIDEREL,"↕":d.RELSTRETCH,"↖":d.RELSTRETCH,"↗":d.RELSTRETCH,"↘":d.RELSTRETCH,"↙":d.RELSTRETCH,"↦":d.WIDEREL,"↩":d.WIDEREL,"↪":d.WIDEREL,"↼":d.WIDEREL,"↽":d.WIDEREL,"⇀":d.WIDEREL,"⇁":d.WIDEREL,"⇌":d.WIDEREL,"⇐":d.WIDEREL,"⇑":d.RELSTRETCH,"⇒":d.WIDEREL,"⇓":d.RELSTRETCH,"⇔":d.WIDEREL,"⇕":d.RELSTRETCH,"∈":d.REL,"∉":d.REL,"∋":d.REL,"−":d.BIN4,"∓":d.BIN4,"∕":d.TALLBIN,"∖":d.BIN4,"∗":d.BIN4,"∘":d.BIN4,"∙":d.BIN4,"∝":d.REL,"∣":d.REL,"∥":d.REL,"∧":d.BIN4,"∨":d.BIN4,"∩":d.BIN4,"∪":d.BIN4,"∼":d.REL,"≀":d.BIN4,"≃":d.REL,"≅":d.REL,"≈":d.REL,"≍":d.REL,"≐":d.REL,"≠":d.REL,"≡":d.REL,"≤":d.REL,"≥":d.REL,"≪":d.REL,"≫":d.REL,"≺":d.REL,"≻":d.REL,"⊂":d.REL,"⊃":d.REL,"⊆":d.REL,"⊇":d.REL,"⊎":d.BIN4,"⊑":d.REL,"⊒":d.REL,"⊓":d.BIN4,"⊔":d.BIN4,"⊕":d.BIN4,"⊖":d.BIN4,"⊗":d.BIN4,"⊘":d.BIN4,"⊙":d.BIN4,"⊢":d.REL,"⊣":d.REL,"⊤":d.ORD55,"⊥":d.REL,"⊨":d.REL,"⋄":d.BIN4,"⋅":d.BIN4,"⋆":d.BIN4,"⋈":d.REL,"⋮":d.ORD55,"⋯":d.INNER,"⋱":[5,5,b.INNER],"△":d.BIN4,"▵":d.BIN4,"▹":d.BIN4,"▽":d.BIN4,"▿":d.BIN4,"◃":d.BIN4,"❘":d.REL,"⟵":d.WIDEREL,"⟶":d.WIDEREL,"⟷":d.WIDEREL,"⟸":d.WIDEREL,"⟹":d.WIDEREL,"⟺":d.WIDEREL,"⟼":d.WIDEREL,"⨯":d.BIN4,"⨿":d.BIN4,"⪯":d.REL,"⪰":d.REL,"±":d.BIN4,"·":d.BIN4,"×":d.BIN4,"÷":d.BIN4,"*":d.BIN3,"+":d.BIN4,",":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"-":d.BIN4,".":[3,3,b.ORD],"/":d.ORD11,":":[1,2,b.REL],";":[0,3,b.PUNCT,{linebreakstyle:"after",separator:true}],"<":d.REL,"=":d.REL,">":d.REL,"?":[1,1,b.CLOSE],"\\":d.ORD,"^":d.ORD11,_:d.ORD11,"|":[2,2,b.ORD,{fence:true,stretchy:true,symmetric:true}],"#":d.ORD,$:d.ORD,".":[0,3,b.PUNCT,{separator:true}],"ʹ":d.ORD,"̀":d.ACCENT,"́":d.ACCENT,"̃":d.WIDEACCENT,"̄":d.ACCENT,"̆":d.ACCENT,"̇":d.ACCENT,"̈":d.ACCENT,"̌":d.ACCENT,"̲":d.WIDEACCENT,"̸":d.REL4,"―":[0,0,b.ORD,{stretchy:true}],"‗":[0,0,b.ORD,{stretchy:true}],"†":d.BIN3,"‡":d.BIN3,"⃗":d.ACCENT,"ℑ":d.ORD,"ℓ":d.ORD,"℘":d.ORD,"ℜ":d.ORD,"∅":d.ORD,"∞":d.ORD,"⌅":d.BIN3,"⌆":d.BIN3,"⌢":d.REL4,"⌣":d.REL4,"〈":d.OPEN,"〉":d.CLOSE,"⎪":d.ORD,"⎯":[0,0,b.ORD,{stretchy:true}],"⎰":d.OPEN,"⎱":d.CLOSE,"─":d.ORD,"◯":d.BIN3,"♠":d.ORD,"♡":d.ORD,"♢":d.ORD,"♣":d.ORD,"〈":d.OPEN,"〉":d.CLOSE,"︷":d.WIDEACCENT,"︸":d.WIDEACCENT}}},{OPTYPES:d});var c=a.mo.prototype.OPTABLE;c.infix["^"]=d.WIDEREL;c.infix._=d.WIDEREL;c.prefix["∣"]=d.OPEN;c.prefix["∥"]=d.OPEN;c.postfix["∣"]=d.CLOSE;c.postfix["∥"]=d.CLOSE})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="2.4.0";var a=MathJax.ElementJax.mml;SETTINGS=MathJax.Hub.config.menuSettings;a.mbase.Augment({toMathML:function(k){var g=this.inferred&&this.parent.inferRow;if(k==null){k=""}var e=this.type,d=this.toMathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[],h=this.isToken?"":k+(g?"":"  ");
for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken&&!this.isChars){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||j.length===1&&j[0]===""){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},toMathMLattributes:function(){var j=[],g=this.defaults;var c=this.attrNames||a.copyAttributeNames,l=a.skipAttributes;if(this.type==="math"&&(!this.attr||!this.attr.xmlns)){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(!this.attrNames){if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=d==="open"||d==="close"||d==="form";if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.toMathMLattribute(k)+'"')}this[d]=k}}}}for(var h=0,f=c.length;h<f;h++){if(c[h]==="class"){continue}k=(this.attr||{})[c[h]];if(k==null){k=this[c[h]]}if(k!=null){j.push(c[h]+'="'+this.toMathMLquote(k)+'"')}}this.toMathMLclass(j);if(j.length){return" "+j.join(" ")}else{return""}},toMathMLclass:function(c){var e=[];if(this["class"]){e.push(this["class"])}if(this.isa(a.TeXAtom)&&SETTINGS.texHints){var d=["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER","VCENTER"][this.texClass];if(d){e.push("MJX-TeXAtom-"+d)}}if(this.mathvariant&&this.toMathMLvariants[this.mathvariant]){e.push("MJX"+this.mathvariant)}if(this.variantForm){e.push("MJX-variant")}if(e.length){c.unshift('class="'+e.join(" ")+'"')}},toMathMLattribute:function(c){if(typeof c==="string"&&c.replace(/ /g,"").match(/^(([-+])?(\d+(\.\d*)?|\.\d+))mu$/)){return RegExp.$2+(1/18*RegExp.$3).toFixed(3).replace(/\.?0+$/,"")+"em"}else{if(this.toMathMLvariants[c]){return this.toMathMLvariants[c]}}return this.toMathMLquote(c)},toMathMLvariants:{"-tex-caligraphic":a.VARIANT.SCRIPT,"-tex-caligraphic-bold":a.VARIANT.BOLDSCRIPT,"-tex-oldstyle":a.VARIANT.NORMAL,"-tex-oldstyle-bold":a.VARIANT.BOLD,"-tex-mathit":a.VARIANT.ITALIC},toMathMLquote:function(f){f=String(f).split("");for(var g=0,d=f.length;g<d;g++){var k=f[g].charCodeAt(0);if(k<=55295||57344<=k){if(k<32||k>126){f[g]="&#x"+k.toString(16).toUpperCase()+";"}else{var j={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[f[g]];if(j){f[g]=j}}}else{if(g+1<d){var h=f[g+1].charCodeAt(0);var e=(k-55296<<10)+(h-56320)+65536;f[g]="&#x"+e.toString(16).toUpperCase()+";";f[g+1]="";g++}else{f[g]=""}}}return f.join("")}});a.math.Augment({toMathML:function(c,d){var f;if(c==null){c=""}if(d&&d.originalText&&SETTINGS.semantics){f=MathJax.InputJax[d.inputJax].annotationEncoding}var k=this.data[0]&&this.data[0].data.length>1;var n=this.type,j=this.toMathMLattributes();var h=[],l=c+(f?"    ":"")+(k?"  ":"");for(var g=0,e=this.data.length;g<e;g++){if(this.data[g]){h.push(this.data[g].toMathML(l))}else{h.push(l+"<mrow />")}}if(h.length===0||h.length===1&&h[0]===""){if(!f){return"<"+n+j+" />"}h.push(l+"<mrow />")}if(f){if(k){h.unshift(c+"    <mrow>");h.push(c+"    </mrow>")}h.unshift(c+"  <semantics>");h.push(c+'    <annotation encoding="'+f+'">'+d.originalText+"</annotation>");h.push(c+"  </semantics>")}return c+"<"+n+j+">\n"+h.join("\n")+"\n"+c+"</"+n+">"}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.toMathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(d){var c=this.toMathMLattributes();if(!c&&this.data[0].data.length===1){return d.substr(2)+this.data[0].toMathML(d)}return d+"<mrow"+c+">\n"+this.data[0].toMathML(d+"  ")+"\n"+d+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.toMathMLquote(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});a.xml.Augment({toMathML:function(c){return(c||"")+this.toString()}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");(function(c,d){var a;var b=function(e){return MathJax.Localization._.apply(MathJax.Localization,[["MathML",e]].concat([].slice.call(arguments,1)))};c.Parse=MathJax.Object.Subclass({Init:function(e){this.Parse(e)},Parse:function(g){var h;if(typeof g!=="string"){h=g.parentNode}else{h=c.ParseXML(this.preProcessMath.call(this,g));if(h==null){c.Error(["ErrorParsingMathML","Error parsing MathML"])}}var f=h.getElementsByTagName("parsererror")[0];if(f){c.Error(["ParsingError","Error parsing MathML: %1",f.textContent.replace(/This page.*?errors:|XML Parsing Error: |Below is a rendering of the page.*/g,"")])}if(h.childNodes.length!==1){c.Error(["MathMLSingleElement","MathML must be formed by a single element"])}if(h.firstChild.nodeName.toLowerCase()==="html"){var e=h.getElementsByTagName("h1")[0];if(e&&e.textContent==="XML parsing error"&&e.nextSibling){c.Error(["ParsingError","Error parsing MathML: %1",String(e.nextSibling.nodeValue).replace(/fatal parsing error: /,"")])}}if(h.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")!=="math"){c.Error(["MathMLRootElement","MathML must be formed by a <math> element, not %1","<"+h.firstChild.nodeName+">"])}this.mml=this.MakeMML(h.firstChild)},MakeMML:function(h){var i=String(h.getAttribute("class")||"");var f,g=h.nodeName.toLowerCase().replace(/^[a-z]+:/,"");var e=i.match(/(^| )MJX-TeXAtom-([^ ]*)/);if(e){f=this.TeXAtom(e[2])}else{if(!(a[g]&&a[g].isa&&a[g].isa(a.mbase))){MathJax.Hub.signal.Post(["MathML Jax - unknown node type",g]);return a.Error(b("UnknownNodeType","Unknown node type: %1",g))}else{f=a[g]()}}this.AddAttributes(f,h);this.CheckClass(f,f["class"]);this.AddChildren(f,h);if(c.config.useMathMLspacing){f.useMMLspacing=8}return f},TeXAtom:function(f){var e=a.TeXAtom().With({texClass:a.TEXCLASS[f]});if(e.texClass===a.TEXCLASS.OP){e.movesupsub=e.movablelimits=true}return e},CheckClass:function(f,h){h=(h||"").split(/ /);var j=[];for(var g=0,e=h.length;g<e;g++){if(h[g].substr(0,4)==="MJX-"){if(h[g]==="MJX-arrow"){if(!f.notation.match("/"+a.NOTATION.UPDIAGONALARROW+"/")){f.notation+=" "+a.NOTATION.UPDIAGONALARROW}}else{if(h[g]==="MJX-variant"){f.variantForm=true;if(!MathJax.Extension["TeX/AMSsymbols"]){MathJax.Hub.RestartAfter(MathJax.Ajax.Require("[MathJax]/extensions/TeX/AMSsymbols.js"))}}else{if(h[g].substr(0,11)!=="MJX-TeXAtom"){f.mathvariant=h[g].substr(3);if(f.mathvariant==="-tex-caligraphic-bold"||f.mathvariant==="-tex-oldstyle-bold"){if(!MathJax.Extension["TeX/boldsymbol"]){MathJax.Hub.RestartAfter(MathJax.Ajax.Require("[MathJax]/extensions/TeX/boldsymbol.js"))}}}}}}else{j.push(h[g])}}if(j.length){f["class"]=j.join(" ")}else{delete f["class"]}},AddAttributes:function(g,j){g.attr={};g.attrNames=[];for(var h=0,e=j.attributes.length;h<e;h++){var f=j.attributes[h].name;if(f=="xlink:href"){f="href"}if(f.match(/:/)){continue}if(f.match(/^_moz-math-((column|row)(align|line)|font-style)$/)){continue}var k=j.attributes[h].value;k=this.filterAttribute(f,k);if(k!=null){if(k.toLowerCase()==="true"){k=true}else{if(k.toLowerCase()==="false"){k=false}}if(g.defaults[f]!=null||a.copyAttributes[f]){g[f]=k}else{g.attr[f]=k}g.attrNames.push(f)}}},filterAttribute:function(e,f){return f},AddChildren:function(e,g){for(var k=0,j=g.childNodes.length;k<j;k++){var f=g.childNodes[k];if(f.nodeName==="#comment"){continue}if(f.nodeName==="#text"){if((e.isToken||e.isChars)&&!e.mmlSelfClosing){var o=f.nodeValue.replace(/&([a-z][a-z0-9]*);/gi,this.replaceEntity);e.Append(a.chars(this.trimSpace(o)))}else{if(f.nodeValue.match(/\S/)){c.Error(["UnexpectedTextNode","Unexpected text node: %1","'"+f.nodeValue+"'"])}}}else{if(e.type==="annotation-xml"){e.Append(a.xml(f))}else{var h=this.MakeMML(f);e.Append(h);if(h.mmlSelfClosing&&h.data.length){e.Append.apply(e,h.data);h.data=[]}}}}if(e.type==="mrow"&&e.data.length>=2){var l=e.data[0],n=e.data[e.data.length-1];if(l.type==="mo"&&l.Get("fence")&&n.type==="mo"&&n.Get("fence")){if(l.data[0]){e.open=l.data.join("")}if(n.data[0]){e.close=n.data.join("")}}}},preProcessMath:function(f){if(f.match(/^<[a-z]+:/i)&&!f.match(/^<[^<>]* xmlns:/)){f=f.replace(/^<([a-z]+)(:math)/i,'<$1$2 xmlns:$1="http://www.w3.org/1998/Math/MathML"')}var e=f.match(/^(<math( ('.*?'|".*?"|[^>])+)>)/i);if(e&&e[2].match(/ (?!xmlns=)[a-z]+=\"http:/i)){f=e[1].replace(/ (?!xmlns=)([a-z]+=(['"])http:.*?\2)/gi," xmlns:$1 $1")+f.substr(e[0].length)}if(f.match(/^<math/i)&&!f.match(/^<[^<>]* xmlns=/)){f=f.replace(/^<(math)/i,'<math xmlns="http://www.w3.org/1998/Math/MathML"')}f=f.replace(/^\s*(?:\/\/)?<!(--)?\[CDATA\[((.|\n)*)(\/\/)?\]\]\1>\s*$/,"$2");return f.replace(/&([a-z][a-z0-9]*);/gi,this.replaceEntity)},trimSpace:function(e){return e.replace(/[\t\n\r]/g," ").replace(/^ +/,"").replace(/ +$/,"").replace(/  +/g," ")},replaceEntity:function(g,f){if(f.match(/^(lt|amp|quot)$/)){return g}if(c.Parse.Entity[f]){return c.Parse.Entity[f]}var h=f.charAt(0).toLowerCase();var e=f.match(/^[a-zA-Z](fr|scr|opf)$/);if(e){h=e[1]}if(!c.Parse.loaded[h]){c.Parse.loaded[h]=true;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(c.entityDir+"/"+h+".js"))}return g}},{loaded:[]});c.Augment({sourceMenuTitle:["OriginalMathML","Original MathML"],prefilterHooks:MathJax.Callback.Hooks(true),postfilterHooks:MathJax.Callback.Hooks(true),Translate:function(e){if(!this.ParseXML){this.ParseXML=this.createParser()}var f,h,i={script:e};if(e.firstChild&&e.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")==="math"){i.math=e.firstChild;this.prefilterHooks.Execute(i);h=i.math}else{h=MathJax.HTML.getScript(e);if(d.isMSIE){h=h.replace(/(&nbsp;)+$/,"")}i.math=h;this.prefilterHooks.Execute(i);h=i.math}try{f=c.Parse(h).mml}catch(g){if(!g.mathmlError){throw g}f=this.formatError(g,h,e)}i.math=a(f);this.postfilterHooks.Execute(i);return i.math},prefilterMath:function(f,e){return f},prefilterMathML:function(f,e){return f},formatError:function(h,g,e){var f=h.message.replace(/\n.*/,"");MathJax.Hub.signal.Post(["MathML Jax - parse error",f,g,e]);return a.Error(f)},Error:function(e){if(e instanceof Array){e=b.apply(b,e)}throw MathJax.Hub.Insert(Error(e),{mathmlError:true})},parseDOM:function(e){return this.parser.parseFromString(e,"text/xml")},parseMS:function(e){return this.parser.loadXML(e)?this.parser:null},parseDIV:function(e){this.div.innerHTML=e.replace(/<([a-z]+)([^>]*)\/>/g,"<$1$2></$1>");return this.div},parseError:function(e){return null},createMSParser:function(){var j=null;var f=["MSXML2.DOMDocument.6.0","MSXML2.DOMDocument.5.0","MSXML2.DOMDocument.4.0","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument.2.0","Microsoft.XMLDOM"];for(var g=0,e=f.length;g<e&&!j;g++){try{j=new ActiveXObject(f[g])}catch(h){}}return j},createParser:function(){if(window.DOMParser){this.parser=new DOMParser;return this.parseDOM}else{if(window.ActiveXObject){this.parser=this.createMSParser();if(!this.parser){MathJax.Localization.Try(this.parserCreationError);return this.parseError}this.parser.async=false;return this.parseMS}}this.div=MathJax.Hub.Insert(document.createElement("div"),{style:{visibility:"hidden",overflow:"hidden",height:"1px",position:"absolute",top:0}});if(!document.body.firstChild){document.body.appendChild(this.div)}else{document.body.insertBefore(this.div,document.body.firstChild)}return this.parseDIV},parserCreationError:function(){alert(b("CantCreateXMLParser","MathJax can't create an XML parser for MathML.  Check that\nthe 'Script ActiveX controls marked safe for scripting' security\nsetting is enabled (use the Internet Options item in the Tools\nmenu, and select the Security panel, then press the Custom Level\nbutton to check this).\n\nMathML equations will not be able to be processed by MathJax."))},Startup:function(){a=MathJax.ElementJax.mml;a.mspace.Augment({mmlSelfClosing:true});a.none.Augment({mmlSelfClosing:true});a.mprescripts.Augment({mmlSelfClosing:true})}});c.prefilterHooks.Add(function(e){e.math=typeof e.math==="string"?c.prefilterMath(e.math,e.script):c.prefilterMathML(e.math,e.script)});c.Parse.Entity={ApplyFunction:"⁡",Backslash:"∖",Because:"∵",Breve:"˘",Cap:"⋒",CenterDot:"·",CircleDot:"⊙",CircleMinus:"⊖",CirclePlus:"⊕",CircleTimes:"⊗",Congruent:"≡",ContourIntegral:"∮",Coproduct:"∐",Cross:"⨯",Cup:"⋓",CupCap:"≍",Dagger:"‡",Del:"∇",Delta:"Δ",Diamond:"⋄",DifferentialD:"ⅆ",DotEqual:"≐",DoubleDot:"¨",DoubleRightTee:"⊨",DoubleVerticalBar:"∥",DownArrow:"↓",DownLeftVector:"↽",DownRightVector:"⇁",DownTee:"⊤",Downarrow:"⇓",Element:"∈",EqualTilde:"≂",Equilibrium:"⇌",Exists:"∃",ExponentialE:"ⅇ",FilledVerySmallSquare:"▪",ForAll:"∀",Gamma:"Γ",Gg:"⋙",GreaterEqual:"≥",GreaterEqualLess:"⋛",GreaterFullEqual:"≧",GreaterLess:"≷",GreaterSlantEqual:"⩾",GreaterTilde:"≳",Hacek:"ˇ",Hat:"^",HumpDownHump:"≎",HumpEqual:"≏",Im:"ℑ",ImaginaryI:"ⅈ",Integral:"∫",Intersection:"⋂",InvisibleComma:"⁣",InvisibleTimes:"⁢",Lambda:"Λ",Larr:"↞",LeftAngleBracket:"⟨",LeftArrow:"←",LeftArrowRightArrow:"⇆",LeftCeiling:"⌈",LeftDownVector:"⇃",LeftFloor:"⌊",LeftRightArrow:"↔",LeftTee:"⊣",LeftTriangle:"⊲",LeftTriangleEqual:"⊴",LeftUpVector:"↿",LeftVector:"↼",Leftarrow:"⇐",Leftrightarrow:"⇔",LessEqualGreater:"⋚",LessFullEqual:"≦",LessGreater:"≶",LessSlantEqual:"⩽",LessTilde:"≲",Ll:"⋘",Lleftarrow:"⇚",LongLeftArrow:"⟵",LongLeftRightArrow:"⟷",LongRightArrow:"⟶",Longleftarrow:"⟸",Longleftrightarrow:"⟺",Longrightarrow:"⟹",Lsh:"↰",MinusPlus:"∓",NestedGreaterGreater:"≫",NestedLessLess:"≪",NotDoubleVerticalBar:"∦",NotElement:"∉",NotEqual:"≠",NotExists:"∄",NotGreater:"≯",NotGreaterEqual:"≱",NotLeftTriangle:"⋪",NotLeftTriangleEqual:"⋬",NotLess:"≮",NotLessEqual:"≰",NotPrecedes:"⊀",NotPrecedesSlantEqual:"⋠",NotRightTriangle:"⋫",NotRightTriangleEqual:"⋭",NotSubsetEqual:"⊈",NotSucceeds:"⊁",NotSucceedsSlantEqual:"⋡",NotSupersetEqual:"⊉",NotTilde:"≁",NotVerticalBar:"∤",Omega:"Ω",OverBar:"‾",OverBrace:"⏞",PartialD:"∂",Phi:"Φ",Pi:"Π",PlusMinus:"±",Precedes:"≺",PrecedesEqual:"⪯",PrecedesSlantEqual:"≼",PrecedesTilde:"≾",Product:"∏",Proportional:"∝",Psi:"Ψ",Rarr:"↠",Re:"ℜ",ReverseEquilibrium:"⇋",RightAngleBracket:"⟩",RightArrow:"→",RightArrowLeftArrow:"⇄",RightCeiling:"⌉",RightDownVector:"⇂",RightFloor:"⌋",RightTee:"⊢",RightTeeArrow:"↦",RightTriangle:"⊳",RightTriangleEqual:"⊵",RightUpVector:"↾",RightVector:"⇀",Rightarrow:"⇒",Rrightarrow:"⇛",Rsh:"↱",Sigma:"Σ",SmallCircle:"∘",Sqrt:"√",Square:"□",SquareIntersection:"⊓",SquareSubset:"⊏",SquareSubsetEqual:"⊑",SquareSuperset:"⊐",SquareSupersetEqual:"⊒",SquareUnion:"⊔",Star:"⋆",Subset:"⋐",SubsetEqual:"⊆",Succeeds:"≻",SucceedsEqual:"⪰",SucceedsSlantEqual:"≽",SucceedsTilde:"≿",SuchThat:"∋",Sum:"∑",Superset:"⊃",SupersetEqual:"⊇",Supset:"⋑",Therefore:"∴",Theta:"Θ",Tilde:"∼",TildeEqual:"≃",TildeFullEqual:"≅",TildeTilde:"≈",UnderBar:"_",UnderBrace:"⏟",Union:"⋃",UnionPlus:"⊎",UpArrow:"↑",UpDownArrow:"↕",UpTee:"⊥",Uparrow:"⇑",Updownarrow:"⇕",Upsilon:"Υ",Vdash:"⊩",Vee:"⋁",VerticalBar:"∣",VerticalTilde:"≀",Vvdash:"⊪",Wedge:"⋀",Xi:"Ξ",acute:"´",aleph:"ℵ",alpha:"α",amalg:"⨿",and:"∧",ang:"∠",angmsd:"∡",angsph:"∢",ape:"≊",backprime:"‵",backsim:"∽",backsimeq:"⋍",beta:"β",beth:"ℶ",between:"≬",bigcirc:"◯",bigodot:"⨀",bigoplus:"⨁",bigotimes:"⨂",bigsqcup:"⨆",bigstar:"★",bigtriangledown:"▽",bigtriangleup:"△",biguplus:"⨄",blacklozenge:"⧫",blacktriangle:"▴",blacktriangledown:"▾",blacktriangleleft:"◂",bowtie:"⋈",boxdl:"┐",boxdr:"┌",boxminus:"⊟",boxplus:"⊞",boxtimes:"⊠",boxul:"┘",boxur:"└",bsol:"\\",bull:"•",cap:"∩",check:"✓",chi:"χ",circ:"ˆ",circeq:"≗",circlearrowleft:"↺",circlearrowright:"↻",circledR:"®",circledS:"Ⓢ",circledast:"⊛",circledcirc:"⊚",circleddash:"⊝",clubs:"♣",colon:":",comp:"∁",ctdot:"⋯",cuepr:"⋞",cuesc:"⋟",cularr:"↶",cup:"∪",curarr:"↷",curlyvee:"⋎",curlywedge:"⋏",dagger:"†",daleth:"ℸ",ddarr:"⇊",deg:"°",delta:"δ",digamma:"ϝ",div:"÷",divideontimes:"⋇",dot:"˙",doteqdot:"≑",dotplus:"∔",dotsquare:"⊡",dtdot:"⋱",ecir:"≖",efDot:"≒",egs:"⪖",ell:"ℓ",els:"⪕",empty:"∅",epsi:"ε",epsiv:"ϵ",erDot:"≓",eta:"η",eth:"ð",flat:"♭",fork:"⋔",frown:"⌢",gEl:"⪌",gamma:"γ",gap:"⪆",gimel:"ℷ",gnE:"≩",gnap:"⪊",gne:"⪈",gnsim:"⋧",gt:">",gtdot:"⋗",harrw:"↭",hbar:"ℏ",hellip:"…",hookleftarrow:"↩",hookrightarrow:"↪",imath:"ı",infin:"∞",intcal:"⊺",iota:"ι",jmath:"ȷ",kappa:"κ",kappav:"ϰ",lEg:"⪋",lambda:"λ",lap:"⪅",larrlp:"↫",larrtl:"↢",lbrace:"{",lbrack:"[",le:"≤",leftleftarrows:"⇇",leftthreetimes:"⋋",lessdot:"⋖",lmoust:"⎰",lnE:"≨",lnap:"⪉",lne:"⪇",lnsim:"⋦",longmapsto:"⟼",looparrowright:"↬",lowast:"∗",loz:"◊",lt:"<",ltimes:"⋉",ltri:"◃",macr:"¯",malt:"✠",mho:"℧",mu:"μ",multimap:"⊸",nLeftarrow:"⇍",nLeftrightarrow:"⇎",nRightarrow:"⇏",nVDash:"⊯",nVdash:"⊮",natur:"♮",nearr:"↗",nharr:"↮",nlarr:"↚",not:"¬",nrarr:"↛",nu:"ν",nvDash:"⊭",nvdash:"⊬",nwarr:"↖",omega:"ω",omicron:"ο",or:"∨",osol:"⊘",period:".",phi:"φ",phiv:"ϕ",pi:"π",piv:"ϖ",prap:"⪷",precnapprox:"⪹",precneqq:"⪵",precnsim:"⋨",prime:"′",psi:"ψ",rarrtl:"↣",rbrace:"}",rbrack:"]",rho:"ρ",rhov:"ϱ",rightrightarrows:"⇉",rightthreetimes:"⋌",ring:"˚",rmoust:"⎱",rtimes:"⋊",rtri:"▹",scap:"⪸",scnE:"⪶",scnap:"⪺",scnsim:"⋩",sdot:"⋅",searr:"↘",sect:"§",sharp:"♯",sigma:"σ",sigmav:"ς",simne:"≆",smile:"⌣",spades:"♠",sub:"⊂",subE:"⫅",subnE:"⫋",subne:"⊊",supE:"⫆",supnE:"⫌",supne:"⊋",swarr:"↙",tau:"τ",theta:"θ",thetav:"ϑ",tilde:"˜",times:"×",triangle:"▵",triangleq:"≜",upsi:"υ",upuparrows:"⇈",veebar:"⊻",vellip:"⋮",weierp:"℘",xi:"ξ",yen:"¥",zeta:"ζ",zigrarr:"⇝"};c.loadComplete("jax.js")})(MathJax.InputJax.MathML,MathJax.Hub.Browser);(function(h,c,e,a){var g;var b="http://www.w3.org/2000/svg";var j="http://www.w3.org/1999/xlink";a.Augment({config:{styles:{".MathJax_SVG":{display:"inline","font-style":"normal","font-weight":"normal","line-height":"normal","font-size":"100%","font-size-adjust":"none","text-indent":0,"text-align":"left","text-transform":"none","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none",direction:"ltr","max-width":"none","max-height":"none","min-width":0,"min-height":0,border:0,padding:0,margin:0},".MathJax_SVG_Display":{position:"relative",display:"block!important","text-indent":0,"max-width":"none","max-height":"none","min-width":0,"min-height":0,width:"100%"},".MathJax_SVG *":{transition:"none","-webkit-transition":"none","-moz-transition":"none","-ms-transition":"none","-o-transition":"none"},".mjx-svg-href":{fill:"blue",stroke:"blue"},".MathJax_SVG_Processing":{visibility:"hidden",position:"absolute",top:0,left:0,width:0,height:0,overflow:"hidden",display:"block!important"},".MathJax_SVG_Processed":{display:"none!important"},".MathJax_SVG_ExBox":{display:"block!important",overflow:"hidden",width:"1px",height:"60ex","min-height":0,"max-height":"none",padding:0,border:0,margin:0},"#MathJax_SVG_Tooltip":{position:"absolute",left:0,top:0,width:"auto",height:"auto",display:"none"}}},hideProcessedMath:true,fontNames:["TeX","STIX","STIX-Web","Asana-Math","Gyre-Termes","Gyre-Pagella","Latin-Modern","Neo-Euler"],Config:function(){this.SUPER(arguments).Config.apply(this,arguments);var m=c.config.menuSettings,l=this.config,k=m.font;if(m.scale){l.scale=m.scale}if(k&&k!=="Auto"){k=k.replace(/(Local|Web|Image)$/i,"");k=k.replace(/([a-z])([A-Z])/,"$1-$2");this.fontInUse=k}else{this.fontInUse=l.font||"TeX"}if(this.fontNames.indexOf(this.fontInUse)<0){this.fontInUse="TeX"}this.fontDir+="/"+this.fontInUse;if(!this.require){this.require=[]}this.require.push(this.fontDir+"/fontdata.js");this.require.push(MathJax.OutputJax.extensionDir+"/MathEvents.js")},Startup:function(){EVENT=MathJax.Extension.MathEvents.Event;TOUCH=MathJax.Extension.MathEvents.Touch;HOVER=MathJax.Extension.MathEvents.Hover;this.ContextMenu=EVENT.ContextMenu;this.Mousedown=EVENT.AltContextMenu;this.Mouseover=HOVER.Mouseover;this.Mouseout=HOVER.Mouseout;this.Mousemove=HOVER.Mousemove;this.hiddenDiv=e.Element("div",{style:{visibility:"hidden",overflow:"hidden",position:"absolute",top:0,height:"1px",width:"auto",padding:0,border:0,margin:0,textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal"}});if(!document.body.firstChild){document.body.appendChild(this.hiddenDiv)}else{document.body.insertBefore(this.hiddenDiv,document.body.firstChild)}this.hiddenDiv=e.addElement(this.hiddenDiv,"div",{id:"MathJax_SVG_Hidden"});var k=e.addElement(this.hiddenDiv,"div",{style:{width:"5in"}});this.pxPerInch=k.offsetWidth/5;this.hiddenDiv.removeChild(k);this.textSVG=this.Element("svg");d=this.addElement(this.addElement(this.hiddenDiv.parentNode,"svg"),"defs",{id:"MathJax_SVG_glyphs"});f={};this.ExSpan=e.Element("span",{style:{position:"absolute","font-size-adjust":"none"}},[["span",{className:"MathJax_SVG_ExBox"}]]);this.linebreakSpan=e.Element("span",null,[["hr",{style:{width:"auto",size:1,padding:0,border:0,margin:0}}]]);return h.Styles(this.config.styles,["InitializeSVG",this])},InitializeSVG:function(){document.body.appendChild(this.ExSpan);document.body.appendChild(this.linebreakSpan);this.defaultEx=this.ExSpan.firstChild.offsetHeight/60;this.defaultWidth=this.linebreakSpan.firstChild.offsetWidth;document.body.removeChild(this.linebreakSpan);document.body.removeChild(this.ExSpan)},preTranslate:function(o){var t=o.jax[this.id],u,r=t.length,z,s,A,n,y,l,x,q,k,w=false,v,B=this.config.linebreaks.automatic,p=this.config.linebreaks.width;if(B){w=p.match(/^\s*(\d+(\.\d*)?%\s*)?container\s*$/)!=null;if(w){p=p.replace(/\s*container\s*/,"")}else{k=this.defaultWidth}if(p===""){p="100%"}}else{k=1e5}for(u=0;u<r;u++){z=t[u];if(!z.parentNode){continue}s=z.previousSibling;if(s&&String(s.className).match(/^MathJax(_SVG)?(_Display)?( MathJax(_SVG)?_Processing)?$/)){s.parentNode.removeChild(s)}l=z.MathJax.elementJax;if(!l){continue}l.SVG={display:l.root.Get("display")==="block"};A=n=e.Element("span",{style:{"font-size":this.config.scale+"%",display:"inline-block"},className:"MathJax_SVG",id:l.inputID+"-Frame",isMathJax:true,jaxID:this.id,oncontextmenu:EVENT.Menu,onmousedown:EVENT.Mousedown,onmouseover:EVENT.Mouseover,onmouseout:EVENT.Mouseout,onmousemove:EVENT.Mousemove,onclick:EVENT.Click,ondblclick:EVENT.DblClick});if(c.Browser.noContextMenu){A.ontouchstart=TOUCH.start;A.ontouchend=TOUCH.end}if(l.SVG.display){n=e.Element("div",{className:"MathJax_SVG_Display"});n.appendChild(A)}n.setAttribute("role","textbox");n.setAttribute("aria-readonly","true");n.className+=" MathJax_SVG_Processing";z.parentNode.insertBefore(n,z);z.parentNode.insertBefore(this.ExSpan.cloneNode(true),z);n.parentNode.insertBefore(this.linebreakSpan.cloneNode(true),n)}for(u=0;u<r;u++){z=t[u];if(!z.parentNode){continue}y=z.previousSibling;n=y.previousSibling;l=z.MathJax.elementJax;if(!l){continue}x=y.firstChild.offsetHeight/60;v=n.previousSibling.firstChild.offsetWidth;if(w){k=v}if(x===0||x==="NaN"){this.hiddenDiv.appendChild(n);l.SVG.isHidden=true;x=this.defaultEx;v=this.defaultWidth;if(w){k=this.defaultWidth}}l.SVG.ex=x;l.SVG.cwidth=v;l.SVG.em=q=x/a.TeX.x_height*1e3;l.SVG.lineWidth=B?this.length2em(p,1,k/q):1e6}for(u=0;u<r;u++){z=t[u];if(!z.parentNode){continue}y=t[u].previousSibling;A=y.previousSibling;l=t[u].MathJax.elementJax;if(!l){continue}if(!l.SVG.isHidden){A=A.previousSibling}A.parentNode.removeChild(A);y.parentNode.removeChild(y)}o.SVGeqn=o.SVGlast=0;o.SVGi=-1;o.SVGchunk=this.config.EqnChunk;o.SVGdelay=false},Translate:function(l,p){if(!l.parentNode){return}if(p.SVGdelay){p.SVGdelay=false;c.RestartAfter(MathJax.Callback.Delay(this.config.EqnChunkDelay))}var k=l.MathJax.elementJax,o=k.root,m=document.getElementById(k.inputID+"-Frame"),q=k.SVG.display?(m||{}).parentNode:m;if(!q){return}this.em=g.mbase.prototype.em=k.SVG.em;this.ex=k.SVG.ex;this.linebreakWidth=k.SVG.lineWidth*1e3;this.cwidth=k.SVG.cwidth;this.mathDiv=q;m.appendChild(this.textSVG);this.initSVG(o,m);o.setTeXclass();try{o.toSVG(m,q)}catch(n){if(n.restart){while(m.firstChild){m.removeChild(m.firstChild)}}throw n}m.removeChild(this.textSVG);if(k.SVG.isHidden){l.parentNode.insertBefore(q,l)}q.className=q.className.split(/ /)[0];if(this.hideProcessedMath){q.className+=" MathJax_SVG_Processed";if(l.MathJax.preview){k.SVG.preview=l.MathJax.preview;delete l.MathJax.preview}p.SVGeqn+=p.i-p.SVGi;p.SVGi=p.i;if(p.SVGeqn>=p.SVGlast+p.SVGchunk){this.postTranslate(p,true);p.SVGchunk=Math.floor(p.SVGchunk*this.config.EqnChunkFactor);p.SVGdelay=true}}},postTranslate:function(r,o){var l=r.jax[this.id];if(!this.hideProcessedMath){return}for(var p=r.SVGlast,k=r.SVGeqn;p<k;p++){var n=l[p];if(n&&n.MathJax.elementJax){n.previousSibling.className=n.previousSibling.className.split(/ /)[0];var q=n.MathJax.elementJax.SVG;if(q.preview){q.preview.innerHTML="";n.MathJax.preview=q.preview;delete q.preview}}}r.SVGlast=r.SVGeqn},hashCheck:function(k){if(k&&k.nodeName==="g"){do{k=k.parentNode}while(k&&k.firstChild.nodeName!=="svg")}return k},getJaxFromMath:function(k){if(k.parentNode.className==="MathJax_SVG_Display"){k=k.parentNode}do{k=k.nextSibling}while(k&&k.nodeName.toLowerCase()!=="script");return c.getJaxFor(k)},getHoverSpan:function(k,l){l.style.position="relative";return l.firstChild},getHoverBBox:function(k,l,m){var n=EVENT.getBBox(l.parentNode);n.h+=2;n.d-=2;return n},Zoom:function(l,s,q,k,p){s.className="MathJax_SVG";var u=s.appendChild(this.ExSpan.cloneNode(true));var o=u.firstChild.offsetHeight/60;this.em=g.mbase.prototype.em=o/a.TeX.x_height*1e3;this.cwidth=.85*a.defaultWidth;u.parentNode.removeChild(u);s.appendChild(this.textSVG);this.mathDIV=s;this.zoomScale=parseInt(c.config.menuSettings.zscale)/100;this.idPostfix="-zoom";l.root.toSVG(s,s);this.idPostfix="";this.zoomScale=1;s.removeChild(this.textSVG);if(this.operaZoomRefresh){setTimeout(function(){s.firstChild.style.border="1px solid transparent"},1)}if(s.offsetWidth<s.firstChild.offsetWidth){s.style.minWidth=s.firstChild.offsetWidth+"px";q.style.minWidth=q.firstChild.offsetWidth+"px"}s.style.position=q.style.position="absolute";var r=s.offsetWidth,n=s.offsetHeight,t=q.offsetHeight,m=q.offsetWidth;s.style.position=q.style.position="";return{Y:-EVENT.getBBox(s).h,mW:m,mH:t,zW:r,zH:n}},initSVG:function(l,k){},Remove:function(k){var l=document.getElementById(k.inputID+"-Frame");if(l){if(k.SVG.display){l=l.parentNode}l.parentNode.removeChild(l)}delete k.SVG},Em:function(k){if(Math.abs(k)<6e-4){return"0em"}return k.toFixed(3).replace(/\.?0+$/,"")+"em"},Ex:function(k){k=Math.round(k/this.TeX.x_height*this.ex)/this.ex;if(Math.abs(k)<6e-4){return"0ex"}return k.toFixed(3).replace(/\.?0+$/,"")+"ex"},Percent:function(k){return(100*k).toFixed(1).replace(/\.?0+$/,"")+"%"},length2em:function(q,l,o){if(typeof q!=="string"){q=q.toString()}if(q===""){return""}if(q===g.SIZE.NORMAL){return 1e3}if(q===g.SIZE.BIG){return 2e3}if(q===g.SIZE.SMALL){return 710}if(q==="infinity"){return a.BIGDIMEN}if(q.match(/mathspace$/)){return 1e3*a.MATHSPACE[q]}var r=(this.zoomScale||1)/a.em;var n=q.match(/^\s*([-+]?(?:\.\d+|\d+(?:\.\d*)?))?(pt|em|ex|mu|px|pc|in|mm|cm|%)?/);var k=parseFloat(n[1]||"1")*1e3,p=n[2];if(o==null){o=1e3}if(l==null){l=1}if(p==="em"){return k}if(p==="ex"){return k*a.TeX.x_height/1e3}if(p==="%"){return k/100*o/1e3}if(p==="px"){return k*r}if(p==="pt"){return k/10}if(p==="pc"){return k*1.2}if(p==="in"){return k*this.pxPerInch*r}if(p==="cm"){return k*this.pxPerInch*r/2.54}if(p==="mm"){return k*this.pxPerInch*r/25.4}if(p==="mu"){return k/18*l}return k*o/1e3},thickness2em:function(l,k){var m=a.TeX.rule_thickness;if(l===g.LINETHICKNESS.MEDIUM){return m}if(l===g.LINETHICKNESS.THIN){return.67*m}if(l===g.LINETHICKNESS.THICK){return 1.67*m}return this.length2em(l,k,m)},getPadding:function(l){var n={top:0,right:0,bottom:0,left:0},k=false;for(var o in n){if(n.hasOwnProperty(o)){var m=l["padding"+o.charAt(0).toUpperCase()+o.substr(1)];if(m){n[o]=this.length2em(m);k=true}}}return k?n:false},getBorders:function(o){var m={top:0,right:0,bottom:0,left:0},l=false;for(var p in m){if(m.hasOwnProperty(p)){var k="border"+p.charAt(0).toUpperCase()+p.substr(1);var n=o[k+"Style"];if(n&&n!=="none"){l=true;m[p]=this.length2em(o[k+"Width"]);m[p+"Style"]=o[k+"Style"];m[p+"Color"]=o[k+"Color"];if(m[p+"Color"]==="initial"){m[p+"Color"]=""}}else{delete m[p]}}}return l?m:false},Element:function(k,l){var m=typeof k==="string"?document.createElementNS(b,k):k;m.isMathJax=true;if(l){for(var n in l){if(l.hasOwnProperty(n)){m.setAttribute(n,l[n].toString())}}}return m},addElement:function(l,k,m){return l.appendChild(this.Element(k,m))},TextNode:e.TextNode,addText:e.addText,ucMatch:e.ucMatch,HandleVariant:function(s,r,B){var v=i.G();var o,x,z,p,A,t,q,l,y,k;if(!s){s=this.FONTDATA.VARIANT[g.VARIANT.NORMAL]}if(s.forceFamily){B=i.TEXT(r,B,s.font);if(s.h!=null){B.h=s.h}if(s.d!=null){B.d=s.d}v.Add(B);B=""}A=s;for(t=0,q=B.length;t<q;t++){s=A;o=B.charCodeAt(t);z=B.charAt(t);if(o>=55296&&o<56319){t++;o=(o-55296<<10)+(B.charCodeAt(t)-56320)+65536;if(this.FONTDATA.RemapPlane1){var w=this.FONTDATA.RemapPlane1(o,s);o=w.n;s=w.variant}}else{k=this.FONTDATA.RANGES;for(l=0,y=k.length;l<y;l++){if(k[l].name==="alpha"&&s.noLowerCase){continue}x=s["offset"+k[l].offset];if(x&&o>=k[l].low&&o<=k[l].high){if(k[l].remap&&k[l].remap[o]){o=x+k[l].remap[o]}else{o=o-k[l].low+x;if(k[l].add){o+=k[l].add}}if(s["variant"+k[l].offset]){s=this.FONTDATA.VARIANT[s["variant"+k[l].offset]]}break}}}if(s.remap&&s.remap[o]){o=s.remap[o];if(s.remap.variant){s=this.FONTDATA.VARIANT[s.remap.variant]}}else{if(this.FONTDATA.REMAP[o]&&!s.noRemap){o=this.FONTDATA.REMAP[o]}}if(o instanceof Array){s=this.FONTDATA.VARIANT[o[1]];o=o[0]}if(typeof o==="string"){B=o+B.substr(t+1);q=B.length;t=-1;continue}p=this.lookupChar(s,o);z=p[o];if(z){if(z[5]&&z[5].space){v.w+=z[2]}else{z=[r,p.id+"-"+o.toString(16).toUpperCase()].concat(z);v.Add(i.GLYPH.apply(i,z),v.w,0)}}else{if(this.FONTDATA.DELIMITERS[o]){z=this.createDelimiter(o,0,1,p);v.Add(z,v.w,this.FONTDATA.DELIMITERS[o].dir==="V"?z.d:0)}else{if(o<=65535){z=String.fromCharCode(o)}else{x=o-65536;z=String.fromCharCode((x>>10)+55296)+String.fromCharCode((x&1023)+56320)}var u=i.TEXT(r,z,{"font-family":s.defaultFamily||a.config.undefinedFamily,"font-style":s.italic?"italic":"","font-weight":s.bold?"bold":""});if(s.h!=null){u.h=s.h}if(s.d!=null){u.d=s.d}z=i.G();z.Add(u);v.Add(z,v.w,0);c.signal.Post(["SVG Jax - unknown char",o,s])}}}if(B.length==1&&p.skew&&p.skew[o]){v.skew=p.skew[o]*1e3}if(v.element.childNodes.length===1){v.element=v.element.firstChild;v.removeable=false;v.scale=r}return v},lookupChar:function(p,s){var o,k;if(!p.FONTS){var r=this.FONTDATA.FONTS;var q=p.fonts||this.FONTDATA.VARIANT.normal.fonts;if(!(q instanceof Array)){q=[q]}if(p.fonts!=q){p.fonts=q}p.FONTS=[];for(o=0,k=q.length;o<k;o++){if(r[q[o]]){p.FONTS.push(r[q[o]])}}}for(o=0,k=p.FONTS.length;o<k;o++){var l=p.FONTS[o];if(typeof l==="string"){delete p.FONTS;this.loadFont(l)}if(l[s]){return l}else{this.findBlock(l,s)}}return{id:"unknown"}},findBlock:function(l,q){if(l.Ranges){for(var p=0,k=l.Ranges.length;p<k;p++){if(q<l.Ranges[p][0]){return}if(q<=l.Ranges[p][1]){var o=l.Ranges[p][2];for(var n=l.Ranges.length-1;n>=0;n--){if(l.Ranges[n][2]==o){l.Ranges.splice(n,1)}}this.loadFont(l.directory+"/"+o+".js")}}}},loadFont:function(k){c.RestartAfter(h.Require(this.fontDir+"/"+k))},createDelimiter:function(k,n,q,o){if(!q){q=1}var s=i.G();if(!k){s.Clean();delete s.element;s.w=s.r=this.TeX.nulldelimiterspace*q;return s}if(!(n instanceof Array)){n=[n,n]}var t=n[1];n=n[0];var l={alias:k};while(l.alias){k=l.alias;l=this.FONTDATA.DELIMITERS[k];if(!l){l={HW:[0,this.FONTDATA.VARIANT[g.VARIANT.NORMAL]]}}}if(l.load){c.RestartAfter(h.Require(this.fontDir+"/fontdata-"+l.load+".js"))}for(var r=0,p=l.HW.length;r<p;r++){if(l.HW[r][0]*q>=n-10-a.config.blacker||r==p-1&&!l.stretch){if(l.HW[r][2]){q*=l.HW[r][2]
}if(l.HW[r][3]){k=l.HW[r][3]}return this.createChar(q,[k,l.HW[r][1]],o).With({stretched:true})}}if(l.stretch){this["extendDelimiter"+l.dir](s,t,l.stretch,q,o)}return s},createChar:function(s,q,n){var r="",p={fonts:[q[1]],noRemap:true};if(n&&n===g.VARIANT.BOLD){p.fonts=[q[1]+"-bold",q[1]]}if(typeof q[1]!=="string"){p=q[1]}if(q[0]instanceof Array){for(var o=0,k=q[0].length;o<k;o++){r+=String.fromCharCode(q[0][o])}}else{r=String.fromCharCode(q[0])}if(q[4]){s=s*q[4]}var l=this.HandleVariant(p,s,r);if(q[2]){l.x=q[2]*1e3}if(q[3]){l.y=q[3]*1e3}if(q[5]){l.h+=q[5]*1e3}if(q[6]){l.d+=q[6]*1e3}return l},extendDelimiterV:function(r,A,m,o,n){var x=this.createChar(o,m.top||m.ext,n);var u=this.createChar(o,m.bot||m.ext,n);var q=x.h+x.d+u.h+u.d;var w=-x.h;r.Add(x,0,w);w-=x.d;if(m.mid){var z=this.createChar(o,m.mid,n);q+=z.h+z.d}if(m.min&&A<q*m.min){A=q*m.min}if(A>q){var l=this.createChar(o,m.ext,n);var p=m.mid?2:1,v=(A-q)/p,B=(v+100)/(l.h+l.d);while(p-->0){var t=a.Element("g",{transform:"translate("+l.y+","+(w-B*l.h+50+l.y)+") scale(1,"+B+")"});t.appendChild(l.element.cloneNode(false));r.element.appendChild(t);w-=v;if(m.mid&&p){r.Add(z,0,w-z.h);w-=z.h+z.d}}}else{if(m.mid){w+=(q-A)/2;r.Add(z,0,w-z.h);w+=-(z.h+z.d)+(q-A)/2}else{w+=q-A}}r.Add(u,0,w-u.h);r.Clean();r.scale=o;r.isMultiChar=true},extendDelimiterH:function(t,o,m,q,n){var p=this.createChar(q,m.left||m.rep,n);var C=this.createChar(q,m.right||m.rep,n);t.Add(p,-p.l,0);var B=p.r-p.l+(C.r-C.l),z=p.r-p.l;if(m.mid){var A=this.createChar(q,m.mid,n);B+=A.w}if(m.min&&o<B*m.min){o=B*m.min}if(o>B){var y=this.createChar(q,m.rep,n),l=m.fuzz||0;var r=m.mid?2:1,v=(o-B)/r,D=(v+l)/(y.r-y.l);while(r-->0){var u=a.Element("g",{transform:"translate("+(z-l/2-D*y.l+y.x)+","+y.y+") scale("+D+",1)"});u.appendChild(y.element.cloneNode(false));t.element.appendChild(u);z+=v;if(m.mid&&r){t.Add(A,z,0);z+=A.w}}}else{if(m.mid){z-=(B-o)/2;t.Add(A,z,0);z+=A.w-(B-o)/2}else{z-=B-o}}t.Add(C,z-C.l,0);t.Clean();t.scale=q;t.isMultiChar=true},MATHSPACE:{veryverythinmathspace:1/18,verythinmathspace:2/18,thinmathspace:3/18,mediummathspace:4/18,thickmathspace:5/18,verythickmathspace:6/18,veryverythickmathspace:7/18,negativeveryverythinmathspace:-1/18,negativeverythinmathspace:-2/18,negativethinmathspace:-3/18,negativemediummathspace:-4/18,negativethickmathspace:-5/18,negativeverythickmathspace:-6/18,negativeveryverythickmathspace:-7/18},TeX:{x_height:430.554,quad:1e3,num1:676.508,num2:393.732,num3:443.73,denom1:685.951,denom2:344.841,sup1:412.892,sup2:362.892,sup3:288.888,sub1:150,sub2:247.217,sup_drop:386.108,sub_drop:50,delim1:2390,delim2:1e3,axis_height:250,rule_thickness:60,big_op_spacing1:111.111,big_op_spacing2:166.666,big_op_spacing3:200,big_op_spacing4:600,big_op_spacing5:100,scriptspace:100,nulldelimiterspace:120,delimiterfactor:901,delimitershortfall:100,min_rule_thickness:1.25,min_root_space:1.5},BIGDIMEN:1e7,NBSP:" "});var i=a.BBOX=MathJax.Object.Subclass({type:"g",removeable:true,Init:function(k){this.h=this.d=-a.BIGDIMEN;this.H=this.D=0;this.w=this.r=0;this.l=a.BIGDIMEN;this.x=this.y=0;this.scale=1;this.n=0;if(this.type){this.element=a.Element(this.type,k)}},With:function(k){return c.Insert(this,k)},Add:function(n,m,l,p,o){if(m){n.x+=m}if(l){n.y+=l}if(n.element){if(n.removeable&&n.element.childNodes.length===1&&n.n===1){var r=n.element.firstChild;if(r.nodeName==="use"||r.nodeName==="rect"){n.element=r;n.scale=n.childScale;var k=n.childX,q=n.childY;n.x+=k;n.y+=q;n.h-=q;n.d+=q;n.H-=q;n.D+=q;n.w-=k;n.r-=k;n.l+=k;n.removeable=false}}if(Math.abs(n.x)<1&&Math.abs(n.y)<1){n.remove=n.removeable}else{if(n.element.nodeName==="g"){if(!n.element.firstChild){n.remove=n.removeable}else{n.element.setAttribute("transform","translate("+Math.floor(n.x)+","+Math.floor(n.y)+")")}}else{if(n.element.nodeName==="line"||n.element.nodeName==="polygon"||n.element.nodeName==="path"||n.element.nodeName==="a"){n.element.setAttribute("transform","translate("+Math.floor(n.x)+","+Math.floor(n.y)+")")}else{n.element.setAttribute("x",Math.floor(n.x/n.scale));n.element.setAttribute("y",Math.floor(n.y/n.scale))}}}if(n.remove){this.n+=n.n;while(n.element.firstChild){if(o&&this.element.firstChild){this.element.insertBefore(n.element.firstChild,this.element.firstChild)}else{this.element.appendChild(n.element.firstChild)}}}else{if(o){this.element.insertBefore(n.element,this.element.firstChild)}else{this.element.appendChild(n.element)}}delete n.element}if(n.hasIndent){this.hasIndent=n.hasIndent}if(n.d-n.y>this.d){this.d=n.d-n.y;if(this.d>this.D){this.D=this.d}}if(n.y+n.h>this.h){this.h=n.y+n.h;if(this.h>this.H){this.H=this.h}}if(n.D-n.y>this.D){this.D=n.D-n.y}if(n.y+n.H>this.H){this.H=n.y+n.H}if(n.x+n.l<this.l){this.l=n.x+n.l}if(n.x+n.r>this.r){this.r=n.x+n.r}if(p||n.x+n.w+(n.X||0)>this.w){this.w=n.x+n.w+(n.X||0)}this.childScale=n.scale;this.childX=n.x;this.childY=n.y;this.n++;return n},Align:function(m,o,l,k){l={left:l,center:(this.w-m.w)/2,right:this.w-m.w-l}[o]||0;if(l<0){if(this.element.childNodes.length){this.element.setAttribute("transform","translate("+Math.floor(-l)+",0)");var n=a.Element("g");n.appendChild(this.element);this.element=n}this.l-=l;this.w-=l;this.r-=l;l=0}this.Add(m,l,k)},Clean:function(){if(this.h===-a.BIGDIMEN){this.h=this.d=this.l=0}return this}});i.ROW=i.Subclass({Init:function(){this.SUPER(arguments).Init.call(this);this.svg=[];this.sh=this.sd=0},Check:function(l){var k=l.toSVG();this.svg.push(k);if(l.SVGcanStretch("Vertical")){k.mml=l}if(k.h>this.sh){this.sh=k.h}if(k.d>this.sd){this.sd=k.d}},Stretch:function(){for(var o=0,k=this.svg.length;o<k;o++){var l=this.svg[o],n=l.mml;if(n){if(n.forceStretch||n.SVGdata.h!==this.sh||n.SVGdata.d!==this.sd){l=n.SVGstretchV(this.sh,this.sd)}n.SVGdata.HW=this.sh;n.SVGdata.D=this.sd}if(l.ic){this.ic=l.ic}else{delete this.ic}this.Add(l,this.w,0,true)}delete this.svg}});i.RECT=i.Subclass({type:"rect",removeable:false,Init:function(l,n,k,m){if(m==null){m={stroke:"none"}}m.width=Math.floor(k);m.height=Math.floor(l+n);this.SUPER(arguments).Init.call(this,m);this.w=this.r=k;this.h=this.H=l+n;this.d=this.D=this.l=0;this.y=-n}});i.FRAME=i.Subclass({type:"rect",removeable:false,Init:function(n,q,k,m,p,l,o){if(o==null){o={}}o.fill="none";o["stroke-width"]=m.toFixed(2).replace(/\.?0+$/,"");o.width=Math.floor(k-m);o.height=Math.floor(n+q-m);o.transform="translate("+Math.floor(m/2)+","+Math.floor(-q+m/2)+")";if(p==="dashed"){o["stroke-dasharray"]=[Math.floor(6*a.em),Math.floor(6*a.em)].join(" ")}this.SUPER(arguments).Init.call(this,o);this.w=this.r=k;this.h=this.H=n;this.d=this.D=q;this.l=0}});i.HLINE=i.Subclass({type:"line",removeable:false,Init:function(l,p,r,o,q){if(q==null){q={"stroke-linecap":"square"}}if(o&&o!==""){q.stroke=o}q["stroke-width"]=p.toFixed(2).replace(/\.?0+$/,"");q.x1=q.y1=q.y2=Math.floor(p/2);q.x2=Math.floor(l-p/2);if(r==="dashed"){var s=Math.floor(Math.max(0,l-p)/(6*p)),k=Math.floor(Math.max(0,l-p)/(2*s+1));q["stroke-dasharray"]=k+" "+k}if(r==="dotted"){q["stroke-dasharray"]=[1,Math.max(150,Math.floor(2*p))].join(" ");q["stroke-linecap"]="round"}this.SUPER(arguments).Init.call(this,q);this.w=this.r=l;this.l=0;this.h=this.H=p;this.d=this.D=0}});i.VLINE=i.Subclass({type:"line",removeable:false,Init:function(p,o,r,l,q){if(q==null){q={"stroke-linecap":"square"}}if(l&&l!==""){q.stroke=l}q["stroke-width"]=o.toFixed(2).replace(/\.?0+$/,"");q.x1=q.x2=q.y1=Math.floor(o/2);q.y2=Math.floor(p-o/2);if(r==="dashed"){var s=Math.floor(Math.max(0,p-o)/(6*o)),k=Math.floor(Math.max(0,p-o)/(2*s+1));q["stroke-dasharray"]=k+" "+k}if(r==="dotted"){q["stroke-dasharray"]=[1,Math.max(150,Math.floor(2*o))].join(" ");q["stroke-linecap"]="round"}this.SUPER(arguments).Init.call(this,q);this.w=this.r=o;this.l=0;this.h=this.H=p;this.d=this.D=0}});i.TEXT=i.Subclass({type:"text",removeable:false,Init:function(n,m,k){if(!k){k={}}k.stroke="none";this.SUPER(arguments).Init.call(this,k);a.addText(this.element,m);a.textSVG.appendChild(this.element);var l=this.element.getBBox();a.textSVG.removeChild(this.element);n*=1e3/a.em;this.element.setAttribute("transform","scale("+n+") matrix(1 0 0 -1 0 0)");this.w=this.r=l.width*n;this.l=0;this.h=this.H=-l.y*n;this.d=this.D=(l.height+l.y)*n}});i.G=i;i.NULL=i.Subclass({Init:function(){this.SUPER(arguments).Init.apply(this,arguments);this.Clean()}});var f,d;i.GLYPH=i.Subclass({type:"path",removeable:false,Init:function(q,m,u,v,x,s,k,n){var o,y=a.config.blacker;if(!f[m]){o={id:m,"stroke-width":y};if(n!==""){o.d="M"+n+"Z"}this.SUPER(arguments).Init.call(this,o);d.appendChild(this.element);f[m]=true}o={};if(q!==1){o.transform="scale("+q+")"}this.element=a.Element("use",o);this.element.setAttributeNS(j,"href","#"+m);this.h=(u+y)*q;this.d=(v+y)*q;this.w=(x+y/2)*q;this.l=(s+y/2)*q;this.r=(k+y/2)*q;this.H=Math.max(0,this.h);this.D=Math.max(0,this.d);this.x=this.y=0;this.scale=q}});c.Register.StartupHook("mml Jax Ready",function(){g=MathJax.ElementJax.mml;g.mbase.Augment({SVG:i,toSVG:function(){this.SVGgetStyles();var o=this.SVGgetVariant();var l=this.SVG();this.SVGgetScale(l);this.SVGhandleSpace(l);for(var n=0,k=this.data.length;n<k;n++){if(this.data[n]){var q=l.Add(this.data[n].toSVG(o,l.scale),l.w,0,true);if(q.skew){l.skew=q.skew}}}l.Clean();var p=this.data.join("");if(l.skew&&p.length!==1){delete l.skew}if(l.r>l.w&&p.length===1&&!o.noIC){l.ic=l.r-l.w;l.w=l.r}this.SVGhandleColor(l);this.SVGsaveData(l);return l},SVGchildSVG:function(k){return this.data[k]?this.data[k].toSVG():i()},SVGdataStretched:function(l,k,m){this.SVGdata={HW:k,D:m};if(!this.data[l]){return i()}if(m!=null){return this.data[l].SVGstretchV(k,m)}if(k!=null){return this.data[l].SVGstretchH(k)}return this.data[l].toSVG()},SVGsaveData:function(l){if(!this.SVGdata){this.SVGdata={}}this.SVGdata.w=l.w,this.SVGdata.x=l.x;this.SVGdata.h=l.h,this.SVGdata.d=l.d;if(l.y){this.SVGdata.h+=l.y;this.SVGdata.d-=l.y}if(l.X!=null){this.SVGdata.X=l.X}if(this["class"]){l.removeable=false;a.Element(l.element,{"class":this["class"]})}if(this.id){l.removeable=false;a.Element(l.element,{id:this.id})}if(this.href){var k=a.Element("a",{"class":"mjx-svg-href"});k.setAttributeNS(j,"href",this.href);k.onclick=this.SVGlink;a.addElement(k,"rect",{width:l.w,height:l.h+l.d,y:-l.d,fill:"none",stroke:"none","pointer-events":"all"});if(l.type==="svg"){var n=l.element.firstChild;while(n.firstChild){k.appendChild(n.firstChild)}n.appendChild(k)}else{k.appendChild(l.element);l.element=k}l.removeable=false}if(a.config.addMMLclasses){this.SVGaddClass(l.element,"mjx-svg-"+this.type);l.removeable=false}var m=this.style;if(m&&l.element){l.element.style.cssText=m;if(l.element.style.fontSize){l.element.style.fontSize=""}l.element.style.border=l.element.style.padding="";if(l.removeable){l.removeable=l.element.style.cssText===""}}},SVGaddClass:function(m,k){var l=m.getAttribute("class");m.setAttribute("class",(l?l+" ":"")+k)},SVGlink:function(){var k=this.href.animVal;if(k.charAt(0)==="#"){var l=a.hashCheck(document.getElementById(k.substr(1)));if(l&&l.scrollIntoView){setTimeout(function(){l.parentNode.scrollIntoView(true)},1)}}document.location=k},SVGgetStyles:function(){if(this.style){var k=e.Element("span");k.style.cssText=this.style;this.styles=this.SVGprocessStyles(k.style)}},SVGprocessStyles:function(k){var l={border:a.getBorders(k),padding:a.getPadding(k)};if(!l.border){delete l.border}if(!l.padding){delete l.padding}if(k.fontSize){l.fontSize=k.fontSize}if(k.color){l.color=k.color}if(k.backgroundColor){l.background=k.backgroundColor}if(k.fontStyle){l.fontStyle=k.fontStyle}if(k.fontWeight){l.fontWeight=k.fontWeight}if(k.fontFamily){l.fontFamily=k.fontFamily}if(l.fontWeight&&l.fontWeight.match(/^\d+$/)){l.fontWeight=parseInt(l.fontWeight)>600?"bold":"normal"}return l},SVGhandleSpace:function(n){if(this.useMMLspacing){if(this.type!=="mo"){return}var m=this.getValues("scriptlevel","lspace","rspace");if(m.scriptlevel<=0||this.hasValue("lspace")||this.hasValue("rspace")){var l=this.SVGgetMu(n);m.lspace=Math.max(0,a.length2em(m.lspace,l));m.rspace=Math.max(0,a.length2em(m.rspace,l));var k=this,o=this.Parent();while(o&&o.isEmbellished()&&o.Core()===k){k=o;o=o.Parent()}if(m.lspace){n.x+=m.lspace}if(m.rspace){n.X=m.rspace}}}else{var p=this.texSpacing();this.SVGgetScale();if(p!==""){n.x+=a.length2em(p,this.scale)*this.mscale}}},SVGhandleColor:function(o){var w=this.getValues("mathcolor","color");if(this.styles&&this.styles.color&&!w.color){w.color=this.styles.color}if(w.color&&!this.mathcolor){w.mathcolor=w.color}if(w.mathcolor){a.Element(o.element,{fill:w.mathcolor,stroke:w.mathcolor});o.removeable=false}var s=(this.styles||{}).border,u=(this.styles||{}).padding,t=(s||{}).left||0,q=(u||{}).left||0,k;w.background=this.mathbackground||this.background||(this.styles||{}).background||g.COLOR.TRANSPARENT;if(t+q){var l=i();for(k in o){if(o.hasOwnProperty(k)){l[k]=o[k]}}l.x=0;l.y=0;o.element=a.Element("g");o.removeable=true;o.Add(l,t+q,0)}if(u){o.w+=u.right||0;o.h+=u.top||0;o.d+=u.bottom||0}if(s){o.w+=s.right||0;o.h+=s.top||0;o.d+=s.bottom||0}if(w.background!==g.COLOR.TRANSPARENT){if(o.element.nodeName!=="g"&&o.element.nodeName!=="svg"){var p=a.Element("g");p.appendChild(o.element);o.element=p;o.removeable=true}o.Add(i.RECT(o.h,o.d,o.w,{fill:w.background,stroke:"none"}),0,0,false,true)}if(s){var v=5;var m={left:["V",o.h+o.d,-v,-o.d],right:["V",o.h+o.d,o.w-s.right+v,-o.d],top:["H",o.w,0,o.h-s.top+v],bottom:["H",o.w,0,-o.d-v]};for(k in m){if(m.hasOwnProperty(k)){if(s[k]){var r=m[k],n=i[r[0]+"LINE"];o.Add(n(r[1],s[k],s[k+"Style"],s[k+"Color"]),r[2],r[3])}}}}},SVGhandleVariant:function(k,m,l){return a.HandleVariant(k,m,l)},SVGgetVariant:function(){var k=this.getValues("mathvariant","fontfamily","fontweight","fontstyle");var l=k.mathvariant;if(this.variantForm){l="-TeX-variant"}k.hasVariant=this.Get("mathvariant",true);if(!k.hasVariant){k.family=k.fontfamily;k.weight=k.fontweight;k.style=k.fontstyle}if(this.styles){if(!k.style&&this.styles.fontStyle){k.style=this.styles.fontStyle}if(!k.weight&&this.styles.fontWeight){k.weight=this.styles.fontWeight}if(!k.family&&this.styles.fontFamily){k.family=this.styles.fontFamily}}if(k.family&&!k.hasVariant){if(!k.weight&&k.mathvariant.match(/bold/)){k.weight="bold"}if(!k.style&&k.mathvariant.match(/italic/)){k.style="italic"}l={forceFamily:true,font:{"font-family":k.family}};if(k.style){l.font["font-style"]=k.style}if(k.weight){l.font["font-weight"]=k.weight}return l}if(k.weight==="bold"){l={normal:g.VARIANT.BOLD,italic:g.VARIANT.BOLDITALIC,fraktur:g.VARIANT.BOLDFRAKTUR,script:g.VARIANT.BOLDSCRIPT,"sans-serif":g.VARIANT.BOLDSANSSERIF,"sans-serif-italic":g.VARIANT.SANSSERIFBOLDITALIC}[l]||l}else{if(k.weight==="normal"){l={bold:g.VARIANT.normal,"bold-italic":g.VARIANT.ITALIC,"bold-fraktur":g.VARIANT.FRAKTUR,"bold-script":g.VARIANT.SCRIPT,"bold-sans-serif":g.VARIANT.SANSSERIF,"sans-serif-bold-italic":g.VARIANT.SANSSERIFITALIC}[l]||l}}if(k.style==="italic"){l={normal:g.VARIANT.ITALIC,bold:g.VARIANT.BOLDITALIC,"sans-serif":g.VARIANT.SANSSERIFITALIC,"bold-sans-serif":g.VARIANT.SANSSERIFBOLDITALIC}[l]||l}else{if(k.style==="normal"){l={italic:g.VARIANT.NORMAL,"bold-italic":g.VARIANT.BOLD,"sans-serif-italic":g.VARIANT.SANSSERIF,"sans-serif-bold-italic":g.VARIANT.BOLDSANSSERIF}[l]||l}}if(!(l in a.FONTDATA.VARIANT)){l="normal"}return a.FONTDATA.VARIANT[l]},SVGgetScale:function(l){var m=1;if(this.mscale){m=this.scale}else{var k=this.getValues("scriptlevel","fontsize");k.mathsize=(this.isToken?this:this.Parent()).Get("mathsize");if((this.styles||{}).fontSize&&!k.fontsize){k.fontsize=this.styles.fontSize}if(k.fontsize&&!this.mathsize){k.mathsize=k.fontsize}if(k.scriptlevel!==0){if(k.scriptlevel>2){k.scriptlevel=2}m=Math.pow(this.Get("scriptsizemultiplier"),k.scriptlevel);k.scriptminsize=a.length2em(this.Get("scriptminsize"))/1e3;if(m<k.scriptminsize){m=k.scriptminsize}}this.scale=m;this.mscale=a.length2em(k.mathsize)/1e3}if(l){l.scale=m;if(this.isToken){l.scale*=this.mscale}}return m*this.mscale},SVGgetMu:function(m){var k=1,l=this.getValues("scriptlevel","scriptsizemultiplier");if(m.scale&&m.scale!==1){k=1/m.scale}if(l.scriptlevel!==0){if(l.scriptlevel>2){l.scriptlevel=2}k=Math.sqrt(Math.pow(l.scriptsizemultiplier,l.scriptlevel))}return k},SVGnotEmpty:function(k){while(k){if(k.type!=="mrow"&&k.type!=="texatom"||k.data.length>1){return true}k=k.data[0]}return false},SVGcanStretch:function(m){var l=false;if(this.isEmbellished()){var k=this.Core();if(k&&k!==this){l=k.SVGcanStretch(m);if(l&&k.forceStretch){this.forceStretch=true}}}return l},SVGstretchV:function(k,l){return this.toSVG(k,l)},SVGstretchH:function(k){return this.toSVG(k)},SVGlineBreaks:function(){return false}},{SVGautoload:function(){var k=a.autoloadDir+"/"+this.type+".js";c.RestartAfter(h.Require(k))},SVGautoloadFile:function(k){var l=a.autoloadDir+"/"+k+".js";c.RestartAfter(h.Require(l))}});g.chars.Augment({toSVG:function(l,o,k,m){var n=this.data.join("").replace(/[\u2061-\u2064]/g,"");if(k){n=k(n,m)}return this.SVGhandleVariant(l,o,n)}});g.entity.Augment({toSVG:function(l,o,k,m){var n=this.toString().replace(/[\u2061-\u2064]/g,"");if(k){n=k(n,m)}return this.SVGhandleVariant(l,o,n)}});g.mo.Augment({toSVG:function(l,k){this.SVGgetStyles();var t=this.svg=this.SVG();var p=this.SVGgetScale(t);this.SVGhandleSpace(t);if(this.data.length==0){t.Clean();this.SVGsaveData(t);return t}if(k!=null){return this.SVGstretchV(l,k)}else{if(l!=null){return this.SVG.strechH(l)}}var r=this.SVGgetVariant();var z=this.getValues("largeop","displaystyle");if(z.largeop){r=a.FONTDATA.VARIANT[z.displaystyle?"-largeOp":"-smallOp"]}var y=this.CoreParent(),q=y&&y.isa(g.msubsup)&&this!==y.data[0],n=q?this.SVGremapChars:null;if(this.data.join("").length===1&&y&&y.isa(g.munderover)&&this.CoreText(y.data[y.base]).length===1){var u=y.data[y.over],w=y.data[y.under];if(u&&this===u.CoreMO()&&y.Get("accent")){n=a.FONTDATA.REMAPACCENT}else{if(w&&this===w.CoreMO()&&y.Get("accentunder")){n=a.FONTDATA.REMAPACCENTUNDER}}}if(q&&this.data.join("").match(/['`"\u00B4\u2032-\u2037\u2057]/)){r=a.FONTDATA.VARIANT["-TeX-variant"]}for(var s=0,o=this.data.length;s<o;s++){if(this.data[s]){var A=this.data[s].toSVG(r,p,this.SVGremap,n),v=t.w;if(v===0&&-A.l>10*A.w){v+=-A.l}t.Add(A,v,0,true);if(A.skew){t.skew=A.skew}}}t.Clean();if(this.data.join("").length!==1){delete t.skew}if(z.largeop){t.y=a.TeX.axis_height-(t.h-t.d)/2/p;if(t.r>t.w){t.ic=t.r-t.w;t.w=t.r}}this.SVGhandleColor(t);this.SVGsaveData(t);return t},CoreParent:function(){var k=this;while(k&&k.isEmbellished()&&k.CoreMO()===this&&!k.isa(g.math)){k=k.Parent()}return k},CoreText:function(k){if(!k){return""}if(k.isEmbellished()){return k.CoreMO().data.join("")}while((k.isa(g.mrow)||k.isa(g.TeXAtom)||k.isa(g.mstyle)||k.isa(g.mphantom))&&k.data.length===1&&k.data[0]){k=k.data[0]}if(!k.isToken){return""}else{return k.data.join("")}},SVGremapChars:{"*":"∗",'"':"″","°":"∘","²":"2","³":"3","´":"′","¹":"1"},SVGremap:function(l,k){l=l.replace(/-/g,"−");if(k){l=l.replace(/'/g,"′").replace(/`/g,"‵");if(l.length===1){l=k[l]||l}}return l},SVGcanStretch:function(o){if(!this.Get("stretchy")){return false}var p=this.data.join("");if(p.length>1){return false}var l=this.CoreParent();if(l&&l.isa(g.munderover)&&this.CoreText(l.data[l.base]).length===1){var n=l.data[l.over],k=l.data[l.under];if(n&&this===n.CoreMO()&&l.Get("accent")){p=a.FONTDATA.REMAPACCENT[p]||p}else{if(k&&this===k.CoreMO()&&l.Get("accentunder")){p=a.FONTDATA.REMAPACCENTUNDER[p]||p}}}p=a.FONTDATA.DELIMITERS[p.charCodeAt(0)];var m=p&&p.dir==o.substr(0,1);if(!m){delete this.svg}this.forceStretch=m&&(this.Get("minsize",true)||this.Get("maxsize",true));return m},SVGstretchV:function(p,q){var m=this.svg||this.toSVG();var l=this.getValues("symmetric","maxsize","minsize");var o=a.TeX.axis_height*m.scale,k=this.SVGgetMu(m),n;if(l.symmetric){n=2*Math.max(p-o,q+o)}else{n=p+q}l.maxsize=a.length2em(l.maxsize,k,m.h+m.d);l.minsize=a.length2em(l.minsize,k,m.h+m.d);n=Math.max(l.minsize,Math.min(l.maxsize,n));m=a.createDelimiter(this.data.join("").charCodeAt(0),n,m.scale);if(l.symmetric){n=(m.h+m.d)/2+o}else{n=(m.h+m.d)*p/(p+q)}m.y=n-m.h;this.SVGhandleSpace(m);this.SVGhandleColor(m);delete this.svg.element;this.SVGsaveData(m);m.stretched=true;return m},SVGstretchH:function(l){var n=this.svg||this.toSVG(),k=this.SVGgetMu(n);var m=this.getValues("maxsize","minsize","mathvariant","fontweight");if((m.fontweight==="bold"||parseInt(m.fontweight)>=600)&&!this.Get("mathvariant",true)){m.mathvariant=g.VARIANT.BOLD}m.maxsize=a.length2em(m.maxsize,k,n.w);m.minsize=a.length2em(m.minsize,k,n.w);l=Math.max(m.minsize,Math.min(m.maxsize,l));n=a.createDelimiter(this.data.join("").charCodeAt(0),l,n.scale,m.mathvariant);this.SVGhandleSpace(n);this.SVGhandleColor(n);delete this.svg.element;this.SVGsaveData(n);n.stretched=true;return n}});g.mtext.Augment({toSVG:function(){if(a.config.mtextFontInherit||this.Parent().type==="merror"){this.SVGgetStyles();var k=this.SVG(),n=this.SVGgetScale(k);this.SVGhandleSpace(k);var l=this.SVGgetVariant(),m={direction:this.Get("dir")};if(l.bold){m["font-weight"]="bold"}if(l.italic){m["font-style"]="italic"}l=this.Get("mathvariant");if(l==="monospace"){m["class"]="MJX-monospace"}else{if(l.match(/sans-serif/)){m["class"]="MJX-sans-serif"}}k.Add(i.TEXT(n,this.data.join(""),m));k.Clean();this.SVGhandleColor(k);this.SVGsaveData(k);return k}else{return this.SUPER(arguments).toSVG.call(this)}}});g.merror.Augment({toSVG:function(n,k){this.SVGgetStyles();var r=this.SVG(),p=a.length2em(this.styles.fontSize||1)/1e3;this.SVGhandleSpace(r);var l=p!==1?{transform:"scale("+p+")"}:{};var t=i(l);t.Add(this.SVGchildSVG(0));t.Clean();if(p!==1){t.removeable=false;var s=["w","h","d","l","r","D","H"];for(var q=0,o=s.length;q<o;q++){t[s[q]]*=p}}r.Add(t);r.Clean();this.SVGhandleColor(r);this.SVGsaveData(r);return r},SVGgetStyles:function(){var k=e.Element("span",{style:a.config.merrorStyle});this.styles=this.SVGprocessStyles(k.style);if(this.style){k.style.cssText=this.style;c.Insert(this.styles,this.SVGprocessStyles(k.style))}}});g.ms.Augment({toSVG:g.mbase.SVGautoload});g.mglyph.Augment({toSVG:g.mbase.SVGautoload});g.mspace.Augment({toSVG:function(){this.SVGgetStyles();var m=this.getValues("height","depth","width");m.mathbackground=this.mathbackground;if(this.background&&!this.mathbackground){m.mathbackground=this.background}var l=this.SVG();this.SVGgetScale(l);var n=this.mscale,k=this.SVGgetMu(l);l.h=a.length2em(m.height,k)*n;l.d=a.length2em(m.depth,k)*n;l.w=l.r=a.length2em(m.width,k)*n;if(l.w<0){l.x=l.w;l.w=l.r=0}if(l.h<-l.d){l.d=-l.h}l.l=0;l.Clean();this.SVGhandleColor(l);this.SVGsaveData(l);return l}});g.mphantom.Augment({toSVG:function(k,m){this.SVGgetStyles();var l=this.SVG();this.SVGgetScale(l);if(this.data[0]!=null){this.SVGhandleSpace(l);l.Add(this.SVGdataStretched(0,k,m));l.Clean();while(l.element.firstChild){l.element.removeChild(l.element.firstChild)}}this.SVGhandleColor(l);this.SVGsaveData(l);if(l.removeable&&!l.element.firstChild){delete l.element}return l}});g.mpadded.Augment({toSVG:function(l,k){this.SVGgetStyles();var o=this.SVG();if(this.data[0]!=null){this.SVGgetScale(o);this.SVGhandleSpace(o);var m=this.SVGdataStretched(0,l,k),u=this.SVGgetMu(o);var t=this.getValues("height","depth","width","lspace","voffset"),r=0,q=0;if(t.lspace){r=this.SVGlength2em(m,t.lspace,u)}if(t.voffset){q=this.SVGlength2em(m,t.voffset,u)}var n=m.h,p=m.d,s=m.w;o.Add(m,r,q);o.Clean();o.h=n;o.d=p;o.w=s;o.removeable=false;if(t.height!==""){o.h=this.SVGlength2em(o,t.height,u,"h",0)}if(t.depth!==""){o.d=this.SVGlength2em(o,t.depth,u,"d",0)}if(t.width!==""){o.w=this.SVGlength2em(o,t.width,u,"w",0)}if(o.h>o.H){o.H=o.h}if(o.d>o.D){o.D=o.d}}this.SVGhandleColor(o);this.SVGsaveData(o);return o},SVGlength2em:function(o,r,l,s,k){if(k==null){k=-a.BIGDIMEN}var p=String(r).match(/width|height|depth/);var q=p?o[p[0].charAt(0)]:s?o[s]:0;var n=a.length2em(r,l,q/this.mscale)*this.mscale;if(s&&String(r).match(/^\s*[-+]/)){return Math.max(k,o[s]+n)}else{return n}}});g.mrow.Augment({SVG:i.ROW,toSVG:function(){this.SVGgetStyles();var l=this.SVG();this.SVGhandleSpace(l);for(var n=0,k=this.data.length;n<k;n++){if(this.data[n]){l.Check(this.data[n])}}l.Stretch();l.Clean();if(this.SVGlineBreaks(l)){l=this.SVGmultiline(l)}this.SVGhandleColor(l);this.SVGsaveData(l);return l},SVGlineBreaks:function(k){if(!this.parent.linebreakContainer){return false}return a.config.linebreaks.automatic&&k.w>a.linebreakWidth||this.hasNewline()},SVGmultiline:function(k){g.mbase.SVGautoloadFile("multiline")},SVGstretchH:function(k){var l=this.data[this.core].SVGstretchH(k);this.SVGhandleColor(l);this.SVGsaveData(l);return l},SVGstretchV:function(l,m){var k=this.data[this.core].SVGstretchV(l,m);this.SVGhandleColor(k);this.SVGsaveData(k);return k}});g.mstyle.Augment({toSVG:function(){this.SVGgetStyles();var k=this.SVG();if(this.data[0]!=null){this.SVGhandleSpace(k);var l=k.Add(this.data[0].toSVG());k.Clean();if(l.ic){k.ic=l.ic}this.SVGhandleColor(k)}this.SVGsaveData(k);return k},SVGstretchH:function(k){return this.data[0]!=null?this.data[0].SVGstretchH(k):i.NULL()},SVGstretchV:function(k,l){return this.data[0]!=null?this.data[0].SVGstretchV(k,l):i.NULL()}});g.mfrac.Augment({toSVG:function(){this.SVGgetStyles();var y=this.SVG(),G=this.SVGgetScale(y);var m=i();m.scale=y.scale;this.SVGhandleSpace(m);var o=this.SVGchildSVG(0),n=this.SVGchildSVG(1);var k=this.getValues("displaystyle","linethickness","numalign","denomalign","bevelled");var C=k.displaystyle;var F=a.TeX.axis_height*G;if(k.bevelled){var E=C?400:150;var r=Math.max(o.h+o.d,n.h+n.d)+2*E;var D=a.createDelimiter(47,r);m.Add(o,0,(o.d-o.h)/2+F+E);m.Add(D,o.w-E/2,(D.d-D.h)/2+F);m.Add(n,o.w+D.w-E,(n.d-n.h)/2+F-E)}else{var l=Math.max(o.w,n.w);var x=a.thickness2em(k.linethickness,this.scale)*this.mscale,A,z,w,s;var B=a.TeX.min_rule_thickness/a.em*1e3;if(C){w=a.TeX.num1;s=a.TeX.denom1}else{w=x===0?a.TeX.num3:a.TeX.num2;s=a.TeX.denom2}w*=G;s*=G;if(x===0){A=Math.max((C?7:3)*a.TeX.rule_thickness,2*B);z=w-o.d-(n.h-s);if(z<A){w+=(A-z)/2;s+=(A-z)/2}m.w=l;x=0}else{A=Math.max((C?2:0)*B+x,x/2+1.5*B);z=w-o.d-(F+x/2);if(z<A){w+=A-z}z=F-x/2-(n.h-s);if(z<A){s+=A-z}m.Add(i.RECT(x/2,x/2,l+2*x),0,F)}m.Align(o,k.numalign,x,w);m.Align(n,k.denomalign,x,-s)}m.Clean();y.Add(m,0,0);y.Clean();this.SVGhandleColor(y);this.SVGsaveData(y);return y},SVGcanStretch:function(k){return false},SVGhandleSpace:function(k){if(!this.texWithDelims&&!this.useMMLspacing){k.x=k.X=a.TeX.nulldelimiterspace*this.mscale}this.SUPER(arguments).SVGhandleSpace.call(this,k)}});g.msqrt.Augment({toSVG:function(){this.SVGgetStyles();var r=this.SVG(),n=this.SVGgetScale(r);this.SVGhandleSpace(r);var m=this.SVGchildSVG(0),s,o;var w=a.TeX.rule_thickness*n,l,k,v,u=0;if(this.Get("displaystyle")){l=a.TeX.x_height*n}else{l=w}k=Math.max(w+l/4,1e3*a.TeX.min_root_space/a.em);v=m.h+m.d+k+w;o=a.createDelimiter(8730,v,n);if(o.h+o.d>v){k=(o.h+o.d-(v-w))/2}s=i.RECT(w,0,m.w);v=m.h+k+w;u=this.SVGaddRoot(r,o,u,o.h+o.d-v,n);r.Add(o,u,v-o.h);r.Add(s,u+o.w,v-s.h);r.Add(m,u+o.w,0);r.Clean();r.h+=w;r.H+=w;this.SVGhandleColor(r);this.SVGsaveData(r);return r},SVGaddRoot:function(l,m,k,o,n){return k}});g.mroot.Augment({toSVG:g.msqrt.prototype.toSVG,SVGaddRoot:function(n,l,q,o,k){var s=(l.isMultiChar?.55:.65)*l.w;if(this.data[1]){var p=this.data[1].toSVG();p.x=0;var m=this.SVGrootHeight(l.h+l.d,k,p)-o;var r=Math.min(p.w,p.r);q=Math.max(r,s);n.Add(p,q-r,m)}else{s=q}return q-s},SVGrootHeight:function(m,l,k){return.45*(m-900*l)+600*l+Math.max(0,k.d-75)}});g.mfenced.Augment({SVG:i.ROW,toSVG:function(){this.SVGgetStyles();var l=this.SVG();this.SVGhandleSpace(l);if(this.data.open){l.Check(this.data.open)}if(this.data[0]!=null){l.Check(this.data[0])}for(var n=1,k=this.data.length;n<k;n++){if(this.data[n]){if(this.data["sep"+n]){l.Check(this.data["sep"+n])}l.Check(this.data[n])}}if(this.data.close){l.Check(this.data.close)}l.Stretch();l.Clean();this.SVGhandleColor(l);this.SVGsaveData(l);return l}});g.menclose.Augment({toSVG:g.mbase.SVGautoload});g.maction.Augment({toSVG:g.mbase.SVGautoload});g.semantics.Augment({toSVG:function(){this.SVGgetStyles();var k=this.SVG();if(this.data[0]!=null){this.SVGhandleSpace(k);k.Add(this.data[0].toSVG());k.Clean()}else{k.Clean()}this.SVGsaveData(k);return k},SVGstretchH:function(k){return this.data[0]!=null?this.data[0].SVGstretchH(k):i.NULL()},SVGstretchV:function(k,l){return this.data[0]!=null?this.data[0].SVGstretchV(k,l):i.NULL()}});g.munderover.Augment({toSVG:function(F,C){this.SVGgetStyles();var l=this.getValues("displaystyle","accent","accentunder","align");if(!l.displaystyle&&this.data[this.base]!=null&&this.data[this.base].CoreMO().Get("movablelimits")){return g.msubsup.prototype.toSVG.call(this)}var E=this.SVG(),M=this.SVGgetScale(E);this.SVGhandleSpace(E);var p=[],K=[],u,J,G,n=-a.BIGDIMEN,I=n;for(J=0,G=this.data.length;J<G;J++){if(this.data[J]!=null){if(J==this.base){p[J]=this.SVGdataStretched(J,F,C);K[J]=(C!=null||F==null)&&this.data[J].SVGcanStretch("Horizontal")}else{p[J]=this.data[J].toSVG();p[J].x=0;delete p[J].X;K[J]=this.data[J].SVGcanStretch("Horizontal")}if(p[J].w>I){I=p[J].w}if(!K[J]&&I>n){n=I}}}if(C==null&&F!=null){n=F}else{if(n==-a.BIGDIMEN){n=I}}for(J=I=0,G=this.data.length;J<G;J++){if(this.data[J]){if(K[J]){p[J]=this.data[J].SVGstretchH(n);if(J!==this.base){p[J].x=0;delete p[J].X}}if(p[J].w>I){I=p[J].w}}}var B=a.TeX.rule_thickness*this.mscale;var o=p[this.base]||{w:0,h:0,d:0,H:0,D:0,l:0,r:0,y:0,scale:M};var s,q,w,v,r,A,H,L=0;if(o.ic){L=1.3*o.ic+.05}for(J=0,G=this.data.length;J<G;J++){if(this.data[J]!=null){u=p[J];r=a.TeX.big_op_spacing5*M;var z=J!=this.base&&l[this.ACCENTS[J]];if(z&&u.w<=1){u.x=-u.l;p[J]=i.G().With({removeable:false});p[J].Add(u);p[J].Clean();p[J].w=-u.l;u=p[J]}A={left:0,center:(I-u.w)/2,right:I-u.w}[l.align];s=A;q=0;if(J==this.over){if(z){H=B*M;r=0;if(o.skew){s+=o.skew}}else{w=a.TeX.big_op_spacing1*M;v=a.TeX.big_op_spacing3*M;H=Math.max(w,v-Math.max(0,u.d))}H=Math.max(H,1500/a.em);s+=L/2;q=o.y+o.h+u.d+H;u.h+=r;if(u.h>u.H){u.H=u.h}}else{if(J==this.under){if(z){H=3*B*M;r=0}else{w=a.TeX.big_op_spacing2*M;v=a.TeX.big_op_spacing4*M;H=Math.max(w,v-u.h)}H=Math.max(H,1500/a.em);s-=L/2;q=o.y-(o.d+u.h+H);u.d+=r;if(u.d>u.D){u.D=u.d}}}E.Add(u,s,q)}}E.Clean();this.SVGhandleColor(E);this.SVGsaveData(E);return E}});g.msubsup.Augment({toSVG:function(G,z){this.SVGgetStyles();var B=this.SVG(),K=this.SVGgetScale(B);this.SVGhandleSpace(B);var E=this.SVGgetMu(B);var m=B.Add(this.SVGdataStretched(this.base,G,z));var l=(this.data[this.sup]||this.data[this.sub]||this).SVGgetScale();var I=a.TeX.x_height*K,y=a.TeX.scriptspace*K;var k,n;if(this.SVGnotEmpty(this.data[this.sup])){k=this.data[this.sup].toSVG();k.w+=y;k.r=Math.max(k.w,k.r)}if(this.SVGnotEmpty(this.data[this.sub])){n=this.data[this.sub].toSVG();n.w+=y;n.r=Math.max(n.w,n.r)}var C=a.TeX.sup_drop*l,A=a.TeX.sub_drop*l;var w=m.h+(m.y||0)-C,o=m.d-(m.y||0)+A,J=0,F;if(m.ic){m.w-=m.ic;J=1.3*m.ic+.05}if(this.data[this.base]&&(this.data[this.base].type==="mi"||this.data[this.base].type==="mo")){if(this.data[this.base].data.join("").length===1&&m.scale===1&&!m.stretched&&!this.data[this.base].Get("largeop")){w=o=0}}var H=this.getValues("subscriptshift","superscriptshift");H.subscriptshift=H.subscriptshift===""?0:a.length2em(H.subscriptshift,E);H.superscriptshift=H.superscriptshift===""?0:a.length2em(H.superscriptshift,E);if(!k){if(n){o=Math.max(o,a.TeX.sub1*K,n.h-4/5*I,H.subscriptshift);B.Add(n,m.w,-o);this.data[this.sub].SVGdata.dy=-o}}else{if(!n){values=this.getValues("displaystyle","texprimestyle");F=a.TeX[values.displaystyle?"sup1":values.texprimestyle?"sup3":"sup2"];w=Math.max(w,F*K,k.d+1/4*I,H.superscriptshift);B.Add(k,m.w+J,w);this.data[this.sup].SVGdata.dx=J;this.data[this.sup].SVGdata.dy=w}else{o=Math.max(o,a.TeX.sub2*K);var x=a.TeX.rule_thickness*K;if(w-k.d-(n.h-o)<3*x){o=3*x-w+k.d+n.h;C=4/5*I-(w-k.d);if(C>0){w+=C;o-=C}}B.Add(k,m.w+J,Math.max(w,H.superscriptshift));B.Add(n,m.w,-Math.max(o,H.subscriptshift));this.data[this.sup].SVGdata.dx=J;this.data[this.sup].SVGdata.dy=Math.max(w,H.superscriptshift);this.data[this.sub].SVGdata.dy=-Math.max(o,H.subscriptshift)}}B.Clean();this.SVGhandleColor(B);this.SVGsaveData(B);return B}});g.mmultiscripts.Augment({toSVG:g.mbase.SVGautoload});
g.mtable.Augment({toSVG:g.mbase.SVGautoload});g["annotation-xml"].Augment({toSVG:g.mbase.SVGautoload});g.math.Augment({SVG:i.Subclass({type:"svg",removeable:false}),toSVG:function(t,m){if(this.data[0]){this.SVGgetStyles();g.mbase.prototype.displayAlign=c.config.displayAlign;g.mbase.prototype.displayIndent=c.config.displayIndent;var q=i.G({stroke:"black",fill:"black","stroke-width":0,transform:"matrix(1 0 0 -1 0 0)"}).With({removeable:false});q.Add(this.data[0].toSVG(),0,0,true);q.Clean();this.SVGhandleColor(q);var s=this.SVG();s.element.setAttribute("xmlns:xlink",j);s.Add(q);s.Clean();this.SVGsaveData(s);if(!t){s.element=s.element.firstChild;s.element.removeAttribute("transform");s.removable=true;return s}var p=Math.max(-s.l,0),k=Math.max(s.r-s.w,0);var n=s.element.style;n.width=a.Ex(p+s.w+k);n.height=a.Ex(s.H+s.D+2*a.em);n.verticalAlign=a.Ex(-s.D-3*a.em);n.marginLeft=a.Ex(-p);n.marginRight=a.Ex(-k);s.element.setAttribute("viewBox",-p+" "+(-s.H-a.em)+" "+(p+s.w+k)+" "+(s.H+s.D+2*a.em));s.element.style.margin="1px 0px";if(s.H>s.h||s.D>s.d){var o=e.Element("span",{style:{display:"inline-block","white-space":"nowrap",padding:"1px 0px"},isMathJax:true},[["span",{style:{display:"inline-block",position:"relative",isMathJax:true,width:a.Ex(s.w),height:a.Ex(s.h+s.d),"vertical-align":a.Ex(-s.d)}}]]);o.firstChild.appendChild(s.element);s.element=o;n.verticalAlign=n.margin="";n.position="absolute";n.bottom=a.Ex(s.d-s.D);n.left=0}t.appendChild(s.element);s.element=null;if(!this.isMultiline&&this.Get("display")==="block"){var u=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(u.indentalignfirst!==g.INDENTALIGN.INDENTALIGN){u.indentalign=u.indentalignfirst}if(u.indentalign===g.INDENTALIGN.AUTO){u.indentalign=this.displayAlign}m.style.textAlign=u.indentalign;if(u.indentshiftfirst!==g.INDENTSHIFT.INDENTSHIFT){u.indentshift=u.indentshiftfirst}if(u.indentshift==="auto"){u.indentshift=this.displayIndent}if(u.indentshift&&u.indentalign!==g.INDENTALIGN.CENTER&&!s.hasIndent){t.style[{left:"marginLeft",right:"marginRight"}[u.indentalign]]=a.Ex(a.length2em(u.indentshift))}}}return t}});g.TeXAtom.Augment({toSVG:function(k,n){this.SVGgetStyles();var l=this.SVG();this.SVGhandleSpace(l);if(this.data[0]!=null){var m=this.SVGdataStretched(0,k,n),o=0;if(this.texClass===g.TEXCLASS.VCENTER){o=a.TeX.axis_height-(m.h+m.d)/2+m.d}l.Add(m,0,o);l.ic=m.ic}this.SVGhandleColor(l);this.SVGsaveData(l);return l}});c.Register.StartupHook("onLoad",function(){setTimeout(MathJax.Callback(["loadComplete",a,"jax.js"]),0)})});c.Browser.Select({Opera:function(k){a.Augment({operaZoomRefresh:true})}});c.Register.StartupHook("End Cookie",function(){if(c.config.menuSettings.zoom!=="None"){h.Require("[MathJax]/extensions/MathZoom.js")}});if(!document.createElementNS){if(!document.namespaces.svg){document.namespaces.add("svg",b)}a.Augment({Element:function(k,l){var m=typeof k==="string"?document.createElement("svg:"+k):k;m.isMathJax=true;if(l){for(var n in l){if(l.hasOwnProperty(n)){m.setAttribute(n,l[n].toString())}}}return m}})}})(MathJax.Ajax,MathJax.Hub,MathJax.HTML,MathJax.OutputJax.SVG);(function(m,b,p,h){var o="2.4.0";var l="MathJax_Main",q="MathJax_Main-bold",n="MathJax_Math-italic",i="MathJax_AMS",g="MathJax_Size1",f="MathJax_Size2",e="MathJax_Size3",c="MathJax_Size4";var j="H",a="V",k={load:"extra",dir:j},d={load:"extra",dir:a};var r=[[1e3,l],[1200,g],[1800,f],[2400,e],[3e3,c]];m.Augment({FONTDATA:{version:o,baselineskip:1200,lineH:800,lineD:200,FONTS:{MathJax_Main:"Main/Regular/Main.js","MathJax_Main-bold":"Main/Bold/Main.js","MathJax_Main-italic":"Main/Italic/Main.js","MathJax_Math-italic":"Math/Italic/Main.js","MathJax_Math-bold-italic":"Math/BoldItalic/Main.js",MathJax_Caligraphic:"Caligraphic/Regular/Main.js",MathJax_Size1:"Size1/Regular/Main.js",MathJax_Size2:"Size2/Regular/Main.js",MathJax_Size3:"Size3/Regular/Main.js",MathJax_Size4:"Size4/Regular/Main.js",MathJax_AMS:"AMS/Regular/Main.js",MathJax_Fraktur:"Fraktur/Regular/Main.js","MathJax_Fraktur-bold":"Fraktur/Bold/Main.js",MathJax_SansSerif:"SansSerif/Regular/Main.js","MathJax_SansSerif-bold":"SansSerif/Bold/Main.js","MathJax_SansSerif-italic":"SansSerif/Italic/Main.js",MathJax_Script:"Script/Regular/Main.js",MathJax_Typewriter:"Typewriter/Regular/Main.js","MathJax_Caligraphic-bold":"Caligraphic/Bold/Main.js"},VARIANT:{normal:{fonts:[l,g,i],offsetG:945,variantG:"italic",remap:{913:65,914:66,917:69,918:90,919:72,921:73,922:75,924:77,925:78,927:79,929:80,932:84,935:88,8726:[8726,"-TeX-variant"],8463:[8463,"-TeX-variant"],8242:[39,"sans-serif-italic"],10744:[47,b.VARIANT.ITALIC]}},bold:{fonts:[q,g,i],bold:true,offsetG:945,variantG:"bold-italic",remap:{913:65,914:66,917:69,918:90,919:72,921:73,922:75,924:77,925:78,927:79,929:80,932:84,935:88,10744:[47,"bold-italic"],8602:"↚",8603:"↛",8622:"↮",8653:"⇍",8654:"⇎",8655:"⇏",8708:"∄",8740:"∤",8742:"∦",8769:"≁",8775:"≇",8814:"≮",8815:"≯",8816:"≰",8817:"≱",8832:"⊀",8833:"⊁",8840:"⊈",8841:"⊉",8876:"⊬",8877:"⊭",8928:"⋠",8929:"⋡"}},italic:{fonts:[n,"MathJax_Main-italic",l,g,i],italic:true,remap:{913:65,914:66,917:69,918:90,919:72,921:73,922:75,924:77,925:78,927:79,929:80,932:84,935:88}},"bold-italic":{fonts:["MathJax_Math-bold-italic",q,g,i],bold:true,italic:true,remap:{913:65,914:66,917:69,918:90,919:72,921:73,922:75,924:77,925:78,927:79,929:80,932:84,935:88}},"double-struck":{fonts:[i,l]},fraktur:{fonts:["MathJax_Fraktur",l,g,i]},"bold-fraktur":{fonts:["MathJax_Fraktur-bold",q,g,i],bold:true},script:{fonts:["MathJax_Script",l,g,i]},"bold-script":{fonts:["MathJax_Script",q,g,i],bold:true},"sans-serif":{fonts:["MathJax_SansSerif",l,g,i]},"bold-sans-serif":{fonts:["MathJax_SansSerif-bold",q,g,i],bold:true},"sans-serif-italic":{fonts:["MathJax_SansSerif-italic","MathJax_Main-italic",g,i],italic:true},"sans-serif-bold-italic":{fonts:["MathJax_SansSerif-italic","MathJax_Main-italic",g,i],bold:true,italic:true},monospace:{fonts:["MathJax_Typewriter",l,g,i]},"-tex-caligraphic":{fonts:["MathJax_Caligraphic",l],offsetA:65,variantA:"italic"},"-tex-oldstyle":{fonts:["MathJax_Caligraphic",l]},"-tex-mathit":{fonts:["MathJax_Main-italic",n,l,g,i],italic:true,noIC:true,remap:{913:65,914:66,917:69,918:90,919:72,921:73,922:75,924:77,925:78,927:79,929:80,932:84,935:88}},"-TeX-variant":{fonts:[i,l,g],remap:{8808:57356,8809:57357,8816:57361,8817:57358,10887:57360,10888:57359,8740:57350,8742:57351,8840:57366,8841:57368,8842:57370,8843:57371,10955:57367,10956:57369,988:57352,1008:57353,8726:[8726,b.VARIANT.NORMAL],8463:[8463,b.VARIANT.NORMAL]}},"-largeOp":{fonts:[f,g,l]},"-smallOp":{fonts:[g,l]},"-tex-caligraphic-bold":{fonts:["MathJax_Caligraphic-bold","MathJax_Main-bold","MathJax_Main","MathJax_Math","MathJax_Size1"],bold:true,offsetA:65,variantA:"bold-italic"},"-tex-oldstyle-bold":{fonts:["MathJax_Caligraphic-bold","MathJax_Main-bold","MathJax_Main","MathJax_Math","MathJax_Size1"],bold:true}},RANGES:[{name:"alpha",low:97,high:122,offset:"A",add:32},{name:"number",low:48,high:57,offset:"N"},{name:"greek",low:945,high:1014,offset:"G"}],RULECHAR:8722,REMAP:{160:32,8254:713,8400:8636,8401:8640,8406:8592,8417:8596,8428:8641,8429:8637,8430:8592,8431:8594,8432:42,65079:9182,65080:9183,183:8901,697:8242,978:933,8213:8212,8215:95,8226:8729,8260:47,8965:8892,8966:10846,9642:9632,9652:9650,9653:9651,9656:9654,9662:9660,9663:9661,9666:9664,9001:10216,9002:10217,12296:10216,12297:10217,10072:8739,10799:215,9723:9633,9724:9632,8450:[67,b.VARIANT.DOUBLESTRUCK],8459:[72,b.VARIANT.SCRIPT],8460:[72,b.VARIANT.FRAKTUR],8461:[72,b.VARIANT.DOUBLESTRUCK],8462:[104,b.VARIANT.ITALIC],8464:[74,b.VARIANT.SCRIPT],8465:[73,b.VARIANT.FRAKTUR],8466:[76,b.VARIANT.SCRIPT],8469:[78,b.VARIANT.DOUBLESTRUCK],8473:[80,b.VARIANT.DOUBLESTRUCK],8474:[81,b.VARIANT.DOUBLESTRUCK],8475:[82,b.VARIANT.SCRIPT],8476:[82,b.VARIANT.FRAKTUR],8477:[82,b.VARIANT.DOUBLESTRUCK],8484:[90,b.VARIANT.DOUBLESTRUCK],8486:[937,b.VARIANT.NORMAL],8488:[90,b.VARIANT.FRAKTUR],8492:[66,b.VARIANT.SCRIPT],8493:[67,b.VARIANT.FRAKTUR],8496:[69,b.VARIANT.SCRIPT],8497:[70,b.VARIANT.SCRIPT],8499:[77,b.VARIANT.SCRIPT],8775:8774,8988:9484,8989:9488,8990:9492,8991:9496,8708:"∄",8716:"∌",8772:"≄",8777:"≉",8802:"≢",8813:"≭",8820:"≴",8821:"≵",8824:"≸",8825:"≹",8836:"⊄",8837:"⊅",8930:"⋢",8931:"⋣",10764:"∬∬",8243:"′′",8244:"′′′",8246:"‵‵",8247:"‵‵‵",8279:"′′′′",8411:"...",8412:"...."},REMAPACCENT:{"→":"⃗","′":"'","‵":"`"},REMAPACCENTUNDER:{},PLANE1MAP:[[119808,119833,65,b.VARIANT.BOLD],[119834,119859,97,b.VARIANT.BOLD],[119860,119885,65,b.VARIANT.ITALIC],[119886,119911,97,b.VARIANT.ITALIC],[119912,119937,65,b.VARIANT.BOLDITALIC],[119938,119963,97,b.VARIANT.BOLDITALIC],[119964,119989,65,b.VARIANT.SCRIPT],[120068,120093,65,b.VARIANT.FRAKTUR],[120094,120119,97,b.VARIANT.FRAKTUR],[120120,120145,65,b.VARIANT.DOUBLESTRUCK],[120172,120197,65,b.VARIANT.BOLDFRAKTUR],[120198,120223,97,b.VARIANT.BOLDFRAKTUR],[120224,120249,65,b.VARIANT.SANSSERIF],[120250,120275,97,b.VARIANT.SANSSERIF],[120276,120301,65,b.VARIANT.BOLDSANSSERIF],[120302,120327,97,b.VARIANT.BOLDSANSSERIF],[120328,120353,65,b.VARIANT.SANSSERIFITALIC],[120354,120379,97,b.VARIANT.SANSSERIFITALIC],[120432,120457,65,b.VARIANT.MONOSPACE],[120458,120483,97,b.VARIANT.MONOSPACE],[120488,120513,913,b.VARIANT.BOLD],[120546,120570,913,b.VARIANT.ITALIC],[120572,120603,945,b.VARIANT.ITALIC],[120604,120628,913,b.VARIANT.BOLDITALIC],[120630,120661,945,b.VARIANT.BOLDITALIC],[120662,120686,913,b.VARIANT.BOLDSANSSERIF],[120720,120744,913,b.VARIANT.SANSSERIFBOLDITALIC],[120782,120791,48,b.VARIANT.BOLD],[120802,120811,48,b.VARIANT.SANSSERIF],[120812,120821,48,b.VARIANT.BOLDSANSSERIF],[120822,120831,48,b.VARIANT.MONOSPACE]],REMAPGREEK:{913:65,914:66,917:69,918:90,919:72,921:73,922:75,924:77,925:78,927:79,929:80,930:920,932:84,935:88,938:8711,970:8706,971:1013,972:977,973:1008,974:981,975:1009,976:982},RemapPlane1:function(v,u){for(var t=0,s=this.PLANE1MAP.length;t<s;t++){if(v<this.PLANE1MAP[t][0]){break}if(v<=this.PLANE1MAP[t][1]){v=v-this.PLANE1MAP[t][0]+this.PLANE1MAP[t][2];if(this.REMAPGREEK[v]){v=this.REMAPGREEK[v]}u=this.VARIANT[this.PLANE1MAP[t][3]];break}}return{n:v,variant:u}},DELIMITERS:{40:{dir:a,HW:r,stretch:{top:[9115,c],ext:[9116,c],bot:[9117,c]}},41:{dir:a,HW:r,stretch:{top:[9118,c],ext:[9119,c],bot:[9120,c]}},47:{dir:a,HW:r},91:{dir:a,HW:r,stretch:{top:[9121,c],ext:[9122,c],bot:[9123,c]}},92:{dir:a,HW:r},93:{dir:a,HW:r,stretch:{top:[9124,c],ext:[9125,c],bot:[9126,c]}},123:{dir:a,HW:r,stretch:{top:[9127,c],mid:[9128,c],bot:[9129,c],ext:[9130,c]}},124:{dir:a,HW:[[1e3,l]],stretch:{ext:[8739,l]}},125:{dir:a,HW:r,stretch:{top:[9131,c],mid:[9132,c],bot:[9133,c],ext:[9130,c]}},175:{dir:j,HW:[[.59,l]],stretch:{rep:[175,l]}},710:{dir:j,HW:[[267+250,l],[567+250,g],[1005+330,f],[1447+330,e],[1909,c]]},732:{dir:j,HW:[[333+250,l],[555+250,g],[1e3+330,f],[1443+330,e],[1887,c]]},8214:{dir:a,HW:[[602,g],[1e3,l,null,8741]],stretch:{ext:[8741,l]}},8592:{dir:j,HW:[[1e3,l]],stretch:{left:[8592,l],rep:[8722,l],fuzz:300}},8593:{dir:a,HW:[[888,l]],stretch:{top:[8593,g],ext:[9168,g]}},8594:{dir:j,HW:[[1e3,l]],stretch:{rep:[8722,l],right:[8594,l],fuzz:300}},8595:{dir:a,HW:[[888,l]],stretch:{ext:[9168,g],bot:[8595,g]}},8596:{dir:j,HW:[[1e3,l]],stretch:{left:[8592,l],rep:[8722,l],right:[8594,l],fuzz:300}},8597:{dir:a,HW:[[1044,l]],stretch:{top:[8593,g],ext:[9168,g],bot:[8595,g]}},8656:{dir:j,HW:[[1e3,l]],stretch:{left:[8656,l],rep:[61,l],fuzz:300}},8657:{dir:a,HW:[[888,l]],stretch:{top:[8657,g],ext:[8214,g]}},8658:{dir:j,HW:[[1e3,l]],stretch:{rep:[61,l],right:[8658,l],fuzz:300}},8659:{dir:a,HW:[[888,l]],stretch:{ext:[8214,g],bot:[8659,g]}},8660:{dir:j,HW:[[1e3,l]],stretch:{left:[8656,l],rep:[61,l],right:[8658,l],fuzz:300}},8661:{dir:a,HW:[[1044,l]],stretch:{top:[8657,g],ext:[8214,g],bot:[8659,g]}},8722:{dir:j,HW:[[611,l]],stretch:{rep:[8722,l],fuzz:300}},8730:{dir:a,HW:r,stretch:{top:[57345,c],ext:[57344,c],bot:[9143,c],fullExtenders:true}},8739:{dir:a,HW:[[1e3,l]],stretch:{ext:[8739,l]}},8741:{dir:a,HW:[[1e3,l]],stretch:{ext:[8741,l]}},8968:{dir:a,HW:r,stretch:{top:[9121,c],ext:[9122,c]}},8969:{dir:a,HW:r,stretch:{top:[9124,c],ext:[9125,c]}},8970:{dir:a,HW:r,stretch:{ext:[9122,c],bot:[9123,c]}},8971:{dir:a,HW:r,stretch:{ext:[9125,c],bot:[9126,c]}},9130:{dir:a,HW:[[320,c]],stretch:{top:[9130,c],ext:[9130,c],bot:[9130,c]}},9136:{dir:a,HW:[[989,l]],stretch:{top:[9127,c],ext:[9130,c],bot:[9133,c]}},9137:{dir:a,HW:[[989,l]],stretch:{top:[9131,c],ext:[9130,c],bot:[9129,c]}},9168:{dir:a,HW:[[602,g],[1e3,l,null,8739]],stretch:{ext:[8739,l]}},9182:{dir:j,HW:[],stretch:{min:.9,left:[57680,c],mid:[[57683,57682],c],right:[57681,c],rep:[57684,c]}},9183:{dir:j,HW:[],stretch:{min:.9,left:[57682,c],mid:[[57681,57680],c],right:[57683,c],rep:[57684,c]}},10216:{dir:a,HW:r},10217:{dir:a,HW:r},10222:{dir:a,HW:[[989,l]],stretch:{top:[9127,c],ext:[9130,c],bot:[9129,c]}},10223:{dir:a,HW:[[989,l]],stretch:{top:[9131,c],ext:[9130,c],bot:[9133,c]}},45:{alias:8722,dir:j},94:{alias:710,dir:j},95:{alias:8722,dir:j},126:{alias:732,dir:j},713:{alias:175,dir:j},770:{alias:710,dir:j},771:{alias:732,dir:j},780:{alias:711,dir:j},818:{alias:8722,dir:j},8213:{alias:8722,dir:j},8215:{alias:8722,dir:j},8254:{alias:175,dir:j},8725:{alias:47,dir:a},9001:{alias:10216,dir:a},9002:{alias:10217,dir:a},9135:{alias:8722,dir:j},9472:{alias:8722,dir:j},10072:{alias:8739,dir:a},12296:{alias:10216,dir:a},12297:{alias:10217,dir:a},65079:{alias:9182,dir:j},65080:{alias:9183,dir:j},61:k,8606:k,8608:k,8612:k,8613:d,8614:k,8615:d,8624:d,8625:d,8636:k,8637:k,8638:d,8639:d,8640:k,8641:k,8642:d,8643:d,8666:k,8667:k,9140:k,9141:k,9180:k,9181:k,9184:k,9185:k,10502:k,10503:k,10574:k,10575:d,10576:k,10577:d,10586:k,10587:k,10588:d,10589:d,10590:k,10591:k,10592:d,10593:d,10229:{alias:8592,dir:j},10230:{alias:8594,dir:j},10231:{alias:8596,dir:j},10232:{alias:8656,dir:j},10233:{alias:8658,dir:j},10234:{alias:8660,dir:j},10235:{alias:8612,dir:j},10236:{alias:8614,dir:j},10237:{alias:10502,dir:j},10238:{alias:10503,dir:j}}}});m.FONTDATA.FONTS.MathJax_Main={directory:"Main/Regular",family:"MathJax_Main",id:"MJMAIN",skew:{305:.0278,567:.0833,8467:.111,8472:.111,8706:.0833},Ranges:[[32,127,"BasicLatin"],[256,383,"LatinExtendedA"],[384,591,"LatinExtendedB"],[688,767,"SpacingModLetters"],[768,879,"CombDiacritMarks"],[880,1023,"GreekAndCoptic"],[8448,8527,"LetterlikeSymbols"],[8704,8959,"MathOperators"],[9632,9727,"GeometricShapes"],[9728,9983,"MiscSymbols"],[10752,11007,"SuppMathOperators"]],32:[0,0,250,0,0,""],40:[750,250,389,94,333,"94 250Q94 319 104 381T127 488T164 576T202 643T244 695T277 729T302 750H315H319Q333 750 333 741Q333 738 316 720T275 667T226 581T184 443T167 250T184 58T225 -81T274 -167T316 -220T333 -241Q333 -250 318 -250H315H302L274 -226Q180 -141 137 -14T94 250"],41:[750,250,389,55,294,"60 749L64 750Q69 750 74 750H86L114 726Q208 641 251 514T294 250Q294 182 284 119T261 12T224 -76T186 -143T145 -194T113 -227T90 -246Q87 -249 86 -250H74Q66 -250 63 -250T58 -247T55 -238Q56 -237 66 -225Q221 -64 221 250T66 725Q56 737 55 738Q55 746 60 749"],43:[583,82,778,56,722,"56 237T56 250T70 270H369V420L370 570Q380 583 389 583Q402 583 409 568V270H707Q722 262 722 250T707 230H409V-68Q401 -82 391 -82H389H387Q375 -82 369 -68V230H70Q56 237 56 250"],44:[121,195,278,78,210,"78 35T78 60T94 103T137 121Q165 121 187 96T210 8Q210 -27 201 -60T180 -117T154 -158T130 -185T117 -194Q113 -194 104 -185T95 -172Q95 -168 106 -156T131 -126T157 -76T173 -3V9L172 8Q170 7 167 6T161 3T152 1T140 0Q113 0 96 17"],46:[120,0,278,78,199,"78 60Q78 84 95 102T138 120Q162 120 180 104T199 61Q199 36 182 18T139 0T96 17T78 60"],47:[750,250,500,56,444,"423 750Q432 750 438 744T444 730Q444 725 271 248T92 -240Q85 -250 75 -250Q68 -250 62 -245T56 -231Q56 -221 230 257T407 740Q411 750 423 750"],48:[666,22,500,39,460,"96 585Q152 666 249 666Q297 666 345 640T423 548Q460 465 460 320Q460 165 417 83Q397 41 362 16T301 -15T250 -22Q224 -22 198 -16T137 16T82 83Q39 165 39 320Q39 494 96 585ZM321 597Q291 629 250 629Q208 629 178 597Q153 571 145 525T137 333Q137 175 145 125T181 46Q209 16 250 16Q290 16 318 46Q347 76 354 130T362 333Q362 478 354 524T321 597"],49:[666,0,500,83,427,"213 578L200 573Q186 568 160 563T102 556H83V602H102Q149 604 189 617T245 641T273 663Q275 666 285 666Q294 666 302 660V361L303 61Q310 54 315 52T339 48T401 46H427V0H416Q395 3 257 3Q121 3 100 0H88V46H114Q136 46 152 46T177 47T193 50T201 52T207 57T213 61V578"],50:[666,0,500,50,449,"109 429Q82 429 66 447T50 491Q50 562 103 614T235 666Q326 666 387 610T449 465Q449 422 429 383T381 315T301 241Q265 210 201 149L142 93L218 92Q375 92 385 97Q392 99 409 186V189H449V186Q448 183 436 95T421 3V0H50V19V31Q50 38 56 46T86 81Q115 113 136 137Q145 147 170 174T204 211T233 244T261 278T284 308T305 340T320 369T333 401T340 431T343 464Q343 527 309 573T212 619Q179 619 154 602T119 569T109 550Q109 549 114 549Q132 549 151 535T170 489Q170 464 154 447T109 429"],51:[665,22,500,42,457,"127 463Q100 463 85 480T69 524Q69 579 117 622T233 665Q268 665 277 664Q351 652 390 611T430 522Q430 470 396 421T302 350L299 348Q299 347 308 345T337 336T375 315Q457 262 457 175Q457 96 395 37T238 -22Q158 -22 100 21T42 130Q42 158 60 175T105 193Q133 193 151 175T169 130Q169 119 166 110T159 94T148 82T136 74T126 70T118 67L114 66Q165 21 238 21Q293 21 321 74Q338 107 338 175V195Q338 290 274 322Q259 328 213 329L171 330L168 332Q166 335 166 348Q166 366 174 366Q202 366 232 371Q266 376 294 413T322 525V533Q322 590 287 612Q265 626 240 626Q208 626 181 615T143 592T132 580H135Q138 579 143 578T153 573T165 566T175 555T183 540T186 520Q186 498 172 481T127 463"],52:[677,0,500,28,471,"462 0Q444 3 333 3Q217 3 199 0H190V46H221Q241 46 248 46T265 48T279 53T286 61Q287 63 287 115V165H28V211L179 442Q332 674 334 675Q336 677 355 677H373L379 671V211H471V165H379V114Q379 73 379 66T385 54Q393 47 442 46H471V0H462ZM293 211V545L74 212L183 211H293"],53:[666,22,500,50,449,"164 157Q164 133 148 117T109 101H102Q148 22 224 22Q294 22 326 82Q345 115 345 210Q345 313 318 349Q292 382 260 382H254Q176 382 136 314Q132 307 129 306T114 304Q97 304 95 310Q93 314 93 485V614Q93 664 98 664Q100 666 102 666Q103 666 123 658T178 642T253 634Q324 634 389 662Q397 666 402 666Q410 666 410 648V635Q328 538 205 538Q174 538 149 544L139 546V374Q158 388 169 396T205 412T256 420Q337 420 393 355T449 201Q449 109 385 44T229 -22Q148 -22 99 32T50 154Q50 178 61 192T84 210T107 214Q132 214 148 197T164 157"],54:[666,22,500,41,456,"42 313Q42 476 123 571T303 666Q372 666 402 630T432 550Q432 525 418 510T379 495Q356 495 341 509T326 548Q326 592 373 601Q351 623 311 626Q240 626 194 566Q147 500 147 364L148 360Q153 366 156 373Q197 433 263 433H267Q313 433 348 414Q372 400 396 374T435 317Q456 268 456 210V192Q456 169 451 149Q440 90 387 34T253 -22Q225 -22 199 -14T143 16T92 75T56 172T42 313ZM257 397Q227 397 205 380T171 335T154 278T148 216Q148 133 160 97T198 39Q222 21 251 21Q302 21 329 59Q342 77 347 104T352 209Q352 289 347 316T329 361Q302 397 257 397"],55:[676,22,500,55,485,"55 458Q56 460 72 567L88 674Q88 676 108 676H128V672Q128 662 143 655T195 646T364 644H485V605L417 512Q408 500 387 472T360 435T339 403T319 367T305 330T292 284T284 230T278 162T275 80Q275 66 275 52T274 28V19Q270 2 255 -10T221 -22Q210 -22 200 -19T179 0T168 40Q168 198 265 368Q285 400 349 489L395 552H302Q128 552 119 546Q113 543 108 522T98 479L95 458V455H55V458"],56:[666,22,500,43,457,"70 417T70 494T124 618T248 666Q319 666 374 624T429 515Q429 485 418 459T392 417T361 389T335 371T324 363L338 354Q352 344 366 334T382 323Q457 264 457 174Q457 95 399 37T249 -22Q159 -22 101 29T43 155Q43 263 172 335L154 348Q133 361 127 368Q70 417 70 494ZM286 386L292 390Q298 394 301 396T311 403T323 413T334 425T345 438T355 454T364 471T369 491T371 513Q371 556 342 586T275 624Q268 625 242 625Q201 625 165 599T128 534Q128 511 141 492T167 463T217 431Q224 426 228 424L286 386ZM250 21Q308 21 350 55T392 137Q392 154 387 169T375 194T353 216T330 234T301 253T274 270Q260 279 244 289T218 306L210 311Q204 311 181 294T133 239T107 157Q107 98 150 60T250 21"],57:[666,22,500,42,456,"352 287Q304 211 232 211Q154 211 104 270T44 396Q42 412 42 436V444Q42 537 111 606Q171 666 243 666Q245 666 249 666T257 665H261Q273 665 286 663T323 651T370 619T413 560Q456 472 456 334Q456 194 396 97Q361 41 312 10T208 -22Q147 -22 108 7T68 93T121 149Q143 149 158 135T173 96Q173 78 164 65T148 49T135 44L131 43Q131 41 138 37T164 27T206 22H212Q272 22 313 86Q352 142 352 280V287ZM244 248Q292 248 321 297T351 430Q351 508 343 542Q341 552 337 562T323 588T293 615T246 625Q208 625 181 598Q160 576 154 546T147 441Q147 358 152 329T172 282Q197 248 244 248"],58:[430,0,278,78,199,"78 370Q78 394 95 412T138 430Q162 430 180 414T199 371Q199 346 182 328T139 310T96 327T78 370ZM78 60Q78 84 95 102T138 120Q162 120 180 104T199 61Q199 36 182 18T139 0T96 17T78 60"],59:[430,194,278,78,202,"78 370Q78 394 95 412T138 430Q162 430 180 414T199 371Q199 346 182 328T139 310T96 327T78 370ZM78 60Q78 85 94 103T137 121Q202 121 202 8Q202 -44 183 -94T144 -169T118 -194Q115 -194 106 -186T95 -174Q94 -171 107 -155T137 -107T160 -38Q161 -32 162 -22T165 -4T165 4Q165 5 161 4T142 0Q110 0 94 18T78 60"],60:[540,40,778,83,695,"694 -11T694 -19T688 -33T678 -40Q671 -40 524 29T234 166L90 235Q83 240 83 250Q83 261 91 266Q664 540 678 540Q681 540 687 534T694 519T687 505Q686 504 417 376L151 250L417 124Q686 -4 687 -5Q694 -11 694 -19"],61:[367,-133,778,56,722,"56 347Q56 360 70 367H707Q722 359 722 347Q722 336 708 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153"],62:[540,40,778,82,694,"84 520Q84 528 88 533T96 539L99 540Q106 540 253 471T544 334L687 265Q694 260 694 250T687 235Q685 233 395 96L107 -40H101Q83 -38 83 -20Q83 -19 83 -17Q82 -10 98 -1Q117 9 248 71Q326 108 378 132L626 250L378 368Q90 504 86 509Q84 513 84 520"],91:[750,250,278,118,255,"118 -250V750H255V710H158V-210H255V-250H118"],92:[750,250,500,56,444,"56 731Q56 740 62 745T75 750Q85 750 92 740Q96 733 270 255T444 -231Q444 -239 438 -244T424 -250Q414 -250 407 -240Q404 -236 230 242T56 731"],93:[750,250,278,22,159,"22 710V750H159V-250H22V-210H119V710H22"],94:[694,-531,500,112,387,"112 560L249 694L257 686Q387 562 387 560L361 531Q359 532 303 581L250 627L195 580Q182 569 169 557T148 538L140 532Q138 530 125 546L112 560"],97:[448,11,500,34,493,"137 305T115 305T78 320T63 359Q63 394 97 421T218 448Q291 448 336 416T396 340Q401 326 401 309T402 194V124Q402 76 407 58T428 40Q443 40 448 56T453 109V145H493V106Q492 66 490 59Q481 29 455 12T400 -6T353 12T329 54V58L327 55Q325 52 322 49T314 40T302 29T287 17T269 6T247 -2T221 -8T190 -11Q130 -11 82 20T34 107Q34 128 41 147T68 188T116 225T194 253T304 268H318V290Q318 324 312 340Q290 411 215 411Q197 411 181 410T156 406T148 403Q170 388 170 359Q170 334 154 320ZM126 106Q126 75 150 51T209 26Q247 26 276 49T315 109Q317 116 318 175Q318 233 317 233Q309 233 296 232T251 223T193 203T147 166T126 106"],98:[695,11,556,20,522,"307 -11Q234 -11 168 55L158 37Q156 34 153 28T147 17T143 10L138 1L118 0H98V298Q98 599 97 603Q94 622 83 628T38 637H20V660Q20 683 22 683L32 684Q42 685 61 686T98 688Q115 689 135 690T165 693T176 694H179V543Q179 391 180 391L183 394Q186 397 192 401T207 411T228 421T254 431T286 439T323 442Q401 442 461 379T522 216Q522 115 458 52T307 -11ZM182 98Q182 97 187 90T196 79T206 67T218 55T233 44T250 35T271 29T295 26Q330 26 363 46T412 113Q424 148 424 212Q424 287 412 323Q385 405 300 405Q270 405 239 390T188 347L182 339V98"],99:[448,12,444,34,415,"370 305T349 305T313 320T297 358Q297 381 312 396Q317 401 317 402T307 404Q281 408 258 408Q209 408 178 376Q131 329 131 219Q131 137 162 90Q203 29 272 29Q313 29 338 55T374 117Q376 125 379 127T395 129H409Q415 123 415 120Q415 116 411 104T395 71T366 33T318 2T249 -11Q163 -11 99 53T34 214Q34 318 99 383T250 448T370 421T404 357Q404 334 387 320"],100:[695,11,556,34,535,"376 495Q376 511 376 535T377 568Q377 613 367 624T316 637H298V660Q298 683 300 683L310 684Q320 685 339 686T376 688Q393 689 413 690T443 693T454 694H457V390Q457 84 458 81Q461 61 472 55T517 46H535V0Q533 0 459 -5T380 -11H373V44L365 37Q307 -11 235 -11Q158 -11 96 50T34 215Q34 315 97 378T244 442Q319 442 376 393V495ZM373 342Q328 405 260 405Q211 405 173 369Q146 341 139 305T131 211Q131 155 138 120T173 59Q203 26 251 26Q322 26 373 103V342"],101:[448,11,444,28,415,"28 218Q28 273 48 318T98 391T163 433T229 448Q282 448 320 430T378 380T406 316T415 245Q415 238 408 231H126V216Q126 68 226 36Q246 30 270 30Q312 30 342 62Q359 79 369 104L379 128Q382 131 395 131H398Q415 131 415 121Q415 117 412 108Q393 53 349 21T250 -11Q155 -11 92 58T28 218ZM333 275Q322 403 238 411H236Q228 411 220 410T195 402T166 381T143 340T127 274V267H333V275"],102:[705,0,306,26,372,"273 0Q255 3 146 3Q43 3 34 0H26V46H42Q70 46 91 49Q99 52 103 60Q104 62 104 224V385H33V431H104V497L105 564L107 574Q126 639 171 668T266 704Q267 704 275 704T289 705Q330 702 351 679T372 627Q372 604 358 590T321 576T284 590T270 627Q270 647 288 667H284Q280 668 273 668Q245 668 223 647T189 592Q183 572 182 497V431H293V385H185V225Q185 63 186 61T189 57T194 54T199 51T206 49T213 48T222 47T231 47T241 46T251 46H282V0H273"],103:[453,206,500,29,485,"329 409Q373 453 429 453Q459 453 472 434T485 396Q485 382 476 371T449 360Q416 360 412 390Q410 404 415 411Q415 412 416 414V415Q388 412 363 393Q355 388 355 386Q355 385 359 381T368 369T379 351T388 325T392 292Q392 230 343 187T222 143Q172 143 123 171Q112 153 112 133Q112 98 138 81Q147 75 155 75T227 73Q311 72 335 67Q396 58 431 26Q470 -13 470 -72Q470 -139 392 -175Q332 -206 250 -206Q167 -206 107 -175Q29 -140 29 -75Q29 -39 50 -15T92 18L103 24Q67 55 67 108Q67 155 96 193Q52 237 52 292Q52 355 102 398T223 442Q274 442 318 416L329 409ZM299 343Q294 371 273 387T221 404Q192 404 171 388T145 343Q142 326 142 292Q142 248 149 227T179 192Q196 182 222 182Q244 182 260 189T283 207T294 227T299 242Q302 258 302 292T299 343ZM403 -75Q403 -50 389 -34T348 -11T299 -2T245 0H218Q151 0 138 -6Q118 -15 107 -34T95 -74Q95 -84 101 -97T122 -127T170 -155T250 -167Q319 -167 361 -139T403 -75"],104:[695,0,556,25,542,"41 46H55Q94 46 102 60V68Q102 77 102 91T102 124T102 167T103 217T103 272T103 329Q103 366 103 407T103 482T102 542T102 586T102 603Q99 622 88 628T43 637H25V660Q25 683 27 683L37 684Q47 685 66 686T103 688Q120 689 140 690T170 693T181 694H184V367Q244 442 328 442Q451 442 463 329Q464 322 464 190V104Q464 66 466 59T477 49Q498 46 526 46H542V0H534L510 1Q487 2 460 2T422 3Q319 3 310 0H302V46H318Q379 46 379 62Q380 64 380 200Q379 335 378 343Q372 371 358 385T334 402T308 404Q263 404 229 370Q202 343 195 315T187 232V168V108Q187 78 188 68T191 55T200 49Q221 46 249 46H265V0H257L234 1Q210 2 183 2T145 3Q42 3 33 0H25V46H41"],105:[669,0,278,26,255,"69 609Q69 637 87 653T131 669Q154 667 171 652T188 609Q188 579 171 564T129 549Q104 549 87 564T69 609ZM247 0Q232 3 143 3Q132 3 106 3T56 1L34 0H26V46H42Q70 46 91 49Q100 53 102 60T104 102V205V293Q104 345 102 359T88 378Q74 385 41 385H30V408Q30 431 32 431L42 432Q52 433 70 434T106 436Q123 437 142 438T171 441T182 442H185V62Q190 52 197 50T232 46H255V0H247"],106:[669,205,306,-55,218,"98 609Q98 637 116 653T160 669Q183 667 200 652T217 609Q217 579 200 564T158 549Q133 549 116 564T98 609ZM28 -163Q58 -168 64 -168Q124 -168 135 -77Q137 -65 137 141T136 353Q132 371 120 377T72 385H52V408Q52 431 54 431L58 432Q62 432 70 432T87 433T108 434T133 436Q151 437 171 438T202 441T214 442H218V184Q217 -36 217 -59T211 -98Q195 -145 153 -175T58 -205Q9 -205 -23 -179T-55 -117Q-55 -94 -40 -79T-2 -64T36 -79T52 -118Q52 -143 28 -163"],107:[695,0,528,20,511,"36 46H50Q89 46 97 60V68Q97 77 97 91T97 124T98 167T98 217T98 272T98 329Q98 366 98 407T98 482T98 542T97 586T97 603Q94 622 83 628T38 637H20V660Q20 683 22 683L32 684Q42 685 61 686T98 688Q115 689 135 690T165 693T176 694H179V463L180 233L240 287Q300 341 304 347Q310 356 310 364Q310 383 289 385H284V431H293Q308 428 412 428Q475 428 484 431H489V385H476Q407 380 360 341Q286 278 286 274Q286 273 349 181T420 79Q434 60 451 53T500 46H511V0H505Q496 3 418 3Q322 3 307 0H299V46H306Q330 48 330 65Q330 72 326 79Q323 84 276 153T228 222L176 176V120V84Q176 65 178 59T189 49Q210 46 238 46H254V0H246Q231 3 137 3T28 0H20V46H36"],108:[695,0,278,26,263,"42 46H56Q95 46 103 60V68Q103 77 103 91T103 124T104 167T104 217T104 272T104 329Q104 366 104 407T104 482T104 542T103 586T103 603Q100 622 89 628T44 637H26V660Q26 683 28 683L38 684Q48 685 67 686T104 688Q121 689 141 690T171 693T182 694H185V379Q185 62 186 60Q190 52 198 49Q219 46 247 46H263V0H255L232 1Q209 2 183 2T145 3T107 3T57 1L34 0H26V46H42"],109:[443,0,833,25,819,"41 46H55Q94 46 102 60V68Q102 77 102 91T102 122T103 161T103 203Q103 234 103 269T102 328V351Q99 370 88 376T43 385H25V408Q25 431 27 431L37 432Q47 433 65 434T102 436Q119 437 138 438T167 441T178 442H181V402Q181 364 182 364T187 369T199 384T218 402T247 421T285 437Q305 442 336 442Q351 442 364 440T387 434T406 426T421 417T432 406T441 395T448 384T452 374T455 366L457 361L460 365Q463 369 466 373T475 384T488 397T503 410T523 422T546 432T572 439T603 442Q729 442 740 329Q741 322 741 190V104Q741 66 743 59T754 49Q775 46 803 46H819V0H811L788 1Q764 2 737 2T699 3Q596 3 587 0H579V46H595Q656 46 656 62Q657 64 657 200Q656 335 655 343Q649 371 635 385T611 402T585 404Q540 404 506 370Q479 343 472 315T464 232V168V108Q464 78 465 68T468 55T477 49Q498 46 526 46H542V0H534L510 1Q487 2 460 2T422 3Q319 3 310 0H302V46H318Q379 46 379 62Q380 64 380 200Q379 335 378 343Q372 371 358 385T334 402T308 404Q263 404 229 370Q202 343 195 315T187 232V168V108Q187 78 188 68T191 55T200 49Q221 46 249 46H265V0H257L234 1Q210 2 183 2T145 3Q42 3 33 0H25V46H41"],110:[443,0,556,25,542,"41 46H55Q94 46 102 60V68Q102 77 102 91T102 122T103 161T103 203Q103 234 103 269T102 328V351Q99 370 88 376T43 385H25V408Q25 431 27 431L37 432Q47 433 65 434T102 436Q119 437 138 438T167 441T178 442H181V402Q181 364 182 364T187 369T199 384T218 402T247 421T285 437Q305 442 336 442Q450 438 463 329Q464 322 464 190V104Q464 66 466 59T477 49Q498 46 526 46H542V0H534L510 1Q487 2 460 2T422 3Q319 3 310 0H302V46H318Q379 46 379 62Q380 64 380 200Q379 335 378 343Q372 371 358 385T334 402T308 404Q263 404 229 370Q202 343 195 315T187 232V168V108Q187 78 188 68T191 55T200 49Q221 46 249 46H265V0H257L234 1Q210 2 183 2T145 3Q42 3 33 0H25V46H41"],111:[448,10,500,28,471,"28 214Q28 309 93 378T250 448Q340 448 405 380T471 215Q471 120 407 55T250 -10Q153 -10 91 57T28 214ZM250 30Q372 30 372 193V225V250Q372 272 371 288T364 326T348 362T317 390T268 410Q263 411 252 411Q222 411 195 399Q152 377 139 338T126 246V226Q126 130 145 91Q177 30 250 30"],112:[443,194,556,20,522,"36 -148H50Q89 -148 97 -134V-126Q97 -119 97 -107T97 -77T98 -38T98 6T98 55T98 106Q98 140 98 177T98 243T98 296T97 335T97 351Q94 370 83 376T38 385H20V408Q20 431 22 431L32 432Q42 433 61 434T98 436Q115 437 135 438T165 441T176 442H179V416L180 390L188 397Q247 441 326 441Q407 441 464 377T522 216Q522 115 457 52T310 -11Q242 -11 190 33L182 40V-45V-101Q182 -128 184 -134T195 -145Q216 -148 244 -148H260V-194H252L228 -193Q205 -192 178 -192T140 -191Q37 -191 28 -194H20V-148H36ZM424 218Q424 292 390 347T305 402Q234 402 182 337V98Q222 26 294 26Q345 26 384 80T424 218"],113:[442,194,528,33,535,"33 218Q33 308 95 374T236 441H246Q330 441 381 372L387 364Q388 364 404 403L420 442H457V156Q457 -132 458 -134Q462 -142 470 -145Q491 -148 519 -148H535V-194H527L504 -193Q480 -192 453 -192T415 -191Q312 -191 303 -194H295V-148H311Q339 -148 360 -145Q369 -141 371 -135T373 -106V-41V49Q313 -11 236 -11Q154 -11 94 53T33 218ZM376 300Q346 389 278 401Q275 401 269 401T261 402Q211 400 171 350T131 214Q131 137 165 82T253 27Q296 27 328 54T376 118V300"],114:[443,0,392,20,364,"36 46H50Q89 46 97 60V68Q97 77 97 91T98 122T98 161T98 203Q98 234 98 269T98 328L97 351Q94 370 83 376T38 385H20V408Q20 431 22 431L32 432Q42 433 60 434T96 436Q112 437 131 438T160 441T171 442H174V373Q213 441 271 441H277Q322 441 343 419T364 373Q364 352 351 337T313 322Q288 322 276 338T263 372Q263 381 265 388T270 400T273 405Q271 407 250 401Q234 393 226 386Q179 341 179 207V154Q179 141 179 127T179 101T180 81T180 66V61Q181 59 183 57T188 54T193 51T200 49T207 48T216 47T225 47T235 46T245 46H276V0H267Q249 3 140 3Q37 3 28 0H20V46H36"],115:[448,11,394,33,359,"295 316Q295 356 268 385T190 414Q154 414 128 401Q98 382 98 349Q97 344 98 336T114 312T157 287Q175 282 201 278T245 269T277 256Q294 248 310 236T342 195T359 133Q359 71 321 31T198 -10H190Q138 -10 94 26L86 19L77 10Q71 4 65 -1L54 -11H46H42Q39 -11 33 -5V74V132Q33 153 35 157T45 162H54Q66 162 70 158T75 146T82 119T101 77Q136 26 198 26Q295 26 295 104Q295 133 277 151Q257 175 194 187T111 210Q75 227 54 256T33 318Q33 357 50 384T93 424T143 442T187 447H198Q238 447 268 432L283 424L292 431Q302 440 314 448H322H326Q329 448 335 442V310L329 304H301Q295 310 295 316"],116:[615,10,389,18,333,"27 422Q80 426 109 478T141 600V615H181V431H316V385H181V241Q182 116 182 100T189 68Q203 29 238 29Q282 29 292 100Q293 108 293 146V181H333V146V134Q333 57 291 17Q264 -10 221 -10Q187 -10 162 2T124 33T105 68T98 100Q97 107 97 248V385H18V422H27"],117:[443,11,556,25,542,"383 58Q327 -10 256 -10H249Q124 -10 105 89Q104 96 103 226Q102 335 102 348T96 369Q86 385 36 385H25V408Q25 431 27 431L38 432Q48 433 67 434T105 436Q122 437 142 438T172 441T184 442H187V261Q188 77 190 64Q193 49 204 40Q224 26 264 26Q290 26 311 35T343 58T363 90T375 120T379 144Q379 145 379 161T380 201T380 248V315Q380 361 370 372T320 385H302V431Q304 431 378 436T457 442H464V264Q464 84 465 81Q468 61 479 55T524 46H542V0Q540 0 467 -5T390 -11H383V58"],118:[431,11,528,19,508,"338 431Q344 429 422 429Q479 429 503 431H508V385H497Q439 381 423 345Q421 341 356 172T288 -2Q283 -11 263 -11Q244 -11 239 -2Q99 359 98 364Q93 378 82 381T43 385H19V431H25L33 430Q41 430 53 430T79 430T104 429T122 428Q217 428 232 431H240V385H226Q187 384 184 370Q184 366 235 234L286 102L377 341V349Q377 363 367 372T349 383T335 385H331V431H338"],119:[431,11,722,18,703,"90 368Q84 378 76 380T40 385H18V431H24L43 430Q62 430 84 429T116 428Q206 428 221 431H229V385H215Q177 383 177 368Q177 367 221 239L265 113L339 328L333 345Q323 374 316 379Q308 384 278 385H258V431H264Q270 428 348 428Q439 428 454 431H461V385H452Q404 385 404 369Q404 366 418 324T449 234T481 143L496 100L537 219Q579 341 579 347Q579 363 564 373T530 385H522V431H529Q541 428 624 428Q692 428 698 431H703V385H697Q696 385 691 385T682 384Q635 377 619 334L559 161Q546 124 528 71Q508 12 503 1T487 -11H479Q460 -11 456 -4Q455 -3 407 133L361 267Q359 263 266 -4Q261 -11 243 -11H238Q225 -11 220 -3L90 368"],120:[431,0,528,11,516,"201 0Q189 3 102 3Q26 3 17 0H11V46H25Q48 47 67 52T96 61T121 78T139 96T160 122T180 150L226 210L168 288Q159 301 149 315T133 336T122 351T113 363T107 370T100 376T94 379T88 381T80 383Q74 383 44 385H16V431H23Q59 429 126 429Q219 429 229 431H237V385Q201 381 201 369Q201 367 211 353T239 315T268 274L272 270L297 304Q329 345 329 358Q329 364 327 369T322 376T317 380T310 384L307 385H302V431H309Q324 428 408 428Q487 428 493 431H499V385H492Q443 385 411 368Q394 360 377 341T312 257L296 236L358 151Q424 61 429 57T446 50Q464 46 499 46H516V0H510H502Q494 1 482 1T457 2T432 2T414 3Q403 3 377 3T327 1L304 0H295V46H298Q309 46 320 51T331 63Q331 65 291 120L250 175Q249 174 219 133T185 88Q181 83 181 74Q181 63 188 55T206 46Q208 46 208 23V0H201"],121:[431,204,528,19,508,"69 -66Q91 -66 104 -80T118 -116Q118 -134 109 -145T91 -160Q84 -163 97 -166Q104 -168 111 -168Q131 -168 148 -159T175 -138T197 -106T213 -75T225 -43L242 0L170 183Q150 233 125 297Q101 358 96 368T80 381Q79 382 78 382Q66 385 34 385H19V431H26L46 430Q65 430 88 429T122 428Q129 428 142 428T171 429T200 430T224 430L233 431H241V385H232Q183 385 185 366L286 112Q286 113 332 227L376 341V350Q376 365 366 373T348 383T334 385H331V431H337H344Q351 431 361 431T382 430T405 429T422 429Q477 429 503 431H508V385H497Q441 380 422 345Q420 343 378 235T289 9T227 -131Q180 -204 113 -204Q69 -204 44 -177T19 -116Q19 -89 35 -78T69 -66"],122:[431,0,444,28,401,"42 263Q44 270 48 345T53 423V431H393Q399 425 399 415Q399 403 398 402L381 378Q364 355 331 309T265 220L134 41L182 40H206Q254 40 283 46T331 77Q352 105 359 185L361 201Q361 202 381 202H401V196Q401 195 393 103T384 6V0H209L34 1L31 3Q28 8 28 17Q28 30 29 31T160 210T294 394H236Q169 393 152 388Q127 382 113 367Q89 344 82 264V255H42V263"],123:[750,250,500,65,434,"434 -231Q434 -244 428 -250H410Q281 -250 230 -184Q225 -177 222 -172T217 -161T213 -148T211 -133T210 -111T209 -84T209 -47T209 0Q209 21 209 53Q208 142 204 153Q203 154 203 155Q189 191 153 211T82 231Q71 231 68 234T65 250T68 266T82 269Q116 269 152 289T203 345Q208 356 208 377T209 529V579Q209 634 215 656T244 698Q270 724 324 740Q361 748 377 749Q379 749 390 749T408 750H428Q434 744 434 732Q434 719 431 716Q429 713 415 713Q362 710 332 689T296 647Q291 634 291 499V417Q291 370 288 353T271 314Q240 271 184 255L170 250L184 245Q202 239 220 230T262 196T290 137Q291 131 291 1Q291 -134 296 -147Q306 -174 339 -192T415 -213Q429 -213 431 -216Q434 -219 434 -231"],124:[750,249,278,119,159,"139 -249H137Q125 -249 119 -235V251L120 737Q130 750 139 750Q152 750 159 735V-235Q151 -249 141 -249H139"],125:[750,250,500,65,434,"65 731Q65 745 68 747T88 750Q171 750 216 725T279 670Q288 649 289 635T291 501Q292 362 293 357Q306 312 345 291T417 269Q428 269 431 266T434 250T431 234T417 231Q380 231 345 210T298 157Q293 143 292 121T291 -28V-79Q291 -134 285 -156T256 -198Q202 -250 89 -250Q71 -250 68 -247T65 -230Q65 -224 65 -223T66 -218T69 -214T77 -213Q91 -213 108 -210T146 -200T183 -177T207 -139Q208 -134 209 3L210 139Q223 196 280 230Q315 247 330 250Q305 257 280 270Q225 304 212 352L210 362L209 498Q208 635 207 640Q195 680 154 696T77 713Q68 713 67 716T65 731"],168:[669,-554,500,95,405,"95 612Q95 633 112 651T153 669T193 652T210 612Q210 588 194 571T152 554L127 560Q95 577 95 612ZM289 611Q289 634 304 649T335 668Q336 668 340 668T346 669Q369 669 386 652T404 612T387 572T346 554Q323 554 306 570T289 611"],172:[356,-89,667,56,611,"56 323T56 336T70 356H596Q603 353 611 343V102Q598 89 591 89Q587 89 584 90T579 94T575 98T572 102L571 209V316H70Q56 323 56 336"],175:[590,-544,500,69,430,"69 544V590H430V544H69"],176:[715,-542,500,147,352,"147 628Q147 669 179 692T244 715Q298 715 325 689T352 629Q352 592 323 567T249 542Q202 542 175 567T147 628ZM313 628Q313 660 300 669T259 678H253Q248 678 242 678T234 679Q217 679 207 674T192 659T188 644T187 629Q187 600 198 590Q210 579 250 579H265Q279 579 288 581T305 595T313 628"],177:[666,0,778,56,722,"56 320T56 333T70 353H369V502Q369 651 371 655Q376 666 388 666Q402 666 405 654T409 596V500V353H707Q722 345 722 333Q722 320 707 313H409V40H707Q722 32 722 20T707 0H70Q56 7 56 20T70 40H369V313H70Q56 320 56 333"],180:[699,-505,500,203,393,"349 699Q367 699 380 686T393 656Q393 651 392 647T387 637T380 627T367 616T351 602T330 585T303 563L232 505L217 519Q203 533 204 533Q204 534 229 567T282 636T313 678L316 681Q318 684 321 686T328 692T337 697T349 699"],215:[491,-9,778,147,630,"630 29Q630 9 609 9Q604 9 587 25T493 118L389 222L284 117Q178 13 175 11Q171 9 168 9Q160 9 154 15T147 29Q147 36 161 51T255 146L359 250L255 354Q174 435 161 449T147 471Q147 480 153 485T168 490Q173 490 175 489Q178 487 284 383L389 278L493 382Q570 459 587 475T609 491Q630 491 630 471Q630 464 620 453T522 355L418 250L522 145Q606 61 618 48T630 29"],247:[537,36,778,56,721,"318 466Q318 500 339 518T386 537Q418 537 438 517T458 466Q458 438 440 417T388 396Q355 396 337 417T318 466ZM56 237T56 250T70 270H706Q721 262 721 250T706 230H70Q56 237 56 250ZM318 34Q318 68 339 86T386 105Q418 105 438 85T458 34Q458 6 440 -15T388 -36Q355 -36 337 -15T318 34"],710:[694,-531,500,112,387,"112 560L249 694L257 686Q387 562 387 560L361 531Q359 532 303 581L250 627L195 580Q182 569 169 557T148 538L140 532Q138 530 125 546L112 560"],711:[644,-513,500,114,385,"114 611L127 630L136 644Q138 644 193 612Q248 581 250 581L306 612Q361 644 363 644L385 611L318 562L249 513L114 611"],713:[590,-544,500,69,430,"69 544V590H430V544H69"],714:[699,-505,500,203,393,"349 699Q367 699 380 686T393 656Q393 651 392 647T387 637T380 627T367 616T351 602T330 585T303 563L232 505L217 519Q203 533 204 533Q204 534 229 567T282 636T313 678L316 681Q318 684 321 686T328 692T337 697T349 699"],715:[699,-505,500,106,296,"106 655Q106 671 119 685T150 699Q166 699 177 688Q190 671 222 629T275 561T295 533T282 519L267 505L196 563Q119 626 113 634Q106 643 106 655"],728:[694,-515,500,92,407,"250 515Q179 515 138 565T92 683V694H129V689Q129 688 129 683T130 675Q137 631 169 599T248 567Q304 567 337 608T370 689V694H407V683Q403 617 361 566T250 515"],729:[669,-549,500,190,309,"190 609Q190 637 208 653T252 669Q275 667 292 652T309 609Q309 579 292 564T250 549Q225 549 208 564T190 609"],732:[668,-565,500,83,416,"179 601Q164 601 151 595T131 584T111 565L97 577L83 588Q83 589 95 603T121 633T142 654Q165 668 187 668T253 650T320 632Q335 632 348 638T368 649T388 668L402 656L416 645Q375 586 344 572Q330 565 313 565Q292 565 248 583T179 601"],8211:[285,-248,500,0,499,"0 248V285H499V248H0"],8212:[285,-248,1e3,0,999,"0 248V285H999V248H0"],8216:[694,-379,278,64,199,"64 494Q64 548 86 597T131 670T160 694Q163 694 172 685T182 672Q182 669 170 656T144 625T116 573T101 501Q101 489 102 489T107 491T120 497T138 500Q163 500 180 483T198 440T181 397T139 379Q110 379 87 405T64 494"],8217:[694,-379,278,78,212,"78 634Q78 659 95 676T138 694Q166 694 189 668T212 579Q212 525 190 476T146 403T118 379Q114 379 105 388T95 401Q95 404 107 417T133 448T161 500T176 572Q176 584 175 584T170 581T157 576T139 573Q114 573 96 590T78 634"],8220:[694,-379,500,128,466,"128 494Q128 528 137 560T158 616T185 658T209 685T223 694T236 685T245 670Q244 668 231 654T204 622T178 571T164 501Q164 489 165 489T170 491T183 497T201 500Q226 500 244 483T262 440T245 397T202 379Q173 379 151 405T128 494ZM332 494Q332 528 341 560T362 616T389 658T413 685T427 694T439 685T449 672Q449 669 437 656T411 625T383 573T368 501Q368 489 369 489T374 491T387 497T405 500Q430 500 448 483T466 440T449 397T406 379Q377 379 355 405T332 494"],8221:[694,-379,500,34,372,"34 634Q34 659 50 676T93 694Q121 694 144 668T168 579Q168 525 146 476T101 403T73 379Q69 379 60 388T50 401Q50 404 62 417T88 448T116 500T131 572Q131 584 130 584T125 581T112 576T94 573Q69 573 52 590T34 634ZM238 634Q238 659 254 676T297 694Q325 694 348 668T372 579Q372 525 350 476T305 403T277 379Q273 379 264 388T254 401Q254 404 266 417T292 448T320 500T335 572Q335 584 334 584T329 581T316 576T298 573Q273 573 256 590T238 634"],8224:[705,216,444,54,389,"182 675Q195 705 222 705Q234 705 243 700T253 691T263 675L262 655Q262 620 252 549T240 454V449Q250 451 288 461T346 472T377 461T389 431Q389 417 379 404T346 390Q327 390 288 401T243 412H240V405Q245 367 250 339T258 301T261 274T263 225Q263 124 255 -41T239 -213Q236 -216 222 -216H217Q206 -216 204 -212T200 -186Q199 -175 199 -168Q181 38 181 225Q181 265 182 280T191 327T204 405V412H201Q196 412 157 401T98 390Q76 390 66 403T55 431T65 458T98 472Q116 472 155 462T205 449Q204 452 204 460T201 490T193 547Q182 619 182 655V675"],8225:[705,205,444,54,389,"181 658Q181 705 222 705T263 658Q263 633 252 572T240 497Q240 496 241 496Q243 496 285 507T345 519Q365 519 376 508T388 478Q388 466 384 458T375 447T361 438H344Q318 438 282 448T241 459Q240 458 240 456Q240 449 251 384T263 297Q263 278 255 267T238 253T222 250T206 252T190 266T181 297Q181 323 192 383T204 458Q204 459 203 459Q198 459 162 449T101 438H84Q74 443 70 446T61 457T56 478Q56 497 67 508T99 519Q117 519 159 508T203 496Q204 496 204 499Q204 507 193 572T181 658ZM181 202Q181 249 222 249T263 202Q263 185 259 161T249 103T240 48V41H243Q248 41 287 52T346 63T377 52T389 22Q389 8 379 -5T346 -19Q327 -19 288 -8T243 3H240V-4Q243 -24 249 -58T259 -117T263 -158Q263 -177 255 -188T238 -202T222 -205T206 -203T190 -189T181 -158Q181 -141 185 -117T195 -59T204 -4V3H201Q196 3 157 -8T98 -19Q76 -19 66 -6T55 22T65 49T98 63Q117 63 156 52T201 41H204V48Q201 68 195 102T185 161T181 202"],8230:[120,0,1172,78,1093,"78 60Q78 84 95 102T138 120Q162 120 180 104T199 61Q199 36 182 18T139 0T96 17T78 60ZM525 60Q525 84 542 102T585 120Q609 120 627 104T646 61Q646 36 629 18T586 0T543 17T525 60ZM972 60Q972 84 989 102T1032 120Q1056 120 1074 104T1093 61Q1093 36 1076 18T1033 0T990 17T972 60"],8242:[560,-43,275,30,262,"79 43Q73 43 52 49T30 61Q30 68 85 293T146 528Q161 560 198 560Q218 560 240 545T262 501Q262 496 260 486Q259 479 173 263T84 45T79 43"],8407:[714,-516,0,-471,-29,"-123 694Q-123 702 -118 708T-103 714Q-93 714 -88 706T-80 687T-67 660T-40 633Q-29 626 -29 615Q-29 606 -36 600T-53 590T-83 571T-121 531Q-135 516 -143 516T-157 522T-163 536T-152 559T-129 584T-116 595H-287L-458 596Q-459 597 -461 599T-466 602T-469 607T-471 615Q-471 622 -458 635H-99Q-123 673 -123 694"],8592:[511,11,1e3,55,944,"944 261T944 250T929 230H165Q167 228 182 216T211 189T244 152T277 96T303 25Q308 7 308 0Q308 -11 288 -11Q281 -11 278 -11T272 -7T267 2T263 21Q245 94 195 151T73 236Q58 242 55 247Q55 254 59 257T73 264Q121 283 158 314T215 375T247 434T264 480L267 497Q269 503 270 505T275 509T288 511Q308 511 308 500Q308 493 303 475Q293 438 278 406T246 352T215 315T185 287T165 270H929Q944 261 944 250"],8593:[694,193,500,17,483,"27 414Q17 414 17 433Q17 437 17 439T17 444T19 447T20 450T22 452T26 453T30 454T36 456Q80 467 120 494T180 549Q227 607 238 678Q240 694 251 694Q259 694 261 684Q261 677 265 659T284 608T320 549Q340 525 363 507T405 479T440 463T467 455T479 451Q483 447 483 433Q483 413 472 413Q467 413 458 416Q342 448 277 545L270 555V-179Q262 -193 252 -193H250H248Q236 -193 230 -179V555L223 545Q192 499 146 467T70 424T27 414"],8594:[511,11,1e3,56,944,"56 237T56 250T70 270H835Q719 357 692 493Q692 494 692 496T691 499Q691 511 708 511H711Q720 511 723 510T729 506T732 497T735 481T743 456Q765 389 816 336T935 261Q944 258 944 250Q944 244 939 241T915 231T877 212Q836 186 806 152T761 85T740 35T732 4Q730 -6 727 -8T711 -11Q691 -11 691 0Q691 7 696 25Q728 151 835 230H70Q56 237 56 250"],8595:[694,194,500,17,483,"473 86Q483 86 483 67Q483 63 483 61T483 56T481 53T480 50T478 48T474 47T470 46T464 44Q428 35 391 14T316 -55T264 -168Q264 -170 263 -173T262 -180T261 -184Q259 -194 251 -194Q242 -194 238 -176T221 -121T180 -49Q169 -34 155 -21T125 2T95 20T67 33T44 42T27 47L21 49Q17 53 17 67Q17 87 28 87Q33 87 42 84Q158 52 223 -45L230 -55V312Q230 391 230 482T229 591Q229 662 231 676T243 693Q244 694 251 694Q264 692 270 679V-55L277 -45Q307 1 353 33T430 76T473 86"],8596:[511,11,1e3,55,944,"263 479Q267 501 271 506T288 511Q308 511 308 500Q308 493 303 475Q293 438 278 406T246 352T215 315T185 287T165 270H835Q729 349 696 475Q691 493 691 500Q691 511 711 511Q720 511 723 510T729 506T732 497T735 481T743 456Q765 389 816 336T935 261Q944 258 944 250Q944 244 939 241T915 231T877 212Q836 186 806 152T761 85T740 35T732 4Q730 -6 727 -8T711 -11Q691 -11 691 0Q691 7 696 25Q728 151 835 230H165Q167 228 182 216T211 189T244 152T277 96T303 25Q308 7 308 0Q308 -11 288 -11Q281 -11 278 -11T272 -7T267 2T263 21Q245 94 195 151T73 236Q58 242 55 247Q55 254 59 257T73 264Q144 292 194 349T263 479"],8597:[772,272,500,17,483,"27 492Q17 492 17 511Q17 515 17 517T17 522T19 525T20 528T22 530T26 531T30 532T36 534Q80 545 120 572T180 627Q210 664 223 701T238 755T250 772T261 762Q261 757 264 741T282 691T319 628Q352 589 390 566T454 536L479 529Q483 525 483 511Q483 491 472 491Q467 491 458 494Q342 526 277 623L270 633V-133L277 -123Q307 -77 353 -45T430 -2T473 8Q483 8 483 -11Q483 -15 483 -17T483 -22T481 -25T480 -28T478 -30T474 -31T470 -32T464 -34Q407 -49 364 -84T300 -157T270 -223T261 -262Q259 -272 250 -272Q242 -272 239 -255T223 -201T180 -127Q169 -112 155 -99T125 -76T95 -58T67 -45T44 -36T27 -31L21 -29Q17 -25 17 -11Q17 9 28 9Q33 9 42 6Q158 -26 223 -123L230 -133V633L223 623Q192 577 146 545T70 502T27 492"],8598:[720,195,1e3,29,944,"204 662Q257 662 301 676T369 705T394 720Q398 720 407 711T417 697Q417 688 389 671T310 639T212 623Q176 623 153 628Q151 628 221 557T546 232Q942 -164 943 -168Q944 -170 944 -174Q944 -182 938 -188T924 -195Q922 -195 916 -193Q912 -191 517 204Q440 281 326 394T166 553L121 598Q126 589 126 541Q126 438 70 349Q59 332 52 332Q48 332 39 341T29 355Q29 358 38 372T57 407T77 464T86 545Q86 583 78 614T63 663T55 683Q55 693 65 693Q73 693 82 688Q136 662 204 662"],8599:[720,195,1e3,55,971,"582 697Q582 701 591 710T605 720Q607 720 630 706T697 677T795 662Q830 662 863 670T914 686T934 694Q942 694 944 685Q944 680 936 663T921 615T913 545Q913 490 927 446T956 379T970 355Q970 351 961 342T947 332Q940 332 929 349Q874 436 874 541Q874 590 878 598L832 553Q787 508 673 395T482 204Q87 -191 83 -193Q77 -195 75 -195Q67 -195 61 -189T55 -174Q55 -170 56 -168Q58 -164 453 232Q707 487 777 557T847 628Q824 623 787 623Q689 623 599 679Q582 690 582 697"],8600:[695,220,1e3,55,970,"55 675Q55 683 60 689T75 695Q77 695 83 693Q87 691 482 296Q532 246 605 174T717 62T799 -20T859 -80T878 -97Q874 -93 874 -41Q874 64 929 151Q940 168 947 168Q951 168 960 159T970 145Q970 143 956 121T928 54T913 -45Q913 -83 920 -114T936 -163T944 -185Q942 -194 934 -194Q932 -194 914 -186T864 -170T795 -162Q743 -162 698 -176T630 -205T605 -220Q601 -220 592 -211T582 -197Q582 -187 611 -170T691 -138T787 -123Q824 -123 847 -128Q848 -128 778 -57T453 268Q58 664 56 668Q55 670 55 675"],8601:[695,220,1e3,29,944,"126 -41Q126 -92 121 -97Q121 -98 139 -80T200 -20T281 61T394 173T517 296Q909 690 916 693Q922 695 924 695Q932 695 938 689T944 674Q944 670 943 668Q942 664 546 268Q292 13 222 -57T153 -128Q176 -123 212 -123Q310 -123 400 -179Q417 -190 417 -197Q417 -201 408 -210T394 -220Q392 -220 369 -206T302 -177T204 -162Q131 -162 67 -194Q63 -195 59 -192T55 -183Q55 -180 62 -163T78 -115T86 -45Q86 10 72 54T44 120T29 145Q29 149 38 158T52 168Q59 168 70 151Q126 62 126 -41"],8614:[511,11,1e3,54,944,"95 155V109Q95 83 92 73T75 63Q61 63 58 74T54 130Q54 140 54 180T55 250Q55 421 57 425Q61 437 75 437Q88 437 91 428T95 393V345V270H835Q719 357 692 493Q692 494 692 496T691 499Q691 511 708 511H711Q720 511 723 510T729 506T732 497T735 481T743 456Q765 389 816 336T935 261Q944 258 944 250Q944 244 939 241T915 231T877 212Q836 186 806 152T761 85T740 35T732 4Q730 -6 727 -8T711 -11Q691 -11 691 0Q691 7 696 25Q728 151 835 230H95V155"],8617:[511,11,1126,55,1070,"903 424T903 444T929 464Q976 464 1023 434T1070 347Q1070 316 1055 292T1016 256T971 237T929 230H165Q167 228 182 216T211 189T244 152T277 96T303 25Q308 7 308 0Q308 -11 288 -11Q281 -11 278 -11T272 -7T267 2T263 21Q245 94 195 151T73 236Q58 242 55 247Q55 254 59 257T73 264Q121 283 158 314T215 375T247 434T264 480L267 497Q269 503 270 505T275 509T288 511Q308 511 308 500Q308 493 303 475Q293 438 278 406T246 352T215 315T185 287T165 270H926Q929 270 941 271T960 275T978 280T998 290T1015 307Q1030 325 1030 347Q1030 355 1027 364T1014 387T983 411T929 424H928Q903 424 903 444"],8618:[511,11,1126,55,1070,"55 347Q55 380 72 404T113 441T159 458T197 464Q222 464 222 444Q222 429 204 426T157 417T110 387Q95 369 95 347Q95 339 98 330T111 307T142 283T196 270H961Q845 357 818 493Q818 494 818 496T817 499Q817 511 834 511H837Q846 511 849 510T855 506T858 497T861 481T869 456Q891 389 942 336T1061 261Q1070 258 1070 250Q1070 244 1065 241T1041 231T1003 212Q962 186 932 152T887 85T866 35T858 4Q856 -6 853 -8T837 -11Q817 -11 817 0Q817 7 822 25Q854 151 961 230H196Q149 230 102 260T55 347"],8636:[511,-230,1e3,55,944,"62 230Q56 236 55 244Q55 252 57 255T69 265Q114 292 151 326T208 391T243 448T265 491T273 509Q276 511 288 511Q304 511 306 505Q309 501 303 484Q293 456 279 430T251 383T223 344T196 313T173 291T156 276L148 270H929Q944 261 944 250T929 230H62"],8637:[270,11,1e3,55,944,"55 256Q56 264 62 270H929Q944 261 944 250T929 230H148Q149 229 165 215T196 185T231 145T270 87T303 16Q309 -1 306 -5Q304 -11 288 -11Q279 -11 276 -10T269 -4T264 10T253 36T231 75Q172 173 69 235Q59 242 57 245T55 256"],8640:[511,-230,1e3,56,945,"691 500Q691 511 711 511Q720 511 723 510T730 504T735 490T746 464T768 425Q796 378 835 339T897 285T933 263Q941 258 942 256T944 245T937 230H70Q56 237 56 250T70 270H852Q802 308 762 364T707 455T691 500"],8641:[270,11,1e3,56,944,"56 237T56 250T70 270H937Q944 263 944 256Q944 251 944 250T943 246T940 242T933 238Q794 153 734 7Q729 -7 726 -9T711 -11Q695 -11 693 -5Q690 -1 696 16Q721 84 763 139T852 230H70Q56 237 56 250"],8652:[671,11,1e3,55,945,"691 660Q691 671 711 671Q720 671 723 670T730 664T735 650T746 624T768 585Q797 538 836 499T897 445T933 423Q941 418 942 416T944 405T937 390H70Q56 397 56 410T70 430H852Q802 468 762 524T707 615T691 660ZM55 256Q56 264 62 270H929Q944 261 944 250T929 230H148Q149 229 165 215T196 185T231 145T270 87T303 16Q309 -1 306 -5Q304 -11 288 -11Q279 -11 276 -10T269 -4T264 10T253 36T231 75Q172 173 69 235Q59 242 57 245T55 256"],8656:[525,24,1e3,56,945,"944 153Q944 140 929 133H318L328 123Q379 69 414 0Q419 -13 419 -17Q419 -24 399 -24Q388 -24 385 -23T377 -12Q332 77 253 144T72 237Q62 240 59 242T56 250T59 257T70 262T89 268T119 278T160 296Q303 366 377 512Q382 522 385 523T401 525Q419 524 419 515Q419 510 414 500Q379 431 328 377L318 367H929Q944 359 944 347Q944 336 930 328L602 327H274L264 319Q225 289 147 250Q148 249 165 241T210 217T264 181L274 173H930Q931 172 933 171T936 169T938 167T941 164T942 162T943 158T944 153"],8657:[694,194,611,31,579,"228 -179Q227 -180 226 -182T223 -186T221 -189T218 -192T214 -193T208 -194Q196 -194 189 -181L188 125V430L176 419Q122 369 59 338Q46 330 40 330Q38 330 31 337V350Q31 362 33 365T46 374Q60 381 77 390T128 426T190 484T247 567T292 677Q295 688 298 692Q302 694 305 694Q313 694 318 677Q334 619 363 568T420 485T481 427T532 391T564 374Q575 368 577 365T579 350V337Q572 330 570 330Q564 330 551 338Q487 370 435 419L423 430L422 125V-181Q409 -194 401 -194Q397 -194 394 -193T388 -189T385 -184T382 -180V-177V475L373 487Q331 541 305 602Q304 601 300 591T290 571T278 548T260 519T238 488L229 476L228 148V-179"],8658:[525,24,1e3,56,944,"580 514Q580 525 596 525Q601 525 604 525T609 525T613 524T615 523T617 520T619 517T622 512Q659 438 720 381T831 300T927 263Q944 258 944 250T935 239T898 228T840 204Q696 134 622 -12Q618 -21 615 -22T600 -24Q580 -24 580 -17Q580 -13 585 0Q620 69 671 123L681 133H70Q56 140 56 153Q56 168 72 173H725L735 181Q774 211 852 250Q851 251 834 259T789 283T735 319L725 327H72Q56 332 56 347Q56 360 70 367H681L671 377Q638 412 609 458T580 514"],8659:[694,194,611,31,579,"401 694Q412 694 422 681V375L423 70L435 81Q487 130 551 162Q564 170 570 170Q572 170 579 163V150Q579 138 577 135T564 126Q541 114 518 99T453 48T374 -46T318 -177Q313 -194 305 -194T293 -178T272 -119T225 -31Q158 70 46 126Q35 132 33 135T31 150V163Q38 170 40 170Q46 170 59 162Q122 131 176 81L188 70V375L189 681Q199 694 208 694Q219 694 228 680V352L229 25L238 12Q279 -42 305 -102Q344 -23 373 13L382 25V678Q387 692 401 694"],8660:[526,25,1e3,33,966,"308 524Q318 526 323 526Q340 526 340 514Q340 507 336 499Q326 476 314 454T292 417T274 391T260 374L255 368Q255 367 500 367Q744 367 744 368L739 374Q734 379 726 390T707 416T685 453T663 499Q658 511 658 515Q658 525 680 525Q687 524 690 523T695 519T701 507Q766 359 902 287Q921 276 939 269T961 259T966 250Q966 246 965 244T960 240T949 236T930 228T902 213Q763 137 701 -7Q697 -16 695 -19T690 -23T680 -25Q658 -25 658 -15Q658 -11 663 1Q673 24 685 46T707 83T725 109T739 126L744 132Q744 133 500 133Q255 133 255 132L260 126Q265 121 273 110T292 84T314 47T336 1Q341 -11 341 -15Q341 -25 319 -25Q312 -24 309 -23T304 -19T298 -7Q233 141 97 213Q83 221 70 227T51 235T41 239T35 243T34 250T35 256T40 261T51 265T70 273T97 287Q235 363 299 509Q305 522 308 524ZM792 319L783 327H216Q183 294 120 256L110 250L120 244Q173 212 207 181L216 173H783L792 181Q826 212 879 244L889 250L879 256Q826 288 792 319"],8661:[772,272,611,31,579,"290 755Q298 772 305 772T318 757T343 706T393 633Q431 588 473 558T545 515T579 497V484Q579 464 570 464Q564 464 550 470Q485 497 423 550L422 400V100L423 -50Q485 3 550 30Q565 36 570 36Q579 36 579 16V3Q575 -1 549 -12T480 -53T393 -132Q361 -172 342 -208T318 -258T305 -272T293 -258T268 -208T217 -132Q170 -80 128 -51T61 -12T31 3V16Q31 36 40 36Q46 36 61 30Q86 19 109 6T146 -18T173 -38T188 -50V550Q186 549 173 539T147 519T110 495T61 470Q46 464 40 464Q31 464 31 484V497Q34 500 63 513T135 557T217 633Q267 692 290 755ZM374 598Q363 610 351 625T332 651T316 676T305 695L294 676Q282 657 267 636T236 598L228 589V-89L236 -98Q247 -110 259 -125T278 -151T294 -176T305 -195L316 -176Q328 -157 343 -136T374 -98L382 -89V589L374 598"],8704:[694,22,556,0,556,"0 673Q0 684 7 689T20 694Q32 694 38 680T82 567L126 451H430L473 566Q483 593 494 622T512 668T519 685Q524 694 538 694Q556 692 556 674Q556 670 426 329T293 -15Q288 -22 278 -22T263 -15Q260 -11 131 328T0 673ZM414 410Q414 411 278 411T142 410L278 55L414 410"],8706:[715,22,531,42,567,"202 508Q179 508 169 520T158 547Q158 557 164 577T185 624T230 675T301 710L333 715H345Q378 715 384 714Q447 703 489 661T549 568T566 457Q566 362 519 240T402 53Q321 -22 223 -22Q123 -22 73 56Q42 102 42 148V159Q42 276 129 370T322 465Q383 465 414 434T455 367L458 378Q478 461 478 515Q478 603 437 639T344 676Q266 676 223 612Q264 606 264 572Q264 547 246 528T202 508ZM430 306Q430 372 401 400T333 428Q270 428 222 382Q197 354 183 323T150 221Q132 149 132 116Q132 21 232 21Q244 21 250 22Q327 35 374 112Q389 137 409 196T430 306"],8707:[694,0,556,56,500,"56 661T56 674T70 694H487Q497 686 500 679V15Q497 10 487 1L279 0H70Q56 7 56 20T70 40H460V327H84Q70 334 70 347T84 367H460V654H70Q56 661 56 674"],8709:[772,78,500,39,460,"331 696Q335 708 339 722T345 744T350 759T357 769T367 772Q374 772 381 767T388 754Q388 746 377 712L366 673L378 661Q460 575 460 344Q460 281 456 234T432 126T373 27Q319 -22 250 -22Q214 -22 180 -7Q168 -3 168 -4L159 -33Q148 -71 142 -75Q138 -78 132 -78Q124 -78 118 -72T111 -60Q111 -52 122 -18L133 21L125 29Q39 111 39 344Q39 596 137 675Q187 716 251 716Q265 716 278 714T296 710T315 703T331 696ZM276 676Q264 679 246 679Q196 679 159 631Q134 597 128 536T121 356Q121 234 127 174T151 80L234 366Q253 430 275 506T308 618L318 654Q318 656 294 669L276 676ZM181 42Q207 16 250 16Q291 16 324 47Q354 78 366 136T378 356Q378 470 372 528T349 616L348 613Q348 611 264 326L181 42"],8711:[683,33,833,46,786,"46 676Q46 679 51 683H781Q786 679 786 676Q786 674 617 326T444 -26Q439 -33 416 -33T388 -26Q385 -22 216 326T46 676ZM697 596Q697 597 445 597T193 596Q195 591 319 336T445 80L697 596"],8712:[541,41,667,84,583,"84 250Q84 372 166 450T360 539Q361 539 377 539T419 540T469 540H568Q583 532 583 520Q583 511 570 501L466 500Q355 499 329 494Q280 482 242 458T183 409T147 354T129 306T124 272V270H568Q583 262 583 250T568 230H124V228Q124 207 134 177T167 112T231 48T328 7Q355 1 466 0H570Q583 -10 583 -20Q583 -32 568 -40H471Q464 -40 446 -40T417 -41Q262 -41 172 45Q84 127 84 250"],8713:[716,215,667,84,584,"196 25Q84 109 84 250Q84 372 166 450T360 539Q361 539 375 539T413 540T460 540L547 707Q550 716 563 716Q570 716 575 712T581 703T583 696T505 540H568Q583 532 583 520Q583 511 570 501L484 500L366 270H568Q583 262 583 250T568 230H346L247 38Q284 16 328 7Q355 1 466 0H570Q583 -10 583 -20Q583 -32 568 -40H471Q464 -40 447 -40T419 -41Q304 -41 228 3Q117 -211 115 -212Q111 -215 104 -215T92 -212T86 -204T84 -197Q84 -190 89 -183L196 25ZM214 61L301 230H124V228Q124 196 147 147T214 61ZM321 270L440 500Q353 499 329 494Q280 482 242 458T183 409T147 354T129 306T124 272V270H321"],8715:[541,40,667,83,582,"83 520Q83 532 98 540H195Q202 540 220 540T249 541Q404 541 494 455Q582 374 582 250Q582 165 539 99T434 0T304 -39Q297 -40 195 -40H98Q83 -32 83 -20Q83 -10 96 0H200Q311 1 337 6Q369 14 401 28Q422 39 445 55Q484 85 508 127T537 191T542 228V230H98Q84 237 84 250T98 270H542V272Q542 280 539 295T527 336T497 391T445 445Q422 461 401 472Q386 479 374 483T347 491T325 495T298 498T273 499T239 500T200 500L96 501Q83 511 83 520"],8722:[270,-230,778,84,694,"84 237T84 250T98 270H679Q694 262 694 250T679 230H98Q84 237 84 250"],8723:[500,166,778,56,722,"56 467T56 480T70 500H707Q722 492 722 480T707 460H409V187H707Q722 179 722 167Q722 154 707 147H409V0V-93Q409 -144 406 -155T389 -166Q376 -166 372 -155T368 -105Q368 -96 368 -62T369 -2V147H70Q56 154 56 167T70 187H369V460H70Q56 467 56 480"],8725:[750,250,500,56,444,"423 750Q432 750 438 744T444 730Q444 725 271 248T92 -240Q85 -250 75 -250Q68 -250 62 -245T56 -231Q56 -221 230 257T407 740Q411 750 423 750"],8726:[750,250,500,56,444,"56 731Q56 740 62 745T75 750Q85 750 92 740Q96 733 270 255T444 -231Q444 -239 438 -244T424 -250Q414 -250 407 -240Q404 -236 230 242T56 731"],8727:[465,-35,500,64,435,"229 286Q216 420 216 436Q216 454 240 464Q241 464 245 464T251 465Q263 464 273 456T283 436Q283 419 277 356T270 286L328 328Q384 369 389 372T399 375Q412 375 423 365T435 338Q435 325 425 315Q420 312 357 282T289 250L355 219L425 184Q434 175 434 161Q434 146 425 136T401 125Q393 125 383 131T328 171L270 213Q283 79 283 63Q283 53 276 44T250 35Q231 35 224 44T216 63Q216 80 222 143T229 213L171 171Q115 130 110 127Q106 124 100 124Q87 124 76 134T64 161Q64 166 64 169T67 175T72 181T81 188T94 195T113 204T138 215T170 230T210 250L74 315Q65 324 65 338Q65 353 74 363T98 374Q106 374 116 368T171 328L229 286"],8728:[444,-55,500,55,444,"55 251Q55 328 112 386T249 444T386 388T444 249Q444 171 388 113T250 55Q170 55 113 112T55 251ZM245 403Q188 403 142 361T96 250Q96 183 141 140T250 96Q284 96 313 109T354 135T375 160Q403 197 403 250Q403 313 360 358T245 403"],8729:[444,-55,500,55,444,"55 251Q55 328 112 386T249 444T386 388T444 249Q444 171 388 113T250 55Q170 55 113 112T55 251"],8730:[800,200,833,71,853,"95 178Q89 178 81 186T72 200T103 230T169 280T207 309Q209 311 212 311H213Q219 311 227 294T281 177Q300 134 312 108L397 -77Q398 -77 501 136T707 565T814 786Q820 800 834 800Q841 800 846 794T853 782V776L620 293L385 -193Q381 -200 366 -200Q357 -200 354 -197Q352 -195 256 15L160 225L144 214Q129 202 113 190T95 178"],8733:[442,11,778,56,722,"56 124T56 216T107 375T238 442Q260 442 280 438T319 425T352 407T382 385T406 361T427 336T442 315T455 297T462 285L469 297Q555 442 679 442Q687 442 722 437V398H718Q710 400 694 400Q657 400 623 383T567 343T527 294T503 253T495 235Q495 231 520 192T554 143Q625 44 696 44Q717 44 719 46H722V-5Q695 -11 678 -11Q552 -11 457 141Q455 145 454 146L447 134Q362 -11 235 -11Q157 -11 107 56ZM93 213Q93 143 126 87T220 31Q258 31 292 48T349 88T389 137T413 178T421 196Q421 200 396 239T362 288Q322 345 288 366T213 387Q163 387 128 337T93 213"],8734:[442,11,1e3,55,944,"55 217Q55 305 111 373T254 442Q342 442 419 381Q457 350 493 303L507 284L514 294Q618 442 747 442Q833 442 888 374T944 214Q944 128 889 59T743 -11Q657 -11 580 50Q542 81 506 128L492 147L485 137Q381 -11 252 -11Q166 -11 111 57T55 217ZM907 217Q907 285 869 341T761 397Q740 397 720 392T682 378T648 359T619 335T594 310T574 285T559 263T548 246L543 238L574 198Q605 158 622 138T664 94T714 61T765 51Q827 51 867 100T907 217ZM92 214Q92 145 131 89T239 33Q357 33 456 193L425 233Q364 312 334 337Q285 380 233 380Q171 380 132 331T92 214"],8736:[694,0,722,55,666,"71 0L68 2Q65 3 63 5T58 11T55 20Q55 22 57 28Q67 43 346 361Q397 420 474 508Q595 648 616 671T647 694T661 688T666 674Q666 668 663 663Q662 662 627 622T524 503T390 350L120 41L386 40H653Q666 30 666 20Q666 8 651 0H71"],8739:[750,249,278,119,159,"139 -249H137Q125 -249 119 -235V251L120 737Q130 750 139 750Q152 750 159 735V-235Q151 -249 141 -249H139"],8741:[750,250,500,132,368,"133 736Q138 750 153 750Q164 750 170 739Q172 735 172 250T170 -239Q164 -250 152 -250Q144 -250 138 -244L137 -243Q133 -241 133 -179T132 250Q132 731 133 736ZM329 739Q334 750 346 750Q353 750 361 744L362 743Q366 741 366 679T367 250T367 -178T362 -243L361 -244Q355 -250 347 -250Q335 -250 329 -239Q327 -235 327 250T329 739"],8743:[598,22,667,55,611,"318 591Q325 598 333 598Q344 598 348 591Q349 590 414 445T545 151T611 -4Q609 -22 591 -22Q588 -22 586 -21T581 -20T577 -17T575 -13T572 -9T570 -4L333 528L96 -4Q87 -20 80 -21Q78 -22 75 -22Q57 -22 55 -4Q55 2 120 150T251 444T318 591"],8744:[598,22,667,55,611,"55 580Q56 587 61 592T75 598Q86 598 96 580L333 48L570 580Q579 596 586 597Q588 598 591 598Q609 598 611 580Q611 574 546 426T415 132T348 -15Q343 -22 333 -22T318 -15Q317 -14 252 131T121 425T55 580"],8745:[598,22,667,55,611,"88 -21T75 -21T55 -7V200Q55 231 55 280Q56 414 60 428Q61 430 61 431Q77 500 152 549T332 598Q443 598 522 544T610 405Q611 399 611 194V-7Q604 -22 591 -22Q582 -22 572 -9L570 405Q563 433 556 449T529 485Q498 519 445 538T334 558Q251 558 179 518T96 401Q95 396 95 193V-7Q88 -21 75 -21"],8746:[598,22,667,55,611,"591 598H592Q604 598 611 583V376Q611 345 611 296Q610 162 606 148Q605 146 605 145Q586 68 507 23T333 -22Q268 -22 209 -1T106 66T56 173Q55 180 55 384L56 585Q66 598 75 598Q85 598 95 585V378L96 172L98 162Q112 95 181 57T332 18Q415 18 487 58T570 175Q571 180 571 383V583Q579 598 591 598"],8747:[716,216,417,55,472,"151 -112Q151 -150 106 -161Q106 -165 114 -172T134 -179Q155 -179 170 -146Q181 -120 188 -64T206 101T232 310Q256 472 277 567Q308 716 392 716Q434 716 453 681T472 613Q472 590 458 577T424 564Q404 564 390 578T376 612Q376 650 421 661Q421 663 418 667T407 675T393 679Q387 679 380 675Q360 665 350 619T326 438Q302 190 253 -57Q235 -147 201 -186Q174 -213 138 -216Q93 -216 74 -181T55 -113Q55 -91 69 -78T103 -64Q123 -64 137 -78T151 -112"],8764:[367,-133,778,55,722,"55 166Q55 241 101 304T222 367Q260 367 296 349T362 304T421 252T484 208T554 189Q616 189 655 236T694 338Q694 350 698 358T708 367Q722 367 722 334Q722 260 677 197T562 134H554Q517 134 481 152T414 196T355 248T292 293T223 311Q179 311 145 286Q109 257 96 218T80 156T69 133Q55 133 55 166"],8768:[583,83,278,55,222,"55 569Q55 583 83 583Q122 583 151 565T194 519T215 464T222 411Q222 360 194 304T139 193T111 89Q111 38 134 -7T195 -55Q222 -57 222 -69Q222 -83 189 -83Q130 -83 93 -33T55 90Q55 130 72 174T110 252T148 328T166 411Q166 462 144 507T83 555Q55 556 55 569"],8771:[464,-36,778,55,722,"55 283Q55 356 103 409T217 463Q262 463 297 447T395 382Q431 355 446 344T493 320T554 307H558Q613 307 652 344T694 433Q694 464 708 464T722 432Q722 356 673 304T564 251H554Q510 251 465 275T387 329T310 382T223 407H219Q164 407 122 367Q91 333 85 295T76 253T69 250Q55 250 55 283ZM56 56Q56 71 72 76H706Q722 70 722 56Q722 44 707 36H70Q56 43 56 56"],8773:[589,-22,1e3,55,722,"55 388Q55 463 101 526T222 589Q260 589 296 571T362 526T421 474T484 430T554 411Q616 411 655 458T694 560Q694 572 698 580T708 589Q722 589 722 556Q722 482 677 419T562 356H554Q517 356 481 374T414 418T355 471T292 515T223 533Q179 533 145 508Q109 479 96 440T80 378T69 355Q55 355 55 388ZM56 236Q56 249 70 256H707Q722 248 722 236Q722 225 708 217L390 216H72Q56 221 56 236ZM56 42Q56 57 72 62H708Q722 52 722 42Q722 30 707 22H70Q56 29 56 42"],8776:[483,-55,778,55,722,"55 319Q55 360 72 393T114 444T163 472T205 482Q207 482 213 482T223 483Q262 483 296 468T393 413L443 381Q502 346 553 346Q609 346 649 375T694 454Q694 465 698 474T708 483Q722 483 722 452Q722 386 675 338T555 289Q514 289 468 310T388 357T308 404T224 426Q164 426 125 393T83 318Q81 289 69 289Q55 289 55 319ZM55 85Q55 126 72 159T114 210T163 238T205 248Q207 248 213 248T223 249Q262 249 296 234T393 179L443 147Q502 112 553 112Q609 112 649 141T694 220Q694 249 708 249T722 217Q722 153 675 104T555 55Q514 55 468 76T388 123T308 170T224 192Q164 192 125 159T83 84Q80 55 69 55Q55 55 55 85"],8781:[484,-16,778,55,722,"55 464Q55 471 60 477T74 484Q80 484 108 464T172 420T268 376T389 356Q436 356 483 368T566 399T630 436T675 467T695 482Q701 484 703 484Q711 484 716 478T722 464Q722 454 707 442Q550 316 389 316Q338 316 286 329T195 362T124 402T76 437T57 456Q55 462 55 464ZM57 45Q66 58 109 88T230 151T381 183Q438 183 494 168T587 135T658 94T703 61T720 45Q722 39 722 36Q722 28 717 22T703 16Q697 16 669 36T606 80T510 124T389 144Q341 144 294 132T211 101T147 64T102 33T82 18Q76 16 74 16Q66 16 61 22T55 36Q55 39 57 45"],8784:[670,-133,778,56,722,"56 347Q56 360 70 367H707Q722 359 722 347Q722 336 708 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153ZM329 610Q329 634 346 652T389 670Q413 670 431 654T450 611Q450 586 433 568T390 550T347 567T329 610"],8800:[716,215,778,56,722,"166 -215T159 -215T147 -212T141 -204T139 -197Q139 -190 144 -183L306 133H70Q56 140 56 153Q56 168 72 173H327L406 327H72Q56 332 56 347Q56 360 70 367H426Q597 702 602 707Q605 716 618 716Q625 716 630 712T636 703T638 696Q638 692 471 367H707Q722 359 722 347Q722 336 708 328L451 327L371 173H708Q722 163 722 153Q722 140 707 133H351Q175 -210 170 -212Q166 -215 159 -215"],8801:[464,-36,778,56,722,"56 444Q56 457 70 464H707Q722 456 722 444Q722 430 706 424H72Q56 429 56 444ZM56 237T56 250T70 270H707Q722 262 722 250T707 230H70Q56 237 56 250ZM56 56Q56 71 72 76H706Q722 70 722 56Q722 44 707 36H70Q56 43 56 56"],8804:[636,138,778,83,694,"674 636Q682 636 688 630T694 615T687 601Q686 600 417 472L151 346L399 228Q687 92 691 87Q694 81 694 76Q694 58 676 56H670L382 192Q92 329 90 331Q83 336 83 348Q84 359 96 365Q104 369 382 500T665 634Q669 636 674 636ZM84 -118Q84 -108 99 -98H678Q694 -104 694 -118Q694 -130 679 -138H98Q84 -131 84 -118"],8805:[636,138,778,82,694,"83 616Q83 624 89 630T99 636Q107 636 253 568T543 431T687 361Q694 356 694 346T687 331Q685 329 395 192L107 56H101Q83 58 83 76Q83 77 83 79Q82 86 98 95Q117 105 248 167Q326 204 378 228L626 346L360 472Q291 505 200 548Q112 589 98 597T83 616ZM84 -118Q84 -108 99 -98H678Q694 -104 694 -118Q694 -130 679 -138H98Q84 -131 84 -118"],8810:[568,67,1e3,56,944,"639 -48Q639 -54 634 -60T619 -67H618Q612 -67 536 -26Q430 33 329 88Q61 235 59 239Q56 243 56 250T59 261Q62 266 336 415T615 567L619 568Q622 567 625 567Q639 562 639 548Q639 540 633 534Q632 532 374 391L117 250L374 109Q632 -32 633 -34Q639 -40 639 -48ZM944 -48Q944 -54 939 -60T924 -67H923Q917 -67 841 -26Q735 33 634 88Q366 235 364 239Q361 243 361 250T364 261Q367 266 641 415T920 567L924 568Q927 567 930 567Q944 562 944 548Q944 540 938 534Q937 532 679 391L422 250L679 109Q937 -32 938 -34Q944 -40 944 -48"],8811:[567,67,1e3,55,944,"55 539T55 547T60 561T74 567Q81 567 207 498Q297 449 365 412Q633 265 636 261Q639 255 639 250Q639 241 626 232Q614 224 365 88Q83 -65 79 -66Q76 -67 73 -67Q65 -67 60 -61T55 -47Q55 -39 61 -33Q62 -33 95 -15T193 39T320 109L321 110H322L323 111H324L325 112L326 113H327L329 114H330L331 115H332L333 116L334 117H335L336 118H337L338 119H339L340 120L341 121H342L343 122H344L345 123H346L347 124L348 125H349L351 126H352L353 127H354L355 128L356 129H357L358 130H359L360 131H361L362 132L363 133H364L365 134H366L367 135H368L369 136H370L371 137L372 138H373L374 139H375L376 140L378 141L576 251Q63 530 62 533Q55 539 55 547ZM360 539T360 547T365 561T379 567Q386 567 512 498Q602 449 670 412Q938 265 941 261Q944 255 944 250Q944 241 931 232Q919 224 670 88Q388 -65 384 -66Q381 -67 378 -67Q370 -67 365 -61T360 -47Q360 -39 366 -33Q367 -33 400 -15T498 39T625 109L626 110H627L628 111H629L630 112L631 113H632L634 114H635L636 115H637L638 116L639 117H640L641 118H642L643 119H644L645 120L646 121H647L648 122H649L650 123H651L652 124L653 125H654L656 126H657L658 127H659L660 128L661 129H662L663 130H664L665 131H666L667 132L668 133H669L670 134H671L672 135H673L674 136H675L676 137L677 138H678L679 139H680L681 140L683 141L881 251Q368 530 367 533Q360 539 360 547"],8826:[539,41,778,84,694,"84 249Q84 262 91 266T117 270Q120 270 126 270T137 269Q388 273 512 333T653 512Q657 539 676 539Q685 538 689 532T694 520V515Q689 469 672 431T626 366T569 320T500 286T435 265T373 249Q379 248 404 242T440 233T477 221T533 199Q681 124 694 -17Q694 -41 674 -41Q658 -41 653 -17Q646 41 613 84T533 154T418 197T284 220T137 229H114Q104 229 98 230T88 235T84 249"],8827:[539,41,778,83,694,"84 517Q84 539 102 539Q115 539 119 529T125 503T137 459T171 404Q277 275 640 269H661Q694 269 694 249T661 229H640Q526 227 439 214T283 173T173 98T124 -17Q118 -41 103 -41Q83 -41 83 -17Q88 29 105 67T151 132T208 178T277 212T342 233T404 249Q401 250 380 254T345 263T302 276T245 299Q125 358 92 468Q84 502 84 517"],8834:[541,41,778,84,694,"84 250Q84 372 166 450T360 539Q361 539 370 539T395 539T430 540T475 540T524 540H679Q694 532 694 520Q694 511 681 501L522 500H470H441Q366 500 338 496T266 472Q244 461 224 446T179 404T139 337T124 250V245Q124 157 185 89Q244 25 328 7Q348 2 366 2T522 0H681Q694 -10 694 -20Q694 -32 679 -40H526Q510 -40 480 -40T434 -41Q350 -41 289 -25T172 45Q84 127 84 250"],8835:[541,40,778,83,693,"83 520Q83 532 98 540H251Q267 540 297 540T343 541Q427 541 488 525T605 455Q693 374 693 250Q693 165 650 99T545 0T415 -39Q407 -40 251 -40H98Q83 -32 83 -20Q83 -10 96 0H255H308H337Q412 0 439 4T512 28Q533 39 553 54T599 96T639 163T654 250Q654 341 592 411Q557 449 512 472Q468 491 439 495T335 500H306H255L96 501Q83 511 83 520"],8838:[637,138,778,84,694,"84 346Q84 468 166 546T360 635Q361 635 370 635T395 635T430 636T475 636T524 636H679Q694 628 694 616Q694 607 681 597L522 596H470H441Q366 596 338 592T266 568Q244 557 224 542T179 500T139 433T124 346V341Q124 253 185 185Q244 121 328 103Q348 98 366 98T522 96H681Q694 86 694 76Q694 64 679 56H526Q510 56 480 56T434 55Q350 55 289 71T172 141Q84 223 84 346ZM104 -131T104 -118T118 -98H679Q694 -106 694 -118T679 -138H118Q104 -131 104 -118"],8839:[637,138,778,83,693,"83 616Q83 628 98 636H251Q267 636 297 636T343 637Q427 637 488 621T605 551Q693 470 693 346Q693 261 650 195T545 96T415 57Q407 56 251 56H98Q83 64 83 76Q83 86 96 96H255H308H337Q412 96 439 100T512 124Q533 135 553 150T599 192T639 259T654 346Q654 437 592 507Q557 545 512 568Q468 587 439 591T335 596H306H255L96 597Q83 607 83 616ZM84 -131T84 -118T98 -98H659Q674 -106 674 -118T659 -138H98Q84 -131 84 -118"],8846:[598,22,667,55,611,"591 598H592Q604 598 611 583V376Q611 345 611 296Q610 162 606 148Q605 146 605 145Q586 68 507 23T333 -22Q268 -22 209 -1T106 66T56 173Q55 180 55 384L56 585Q66 598 75 598Q85 598 95 585V378L96 172L98 162Q112 95 181 57T332 18Q415 18 487 58T570 175Q571 180 571 383V583Q579 598 591 598ZM313 406Q313 417 313 435T312 459Q312 483 316 493T333 503T349 494T353 461V406V325H515Q516 325 519 323T527 316T531 305T527 294T520 287T515 285H353V204V152Q353 127 350 117T333 107T316 117T312 152Q312 158 312 175T313 204V285H151Q150 285 147 287T139 294T135 305T139 316T146 323T151 325H313V406"],8849:[636,138,778,84,714,"94 620Q98 632 110 636H699Q714 628 714 616T699 596H134V96H698Q714 90 714 76Q714 64 699 56H109Q104 59 95 69L94 344V620ZM84 -118Q84 -103 100 -98H698Q714 -104 714 -118Q714 -130 699 -138H98Q84 -131 84 -118"],8850:[636,138,778,64,694,"64 603T64 616T78 636H668Q675 633 683 623V69Q675 59 668 56H78Q64 63 64 76Q64 91 80 96H643V596H78Q64 603 64 616ZM64 -118Q64 -108 79 -98H678Q694 -104 694 -118Q694 -130 679 -138H78Q64 -131 64 -118"],8851:[598,0,667,61,605,"83 0Q79 0 76 1T71 3T67 6T65 9T63 13T61 16V301L62 585Q70 595 76 598H592Q602 590 605 583V15Q598 2 587 0Q583 0 580 1T575 3T571 6T569 9T567 13T565 16V558H101V15Q94 2 83 0"],8852:[598,0,667,61,605,"77 0Q65 4 61 16V301L62 585Q72 598 81 598Q94 598 101 583V40H565V583Q573 598 585 598Q598 598 605 583V15Q602 10 592 1L335 0H77"],8853:[583,83,778,56,722,"56 250Q56 394 156 488T384 583Q530 583 626 485T722 250Q722 110 625 14T390 -83Q249 -83 153 14T56 250ZM364 542Q308 539 251 509T148 418T96 278V270H369V542H364ZM681 278Q675 338 650 386T592 462T522 509T458 535T412 542H409V270H681V278ZM96 222Q104 150 139 95T219 12T302 -29T366 -42H369V230H96V222ZM681 222V230H409V-42H412Q429 -42 456 -36T521 -10T590 37T649 113T681 222"],8854:[583,83,778,56,722,"56 250Q56 394 156 488T384 583Q530 583 626 485T722 250Q722 110 625 14T390 -83Q249 -83 153 14T56 250ZM681 278Q669 385 591 463T381 542Q283 542 196 471T96 278V270H681V278ZM275 -42T388 -42T585 32T681 222V230H96V222Q108 107 191 33"],8855:[583,83,778,56,722,"56 250Q56 394 156 488T384 583Q530 583 626 485T722 250Q722 110 625 14T390 -83Q249 -83 153 14T56 250ZM582 471Q531 510 496 523Q446 542 381 542Q324 542 272 519T196 471L389 278L485 375L582 471ZM167 442Q95 362 95 250Q95 137 167 58L359 250L167 442ZM610 58Q682 138 682 250Q682 363 610 442L418 250L610 58ZM196 29Q209 16 230 2T295 -27T388 -42Q409 -42 429 -40T465 -33T496 -23T522 -11T544 1T561 13T574 22T582 29L388 222L196 29"],8856:[583,83,778,56,722,"56 250Q56 394 156 488T384 583Q530 583 626 485T722 250Q722 110 625 14T390 -83Q249 -83 153 14T56 250ZM582 471Q581 472 571 480T556 491T539 502T517 514T491 525T460 534T424 539T381 542Q272 542 184 460T95 251Q95 198 113 150T149 80L167 58L582 471ZM388 -42Q513 -42 597 44T682 250Q682 363 610 442L196 29Q209 16 229 2T295 -27T388 -42"],8857:[583,83,778,56,722,"56 250Q56 394 156 488T384 583Q530 583 626 485T722 250Q722 110 625 14T390 -83Q249 -83 153 14T56 250ZM682 250Q682 322 649 387T546 497T381 542Q272 542 184 459T95 250Q95 132 178 45T389 -42Q515 -42 598 45T682 250ZM311 250Q311 285 332 304T375 328Q376 328 382 328T392 329Q424 326 445 305T466 250Q466 217 445 195T389 172Q354 172 333 195T311 250"],8866:[695,0,611,55,555,"55 678Q55 679 56 681T58 684T61 688T65 691T70 693T77 694Q88 692 95 679V367H540Q555 359 555 347Q555 334 540 327H95V15Q88 2 77 0Q73 0 70 1T65 3T61 6T59 9T57 13T55 16V678"],8867:[695,0,611,54,555,"515 678Q515 679 516 681T518 684T521 688T525 691T530 693T537 694Q548 692 555 679V15Q548 2 537 0Q533 0 530 1T525 3T521 6T519 9T517 13T515 16V327H71Q70 327 67 329T59 336T55 347T59 358T66 365T71 367H515V678"],8868:[668,0,778,55,723,"55 642T55 648T59 659T66 666T71 668H708Q723 660 723 648T708 628H409V15Q402 2 391 0Q387 0 384 1T379 3T375 6T373 9T371 13T369 16V628H71Q70 628 67 630T59 637"],8869:[669,0,778,54,723,"369 652Q369 653 370 655T372 658T375 662T379 665T384 667T391 668Q402 666 409 653V40H708Q723 32 723 20T708 0H71Q70 0 67 2T59 9T55 20T59 31T66 38T71 40H369V652"],8872:[750,249,867,119,812,"139 -249H137Q125 -249 119 -235V251L120 737Q130 750 139 750Q152 750 159 735V367H796Q811 359 811 347Q811 336 797 328L479 327H161L159 328V172L161 173H797Q798 172 800 171T803 169T805 167T808 164T809 162T810 158T811 153Q811 140 796 133H159V-235Q151 -249 141 -249H139"],8900:[488,-12,500,12,488,"242 486Q245 488 250 488Q256 488 258 486Q262 484 373 373T486 258T488 250T486 242T373 127T258 14Q256 12 250 12Q245 12 242 14Q237 16 127 126T14 242Q12 245 12 250T14 258Q16 263 126 373T242 486ZM439 250L250 439L61 250L250 61L439 250"],8901:[310,-190,278,78,199,"78 250Q78 274 95 292T138 310Q162 310 180 294T199 251Q199 226 182 208T139 190T96 207T78 250"],8902:[486,-16,500,3,497,"210 282Q210 284 225 381T241 480Q241 484 245 484Q249 486 251 486Q258 486 260 477T272 406Q275 390 276 380Q290 286 290 282L388 299Q484 314 487 314H488Q497 314 497 302Q497 297 434 266Q416 257 404 251L315 206L361 118Q372 98 383 75T401 40L407 28Q407 16 395 16Q394 16 392 16L390 17L250 159L110 17L108 16Q106 16 105 16Q93 16 93 28L99 40Q105 52 116 75T139 118L185 206L96 251Q6 296 4 300Q3 301 3 302Q3 314 12 314H13Q16 314 112 299L210 282"],8904:[505,5,900,26,873,"833 50T833 250T832 450T659 351T487 250T658 150T832 50Q833 50 833 250ZM873 10Q866 -5 854 -5Q851 -5 845 -3L449 226L260 115Q51 -5 43 -5Q39 -5 35 -1T28 7L26 11V489Q33 505 43 505Q51 505 260 385L449 274L845 503Q851 505 853 505Q866 505 873 490V10ZM412 250L67 450Q66 450 66 250T67 50Q69 51 240 150T412 250"],8942:[900,30,278,78,199,"78 30Q78 54 95 72T138 90Q162 90 180 74T199 31Q199 6 182 -12T139 -30T96 -13T78 30ZM78 440Q78 464 95 482T138 500Q162 500 180 484T199 441Q199 416 182 398T139 380T96 397T78 440ZM78 840Q78 864 95 882T138 900Q162 900 180 884T199 841Q199 816 182 798T139 780T96 797T78 840"],8943:[310,-190,1172,78,1093,"78 250Q78 274 95 292T138 310Q162 310 180 294T199 251Q199 226 182 208T139 190T96 207T78 250ZM525 250Q525 274 542 292T585 310Q609 310 627 294T646 251Q646 226 629 208T586 190T543 207T525 250ZM972 250Q972 274 989 292T1032 310Q1056 310 1074 294T1093 251Q1093 226 1076 208T1033 190T990 207T972 250"],8945:[820,-100,1282,133,1148,"133 760Q133 784 150 802T193 820Q217 820 235 804T254 761Q254 736 237 718T194 700T151 717T133 760ZM580 460Q580 484 597 502T640 520Q664 520 682 504T701 461Q701 436 684 418T641 400T598 417T580 460ZM1027 160Q1027 184 1044 202T1087 220Q1111 220 1129 204T1148 161Q1148 136 1131 118T1088 100T1045 117T1027 160"],8968:[750,250,444,174,422,"174 734Q178 746 190 750H298H369Q400 750 411 747T422 730T411 713T372 709Q365 709 345 709T310 710H214V-235Q206 -248 196 -250Q192 -250 189 -249T184 -247T180 -244T178 -241T176 -237T174 -234V734"],8969:[750,250,444,21,269,"21 717T21 730T32 746T75 750H147H256Q266 742 269 735V-235Q262 -248 251 -250Q247 -250 244 -249T239 -247T235 -244T233 -241T231 -237T229 -234V710H133Q119 710 99 710T71 709Q43 709 32 713"],8970:[751,251,444,174,423,"174 734Q174 735 175 737T177 740T180 744T184 747T189 749T196 750Q206 748 214 735V-210H310H373Q401 -210 411 -213T422 -230T411 -247T369 -251Q362 -251 338 -251T298 -250H190Q178 -246 174 -234V734"],8971:[751,250,444,21,269,"229 734Q229 735 230 737T232 740T235 744T239 747T244 749T251 750Q262 748 269 735V-235Q266 -240 256 -249L147 -250H77Q43 -250 32 -247T21 -230T32 -213T72 -209Q79 -209 99 -209T133 -210H229V734"],8994:[388,-122,1e3,55,944,"55 141Q55 149 72 174T125 234T209 303T329 360T478 388H526Q649 383 765 319Q814 291 858 250T923 179T944 141Q944 133 938 128T924 122Q914 124 912 125T902 139Q766 328 500 328Q415 328 342 308T225 258T150 199T102 148T84 124Q81 122 75 122Q55 127 55 141"],8995:[378,-134,1e3,55,944,"923 378Q944 378 944 358Q944 345 912 311T859 259Q710 134 500 134Q288 134 140 259Q55 336 55 358Q55 366 61 372T75 378Q78 378 84 376Q86 376 101 356T147 310T221 257T339 212T500 193Q628 193 734 236Q841 282 903 363Q914 378 923 378"],9136:[744,244,412,56,357,"357 741V726Q357 720 349 715Q261 655 242 539Q240 526 240 454T239 315T239 247Q240 235 240 124V40Q240 -17 233 -53T201 -130Q155 -206 78 -244H69H64Q58 -244 57 -243T56 -234Q56 -232 56 -231V-225Q56 -218 63 -215Q153 -153 170 -39Q172 -25 173 119V219Q173 245 174 249Q173 258 173 376V460Q173 515 178 545T201 611Q244 695 327 741L334 744H354L357 741"],9137:[744,244,412,55,357,"78 744Q153 706 196 640T239 492V376Q239 341 239 314T238 271T238 253Q239 251 239 223V119V49Q239 -39 254 -85Q263 -111 275 -134T301 -172T326 -197T346 -213T356 -221T357 -232V-241L354 -244H334Q264 -209 222 -146T174 -12Q173 -6 173 95Q173 134 173 191T174 250Q173 258 173 382V451Q173 542 159 585Q145 626 120 658T75 706T56 723V731Q56 741 57 742T66 744H78"],10216:[750,250,389,109,333,"333 -232Q332 -239 327 -244T313 -250Q303 -250 296 -240Q293 -233 202 6T110 250T201 494T296 740Q299 745 306 749L309 750Q312 750 313 750Q331 750 333 732Q333 727 243 489Q152 252 152 250T243 11Q333 -227 333 -232"],10217:[750,250,389,55,279,"55 732Q56 739 61 744T75 750Q85 750 92 740Q95 733 186 494T278 250T187 6T92 -240Q85 -250 75 -250Q67 -250 62 -245T55 -232Q55 -227 145 11Q236 248 236 250T145 489Q55 727 55 732"],10222:[744,244,412,173,357,"357 741V726Q357 720 349 715Q261 655 242 539Q240 526 240 394V331Q240 259 239 250Q240 242 240 119V49Q240 -42 254 -85Q263 -111 275 -134T301 -172T326 -197T346 -213T356 -221T357 -232V-241L354 -244H334Q264 -209 222 -146T174 -12Q173 -6 173 95Q173 134 173 191T174 250Q173 260 173 376V460Q173 515 178 545T201 611Q244 695 327 741L334 744H354L357 741"],10223:[744,244,412,55,240,"78 744Q153 706 196 640T239 492V376Q239 339 239 311T238 269T238 252Q240 236 240 124V40Q240 -18 233 -53T202 -130Q156 -206 79 -244H70H65Q58 -244 57 -242T56 -231T57 -220T64 -215Q153 -154 170 -39Q173 -18 174 119V247Q173 249 173 382V451Q173 542 159 585Q145 626 120 658T75 706T56 723V731Q56 741 57 742T66 744H78"],10229:[511,11,1609,55,1525,"165 270H1510Q1525 262 1525 250T1510 230H165Q167 228 182 216T211 189T244 152T277 96T303 25Q308 7 308 0Q308 -11 288 -11Q281 -11 278 -11T272 -7T267 2T263 21Q245 94 195 151T73 236Q58 242 55 247Q55 254 59 257T73 264Q121 283 158 314T215 375T247 434T264 480L267 497Q269 503 270 505T275 509T288 511Q308 511 308 500Q308 493 303 475Q293 438 278 406T246 352T215 315T185 287T165 270"],10230:[511,11,1638,84,1553,"84 237T84 250T98 270H1444Q1328 357 1301 493Q1301 494 1301 496T1300 499Q1300 511 1317 511H1320Q1329 511 1332 510T1338 506T1341 497T1344 481T1352 456Q1374 389 1425 336T1544 261Q1553 258 1553 250Q1553 244 1548 241T1524 231T1486 212Q1445 186 1415 152T1370 85T1349 35T1341 4Q1339 -6 1336 -8T1320 -11Q1300 -11 1300 0Q1300 7 1305 25Q1337 151 1444 230H98Q84 237 84 250"],10231:[511,11,1859,55,1803,"165 270H1694Q1578 357 1551 493Q1551 494 1551 496T1550 499Q1550 511 1567 511H1570Q1579 511 1582 510T1588 506T1591 497T1594 481T1602 456Q1624 389 1675 336T1794 261Q1803 258 1803 250Q1803 244 1798 241T1774 231T1736 212Q1695 186 1665 152T1620 85T1599 35T1591 4Q1589 -6 1586 -8T1570 -11Q1550 -11 1550 0Q1550 7 1555 25Q1587 151 1694 230H165Q167 228 182 216T211 189T244 152T277 96T303 25Q308 7 308 0Q308 -11 288 -11Q281 -11 278 -11T272 -7T267 2T263 21Q245 94 195 151T73 236Q58 242 55 247Q55 254 59 257T73 264Q121 283 158 314T215 375T247 434T264 480L267 497Q269 503 270 505T275 509T288 511Q308 511 308 500Q308 493 303 475Q293 438 278 406T246 352T215 315T185 287T165 270"],10232:[525,24,1609,56,1554,"274 173H1539Q1540 172 1542 171T1545 169T1547 167T1550 164T1551 162T1552 158T1553 153Q1553 140 1538 133H318L328 123Q379 69 414 0Q419 -13 419 -17Q419 -24 399 -24Q388 -24 385 -23T377 -12Q332 77 253 144T72 237Q62 240 59 242T56 250T59 257T70 262T89 268T119 278T160 296Q303 366 377 512Q382 522 385 523T401 525Q419 524 419 515Q419 510 414 500Q379 431 328 377L318 367H1538Q1553 359 1553 347Q1553 336 1539 328L1221 327H903L900 328L602 327H274L264 319Q225 289 147 250Q148 249 165 241T210 217T264 181L274 173"],10233:[525,24,1638,56,1582,"1218 514Q1218 525 1234 525Q1239 525 1242 525T1247 525T1251 524T1253 523T1255 520T1257 517T1260 512Q1297 438 1358 381T1469 300T1565 263Q1582 258 1582 250T1573 239T1536 228T1478 204Q1334 134 1260 -12Q1256 -21 1253 -22T1238 -24Q1218 -24 1218 -17Q1218 -13 1223 0Q1258 69 1309 123L1319 133H70Q56 140 56 153Q56 168 72 173H1363L1373 181Q1412 211 1490 250Q1489 251 1472 259T1427 283T1373 319L1363 327H710L707 328L390 327H72Q56 332 56 347Q56 360 70 367H1319L1309 377Q1276 412 1247 458T1218 514"],10234:[525,24,1858,56,1802,"1438 514Q1438 525 1454 525Q1459 525 1462 525T1467 525T1471 524T1473 523T1475 520T1477 517T1480 512Q1517 438 1578 381T1689 300T1785 263Q1802 258 1802 250T1793 239T1756 228T1698 204Q1554 134 1480 -12Q1476 -21 1473 -22T1458 -24Q1438 -24 1438 -17Q1438 -13 1443 0Q1478 69 1529 123L1539 133H318L328 123Q379 69 414 0Q419 -13 419 -17Q419 -24 399 -24Q388 -24 385 -23T377 -12Q332 77 253 144T72 237Q62 240 59 242T56 250T59 257T70 262T89 268T119 278T160 296Q303 366 377 512Q382 522 385 523T401 525Q419 524 419 515Q419 510 414 500Q379 431 328 377L318 367H1539L1529 377Q1496 412 1467 458T1438 514ZM274 173H1583L1593 181Q1632 211 1710 250Q1709 251 1692 259T1647 283T1593 319L1583 327H930L927 328L602 327H274L264 319Q225 289 147 250Q148 249 165 241T210 217T264 181L274 173"],10236:[511,11,1638,54,1553,"95 155V109Q95 83 92 73T75 63Q61 63 58 74T54 130Q54 140 54 180T55 250Q55 421 57 425Q61 437 75 437Q88 437 91 428T95 393V345V270H1444Q1328 357 1301 493Q1301 494 1301 496T1300 499Q1300 511 1317 511H1320Q1329 511 1332 510T1338 506T1341 497T1344 481T1352 456Q1374 389 1425 336T1544 261Q1553 258 1553 250Q1553 244 1548 241T1524 231T1486 212Q1445 186 1415 152T1370 85T1349 35T1341 4Q1339 -6 1336 -8T1320 -11Q1300 -11 1300 0Q1300 7 1305 25Q1337 151 1444 230H95V155"],10927:[636,138,778,84,694,"84 346Q84 359 91 363T117 367Q120 367 126 367T137 366Q388 370 512 430T653 609Q657 636 676 636Q685 635 689 629T694 618V612Q689 566 672 528T626 463T569 417T500 383T435 362T373 346Q379 345 404 339T440 330T477 318T533 296Q592 266 630 223T681 145T694 78Q694 57 674 57Q662 57 657 67T652 92T640 135T606 191Q500 320 137 326H114Q104 326 98 327T88 332T84 346ZM84 -131T84 -118T98 -98H679Q694 -106 694 -118T679 -138H98Q84 -131 84 -118"],10928:[636,138,778,83,694,"84 614Q84 636 102 636Q115 636 119 626T125 600T137 556T171 501Q277 372 640 366H661Q694 366 694 346T661 326H640Q578 325 526 321T415 307T309 280T222 237T156 172T124 83Q122 66 118 62T103 57Q100 57 98 57T95 58T93 59T90 62T85 67Q83 71 83 80Q88 126 105 164T151 229T208 275T277 309T342 330T404 346Q401 347 380 351T345 360T302 373T245 396Q125 455 92 565Q84 599 84 614ZM84 -131T84 -118T98 -98H679Q694 -106 694 -118T679 -138H98Q84 -131 84 -118"]};
m.FONTDATA.FONTS["MathJax_Math-italic"]={directory:"Math/Italic",family:"MathJax_Math",id:"MJMATHI",style:"italic",skew:{65:.139,66:.0833,67:.0833,68:.0556,69:.0833,70:.0833,71:.0833,72:.0556,73:.111,74:.167,75:.0556,76:.0278,77:.0833,78:.0833,79:.0833,80:.0833,81:.0833,82:.0833,83:.0833,84:.0833,85:.0278,88:.0833,90:.0833,99:.0556,100:.167,101:.0556,102:.167,103:.0278,104:-.0278,108:.0833,111:.0556,112:.0833,113:.0833,114:.0556,115:.0556,116:.0833,117:.0278,118:.0278,119:.0833,120:.0278,121:.0556,122:.0556,915:.0833,916:.167,920:.0833,923:.167,926:.0833,928:.0556,931:.0833,933:.0556,934:.0833,936:.0556,937:.0833,945:.0278,946:.0833,948:.0556,949:.0833,950:.0833,951:.0556,952:.0833,953:.0556,956:.0278,957:.0278,958:.111,959:.0556,961:.0833,962:.0833,964:.0278,965:.0278,966:.0833,967:.0556,968:.111,977:.0833,981:.0833,1009:.0833,1013:.0556},32:[0,0,250,0,0,""],47:[716,215,778,139,638,"166 -215T159 -215T147 -212T141 -204T139 -197Q139 -190 144 -183Q157 -157 378 274T602 707Q605 716 618 716Q625 716 630 712T636 703T638 696Q638 691 406 241T170 -212Q166 -215 159 -215"],65:[716,0,750,35,726,"208 74Q208 50 254 46Q272 46 272 35Q272 34 270 22Q267 8 264 4T251 0Q249 0 239 0T205 1T141 2Q70 2 50 0H42Q35 7 35 11Q37 38 48 46H62Q132 49 164 96Q170 102 345 401T523 704Q530 716 547 716H555H572Q578 707 578 706L606 383Q634 60 636 57Q641 46 701 46Q726 46 726 36Q726 34 723 22Q720 7 718 4T704 0Q701 0 690 0T651 1T578 2Q484 2 455 0H443Q437 6 437 9T439 27Q443 40 445 43L449 46H469Q523 49 533 63L521 213H283L249 155Q208 86 208 74ZM516 260Q516 271 504 416T490 562L463 519Q447 492 400 412L310 260L413 259Q516 259 516 260"],66:[683,0,759,35,756,"231 637Q204 637 199 638T194 649Q194 676 205 682Q206 683 335 683Q594 683 608 681Q671 671 713 636T756 544Q756 480 698 429T565 360L555 357Q619 348 660 311T702 219Q702 146 630 78T453 1Q446 0 242 0Q42 0 39 2Q35 5 35 10Q35 17 37 24Q42 43 47 45Q51 46 62 46H68Q95 46 128 49Q142 52 147 61Q150 65 219 339T288 628Q288 635 231 637ZM649 544Q649 574 634 600T585 634Q578 636 493 637Q473 637 451 637T416 636H403Q388 635 384 626Q382 622 352 506Q352 503 351 500L320 374H401Q482 374 494 376Q554 386 601 434T649 544ZM595 229Q595 273 572 302T512 336Q506 337 429 337Q311 337 310 336Q310 334 293 263T258 122L240 52Q240 48 252 48T333 46Q422 46 429 47Q491 54 543 105T595 229"],67:[705,22,715,50,760,"50 252Q50 367 117 473T286 641T490 704Q580 704 633 653Q642 643 648 636T656 626L657 623Q660 623 684 649Q691 655 699 663T715 679T725 690L740 705H746Q760 705 760 698Q760 694 728 561Q692 422 692 421Q690 416 687 415T669 413H653Q647 419 647 422Q647 423 648 429T650 449T651 481Q651 552 619 605T510 659Q484 659 454 652T382 628T299 572T226 479Q194 422 175 346T156 222Q156 108 232 58Q280 24 350 24Q441 24 512 92T606 240Q610 253 612 255T628 257Q648 257 648 248Q648 243 647 239Q618 132 523 55T319 -22Q206 -22 128 53T50 252"],68:[683,0,828,33,803,"287 628Q287 635 230 637Q207 637 200 638T193 647Q193 655 197 667T204 682Q206 683 403 683Q570 682 590 682T630 676Q702 659 752 597T803 431Q803 275 696 151T444 3L430 1L236 0H125H72Q48 0 41 2T33 11Q33 13 36 25Q40 41 44 43T67 46Q94 46 127 49Q141 52 146 61Q149 65 218 339T287 628ZM703 469Q703 507 692 537T666 584T629 613T590 629T555 636Q553 636 541 636T512 636T479 637H436Q392 637 386 627Q384 623 313 339T242 52Q242 48 253 48T330 47Q335 47 349 47T373 46Q499 46 581 128Q617 164 640 212T683 339T703 469"],69:[680,0,738,31,764,"492 213Q472 213 472 226Q472 230 477 250T482 285Q482 316 461 323T364 330H312Q311 328 277 192T243 52Q243 48 254 48T334 46Q428 46 458 48T518 61Q567 77 599 117T670 248Q680 270 683 272Q690 274 698 274Q718 274 718 261Q613 7 608 2Q605 0 322 0H133Q31 0 31 11Q31 13 34 25Q38 41 42 43T65 46Q92 46 125 49Q139 52 144 61Q146 66 215 342T285 622Q285 629 281 629Q273 632 228 634H197Q191 640 191 642T193 659Q197 676 203 680H757Q764 676 764 669Q764 664 751 557T737 447Q735 440 717 440H705Q698 445 698 453L701 476Q704 500 704 528Q704 558 697 578T678 609T643 625T596 632T532 634H485Q397 633 392 631Q388 629 386 622Q385 619 355 499T324 377Q347 376 372 376H398Q464 376 489 391T534 472Q538 488 540 490T557 493Q562 493 565 493T570 492T572 491T574 487T577 483L544 351Q511 218 508 216Q505 213 492 213"],70:[680,0,643,31,749,"48 1Q31 1 31 11Q31 13 34 25Q38 41 42 43T65 46Q92 46 125 49Q139 52 144 61Q146 66 215 342T285 622Q285 629 281 629Q273 632 228 634H197Q191 640 191 642T193 659Q197 676 203 680H742Q749 676 749 669Q749 664 736 557T722 447Q720 440 702 440H690Q683 445 683 453Q683 454 686 477T689 530Q689 560 682 579T663 610T626 626T575 633T503 634H480Q398 633 393 631Q388 629 386 623Q385 622 352 492L320 363H375Q378 363 398 363T426 364T448 367T472 374T489 386Q502 398 511 419T524 457T529 475Q532 480 548 480H560Q567 475 567 470Q567 467 536 339T502 207Q500 200 482 200H470Q463 206 463 212Q463 215 468 234T473 274Q473 303 453 310T364 317H309L277 190Q245 66 245 60Q245 46 334 46H359Q365 40 365 39T363 19Q359 6 353 0H336Q295 2 185 2Q120 2 86 2T48 1"],71:[705,22,786,50,760,"50 252Q50 367 117 473T286 641T490 704Q580 704 633 653Q642 643 648 636T656 626L657 623Q660 623 684 649Q691 655 699 663T715 679T725 690L740 705H746Q760 705 760 698Q760 694 728 561Q692 422 692 421Q690 416 687 415T669 413H653Q647 419 647 422Q647 423 648 429T650 449T651 481Q651 552 619 605T510 659Q492 659 471 656T418 643T357 615T294 567T236 496T189 394T158 260Q156 242 156 221Q156 173 170 136T206 79T256 45T308 28T353 24Q407 24 452 47T514 106Q517 114 529 161T541 214Q541 222 528 224T468 227H431Q425 233 425 235T427 254Q431 267 437 273H454Q494 271 594 271Q634 271 659 271T695 272T707 272Q721 272 721 263Q721 261 719 249Q714 230 709 228Q706 227 694 227Q674 227 653 224Q646 221 643 215T629 164Q620 131 614 108Q589 6 586 3Q584 1 581 1Q571 1 553 21T530 52Q530 53 528 52T522 47Q448 -22 322 -22Q201 -22 126 55T50 252"],72:[683,0,831,31,888,"228 637Q194 637 192 641Q191 643 191 649Q191 673 202 682Q204 683 219 683Q260 681 355 681Q389 681 418 681T463 682T483 682Q499 682 499 672Q499 670 497 658Q492 641 487 638H485Q483 638 480 638T473 638T464 637T455 637Q416 636 405 634T387 623Q384 619 355 500Q348 474 340 442T328 395L324 380Q324 378 469 378H614L615 381Q615 384 646 504Q674 619 674 627T617 637Q594 637 587 639T580 648Q580 650 582 660Q586 677 588 679T604 682Q609 682 646 681T740 680Q802 680 835 681T871 682Q888 682 888 672Q888 645 876 638H874Q872 638 869 638T862 638T853 637T844 637Q805 636 794 634T776 623Q773 618 704 340T634 58Q634 51 638 51Q646 48 692 46H723Q729 38 729 37T726 19Q722 6 716 0H701Q664 2 567 2Q533 2 504 2T458 2T437 1Q420 1 420 10Q420 15 423 24Q428 43 433 45Q437 46 448 46H454Q481 46 514 49Q520 50 522 50T528 55T534 64T540 82T547 110T558 153Q565 181 569 198Q602 330 602 331T457 332H312L279 197Q245 63 245 58Q245 51 253 49T303 46H334Q340 38 340 37T337 19Q333 6 327 0H312Q275 2 178 2Q144 2 115 2T69 2T48 1Q31 1 31 10Q31 12 34 24Q39 43 44 45Q48 46 59 46H65Q92 46 125 49Q139 52 144 61Q147 65 216 339T285 628Q285 635 228 637"],73:[683,0,440,26,504,"43 1Q26 1 26 10Q26 12 29 24Q34 43 39 45Q42 46 54 46H60Q120 46 136 53Q137 53 138 54Q143 56 149 77T198 273Q210 318 216 344Q286 624 286 626Q284 630 284 631Q274 637 213 637H193Q184 643 189 662Q193 677 195 680T209 683H213Q285 681 359 681Q481 681 487 683H497Q504 676 504 672T501 655T494 639Q491 637 471 637Q440 637 407 634Q393 631 388 623Q381 609 337 432Q326 385 315 341Q245 65 245 59Q245 52 255 50T307 46H339Q345 38 345 37T342 19Q338 6 332 0H316Q279 2 179 2Q143 2 113 2T65 2T43 1"],74:[683,22,555,57,633,"447 625Q447 637 354 637H329Q323 642 323 645T325 664Q329 677 335 683H352Q393 681 498 681Q541 681 568 681T605 682T619 682Q633 682 633 672Q633 670 630 658Q626 642 623 640T604 637Q552 637 545 623Q541 610 483 376Q420 128 419 127Q397 64 333 21T195 -22Q137 -22 97 8T57 88Q57 130 80 152T132 174Q177 174 182 130Q182 98 164 80T123 56Q115 54 115 53T122 44Q148 15 197 15Q235 15 271 47T324 130Q328 142 387 380T447 625"],75:[683,0,849,31,889,"285 628Q285 635 228 637Q205 637 198 638T191 647Q191 649 193 661Q199 681 203 682Q205 683 214 683H219Q260 681 355 681Q389 681 418 681T463 682T483 682Q500 682 500 674Q500 669 497 660Q496 658 496 654T495 648T493 644T490 641T486 639T479 638T470 637T456 637Q416 636 405 634T387 623L306 305Q307 305 490 449T678 597Q692 611 692 620Q692 635 667 637Q651 637 651 648Q651 650 654 662T659 677Q662 682 676 682Q680 682 711 681T791 680Q814 680 839 681T869 682Q889 682 889 672Q889 650 881 642Q878 637 862 637Q787 632 726 586Q710 576 656 534T556 455L509 418L518 396Q527 374 546 329T581 244Q656 67 661 61Q663 59 666 57Q680 47 717 46H738Q744 38 744 37T741 19Q737 6 731 0H720Q680 3 625 3Q503 3 488 0H478Q472 6 472 9T474 27Q478 40 480 43T491 46H494Q544 46 544 71Q544 75 517 141T485 216L427 354L359 301L291 248L268 155Q245 63 245 58Q245 51 253 49T303 46H334Q340 37 340 35Q340 19 333 5Q328 0 317 0Q314 0 280 1T180 2Q118 2 85 2T49 1Q31 1 31 11Q31 13 34 25Q38 41 42 43T65 46Q92 46 125 49Q139 52 144 61Q147 65 216 339T285 628"],76:[683,2,681,32,647,"228 637Q194 637 192 641Q191 643 191 649Q191 673 202 682Q204 683 217 683Q271 680 344 680Q485 680 506 683H518Q524 677 524 674T522 656Q517 641 513 637H475Q406 636 394 628Q387 624 380 600T313 336Q297 271 279 198T252 88L243 52Q243 48 252 48T311 46H328Q360 46 379 47T428 54T478 72T522 106T564 161Q580 191 594 228T611 270Q616 273 628 273H641Q647 264 647 262T627 203T583 83T557 9Q555 4 553 3T537 0T494 -1Q483 -1 418 -1T294 0H116Q32 0 32 10Q32 17 34 24Q39 43 44 45Q48 46 59 46H65Q92 46 125 49Q139 52 144 61Q147 65 216 339T285 628Q285 635 228 637"],77:[684,0,970,35,1051,"289 629Q289 635 232 637Q208 637 201 638T194 648Q194 649 196 659Q197 662 198 666T199 671T201 676T203 679T207 681T212 683T220 683T232 684Q238 684 262 684T307 683Q386 683 398 683T414 678Q415 674 451 396L487 117L510 154Q534 190 574 254T662 394Q837 673 839 675Q840 676 842 678T846 681L852 683H948Q965 683 988 683T1017 684Q1051 684 1051 673Q1051 668 1048 656T1045 643Q1041 637 1008 637Q968 636 957 634T939 623Q936 618 867 340T797 59Q797 55 798 54T805 50T822 48T855 46H886Q892 37 892 35Q892 19 885 5Q880 0 869 0Q864 0 828 1T736 2Q675 2 644 2T609 1Q592 1 592 11Q592 13 594 25Q598 41 602 43T625 46Q652 46 685 49Q699 52 704 61Q706 65 742 207T813 490T848 631L654 322Q458 10 453 5Q451 4 449 3Q444 0 433 0Q418 0 415 7Q413 11 374 317L335 624L267 354Q200 88 200 79Q206 46 272 46H282Q288 41 289 37T286 19Q282 3 278 1Q274 0 267 0Q265 0 255 0T221 1T157 2Q127 2 95 1T58 0Q43 0 39 2T35 11Q35 13 38 25T43 40Q45 46 65 46Q135 46 154 86Q158 92 223 354T289 629"],78:[683,0,803,31,888,"234 637Q231 637 226 637Q201 637 196 638T191 649Q191 676 202 682Q204 683 299 683Q376 683 387 683T401 677Q612 181 616 168L670 381Q723 592 723 606Q723 633 659 637Q635 637 635 648Q635 650 637 660Q641 676 643 679T653 683Q656 683 684 682T767 680Q817 680 843 681T873 682Q888 682 888 672Q888 650 880 642Q878 637 858 637Q787 633 769 597L620 7Q618 0 599 0Q585 0 582 2Q579 5 453 305L326 604L261 344Q196 88 196 79Q201 46 268 46H278Q284 41 284 38T282 19Q278 6 272 0H259Q228 2 151 2Q123 2 100 2T63 2T46 1Q31 1 31 10Q31 14 34 26T39 40Q41 46 62 46Q130 49 150 85Q154 91 221 362L289 634Q287 635 234 637"],79:[704,22,763,50,740,"740 435Q740 320 676 213T511 42T304 -22Q207 -22 138 35T51 201Q50 209 50 244Q50 346 98 438T227 601Q351 704 476 704Q514 704 524 703Q621 689 680 617T740 435ZM637 476Q637 565 591 615T476 665Q396 665 322 605Q242 542 200 428T157 216Q157 126 200 73T314 19Q404 19 485 98T608 313Q637 408 637 476"],80:[683,0,642,33,751,"287 628Q287 635 230 637Q206 637 199 638T192 648Q192 649 194 659Q200 679 203 681T397 683Q587 682 600 680Q664 669 707 631T751 530Q751 453 685 389Q616 321 507 303Q500 302 402 301H307L277 182Q247 66 247 59Q247 55 248 54T255 50T272 48T305 46H336Q342 37 342 35Q342 19 335 5Q330 0 319 0Q316 0 282 1T182 2Q120 2 87 2T51 1Q33 1 33 11Q33 13 36 25Q40 41 44 43T67 46Q94 46 127 49Q141 52 146 61Q149 65 218 339T287 628ZM645 554Q645 567 643 575T634 597T609 619T560 635Q553 636 480 637Q463 637 445 637T416 636T404 636Q391 635 386 627Q384 621 367 550T332 412T314 344Q314 342 395 342H407H430Q542 342 590 392Q617 419 631 471T645 554"],81:[704,194,791,50,740,"399 -80Q399 -47 400 -30T402 -11V-7L387 -11Q341 -22 303 -22Q208 -22 138 35T51 201Q50 209 50 244Q50 346 98 438T227 601Q351 704 476 704Q514 704 524 703Q621 689 680 617T740 435Q740 255 592 107Q529 47 461 16L444 8V3Q444 2 449 -24T470 -66T516 -82Q551 -82 583 -60T625 -3Q631 11 638 11Q647 11 649 2Q649 -6 639 -34T611 -100T557 -165T481 -194Q399 -194 399 -87V-80ZM636 468Q636 523 621 564T580 625T530 655T477 665Q429 665 379 640Q277 591 215 464T153 216Q153 110 207 59Q231 38 236 38V46Q236 86 269 120T347 155Q372 155 390 144T417 114T429 82T435 55L448 64Q512 108 557 185T619 334T636 468ZM314 18Q362 18 404 39L403 49Q399 104 366 115Q354 117 347 117Q344 117 341 117T337 118Q317 118 296 98T274 52Q274 18 314 18"],82:[683,21,759,33,755,"230 637Q203 637 198 638T193 649Q193 676 204 682Q206 683 378 683Q550 682 564 680Q620 672 658 652T712 606T733 563T739 529Q739 484 710 445T643 385T576 351T538 338L545 333Q612 295 612 223Q612 212 607 162T602 80V71Q602 53 603 43T614 25T640 16Q668 16 686 38T712 85Q717 99 720 102T735 105Q755 105 755 93Q755 75 731 36Q693 -21 641 -21H632Q571 -21 531 4T487 82Q487 109 502 166T517 239Q517 290 474 313Q459 320 449 321T378 323H309L277 193Q244 61 244 59Q244 55 245 54T252 50T269 48T302 46H333Q339 38 339 37T336 19Q332 6 326 0H311Q275 2 180 2Q146 2 117 2T71 2T50 1Q33 1 33 10Q33 12 36 24Q41 43 46 45Q50 46 61 46H67Q94 46 127 49Q141 52 146 61Q149 65 218 339T287 628Q287 635 230 637ZM630 554Q630 586 609 608T523 636Q521 636 500 636T462 637H440Q393 637 386 627Q385 624 352 494T319 361Q319 360 388 360Q466 361 492 367Q556 377 592 426Q608 449 619 486T630 554"],83:[705,22,613,52,645,"308 24Q367 24 416 76T466 197Q466 260 414 284Q308 311 278 321T236 341Q176 383 176 462Q176 523 208 573T273 648Q302 673 343 688T407 704H418H425Q521 704 564 640Q565 640 577 653T603 682T623 704Q624 704 627 704T632 705Q645 705 645 698T617 577T585 459T569 456Q549 456 549 465Q549 471 550 475Q550 478 551 494T553 520Q553 554 544 579T526 616T501 641Q465 662 419 662Q362 662 313 616T263 510Q263 480 278 458T319 427Q323 425 389 408T456 390Q490 379 522 342T554 242Q554 216 546 186Q541 164 528 137T492 78T426 18T332 -20Q320 -22 298 -22Q199 -22 144 33L134 44L106 13Q83 -14 78 -18T65 -22Q52 -22 52 -14Q52 -11 110 221Q112 227 130 227H143Q149 221 149 216Q149 214 148 207T144 186T142 153Q144 114 160 87T203 47T255 29T308 24"],84:[677,0,584,21,704,"40 437Q21 437 21 445Q21 450 37 501T71 602L88 651Q93 669 101 677H569H659Q691 677 697 676T704 667Q704 661 687 553T668 444Q668 437 649 437Q640 437 637 437T631 442L629 445Q629 451 635 490T641 551Q641 586 628 604T573 629Q568 630 515 631Q469 631 457 630T439 622Q438 621 368 343T298 60Q298 48 386 46Q418 46 427 45T436 36Q436 31 433 22Q429 4 424 1L422 0Q419 0 415 0Q410 0 363 1T228 2Q99 2 64 0H49Q43 6 43 9T45 27Q49 40 55 46H83H94Q174 46 189 55Q190 56 191 56Q196 59 201 76T241 233Q258 301 269 344Q339 619 339 625Q339 630 310 630H279Q212 630 191 624Q146 614 121 583T67 467Q60 445 57 441T43 437H40"],85:[683,22,683,60,767,"107 637Q73 637 71 641Q70 643 70 649Q70 673 81 682Q83 683 98 683Q139 681 234 681Q268 681 297 681T342 682T362 682Q378 682 378 672Q378 670 376 658Q371 641 366 638H364Q362 638 359 638T352 638T343 637T334 637Q295 636 284 634T266 623Q265 621 238 518T184 302T154 169Q152 155 152 140Q152 86 183 55T269 24Q336 24 403 69T501 205L552 406Q599 598 599 606Q599 633 535 637Q511 637 511 648Q511 650 513 660Q517 676 519 679T529 683Q532 683 561 682T645 680Q696 680 723 681T752 682Q767 682 767 672Q767 650 759 642Q756 637 737 637Q666 633 648 597Q646 592 598 404Q557 235 548 205Q515 105 433 42T263 -22Q171 -22 116 34T60 167V183Q60 201 115 421Q164 622 164 628Q164 635 107 637"],86:[683,22,583,52,769,"52 648Q52 670 65 683H76Q118 680 181 680Q299 680 320 683H330Q336 677 336 674T334 656Q329 641 325 637H304Q282 635 274 635Q245 630 242 620Q242 618 271 369T301 118L374 235Q447 352 520 471T595 594Q599 601 599 609Q599 633 555 637Q537 637 537 648Q537 649 539 661Q542 675 545 679T558 683Q560 683 570 683T604 682T668 681Q737 681 755 683H762Q769 676 769 672Q769 655 760 640Q757 637 743 637Q730 636 719 635T698 630T682 623T670 615T660 608T652 599T645 592L452 282Q272 -9 266 -16Q263 -18 259 -21L241 -22H234Q216 -22 216 -15Q213 -9 177 305Q139 623 138 626Q133 637 76 637H59Q52 642 52 648"],87:[683,22,944,51,1048,"436 683Q450 683 486 682T553 680Q604 680 638 681T677 682Q695 682 695 674Q695 670 692 659Q687 641 683 639T661 637Q636 636 621 632T600 624T597 615Q597 603 613 377T629 138L631 141Q633 144 637 151T649 170T666 200T690 241T720 295T759 362Q863 546 877 572T892 604Q892 619 873 628T831 637Q817 637 817 647Q817 650 819 660Q823 676 825 679T839 682Q842 682 856 682T895 682T949 681Q1015 681 1034 683Q1048 683 1048 672Q1048 666 1045 655T1038 640T1028 637Q1006 637 988 631T958 617T939 600T927 584L923 578L754 282Q586 -14 585 -15Q579 -22 561 -22Q546 -22 542 -17Q539 -14 523 229T506 480L494 462Q472 425 366 239Q222 -13 220 -15T215 -19Q210 -22 197 -22Q178 -22 176 -15Q176 -12 154 304T131 622Q129 631 121 633T82 637H58Q51 644 51 648Q52 671 64 683H76Q118 680 176 680Q301 680 313 683H323Q329 677 329 674T327 656Q322 641 318 637H297Q236 634 232 620Q262 160 266 136L501 550L499 587Q496 629 489 632Q483 636 447 637Q428 637 422 639T416 648Q416 650 418 660Q419 664 420 669T421 676T424 680T428 682T436 683"],88:[683,0,828,26,852,"42 0H40Q26 0 26 11Q26 15 29 27Q33 41 36 43T55 46Q141 49 190 98Q200 108 306 224T411 342Q302 620 297 625Q288 636 234 637H206Q200 643 200 645T202 664Q206 677 212 683H226Q260 681 347 681Q380 681 408 681T453 682T473 682Q490 682 490 671Q490 670 488 658Q484 643 481 640T465 637Q434 634 411 620L488 426L541 485Q646 598 646 610Q646 628 622 635Q617 635 609 637Q594 637 594 648Q594 650 596 664Q600 677 606 683H618Q619 683 643 683T697 681T738 680Q828 680 837 683H845Q852 676 852 672Q850 647 840 637H824Q790 636 763 628T722 611T698 593L687 584Q687 585 592 480L505 384Q505 383 536 304T601 142T638 56Q648 47 699 46Q734 46 734 37Q734 35 732 23Q728 7 725 4T711 1Q708 1 678 1T589 2Q528 2 496 2T461 1Q444 1 444 10Q444 11 446 25Q448 35 450 39T455 44T464 46T480 47T506 54Q523 62 523 64Q522 64 476 181L429 299Q241 95 236 84Q232 76 232 72Q232 53 261 47Q262 47 267 47T273 46Q276 46 277 46T280 45T283 42T284 35Q284 26 282 19Q279 6 276 4T261 1Q258 1 243 1T201 2T142 2Q64 2 42 0"],89:[683,-1,581,30,763,"66 637Q54 637 49 637T39 638T32 641T30 647T33 664T42 682Q44 683 56 683Q104 680 165 680Q288 680 306 683H316Q322 677 322 674T320 656Q316 643 310 637H298Q242 637 242 624Q242 619 292 477T343 333L346 336Q350 340 358 349T379 373T411 410T454 461Q546 568 561 587T577 618Q577 634 545 637Q528 637 528 647Q528 649 530 661Q533 676 535 679T549 683Q551 683 578 682T657 680Q684 680 713 681T746 682Q763 682 763 673Q763 669 760 657T755 643Q753 637 734 637Q662 632 617 587Q608 578 477 424L348 273L322 169Q295 62 295 57Q295 46 363 46Q379 46 384 45T390 35Q390 33 388 23Q384 6 382 4T366 1Q361 1 324 1T232 2Q170 2 138 2T102 1Q84 1 84 9Q84 14 87 24Q88 27 89 30T90 35T91 39T93 42T96 44T101 45T107 45T116 46T129 46Q168 47 180 50T198 63Q201 68 227 171L252 274L129 623Q128 624 127 625T125 627T122 629T118 631T113 633T105 634T96 635T83 636T66 637"],90:[683,0,683,58,723,"58 8Q58 23 64 35Q64 36 329 334T596 635L586 637Q575 637 512 637H500H476Q442 637 420 635T365 624T311 598T266 548T228 469Q227 466 226 463T224 458T223 453T222 450L221 448Q218 443 202 443Q185 443 182 453L214 561Q228 606 241 651Q249 679 253 681Q256 683 487 683H718Q723 678 723 675Q723 673 717 649Q189 54 188 52L185 49H274Q369 50 377 51Q452 60 500 100T579 247Q587 272 590 277T603 282H607Q628 282 628 271Q547 5 541 2Q538 0 300 0H124Q58 0 58 8"],97:[441,10,529,33,506,"33 157Q33 258 109 349T280 441Q331 441 370 392Q386 422 416 422Q429 422 439 414T449 394Q449 381 412 234T374 68Q374 43 381 35T402 26Q411 27 422 35Q443 55 463 131Q469 151 473 152Q475 153 483 153H487Q506 153 506 144Q506 138 501 117T481 63T449 13Q436 0 417 -8Q409 -10 393 -10Q359 -10 336 5T306 36L300 51Q299 52 296 50Q294 48 292 46Q233 -10 172 -10Q117 -10 75 30T33 157ZM351 328Q351 334 346 350T323 385T277 405Q242 405 210 374T160 293Q131 214 119 129Q119 126 119 118T118 106Q118 61 136 44T179 26Q217 26 254 59T298 110Q300 114 325 217T351 328"],98:[694,11,429,40,422,"73 647Q73 657 77 670T89 683Q90 683 161 688T234 694Q246 694 246 685T212 542Q204 508 195 472T180 418L176 399Q176 396 182 402Q231 442 283 442Q345 442 383 396T422 280Q422 169 343 79T173 -11Q123 -11 82 27T40 150V159Q40 180 48 217T97 414Q147 611 147 623T109 637Q104 637 101 637H96Q86 637 83 637T76 640T73 647ZM336 325V331Q336 405 275 405Q258 405 240 397T207 376T181 352T163 330L157 322L136 236Q114 150 114 114Q114 66 138 42Q154 26 178 26Q211 26 245 58Q270 81 285 114T318 219Q336 291 336 325"],99:[442,12,433,34,430,"34 159Q34 268 120 355T306 442Q362 442 394 418T427 355Q427 326 408 306T360 285Q341 285 330 295T319 325T330 359T352 380T366 386H367Q367 388 361 392T340 400T306 404Q276 404 249 390Q228 381 206 359Q162 315 142 235T121 119Q121 73 147 50Q169 26 205 26H209Q321 26 394 111Q403 121 406 121Q410 121 419 112T429 98T420 83T391 55T346 25T282 0T202 -11Q127 -11 81 37T34 159"],100:[694,10,520,33,523,"366 683Q367 683 438 688T511 694Q523 694 523 686Q523 679 450 384T375 83T374 68Q374 26 402 26Q411 27 422 35Q443 55 463 131Q469 151 473 152Q475 153 483 153H487H491Q506 153 506 145Q506 140 503 129Q490 79 473 48T445 8T417 -8Q409 -10 393 -10Q359 -10 336 5T306 36L300 51Q299 52 296 50Q294 48 292 46Q233 -10 172 -10Q117 -10 75 30T33 157Q33 205 53 255T101 341Q148 398 195 420T280 442Q336 442 364 400Q369 394 369 396Q370 400 396 505T424 616Q424 629 417 632T378 637H357Q351 643 351 645T353 664Q358 683 366 683ZM352 326Q329 405 277 405Q242 405 210 374T160 293Q131 214 119 129Q119 126 119 118T118 106Q118 61 136 44T179 26Q233 26 290 98L298 109L352 326"],101:[443,11,466,39,430,"39 168Q39 225 58 272T107 350T174 402T244 433T307 442H310Q355 442 388 420T421 355Q421 265 310 237Q261 224 176 223Q139 223 138 221Q138 219 132 186T125 128Q125 81 146 54T209 26T302 45T394 111Q403 121 406 121Q410 121 419 112T429 98T420 82T390 55T344 24T281 -1T205 -11Q126 -11 83 42T39 168ZM373 353Q367 405 305 405Q272 405 244 391T199 357T170 316T154 280T149 261Q149 260 169 260Q282 260 327 284T373 353"],102:[705,205,490,55,550,"118 -162Q120 -162 124 -164T135 -167T147 -168Q160 -168 171 -155T187 -126Q197 -99 221 27T267 267T289 382V385H242Q195 385 192 387Q188 390 188 397L195 425Q197 430 203 430T250 431Q298 431 298 432Q298 434 307 482T319 540Q356 705 465 705Q502 703 526 683T550 630Q550 594 529 578T487 561Q443 561 443 603Q443 622 454 636T478 657L487 662Q471 668 457 668Q445 668 434 658T419 630Q412 601 403 552T387 469T380 433Q380 431 435 431Q480 431 487 430T498 424Q499 420 496 407T491 391Q489 386 482 386T428 385H372L349 263Q301 15 282 -47Q255 -132 212 -173Q175 -205 139 -205Q107 -205 81 -186T55 -132Q55 -95 76 -78T118 -61Q162 -61 162 -103Q162 -122 151 -136T127 -157L118 -162"],103:[442,205,477,10,480,"311 43Q296 30 267 15T206 0Q143 0 105 45T66 160Q66 265 143 353T314 442Q361 442 401 394L404 398Q406 401 409 404T418 412T431 419T447 422Q461 422 470 413T480 394Q480 379 423 152T363 -80Q345 -134 286 -169T151 -205Q10 -205 10 -137Q10 -111 28 -91T74 -71Q89 -71 102 -80T116 -111Q116 -121 114 -130T107 -144T99 -154T92 -162L90 -164H91Q101 -167 151 -167Q189 -167 211 -155Q234 -144 254 -122T282 -75Q288 -56 298 -13Q311 35 311 43ZM384 328L380 339Q377 350 375 354T369 368T359 382T346 393T328 402T306 405Q262 405 221 352Q191 313 171 233T151 117Q151 38 213 38Q269 38 323 108L331 118L384 328"],104:[694,11,576,48,555,"137 683Q138 683 209 688T282 694Q294 694 294 685Q294 674 258 534Q220 386 220 383Q220 381 227 388Q288 442 357 442Q411 442 444 415T478 336Q478 285 440 178T402 50Q403 36 407 31T422 26Q450 26 474 56T513 138Q516 149 519 151T535 153Q555 153 555 145Q555 144 551 130Q535 71 500 33Q466 -10 419 -10H414Q367 -10 346 17T325 74Q325 90 361 192T398 345Q398 404 354 404H349Q266 404 205 306L198 293L164 158Q132 28 127 16Q114 -11 83 -11Q69 -11 59 -2T48 16Q48 30 121 320L195 616Q195 629 188 632T149 637H128Q122 643 122 645T124 664Q129 683 137 683"],105:[661,11,345,21,302,"184 600Q184 624 203 642T247 661Q265 661 277 649T290 619Q290 596 270 577T226 557Q211 557 198 567T184 600ZM21 287Q21 295 30 318T54 369T98 420T158 442Q197 442 223 419T250 357Q250 340 236 301T196 196T154 83Q149 61 149 51Q149 26 166 26Q175 26 185 29T208 43T235 78T260 137Q263 149 265 151T282 153Q302 153 302 143Q302 135 293 112T268 61T223 11T161 -11Q129 -11 102 10T74 74Q74 91 79 106T122 220Q160 321 166 341T173 380Q173 404 156 404H154Q124 404 99 371T61 287Q60 286 59 284T58 281T56 279T53 278T49 278T41 278H27Q21 284 21 287"],106:[661,204,412,-12,403,"297 596Q297 627 318 644T361 661Q378 661 389 651T403 623Q403 595 384 576T340 557Q322 557 310 567T297 596ZM288 376Q288 405 262 405Q240 405 220 393T185 362T161 325T144 293L137 279Q135 278 121 278H107Q101 284 101 286T105 299Q126 348 164 391T252 441Q253 441 260 441T272 442Q296 441 316 432Q341 418 354 401T367 348V332L318 133Q267 -67 264 -75Q246 -125 194 -164T75 -204Q25 -204 7 -183T-12 -137Q-12 -110 7 -91T53 -71Q70 -71 82 -81T95 -112Q95 -148 63 -167Q69 -168 77 -168Q111 -168 139 -140T182 -74L193 -32Q204 11 219 72T251 197T278 308T289 365Q289 372 288 376"],107:[694,11,521,48,503,"121 647Q121 657 125 670T137 683Q138 683 209 688T282 694Q294 694 294 686Q294 679 244 477Q194 279 194 272Q213 282 223 291Q247 309 292 354T362 415Q402 442 438 442Q468 442 485 423T503 369Q503 344 496 327T477 302T456 291T438 288Q418 288 406 299T394 328Q394 353 410 369T442 390L458 393Q446 405 434 405H430Q398 402 367 380T294 316T228 255Q230 254 243 252T267 246T293 238T320 224T342 206T359 180T365 147Q365 130 360 106T354 66Q354 26 381 26Q429 26 459 145Q461 153 479 153H483Q499 153 499 144Q499 139 496 130Q455 -11 378 -11Q333 -11 305 15T277 90Q277 108 280 121T283 145Q283 167 269 183T234 206T200 217T182 220H180Q168 178 159 139T145 81T136 44T129 20T122 7T111 -2Q98 -11 83 -11Q66 -11 57 -1T48 16Q48 26 85 176T158 471L195 616Q196 629 188 632T149 637H144Q134 637 131 637T124 640T121 647"],108:[695,12,298,38,266,"117 59Q117 26 142 26Q179 26 205 131Q211 151 215 152Q217 153 225 153H229Q238 153 241 153T246 151T248 144Q247 138 245 128T234 90T214 43T183 6T137 -11Q101 -11 70 11T38 85Q38 97 39 102L104 360Q167 615 167 623Q167 626 166 628T162 632T157 634T149 635T141 636T132 637T122 637Q112 637 109 637T101 638T95 641T94 647Q94 649 96 661Q101 680 107 682T179 688Q194 689 213 690T243 693T254 694Q266 694 266 686Q266 675 193 386T118 83Q118 81 118 75T117 65V59"],109:[443,11,878,21,857,"21 287Q22 293 24 303T36 341T56 388T88 425T132 442T175 435T205 417T221 395T229 376L231 369Q231 367 232 367L243 378Q303 442 384 442Q401 442 415 440T441 433T460 423T475 411T485 398T493 385T497 373T500 364T502 357L510 367Q573 442 659 442Q713 442 746 415T780 336Q780 285 742 178T704 50Q705 36 709 31T724 26Q752 26 776 56T815 138Q818 149 821 151T837 153Q857 153 857 145Q857 144 853 130Q845 101 831 73T785 17T716 -10Q669 -10 648 17T627 73Q627 92 663 193T700 345Q700 404 656 404H651Q565 404 506 303L499 291L466 157Q433 26 428 16Q415 -11 385 -11Q372 -11 364 -4T353 8T350 18Q350 29 384 161L420 307Q423 322 423 345Q423 404 379 404H374Q288 404 229 303L222 291L189 157Q156 26 151 16Q138 -11 108 -11Q95 -11 87 -5T76 7T74 17Q74 30 112 181Q151 335 151 342Q154 357 154 369Q154 405 129 405Q107 405 92 377T69 316T57 280Q55 278 41 278H27Q21 284 21 287"],110:[443,11,600,21,580,"21 287Q22 293 24 303T36 341T56 388T89 425T135 442Q171 442 195 424T225 390T231 369Q231 367 232 367L243 378Q304 442 382 442Q436 442 469 415T503 336T465 179T427 52Q427 26 444 26Q450 26 453 27Q482 32 505 65T540 145Q542 153 560 153Q580 153 580 145Q580 144 576 130Q568 101 554 73T508 17T439 -10Q392 -10 371 17T350 73Q350 92 386 193T423 345Q423 404 379 404H374Q288 404 229 303L222 291L189 157Q156 26 151 16Q138 -11 108 -11Q95 -11 87 -5T76 7T74 17Q74 30 112 180T152 343Q153 348 153 366Q153 405 129 405Q91 405 66 305Q60 285 60 284Q58 278 41 278H27Q21 284 21 287"],111:[441,11,485,34,476,"201 -11Q126 -11 80 38T34 156Q34 221 64 279T146 380Q222 441 301 441Q333 441 341 440Q354 437 367 433T402 417T438 387T464 338T476 268Q476 161 390 75T201 -11ZM121 120Q121 70 147 48T206 26Q250 26 289 58T351 142Q360 163 374 216T388 308Q388 352 370 375Q346 405 306 405Q243 405 195 347Q158 303 140 230T121 120"],112:[443,194,503,-39,497,"23 287Q24 290 25 295T30 317T40 348T55 381T75 411T101 433T134 442Q209 442 230 378L240 387Q302 442 358 442Q423 442 460 395T497 281Q497 173 421 82T249 -10Q227 -10 210 -4Q199 1 187 11T168 28L161 36Q160 35 139 -51T118 -138Q118 -144 126 -145T163 -148H188Q194 -155 194 -157T191 -175Q188 -187 185 -190T172 -194Q170 -194 161 -194T127 -193T65 -192Q-5 -192 -24 -194H-32Q-39 -187 -39 -183Q-37 -156 -26 -148H-6Q28 -147 33 -136Q36 -130 94 103T155 350Q156 355 156 364Q156 405 131 405Q109 405 94 377T71 316T59 280Q57 278 43 278H29Q23 284 23 287ZM178 102Q200 26 252 26Q282 26 310 49T356 107Q374 141 392 215T411 325V331Q411 405 350 405Q339 405 328 402T306 393T286 380T269 365T254 350T243 336T235 326L232 322Q232 321 229 308T218 264T204 212Q178 106 178 102"],113:[442,194,446,33,460,"33 157Q33 258 109 349T280 441Q340 441 372 389Q373 390 377 395T388 406T404 418Q438 442 450 442Q454 442 457 439T460 434Q460 425 391 149Q320 -135 320 -139Q320 -147 365 -148H390Q396 -156 396 -157T393 -175Q389 -188 383 -194H370Q339 -192 262 -192Q234 -192 211 -192T174 -192T157 -193Q143 -193 143 -185Q143 -182 145 -170Q149 -154 152 -151T172 -148Q220 -148 230 -141Q238 -136 258 -53T279 32Q279 33 272 29Q224 -10 172 -10Q117 -10 75 30T33 157ZM352 326Q329 405 277 405Q242 405 210 374T160 293Q131 214 119 129Q119 126 119 118T118 106Q118 61 136 44T179 26Q233 26 290 98L298 109L352 326"],114:[443,11,451,21,430,"21 287Q22 290 23 295T28 317T38 348T53 381T73 411T99 433T132 442Q161 442 183 430T214 408T225 388Q227 382 228 382T236 389Q284 441 347 441H350Q398 441 422 400Q430 381 430 363Q430 333 417 315T391 292T366 288Q346 288 334 299T322 328Q322 376 378 392Q356 405 342 405Q286 405 239 331Q229 315 224 298T190 165Q156 25 151 16Q138 -11 108 -11Q95 -11 87 -5T76 7T74 17Q74 30 114 189T154 366Q154 405 128 405Q107 405 92 377T68 316T57 280Q55 278 41 278H27Q21 284 21 287"],115:[443,10,469,53,419,"131 289Q131 321 147 354T203 415T300 442Q362 442 390 415T419 355Q419 323 402 308T364 292Q351 292 340 300T328 326Q328 342 337 354T354 372T367 378Q368 378 368 379Q368 382 361 388T336 399T297 405Q249 405 227 379T204 326Q204 301 223 291T278 274T330 259Q396 230 396 163Q396 135 385 107T352 51T289 7T195 -10Q118 -10 86 19T53 87Q53 126 74 143T118 160Q133 160 146 151T160 120Q160 94 142 76T111 58Q109 57 108 57T107 55Q108 52 115 47T146 34T201 27Q237 27 263 38T301 66T318 97T323 122Q323 150 302 164T254 181T195 196T148 231Q131 256 131 289"],116:[626,11,361,19,330,"26 385Q19 392 19 395Q19 399 22 411T27 425Q29 430 36 430T87 431H140L159 511Q162 522 166 540T173 566T179 586T187 603T197 615T211 624T229 626Q247 625 254 615T261 596Q261 589 252 549T232 470L222 433Q222 431 272 431H323Q330 424 330 420Q330 398 317 385H210L174 240Q135 80 135 68Q135 26 162 26Q197 26 230 60T283 144Q285 150 288 151T303 153H307Q322 153 322 145Q322 142 319 133Q314 117 301 95T267 48T216 6T155 -11Q125 -11 98 4T59 56Q57 64 57 83V101L92 241Q127 382 128 383Q128 385 77 385H26"],117:[442,11,572,21,551,"21 287Q21 295 30 318T55 370T99 420T158 442Q204 442 227 417T250 358Q250 340 216 246T182 105Q182 62 196 45T238 27T291 44T328 78L339 95Q341 99 377 247Q407 367 413 387T427 416Q444 431 463 431Q480 431 488 421T496 402L420 84Q419 79 419 68Q419 43 426 35T447 26Q469 29 482 57T512 145Q514 153 532 153Q551 153 551 144Q550 139 549 130T540 98T523 55T498 17T462 -8Q454 -10 438 -10Q372 -10 347 46Q345 45 336 36T318 21T296 6T267 -6T233 -11Q189 -11 155 7Q103 38 103 113Q103 170 138 262T173 379Q173 380 173 381Q173 390 173 393T169 400T158 404H154Q131 404 112 385T82 344T65 302T57 280Q55 278 41 278H27Q21 284 21 287"],118:[443,11,485,21,467,"173 380Q173 405 154 405Q130 405 104 376T61 287Q60 286 59 284T58 281T56 279T53 278T49 278T41 278H27Q21 284 21 287Q21 294 29 316T53 368T97 419T160 441Q202 441 225 417T249 361Q249 344 246 335Q246 329 231 291T200 202T182 113Q182 86 187 69Q200 26 250 26Q287 26 319 60T369 139T398 222T409 277Q409 300 401 317T383 343T365 361T357 383Q357 405 376 424T417 443Q436 443 451 425T467 367Q467 340 455 284T418 159T347 40T241 -11Q177 -11 139 22Q102 54 102 117Q102 148 110 181T151 298Q173 362 173 380"],119:[443,11,716,21,690,"580 385Q580 406 599 424T641 443Q659 443 674 425T690 368Q690 339 671 253Q656 197 644 161T609 80T554 12T482 -11Q438 -11 404 5T355 48Q354 47 352 44Q311 -11 252 -11Q226 -11 202 -5T155 14T118 53T104 116Q104 170 138 262T173 379Q173 380 173 381Q173 390 173 393T169 400T158 404H154Q131 404 112 385T82 344T65 302T57 280Q55 278 41 278H27Q21 284 21 287Q21 293 29 315T52 366T96 418T161 441Q204 441 227 416T250 358Q250 340 217 250T184 111Q184 65 205 46T258 26Q301 26 334 87L339 96V119Q339 122 339 128T340 136T341 143T342 152T345 165T348 182T354 206T362 238T373 281Q402 395 406 404Q419 431 449 431Q468 431 475 421T483 402Q483 389 454 274T422 142Q420 131 420 107V100Q420 85 423 71T442 42T487 26Q558 26 600 148Q609 171 620 213T632 273Q632 306 619 325T593 357T580 385"],120:[442,11,572,35,522,"52 289Q59 331 106 386T222 442Q257 442 286 424T329 379Q371 442 430 442Q467 442 494 420T522 361Q522 332 508 314T481 292T458 288Q439 288 427 299T415 328Q415 374 465 391Q454 404 425 404Q412 404 406 402Q368 386 350 336Q290 115 290 78Q290 50 306 38T341 26Q378 26 414 59T463 140Q466 150 469 151T485 153H489Q504 153 504 145Q504 144 502 134Q486 77 440 33T333 -11Q263 -11 227 52Q186 -10 133 -10H127Q78 -10 57 16T35 71Q35 103 54 123T99 143Q142 143 142 101Q142 81 130 66T107 46T94 41L91 40Q91 39 97 36T113 29T132 26Q168 26 194 71Q203 87 217 139T245 247T261 313Q266 340 266 352Q266 380 251 392T217 404Q177 404 142 372T93 290Q91 281 88 280T72 278H58Q52 284 52 289"],121:[443,205,490,21,497,"21 287Q21 301 36 335T84 406T158 442Q199 442 224 419T250 355Q248 336 247 334Q247 331 231 288T198 191T182 105Q182 62 196 45T238 27Q261 27 281 38T312 61T339 94Q339 95 344 114T358 173T377 247Q415 397 419 404Q432 431 462 431Q475 431 483 424T494 412T496 403Q496 390 447 193T391 -23Q363 -106 294 -155T156 -205Q111 -205 77 -183T43 -117Q43 -95 50 -80T69 -58T89 -48T106 -45Q150 -45 150 -87Q150 -107 138 -122T115 -142T102 -147L99 -148Q101 -153 118 -160T152 -167H160Q177 -167 186 -165Q219 -156 247 -127T290 -65T313 -9T321 21L315 17Q309 13 296 6T270 -6Q250 -11 231 -11Q185 -11 150 11T104 82Q103 89 103 113Q103 170 138 262T173 379Q173 380 173 381Q173 390 173 393T169 400T158 404H154Q131 404 112 385T82 344T65 302T57 280Q55 278 41 278H27Q21 284 21 287"],122:[442,11,465,35,468,"347 338Q337 338 294 349T231 360Q211 360 197 356T174 346T162 335T155 324L153 320Q150 317 138 317Q117 317 117 325Q117 330 120 339Q133 378 163 406T229 440Q241 442 246 442Q271 442 291 425T329 392T367 375Q389 375 411 408T434 441Q435 442 449 442H462Q468 436 468 434Q468 430 463 420T449 399T432 377T418 358L411 349Q368 298 275 214T160 106L148 94L163 93Q185 93 227 82T290 71Q328 71 360 90T402 140Q406 149 409 151T424 153Q443 153 443 143Q443 138 442 134Q425 72 376 31T278 -11Q252 -11 232 6T193 40T155 57Q111 57 76 -3Q70 -11 59 -11H54H41Q35 -5 35 -2Q35 13 93 84Q132 129 225 214T340 322Q352 338 347 338"],915:[680,-1,615,31,721,"49 1Q31 1 31 10Q31 12 34 24Q39 43 44 45Q48 46 59 46H65Q92 46 125 49Q139 52 144 61Q146 66 215 342T285 622Q285 629 281 629Q273 632 228 634H197Q191 640 191 642T193 661Q197 674 203 680H714Q721 676 721 669Q721 664 708 557T694 447Q692 440 674 440H662Q655 445 655 454Q655 455 658 480T661 534Q661 572 652 592Q638 619 603 626T501 634H471Q398 633 393 630Q389 628 386 622Q385 619 315 341T245 60Q245 46 333 46H345Q366 46 366 35Q366 33 363 21T358 6Q356 1 339 1Q334 1 292 1T187 2Q122 2 88 2T49 1"],920:[704,22,763,50,740,"740 435Q740 320 676 213T511 42T304 -22Q207 -22 138 35T51 201Q50 209 50 244Q50 346 98 438T227 601Q351 704 476 704Q514 704 524 703Q621 689 680 617T740 435ZM640 466Q640 523 625 565T583 628T532 658T479 668Q370 668 273 559T151 255Q150 245 150 213Q150 156 165 116T207 55T259 26T313 17Q385 17 451 63T561 184Q590 234 615 312T640 466ZM510 276Q510 278 512 288L515 298Q515 299 384 299H253L250 285Q246 271 244 268T231 265H227Q216 265 214 266T207 274Q207 278 223 345T244 416Q247 419 260 419H263Q280 419 280 408Q280 406 278 396L275 386Q275 385 406 385H537L540 399Q544 413 546 416T559 419H563Q574 419 576 418T583 410Q583 403 566 339Q549 271 544 267Q542 265 538 265H530H527Q510 265 510 276"],923:[716,0,694,35,670,"135 2Q114 2 90 2T60 1Q35 1 35 11Q35 28 42 40Q45 46 55 46Q119 46 151 94Q153 97 325 402T498 709Q505 716 526 716Q543 716 549 710Q550 709 560 548T580 224T591 57Q594 52 595 52Q603 47 638 46H663Q670 39 670 35Q669 12 657 0H644Q613 2 530 2Q497 2 469 2T424 2T405 1Q388 1 388 10Q388 15 391 24Q392 27 393 32T395 38T397 41T401 44T406 45T415 46Q473 46 487 64L472 306Q468 365 465 426T459 518L457 550Q456 550 328 322T198 88Q196 80 196 77Q196 49 243 46Q261 46 261 35Q261 34 259 22Q256 7 254 4T240 0Q237 0 211 1T135 2"],926:[678,0,742,53,777,"222 668Q222 670 229 677H654Q677 677 705 677T740 678Q764 678 770 676T777 667Q777 662 764 594Q761 579 757 559T751 528L749 519Q747 512 729 512H717Q710 519 710 525Q712 532 715 559T719 591Q718 595 711 595Q682 598 486 598Q252 598 246 592Q239 587 228 552L216 517Q214 512 197 512H185Q178 517 178 522Q178 524 198 591T222 668ZM227 262Q218 262 215 262T209 266L207 270L227 356Q247 435 250 439Q253 443 260 443H267H280Q287 438 287 433Q287 430 285 420T280 402L278 393Q278 392 431 392H585L590 415Q595 436 598 439T612 443H628Q635 438 635 433Q635 431 615 351T594 268Q592 262 575 262H572Q556 262 556 272Q556 280 560 293L565 313H258L252 292Q248 271 245 267T230 262H227ZM60 0Q53 4 53 11Q53 14 68 89T84 169Q88 176 98 176H104H116Q123 169 123 163Q122 160 117 127T112 88Q112 80 243 80H351H454Q554 80 574 81T597 88V89Q603 100 610 121T622 157T630 174Q633 176 646 176H658Q665 171 665 166Q665 164 643 89T618 7Q616 2 607 1T548 0H335H60"],928:[681,0,831,31,887,"48 1Q31 1 31 10Q31 12 34 24Q39 43 44 45Q48 46 59 46H65Q92 46 125 49Q139 52 144 61Q146 66 215 342T285 622Q285 629 281 629Q273 632 228 634H197Q191 640 191 642T193 661Q197 674 203 680H541Q621 680 709 680T812 681Q841 681 855 681T877 679T886 676T887 670Q887 663 885 656Q880 637 875 635Q871 634 860 634H854Q827 634 794 631Q780 628 775 619Q773 614 704 338T634 58Q634 51 638 51Q646 48 692 46H723Q729 38 729 37T726 19Q722 6 716 0H701Q664 2 567 2Q533 2 504 2T458 2T437 1Q420 1 420 10Q420 15 423 24Q428 43 433 45Q437 46 448 46H454Q481 46 514 49Q528 52 533 61Q536 67 572 209T642 491T678 632Q678 634 533 634H388Q387 631 316 347T245 59Q245 55 246 54T253 50T270 48T303 46H334Q340 38 340 37T337 19Q333 6 327 0H312Q275 2 178 2Q144 2 115 2T69 2T48 1"],931:[683,0,780,58,806,"65 0Q58 4 58 11Q58 16 114 67Q173 119 222 164L377 304Q378 305 340 386T261 552T218 644Q217 648 219 660Q224 678 228 681Q231 683 515 683H799Q804 678 806 674Q806 667 793 559T778 448Q774 443 759 443Q747 443 743 445T739 456Q739 458 741 477T743 516Q743 552 734 574T710 609T663 627T596 635T502 637Q480 637 469 637H339Q344 627 411 486T478 341V339Q477 337 477 336L457 318Q437 300 398 265T322 196L168 57Q167 56 188 56T258 56H359Q426 56 463 58T537 69T596 97T639 146T680 225Q686 243 689 246T702 250H705Q726 250 726 239Q726 238 683 123T639 5Q637 1 610 1Q577 0 348 0H65"],933:[706,0,583,28,700,"45 535Q34 535 31 536T28 544Q28 554 39 578T70 631T126 683T206 705Q230 705 251 698T295 671T330 612T344 514Q344 477 342 473V472Q343 472 347 480T361 509T380 547Q471 704 596 704Q615 704 625 702Q659 692 679 663T700 595Q700 565 696 552T687 537T670 535Q656 535 653 536T649 543Q649 544 649 550T650 562Q650 589 629 605T575 621Q502 621 448 547T365 361Q290 70 290 60Q290 46 379 46H404Q410 40 410 39T408 19Q404 6 398 0H381Q340 2 225 2Q184 2 149 2T94 2T69 1Q61 1 58 1T53 4T51 10Q51 11 53 23Q54 25 55 30T56 36T58 40T60 43T62 44T67 46T73 46T82 46H89Q144 46 163 49T190 62L198 93Q206 124 217 169T241 262T262 350T274 404Q281 445 281 486V494Q281 621 185 621Q147 621 116 601T74 550Q71 539 66 537T45 535"],934:[683,0,667,24,642,"356 624Q356 637 267 637H243Q237 642 237 645T239 664Q243 677 249 683H264Q342 681 429 681Q565 681 571 683H583Q589 677 589 674T587 656Q582 641 578 637H540Q516 637 504 637T479 633T463 630T454 623T448 613T443 597T438 576Q436 566 434 556T430 539L428 533Q442 533 472 526T543 502T613 451T642 373Q642 301 567 241T386 158L336 150Q332 150 331 146Q310 66 310 60Q310 46 399 46H424Q430 40 430 39T428 19Q424 6 418 0H401Q360 2 247 2Q207 2 173 2T119 2T95 1Q87 1 84 1T79 4T77 10Q77 11 79 23Q80 25 81 30T82 36T84 40T86 43T88 44T93 46T99 46T108 46H115Q170 46 189 49T216 62Q220 74 228 107L239 150L223 152Q139 164 82 205T24 311Q24 396 125 462Q207 517 335 533L346 578Q356 619 356 624ZM130 291Q130 203 241 188H249Q249 190 287 342L325 495H324Q313 495 291 491T229 466T168 414Q130 357 130 291ZM536 393Q536 440 507 463T418 496L341 187L351 189Q443 201 487 255Q536 314 536 393"],936:[683,0,612,21,692,"216 151Q48 174 48 329Q48 361 56 403T65 458Q65 482 58 494T43 507T28 510T21 520Q21 528 23 534T29 544L32 546H72H94Q110 546 119 544T139 536T154 514T159 476V465Q159 445 149 399T138 314Q142 229 197 201Q223 187 226 190L233 218Q240 246 253 300T280 407Q333 619 333 625Q333 637 244 637H220Q214 642 214 645T216 664Q220 677 226 683H241Q321 681 405 681Q543 681 549 683H560Q566 677 566 674T564 656Q559 641 555 637H517Q448 636 436 628Q429 623 423 600T373 404L320 192Q370 201 419 248Q451 281 469 317T500 400T518 457Q529 486 542 505T569 532T594 543T621 546H644H669Q692 546 692 536Q691 509 676 509Q623 509 593 399Q587 377 579 355T552 301T509 244T446 195T359 159Q324 151 314 151Q311 151 310 150T298 106T287 60Q287 46 376 46H401Q407 40 407 39T405 19Q401 6 395 0H378Q337 2 224 2Q184 2 150 2T96 2T72 1Q64 1 61 1T56 4T54 10Q54 11 56 23Q57 25 58 30T59 36T61 40T63 43T65 44T70 46T76 46T85 46H92Q147 46 166 49T193 62L204 106Q216 149 216 151"],937:[704,0,772,80,786,"125 84Q127 78 194 76H243V78Q243 122 208 215T165 350Q164 359 162 389Q162 522 272 610Q328 656 396 680T525 704Q628 704 698 661Q734 637 755 601T781 544T786 504Q786 439 747 374T635 226T537 109Q518 81 518 77Q537 76 557 76Q608 76 620 78T640 92Q646 100 656 119T673 155T683 172Q690 173 698 173Q718 173 718 162Q718 161 681 82T642 2Q639 0 550 0H461Q455 5 455 9T458 28Q472 78 510 149T584 276T648 402T677 525Q677 594 636 631T530 668Q476 668 423 641T335 568Q284 499 271 400Q270 388 270 348Q270 298 277 228T285 115Q285 82 280 49T271 6Q269 1 258 1T175 0H87Q83 3 80 7V18Q80 22 82 98Q84 156 85 163T91 172Q94 173 104 173T119 172Q124 169 124 126Q125 104 125 84"],945:[442,11,640,34,603,"34 156Q34 270 120 356T309 442Q379 442 421 402T478 304Q484 275 485 237V208Q534 282 560 374Q564 388 566 390T582 393Q603 393 603 385Q603 376 594 346T558 261T497 161L486 147L487 123Q489 67 495 47T514 26Q528 28 540 37T557 60Q559 67 562 68T577 70Q597 70 597 62Q597 56 591 43Q579 19 556 5T512 -10H505Q438 -10 414 62L411 69L400 61Q390 53 370 41T325 18T267 -2T203 -11Q124 -11 79 39T34 156ZM208 26Q257 26 306 47T379 90L403 112Q401 255 396 290Q382 405 304 405Q235 405 183 332Q156 292 139 224T121 120Q121 71 146 49T208 26"],946:[705,194,566,23,573,"29 -194Q23 -188 23 -186Q23 -183 102 134T186 465Q208 533 243 584T309 658Q365 705 429 705H431Q493 705 533 667T573 570Q573 465 469 396L482 383Q533 332 533 252Q533 139 448 65T257 -10Q227 -10 203 -2T165 17T143 40T131 59T126 65L62 -188Q60 -194 42 -194H29ZM353 431Q392 431 427 419L432 422Q436 426 439 429T449 439T461 453T472 471T484 495T493 524T501 560Q503 569 503 593Q503 611 502 616Q487 667 426 667Q384 667 347 643T286 582T247 514T224 455Q219 439 186 308T152 168Q151 163 151 147Q151 99 173 68Q204 26 260 26Q302 26 349 51T425 137Q441 171 449 214T457 279Q457 337 422 372Q380 358 347 358H337Q258 358 258 389Q258 396 261 403Q275 431 353 431"],947:[441,216,518,11,543,"31 249Q11 249 11 258Q11 275 26 304T66 365T129 418T206 441Q233 441 239 440Q287 429 318 386T371 255Q385 195 385 170Q385 166 386 166L398 193Q418 244 443 300T486 391T508 430Q510 431 524 431H537Q543 425 543 422Q543 418 522 378T463 251T391 71Q385 55 378 6T357 -100Q341 -165 330 -190T303 -216Q286 -216 286 -188Q286 -138 340 32L346 51L347 69Q348 79 348 100Q348 257 291 317Q251 355 196 355Q148 355 108 329T51 260Q49 251 47 251Q45 249 31 249"],948:[717,10,444,36,451,"195 609Q195 656 227 686T302 717Q319 716 351 709T407 697T433 690Q451 682 451 662Q451 644 438 628T403 612Q382 612 348 641T288 671T249 657T235 628Q235 584 334 463Q401 379 401 292Q401 169 340 80T205 -10H198Q127 -10 83 36T36 153Q36 286 151 382Q191 413 252 434Q252 435 245 449T230 481T214 521T201 566T195 609ZM112 130Q112 83 136 55T204 27Q233 27 256 51T291 111T309 178T316 232Q316 267 309 298T295 344T269 400L259 396Q215 381 183 342T137 256T118 179T112 130"],949:[452,23,466,27,428,"190 -22Q124 -22 76 11T27 107Q27 174 97 232L107 239L99 248Q76 273 76 304Q76 364 144 408T290 452H302Q360 452 405 421Q428 405 428 392Q428 381 417 369T391 356Q382 356 371 365T338 383T283 392Q217 392 167 368T116 308Q116 289 133 272Q142 263 145 262T157 264Q188 278 238 278H243Q308 278 308 247Q308 206 223 206Q177 206 142 219L132 212Q68 169 68 112Q68 39 201 39Q253 39 286 49T328 72T345 94T362 105Q376 103 376 88Q376 79 365 62T334 26T275 -8T190 -22"],950:[704,204,438,44,471,"296 643Q298 704 324 704Q342 704 342 687Q342 682 339 664T336 633Q336 623 337 618T338 611Q339 612 341 612Q343 614 354 616T374 618L384 619H394Q471 619 471 586Q467 548 386 546H372Q338 546 320 564L311 558Q235 506 175 398T114 190Q114 171 116 155T125 127T137 104T153 86T171 72T192 61T213 53T235 46T256 39L322 16Q389 -10 389 -80Q389 -119 364 -154T300 -202Q292 -204 274 -204Q247 -204 225 -196Q210 -192 193 -182T172 -167Q167 -159 173 -148Q180 -139 191 -139Q195 -139 221 -153T283 -168Q298 -166 310 -152T322 -117Q322 -91 302 -75T250 -51T183 -29T116 4T65 62T44 160Q44 287 121 410T293 590L302 595Q296 613 296 643"],951:[443,216,497,21,503,"21 287Q22 290 23 295T28 317T38 348T53 381T73 411T99 433T132 442Q156 442 175 435T205 417T221 395T229 376L231 369Q231 367 232 367L243 378Q304 442 382 442Q436 442 469 415T503 336V326Q503 302 439 53Q381 -182 377 -189Q364 -216 332 -216Q319 -216 310 -208T299 -186Q299 -177 358 57L420 307Q423 322 423 345Q423 404 379 404H374Q288 404 229 303L222 291L189 157Q156 26 151 16Q138 -11 108 -11Q95 -11 87 -5T76 7T74 17Q74 30 114 189T154 366Q154 405 128 405Q107 405 92 377T68 316T57 280Q55 278 41 278H27Q21 284 21 287"],952:[705,10,469,35,462,"35 200Q35 302 74 415T180 610T319 704Q320 704 327 704T339 705Q393 701 423 656Q462 596 462 495Q462 380 417 261T302 66T168 -10H161Q125 -10 99 10T60 63T41 130T35 200ZM383 566Q383 668 330 668Q294 668 260 623T204 521T170 421T157 371Q206 370 254 370L351 371Q352 372 359 404T375 484T383 566ZM113 132Q113 26 166 26Q181 26 198 36T239 74T287 161T335 307L340 324H145Q145 321 136 286T120 208T113 132"],953:[442,10,354,48,333,"139 -10Q111 -10 92 0T64 25T52 52T48 74Q48 89 55 109T85 199T135 375L137 384Q139 394 140 397T145 409T151 422T160 431T173 439T190 442Q202 442 213 435T225 410Q225 404 214 358T181 238T137 107Q126 74 126 54Q126 43 126 39T130 31T142 27H147Q206 27 255 78Q272 98 281 114T290 138T295 149T313 153Q321 153 324 153T329 152T332 149T332 143Q332 106 276 48T145 -10H139"],954:[442,11,576,48,554,"83 -11Q70 -11 62 -4T51 8T49 17Q49 30 96 217T147 414Q160 442 193 442Q205 441 213 435T223 422T225 412Q225 401 208 337L192 270Q193 269 208 277T235 292Q252 304 306 349T396 412T467 431Q489 431 500 420T512 391Q512 366 494 347T449 327Q430 327 418 338T405 368Q405 370 407 380L397 375Q368 360 315 315L253 266L240 257H245Q262 257 300 251T366 230Q422 203 422 150Q422 140 417 114T411 67Q411 26 437 26Q484 26 513 137Q516 149 519 151T535 153Q554 153 554 144Q554 121 527 64T457 -7Q447 -10 431 -10Q386 -10 360 17T333 90Q333 108 336 122T339 146Q339 170 320 186T271 209T222 218T185 221H180L155 122Q129 22 126 16Q113 -11 83 -11"],955:[694,12,583,47,557,"166 673Q166 685 183 694H202Q292 691 316 644Q322 629 373 486T474 207T524 67Q531 47 537 34T546 15T551 6T555 2T556 -2T550 -11H482Q457 3 450 18T399 152L354 277L340 262Q327 246 293 207T236 141Q211 112 174 69Q123 9 111 -1T83 -12Q47 -12 47 20Q47 37 61 52T199 187Q229 216 266 252T321 306L338 322Q338 323 288 462T234 612Q214 657 183 657Q166 657 166 673"],956:[442,216,603,23,580,"58 -216Q44 -216 34 -208T23 -186Q23 -176 96 116T173 414Q186 442 219 442Q231 441 239 435T249 423T251 413Q251 401 220 279T187 142Q185 131 185 107V99Q185 26 252 26Q261 26 270 27T287 31T302 38T315 45T327 55T338 65T348 77T356 88T365 100L372 110L408 253Q444 395 448 404Q461 431 491 431Q504 431 512 424T523 412T525 402L449 84Q448 79 448 68Q448 43 455 35T476 26Q485 27 496 35Q517 55 537 131Q543 151 547 152Q549 153 557 153H561Q580 153 580 144Q580 138 575 117T555 63T523 13Q510 0 491 -8Q483 -10 467 -10Q446 -10 429 -4T402 11T385 29T376 44T374 51L368 45Q362 39 350 30T324 12T288 -4T246 -11Q199 -11 153 12L129 -85Q108 -167 104 -180T92 -202Q76 -216 58 -216"],957:[442,2,494,45,530,"74 431Q75 431 146 436T219 442Q231 442 231 434Q231 428 185 241L137 51H140L150 55Q161 59 177 67T214 86T261 119T312 165Q410 264 445 394Q458 442 496 442Q509 442 519 434T530 411Q530 390 516 352T469 262T388 162T267 70T106 5Q81 -2 71 -2Q66 -2 59 -1T51 1Q45 5 45 11Q45 13 88 188L132 364Q133 377 125 380T86 385H65Q59 391 59 393T61 412Q65 431 74 431"],958:[704,205,438,21,443,"268 632Q268 704 296 704Q314 704 314 687Q314 682 311 664T308 635T309 620V616H315Q342 619 360 619Q443 619 443 586Q439 548 358 546H344Q326 546 317 549T290 566Q257 550 226 505T195 405Q195 381 201 364T211 342T218 337Q266 347 298 347Q375 347 375 314Q374 297 359 288T327 277T280 275Q234 275 208 283L195 286Q149 260 119 214T88 130Q88 116 90 108Q101 79 129 63T229 20Q238 17 243 15Q337 -21 354 -33Q383 -53 383 -94Q383 -137 351 -171T273 -205Q240 -205 202 -190T158 -167Q156 -163 156 -159Q156 -151 161 -146T176 -140Q182 -140 189 -143Q232 -168 274 -168Q286 -168 292 -165Q313 -151 313 -129Q313 -112 301 -104T232 -75Q214 -68 204 -64Q198 -62 171 -52T136 -38T107 -24T78 -8T56 12T36 37T26 66T21 103Q21 149 55 206T145 301L154 307L148 313Q141 319 136 323T124 338T111 358T103 382T99 413Q99 471 143 524T259 602L271 607Q268 618 268 632"],959:[441,11,485,34,476,"201 -11Q126 -11 80 38T34 156Q34 221 64 279T146 380Q222 441 301 441Q333 441 341 440Q354 437 367 433T402 417T438 387T464 338T476 268Q476 161 390 75T201 -11ZM121 120Q121 70 147 48T206 26Q250 26 289 58T351 142Q360 163 374 216T388 308Q388 352 370 375Q346 405 306 405Q243 405 195 347Q158 303 140 230T121 120"],960:[431,11,570,19,573,"132 -11Q98 -11 98 22V33L111 61Q186 219 220 334L228 358H196Q158 358 142 355T103 336Q92 329 81 318T62 297T53 285Q51 284 38 284Q19 284 19 294Q19 300 38 329T93 391T164 429Q171 431 389 431Q549 431 553 430Q573 423 573 402Q573 371 541 360Q535 358 472 358H408L405 341Q393 269 393 222Q393 170 402 129T421 65T431 37Q431 20 417 5T381 -10Q370 -10 363 -7T347 17T331 77Q330 86 330 121Q330 170 339 226T357 318T367 358H269L268 354Q268 351 249 275T206 114T175 17Q164 -11 132 -11"],961:[442,216,517,23,510,"58 -216Q25 -216 23 -186Q23 -176 73 26T127 234Q143 289 182 341Q252 427 341 441Q343 441 349 441T359 442Q432 442 471 394T510 276Q510 219 486 165T425 74T345 13T266 -10H255H248Q197 -10 165 35L160 41L133 -71Q108 -168 104 -181T92 -202Q76 -216 58 -216ZM424 322Q424 359 407 382T357 405Q322 405 287 376T231 300Q217 269 193 170L176 102Q193 26 260 26Q298 26 334 62Q367 92 389 158T418 266T424 322"],962:[442,107,363,30,405,"31 207Q31 306 115 374T302 442Q341 442 373 430T405 400Q405 392 399 383T379 374Q373 375 348 390T296 405Q222 405 160 357T98 249Q98 232 103 218T112 195T132 175T154 159T186 141T219 122Q234 114 255 102T286 85T299 78L302 74Q306 71 308 69T315 61T322 51T328 40T332 25T334 8Q334 -31 305 -69T224 -107Q194 -107 163 -92Q156 -88 156 -80Q156 -73 162 -67T178 -61Q186 -61 190 -63Q209 -71 224 -71Q244 -71 253 -59T263 -30Q263 -25 263 -21T260 -12T255 -4T248 3T239 9T227 17T213 25T195 34T174 46Q170 48 150 58T122 74T97 90T70 112T51 137T36 169T31 207"],963:[431,11,571,31,572,"184 -11Q116 -11 74 34T31 147Q31 247 104 333T274 430Q275 431 414 431H552Q553 430 555 429T559 427T562 425T565 422T567 420T569 416T570 412T571 407T572 401Q572 357 507 357Q500 357 490 357T476 358H416L421 348Q439 310 439 263Q439 153 359 71T184 -11ZM361 278Q361 358 276 358Q152 358 115 184Q114 180 114 178Q106 141 106 117Q106 67 131 47T188 26Q242 26 287 73Q316 103 334 153T356 233T361 278"],964:[431,13,437,18,517,"39 284Q18 284 18 294Q18 301 45 338T99 398Q134 425 164 429Q170 431 332 431Q492 431 497 429Q517 424 517 402Q517 388 508 376T485 360Q479 358 389 358T299 356Q298 355 283 274T251 109T233 20Q228 5 215 -4T186 -13Q153 -13 153 20V30L203 192Q214 228 227 272T248 336L254 357Q254 358 208 358Q206 358 197 358T183 359Q105 359 61 295Q56 287 53 286T39 284"],965:[443,10,540,21,523,"413 384Q413 406 432 424T473 443Q492 443 507 425T523 367Q523 334 508 270T468 153Q424 63 373 27T282 -10H268Q220 -10 186 2T135 36T111 78T104 121Q104 170 138 262T173 379Q173 380 173 381Q173 390 173 393T169 400T158 404H154Q131 404 112 385T82 344T65 302T57 280Q55 278 41 278H27Q21 284 21 287Q21 299 34 333T82 404T161 441Q200 441 225 419T250 355Q248 336 247 334Q247 331 232 291T201 199T185 118Q185 68 211 47T275 26Q317 26 355 57T416 132T452 216T465 277Q465 301 457 318T439 343T421 361T413 384"],966:[442,218,654,50,618,"92 210Q92 176 106 149T142 108T185 85T220 72L235 70L237 71L250 112Q268 170 283 211T322 299T370 375T429 423T502 442Q547 442 582 410T618 302Q618 224 575 152T457 35T299 -10Q273 -10 273 -12L266 -48Q260 -83 252 -125T241 -179Q236 -203 215 -212Q204 -218 190 -218Q159 -215 159 -185Q159 -175 214 -2L209 0Q204 2 195 5T173 14T147 28T120 46T94 71T71 103T56 142T50 190Q50 238 76 311T149 431H162Q183 431 183 423Q183 417 175 409Q134 361 114 300T92 210ZM574 278Q574 320 550 344T486 369Q437 369 394 329T323 218Q309 184 295 109L286 64Q304 62 306 62Q423 62 498 131T574 278"],967:[443,204,626,24,600,"576 -125Q576 -147 547 -175T487 -204H476Q394 -204 363 -157Q334 -114 293 26L284 59Q283 58 248 19T170 -66T92 -151T53 -191Q49 -194 43 -194Q36 -194 31 -189T25 -177T38 -154T151 -30L272 102L265 131Q189 405 135 405Q104 405 87 358Q86 351 68 351Q48 351 48 361Q48 369 56 386T89 423T148 442Q224 442 258 400Q276 375 297 320T330 222L341 180Q344 180 455 303T573 429Q579 431 582 431Q600 431 600 414Q600 407 587 392T477 270Q356 138 353 134L362 102Q392 -10 428 -89T490 -168Q504 -168 517 -156T536 -126Q539 -116 543 -115T557 -114T571 -115Q576 -118 576 -125"],968:[694,205,651,21,634,"161 441Q202 441 226 417T250 358Q250 338 218 252T187 127Q190 85 214 61Q235 43 257 37Q275 29 288 29H289L371 360Q455 691 456 692Q459 694 472 694Q492 694 492 687Q492 678 411 356Q329 28 329 27T335 26Q421 26 498 114T576 278Q576 302 568 319T550 343T532 361T524 384Q524 405 541 424T583 443Q602 443 618 425T634 366Q634 337 623 288T605 220Q573 125 492 57T329 -11H319L296 -104Q272 -198 272 -199Q270 -205 252 -205H239Q233 -199 233 -197Q233 -192 256 -102T279 -9Q272 -8 265 -8Q106 14 106 139Q106 174 139 264T173 379Q173 380 173 381Q173 390 173 393T169 400T158 404H154Q131 404 112 385T82 344T65 302T57 280Q55 278 41 278H27Q21 284 21 287Q21 299 34 333T82 404T161 441"],969:[443,12,622,15,604,"495 384Q495 406 514 424T555 443Q574 443 589 425T604 364Q604 334 592 278T555 155T483 38T377 -11Q297 -11 267 66Q266 68 260 61Q201 -11 125 -11Q15 -11 15 139Q15 230 56 325T123 434Q135 441 147 436Q160 429 160 418Q160 406 140 379T94 306T62 208Q61 202 61 187Q61 124 85 100T143 76Q201 76 245 129L253 137V156Q258 297 317 297Q348 297 348 261Q348 243 338 213T318 158L308 135Q309 133 310 129T318 115T334 97T358 83T393 76Q456 76 501 148T546 274Q546 305 533 325T508 357T495 384"],977:[705,11,591,21,563,"537 500Q537 474 533 439T524 383L521 362Q558 355 561 351Q563 349 563 345Q563 321 552 318Q542 318 521 323L510 326Q496 261 459 187T362 51T241 -11Q100 -11 100 105Q100 139 127 242T154 366Q154 405 128 405Q107 405 92 377T68 316T57 280Q55 278 41 278H27Q21 284 21 287Q21 291 27 313T47 368T79 418Q103 442 134 442Q169 442 201 419T233 344Q232 330 206 228T180 98Q180 26 247 26Q292 26 332 90T404 260L427 349Q422 349 398 359T339 392T289 440Q265 476 265 520Q265 590 312 647T417 705Q463 705 491 670T528 592T537 500ZM464 564Q464 668 413 668Q373 668 339 622T304 522Q304 494 317 470T349 431T388 406T421 391T435 387H436L443 415Q450 443 457 485T464 564"],981:[694,205,596,42,579,"409 688Q413 694 421 694H429H442Q448 688 448 686Q448 679 418 563Q411 535 404 504T392 458L388 442Q388 441 397 441T429 435T477 418Q521 397 550 357T579 260T548 151T471 65T374 11T279 -10H275L251 -105Q245 -128 238 -160Q230 -192 227 -198T215 -205H209Q189 -205 189 -198Q189 -193 211 -103L234 -11Q234 -10 226 -10Q221 -10 206 -8T161 6T107 36T62 89T43 171Q43 231 76 284T157 370T254 422T342 441Q347 441 348 445L378 567Q409 686 409 688ZM122 150Q122 116 134 91T167 53T203 35T237 27H244L337 404Q333 404 326 403T297 395T255 379T211 350T170 304Q152 276 137 237Q122 191 122 150ZM500 282Q500 320 484 347T444 385T405 400T381 404H378L332 217L284 29Q284 27 285 27Q293 27 317 33T357 47Q400 66 431 100T475 170T494 234T500 282"],982:[431,10,828,19,823,"206 -10Q158 -10 136 24T114 110Q114 233 199 349L205 358H184Q144 358 121 347Q108 340 95 330T75 312T61 295T53 285Q51 284 38 284Q19 284 19 294Q19 300 38 329T93 391T164 429Q171 431 532 431Q799 431 803 430Q823 423 823 402Q823 377 801 364Q790 358 766 358Q748 358 748 357Q748 355 749 348T752 327T754 297Q754 258 738 207T693 107T618 24T520 -10Q488 -10 466 2T432 36T416 77T411 120Q411 128 410 128T404 122Q373 71 323 31T206 -10ZM714 296Q714 316 707 358H251Q250 357 244 348T230 328T212 301T193 267T176 229T164 187T159 144Q159 62 222 62Q290 62 349 127T432 285Q433 286 434 288T435 291T437 293T440 294T444 294T452 294H466Q472 288 472 286Q472 285 464 244T456 170Q456 62 534 62Q604 62 659 139T714 296"],1009:[442,194,517,67,510,"205 -174Q136 -174 102 -153T67 -76Q67 -25 91 85T127 234Q143 289 182 341Q252 427 341 441Q343 441 349 441T359 442Q432 442 471 394T510 276Q510 169 431 80T253 -10Q226 -10 204 -2T169 19T146 44T132 64L128 73Q128 72 124 53T116 5T112 -44Q112 -68 117 -78T150 -95T236 -102Q327 -102 356 -111T386 -154Q386 -166 384 -178Q381 -190 378 -192T361 -194H348Q342 -188 342 -179Q342 -169 315 -169Q294 -169 264 -171T205 -174ZM424 322Q424 359 407 382T357 405Q322 405 287 376T231 300Q221 276 204 217Q188 152 188 116Q188 68 210 47T259 26Q297 26 334 62Q367 92 389 158T418 266T424 322"],1013:[431,11,406,40,382,"227 -11Q149 -11 95 41T40 174Q40 262 87 322Q121 367 173 396T287 430Q289 431 329 431H367Q382 426 382 411Q382 385 341 385H325H312Q191 385 154 277L150 265H327Q340 256 340 246Q340 228 320 219H138V217Q128 187 128 143Q128 77 160 52T231 26Q258 26 284 36T326 57T343 68Q350 68 354 58T358 39Q358 36 357 35Q354 31 337 21T289 0T227 -11"],8710:[716,0,833,48,788,""]};
m.FONTDATA.FONTS.MathJax_Main[8942][0]+=400;m.FONTDATA.FONTS.MathJax_Main[8945][0]+=700;m.FONTDATA.FONTS.MathJax_Main[8722][1]+=100;m.FONTDATA.FONTS.MathJax_Main[61][1]+=100;MathJax.Hub.Insert(m.FONTDATA.FONTS.MathJax_Main,{61152:[0,0,-575,0,0,{space:1}],61153:[0,0,-300,0,0,{space:1}],61160:[0,0,25,0,0,{space:1}]});h.Register.StartupHook("SVG Jax Require",function(){h.Register.LoadHook(m.fontDir+"/Size4/Regular/Main.js",function(){m.FONTDATA.FONTS.MathJax_Size4[57684][0]+=200;m.FONTDATA.FONTS.MathJax_Size4[57684][1]+=200});m.FONTDATA.FONTS.MathJax_Main[8773][2]-=222;h.Register.LoadHook(m.fontDir+"/Main/Bold/MathOperators.js",function(){m.FONTDATA.FONTS["MathJax_Main-bold"][8773][2]-=106});h.Register.LoadHook(m.fontDir+"/Typewriter/Regular/BasicLatin.js",function(){m.FONTDATA.FONTS.MathJax_Typewriter[32][2]+=275});p.loadComplete(m.fontDir+"/fontdata.js")})})(MathJax.OutputJax.SVG,MathJax.ElementJax.mml,MathJax.Ajax,MathJax.Hub);(function(a){var l="2.4.0";var k=a.FONTDATA.DELIMITERS;var g="MathJax_Main",h="MathJax_Main-bold",i="MathJax_AMS",e="MathJax_Size1",b="MathJax_Size4";var j="H",f="V";var d={61:{dir:j,HW:[[.767,g]],stretch:{rep:[61,g]}},8606:{dir:j,HW:[[1,i]],stretch:{left:[8606,i],rep:[8722,g]}},8608:{dir:j,HW:[[1,i]],stretch:{right:[8608,i],rep:[8722,g]}},8612:{dir:j,HW:[],stretch:{min:1,left:[8592,g],rep:[8722,g],right:[8739,e,0,-.05,.9]}},8613:{dir:f,HW:[],stretch:{min:.6,bot:[8869,h,0,0,.75],ext:[9168,e],top:[8593,e]}},8614:{dir:j,HW:[[1,g]],stretch:{left:[8739,e,-.09,-.05,.9],rep:[8722,g],right:[8594,g]}},8615:{dir:f,HW:[],stretch:{min:.6,top:[8868,h,0,0,.75],ext:[9168,e],bot:[8595,e]}},8624:{dir:f,HW:[[.722,i]],stretch:{top:[8624,i],ext:[9168,e,.097]}},8625:{dir:f,HW:[[.722,i]],stretch:{top:[8625,i,.27],ext:[9168,e]}},8636:{dir:j,HW:[[1,g]],stretch:{left:[8636,g],rep:[8722,g]}},8637:{dir:j,HW:[[1,g]],stretch:{left:[8637,g],rep:[8722,g]}},8638:{dir:f,HW:[[.888,i]],stretch:{top:[8638,i,.12,0,1.1],ext:[9168,e]}},8639:{dir:f,HW:[[.888,i]],stretch:{top:[8639,i,.12,0,1.1],ext:[9168,e]}},8640:{dir:j,HW:[[1,g]],stretch:{right:[8640,g],rep:[8722,g]}},8641:{dir:j,HW:[[1,g]],stretch:{right:[8641,g],rep:[8722,g]}},8642:{dir:f,HW:[[.888,i]],stretch:{bot:[8642,i,.12,0,1.1],ext:[9168,e]}},8643:{dir:f,HW:[[.888,i]],stretch:{bot:[8643,i,.12,0,1.1],ext:[9168,e]}},8666:{dir:j,HW:[[1,i]],stretch:{left:[8666,i],rep:[8801,g]}},8667:{dir:j,HW:[[1,i]],stretch:{right:[8667,i],rep:[8801,g]}},9140:{dir:j,HW:[],stretch:{min:.5,left:[9484,i,0,-.1],rep:[8722,g,0,.325],right:[9488,i,0,-.1]}},9141:{dir:j,HW:[],stretch:{min:.5,left:[9492,i,0,.26],rep:[8722,g,0,0,0,.25],right:[9496,i,0,.26]}},9180:{dir:j,HW:[[.778,i,0,8994],[1,g,0,8994]],stretch:{left:[57680,b],rep:[57684,b],right:[57681,b]}},9181:{dir:j,HW:[[.778,i,0,8995],[1,g,0,8995]],stretch:{left:[57682,b],rep:[57684,b],right:[57683,b]}},9184:{dir:j,HW:[],stretch:{min:1.25,left:[714,g,-.1],rep:[713,g,-.05,.13],right:[715,g],fullExtenders:true}},9185:{dir:j,HW:[],stretch:{min:1.5,left:[715,g,-.1,.1],rep:[713,g,-.1],right:[714,g,-.1,.1],fullExtenders:true}},10502:{dir:j,HW:[],stretch:{min:1,left:[8656,g],rep:[61,g],right:[8739,e,0,-.1]}},10503:{dir:j,HW:[],stretch:{min:.7,left:[8872,i,0,-.12],rep:[61,g],right:[8658,g]}},10574:{dir:j,HW:[],stretch:{min:.5,left:[8636,g],rep:[8722,g],right:[8640,g]}},10575:{dir:f,HW:[],stretch:{min:.5,top:[8638,i,.12,0,1.1],ext:[9168,e],bot:[8642,i,.12,0,1.1]}},10576:{dir:j,HW:[],stretch:{min:.5,left:[8637,g],rep:[8722,g],right:[8641,g]}},10577:{dir:f,HW:[],stretch:{min:.5,top:[8639,i,.12,0,1.1],ext:[9168,e],bot:[8643,i,.12,0,1.1]}},10586:{dir:j,HW:[],stretch:{min:1,left:[8636,g],rep:[8722,g],right:[8739,e,0,-.05,.9]}},10587:{dir:j,HW:[],stretch:{min:1,left:[8739,e,-.05,-.05,.9],rep:[8722,g],right:[8640,g]}},10588:{dir:f,HW:[],stretch:{min:.7,bot:[8869,h,0,0,.75],ext:[9168,e],top:[8638,i,.12,0,1.1]}},10589:{dir:f,HW:[],stretch:{min:.7,top:[8868,h,0,0,.75],ext:[9168,e],bot:[8642,i,.12,0,1.1]}},10590:{dir:j,HW:[],stretch:{min:1,left:[8637,g],rep:[8722,g],right:[8739,e,0,-.05,.9]}},10591:{dir:j,HW:[],stretch:{min:1,left:[8739,e,-.05,-.05,.9],rep:[8722,g],right:[8641,g]}},10592:{dir:f,HW:[],stretch:{min:.7,bot:[8869,h,0,0,.75],ext:[9168,e],top:[8639,i,.12,0,1.1]}},10593:{dir:f,HW:[],stretch:{min:.7,top:[8868,h,0,0,.75],ext:[9168,e],bot:[8643,i,.12,0,1.1]}}};for(var c in d){if(d.hasOwnProperty(c)){k[c]=d[c]}}MathJax.Ajax.loadComplete(a.fontDir+"/fontdata-extra.js")})(MathJax.OutputJax.SVG);MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var c="2.4.0";var a=MathJax.ElementJax.mml,d=MathJax.OutputJax.SVG,b=d.BBOX;a.mtable.Augment({toSVG:function(V){this.SVGgetStyles();var l=this.SVG(),al=this.SVGgetScale(l);if(this.data.length===0){this.SVGsaveData(l);return l}var aI=this.getValues("columnalign","rowalign","columnspacing","rowspacing","columnwidth","equalcolumns","equalrows","columnlines","rowlines","frame","framespacing","align","useHeight","width","side","minlabelspacing");if(aI.width.match(/%$/)){l.width=aI.width=Math.floor(d.cwidth*parseFloat(aI.width)/100)+"px"}var t=this.SVGgetMu(l);var aF=-1;var v=[],E=[],h=[],L=[],G=[],aD,aC,u=-1,aA,r,av,O,aj,z,aw;var Z=d.FONTDATA.lineH*al*aI.useHeight,ad=d.FONTDATA.lineD*al*aI.useHeight;for(aD=0,aA=this.data.length;aD<aA;aD++){O=this.data[aD];av=O.type==="mlabeledtr"?aF:0;L[aD]=[];v[aD]=Z;E[aD]=ad;for(aC=av,r=O.data.length+av;aC<r;aC++){if(h[aC]==null){if(aC>u){u=aC}G[aC]=b.G();h[aC]=-d.BIGDIMEN}aj=O.data[aC-av];L[aD][aC]=aj.toSVG();if(aj.isEmbellished()){z=aj.CoreMO();var aH=z.Get("minsize",true);if(aH){if(z.SVGcanStretch("Vertical")){aw=z.SVGdata.h+z.SVGdata.d;if(aw){aH=d.length2em(aH,t,aw);if(aH*z.SVGdata.h/aw>v[aD]){v[aD]=aH*z.SVGdata.h/aw}if(aH*z.SVGdata.d/aw>E[aD]){E[aD]=aH*z.SVGdata.d/aw}}}else{if(z.SVGcanStretch("Horizontal")){aH=d.length2em(aH,t,z.SVGdata.w);if(aH>h[aC]){h[aC]=aH}}}}}if(L[aD][aC].h>v[aD]){v[aD]=L[aD][aC].h}if(L[aD][aC].d>E[aD]){E[aD]=L[aD][aC].d}if(L[aD][aC].w>h[aC]){h[aC]=L[aD][aC].w}}}var ak=MathJax.Hub.SplitList;var ai=ak(aI.columnspacing),Q=ak(aI.rowspacing),af=ak(aI.columnalign),I=ak(aI.rowalign),K=ak(aI.columnlines),g=ak(aI.rowlines),an=ak(aI.columnwidth),ar=[];for(aD=0,aA=ai.length;aD<aA;aD++){ai[aD]=d.length2em(ai[aD],t)}for(aD=0,aA=Q.length;aD<aA;aD++){Q[aD]=d.length2em(Q[aD],t)}while(ai.length<u){ai.push(ai[ai.length-1])}while(af.length<=u){af.push(af[af.length-1])}while(K.length<u){K.push(K[K.length-1])}while(an.length<=u){an.push(an[an.length-1])}while(Q.length<L.length){Q.push(Q[Q.length-1])}while(I.length<=L.length){I.push(I[I.length-1])}while(g.length<L.length){g.push(g[g.length-1])}if(G[aF]){af[aF]=aI.side.substr(0,1)==="l"?"left":"right";ai[aF]=-h[aF]}for(aD=0,aA=L.length;aD<aA;aD++){O=this.data[aD];ar[aD]=[];if(O.rowalign){I[aD]=O.rowalign}if(O.columnalign){ar[aD]=ak(O.columnalign);while(ar[aD].length<=u){ar[aD].push(ar[aD][ar[aD].length-1])}}}if(aI.equalrows){var R=Math.max.apply(Math,v),am=Math.max.apply(Math,E);for(aD=0,aA=L.length;aD<aA;aD++){av=(R+am-(v[aD]+E[aD]))/2;v[aD]+=av;E[aD]+=av}}aw=v[0]+E[L.length-1];for(aD=0,aA=L.length-1;aD<aA;aD++){aw+=Math.max(0,E[aD]+v[aD+1]+Q[aD])}var ab=0,X=0,ax,aG=aw;if(aI.frame!=="none"||(aI.columnlines+aI.rowlines).match(/solid|dashed/)){var q=ak(aI.framespacing);if(q.length!=2){q=ak(this.defaults.framespacing)}ab=d.length2em(q[0],t);X=d.length2em(q[1],t);aG=aw+2*X}var e,au,az="";if(typeof aI.align!=="string"){aI.align=String(aI.align)}if(aI.align.match(/(top|bottom|center|baseline|axis)( +(-?\d+))?/)){az=RegExp.$3;aI.align=RegExp.$1}else{aI.align=this.defaults.align}if(az!==""){az=parseInt(az);if(az<0){az=L.length+1+az}if(az<1){az=1}else{if(az>L.length){az=L.length}}e=0;au=-(aw+X)+v[0];for(aD=0,aA=az-1;aD<aA;aD++){var U=Math.max(0,E[aD]+v[aD+1]+Q[aD]);e+=U;au+=U}}else{e={top:-(v[0]+X),bottom:aw+X-v[0],center:aw/2-v[0],baseline:aw/2-v[0],axis:aw/2+d.TeX.axis_height*al-v[0]}[aI.align];au={top:-(aw+2*X),bottom:0,center:-(aw/2+X),baseline:-(aw/2+X),axis:d.TeX.axis_height*al-aw/2-X}[aI.align]}var ao,at=0,S=0,T=0,ay=0,aE=0,o=[],w=[],ag=1;if(aI.equalcolumns&&aI.width!=="auto"){ao=d.length2em(aI.width,t);for(aD=0,aA=Math.min(u+1,ai.length);aD<aA;aD++){ao-=ai[aD]}ao/=u+1;for(aD=0,aA=Math.min(u+1,an.length);aD<aA;aD++){h[aD]=ao}}else{for(aD=0,aA=Math.min(u+1,an.length);aD<aA;aD++){if(an[aD]==="auto"){S+=h[aD]}else{if(an[aD]==="fit"){w[aE]=aD;aE++;S+=h[aD]}else{if(an[aD].match(/%$/)){o[ay]=aD;ay++;T+=h[aD];at+=d.length2em(an[aD],t,1)}else{h[aD]=d.length2em(an[aD],t);S+=h[aD]}}}}if(aI.width==="auto"){if(at>.98){ag=T/(S+T);ao=S+T}else{ao=S/(1-at)}}else{ao=d.length2em(aI.width,t);for(aD=0,aA=Math.min(u+1,ai.length);aD<aA;aD++){ao-=ai[aD]}}for(aD=0,aA=o.length;aD<aA;aD++){h[o[aD]]=d.length2em(an[o[aD]],t,ao*ag);S+=h[o[aD]]}if(Math.abs(ao-S)>.01){if(aE&&ao>S){ao=(ao-S)/aE;for(aD=0,aA=w.length;aD<aA;aD++){h[w[aD]]+=ao}}else{ao=ao/S;for(aC=0;aC<=u;aC++){h[aC]*=ao}}}if(aI.equalcolumns){var ac=Math.max.apply(Math,h);for(aC=0;aC<=u;aC++){h[aC]=ac}}}var ap=e,k,aB;av=G[aF]?aF:0;for(aC=av;aC<=u;aC++){G[aC].w=h[aC];for(aD=0,aA=L.length;aD<aA;aD++){if(L[aD][aC]){av=this.data[aD].type==="mlabeledtr"?aF:0;aj=this.data[aD].data[aC-av];if(aj.SVGcanStretch("Horizontal")){L[aD][aC]=aj.SVGstretchH(h[aC])}else{if(aj.SVGcanStretch("Vertical")){z=aj.CoreMO();var aa=z.symmetric;z.symmetric=false;L[aD][aC]=aj.SVGstretchV(v[aD],E[aD]);z.symmetric=aa}}aB=aj.rowalign||this.data[aD].rowalign||I[aD];k={top:v[aD]-L[aD][aC].h,bottom:L[aD][aC].d-E[aD],center:(v[aD]-E[aD]-(L[aD][aC].h-L[aD][aC].d))/2,baseline:0,axis:0}[aB]||0;aB=aj.columnalign||ar[aD][aC]||af[aC];G[aC].Align(L[aD][aC],aB,0,ap+k)}if(aD<L.length-1){ap-=Math.max(0,E[aD]+v[aD+1]+Q[aD])}}ap=e}var ae=1.5*d.em;var aq=ab-ae/2;for(aC=0;aC<=u;aC++){l.Add(G[aC],aq,0);aq+=h[aC]+ai[aC];if(K[aC]!=="none"&&aC<u&&aC!==aF){l.Add(b.VLINE(aG,ae,K[aC]),aq-ai[aC]/2,au)}}l.w+=ab;l.d=-au;l.h=aG+au;ax=l.w;if(aI.frame!=="none"){l.Add(b.HLINE(ax,ae,aI.frame),0,au+aG-ae);l.Add(b.HLINE(ax,ae,aI.frame),0,au);l.Add(b.VLINE(aG,ae,aI.frame),0,au);l.Add(b.VLINE(aG,ae,aI.frame),ax-ae,au)}ap=e-ae/2;for(aD=0,aA=L.length-1;aD<aA;aD++){k=Math.max(0,E[aD]+v[aD+1]+Q[aD]);if(g[aD]!=="none"){l.Add(b.HLINE(ax,ae,g[aD]),0,ap-E[aD]-(k-E[aD]-v[aD+1])/2)}ap-=k}l.Clean();this.SVGhandleSpace(l);this.SVGhandleColor(l);if(G[aF]){var N=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(N.indentalignfirst!==a.INDENTALIGN.INDENTALIGN){N.indentalign=N.indentalignfirst}if(N.indentalign===a.INDENTALIGN.AUTO){N.indentalign=this.displayAlign}if(N.indentshiftfirst!==a.INDENTSHIFT.INDENTSHIFT){N.indentshift=N.indentshiftfirst}if(N.indentshift==="auto"){N.indentshift=this.displayIndent}var ah=N.indentshift?d.length2em(N.indentshift,t):0;var aJ=d.length2em(aI.minlabelspacing,t);var B=l;l=this.SVG();if(N.indentalign===a.INDENTALIGN.CENTER){l.w=l.r=d.length2em(d.cwidth+"px");ah=0;l.hasIndent=true}else{if(af[aF]!==N.indentalign){l.w=l.r=d.length2em(d.cwidth+"px")-ah-aJ;ah=aJ=0}else{l.w=l.r=B.w+ah;l.hasIndent=true}}l.Align(B,N.indentalign,ah,0);l.Align(G[aF],af[aF],aJ,0)}this.SVGsaveData(l);return l},SVGhandleSpace:function(e){if(!this.hasFrame&&!e.width){e.x=e.X=167}this.SUPER(arguments).SVGhandleSpace.call(this,e)}});a.mtd.Augment({toSVG:function(e,g){var f=this.svg=this.SVG();if(this.data[0]){f.Add(this.SVGdataStretched(0,e,g));f.Clean()}this.SVGhandleColor(f);this.SVGsaveData(f);return f}});MathJax.Hub.Startup.signal.Post("SVG mtable Ready");MathJax.Ajax.loadComplete(d.autoloadDir+"/mtable.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var d="2.4.0";var a=MathJax.ElementJax.mml,f=MathJax.OutputJax.SVG,b=f.BBOX,e=MathJax.Localization;var c="http://www.w3.org/1999/xlink";b.MGLYPH=b.Subclass({type:"image",removeable:false,Init:function(j,o,k,l,r,g){if(g==null){g={}}var i=j.width*1e3/f.em,p=j.height*1e3/f.em;var q=i,n=p,m=0;if(o!==""){i=f.length2em(o,r,q);p=q?i/q*n:0}if(k!==""){p=f.length2em(k,r,n);if(o===""){i=n?p/n*q:0}}if(l!==""&&l.match(/\d/)){m=f.length2em(l,r);g.y=-m}g.height=Math.floor(p);g.width=Math.floor(i);g.transform="translate(0,"+p+") matrix(1 0 0 -1 0 0)";g.preserveAspectRatio="none";this.SUPER(arguments).Init.call(this,g);this.element.setAttributeNS(c,"href",j.src);this.w=this.r=i;this.h=this.H=p+m;this.d=this.D=-m;this.l=0}});a.mglyph.Augment({toSVG:function(k,n){this.SVGgetStyles();var j=this.SVG(),i,l;this.SVGhandleSpace(j);var h=this.getValues("src","width","height","valign","alt");if(h.src===""){h=this.getValues("index","fontfamily");if(h.index){if(!n){n=this.SVGgetScale()}var m={};if(h.fontfamily){m["font-family"]=h.fontfamily}j.Add(b.TEXT(n,String.fromCharCode(h.index),m))}}else{if(!this.img){this.img=a.mglyph.GLYPH[h.src]}if(!this.img){this.img=a.mglyph.GLYPH[h.src]={img:new Image,status:"pending"};i=this.img.img;i.onload=MathJax.Callback(["SVGimgLoaded",this]);i.onerror=MathJax.Callback(["SVGimgError",this]);i.src=h.src;MathJax.Hub.RestartAfter(i.onload)}if(this.img.status!=="OK"){l=a.Error(e._(["MathML","BadMglyph"],"Bad mglyph: %1",h.src),{mathsize:"75%"});this.Append(l);j=l.toSVG();this.data.pop()}else{var g=this.SVGgetMu(j);j.Add(b.MGLYPH(this.img.img,h.width,h.height,h.valign,g,{src:h.src,alt:h.alt,title:h.alt}))}}j.Clean();this.SVGhandleColor(j);this.SVGsaveData(j);return j},SVGimgLoaded:function(h,g){if(typeof h==="string"){g=h}this.img.status=g||"OK"},SVGimgError:function(){this.img.img.onload("error")}},{GLYPH:{}});MathJax.Hub.Startup.signal.Post("SVG mglyph Ready");MathJax.Ajax.loadComplete(f.autoloadDir+"/mglyph.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var b="2.4.0";var a=MathJax.ElementJax.mml,c=MathJax.OutputJax.SVG;a.mmultiscripts.Augment({toSVG:function(G,z){this.SVGgetStyles();var B=this.SVG(),N=this.SVGgetScale(B);this.SVGhandleSpace(B);var j=this.data[this.base]?this.SVGdataStretched(this.base,G,z):c.BBOX.G().Clean();var K=c.TeX.x_height*N,y=c.TeX.scriptspace*N*.75;var x=this.SVGgetScripts(y);var k=x[0],e=x[1],n=x[2],i=x[3];var g=(this.data[1]||this).SVGgetScale();var C=c.TeX.sup_drop*g,A=c.TeX.sub_drop*g;var o=j.h-C,m=j.d+A,L=0,F;if(j.ic){L=j.ic}if(this.data[this.base]&&(this.data[this.base].type==="mi"||this.data[this.base].type==="mo")){if(this.data[this.base].data.join("").length===1&&j.scale===1&&!j.stretched&&!this.data[this.base].Get("largeop")){o=m=0}}var H=this.getValues("subscriptshift","superscriptshift"),E=this.SVGgetMu(B);H.subscriptshift=H.subscriptshift===""?0:c.length2em(H.subscriptshift,E);H.superscriptshift=H.superscriptshift===""?0:c.length2em(H.superscriptshift,E);var l=0;if(n){l=n.w+L}else{if(i){l=i.w-L}}B.Add(j,Math.max(0,l),0);if(!e&&!i){m=Math.max(m,c.TeX.sub1*N,H.subscriptshift);if(k){m=Math.max(m,k.h-4/5*K)}if(n){m=Math.max(m,n.h-4/5*K)}if(k){B.Add(k,l+j.w+y-L,-m)}if(n){B.Add(n,0,-m)}}else{if(!k&&!n){var f=this.getValues("displaystyle","texprimestyle");F=c.TeX[f.displaystyle?"sup1":f.texprimestyle?"sup3":"sup2"];o=Math.max(o,F*N,H.superscriptshift);if(e){o=Math.max(o,e.d+1/4*K)}if(i){o=Math.max(o,i.d+1/4*K)}if(e){B.Add(e,l+j.w+y,o)}if(i){B.Add(i,0,o)}}else{m=Math.max(m,c.TeX.sub2*N);var w=c.TeX.rule_thickness*N;var I=(k||n).h,J=(e||i).d;if(n){I=Math.max(I,n.h)}if(i){J=Math.max(J,i.d)}if(o-J-(I-m)<3*w){m=3*w-o+J+I;C=4/5*K-(o-J);if(C>0){o+=C;m-=C}}o=Math.max(o,H.superscriptshift);m=Math.max(m,H.subscriptshift);if(e){B.Add(e,l+j.w+y,o)}if(i){B.Add(i,l+L-i.w,o)}if(k){B.Add(k,l+j.w+y-L,-m)}if(n){B.Add(n,l-n.w,-m)}}}B.Clean();this.SVGhandleColor(B);this.SVGsaveData(B);var M=this.SVGdata;M.dx=l;M.s=y;M.u=o,M.v=m;M.delta=L;return B},SVGgetScripts:function(p){var o,d,e=[];var n=1,g=this.data.length,f=0;for(var h=0;h<4;h+=2){while(n<g&&this.data[n].type!=="mprescripts"){for(var l=h;l<h+2;l++){if(this.data[n]&&this.data[n].type!=="none"){if(!e[l]){e[l]=c.BBOX.G()}e[l].Add(this.data[n].toSVG().With({x:f}))}n++}d=e[h]||{w:0};o=e[h+1]||{w:0};d.w=o.w=f=Math.max(d.w,o.w)}n++;f=0}for(l=0;l<4;l++){if(e[l]){e[l].w+=p;e[l].Clean()}}return e}});MathJax.Hub.Startup.signal.Post("SVG mmultiscripts Ready");MathJax.Ajax.loadComplete(c.autoloadDir+"/mmultiscripts.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var c="2.4.0";var a=MathJax.ElementJax.mml,d=MathJax.OutputJax.SVG;var b=d.BBOX;b.FOREIGN=b.Subclass({type:"foreignObject",removeable:false});a["annotation-xml"].Augment({toSVG:function(){var f=this.SVG();this.SVGhandleSpace(f);var h=this.Get("encoding");for(var g=0,e=this.data.length;g<e;g++){f.Add(this.data[g].toSVG(h),f.w,0)}f.Clean();this.SVGhandleColor(f);this.SVGsaveData(f);return f}});a.xml.Augment({toSVG:function(e){var p=d.textSVG.parentNode;d.mathDiv.style.width="auto";p.insertBefore(this.div,d.textSVG);var q=this.div.offsetWidth,k=this.div.offsetHeight;var o=MathJax.HTML.addElement(this.div,"span",{style:{display:"inline-block",overflow:"hidden",height:k+"px",width:"1px",marginRight:"-1px"}});var n=this.div.offsetHeight-k;k-=n;this.div.removeChild(o);p.removeChild(this.div);d.mathDiv.style.width="";var g=1e3/d.em;var l=b.FOREIGN({y:-k+"px",width:q+"px",height:k+n+"px",transform:"scale("+g+") matrix(1 0 0 -1 0 0)"});for(var j=0,f=this.data.length;j<f;j++){l.element.appendChild(this.data[j].cloneNode(true))}l.w=q*g;l.h=k*g;l.d=n*g;l.r=l.w;l.l=0;l.Clean();this.SVGsaveData(l);return l}});MathJax.Hub.Startup.signal.Post("SVG annotation-xml Ready");MathJax.Ajax.loadComplete(d.autoloadDir+"/annotation-xml.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var f="2.4.0";var c=MathJax.ElementJax.mml,g=MathJax.OutputJax.SVG;var d,e,b;var a=g.config.tooltip=MathJax.Hub.Insert({delayPost:600,delayClear:600,offsetX:10,offsetY:5},g.config.tooltip||{});c.maction.Augment({SVGtooltip:MathJax.HTML.addElement(document.body,"div",{id:"MathJax_SVG_Tooltip"}),toSVG:function(h,k){this.SVGgetStyles();var i=this.SVG();var j=this.selected();if(j.type=="null"){this.SVGsaveData(i);return i}i.Add(this.SVGdataStretched(this.Get("selection")-1,h,k));this.SVGhandleHitBox(i);this.SVGhandleSpace(i);this.SVGhandleColor(i);this.SVGsaveData(i);return i},SVGhandleHitBox:function(h){var j=g.addElement(h.element,"rect",{width:h.w,height:h.h+h.d,y:-h.d,fill:"none","pointer-events":"all"});var i=this.Get("actiontype");if(this.SVGaction[i]){this.SVGaction[i].call(this,h,j,this.Get("selection"))}},SVGstretchH:c.mbase.prototype.SVGstretchH,SVGstretchV:c.mbase.prototype.SVGstretchV,SVGaction:{toggle:function(h,j,i){this.selection=i;g.Element(j,{cursor:"pointer"});j.onclick=MathJax.Callback(["SVGclick",this])},statusline:function(h,j,i){j.onmouseover=MathJax.Callback(["SVGsetStatus",this]),j.onmouseout=MathJax.Callback(["SVGclearStatus",this]);j.onmouseover.autoReset=j.onmouseout.autoReset=true},tooltip:function(h,j,i){j.onmouseover=MathJax.Callback(["SVGtooltipOver",this]),j.onmouseout=MathJax.Callback(["SVGtooltipOut",this]);j.onmouseover.autoReset=j.onmouseout.autoReset=true}},SVGclick:function(j){this.selection++;if(this.selection>this.data.length){this.selection=1}var i=this;while(i.type!=="math"){i=i.inherit}var h=MathJax.Hub.getJaxFor(i.inputID);h.Update();return MathJax.Extension.MathEvents.Event.False(j)},SVGsetStatus:function(h){this.messageID=MathJax.Message.Set(this.data[1]&&this.data[1].isToken?this.data[1].data.join(""):this.data[1].toString())},SVGclearStatus:function(h){if(this.messageID){MathJax.Message.Clear(this.messageID,0)}delete this.messageID},SVGtooltipOver:function(i){if(!i){i=window.event}if(b){clearTimeout(b);b=null}if(e){clearTimeout(e)}var h=i.pageX;var k=i.pageY;if(h==null){h=i.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;k=i.clientY+document.body.scrollTop+document.documentElement.scrollTop}var j=MathJax.Callback(["SVGtooltipPost",this,h+a.offsetX,k+a.offsetY]);e=setTimeout(j,a.delayPost)},SVGtooltipOut:function(h){if(e){clearTimeout(e);e=null}if(b){clearTimeout(b)}var i=MathJax.Callback(["SVGtooltipClear",this,80]);b=setTimeout(i,a.delayClear)},SVGtooltipPost:function(h,o){e=null;if(b){clearTimeout(b);b=null}var n=this.SVGtooltip;n.style.display="block";n.style.opacity="";if(this===d){return}n.style.left=h+"px";n.style.top=o+"px";n.innerHTML="";var k=MathJax.HTML.addElement(n,"span");var m=this;while(m.type!=="math"){m=m.inherit}var i=MathJax.Hub.getJaxFor(m.inputID);this.em=c.mbase.prototype.em=i.SVG.em;this.ex=i.SVG.ex;this.linebreakWidth=i.SVG.lineWidth*1e3;this.cwidth=i.SVG.cwidth;var j=this.data[1];m=c.math(j);try{m.toSVG(k,n)}catch(l){this.SetData(1,j);n.style.display="none";if(!l.restart){throw l}MathJax.Callback.After(["SVGtooltipPost",this,h,o],l.restart);return}this.SetData(1,j);d=this},SVGtooltipClear:function(i){var h=this.SVGtooltip;if(i<=0){h.style.display="none";h.style.opacity="";b=null}else{h.style.opacity=i/100;b=setTimeout(MathJax.Callback(["SVGtooltipClear",this,i-20]),50)}}});MathJax.Hub.Startup.signal.Post("SVG maction Ready");MathJax.Ajax.loadComplete(g.autoloadDir+"/maction.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var d="2.4.0";var a=MathJax.ElementJax.mml,f=MathJax.OutputJax.SVG,b=f.BBOX;var e={newline:0,nobreak:1e6,goodbreak:[-200],badbreak:[+200],auto:[0],toobig:800,nestfactor:400,spacefactor:-100,spaceoffset:2,spacelimit:1,fence:500,close:500};var c={linebreakstyle:"after"};a.mrow.Augment({SVGmultiline:function(k){var o=this;while(o.inferred||o.parent&&o.parent.type==="mrow"&&o.parent.data.length===1){o=o.parent}var n=o.type==="math"&&o.Get("display")==="block"||o.type==="mtd";o.isMultiline=true;var p=this.getValues("linebreak","linebreakstyle","lineleading","linebreakmultchar","indentalign","indentshift","indentalignfirst","indentshiftfirst","indentalignlast","indentshiftlast");if(p.linebreakstyle===a.LINEBREAKSTYLE.INFIXLINEBREAKSTYLE){p.linebreakstyle=this.Get("infixlinebreakstyle")}p.lineleading=f.length2em(p.lineleading,1,.5);k=this.SVG();if(n&&o.type!=="mtd"){if(f.linebreakWidth<f.BIGDIMEN){k.w=f.linebreakWidth}else{k.w=f.cwidth/f.em*1e3}}var g={n:0,Y:0,scale:this.scale||1,isTop:n,values:{},VALUES:p},m=this.SVGgetAlign(g,{}),i=this.SVGgetShift(g,{},m),h=[],j={index:[],penalty:e.nobreak,w:0,W:i,shift:i,scanW:i,nest:0},l=false;while(this.SVGbetterBreak(j,g)&&(j.scanW>=f.linebreakWidth||j.penalty===e.newline)){this.SVGaddLine(k,h,j.index,g,j.values,l);h=j.index.slice(0);l=true;m=this.SVGgetAlign(g,j.values);i=this.SVGgetShift(g,j.values,m);if(m===a.INDENTALIGN.CENTER){i=0}j.W=j.shift=j.scanW=i;j.penalty=e.nobreak}g.isLast=true;this.SVGaddLine(k,h,[],g,c,l);this.SVGhandleSpace(k);this.SVGhandleColor(k);k.isMultiline=true;this.SVGsaveData(k);return k}});a.mbase.Augment({SVGlinebreakPenalty:e,SVGbetterBreak:function(j,g){if(this.isToken){return false}if(this.isEmbellished()){j.embellished=this;return this.CoreMO().SVGbetterBreak(j,g)}if(this.linebreakContainer){return false}var q=j.index.slice(0),o=j.index.shift(),n=this.data.length,l,r,k,p=j.index.length>0,h=false;if(o==null){o=-1}if(!p){o++;j.W+=j.w;j.w=0}k=j.scanW=j.W;j.nest++;while(o<n&&j.scanW<1.33*f.linebreakWidth){if(this.data[o]){if(this.data[o].SVGbetterBreak(j,g)){h=true;q=[o].concat(j.index);l=j.W;r=j.w;if(j.penalty===e.newline){j.index=q;if(j.nest){j.nest--}return true}}k=p?j.scanW:this.SVGaddWidth(o,j,k)}j.index=[];o++;p=false}if(j.nest){j.nest--}j.index=q;if(h){j.W=l}return h},SVGaddWidth:function(h,k,j){if(this.data[h]){var g=this.data[h].SVGdata;j+=g.w+g.x;if(g.X){j+=g.X}k.W=k.scanW=j;k.w=0}return j},SVGaddLine:function(l,h,k,g,p,n){var q=b();g.first=n;g.last=true;this.SVGmoveLine(h,k,q,g,p);q.Clean();var o=this.SVGgetAlign(g,p),i=this.SVGgetShift(g,p,o);if(i){if(o===a.INDENTALIGN.LEFT){q.x=i}else{if(o===a.INDENTALIGN.RIGHT){q.w+=i;q.r=q.w}}}if(g.n>0){var m=f.FONTDATA.baselineskip*g.scale;var j=(g.values.lineleading==null?g.VALUES:g.values).lineleading*g.scale;g.Y-=Math.max(m,g.d+q.h+j)}l.Align(q,o,0,g.Y);g.d=q.d;g.values=p;g.n++},SVGgetAlign:function(j,g){var k=g,h=j.values,i=j.VALUES,l;if(j.n===0){l=k.indentalignfirst||h.indentalignfirst||i.indentalignfirst}else{if(j.isLast){l=h.indentalignlast||i.indentalignlast}else{l=h.indentalign||i.indentalign}}if(l===a.INDENTALIGN.INDENTALIGN){l=h.indentalign||i.indentalign}if(l===a.INDENTALIGN.AUTO){l=j.isTop?this.displayAlign:a.INDENTALIGN.LEFT}return l},SVGgetShift:function(k,h,m){if(m===a.INDENTALIGN.CENTER){return 0}var l=h,i=k.values,j=k.VALUES,g;if(k.n===0){g=l.indentshiftfirst||i.indentshiftfirst||j.indentshiftfirst}else{if(k.isLast){g=i.indentshiftlast||j.indentshiftlast}else{g=i.indentshift||j.indentshift}}if(g===a.INDENTSHIFT.INDENTSHIFT){g=i.indentshift||j.indentshift}if(g==="auto"||g===""){g=k.isTSop?this.displayIndent:"0"}return f.length2em(g,0)},SVGmoveLine:function(p,g,k,o,h){var m=p[0],l=g[0];if(m==null){m=-1}if(l==null){l=this.data.length-1}if(m===l&&p.length>1){this.data[m].SVGmoveSlice(p.slice(1),g.slice(1),k,o,h,"paddingLeft")}else{var n=o.last;o.last=false;while(m<l){if(this.data[m]){if(p.length<=1){this.data[m].SVGmove(k,o,h)}else{this.data[m].SVGmoveSlice(p.slice(1),[],k,o,h,"paddingLeft")}}m++;o.first=false;p=[]}o.last=n;if(this.data[m]){if(g.length<=1){this.data[m].SVGmove(k,o,h)}else{this.data[m].SVGmoveSlice([],g.slice(1),k,o,h,"paddingRight")}}}},SVGmoveSlice:function(m,g,i,j,h,k){var l=b();this.SVGmoveLine(m,g,l,j,h);l.Clean();this.SVGhandleColor(l);i.Add(l,i.w,0,true);return l},SVGmove:function(g,j,i){if(!(j.first||j.last)||j.first&&j.values.linebreakstyle===a.LINEBREAKSTYLE.BEFORE||j.last&&i.linebreakstyle===a.LINEBREAKSTYLE.AFTER){var h=this.toSVG(this.SVGdata.HW,this.SVGdata.D);if(j.first||j.nextIsFirst){h.x=0}if(j.last&&h.X){h.X=0}g.Add(h,g.w,0,true)}if(j.first&&h&&h.w===0){j.nextIsFirst=true}else{delete j.nextIsFirst}}});a.mfenced.Augment({SVGbetterBreak:function(l,g){var u=l.index.slice(0),s=l.index.shift(),p=this.data.length,o,v,n,t=l.index.length>0,h=false;if(s==null){s=-1}if(!t){s++;l.W+=l.w;l.w=0}n=l.scanW=l.W;l.nest++;if(!this.dataI){this.dataI=[];if(this.data.open){this.dataI.push("open")}if(p){this.dataI.push(0)}for(var r=1;r<p;r++){if(this.data["sep"+r]){this.dataI.push("sep"+r)}this.dataI.push(r)}if(this.data.close){this.dataI.push("close")}}p=this.dataI.length;while(s<p&&l.scanW<1.33*f.linebreakWidth){var q=this.dataI[s];if(this.data[q]){if(this.data[q].SVGbetterBreak(l,g)){h=true;u=[s].concat(l.index);o=l.W;v=l.w;if(l.penalty===e.newline){l.index=u;if(l.nest){l.nest--}return true}}n=t?l.scanW:this.SVGaddWidth(s,l,n)}l.index=[];s++;t=false}if(l.nest){l.nest--}l.index=u;if(h){l.W=o;l.w=v}return h},SVGmoveLine:function(h,m,p,g,r){var o=h[0],n=m[0];if(o==null){o=-1}if(n==null){n=this.dataI.length-1}if(o===n&&h.length>1){this.data[this.dataI[o]].SVGmoveSlice(h.slice(1),m.slice(1),p,g,r,"paddingLeft")}else{var q=g.last;g.last=false;var l=this.dataI[o];while(o<n){if(this.data[l]){if(h.length<=1){this.data[l].SVGmove(p,g,r)}else{this.data[l].SVGmoveSlice(h.slice(1),[],p,g,r,"paddingLeft")}}o++;l=this.dataI[o];g.first=false;h=[]}g.last=q;if(this.data[l]){if(m.length<=1){this.data[l].SVGmove(p,g,r)}else{this.data[l].SVGmoveSlice([],m.slice(1),p,g,r,"paddingRight")}}}}});a.msubsup.Augment({SVGbetterBreak:function(j,g){if(!this.data[this.base]){return false}var o=j.index.slice(0),m=j.index.shift(),l,p,k,n=j.index.length>0,h=false;if(!n){j.W+=j.w;j.w=0}k=j.scanW=j.W;if(m==null){this.SVGdata.dw=this.SVGdata.w-this.data[this.base].SVGdata.w}if(this.data[this.base].SVGbetterBreak(j,g)){h=true;o=[this.base].concat(j.index);l=j.W;p=j.w;if(j.penalty===e.newline){h=n=true}}if(!n){this.SVGaddWidth(this.base,j,k)}j.scanW+=this.SVGdata.dw;j.W=j.scanW;j.index=[];if(h){j.W=l;j.w=p;j.index=o}return h},SVGmoveLine:function(i,j,m,h,o){if(this.data[this.base]){if(i.length>1){this.data[this.base].SVGmoveSlice(i.slice(1),j.slice(1),m,h,o,"paddingLeft")}else{if(j.length<=1){this.data[this.base].SVGmove(m,h,o)}else{this.data[this.base].SVGmoveSlice([],j.slice(1),m,h,o,"paddingRight")}}}if(j.length===0){var l=this.data[this.sup],g=this.data[this.sub],n=m.w,k;if(l){k=l.SVGdata;m.Add(l.toSVG(),n+(k.dx||0),k.dy)}if(g){k=g.SVGdata;m.Add(g.toSVG(),n+(k.dx||0),k.dy)}}}});a.mmultiscripts.Augment({SVGbetterBreak:function(k,h){if(!this.data[this.base]){return false}var p=k.index.slice(0),n=k.index.shift(),m,q,l,o=k.index.length>0,j=false;if(!o){k.W+=k.w;k.w=0}k.scanW=k.W;var g=this.SVGdata.w-this.data[this.base].SVGdata.w-this.SVGdata.dx;k.scanW+=this.SVGdata.dx;l=k.scanW;if(this.data[this.base].SVGbetterBreak(k,h)){j=true;p=[this.base].concat(k.index);m=k.W;q=k.w;if(k.penalty===e.newline){j=o=true}}if(!o){this.SVGaddWidth(this.base,k,l)}k.scanW+=g;k.W=k.scanW;k.index=[];if(j){k.W=m;k.w=q;k.index=p}return j},SVGmoveLine:function(i,k,n,h,p){var q,m=this.SVGdata;if(i.length<1){this.scriptBox=this.SVGgetScripts(this.SVGdata.s);var j=this.scriptBox[2],o=this.scriptBox[3];q=n.w+m.dx;if(o){n.Add(o,q+m.delta-o.w,m.u)}if(j){n.Add(j,q-j.w,-m.v)}}if(this.data[this.base]){if(i.length>1){this.data[this.base].SVGmoveSlice(i.slice(1),k.slice(1),n,h,p,"paddingLeft")}else{if(k.length<=1){this.data[this.base].SVGmove(n,h,p)}else{this.data[this.base].SVGmoveSlice([],k.slice(1),n,h,p,"paddingRight")}}}if(k.length===0){var g=this.scriptBox[0],l=this.scriptBox[1];q=n.w+m.s;if(l){n.Add(l,q,m.u)}if(g){n.Add(g,q-m.delta,-m.v)}delete this.scriptBox}}});a.mo.Augment({SVGbetterBreak:function(i,g){if(i.values&&i.values.last===this){return false}var q=this.getValues("linebreak","linebreakstyle","lineleading","linebreakmultchar","indentalign","indentshift","indentalignfirst","indentshiftfirst","indentalignlast","indentshiftlast","texClass","fence");if(q.linebreakstyle===a.LINEBREAKSTYLE.INFIXLINEBREAKSTYLE){q.linebreakstyle=this.Get("infixlinebreakstyle")}if(q.texClass===a.TEXCLASS.OPEN){i.nest++}if(q.texClass===a.TEXCLASS.CLOSE&&i.nest){i.nest--}var j=i.scanW,k=i.embellished;delete i.embellished;if(!k||!k.SVGdata){k=this}var m=k.SVGdata,p=m.w+m.x;if(q.linebreakstyle===a.LINEBREAKSTYLE.AFTER){j+=p;p=0}if(j-i.shift===0&&q.linebreak!==a.LINEBREAK.NEWLINE){return false}var l=f.linebreakWidth-j;if(g.n===0&&(q.indentshiftfirst!==g.VALUES.indentshiftfirst||q.indentalignfirst!==g.VALUES.indentalignfirst)){var n=this.SVGgetAlign(g,q),h=this.SVGgetShift(g,q,n);l+=i.shift-h}var o=Math.floor(l/f.linebreakWidth*1e3);if(o<0){o=e.toobig-3*o}if(q.fence){o+=e.fence}if(q.linebreakstyle===a.LINEBREAKSTYLE.AFTER&&q.texClass===a.TEXCLASS.OPEN||q.texClass===a.TEXCLASS.CLOSE){o+=e.close}o+=i.nest*e.nestfactor;var r=e[q.linebreak||a.LINEBREAK.AUTO];if(!(r instanceof Array)){if(l>=0){o=r*i.nest}}else{o=Math.max(1,o+r[0]*i.nest)}if(o>=i.penalty){return false}i.penalty=o;i.values=q;i.W=j;i.w=p;q.lineleading=f.length2em(q.lineleading,g.VALUES.lineleading);q.last=this;return true}});a.mspace.Augment({SVGbetterBreak:function(h,g){if(h.values&&h.values.last===this){return false}var o=this.getValues("linebreak");var m=o.linebreak;if(!m||this.hasDimAttr()){m=a.LINEBREAK.AUTO}var i=h.scanW,k=this.SVGdata,n=k.w+k.x;if(i-h.shift===0){return false}var j=f.linebreakWidth-i;var l=Math.floor(j/f.linebreakWidth*1e3);if(l<0){l=e.toobig-3*l}l+=h.nest*e.nestfactor;var p=e[m];if(m===a.LINEBREAK.AUTO&&n>=e.spacelimit*1e3&&!this.mathbackground&&!this.backrgound){p=[(n/1e3+e.spaceoffset)*e.spacefactor]}if(!(p instanceof Array)){if(j>=0){l=p*h.nest}}else{l=Math.max(1,l+p[0]*h.nest)}if(l>=h.penalty){return false}h.penalty=l;h.values=o;h.W=i;h.w=n;o.lineleading=g.VALUES.lineleading;o.linebreakstyle="before";o.last=this;return true}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({SVGbetterBreak:function(h,g){return this.Core().SVGbetterBreak(h,g)},SVGmoveLine:function(k,g,i,j,h){return this.Core().SVGmoveSlice(k,g,i,j,h)}})});a.maction.Augment({SVGbetterBreak:function(h,g){return this.Core().SVGbetterBreak(h,g)},SVGmoveLine:function(k,g,i,j,h){return this.Core().SVGmoveSlice(k,g,i,j,h)}});a.semantics.Augment({SVGbetterBreak:function(h,g){return this.data[0]?this.data[0].SVGbetterBreak(h,g):false},SVGmoveLine:function(k,g,i,j,h){return this.data[0]?this.data[0].SVGmoveSlice(k,g,i,j,h):null}});MathJax.Hub.Startup.signal.Post("SVG multiline Ready");MathJax.Ajax.loadComplete(f.autoloadDir+"/multiline.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var c="2.4.0";var a=MathJax.ElementJax.mml,d=MathJax.OutputJax.SVG,b=d.BBOX;
b.ELLIPSE=b.Subclass({type:"ellipse",removeable:false,Init:function(i,k,e,g,f,j){if(j==null){j={}}j.fill="none";if(f){j.stroke=f}j["stroke-width"]=g.toFixed(2).replace(/\.?0+$/,"");j.cx=Math.floor(e/2);j.cy=Math.floor((i+k)/2-k);j.rx=Math.floor((e-g)/2);j.ry=Math.floor((i+k-g)/2);this.SUPER(arguments).Init.call(this,j);this.w=this.r=e;this.h=this.H=i;this.d=this.D=k;this.l=0}});b.DLINE=b.Subclass({type:"line",removeable:false,Init:function(i,l,e,g,f,j,k){if(k==null){k={}}k.fill="none";if(f){k.stroke=f}k["stroke-width"]=g.toFixed(2).replace(/\.?0+$/,"");if(j=="up"){k.x1=Math.floor(g/2);k.y1=Math.floor(g/2-l);k.x2=Math.floor(e-g/2);k.y2=Math.floor(i-g/2)}else{k.x1=Math.floor(g/2);k.y1=Math.floor(i-g/2);k.x2=Math.floor(e-g/2);k.y2=Math.floor(g/2-l)}this.SUPER(arguments).Init.call(this,k);this.w=this.r=e;this.h=this.H=i;this.d=this.D=l;this.l=0}});b.FPOLY=b.Subclass({type:"polygon",removeable:false,Init:function(p,g,e){if(e==null){e={}}if(g){e.fill=g}var j=[],o=1e8,n=o,r=-o,q=r;for(var h=0,f=p.length;h<f;h++){var l=p[h][0],k=p[h][1];if(l>r){r=l}if(l<o){o=l}if(k>q){q=k}if(k<n){n=k}j.push(Math.floor(l)+","+Math.floor(k))}e.points=j.join(" ");this.SUPER(arguments).Init.call(this,e);this.w=this.r=r;this.h=this.H=q;this.d=this.D=-n;this.l=-o}});b.PPATH=b.Subclass({type:"path",removeable:false,Init:function(i,l,e,k,g,f,j){if(j==null){j={}}j.fill="none";if(f){j.stroke=f}j["stroke-width"]=g.toFixed(2).replace(/\.?0+$/,"");j.d=k;this.SUPER(arguments).Init.call(this,j);this.w=this.r=e;this.h=this.H=i+l;this.d=this.D=this.l=0;this.y=-l}});a.menclose.Augment({toSVG:function(G,K){this.SVGgetStyles();var B=this.SVG(),P=this.SVGgetScale(B);this.SVGhandleSpace(B);var r=this.SVGdataStretched(0,G,K);var g=this.getValues("notation","thickness","padding","mathcolor","color");if(g.color&&!this.mathcolor){g.mathcolor=g.color}if(g.thickness==null){g.thickness=".075em"}if(g.padding==null){g.padding=".2em"}var C=this.SVGgetMu(B);var E=d.length2em(g.padding,C,1/d.em)*P;var z=d.length2em(g.thickness,C,1/d.em);z=Math.max(1/d.em,z);var u=r.h+E+z,A=r.d+E+z,k=r.w+2*(E+z);var y=0,v,M,L,I,q=[false,false,false,false];if(!g.mathcolor){g.mathcolor="black"}var j=MathJax.Hub.SplitList(g.notation),o={};for(L=0,I=j.length;L<I;L++){o[j[L]]=true}if(o[a.NOTATION.UPDIAGONALARROW]){o[a.NOTATION.UPDIAGONALSTRIKE]=false}for(var F in o){if(!o.hasOwnProperty(F)||!o[F]){continue}switch(F){case a.NOTATION.BOX:q=[true,true,true,true];break;case a.NOTATION.ROUNDEDBOX:B.Add(b.FRAME(u,A,k,z,"solid",g.mathcolor,{rx:Math.floor(Math.min(u+A-z,k-z)/4)}));break;case a.NOTATION.CIRCLE:B.Add(b.ELLIPSE(u,A,k,z,g.mathcolor));break;case a.NOTATION.ACTUARIAL:q[0]=true;case a.NOTATION.RIGHT:q[1]=true;break;case a.NOTATION.LEFT:q[3]=true;break;case a.NOTATION.TOP:q[0]=true;break;case a.NOTATION.BOTTOM:q[2]=true;break;case a.NOTATION.VERTICALSTRIKE:B.Add(b.VLINE(u+A,z,"solid",g.mathcolor),(k-z)/2,-A);break;case a.NOTATION.HORIZONTALSTRIKE:B.Add(b.HLINE(k,z,"solid",g.mathcolor),0,(u+A-z)/2-A);break;case a.NOTATION.UPDIAGONALSTRIKE:B.Add(b.DLINE(u,A,k,z,g.mathcolor,"up"));break;case a.NOTATION.UPDIAGONALARROW:var J=Math.sqrt(k*k+(u+A)*(u+A)),N=1/J*10/d.em*z/.075;v=k*N;M=(u+A)*N;var s=.4*M;B.Add(b.DLINE(u-.5*M,A,k-.5*v,z,g.mathcolor,"up"));B.Add(b.FPOLY([[s+v,M],[s-.4*M,.4*v],[s+.3*v,.3*M],[s+.4*M,-.4*v],[s+v,M]],g.mathcolor),k-v-s,u-M);break;case a.NOTATION.DOWNDIAGONALSTRIKE:B.Add(b.DLINE(u,A,k,z,g.mathcolor,"down"));break;case a.NOTATION.PHASORANGLE:q[2]=true;k-=2*E;E=(u+A)/2;k+=E;B.Add(b.DLINE(u,A,E,z,g.mathcolor,"up"));break;case a.NOTATION.MADRUWB:q[1]=q[2]=true;break;case a.NOTATION.RADICAL:B.Add(b.PPATH(u,A,k,"M "+this.SVGxy(z/2,.4*(u+A))+" L "+this.SVGxy(E,z/2)+" L "+this.SVGxy(2*E,u+A-z/2)+" L "+this.SVGxy(k,u+A-z/2),z,g.mathcolor),0,z);y=E;break;case a.NOTATION.LONGDIV:B.Add(b.PPATH(u,A,k,"M "+this.SVGxy(z/2,z/2)+" a "+this.SVGxy(E,(u+A)/2-2*z)+" 0 0,1 "+this.SVGxy(z/2,u+A-z)+" L "+this.SVGxy(k,u+A-z/2),z,g.mathcolor),0,z/2);y=E;break}}var O=[["H",k,0,u-z],["V",u+A,k-z,-A],["H",k,0,-A],["V",u+A,0,-A]];for(L=0;L<4;L++){if(q[L]){var e=O[L];B.Add(b[e[0]+"LINE"](e[1],z,"solid",g.mathcolor),e[2],e[3])}}B.Add(r,y+E+z,0,false,true);B.Clean();this.SVGhandleSpace(B);this.SVGhandleColor(B);this.SVGsaveData(B);return B},SVGxy:function(e,f){return Math.floor(e)+","+Math.floor(f)}});MathJax.Hub.Startup.signal.Post("SVG menclose Ready");MathJax.Ajax.loadComplete(d.autoloadDir+"/menclose.js")});MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){var b="2.4.0";var a=MathJax.ElementJax.mml,c=MathJax.OutputJax.SVG;a.ms.Augment({toSVG:function(){this.SVGgetStyles();var e=this.SVG();this.SVGhandleSpace(e);var d=this.getValues("lquote","rquote");var f=this.SVGgetVariant(),h=this.SVGgetScale();var g=this.data.join("");e.Add(this.SVGhandleVariant(f,h,d.lquote+g+d.rquote));e.Clean();this.SVGhandleColor(e);this.SVGsaveData(e);return e}});a.ms.prototype.defaults.mathvariant="monospace";MathJax.Hub.Startup.signal.Post("SVG ms Ready");MathJax.Ajax.loadComplete(c.autoloadDir+"/ms.js")});MathJax.Extension["MathML/content-mathml"]={version:"2.4.0"};MathJax.Hub.Register.StartupHook("MathML Jax Ready",function(){var c=MathJax.InputJax.MathML,e=c.Parse.prototype;c.prefilterHooks.Add(function(h){if(!c.ctopXSLT){return}if(!c.ParseXML){c.ParseXML=c.createParser()}var i=c.ParseXML(e.preProcessMath(h.math));var g=c.ctopXSLT.transformToDocument(i);if(typeof g==="string"){h.math=g}else{if(window.XMLSerializer){var f=new XMLSerializer;h.math=f.serializeToString(g.documentElement,i)}}});var a='<x:stylesheet version="1.0" xmlns:x="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.w3.org/1998/Math/MathML" xmlns:m="http://www.w3.org/1998/Math/MathML" xmlns:c="http://exslt.org/common" exclude-result-prefixes="m c"><!-- Copyright David Carlisle 2001, 2002, 2008, 2009, 2013. Use and distribution of this code are permitted under the terms of the <a href="http://www.w3.org/Consortium/Legal/copyright-software-19980720" >W3C Software Notice and License</a>. Or the Apache 2, MIT or MPL 1.1 or MPL 2.0 licences. --> <x:output method="xml" /><x:template match="/"><x:apply-templates/></x:template><x:template match="*"><x:copy><x:copy-of select="@*"/><x:apply-templates/></x:copy></x:template><x:template match="m:cn"><mn><x:apply-templates/></mn></x:template><x:template match="m:cn[@type=\'complex-cartesian\']"><mrow><mn><x:apply-templates select="text()[1]"/></mn><mo>+</mo><mn><x:apply-templates select="text()[2]"/></mn><mo>&#8290;<!--invisible times--></mo><mi>i<!-- imaginary i --></mi></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'complex_cartesian\']]"><mrow><mn><x:apply-templates select="*[2]"/></mn><mo>+</mo><mn><x:apply-templates select="*[3]"/></mn><mo>&#8290;<!--invisible times--></mo><mi>i<!-- imaginary i --></mi></mrow></x:template><x:template match="m:cn[@type=\'rational\']"><mrow><mn><x:apply-templates select="text()[1]"/></mn><mo>/</mo><mn><x:apply-templates select="text()[2]"/></mn></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'rational\']]"><mrow><mn><x:apply-templates select="*[2]"/></mn><mo>/</mo><mn><x:apply-templates select="*[3]"/></mn></mrow></x:template><x:template match="m:cn[not(@type) or @type=\'integer\']"><x:choose><x:when test="not(@base) or @base=10"><mn><x:apply-templates/></mn></x:when><x:otherwise><msub><mn><x:apply-templates/></mn><mn><x:value-of select="@base"/></mn></msub></x:otherwise></x:choose></x:template><x:template match="m:cn[@type=\'complex-polar\']"><mrow><mn><x:apply-templates select="text()[1]"/></mn><mo>&#8290;<!--invisible times--></mo><msup><mi>e<!-- exponential e--></mi><mrow><mi>i<!-- imaginary i--></mi><mo>&#8290;<!--invisible times--></mo><mn><x:apply-templates select="text()[2]"/></mn></mrow></msup></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'complex_polar\']]"><mrow><x:apply-templates select="*[2]"/><mo>&#8290;<!--invisible times--></mo><msup><mi>e<!-- exponential e--></mi><mrow><mi>i<!-- imaginary i--></mi><mo>&#8290;<!--invisible times--></mo><x:apply-templates select="*[3]"/></mrow></msup></mrow></x:template><x:template match="m:cn[@type=\'e-notation\']"><mn><x:apply-templates select="m:sep/preceding-sibling::node()"/><x:text>E</x:text><x:apply-templates select="m:sep/following-sibling::node()"/></mn></x:template><x:template match="m:cn[@type=\'hexdouble\']"><mn><x:text>0x</x:text><x:apply-templates/></mn></x:template><x:template match="m:ci/text()"><mi><x:value-of select="."/></mi></x:template><x:template match="m:ci"><mrow><x:apply-templates/></mrow></x:template><x:template match="m:csymbol/text()"><mi><x:value-of select="."/></mi></x:template><x:template match="m:csymbol"><mrow><x:apply-templates/></mrow></x:template><x:template match="m:apply|m:reln"><mrow><x:choose><x:when test="*[1]/*/*"><mfenced separators=""><x:apply-templates select="*[1]"><x:with-param name="p" select="10"/></x:apply-templates></mfenced></x:when><x:otherwise><x:apply-templates select="*[1]"><x:with-param name="p" select="10"/></x:apply-templates></x:otherwise></x:choose><mo>&#8289;<!--function application--></mo><mfenced open="(" close=")" separators=","><x:apply-templates select="*[position()>1]"/></mfenced></mrow></x:template><x:template match="m:bind"><mrow><x:choose><x:when test="*[1]/*/*"><mfenced separators=""><x:apply-templates select="*[1]"><x:with-param name="p" select="10"/></x:apply-templates></mfenced></x:when><x:otherwise><x:apply-templates select="*[1]"><x:with-param name="p" select="10"/></x:apply-templates></x:otherwise></x:choose><x:apply-templates select="bvar/*"/><mo>.</mo><x:apply-templates select="*[position()>1][not(self::m:bvar)]"/></mrow></x:template><x:template match="m:fn"><mrow><x:apply-templates/></mrow></x:template><x:template match="m:interval[*[2]]"><mfenced open="[" close="]"><x:apply-templates/></mfenced></x:template><x:template match="m:interval[*[2]][@closure=\'open\']" priority="2"><mfenced open="(" close=")"><x:apply-templates/></mfenced></x:template><x:template match="m:interval[*[2]][@closure=\'open-closed\']" priority="2"><mfenced open="(" close="]"><x:apply-templates/></mfenced></x:template><x:template match="m:interval[*[2]][@closure=\'closed-open\']" priority="2"><mfenced open="[" close=")"><x:apply-templates/></mfenced></x:template><x:template match="m:interval"><mfenced open="{{" close="}}"><x:apply-templates/></mfenced></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'integer_interval\']]"><mfenced open="[" close="]"><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'interval\']]"><mfenced open="[" close="]"><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'interval-cc\']]"><mfenced open="[" close="]"><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'interval-oo\']]"><mfenced open="(" close=")"><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'oriented_interval\']]"><mfenced open="(" close=")"><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:apply[*[1][self::m:inverse]] |m:apply[*[1][self::m:csymbol=\'inverse\']]"><msup><x:apply-templates select="*[2]"/><mrow><mo>(</mo><mn>-1</mn><mo>)</mo></mrow></msup></x:template><x:template match="m:condition"><mrow><x:apply-templates/></mrow></x:template><x:template match="m:declare"/><x:template match="m:lambda |m:apply[*[1][self::m:csymbol=\'lambda\']] |m:bind[*[1][self::m:csymbol=\'lambda\']]"><mrow><mi>&#955;<!--lambda--></mi><mrow><x:choose><x:when test="m:condition"><x:apply-templates select="m:condition/*"/></x:when><x:otherwise><x:apply-templates select="m:bvar/*"/></x:otherwise></x:choose><x:if test="m:domainofapplication"><mo>&#x2208;</mo><x:apply-templates select="m:domainofapplication/*"/></x:if></mrow><mo>.</mo><mfenced><x:apply-templates select="*[last()]"/></mfenced></mrow></x:template><x:template match="m:lambda[not(m:bvar)]" priority="2"><mrow><x:apply-templates select="*[last()]"/><msub><mo>|</mo><mrow><x:apply-templates select="m:condition|m:interval|m:domainofapplication/*"/></mrow></msub></mrow></x:template><x:template match="m:apply[*[1][self::m:compose]] |m:apply[*[1][self::m:csymbol=\'left_compose\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8728;<!-- o --></mo></x:with-param></x:call-template></x:template><x:template match="m:ident"><mi>id</mi></x:template><x:template match="m:domain"><mi>domain</mi></x:template><x:template match="m:codomain"><mi>codomain</mi></x:template><x:template match="m:image"><mi>image</mi></x:template><x:template match="m:domainofapplication"><merror><mtext>unexpected domainofapplication</mtext></merror></x:template><x:template match="m:apply[*[2][self::m:bvar]][m:domainofapplication]" priority="0.4"><mrow><munder><x:apply-templates select="*[1]"/><mrow><x:apply-templates select="m:bvar/*"/><mo>&#8712;<!-- in --></mo><x:apply-templates select="m:domainofapplication/*"/></mrow></munder><mfenced><x:apply-templates select="m:domainofapplication/following-sibling::*"/></mfenced></mrow></x:template><x:template match="m:apply[m:domainofapplication]" priority="0.3"><mrow><mrow><mi>restriction</mi><mfenced><x:apply-templates select="*[1]"/><x:apply-templates select="m:domainofapplication/*"/></mfenced></mrow><mfenced><x:apply-templates select="m:domainofapplication/following-sibling::*"/></mfenced></mrow></x:template><x:template match="m:piecewise"><mrow><mo>{</mo><mtable><x:for-each select="m:piece|m:otherwise"><mtr><mtd><x:apply-templates select="*[1]"/></mtd><x:choose><x:when test="self::m:piece"><mtd columnalign="left"><mtext>&#160; if &#160;</mtext></mtd><mtd><x:apply-templates select="*[2]"/></mtd></x:when><x:otherwise><mtd columnspan="2" columnalign="left"><mtext>&#160; otherwise</mtext></mtd></x:otherwise></x:choose></mtr></x:for-each></mtable></mrow></x:template><x:template match="m:apply[*[1][self::m:quotient]] |m:apply[*[1][self::m:csymbol=\'quotient\']]"><mrow><mo>&#8970;<!-- lfloor--></mo><x:apply-templates select="*[2]"/><mo>/</mo><x:apply-templates select="*[3]"/><mo>&#8971;<!-- rfloor--></mo></mrow></x:template><x:template match="m:apply[*[1][self::m:factorial]] |m:apply[*[1][self::m:csymbol=\'factorial\']]"><mrow><x:apply-templates select="*[2]"><x:with-param name="p" select="7"/></x:apply-templates><mo>!</mo></mrow></x:template><x:template match="m:apply[*[1][self::m:divide]] |m:apply[*[1][self::m:csymbol=\'divide\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>/</mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="3"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:max]] |m:apply[*[1][self::m:csymbol=\'max\']]"><mrow><mi>max</mi><x:call-template name="set"/></mrow></x:template><x:template match="m:apply[*[1][self::m:min]]|m:reln[*[1][self::m:min]]"><mrow><mi>min</mi><x:call-template name="set"/></mrow></x:template><x:template match="m:apply[*[1][self::m:minus] and count(*)=2] |m:apply[*[1][self::m:csymbol=\'unary_minus\']]"><mrow><mo>&#8722;<!--minus--></mo><x:apply-templates select="*[2]"><x:with-param name="p" select="5"/></x:apply-templates></mrow></x:template><x:template match="m:apply[*[1][self::m:minus] and count(*)&gt;2] |m:apply[*[1][self::m:csymbol=\'minus\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>&#8722;<!--minus--></mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="2"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:plus]] |m:apply[*[1][self::m:csymbol=\'plus\']]"><x:param name="p" select="0"/><mrow><x:if test="$p &gt; 2"><mo>(</mo></x:if><x:for-each select="*[position()&gt;1]"><x:choose><x:when test="self::m:apply[*[1][self::m:times] and *[2][self::m:apply/*[1][self::m:minus] or self::m:cn[not(m:sep) and (number(.) &lt; 0)]]] or self::m:apply[count(*)=2 and *[1][self::m:minus]] or self::m:cn[not(m:sep) and (number(.) &lt; 0)]"><mo>&#8722;<!--minus--></mo></x:when><x:when test="position()!=1"><mo>+</mo></x:when></x:choose><x:choose><x:when test="self::m:cn[not(m:sep) and (number(.) &lt; 0)]"><mn><x:value-of select="-(.)"/></mn></x:when><x:when test=" self::m:apply[count(*)=2 and *[1][self::m:minus]]"><x:apply-templates select="*[2]"><x:with-param name="first" select="2"/><x:with-param name="p" select="2"/></x:apply-templates></x:when><x:when test="self::m:apply[*[1][self::m:times] and *[2][self::m:cn[not(m:sep) and (number(.) &lt;0)]]]"><mrow><mn><x:value-of select="-(*[2])"/></mn><mo>&#8290;<!--invisible times--></mo><x:apply-templates select="."><x:with-param name="first" select="2"/><x:with-param name="p" select="2"/></x:apply-templates></mrow></x:when><x:when test="self::m:apply[*[1][self::m:times] and *[2][self::m:apply/*[1][self::m:minus]]]"><mrow><x:apply-templates select="./*[2]/*[2]"/><x:apply-templates select="."><x:with-param name="first" select="2"/><x:with-param name="p" select="2"/></x:apply-templates></mrow></x:when><x:otherwise><x:apply-templates select="."><x:with-param name="p" select="2"/></x:apply-templates></x:otherwise></x:choose></x:for-each><x:if test="$p &gt; 2"><mo>)</mo></x:if></mrow></x:template><x:template match="m:apply[*[1][self::m:power]] |m:apply[*[1][self::m:csymbol=\'power\']]"><x:param name="p" select="0"/><x:choose><x:when test="$p&gt;=5"><mrow><mo>(</mo><msup><x:apply-templates select="*[2]"><x:with-param name="p" select="5"/></x:apply-templates><x:apply-templates select="*[3]"><x:with-param name="p" select="5"/></x:apply-templates></msup><mo>)</mo></mrow></x:when><x:otherwise><msup><x:apply-templates select="*[2]"><x:with-param name="p" select="5"/></x:apply-templates><x:apply-templates select="*[3]"><x:with-param name="p" select="5"/></x:apply-templates></msup></x:otherwise></x:choose></x:template><x:template match="m:apply[*[1][self::m:rem]] |m:apply[*[1][self::m:csymbol=\'rem\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>mod</mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="3"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:times]] |m:apply[*[1][self::m:csymbol=\'times\']]" name="times"><x:param name="p" select="0"/><x:param name="first" select="1"/><mrow><x:if test="$p &gt; 3"><mo>(</mo></x:if><x:for-each select="*[position()&gt;1]"><x:if test="position() &gt; 1"><mo><x:choose><x:when test="self::m:cn">&#215;<!-- times --></x:when><x:otherwise>&#8290;<!--invisible times--></x:otherwise></x:choose></mo></x:if><x:if test="position()&gt;= $first"><x:apply-templates select="."><x:with-param name="p" select="3"/></x:apply-templates></x:if></x:for-each><x:if test="$p &gt; 3"><mo>)</mo></x:if></mrow></x:template><x:template match="m:apply[*[1][self::m:root] and not(m:degree) or m:degree=2]" priority="4"><msqrt><x:apply-templates select="*[position()&gt;1]"/></msqrt></x:template><x:template match="m:apply[*[1][self::m:root]]"><mroot><x:apply-templates select="*[position()&gt;1 and not(self::m:degree)]"/><mrow><x:apply-templates select="m:degree/*"/></mrow></mroot></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'root\']]"><mroot><x:apply-templates select="*[position()!=1]"/></mroot></x:template><x:template match="m:gcd"><mi>gcd</mi></x:template><x:template match="m:apply[*[1][self::m:and]] |m:reln[*[1][self::m:and]] |m:apply[*[1][self::m:csymbol=\'and\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8743;<!-- and --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:or]] |m:apply[*[1][self::m:csymbol=\'or\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="3"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8744;<!-- or --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:xor]] |m:apply[*[1][self::m:csymbol=\'xor\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="3"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>xor</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:not]] |m:apply[*[1][self::m:csymbol=\'not\']]"><mrow><mo>&#172;<!-- not --></mo><x:apply-templates select="*[2]"><x:with-param name="p" select="7"/></x:apply-templates></mrow></x:template><x:template match="m:apply[*[1][self::m:implies]] |m:reln[*[1][self::m:implies]] |m:apply[*[1][self::m:csymbol=\'implies\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>&#8658;<!-- Rightarrow --></mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="3"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:forall]] |m:apply[*[1][self::m:csymbol=\'forall\']] |m:bind[*[1][self::m:forall]] |m:bind[*[1][self::m:csymbol=\'forall\']]"><mrow><mo>&#8704;<!--forall--></mo><mrow><x:apply-templates select="m:bvar[not(current()/m:condition)]/*|m:condition/*"/></mrow><mo>.</mo><mfenced><x:apply-templates select="*[last()]"/></mfenced></mrow></x:template><x:template match="m:apply[*[1][self::m:exists]] |m:apply[*[1][self::m:csymbol=\'exists\']] |m:bind[*[1][self::m:exists]] |m:bind[*[1][self::m:csymbol=\'exists\']]"><mrow><mo>&#8707;<!--exists--></mo><mrow><x:apply-templates select="m:bvar[not(current()/m:condition)]/*|m:condition/*"/></mrow><mo>.</mo><mfenced separators=""><x:choose><x:when test="m:condition"><x:apply-templates select="m:condition/*"/><mo>&#8743;<!-- and --></mo></x:when><x:when test="m:domainofapplication"><mrow><mrow><x:for-each select="m:bvar"><x:apply-templates/><x:if test="position()!=last()"><mo>,</mo></x:if></x:for-each></mrow><mo>&#8712;<!-- in --></mo><x:apply-templates select="m:domainofapplication/*"/></mrow><mo>&#8743;<!-- and --></mo></x:when></x:choose><x:apply-templates select="*[last()]"/></mfenced></mrow></x:template><x:template match="m:apply[*[1][self::m:abs]] |m:apply[*[1][self::m:csymbol=\'abs\']]"><mrow><mo>|</mo><x:apply-templates select="*[2]"/><mo>|</mo></mrow></x:template><x:template match="m:apply[*[1][self::m:conjugate]] |m:apply[*[1][self::m:csymbol=\'conjugate\']]"><mover><x:apply-templates select="*[2]"/><mo>&#175;<!-- overline --></mo></mover></x:template><x:template match="m:arg"><mi>arg</mi></x:template><x:template match="m:real|m:csymbol[.=\'real\']"><mo>&#8475;<!-- real --></mo></x:template><x:template match="m:imaginary|m:csymbol[.=\'imaginary\']"><mo>&#8465;<!-- imaginary --></mo></x:template><x:template match="m:lcm"><mi>lcm</mi></x:template><x:template match="m:apply[*[1][self::m:floor]] |m:apply[*[1][self::m:csymbol=\'floor\']]"><mrow><mo>&#8970;<!-- lfloor--></mo><x:apply-templates select="*[2]"/><mo>&#8971;<!-- rfloor--></mo></mrow></x:template><x:template match="m:apply[*[1][self::m:ceiling]] |m:apply[*[1][self::m:csymbol=\'ceiling\']]"><mrow><mo>&#8968;<!-- lceil--></mo><x:apply-templates select="*[2]"/><mo>&#8969;<!-- rceil--></mo></mrow></x:template><x:template match="m:apply[*[1][self::m:eq]] |m:reln[*[1][self::m:eq]] |m:apply[*[1][self::m:csymbol=\'eq\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>=</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:neq]] |m:apply[*[1][self::m:csymbol=\'neq\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8800;<!-- neq --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:gt]] |m:reln[*[1][self::m:gt]] |m:apply[*[1][self::m:csymbol=\'gt\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&gt;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:lt]] |m:reln[*[1][self::m:lt]] |m:apply[*[1][self::m:csymbol=\'lt\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&lt;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:geq]] |m:apply[*[1][self::m:csymbol=\'geq\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8805;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:leq]] |m:apply[*[1][self::m:csymbol=\'leq\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8804;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:equivalent]] |m:apply[*[1][self::m:csymbol=\'equivalent\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8801;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:approx]] |m:apply[*[1][self::m:csymbol=\'approx\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="1"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8771;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:factorof]] |m:apply[*[1][self::m:csymbol=\'factorof\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>|</mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="3"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:int]] |m:apply[*[1][self::m:csymbol=\'int\']] |m:bind[*[1][self::m:int]] |m:bind[*[1][self::m:csymbol=\'int\']]"><mrow><msubsup><mi>&#8747;<!--int--></mi><mrow><x:apply-templates select="m:lowlimit/*|m:interval/*[1]|m:condition/*|m:domainofapplication/*"/></mrow><mrow><x:apply-templates select="m:uplimit/*|m:interval/*[2]"/></mrow></msubsup><x:apply-templates select="*[last()]"/><x:if test="m:bvar"><mi>d</mi><x:apply-templates select="m:bvar"/></x:if></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'defint\']]"><mrow><munder><mi>&#8747;<!--int--></mi><x:apply-templates select="*[2]"/></munder><x:apply-templates select="*[last()]"/></mrow></x:template><x:template match="m:apply[*[1][self::m:diff] and not(m:bvar)]| m:apply[*[1][self::m:csymbol=\'diff\']]" priority="2"><msup><mrow><x:apply-templates select="*[2]"/></mrow><mo>&#8242;<!--prime--></mo></msup></x:template><x:template match="m:apply[*[1][self::m:diff]]" priority="1"><mfrac><x:choose><x:when test="m:bvar/m:degree"><mrow><msup><mi>d</mi><x:apply-templates select="m:bvar/m:degree/node()"/></msup><x:apply-templates select="*[last()]"/></mrow><mrow><mi>d</mi><msup><x:apply-templates select="m:bvar/node()"/><x:apply-templates select="m:bvar/m:degree/node()"/></msup></mrow></x:when><x:otherwise><mrow><mi>d</mi><x:apply-templates select="*[last()]"/></mrow><mrow><mi>d</mi><x:apply-templates select="m:bvar"/></mrow></x:otherwise></x:choose></mfrac></x:template><x:template match="m:apply[*[1][self::m:partialdiff] and m:list and not(m:bvar) and count(*)=3]" priority="2"><mrow><msub><mi>D</mi><mrow><x:for-each select="m:list[1]/*"><x:apply-templates select="."/><x:if test="position()&lt;last()"><mo>,</mo></x:if></x:for-each></mrow></msub><mrow><x:apply-templates select="*[3]"/></mrow></mrow></x:template><x:template match="m:apply[*[1][self::m:partialdiff] and m:list and m:lambda]" priority="3"><mfrac><mrow><x:choose><x:when test="count(m:list/*)=1"><mo>&#8706;<!-- partial --></mo></x:when><x:otherwise><msup><mo>&#8706;<!-- partial --></mo><mrow><x:choose><x:when test="m:degree"><x:apply-templates select="m:degree/node()"/></x:when><x:otherwise><mn><x:value-of select="count(m:list/*)"/></mn></x:otherwise></x:choose></mrow></msup></x:otherwise></x:choose><x:apply-templates select="m:lambda/*[last()]"/></mrow><mrow><x:call-template name="pddx"/></mrow></mfrac></x:template><x:template name="pddx"><x:param name="n" select="1"/><x:param name="b" select="m:lambda/m:bvar"/><x:param name="l" select="m:list/*"/><x:choose><x:when test="number($l[1])=number($l[2])"><x:call-template name="pddx"><x:with-param name="n" select="$n+1"/><x:with-param name="b" select="$b"/><x:with-param name="l" select="$l[position()!=1]"/></x:call-template></x:when><x:otherwise><mrow><mo>&#8706;<!-- partial --></mo><x:choose><x:when test="$n=1"><x:apply-templates select="$b[position()=$l[1]]/*"/></x:when><x:otherwise><msup><x:apply-templates select="$b[position()=$l[1]]/*"/><mn><x:value-of select="$n"/></mn></msup></x:otherwise></x:choose></mrow><x:if test="$l[2]"><x:call-template name="pddx"><x:with-param name="b" select="$b"/><x:with-param name="l" select="$l[position()!=1]"/></x:call-template></x:if></x:otherwise></x:choose></x:template><x:template match="m:apply[*[1][self::m:partialdiff]]" priority="1"><mfrac><mrow><x:choose><x:when test="not(m:bvar/m:degree) and not(m:bvar[2])"><mo>&#8706;<!-- partial --></mo></x:when><x:otherwise><msup><mo>&#8706;<!-- partial --></mo><mrow><x:choose><x:when test="m:degree"><x:apply-templates select="m:degree/node()"/></x:when><x:when test="m:bvar/m:degree[string(number(.))=\'NaN\']"><x:for-each select="m:bvar/m:degree"><x:apply-templates select="node()"/><x:if test="position()&lt;last()"><mo>+</mo></x:if></x:for-each><x:if test="count(m:bvar[not(m:degree)])&gt;0"><mo>+</mo><mn><x:value-of select="count(m:bvar[not(m:degree)])"/></mn></x:if></x:when><x:otherwise><mn><x:value-of select="number(sum(m:bvar/m:degree))+count(m:bvar[not(m:degree)])"/></mn></x:otherwise></x:choose></mrow></msup></x:otherwise></x:choose><x:apply-templates select="*[last()]"/></mrow><mrow><x:for-each select="m:bvar"><mrow><mo>&#8706;<!-- partial --></mo><msup><x:apply-templates select="node()"/><mrow><x:apply-templates select="m:degree/node()"/></mrow></msup></mrow></x:for-each></mrow></mfrac></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'partialdiffdegree\']]"><mrow><msub><mo>&#8706;<!-- partial --></mo><mrow><x:apply-templates select="*[2]"/></mrow></msub><mfenced><x:apply-templates select="*[4]"/></mfenced></mrow></x:template><x:template match="m:lowlimit"/><x:template match="m:uplimit"/><x:template match="m:bvar"><mi><x:apply-templates/></mi><x:if test="following-sibling::m:bvar"><mo>,</mo></x:if></x:template><x:template match="m:degree"/><x:template match="m:divergence"><mi>div</mi></x:template><x:template match="m:apply[*[1][self::m:divergence]and m:bvar and m:vector]"><x:variable name="v" select="m:bvar"/><mrow><mi>div</mi><mo>&#8289;<!--function application--></mo><mo>(</mo><mtable><x:for-each select="m:vector/*"><x:variable name="p" select="position()"/><mtr><mtd><x:apply-templates select="$v[$p]/*"/><mo>&#x21a6;<!-- map--></mo><x:apply-templates select="."/></mtd></mtr></x:for-each></mtable><mo>)</mo></mrow></x:template><x:template match="m:grad"><mi>grad</mi></x:template><x:template match="m:apply[*[1][self::m:grad]and m:bvar]"><mrow><mi>grad</mi><mo>&#8289;<!--function application--></mo><mrow><mo>(</mo><mfenced><x:apply-templates select="m:bvar/*"/></mfenced><mo>&#x21a6;<!-- map--></mo><x:apply-templates select="*[position()!=1][not(self::m:bvar)]"/><mo>)</mo></mrow></mrow></x:template><x:template match="m:curl"><mi>curl</mi></x:template><x:template match="m:laplacian"><msup><mo>&#8711;<!-- nabla --></mo><mn>2</mn></msup></x:template><x:template match="m:apply[*[1][self::m:laplacian]and m:bvar]"><mrow><x:apply-templates select="*[1]"/><mo>&#8289;<!--function application--></mo><mrow><mo>(</mo><mfenced><x:apply-templates select="m:bvar/*"/></mfenced><mo>&#x21a6;<!-- map--></mo><x:apply-templates select="*[position()!=1][not(self::m:bvar)]"/><mo>)</mo></mrow></mrow></x:template><x:template match="m:set"><x:call-template name="set"/></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'set\']]"><mfenced open="{{" close="}}" separators=","><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:list"><x:call-template name="set"><x:with-param name="o" select="\'(\'"/><x:with-param name="c" select="\')\'"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'list\']]"><mfenced open="(" close=")" separators=","><x:apply-templates select="*[position()!=1]"/></mfenced></x:template><x:template match="m:apply[*[1][self::m:union]] |m:apply[*[1][self::m:csymbol=\'union\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8746;<!-- union --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:union]][m:bvar] |m:apply[*[1][self::m:csymbol=\'union\']][m:bvar]" priority="2" ><x:call-template name="sum"><x:with-param name="mo"><mo>&#x22C3;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:intersect]] |m:apply[*[1][self::m:csymbol=\'intersect\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="3"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8745;<!-- intersect --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:intersect]][m:bvar] |m:apply[*[1][self::m:csymbol=\'intersect\']][m:bvar]" priority="2" ><x:call-template name="sum"><x:with-param name="mo"><mo>&#x22C2;</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:in]] |m:apply[*[1][self::m:csymbol=\'in\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>&#8712;<!-- in --></mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="3"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:notin]]|m:reln[*[1][self::m:notin]] |m:apply[*[1][self::m:csymbol=\'notin\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="mo"><mo>&#8713;<!-- not in --></mo></x:with-param><x:with-param name="p" select="$p"/><x:with-param name="this-p" select="3"/></x:call-template></x:template><x:template match="m:apply[*[1][self::m:subset]] |m:apply[*[1][self::m:csymbol=\'subset\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8838;<!-- subseteq --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:prsubset]] |m:apply[*[1][self::m:csymbol=\'prsubset\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8834;<!-- prsubset --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:notsubset]] |m:apply[*[1][self::m:csymbol=\'notsubset\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8840;<!-- notsubseteq --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:notprsubset]] |m:apply[*[1][self::m:csymbol=\'notprsubset\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8836;<!-- prsubset --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:setdiff]] |m:apply[*[1][self::m:csymbol=\'setdiff\']]"><x:param name="p" select="0"/><x:call-template name="binary"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#8726;<!-- setminus --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:card]] |m:apply[*[1][self::m:csymbol=\'card\']]"><mrow><mo>|</mo><x:apply-templates select="*[2]"/><mo>|</mo></mrow></x:template><x:template match="m:apply[*[1][self::m:cartesianproduct or self::m:vectorproduct]] |m:apply[*[1][self::m:csymbol[.=\'cartesian_product\' or . = \'vectorproduct\']]]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#215;<!-- times --></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:cartesianproduct][count(following-sibling::m:reals)=count(following-sibling::*)]]" priority="2"><msup><x:apply-templates select="*[2]"><x:with-param name="p" select="5"/></x:apply-templates><mn><x:value-of select="count(*)-1"/></mn></msup></x:template><x:template name="sum" match="m:apply[*[1][self::m:sum]]"><x:param name="mo"><mo>&#8721;<!--sum--></mo></x:param><mrow><munderover><x:copy-of select="$mo"/><mrow><x:apply-templates select="m:lowlimit|m:interval/*[1]|m:condition/*|m:domainofapplication/*"/></mrow><mrow><x:apply-templates select="m:uplimit/*|m:interval/*[2]"/></mrow></munderover><x:apply-templates select="*[last()]"/></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'sum\']]"><mrow><munder><mo>&#8721;<!--sum--></mo><x:apply-templates select="*[2]"/></munder><x:apply-templates select="*[last()]"/></mrow></x:template><x:template match="m:apply/m:lowlimit" priority="3"><mrow><x:if test="../m:bvar"><x:apply-templates select="../m:bvar/node()"/><mo>=</mo></x:if><x:apply-templates/></mrow></x:template><x:template match="m:apply[*[1][self::m:product]]"><x:call-template name="sum"><x:with-param name="mo"><mo>&#8719;<!--product--></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'product\']]"><mrow><munder><mo>&#8719;<!--product--></mo><x:apply-templates select="*[2]"/></munder><x:apply-templates select="*[last()]"/></mrow></x:template><x:template match="m:apply[*[1][self::m:limit]]"><mrow><munder><mi>lim</mi><mrow><x:apply-templates select="m:lowlimit|m:condition/*"/></mrow></munder><x:apply-templates select="*[last()]"/></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'limit\']][m:bind]"><mrow><munder><mi>lim</mi><mrow><x:apply-templates select="m:bind/m:bvar/*"/><mo><x:choose><x:when test="*[3]=\'above\'">&#8600;<!--searrow--></x:when><x:when test="*[3]=\'below\'">&#8599;<!--nearrow--></x:when><x:otherwise>&#8594;<!--rightarrow--></x:otherwise></x:choose></mo><x:apply-templates select="*[2]"/></mrow></munder><x:apply-templates select="m:bind/*[last()]"/></mrow></x:template><x:template match="m:apply[m:limit]/m:lowlimit" priority="4"><mrow><x:apply-templates select="../m:bvar/node()"/><mo>&#8594;<!--rightarrow--></mo><x:apply-templates/></mrow></x:template><x:template match="m:apply[*[1][self::m:tendsto]]|m:reln[*[1][self::m:tendsto]]"><x:param name="p"/><x:call-template name="binary"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo><x:choose><x:when test="@type=\'above\'">&#8600;<!--searrow--></x:when><x:when test="@type=\'below\'">&#8599;<!--nearrow--></x:when><x:when test="@type=\'two-sided\'">&#8594;<!--rightarrow--></x:when><x:otherwise>&#8594;<!--rightarrow--></x:otherwise></x:choose></mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'tendsto\']]"><mrow><x:apply-templates select="*[3]"/><mo><x:choose><x:when test="*[1][self::above]">&#8600;<!--searrow--></x:when><x:when test="*[1][self::below]">&#8599;<!--nearrow--></x:when><x:when test="*[1][self::two-sided]">&#8594;<!--rightarrow--></x:when><x:otherwise>&#8594;<!--rightarrow--></x:otherwise></x:choose></mo><x:apply-templates select="*[4]"/></mrow></x:template><x:template match="m:apply[*[1][self::m:semantics/m:ci=\'tendsto\']]"><mrow><x:apply-templates select="*[2]"/><mo>&#8594;<!--rightarrow--></mo><x:apply-templates select="*[3]"/></mrow></x:template><x:template match="m:tendsto"><mi>tendsto</mi></x:template><x:template match="m:apply[*[1][ self::m:sin or self::m:cos or self::m:tan or self::m:sec or self::m:csc or self::m:cot or self::m:sinh or self::m:cosh or self::m:tanh or self::m:sech or self::m:csch or self::m:coth or self::m:arcsin or self::m:arccos or self::m:arctan or self::m:arccosh or self::m:arccot or self::m:arccoth or self::m:arccsc or self::m:arccsch or self::m:arcsec or self::m:arcsech or self::m:arcsinh or self::m:arctanh or self::m:ln]]"><mrow><mi><x:value-of select="local-name(*[1])"/></mi><mo>&#8289;<!--function application--></mo><x:if test="m:apply"><mo>(</mo></x:if><x:apply-templates select="*[2]"/><x:if test="m:apply"><mo>)</mo></x:if></mrow></x:template><x:template match=" m:sin | m:cos | m:tan | m:sec | m:csc | m:cot | m:sinh | m:cosh | m:tanh | m:sech | m:csch | m:coth | m:arcsin | m:arccos | m:arctan | m:arccosh | m:arccot | m:arccoth | m:arccsc | m:arccsch | m:arcsec | m:arcsech | m:arcsinh | m:arctanh | m:ln|m:mean| m:plus|m:minus"><mi><x:value-of select="local-name()"/></mi></x:template><x:template match="m:apply[*[1][self::m:exp]] |m:apply[*[1][self::m:csymbol=\'exp\']]"><msup><mi>e<!-- exponential e--></mi><mrow><x:apply-templates select="*[2]"/></mrow></msup></x:template><x:template match="m:apply[*[1][self::m:log]] |m:apply[*[1][self::m:csymbol=\'log\']]"><mrow><x:choose><x:when test="not(m:logbase) or m:logbase=10"><mi>log</mi></x:when><x:otherwise><msub><mi>log</mi><mrow><x:apply-templates select="m:logbase/node()"/></mrow></msub></x:otherwise></x:choose><mo>&#8289;<!--function application--></mo><x:apply-templates select="*[last()]"><x:with-param name="p" select="7"/></x:apply-templates></mrow></x:template><x:template match="m:apply[*[1][self::m:mean]] |m:apply[*[1][self::m:csymbol=\'mean\']]"><mrow><mo>&#9001;<!--langle--></mo><x:for-each select="*[position()&gt;1]"><x:apply-templates select="."/><x:if test="position() !=last()"><mo>,</mo></x:if></x:for-each><mo>&#9002;<!--rangle--></mo></mrow></x:template><x:template match="m:sdev|m:csymbol[.=\'sdev\']"><mo>&#963;<!--sigma--></mo></x:template><x:template match="m:apply[*[1][self::m:variance]] |m:apply[*[1][self::m:csymbol=\'variance\']]"><msup><mrow><mo>&#963;<!--sigma--></mo><mo>&#8289;<!--function application--></mo><mfenced><x:apply-templates select="*[position()!=1]"/></mfenced></mrow><mn>2</mn></msup></x:template><x:template match="m:median"><mi>median</mi></x:template><x:template match="m:mode"><mi>mode</mi></x:template><x:template match="m:apply[*[1][self::m:moment]]"><mrow><mo>&#9001;<!--langle--></mo><msup><x:variable name="data" select="*[not(position()=1)] [not(self::m:degree or self::m:momentabout)]"/><x:choose><x:when test="$data[2]"><mfenced><x:apply-templates select="$data"/></mfenced></x:when><x:otherwise><x:apply-templates select="$data"/></x:otherwise></x:choose><mrow><x:apply-templates select="m:degree/node()"/></mrow></msup><mo>&#9002;<!--rangle--></mo></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'moment\']]"><msub><mrow><mo>&#9001;<!--langle--></mo><msup><x:apply-templates select="*[4]"/><x:apply-templates select="*[2]"/></msup><mo>&#9002;<!--rangle--></mo></mrow><x:apply-templates select="*[3]"/></msub></x:template><x:template match="m:momentabout"/><x:template match="m:apply[*[1][self::m:moment]][m:momentabout]" priority="2"><msub><mrow><mo>&#9001;<!--langle--></mo><msup><x:variable name="data" select="*[not(position()=1)] [not(self::m:degree or self::m:momentabout)]"/><x:choose><x:when test="$data[2]"><mfenced><x:apply-templates select="$data"/></mfenced></x:when><x:otherwise><x:apply-templates select="$data"/></x:otherwise></x:choose><mrow><x:apply-templates select="m:degree/node()"/></mrow></msup><mo>&#9002;<!--rangle--></mo></mrow><mrow><x:apply-templates select="m:momentabout/*"/></mrow></msub></x:template><x:template match="m:vector"><mrow><mo>(</mo><mtable><x:for-each select="*"><mtr><mtd><x:apply-templates select="."/></mtd></mtr></x:for-each></mtable><mo>)</mo></mrow></x:template><x:template match="m:vector[m:condition]"><mrow><mo>[</mo><x:apply-templates select="*[last()]"/><mo>|</mo><x:apply-templates select="m:condition"/><mo>]</mo></mrow></x:template><x:template match="m:vector[m:domainofapplication]"><mrow><mo>[</mo><x:apply-templates select="*[last()]"/><mo>|</mo><x:apply-templates select="m:bvar/*"/><mo>&#x2208;</mo><x:apply-templates select="m:domainofapplication/*"/><mo>]</mo></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'vector\']]"><mrow><mo>(</mo><mtable><x:for-each select="*[position()!=1]"><mtr><mtd><x:apply-templates select="."/></mtd></mtr></x:for-each></mtable><mo>)</mo></mrow></x:template><x:template match="m:matrix"><mrow><mo>(</mo><mtable><x:apply-templates/></mtable><mo>)</mo></mrow></x:template><x:template match="m:matrix[m:condition]"><mrow><mo>[</mo><msub><mi>m</mi><mrow><x:for-each select="m:bvar"><x:apply-templates/><x:if test="position()!=last()"><mo>,</mo></x:if></x:for-each></mrow></msub><mo>|</mo><mrow><msub><mi>m</mi><mrow><x:for-each select="m:bvar"><x:apply-templates/><x:if test="position()!=last()"><mo>,</mo></x:if></x:for-each></mrow></msub><mo>=</mo><x:apply-templates select="*[last()]"/></mrow><mo>;</mo><x:apply-templates select="m:condition"/><mo>]</mo></mrow></x:template><x:template match="m:apply[*[1][self::m:csymbol=\'matrix\']]"><mrow><mo>(</mo><mtable><x:apply-templates select="*[position()!=1]"/></mtable><mo>)</mo></mrow></x:template><x:template match="m:matrix/m:matrixrow"><mtr><x:for-each select="*"><mtd><x:apply-templates select="."/></mtd></x:for-each></mtr></x:template><x:template match="m:matrixrow"><mtable><mtr><x:for-each select="*"><mtd><x:apply-templates select="."/></mtd></x:for-each></mtr></mtable></x:template><x:template match="m:apply[*[1][self::m:csymbol.=\'matrixrow\']]"><mtr><x:for-each select="*[position()!=1]"><mtd><x:apply-templates select="."/></mtd></x:for-each></mtr></x:template><x:template match="m:apply[*[1][self::m:determinant]] |m:apply[*[1][self::m:csymbol=\'determinant\']]"><mrow><mi>det</mi><mo>&#8289;<!--function application--></mo><x:apply-templates select="*[2]"><x:with-param name="p" select="7"/></x:apply-templates></mrow></x:template><x:template match="m:apply[*[1][self::m:determinant]][*[2][self::m:matrix]]" priority="2"><mrow><mo>|</mo><mtable><x:apply-templates select="m:matrix/*"/></mtable><mo>|</mo></mrow></x:template><x:template match="m:apply[*[1][self::m:transpose]] |m:apply[*[1][self::m:csymbol=\'transpose\']]"><msup><x:apply-templates select="*[2]"><x:with-param name="p" select="7"/></x:apply-templates><mi>T</mi></msup></x:template><x:template match="m:apply[*[1][self::m:selector]] |m:apply[*[1][self::m:csymbol=\'selector\']]"><msub><x:apply-templates select="*[2]"><x:with-param name="p" select="7"/></x:apply-templates><mrow><x:for-each select="*[position()&gt;2]"><x:apply-templates select="."/><x:if test="position() !=last()"><mo>,</mo></x:if></x:for-each></mrow></msub></x:template><x:template match="m:apply[*[1][self::m:scalarproduct]] |m:apply[*[1][self::m:csymbol=\'scalarproduct\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>.</mo></x:with-param></x:call-template></x:template><x:template match="m:apply[*[1][self::m:outerproduct]] |m:apply[*[1][self::m:csymbol=\'outerproduct\']]"><x:param name="p" select="0"/><x:call-template name="infix"><x:with-param name="this-p" select="2"/><x:with-param name="p" select="$p"/><x:with-param name="mo"><mo>&#x2297;</mo></x:with-param></x:call-template></x:template><x:template match="m:semantics"><x:apply-templates select="*[1]"/></x:template><x:template match="m:semantics[m:annotation-xml/@encoding=\'MathML-Presentation\']"><x:apply-templates select="m:annotation-xml[@encoding=\'MathML-Presentation\']/node()"/></x:template><x:template match="m:integers"><mi mathvariant="double-struck">Z</mi></x:template><x:template match="m:reals"><mi mathvariant="double-struck">R</mi></x:template><x:template match="m:rationals"><mi mathvariant="double-struck">Q</mi></x:template><x:template match="m:naturalnumbers"><mi mathvariant="double-struck">N</mi></x:template><x:template match="m:complexes"><mi mathvariant="double-struck">C</mi></x:template><x:template match="m:primes"><mi mathvariant="double-struck">P</mi></x:template><x:template match="m:exponentiale"><mi>e<!-- exponential e--></mi></x:template><x:template match="m:imaginaryi"><mi>i<!-- imaginary i--></mi></x:template><x:template match="m:notanumber"><mi>NaN</mi></x:template><x:template match="m:true"><mi>true</mi></x:template><x:template match="m:false"><mi>false</mi></x:template><x:template match="m:emptyset|m:csymbol[.=\'emptyset\']"><mi>&#8709;<!-- emptyset --></mi></x:template><x:template match="m:pi|m:csymbol[.=\'pi\']"><mi>&#960;<!-- pi --></mi></x:template><x:template match="m:eulergamma|m:csymbol[.=\'gamma\']"><mi>&#947;<!-- gamma --></mi></x:template><x:template match="m:infinity|m:csymbol[.=\'infinity\']"><mi>&#8734;<!-- infinity --></mi></x:template><x:template name="infix" ><x:param name="mo"/><x:param name="p" select="0"/><x:param name="this-p" select="0"/><x:variable name="dmo"><x:choose><x:when test="m:domainofapplication"><munder><x:copy-of select="$mo"/><mrow><x:apply-templates select="m:domainofapplication/*"/></mrow></munder></x:when><x:otherwise><x:copy-of select="$mo"/></x:otherwise></x:choose></x:variable><mrow><x:if test="$this-p &lt; $p"><mo>(</mo></x:if><x:for-each select="*[not(self::m:domainofapplication)][position()&gt;1]"><x:if test="position() &gt; 1"><x:copy-of select="$dmo"/></x:if><x:apply-templates select="."><x:with-param name="p" select="$this-p"/></x:apply-templates></x:for-each><x:if test="$this-p &lt; $p"><mo>)</mo></x:if></mrow></x:template><x:template name="binary" ><x:param name="mo"/><x:param name="p" select="0"/><x:param name="this-p" select="0"/><mrow><x:if test="($this-p &lt; $p) or ($this-p=$p and $mo=\'&#8722;\')"><mo>(</mo></x:if><x:apply-templates select="*[2]"><x:with-param name="p" select="$this-p"/></x:apply-templates><x:copy-of select="$mo"/><x:apply-templates select="*[3]"><x:with-param name="p" select="$this-p"/></x:apply-templates><x:if test="($this-p &lt; $p) or ($this-p=$p and $mo=\'&#8722;\')"><mo>)</mo></x:if></mrow></x:template><x:template name="set" ><x:param name="o" select="\'{\'"/><x:param name="c" select="\'}\'"/><mrow><mo><x:value-of select="$o"/></mo><x:choose><x:when test="m:condition"><mrow><x:apply-templates select="m:condition/following-sibling::*"/></mrow><mo>|</mo><mrow><x:apply-templates select="m:condition/node()"/></mrow></x:when><x:when test="m:domainofapplication"><mrow><x:apply-templates select="m:domainofapplication/following-sibling::*"/></mrow><mo>|</mo><mrow><x:apply-templates select="m:bvar/node()"/></mrow><mo>&#8712;<!-- in --></mo><mrow><x:apply-templates select="m:domainofapplication/node()"/></mrow></x:when><x:otherwise><x:for-each select="*[not(position()=1 and parent::m:apply)]"><x:apply-templates select="."/><x:if test="position() !=last()"><mo>,</mo></x:if></x:for-each></x:otherwise></x:choose><mo><x:value-of select="$c"/></mo></mrow></x:template><x:template match="m:cs"><ms><x:value-of select=" translate(., \'&#9;&#10;&#13;&#32;\', \'&#160;&#160;&#160;&#160;\')"/></ms></x:template><x:template match="m:cbytes"><mrow/></x:template><x:template match="m:cerror"><merror><x:apply-templates/></merror></x:template><x:template match="m:share" priority="4"><mi href="{@href}">share<x:value-of select="substring-after(@href,\'#\')"/></mi></x:template><x:output indent="yes" omit-xml-declaration="yes"/><x:template match="*"><x:copy><x:copy-of select="@*"/><x:apply-templates/></x:copy></x:template><x:template match="*[@dir=\'rtl\']" priority="10"><x:apply-templates mode="rtl" select="."/></x:template><x:template match="@*" mode="rtl"><x:copy-of select="."/></x:template><x:template match="*" mode="rtl"><x:copy><x:apply-templates select="@*" mode="rtl"/><x:for-each select="node()"><x:sort data-type="number" order="descending" select="position()"/><x:text></x:text><x:apply-templates mode="rtl" select="."/></x:for-each></x:copy></x:template><x:template match="@open" mode="rtl"><x:attribute name="close"><x:value-of select="."/></x:attribute></x:template><x:template match="@open[.=\'(\']" mode="rtl"><x:attribute name="close">)</x:attribute></x:template><x:template match="@open[.=\')\']" mode="rtl"><x:attribute name="close">(</x:attribute></x:template><x:template match="@open[.=\'[\']" mode="rtl"><x:attribute name="close">]</x:attribute></x:template><x:template match="@open[.=\']\']" mode="rtl"><x:attribute name="close">[</x:attribute></x:template><x:template match="@open[.=\'{\']" mode="rtl"><x:attribute name="close">}</x:attribute></x:template><x:template match="@open[.=\'}\']" mode="rtl"><x:attribute name="close">{</x:attribute></x:template><x:template match="@close" mode="rtl"><x:attribute name="open"><x:value-of select="."/></x:attribute></x:template><x:template match="@close[.=\'(\']" mode="rtl"><x:attribute name="open">)</x:attribute></x:template><x:template match="@close[.=\')\']" mode="rtl"><x:attribute name="open">(</x:attribute></x:template><x:template match="@close[.=\'[\']" mode="rtl"><x:attribute name="open">]</x:attribute></x:template><x:template match="@close[.=\']\']" mode="rtl"><x:attribute name="open">[</x:attribute></x:template><x:template match="@close[.=\'{\']" mode="rtl"><x:attribute name="open">}</x:attribute></x:template><x:template match="@close[.=\'}\']" mode="rtl"><x:attribute name="open">{</x:attribute></x:template><x:template match="m:mfrac[@bevelled=\'true\']" mode="rtl"><mrow><msub><mi></mi><x:apply-templates select="*[2]" mode="rtl"/></msub><mo>&#x5c;</mo><msup><mi></mi><x:apply-templates select="*[1]" mode="rtl"/></msup></mrow></x:template><x:template match="m:mfrac" mode="rtl"><x:copy><x:apply-templates mode="rtl" select="@*|*"/></x:copy></x:template><x:template match="m:mroot" mode="rtl"><msup><menclose notation="top right"><x:apply-templates mode="rtl" select="@*|*[1]"/></menclose><x:apply-templates mode="rtl" select="*[2]"/></msup></x:template><x:template match="m:msqrt" mode="rtl"><menclose notation="top right"><x:apply-templates mode="rtl" select="@*|*[1]"/></menclose></x:template><x:template match="m:mtable|m:munder|m:mover|m:munderover" mode="rtl" priority="2"><x:copy><x:apply-templates select="@*" mode="rtl"/><x:apply-templates mode="rtl"></x:apply-templates></x:copy></x:template><x:template match="m:msup" mode="rtl" priority="2"><mmultiscripts><x:apply-templates select="*[1]" mode="rtl"/><mprescripts/><none/><x:apply-templates select="*[2]" mode="rtl"/></mmultiscripts></x:template><x:template match="m:msub" mode="rtl" priority="2"><mmultiscripts><x:apply-templates select="*[1]" mode="rtl"/><mprescripts/><x:apply-templates select="*[2]" mode="rtl"/><none/></mmultiscripts></x:template><x:template match="m:msubsup" mode="rtl" priority="2"><mmultiscripts><x:apply-templates select="*[1]" mode="rtl"/><mprescripts/><x:apply-templates select="*[2]" mode="rtl"/><x:apply-templates select="*[3]" mode="rtl"/></mmultiscripts></x:template><x:template match="m:mmultiscripts" mode="rtl" priority="2"><mmultiscripts><x:apply-templates select="*[1]" mode="rtl"/><x:for-each select="m:mprescripts/following-sibling::*[position() mod 2 = 1]"><x:sort data-type="number" order="descending" select="position()"/><x:apply-templates select="." mode="rtl"/><x:apply-templates select="following-sibling::*[1]" mode="rtl"/></x:for-each><mprescripts/><x:for-each select="m:mprescripts/preceding-sibling::*[position()!=last()][position() mod 2 = 0]"><x:sort data-type="number" order="descending" select="position()"/><x:apply-templates select="." mode="rtl"/><x:apply-templates select="following-sibling::*[1]" mode="rtl"/></x:for-each></mmultiscripts></x:template><x:template match="m:mmultiscripts[not(m:mprescripts)]" mode="rtl" priority="3"><mmultiscripts><x:apply-templates select="*[1]" mode="rtl"/><mprescripts/><x:for-each select="*[position() mod 2 = 0]"><x:sort data-type="number" order="descending" select="position()"/><x:apply-templates select="." mode="rtl"/><x:apply-templates select="following-sibling::*[1]" mode="rtl"/></x:for-each></mmultiscripts></x:template><x:template match="text()[.=\'(\']" mode="rtl">)</x:template><x:template match="text()[.=\')\']" mode="rtl">(</x:template><x:template match="text()[.=\'{\']" mode="rtl">}</x:template><x:template match="text()[.=\'}\']" mode="rtl">{</x:template><x:template match="text()[.=\'&lt;\']" mode="rtl">&gt;</x:template><x:template match="text()[.=\'&gt;\']" mode="rtl">&lt;</x:template><x:template match="text()[.=\'&#x2208;\']" mode="rtl">&#x220b;</x:template><x:template match="text()[.=\'&#x220b;\']" mode="rtl">&#x2208;</x:template><x:template match="@notation[.=\'radical\']" mode="rtl"><x:attribute name="notation">top right</x:attribute></x:template><x:template name="mml2attrib"><!-- <x:copy-of select="@*[not(local-name()=\'href\')]"/> --><x:copy-of select="@*[not(local-name()=\'href\')]"/><x:attribute name="style"><x:if test="@style"><x:value-of select="@style"/>;</x:if><x:if test="@mathcolor">color:<x:value-of select="@mathcolor"/>;</x:if><x:if test="@mathbackground">background-color:<x:value-of select="@mathbackground"/>;</x:if></x:attribute></x:template><!-- <x:template match="*[@href]" priority="3"><a xmlns="http://www.w3.org/1999/xhtml" style="text-decoration: none" href="{@href}"><x:copy><x:call-template name="mml2attrib"/><x:attribute name="class"><x:text>mmlhref </x:text><x:value-of select="@class"/></x:attribute><x:apply-templates/></x:copy></a></x:template> --><x:template match="*[@mathcolor|@mathbackground]"><x:copy><x:call-template name="mml2attrib"/><x:apply-templates/></x:copy></x:template><x:param name="hascolspan" select="true()"/><x:template match="m:mstack"><mtable columnspacing="0em"><x:variable name="t"><x:apply-templates select="*" mode="mstack1"><x:with-param name="p" select="0"/></x:apply-templates></x:variable><x:variable name="maxl"><x:for-each select="c:node-set($t)/*/@l"><x:sort data-type="number" order="descending"/><x:if test="position()=1"><x:value-of select="."/></x:if></x:for-each></x:variable><x:for-each select="c:node-set($t)/*[not(@class=\'mscarries\') or following-sibling::*[1]/@class=\'mscarries\']"><x:variable name="c" select="preceding-sibling::*[1][@class=\'mscarries\']"/><x:text>&#10;</x:text><mtr><x:variable name="offset" select="$maxl - @l"/><x:choose><x:when test="$hascolspan and @class=\'msline\' and (string(*[1]/@columnspan)=\'\' or string(*[1]/@columnspan)=\'0\')"><mtd columnspan="{$maxl}"><x:copy-of select="*/@style"/></mtd></x:when><x:when test="@class=\'msline\' and @l=\'*\'"><x:variable name="msl" select="*[1]"/><x:for-each select="(//node())[position()&lt;=$maxl]"><x:copy-of select="$msl"/></x:for-each></x:when><x:when test="$c"><x:variable name="ldiff" select="$c/@l - @l"/><x:variable name="loffset" select="$maxl - $c/@l"/><x:for-each select="(//*)[position()&lt;= $offset]"><x:variable name="pn" select="position()"/><x:variable name="cy" select="$c/*[position()=$pn - $loffset]"/> <mtd> <x:if test="$cy/*"/> <mover><mphantom><mn>0</mn></mphantom><mpadded width="0em" lspace="-0.5width"><x:copy-of select="$cy/*/*"/></mpadded></mover> </mtd></x:for-each><x:for-each select="*"><x:variable name="pn" select="position()"/><x:variable name="cy" select="$c/*[position()=$pn + $ldiff]"/><x:copy> <x:copy-of select="@*"/> <x:variable name="b"> <x:choose> <x:when test="not(string($cy/@crossout) or $cy/@crossout=\'none\')"><x:copy-of select="*"/></x:when> <x:otherwise> <menclose notation="{$cy/@crossout}"><x:copy-of select="*"/></menclose> </x:otherwise> </x:choose> </x:variable> <x:choose> <x:when test="$cy/*/m:none or not($cy/*/*)"><x:copy-of select="$b"/></x:when> <x:when test="not(string($cy/@location)) or $cy/@location=\'n\'"> <mover><x:copy-of select="$b"/><mpadded width="0em" lspace="-0.5width"><x:copy-of select="$cy/*/*"/></mpadded></mover> </x:when> <x:when test="$cy/@location=\'nw\'"> <mmultiscripts><x:copy-of select="$b"/><mprescripts/><none/><mpadded lspace="-1width" width="0em"><x:copy-of select="$cy/*/*"/></mpadded></mmultiscripts> </x:when> <x:when test="$cy/@location=\'s\'"> <munder><x:copy-of select="$b"/><mpadded width="0em" lspace="-0.5width"><x:copy-of select="$cy/*/*"/></mpadded></munder> </x:when> <x:when test="$cy/@location=\'sw\'"> <mmultiscripts><x:copy-of select="$b"/><mprescripts/><mpadded lspace="-1width" width="0em"><x:copy-of select="$cy/*/*"/></mpadded><none/></mmultiscripts> </x:when> <x:when test="$cy/@location=\'ne\'"> <msup><x:copy-of select="$b"/><mpadded width="0em"><x:copy-of select="$cy/*/*"/></mpadded></msup> </x:when> <x:when test="$cy/@location=\'se\'"> <msub><x:copy-of select="$b"/><mpadded width="0em"><x:copy-of select="$cy/*/*"/></mpadded></msub> </x:when> <x:when test="$cy/@location=\'w\'"> <msup><mrow/><mpadded lspace="-1width" width="0em"><x:copy-of select="$cy/*/*"/></mpadded></msup> <x:copy-of select="$b"/> </x:when> <x:when test="$cy/@location=\'e\'"> <x:copy-of select="$b"/> <msup><mrow/><mpadded width="0em"><x:copy-of select="$cy/*/*"/></mpadded></msup> </x:when> <x:otherwise> <x:copy-of select="$b"/> </x:otherwise> </x:choose></x:copy></x:for-each></x:when><x:otherwise><x:for-each select="(//*)[position()&lt;= $offset]"><mtd/></x:for-each><x:copy-of select="*"/></x:otherwise></x:choose></mtr></x:for-each></mtable></x:template><x:template mode="mstack1" match="*"><x:param name="p"/><x:param name="maxl" select="0"/><mtr l="{1 + $p}"><x:if test="ancestor::mstack[1]/@stackalign=\'left\'"><x:attribute name="l"><x:value-of select="$p"/></x:attribute></x:if><mtd><x:apply-templates select="."/></mtd></mtr></x:template><x:template mode="mstack1" match="m:msrow"><x:param name="p"/><x:param name="maxl" select="0"/><x:variable name="align1" select="ancestor::m:mstack[1]/@stackalign"/><x:variable name="align"><x:choose><x:when test="string($align1)=\'\'">decimalpoint</x:when><x:otherwise><x:value-of select="$align1"/></x:otherwise></x:choose></x:variable><x:variable name="row"><x:apply-templates mode="mstack1" select="*"><x:with-param name="p" select="0"/></x:apply-templates></x:variable><x:text>&#10;</x:text><x:variable name="l1"><x:choose><x:when test="$align=\'decimalpoint\' and m:mn"><x:for-each select="c:node-set($row)/m:mtr[m:mtd/m:mn][1]"><x:value-of select="number(sum(@l))+count(preceding-sibling::*/@l)"/></x:for-each></x:when><x:when test="$align=\'right\' or $align=\'decimalpoint\'"><x:value-of select="count(c:node-set($row)/m:mtr/m:mtd)"/></x:when><x:otherwise><x:value-of select="0"/></x:otherwise></x:choose></x:variable><mtr class="msrow" l="{number($l1) + number(sum(@position)) +$p}"><x:copy-of select="c:node-set($row)/m:mtr/*"/></mtr></x:template><x:template mode="mstack1" match="m:mn"><x:param name="p"/><x:variable name="align1" select="ancestor::m:mstack[1]/@stackalign"/><x:variable name="dp1" select="ancestor::*[@decimalpoint][1]/@decimalpoint"/><x:variable name="align"><x:choose><x:when test="string($align1)=\'\'">decimalpoint</x:when><x:otherwise><x:value-of select="$align1"/></x:otherwise></x:choose></x:variable><x:variable name="dp"><x:choose><x:when test="string($dp1)=\'\'">.</x:when><x:otherwise><x:value-of select="$dp1"/></x:otherwise></x:choose></x:variable><mtr l="$p"><x:variable name="mn" select="normalize-space(.)"/><x:variable name="len" select="string-length($mn)"/><x:choose><x:when test="$align=\'right\' or ($align=\'decimalpoint\' and not(contains($mn,$dp)))"><x:attribute name="l"><x:value-of select="$p + $len"/></x:attribute></x:when><x:when test="$align=\'decimalpoint\'"><x:attribute name="l"><x:value-of select="$p + string-length(substring-before($mn,$dp))"/></x:attribute></x:when></x:choose><x:for-each select="(//node())[position() &lt;=$len]"><x:variable name="pos" select="position()"/><mtd><mn><x:value-of select="substring($mn,$pos,1)"/></mn></mtd></x:for-each></mtr></x:template><x:template match="m:msgroup" mode="mstack1"><x:param name="p"/><x:variable name="s" select="number(sum(@shift))"/><x:variable name="thisp" select="number(sum(@position))"/><x:for-each select="*"><x:apply-templates mode="mstack1" select="."><x:with-param name="p" select="number($p)+$thisp+(position()-1)*$s"/></x:apply-templates></x:for-each></x:template><x:template match="m:msline" mode="mstack1"><x:param name="p"/><x:variable name="align1" select="ancestor::m:mstack[1]/@stackalign"/><x:variable name="align"><x:choose><x:when test="string($align1)=\'\'">decimalpoint</x:when><x:otherwise><x:value-of select="$align1"/></x:otherwise></x:choose></x:variable><mtr class="msline"><x:attribute name="l"><x:choose><x:when test="not(string(@length)) or @length=0">*</x:when><x:when test="string($align)=\'right\' or string($align)=\'decimalpoint\' "><x:value-of select="$p+ @length"/></x:when><x:otherwise><x:value-of select="$p"/></x:otherwise></x:choose></x:attribute><x:variable name="w"><x:choose><x:when test="@mslinethickness=\'thin\'">0.1em</x:when><x:when test="@mslinethickness=\'medium\'">0.15em</x:when><x:when test="@mslinethickness=\'thick\'">0.2em</x:when><x:when test="@mslinethickness"><x:value-of select="@mslinethickness"/></x:when><x:otherwise>0.15em</x:otherwise></x:choose></x:variable><x:choose><x:when test="$hascolspan"><mtd class="msline" columnspan="{@length}"><x:copy-of select="@position"/><x:attribute name="style"><x:value-of select="concat(\'border-style: solid; border-width: 0 0 \',$w,\' 0\')"/></x:attribute></mtd></x:when><x:when test="not(string(@length)) or @length=0"><mtd class="mslinemax"><mpadded lspace="-0.5em" width="0em" height="0em"><mfrac linethickness="{$w}"><mspace width="1em"/><mrow/></mfrac></mpadded></mtd></x:when><x:otherwise><x:variable name="l" select="@length"/><x:for-each select="(//node())[position()&lt;=$l]"><mtd class="msline"><mpadded lspace="-0.5em" width="0em" height="0em"><mfrac linethickness="{$w}"> <mspace width="1em"/> <mrow/></mfrac></mpadded></mtd></x:for-each></x:otherwise></x:choose></mtr></x:template><x:template match="m:mscarries" mode="mstack1"><x:param name="p"/><x:variable name="align1" select="ancestor::m:mstack[1]/@stackalign"/><x:variable name="l1"><x:choose><x:when test="string($align1)=\'left\'">0</x:when><x:otherwise><x:value-of select="count(*)"/></x:otherwise></x:choose></x:variable><mtr class="mscarries" l="{$p + $l1 + sum(@position)}"><x:apply-templates select="*" mode="msc"/></mtr></x:template><x:template match="*" mode="msc"><mtd><x:copy-of select="../@location|../@crossout"/><mstyle mathsize="70%"><x:apply-templates select="."/></mstyle></mtd></x:template><x:template match="m:mscarry" mode="msc"><mtd><x:copy-of select="@location|@crossout"/><mstyle mathsize="70%"><x:apply-templates select="*"/></mstyle></mtd></x:template><x:template match="m:mlongdiv"><x:variable name="ms"><mstack><x:copy-of select="(ancestor-or-self::*/@decimalpoint)[last()]"/><x:choose><x:when test="@longdivstyle=\'left/\right\'"><msrow><mrow><x:copy-of select="*[1]"/></mrow><mo>/</mo><x:copy-of select="*[3]"/><mo></mo><x:copy-of select="*[2]"/></msrow></x:when><x:when test="@longdivstyle=\'left)(right\'"><msrow><mrow><x:copy-of select="*[1]"/></mrow><mo>)</mo><x:copy-of select="*[3]"/><mo>(</mo><x:copy-of select="*[2]"/></msrow></x:when><x:when test="@longdivstyle=\':right=right\'"><msrow><x:copy-of select="*[3]"/><mo>:</mo><x:copy-of select="*[1]"/><mo>=</mo><x:copy-of select="*[2]"/></msrow></x:when><x:otherwise><x:copy-of select="*[2]"/><msline length="{string-length(*[3])}"/><msrow><mrow><x:copy-of select="*[1]"/></mrow><mo>)</mo><x:copy-of select="*[3]"/></msrow></x:otherwise></x:choose><x:copy-of select="*[position()&gt;3]"/></mstack></x:variable><x:apply-templates select="c:node-set($ms)"/></x:template><x:template match="m:menclose[@notation=\'madruwb\']" mode="rtl"><menclose notation="bottom right"><x:apply-templates mode="rtl"/></menclose></x:template></x:stylesheet>';
var d;if(window.XSLTProcessor){if(!c.ParseXML){c.ParseXML=c.createParser()}c.ctopXSLT=new XSLTProcessor;c.ctopXSLT.importStylesheet(c.ParseXML(a))}else{if(MathJax.Hub.Browser.isMSIE){if(MathJax.Hub.Browser.versionAtLeast("9.0")||(document.documentMode||0)>=9){d=new ActiveXObject("Msxml2.FreeThreadedDOMDocument");d.loadXML(a);var b=new ActiveXObject("Msxml2.XSLTemplate");b.stylesheet=d;c.ctopXSLT={ctop:b.createProcessor(),transformToDocument:function(f){this.ctop.input=f;this.ctop.transform();return this.ctop.output}}}else{d=c.createMSParser();d.async=false;d.loadXML(a);c.ctopXSLT={ctop:d,transformToDocument:function(f){return f.documentElement.transformNode(this.ctop)}}}}else{c.ctopXSLT=null}}MathJax.Hub.Startup.signal.Post("MathML content-mathml Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/MathML/content-mathml.js");(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Ascr:"𝒜",Bscr:"ℬ",Cscr:"𝒞",Dscr:"𝒟",Escr:"ℰ",Fscr:"ℱ",Gscr:"𝒢",Hscr:"ℋ",Iscr:"ℐ",Jscr:"𝒥",Kscr:"𝒦",Lscr:"ℒ",Mscr:"ℳ",Nscr:"𝒩",Oscr:"𝒪",Pscr:"𝒫",Qscr:"𝒬",Rscr:"ℛ",Sscr:"𝒮",Tscr:"𝒯",Uscr:"𝒰",Vscr:"𝒱",Wscr:"𝒲",Xscr:"𝒳",Yscr:"𝒴",Zscr:"𝒵",ascr:"𝒶",bscr:"𝒷",cscr:"𝒸",dscr:"𝒹",escr:"ℯ",fscr:"𝒻",gscr:"ℊ",hscr:"𝒽",iscr:"𝒾",jscr:"𝒿",kscr:"𝓀",lscr:"𝓁",mscr:"𝓂",nscr:"𝓃",oscr:"ℴ",pscr:"𝓅",qscr:"𝓆",rscr:"𝓇",sscr:"𝓈",tscr:"𝓉",uscr:"𝓊",vscr:"𝓋",wscr:"𝓌",xscr:"𝓍",yscr:"𝓎",zscr:"𝓏"});MathJax.Ajax.loadComplete(a.entityDir+"/scr.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Aopf:"𝔸",Bopf:"𝔹",Copf:"ℂ",Dopf:"𝔻",Eopf:"𝔼",Fopf:"𝔽",Gopf:"𝔾",Hopf:"ℍ",Iopf:"𝕀",Jopf:"𝕁",Kopf:"𝕂",Lopf:"𝕃",Mopf:"𝕄",Nopf:"ℕ",Oopf:"𝕆",Popf:"ℙ",Qopf:"ℚ",Ropf:"ℝ",Sopf:"𝕊",Topf:"𝕋",Uopf:"𝕌",Vopf:"𝕍",Wopf:"𝕎",Xopf:"𝕏",Yopf:"𝕐",Zopf:"ℤ",aopf:"𝕒",bopf:"𝕓",copf:"𝕔",dopf:"𝕕",eopf:"𝕖",fopf:"𝕗",gopf:"𝕘",hopf:"𝕙",iopf:"𝕚",jopf:"𝕛",kopf:"𝕜",lopf:"𝕝",mopf:"𝕞",nopf:"𝕟",oopf:"𝕠",popf:"𝕡",qopf:"𝕢",ropf:"𝕣",sopf:"𝕤",topf:"𝕥",uopf:"𝕦",vopf:"𝕧",wopf:"𝕨",xopf:"𝕩",yopf:"𝕪",zopf:"𝕫"});MathJax.Ajax.loadComplete(a.entityDir+"/opf.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{ZHcy:"Ж",Zacute:"Ź",Zcaron:"Ž",Zcy:"З",Zdot:"Ż",ZeroWidthSpace:"​",Zeta:"Ζ",zacute:"ź",zcaron:"ž",zcy:"з",zdot:"ż",zeetrf:"ℨ",zhcy:"ж",zwj:"‍",zwnj:"‌"});MathJax.Ajax.loadComplete(a.entityDir+"/z.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{GJcy:"Ѓ",GT:">",Gammad:"Ϝ",Gbreve:"Ğ",Gcedil:"Ģ",Gcirc:"Ĝ",Gcy:"Г",Gdot:"Ġ",GreaterGreater:"⪢",Gt:"≫",gE:"≧",gacute:"ǵ",gammad:"ϝ",gbreve:"ğ",gcirc:"ĝ",gcy:"г",gdot:"ġ",ge:"≥",gel:"⋛",geq:"≥",geqq:"≧",geqslant:"⩾",ges:"⩾",gescc:"⪩",gesdot:"⪀",gesdoto:"⪂",gesdotol:"⪄",gesl:"⋛︀",gesles:"⪔",gg:"≫",ggg:"⋙",gjcy:"ѓ",gl:"≷",glE:"⪒",gla:"⪥",glj:"⪤",gnapprox:"⪊",gneq:"⪈",gneqq:"≩",grave:"`",gsim:"≳",gsime:"⪎",gsiml:"⪐",gtcc:"⪧",gtcir:"⩺",gtlPar:"⦕",gtquest:"⩼",gtrapprox:"⪆",gtrarr:"⥸",gtrdot:"⋗",gtreqless:"⋛",gtreqqless:"⪌",gtrless:"≷",gtrsim:"≳",gvertneqq:"≩︀",gvnE:"≩︀"});MathJax.Ajax.loadComplete(a.entityDir+"/g.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{RBarr:"⤐",REG:"®",Racute:"Ŕ",Rang:"⟫",Rarrtl:"⤖",Rcaron:"Ř",Rcedil:"Ŗ",Rcy:"Р",ReverseElement:"∋",ReverseUpEquilibrium:"⥯",Rho:"Ρ",RightArrowBar:"⇥",RightDoubleBracket:"⟧",RightDownTeeVector:"⥝",RightDownVectorBar:"⥕",RightTeeVector:"⥛",RightTriangleBar:"⧐",RightUpDownVector:"⥏",RightUpTeeVector:"⥜",RightUpVectorBar:"⥔",RightVectorBar:"⥓",RoundImplies:"⥰",RuleDelayed:"⧴",rAarr:"⇛",rArr:"⇒",rAtail:"⤜",rBarr:"⤏",rHar:"⥤",race:"∽̱",racute:"ŕ",radic:"√",raemptyv:"⦳",rang:"⟩",rangd:"⦒",range:"⦥",rangle:"⟩",raquo:"»",rarr:"→",rarrap:"⥵",rarrb:"⇥",rarrbfs:"⤠",rarrc:"⤳",rarrfs:"⤞",rarrhk:"↪",rarrlp:"↬",rarrpl:"⥅",rarrsim:"⥴",rarrw:"↝",ratail:"⤚",ratio:"∶",rationals:"ℚ",rbarr:"⤍",rbbrk:"❳",rbrke:"⦌",rbrksld:"⦎",rbrkslu:"⦐",rcaron:"ř",rcedil:"ŗ",rceil:"⌉",rcub:"}",rcy:"р",rdca:"⤷",rdldhar:"⥩",rdquo:"”",rdquor:"”",rdsh:"↳",real:"ℜ",realine:"ℛ",realpart:"ℜ",reals:"ℝ",rect:"▭",reg:"®",rfisht:"⥽",rfloor:"⌋",rhard:"⇁",rharu:"⇀",rharul:"⥬",rightarrow:"→",rightarrowtail:"↣",rightharpoondown:"⇁",rightharpoonup:"⇀",rightleftarrows:"⇄",rightleftharpoons:"⇌",rightsquigarrow:"↝",risingdotseq:"≓",rlarr:"⇄",rlhar:"⇌",rlm:"‏",rmoustache:"⎱",rnmid:"⫮",roang:"⟭",roarr:"⇾",robrk:"⟧",ropar:"⦆",roplus:"⨮",rotimes:"⨵",rpar:")",rpargt:"⦔",rppolint:"⨒",rrarr:"⇉",rsaquo:"›",rsh:"↱",rsqb:"]",rsquo:"’",rsquor:"’",rthree:"⋌",rtrie:"⊵",rtrif:"▸",rtriltri:"⧎",ruluhar:"⥨",rx:"℞"});MathJax.Ajax.loadComplete(a.entityDir+"/r.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Pcy:"П",Poincareplane:"ℌ",Pr:"⪻",Prime:"″",Proportion:"∷",par:"∥",para:"¶",parallel:"∥",parsim:"⫳",parsl:"⫽",part:"∂",pcy:"п",percnt:"%",permil:"‰",perp:"⊥",pertenk:"‱",phmmat:"ℳ",phone:"☎",pitchfork:"⋔",planck:"ℏ",planckh:"ℎ",plankv:"ℏ",plus:"+",plusacir:"⨣",plusb:"⊞",pluscir:"⨢",plusdo:"∔",plusdu:"⨥",pluse:"⩲",plusmn:"±",plussim:"⨦",plustwo:"⨧",pm:"±",pointint:"⨕",pound:"£",pr:"≺",prE:"⪳",prcue:"≼",pre:"⪯",prec:"≺",precapprox:"⪷",preccurlyeq:"≼",preceq:"⪯",precsim:"≾",primes:"ℙ",prnE:"⪵",prnap:"⪹",prnsim:"⋨",prod:"∏",profalar:"⌮",profline:"⌒",profsurf:"⌓",prop:"∝",propto:"∝",prsim:"≾",prurel:"⊰",puncsp:" "});MathJax.Ajax.loadComplete(a.entityDir+"/p.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Map:"⤅",Mcy:"М",MediumSpace:" ",Mellintrf:"ℳ",Mu:"Μ",mDDot:"∺",male:"♂",maltese:"✠",map:"↦",mapsto:"↦",mapstodown:"↧",mapstoleft:"↤",mapstoup:"↥",marker:"▮",mcomma:"⨩",mcy:"м",mdash:"—",measuredangle:"∡",micro:"µ",mid:"∣",midast:"*",midcir:"⫰",middot:"·",minus:"−",minusb:"⊟",minusd:"∸",minusdu:"⨪",mlcp:"⫛",mldr:"…",mnplus:"∓",models:"⊧",mp:"∓",mstpos:"∾",mumap:"⊸"});MathJax.Ajax.loadComplete(a.entityDir+"/m.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{QUOT:'"',qint:"⨌",qprime:"⁗",quaternions:"ℍ",quatint:"⨖",quest:"?",questeq:"≟",quot:'"'});MathJax.Ajax.loadComplete(a.entityDir+"/q.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{THORN:"Þ",TRADE:"™",TSHcy:"Ћ",TScy:"Ц",Tab:"	",Tau:"Τ",Tcaron:"Ť",Tcedil:"Ţ",Tcy:"Т",ThickSpace:"  ",ThinSpace:" ",TripleDot:"⃛",Tstrok:"Ŧ",target:"⌖",tbrk:"⎴",tcaron:"ť",tcedil:"ţ",tcy:"т",tdot:"⃛",telrec:"⌕",there4:"∴",therefore:"∴",thetasym:"ϑ",thickapprox:"≈",thicksim:"∼",thinsp:" ",thkap:"≈",thksim:"∼",thorn:"þ",timesb:"⊠",timesbar:"⨱",timesd:"⨰",tint:"∭",toea:"⤨",top:"⊤",topbot:"⌶",topcir:"⫱",topfork:"⫚",tosa:"⤩",tprime:"‴",trade:"™",triangledown:"▿",triangleleft:"◃",trianglelefteq:"⊴",triangleright:"▹",trianglerighteq:"⊵",tridot:"◬",trie:"≜",triminus:"⨺",triplus:"⨹",trisb:"⧍",tritime:"⨻",trpezium:"⏢",tscy:"ц",tshcy:"ћ",tstrok:"ŧ",twixt:"≬",twoheadleftarrow:"↞",twoheadrightarrow:"↠"});MathJax.Ajax.loadComplete(a.entityDir+"/t.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Wcirc:"Ŵ",wcirc:"ŵ",wedbar:"⩟",wedge:"∧",wedgeq:"≙",wp:"℘",wr:"≀",wreath:"≀"});MathJax.Ajax.loadComplete(a.entityDir+"/w.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Fcy:"Ф",FilledSmallSquare:"◼",Fouriertrf:"ℱ",fallingdotseq:"≒",fcy:"ф",female:"♀",ffilig:"ﬃ",fflig:"ﬀ",ffllig:"ﬄ",filig:"ﬁ",fjlig:"fj",fllig:"ﬂ",fltns:"▱",fnof:"ƒ",forall:"∀",forkv:"⫙",fpartint:"⨍",frac12:"½",frac13:"⅓",frac14:"¼",frac15:"⅕",frac16:"⅙",frac18:"⅛",frac23:"⅔",frac25:"⅖",frac34:"¾",frac35:"⅗",frac38:"⅜",frac45:"⅘",frac56:"⅚",frac58:"⅝",frac78:"⅞",frasl:"⁄"});MathJax.Ajax.loadComplete(a.entityDir+"/f.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{VDash:"⊫",Vbar:"⫫",Vcy:"В",Vdashl:"⫦",Verbar:"‖",Vert:"‖",VerticalLine:"|",VerticalSeparator:"❘",VeryThinSpace:" ",vArr:"⇕",vBar:"⫨",vBarv:"⫩",vDash:"⊨",vangrt:"⦜",varepsilon:"ϵ",varkappa:"ϰ",varnothing:"∅",varphi:"ϕ",varpi:"ϖ",varpropto:"∝",varr:"↕",varrho:"ϱ",varsigma:"ς",varsubsetneq:"⊊︀",varsubsetneqq:"⫋︀",varsupsetneq:"⊋︀",varsupsetneqq:"⫌︀",vartheta:"ϑ",vartriangleleft:"⊲",vartriangleright:"⊳",vcy:"в",vdash:"⊢",vee:"∨",veeeq:"≚",verbar:"|",vert:"|",vltri:"⊲",vnsub:"⊂⃒",vnsup:"⊃⃒",vprop:"∝",vrtri:"⊳",vsubnE:"⫋︀",vsubne:"⊊︀",vsupnE:"⫌︀",vsupne:"⊋︀",vzigzag:"⦚"});MathJax.Ajax.loadComplete(a.entityDir+"/v.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{ENG:"Ŋ",ETH:"Ð",Eacute:"É",Ecaron:"Ě",Ecirc:"Ê",Ecy:"Э",Edot:"Ė",Egrave:"È",Emacr:"Ē",EmptySmallSquare:"◻",EmptyVerySmallSquare:"▫",Eogon:"Ę",Epsilon:"Ε",Equal:"⩵",Esim:"⩳",Eta:"Η",Euml:"Ë",eDDot:"⩷",eDot:"≑",eacute:"é",easter:"⩮",ecaron:"ě",ecirc:"ê",ecolon:"≕",ecy:"э",edot:"ė",ee:"ⅇ",eg:"⪚",egrave:"è",egsdot:"⪘",el:"⪙",elinters:"⏧",elsdot:"⪗",emacr:"ē",emptyset:"∅",emptyv:"∅",emsp:" ",emsp13:" ",emsp14:" ",eng:"ŋ",ensp:" ",eogon:"ę",epar:"⋕",eparsl:"⧣",eplus:"⩱",epsilon:"ε",eqcirc:"≖",eqcolon:"≕",eqsim:"≂",eqslantgtr:"⪖",eqslantless:"⪕",equals:"=",equest:"≟",equiv:"≡",equivDD:"⩸",eqvparsl:"⧥",erarr:"⥱",esdot:"≐",esim:"≂",euml:"ë",euro:"€",excl:"!",exist:"∃",expectation:"ℰ",exponentiale:"ⅇ"});MathJax.Ajax.loadComplete(a.entityDir+"/e.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{KHcy:"Х",KJcy:"Ќ",Kappa:"Κ",Kcedil:"Ķ",Kcy:"К",kcedil:"ķ",kcy:"к",kgreen:"ĸ",khcy:"х",kjcy:"ќ"});MathJax.Ajax.loadComplete(a.entityDir+"/k.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{xcap:"⋂",xcirc:"◯",xcup:"⋃",xdtri:"▽",xhArr:"⟺",xharr:"⟷",xlArr:"⟸",xlarr:"⟵",xmap:"⟼",xnis:"⋻",xodot:"⨀",xoplus:"⨁",xotime:"⨂",xrArr:"⟹",xrarr:"⟶",xsqcup:"⨆",xuplus:"⨄",xutri:"△",xvee:"⋁",xwedge:"⋀"});MathJax.Ajax.loadComplete(a.entityDir+"/x.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{CHcy:"Ч",COPY:"©",Cacute:"Ć",CapitalDifferentialD:"ⅅ",Cayleys:"ℭ",Ccaron:"Č",Ccedil:"Ç",Ccirc:"Ĉ",Cconint:"∰",Cdot:"Ċ",Cedilla:"¸",Chi:"Χ",ClockwiseContourIntegral:"∲",CloseCurlyDoubleQuote:"”",CloseCurlyQuote:"’",Colon:"∷",Colone:"⩴",Conint:"∯",CounterClockwiseContourIntegral:"∳",cacute:"ć",capand:"⩄",capbrcup:"⩉",capcap:"⩋",capcup:"⩇",capdot:"⩀",caps:"∩︀",caret:"⁁",caron:"ˇ",ccaps:"⩍",ccaron:"č",ccedil:"ç",ccirc:"ĉ",ccups:"⩌",ccupssm:"⩐",cdot:"ċ",cedil:"¸",cemptyv:"⦲",cent:"¢",centerdot:"·",chcy:"ч",checkmark:"✓",cir:"○",cirE:"⧃",cire:"≗",cirfnint:"⨐",cirmid:"⫯",cirscir:"⧂",clubsuit:"♣",colone:"≔",coloneq:"≔",comma:",",commat:"@",compfn:"∘",complement:"∁",complexes:"ℂ",cong:"≅",congdot:"⩭",conint:"∮",coprod:"∐",copy:"©",copysr:"℗",crarr:"↵",cross:"✗",csub:"⫏",csube:"⫑",csup:"⫐",csupe:"⫒",cudarrl:"⤸",cudarrr:"⤵",cularrp:"⤽",cupbrcap:"⩈",cupcap:"⩆",cupcup:"⩊",cupdot:"⊍",cupor:"⩅",cups:"∪︀",curarrm:"⤼",curlyeqprec:"⋞",curlyeqsucc:"⋟",curren:"¤",curvearrowleft:"↶",curvearrowright:"↷",cuvee:"⋎",cuwed:"⋏",cwconint:"∲",cwint:"∱",cylcty:"⌭"});MathJax.Ajax.loadComplete(a.entityDir+"/c.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{NJcy:"Њ",Nacute:"Ń",Ncaron:"Ň",Ncedil:"Ņ",Ncy:"Н",NegativeMediumSpace:"​",NegativeThickSpace:"​",NegativeThinSpace:"​",NegativeVeryThinSpace:"​",NewLine:"\n",NoBreak:"⁠",NonBreakingSpace:" ",Not:"⫬",NotCongruent:"≢",NotCupCap:"≭",NotEqualTilde:"≂̸",NotGreaterFullEqual:"≧̸",NotGreaterGreater:"≫̸",NotGreaterLess:"≹",NotGreaterSlantEqual:"⩾̸",NotGreaterTilde:"≵",NotHumpDownHump:"≎̸",NotHumpEqual:"≏̸",NotLeftTriangleBar:"⧏̸",NotLessGreater:"≸",NotLessLess:"≪̸",NotLessSlantEqual:"⩽̸",NotLessTilde:"≴",NotNestedGreaterGreater:"⪢̸",NotNestedLessLess:"⪡̸",NotPrecedesEqual:"⪯̸",NotReverseElement:"∌",NotRightTriangleBar:"⧐̸",NotSquareSubset:"⊏̸",NotSquareSubsetEqual:"⋢",NotSquareSuperset:"⊐̸",NotSquareSupersetEqual:"⋣",NotSubset:"⊂⃒",NotSucceedsEqual:"⪰̸",NotSucceedsTilde:"≿̸",NotSuperset:"⊃⃒",NotTildeEqual:"≄",NotTildeFullEqual:"≇",NotTildeTilde:"≉",Ntilde:"Ñ",Nu:"Ν",nGg:"⋙̸",nGt:"≫⃒",nGtv:"≫̸",nLl:"⋘̸",nLt:"≪⃒",nLtv:"≪̸",nabla:"∇",nacute:"ń",nang:"∠⃒",nap:"≉",napE:"⩰̸",napid:"≋̸",napos:"ŉ",napprox:"≉",natural:"♮",naturals:"ℕ",nbsp:" ",nbump:"≎̸",nbumpe:"≏̸",ncap:"⩃",ncaron:"ň",ncedil:"ņ",ncong:"≇",ncongdot:"⩭̸",ncup:"⩂",ncy:"н",ndash:"–",ne:"≠",neArr:"⇗",nearhk:"⤤",nearrow:"↗",nedot:"≐̸",nequiv:"≢",nesear:"⤨",nesim:"≂̸",nexist:"∄",nexists:"∄",ngE:"≧̸",nge:"≱",ngeq:"≱",ngeqq:"≧̸",ngeqslant:"⩾̸",nges:"⩾̸",ngsim:"≵",ngt:"≯",ngtr:"≯",nhArr:"⇎",nhpar:"⫲",ni:"∋",nis:"⋼",nisd:"⋺",niv:"∋",njcy:"њ",nlArr:"⇍",nlE:"≦̸",nldr:"‥",nle:"≰",nleftarrow:"↚",nleftrightarrow:"↮",nleq:"≰",nleqq:"≦̸",nleqslant:"⩽̸",nles:"⩽̸",nless:"≮",nlsim:"≴",nlt:"≮",nltri:"⋪",nltrie:"⋬",nmid:"∤",notin:"∉",notinE:"⋹̸",notindot:"⋵̸",notinva:"∉",notinvb:"⋷",notinvc:"⋶",notni:"∌",notniva:"∌",notnivb:"⋾",notnivc:"⋽",npar:"∦",nparallel:"∦",nparsl:"⫽⃥",npart:"∂̸",npolint:"⨔",npr:"⊀",nprcue:"⋠",npre:"⪯̸",nprec:"⊀",npreceq:"⪯̸",nrArr:"⇏",nrarrc:"⤳̸",nrarrw:"↝̸",nrightarrow:"↛",nrtri:"⋫",nrtrie:"⋭",nsc:"⊁",nsccue:"⋡",nsce:"⪰̸",nshortmid:"∤",nshortparallel:"∦",nsim:"≁",nsime:"≄",nsimeq:"≄",nsmid:"∤",nspar:"∦",nsqsube:"⋢",nsqsupe:"⋣",nsub:"⊄",nsubE:"⫅̸",nsube:"⊈",nsubset:"⊂⃒",nsubseteq:"⊈",nsubseteqq:"⫅̸",nsucc:"⊁",nsucceq:"⪰̸",nsup:"⊅",nsupE:"⫆̸",nsupe:"⊉",nsupset:"⊃⃒",nsupseteq:"⊉",nsupseteqq:"⫆̸",ntgl:"≹",ntilde:"ñ",ntlg:"≸",ntriangleleft:"⋪",ntrianglelefteq:"⋬",ntriangleright:"⋫",ntrianglerighteq:"⋭",num:"#",numero:"№",numsp:" ",nvHarr:"⤄",nvap:"≍⃒",nvge:"≥⃒",nvgt:">⃒",nvinfin:"⧞",nvlArr:"⤂",nvle:"≤⃒",nvlt:"<⃒",nvltrie:"⊴⃒",nvrArr:"⤃",nvrtrie:"⊵⃒",nvsim:"∼⃒",nwArr:"⇖",nwarhk:"⤣",nwarrow:"↖",nwnear:"⤧"});MathJax.Ajax.loadComplete(a.entityDir+"/n.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{AElig:"Æ",AMP:"&",Aacute:"Á",Abreve:"Ă",Acirc:"Â",Acy:"А",Agrave:"À",Alpha:"Α",Amacr:"Ā",And:"⩓",Aogon:"Ą",Aring:"Å",Assign:"≔",Atilde:"Ã",Auml:"Ä",aacute:"á",abreve:"ă",ac:"∾",acE:"∾̳",acd:"∿",acirc:"â",acy:"а",aelig:"æ",af:"⁡",agrave:"à",alefsym:"ℵ",amacr:"ā",amp:"&",andand:"⩕",andd:"⩜",andslope:"⩘",andv:"⩚",ange:"⦤",angle:"∠",angmsdaa:"⦨",angmsdab:"⦩",angmsdac:"⦪",angmsdad:"⦫",angmsdae:"⦬",angmsdaf:"⦭",angmsdag:"⦮",angmsdah:"⦯",angrt:"∟",angrtvb:"⊾",angrtvbd:"⦝",angst:"Å",angzarr:"⍼",aogon:"ą",ap:"≈",apE:"⩰",apacir:"⩯",apid:"≋",apos:"'",approx:"≈",approxeq:"≊",aring:"å",ast:"*",asymp:"≈",asympeq:"≍",atilde:"ã",auml:"ä",awconint:"∳",awint:"⨑"});MathJax.Ajax.loadComplete(a.entityDir+"/a.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Jcirc:"Ĵ",Jcy:"Й",Jsercy:"Ј",Jukcy:"Є",jcirc:"ĵ",jcy:"й",jsercy:"ј",jukcy:"є"});MathJax.Ajax.loadComplete(a.entityDir+"/j.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Uacute:"Ú",Uarr:"↟",Uarrocir:"⥉",Ubrcy:"Ў",Ubreve:"Ŭ",Ucirc:"Û",Ucy:"У",Udblac:"Ű",Ugrave:"Ù",Umacr:"Ū",UnderBracket:"⎵",UnderParenthesis:"⏝",Uogon:"Ų",UpArrowBar:"⤒",UpArrowDownArrow:"⇅",UpEquilibrium:"⥮",UpTeeArrow:"↥",UpperLeftArrow:"↖",UpperRightArrow:"↗",Upsi:"ϒ",Uring:"Ů",Utilde:"Ũ",Uuml:"Ü",uArr:"⇑",uHar:"⥣",uacute:"ú",uarr:"↑",ubrcy:"ў",ubreve:"ŭ",ucirc:"û",ucy:"у",udarr:"⇅",udblac:"ű",udhar:"⥮",ufisht:"⥾",ugrave:"ù",uharl:"↿",uharr:"↾",uhblk:"▀",ulcorn:"⌜",ulcorner:"⌜",ulcrop:"⌏",ultri:"◸",umacr:"ū",uml:"¨",uogon:"ų",uparrow:"↑",updownarrow:"↕",upharpoonleft:"↿",upharpoonright:"↾",uplus:"⊎",upsih:"ϒ",upsilon:"υ",urcorn:"⌝",urcorner:"⌝",urcrop:"⌎",uring:"ů",urtri:"◹",utdot:"⋰",utilde:"ũ",utri:"▵",utrif:"▴",uuarr:"⇈",uuml:"ü",uwangle:"⦧"});MathJax.Ajax.loadComplete(a.entityDir+"/u.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Barv:"⫧",Barwed:"⌆",Bcy:"Б",Bernoullis:"ℬ",Beta:"Β",Bumpeq:"≎",bNot:"⫭",backcong:"≌",backepsilon:"϶",barvee:"⊽",barwed:"⌅",barwedge:"⌅",bbrk:"⎵",bbrktbrk:"⎶",bcong:"≌",bcy:"б",bdquo:"„",becaus:"∵",because:"∵",bemptyv:"⦰",bepsi:"϶",bernou:"ℬ",bigcap:"⋂",bigcup:"⋃",bigvee:"⋁",bigwedge:"⋀",bkarow:"⤍",blacksquare:"▪",blacktriangleright:"▸",blank:"␣",blk12:"▒",blk14:"░",blk34:"▓",block:"█",bne:"=⃥",bnequiv:"≡⃥",bnot:"⌐",bot:"⊥",bottom:"⊥",boxDL:"╗",boxDR:"╔",boxDl:"╖",boxDr:"╓",boxH:"═",boxHD:"╦",boxHU:"╩",boxHd:"╤",boxHu:"╧",boxUL:"╝",boxUR:"╚",boxUl:"╜",boxUr:"╙",boxV:"║",boxVH:"╬",boxVL:"╣",boxVR:"╠",boxVh:"╫",boxVl:"╢",boxVr:"╟",boxbox:"⧉",boxdL:"╕",boxdR:"╒",boxh:"─",boxhD:"╥",boxhU:"╨",boxhd:"┬",boxhu:"┴",boxuL:"╛",boxuR:"╘",boxv:"│",boxvH:"╪",boxvL:"╡",boxvR:"╞",boxvh:"┼",boxvl:"┤",boxvr:"├",bprime:"‵",breve:"˘",brvbar:"¦",bsemi:"⁏",bsim:"∽",bsime:"⋍",bsolb:"⧅",bsolhsub:"⟈",bullet:"•",bump:"≎",bumpE:"⪮",bumpe:"≏",bumpeq:"≏"});MathJax.Ajax.loadComplete(a.entityDir+"/b.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{IEcy:"Е",IJlig:"Ĳ",IOcy:"Ё",Iacute:"Í",Icirc:"Î",Icy:"И",Idot:"İ",Igrave:"Ì",Imacr:"Ī",Implies:"⇒",Int:"∬",Iogon:"Į",Iota:"Ι",Itilde:"Ĩ",Iukcy:"І",Iuml:"Ï",iacute:"í",ic:"⁣",icirc:"î",icy:"и",iecy:"е",iexcl:"¡",iff:"⇔",igrave:"ì",ii:"ⅈ",iiiint:"⨌",iiint:"∭",iinfin:"⧜",iiota:"℩",ijlig:"ĳ",imacr:"ī",image:"ℑ",imagline:"ℐ",imagpart:"ℑ",imof:"⊷",imped:"Ƶ","in":"∈",incare:"℅",infintie:"⧝",inodot:"ı","int":"∫",integers:"ℤ",intercal:"⊺",intlarhk:"⨗",intprod:"⨼",iocy:"ё",iogon:"į",iprod:"⨼",iquest:"¿",isin:"∈",isinE:"⋹",isindot:"⋵",isins:"⋴",isinsv:"⋳",isinv:"∈",it:"⁢",itilde:"ĩ",iukcy:"і",iuml:"ï"});MathJax.Ajax.loadComplete(a.entityDir+"/i.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{LJcy:"Љ",LT:"<",Lacute:"Ĺ",Lang:"⟪",Laplacetrf:"ℒ",Lcaron:"Ľ",Lcedil:"Ļ",Lcy:"Л",LeftArrowBar:"⇤",LeftDoubleBracket:"⟦",LeftDownTeeVector:"⥡",LeftDownVectorBar:"⥙",LeftRightVector:"⥎",LeftTeeArrow:"↤",LeftTeeVector:"⥚",LeftTriangleBar:"⧏",LeftUpDownVector:"⥑",LeftUpTeeVector:"⥠",LeftUpVectorBar:"⥘",LeftVectorBar:"⥒",LessLess:"⪡",Lmidot:"Ŀ",LowerLeftArrow:"↙",LowerRightArrow:"↘",Lstrok:"Ł",Lt:"≪",lAarr:"⇚",lArr:"⇐",lAtail:"⤛",lBarr:"⤎",lE:"≦",lHar:"⥢",lacute:"ĺ",laemptyv:"⦴",lagran:"ℒ",lang:"⟨",langd:"⦑",langle:"⟨",laquo:"«",larr:"←",larrb:"⇤",larrbfs:"⤟",larrfs:"⤝",larrhk:"↩",larrpl:"⤹",larrsim:"⥳",lat:"⪫",latail:"⤙",late:"⪭",lates:"⪭︀",lbarr:"⤌",lbbrk:"❲",lbrke:"⦋",lbrksld:"⦏",lbrkslu:"⦍",lcaron:"ľ",lcedil:"ļ",lceil:"⌈",lcub:"{",lcy:"л",ldca:"⤶",ldquo:"“",ldquor:"„",ldrdhar:"⥧",ldrushar:"⥋",ldsh:"↲",leftarrow:"←",leftarrowtail:"↢",leftharpoondown:"↽",leftharpoonup:"↼",leftrightarrow:"↔",leftrightarrows:"⇆",leftrightharpoons:"⇋",leftrightsquigarrow:"↭",leg:"⋚",leq:"≤",leqq:"≦",leqslant:"⩽",les:"⩽",lescc:"⪨",lesdot:"⩿",lesdoto:"⪁",lesdotor:"⪃",lesg:"⋚︀",lesges:"⪓",lessapprox:"⪅",lesseqgtr:"⋚",lesseqqgtr:"⪋",lessgtr:"≶",lesssim:"≲",lfisht:"⥼",lfloor:"⌊",lg:"≶",lgE:"⪑",lhard:"↽",lharu:"↼",lharul:"⥪",lhblk:"▄",ljcy:"љ",ll:"≪",llarr:"⇇",llcorner:"⌞",llhard:"⥫",lltri:"◺",lmidot:"ŀ",lmoustache:"⎰",lnapprox:"⪉",lneq:"⪇",lneqq:"≨",loang:"⟬",loarr:"⇽",lobrk:"⟦",longleftarrow:"⟵",longleftrightarrow:"⟷",longrightarrow:"⟶",looparrowleft:"↫",lopar:"⦅",loplus:"⨭",lotimes:"⨴",lowbar:"_",lozenge:"◊",lozf:"⧫",lpar:"(",lparlt:"⦓",lrarr:"⇆",lrcorner:"⌟",lrhar:"⇋",lrhard:"⥭",lrm:"‎",lrtri:"⊿",lsaquo:"‹",lsh:"↰",lsim:"≲",lsime:"⪍",lsimg:"⪏",lsqb:"[",lsquo:"‘",lsquor:"‚",lstrok:"ł",ltcc:"⪦",ltcir:"⩹",ltdot:"⋖",lthree:"⋋",ltlarr:"⥶",ltquest:"⩻",ltrPar:"⦖",ltrie:"⊴",ltrif:"◂",lurdshar:"⥊",luruhar:"⥦",lvertneqq:"≨︀",lvnE:"≨︀"});MathJax.Ajax.loadComplete(a.entityDir+"/l.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{YAcy:"Я",YIcy:"Ї",YUcy:"Ю",Yacute:"Ý",Ycirc:"Ŷ",Ycy:"Ы",Yuml:"Ÿ",yacute:"ý",yacy:"я",ycirc:"ŷ",ycy:"ы",yicy:"ї",yucy:"ю",yuml:"ÿ"});MathJax.Ajax.loadComplete(a.entityDir+"/y.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{Afr:"𝔄",Bfr:"𝔅",Cfr:"ℭ",Dfr:"𝔇",Efr:"𝔈",Ffr:"𝔉",Gfr:"𝔊",Hfr:"ℌ",Ifr:"ℑ",Jfr:"𝔍",Kfr:"𝔎",Lfr:"𝔏",Mfr:"𝔐",Nfr:"𝔑",Ofr:"𝔒",Pfr:"𝔓",Qfr:"𝔔",Rfr:"ℜ",Sfr:"𝔖",Tfr:"𝔗",Ufr:"𝔘",Vfr:"𝔙",Wfr:"𝔚",Xfr:"𝔛",Yfr:"𝔜",Zfr:"ℨ",afr:"𝔞",bfr:"𝔟",cfr:"𝔠",dfr:"𝔡",efr:"𝔢",ffr:"𝔣",gfr:"𝔤",hfr:"𝔥",ifr:"𝔦",jfr:"𝔧",kfr:"𝔨",lfr:"𝔩",mfr:"𝔪",nfr:"𝔫",ofr:"𝔬",pfr:"𝔭",qfr:"𝔮",rfr:"𝔯",sfr:"𝔰",tfr:"𝔱",ufr:"𝔲",vfr:"𝔳",wfr:"𝔴",xfr:"𝔵",yfr:"𝔶",zfr:"𝔷"});MathJax.Ajax.loadComplete(a.entityDir+"/fr.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{OElig:"Œ",Oacute:"Ó",Ocirc:"Ô",Ocy:"О",Odblac:"Ő",Ograve:"Ò",Omacr:"Ō",Omicron:"Ο",OpenCurlyDoubleQuote:"“",OpenCurlyQuote:"‘",Or:"⩔",Oslash:"Ø",Otilde:"Õ",Otimes:"⨷",Ouml:"Ö",OverBracket:"⎴",OverParenthesis:"⏜",oS:"Ⓢ",oacute:"ó",oast:"⊛",ocir:"⊚",ocirc:"ô",ocy:"о",odash:"⊝",odblac:"ő",odiv:"⨸",odot:"⊙",odsold:"⦼",oelig:"œ",ofcir:"⦿",ogon:"˛",ograve:"ò",ogt:"⧁",ohbar:"⦵",ohm:"Ω",oint:"∮",olarr:"↺",olcir:"⦾",olcross:"⦻",oline:"‾",olt:"⧀",omacr:"ō",omid:"⦶",ominus:"⊖",opar:"⦷",operp:"⦹",oplus:"⊕",orarr:"↻",ord:"⩝",order:"ℴ",orderof:"ℴ",ordf:"ª",ordm:"º",origof:"⊶",oror:"⩖",orslope:"⩗",orv:"⩛",oslash:"ø",otilde:"õ",otimes:"⊗",otimesas:"⨶",ouml:"ö",ovbar:"⌽"});MathJax.Ajax.loadComplete(a.entityDir+"/o.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{SHCHcy:"Щ",SHcy:"Ш",SOFTcy:"Ь",Sacute:"Ś",Sc:"⪼",Scaron:"Š",Scedil:"Ş",Scirc:"Ŝ",Scy:"С",ShortDownArrow:"↓",ShortLeftArrow:"←",ShortRightArrow:"→",ShortUpArrow:"↑",Sub:"⋐",Sup:"⋑",sacute:"ś",sbquo:"‚",sc:"≻",scE:"⪴",scaron:"š",sccue:"≽",sce:"⪰",scedil:"ş",scirc:"ŝ",scpolint:"⨓",scsim:"≿",scy:"с",sdotb:"⊡",sdote:"⩦",seArr:"⇘",searhk:"⤥",searrow:"↘",semi:";",seswar:"⤩",setminus:"∖",setmn:"∖",sext:"✶",sfrown:"⌢",shchcy:"щ",shcy:"ш",shortmid:"∣",shortparallel:"∥",shy:"­",sigmaf:"ς",sim:"∼",simdot:"⩪",sime:"≃",simeq:"≃",simg:"⪞",simgE:"⪠",siml:"⪝",simlE:"⪟",simplus:"⨤",simrarr:"⥲",slarr:"←",smallsetminus:"∖",smashp:"⨳",smeparsl:"⧤",smid:"∣",smt:"⪪",smte:"⪬",smtes:"⪬︀",softcy:"ь",sol:"/",solb:"⧄",solbar:"⌿",spadesuit:"♠",spar:"∥",sqcap:"⊓",sqcaps:"⊓︀",sqcup:"⊔",sqcups:"⊔︀",sqsub:"⊏",sqsube:"⊑",sqsubset:"⊏",sqsubseteq:"⊑",sqsup:"⊐",sqsupe:"⊒",sqsupset:"⊐",sqsupseteq:"⊒",squ:"□",square:"□",squarf:"▪",squf:"▪",srarr:"→",ssetmn:"∖",ssmile:"⌣",sstarf:"⋆",star:"☆",starf:"★",straightepsilon:"ϵ",straightphi:"ϕ",strns:"¯",subdot:"⪽",sube:"⊆",subedot:"⫃",submult:"⫁",subplus:"⪿",subrarr:"⥹",subset:"⊂",subseteq:"⊆",subseteqq:"⫅",subsetneq:"⊊",subsetneqq:"⫋",subsim:"⫇",subsub:"⫕",subsup:"⫓",succ:"≻",succapprox:"⪸",succcurlyeq:"≽",succeq:"⪰",succnapprox:"⪺",succneqq:"⪶",succnsim:"⋩",succsim:"≿",sum:"∑",sung:"♪",sup:"⊃",sup1:"¹",sup2:"²",sup3:"³",supdot:"⪾",supdsub:"⫘",supe:"⊇",supedot:"⫄",suphsol:"⟉",suphsub:"⫗",suplarr:"⥻",supmult:"⫂",supplus:"⫀",supset:"⊃",supseteq:"⊇",supseteqq:"⫆",supsetneq:"⊋",supsetneqq:"⫌",supsim:"⫈",supsub:"⫔",supsup:"⫖",swArr:"⇙",swarhk:"⤦",swarrow:"↙",swnwar:"⤪",szlig:"ß"});MathJax.Ajax.loadComplete(a.entityDir+"/s.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{DD:"ⅅ",DDotrahd:"⤑",DJcy:"Ђ",DScy:"Ѕ",DZcy:"Џ",Darr:"↡",Dashv:"⫤",Dcaron:"Ď",Dcy:"Д",DiacriticalAcute:"´",DiacriticalDot:"˙",DiacriticalDoubleAcute:"˝",DiacriticalGrave:"`",DiacriticalTilde:"˜",Dot:"¨",DotDot:"⃜",DoubleContourIntegral:"∯",DoubleDownArrow:"⇓",DoubleLeftArrow:"⇐",DoubleLeftRightArrow:"⇔",DoubleLeftTee:"⫤",DoubleLongLeftArrow:"⟸",DoubleLongLeftRightArrow:"⟺",DoubleLongRightArrow:"⟹",DoubleRightArrow:"⇒",DoubleUpArrow:"⇑",DoubleUpDownArrow:"⇕",DownArrowBar:"⤓",DownArrowUpArrow:"⇵",DownBreve:"̑",DownLeftRightVector:"⥐",DownLeftTeeVector:"⥞",DownLeftVectorBar:"⥖",DownRightTeeVector:"⥟",DownRightVectorBar:"⥗",DownTeeArrow:"↧",Dstrok:"Đ",dArr:"⇓",dHar:"⥥",darr:"↓",dash:"‐",dashv:"⊣",dbkarow:"⤏",dblac:"˝",dcaron:"ď",dcy:"д",dd:"ⅆ",ddagger:"‡",ddotseq:"⩷",demptyv:"⦱",dfisht:"⥿",dharl:"⇃",dharr:"⇂",diam:"⋄",diamond:"⋄",diamondsuit:"♦",diams:"♦",die:"¨",disin:"⋲",divide:"÷",divonx:"⋇",djcy:"ђ",dlcorn:"⌞",dlcrop:"⌍",dollar:"$",doteq:"≐",dotminus:"∸",doublebarwedge:"⌆",downarrow:"↓",downdownarrows:"⇊",downharpoonleft:"⇃",downharpoonright:"⇂",drbkarow:"⤐",drcorn:"⌟",drcrop:"⌌",dscy:"ѕ",dsol:"⧶",dstrok:"đ",dtri:"▿",dtrif:"▾",duarr:"⇵",duhar:"⥯",dwangle:"⦦",dzcy:"џ",dzigrarr:"⟿"});MathJax.Ajax.loadComplete(a.entityDir+"/d.js")})(MathJax.InputJax.MathML);(function(a){MathJax.Hub.Insert(a.Parse.Entity,{HARDcy:"Ъ",Hcirc:"Ĥ",HilbertSpace:"ℋ",HorizontalLine:"─",Hstrok:"Ħ",hArr:"⇔",hairsp:" ",half:"½",hamilt:"ℋ",hardcy:"ъ",harr:"↔",harrcir:"⥈",hcirc:"ĥ",hearts:"♥",heartsuit:"♥",hercon:"⊹",hksearow:"⤥",hkswarow:"⤦",hoarr:"⇿",homtht:"∻",horbar:"―",hslash:"ℏ",hstrok:"ħ",hybull:"⁃",hyphen:"‐"});MathJax.Ajax.loadComplete(a.entityDir+"/h.js")})(MathJax.InputJax.MathML);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{infix:{"↚":c.RELACCENT,"↛":c.RELACCENT,"↜":c.WIDEREL,"↝":c.WIDEREL,"↞":c.WIDEREL,"↟":c.WIDEREL,"↠":c.WIDEREL,"↡":c.RELSTRETCH,"↢":c.WIDEREL,"↣":c.WIDEREL,"↤":c.WIDEREL,"↥":c.RELSTRETCH,"↧":c.RELSTRETCH,"↨":c.RELSTRETCH,"↫":c.WIDEREL,"↬":c.WIDEREL,"↭":c.WIDEREL,"↮":c.RELACCENT,"↯":c.RELSTRETCH,"↰":c.RELSTRETCH,"↱":c.RELSTRETCH,"↲":c.RELSTRETCH,"↳":c.RELSTRETCH,"↴":c.RELSTRETCH,"↵":c.RELSTRETCH,"↶":c.RELACCENT,"↷":c.RELACCENT,"↸":c.REL,"↹":c.WIDEREL,"↺":c.REL,"↻":c.REL,"↾":c.RELSTRETCH,"↿":c.RELSTRETCH,"⇂":c.RELSTRETCH,"⇃":c.RELSTRETCH,"⇄":c.WIDEREL,"⇅":c.RELSTRETCH,"⇆":c.WIDEREL,"⇇":c.WIDEREL,"⇈":c.RELSTRETCH,"⇉":c.WIDEREL,"⇊":c.RELSTRETCH,"⇋":c.WIDEREL,"⇍":c.RELACCENT,"⇎":c.RELACCENT,"⇏":c.RELACCENT,"⇖":c.RELSTRETCH,"⇗":c.RELSTRETCH,"⇘":c.RELSTRETCH,"⇙":c.RELSTRETCH,"⇚":c.WIDEREL,"⇛":c.WIDEREL,"⇜":c.WIDEREL,"⇝":c.WIDEREL,"⇞":c.REL,"⇟":c.REL,"⇠":c.WIDEREL,"⇡":c.RELSTRETCH,"⇢":c.WIDEREL,"⇣":c.RELSTRETCH,"⇤":c.WIDEREL,"⇥":c.WIDEREL,"⇦":c.WIDEREL,"⇧":c.RELSTRETCH,"⇨":c.WIDEREL,"⇩":c.RELSTRETCH,"⇪":c.RELSTRETCH,"⇫":c.RELSTRETCH,"⇬":c.RELSTRETCH,"⇭":c.RELSTRETCH,"⇮":c.RELSTRETCH,"⇯":c.RELSTRETCH,"⇰":c.WIDEREL,"⇱":c.REL,"⇲":c.REL,"⇳":c.RELSTRETCH,"⇴":c.RELACCENT,"⇵":c.RELSTRETCH,"⇶":c.WIDEREL,"⇷":c.RELACCENT,"⇸":c.RELACCENT,"⇹":c.RELACCENT,"⇺":c.RELACCENT,"⇻":c.RELACCENT,"⇼":c.RELACCENT,"⇽":c.WIDEREL,"⇾":c.WIDEREL,"⇿":c.WIDEREL}}});MathJax.Ajax.loadComplete(a.optableDir+"/Arrows.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"⟦":c.OPEN,"⟪":c.OPEN,"⟬":c.OPEN},postfix:{"⟧":c.CLOSE,"⟫":c.CLOSE,"⟭":c.CLOSE}}});MathJax.Ajax.loadComplete(a.optableDir+"/MiscMathSymbolsA.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"❲":c.OPEN},postfix:{"❳":c.CLOSE}}});MathJax.Ajax.loadComplete(a.optableDir+"/Dingbats.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"‖":[0,0,b.ORD,{fence:true,stretchy:true}],"‘":[0,0,b.OPEN,{fence:true}],"“":[0,0,b.OPEN,{fence:true}]},postfix:{"‖":[0,0,b.ORD,{fence:true,stretchy:true}],"’":[0,0,b.CLOSE,{fence:true}],"”":[0,0,b.CLOSE,{fence:true}]}}});MathJax.Ajax.loadComplete(a.optableDir+"/GeneralPunctuation.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{postfix:{"ˍ":c.WIDEACCENT,"˚":c.ACCENT,"˝":c.ACCENT,"˷":c.WIDEACCENT}}});MathJax.Ajax.loadComplete(a.optableDir+"/SpacingModLetters.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{postfix:{"⎴":c.WIDEACCENT,"⎵":c.WIDEACCENT,"⏜":c.WIDEACCENT,"⏝":c.WIDEACCENT,"⏠":c.WIDEACCENT,"⏡":c.WIDEACCENT}}});MathJax.Ajax.loadComplete(a.optableDir+"/MiscTechnical.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{infix:{"⟰":c.RELSTRETCH,"⟱":c.RELSTRETCH,"⟻":c.WIDEREL,"⟽":c.WIDEREL,"⟾":c.WIDEREL,"⟿":c.WIDEREL}}});MathJax.Ajax.loadComplete(a.optableDir+"/SupplementalArrowsA.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{infix:{"϶":c.REL}}});MathJax.Ajax.loadComplete(a.optableDir+"/GreekAndCoptic.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"ⅅ":c.ORD21,"ⅆ":[2,0,b.ORD]}}});MathJax.Ajax.loadComplete(a.optableDir+"/LetterlikeSymbols.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{infix:{"⤀":c.RELACCENT,"⤁":c.RELACCENT,"⤂":c.RELACCENT,"⤃":c.RELACCENT,"⤄":c.RELACCENT,"⤅":c.RELACCENT,"⤆":c.RELACCENT,"⤇":c.RELACCENT,"⤈":c.REL,"⤉":c.REL,"⤊":c.RELSTRETCH,"⤋":c.RELSTRETCH,"⤌":c.WIDEREL,"⤍":c.WIDEREL,"⤎":c.WIDEREL,"⤏":c.WIDEREL,"⤐":c.WIDEREL,"⤑":c.RELACCENT,"⤒":c.RELSTRETCH,"⤓":c.RELSTRETCH,"⤔":c.RELACCENT,"⤕":c.RELACCENT,"⤖":c.RELACCENT,"⤗":c.RELACCENT,"⤘":c.RELACCENT,"⤙":c.RELACCENT,"⤚":c.RELACCENT,"⤛":c.RELACCENT,"⤜":c.RELACCENT,"⤝":c.RELACCENT,"⤞":c.RELACCENT,"⤟":c.RELACCENT,"⤠":c.RELACCENT,"⤡":c.RELSTRETCH,"⤢":c.RELSTRETCH,"⤣":c.REL,"⤤":c.REL,"⤥":c.REL,"⤦":c.REL,"⤧":c.REL,"⤨":c.REL,"⤩":c.REL,"⤪":c.REL,"⤫":c.REL,"⤬":c.REL,"⤭":c.REL,"⤮":c.REL,"⤯":c.REL,"⤰":c.REL,"⤱":c.REL,"⤲":c.REL,"⤳":c.RELACCENT,"⤴":c.REL,"⤵":c.REL,"⤶":c.REL,"⤷":c.REL,"⤸":c.REL,"⤹":c.REL,"⤺":c.RELACCENT,"⤻":c.RELACCENT,"⤼":c.RELACCENT,"⤽":c.RELACCENT,"⤾":c.REL,"⤿":c.REL,"⥀":c.REL,"⥁":c.REL,"⥂":c.RELACCENT,"⥃":c.RELACCENT,"⥄":c.RELACCENT,"⥅":c.RELACCENT,"⥆":c.RELACCENT,"⥇":c.RELACCENT,"⥈":c.RELACCENT,"⥉":c.REL,"⥊":c.RELACCENT,"⥋":c.RELACCENT,"⥌":c.REL,"⥍":c.REL,"⥎":c.WIDEREL,"⥏":c.RELSTRETCH,"⥐":c.WIDEREL,"⥑":c.RELSTRETCH,"⥒":c.WIDEREL,"⥓":c.WIDEREL,"⥔":c.RELSTRETCH,"⥕":c.RELSTRETCH,"⥖":c.RELSTRETCH,"⥗":c.RELSTRETCH,"⥘":c.RELSTRETCH,"⥙":c.RELSTRETCH,"⥚":c.WIDEREL,"⥛":c.WIDEREL,"⥜":c.RELSTRETCH,"⥝":c.RELSTRETCH,"⥞":c.WIDEREL,"⥟":c.WIDEREL,"⥠":c.RELSTRETCH,"⥡":c.RELSTRETCH,"⥢":c.RELACCENT,"⥣":c.REL,"⥤":c.RELACCENT,"⥥":c.REL,"⥦":c.RELACCENT,"⥧":c.RELACCENT,"⥨":c.RELACCENT,"⥩":c.RELACCENT,"⥪":c.RELACCENT,"⥫":c.RELACCENT,"⥬":c.RELACCENT,"⥭":c.RELACCENT,"⥮":c.RELSTRETCH,"⥯":c.RELSTRETCH,"⥰":c.RELACCENT,"⥱":c.RELACCENT,"⥲":c.RELACCENT,"⥳":c.RELACCENT,"⥴":c.RELACCENT,"⥵":c.RELACCENT,"⥶":c.RELACCENT,"⥷":c.RELACCENT,"⥸":c.RELACCENT,"⥹":c.RELACCENT,"⥺":c.RELACCENT,"⥻":c.RELACCENT,"⥼":c.RELACCENT,"⥽":c.RELACCENT,"⥾":c.REL,"⥿":c.REL}}});MathJax.Ajax.loadComplete(a.optableDir+"/SupplementalArrowsB.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"||":[0,0,b.BIN,{fence:true,stretchy:true,symmetric:true}],"|||":[0,0,b.ORD,{fence:true,stretchy:true,symmetric:true}]},postfix:{"!!":[1,0,b.BIN],"'":c.ACCENT,"++":[0,0,b.BIN],"--":[0,0,b.BIN],"..":[0,0,b.BIN],"...":c.ORD,"||":[0,0,b.BIN,{fence:true,stretchy:true,symmetric:true}],"|||":[0,0,b.ORD,{fence:true,stretchy:true,symmetric:true}]},infix:{"!=":c.BIN4,"&&":c.BIN4,"**":[1,1,b.BIN],"*=":c.BIN4,"+=":c.BIN4,"-=":c.BIN4,"->":c.BIN5,"//":[1,1,b.BIN],"/=":c.BIN4,":=":c.BIN4,"<=":c.BIN5,"<>":[1,1,b.BIN],"==":c.BIN4,">=":c.BIN5,"@":c.ORD11,"||":[2,2,b.BIN,{fence:true,stretchy:true,symmetric:true}],"|||":[2,2,b.ORD,{fence:true,stretchy:true,symmetric:true}]}}});MathJax.Ajax.loadComplete(a.optableDir+"/BasicLatin.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{infix:{"⭅":c.RELSTRETCH,"⭆":c.RELSTRETCH}}});MathJax.Ajax.loadComplete(a.optableDir+"/MiscSymbolsAndArrows.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{postfix:{"̑":c.ACCENT}}});MathJax.Ajax.loadComplete(a.optableDir+"/CombDiacritMarks.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{infix:{"■":c.BIN3,"□":c.BIN3,"▪":c.BIN3,"▫":c.BIN3,"▭":c.BIN3,"▮":c.BIN3,"▯":c.BIN3,"▰":c.BIN3,"▱":c.BIN3,"▲":c.BIN4,"▴":c.BIN4,"▶":c.BIN4,"▷":c.BIN4,"▸":c.BIN4,"▼":c.BIN4,"▾":c.BIN4,"◀":c.BIN4,"◁":c.BIN4,"◂":c.BIN4,"◄":c.BIN4,"◅":c.BIN4,"◆":c.BIN4,"◇":c.BIN4,"◈":c.BIN4,"◉":c.BIN4,"◌":c.BIN4,"◍":c.BIN4,"◎":c.BIN4,"●":c.BIN4,"◖":c.BIN4,"◗":c.BIN4,"◦":c.BIN4}}});MathJax.Ajax.loadComplete(a.optableDir+"/GeometricShapes.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"∄":c.ORD21,"∛":c.ORD11,"∜":c.ORD11,"∡":c.ORD,"∢":c.ORD,"∬":c.INTEGRAL,"∭":c.INTEGRAL,"∯":c.INTEGRAL,"∰":c.INTEGRAL,"∱":c.INTEGRAL,"∲":c.INTEGRAL,"∳":c.INTEGRAL},infix:{"∁":[1,2,b.ORD],"∆":c.BIN3,"∊":c.REL,"∌":c.REL,"∍":c.REL,"∎":c.BIN3,"∔":c.BIN4,"∟":c.REL,"∤":c.REL,"∦":c.REL,"∴":c.REL,"∵":c.REL,"∶":c.REL,"∷":c.REL,"∸":c.BIN4,"∹":c.REL,"∺":c.BIN4,"∻":c.REL,"∽":c.REL,"∽̱":c.BIN3,"∾":c.REL,"∿":c.BIN3,"≁":c.REL,"≂":c.REL,"≂̸":c.REL,"≄":c.REL,"≆":c.REL,"≇":c.REL,"≉":c.REL,"≊":c.REL,"≋":c.REL,"≌":c.REL,"≎":c.REL,"≎̸":c.REL,"≏":c.REL,"≏̸":c.REL,"≑":c.REL,"≒":c.REL,"≓":c.REL,"≔":c.REL,"≕":c.REL,"≖":c.REL,"≗":c.REL,"≘":c.REL,"≙":c.REL,"≚":c.REL,"≜":c.REL,"≝":c.REL,"≞":c.REL,"≟":c.REL,"≢":c.REL,"≣":c.REL,"≦":c.REL,"≦̸":c.REL,"≧":c.REL,"≨":c.REL,"≩":c.REL,"≪̸":c.REL,"≫̸":c.REL,"≬":c.REL,"≭":c.REL,"≮":c.REL,"≯":c.REL,"≰":c.REL,"≱":c.REL,"≲":c.REL,"≳":c.REL,"≴":c.REL,"≵":c.REL,"≶":c.REL,"≷":c.REL,"≸":c.REL,"≹":c.REL,"≼":c.REL,"≽":c.REL,"≾":c.REL,"≿":c.REL,"≿̸":c.REL,"⊀":c.REL,"⊁":c.REL,"⊂⃒":c.REL,"⊃⃒":c.REL,"⊄":c.REL,"⊅":c.REL,"⊈":c.REL,"⊉":c.REL,"⊊":c.REL,"⊋":c.REL,"⊌":c.BIN4,"⊍":c.BIN4,"⊏":c.REL,"⊏̸":c.REL,"⊐":c.REL,"⊐̸":c.REL,"⊚":c.BIN4,"⊛":c.BIN4,"⊜":c.BIN4,"⊝":c.BIN4,"⊞":c.BIN4,"⊟":c.BIN4,"⊠":c.BIN4,"⊡":c.BIN4,"⊦":c.REL,"⊧":c.REL,"⊩":c.REL,"⊪":c.REL,"⊫":c.REL,"⊬":c.REL,"⊭":c.REL,"⊮":c.REL,"⊯":c.REL,"⊰":c.REL,"⊱":c.REL,"⊲":c.REL,"⊳":c.REL,"⊴":c.REL,"⊵":c.REL,"⊶":c.REL,"⊷":c.REL,"⊸":c.REL,"⊹":c.REL,"⊺":c.BIN4,"⊻":c.BIN4,"⊼":c.BIN4,"⊽":c.BIN4,"⊾":c.BIN3,"⊿":c.BIN3,"⋇":c.BIN4,"⋉":c.BIN4,"⋊":c.BIN4,"⋋":c.BIN4,"⋌":c.BIN4,"⋍":c.REL,"⋎":c.BIN4,"⋏":c.BIN4,"⋐":c.REL,"⋑":c.REL,"⋒":c.BIN4,"⋓":c.BIN4,"⋔":c.REL,"⋕":c.REL,"⋖":c.REL,"⋗":c.REL,"⋘":c.REL,"⋙":c.REL,"⋚":c.REL,"⋛":c.REL,"⋜":c.REL,"⋝":c.REL,"⋞":c.REL,"⋟":c.REL,"⋠":c.REL,"⋡":c.REL,"⋢":c.REL,"⋣":c.REL,"⋤":c.REL,"⋥":c.REL,"⋦":c.REL,"⋧":c.REL,"⋨":c.REL,"⋩":c.REL,"⋪":c.REL,"⋫":c.REL,"⋬":c.REL,"⋭":c.REL,"⋰":c.REL,"⋲":c.REL,"⋳":c.REL,"⋴":c.REL,"⋵":c.REL,"⋶":c.REL,"⋷":c.REL,"⋸":c.REL,"⋹":c.REL,"⋺":c.REL,"⋻":c.REL,"⋼":c.REL,"⋽":c.REL,"⋾":c.REL,"⋿":c.REL}}});
MathJax.Ajax.loadComplete(a.optableDir+"/MathOperators.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"⦀":[0,0,b.ORD,{fence:true,stretchy:true}],"⦃":c.OPEN,"⦅":c.OPEN,"⦇":c.OPEN,"⦉":c.OPEN,"⦋":c.OPEN,"⦍":c.OPEN,"⦏":c.OPEN,"⦑":c.OPEN,"⦓":c.OPEN,"⦕":c.OPEN,"⦗":c.OPEN,"⧼":c.OPEN},postfix:{"⦀":[0,0,b.ORD,{fence:true,stretchy:true}],"⦄":c.CLOSE,"⦆":c.CLOSE,"⦈":c.CLOSE,"⦊":c.CLOSE,"⦌":c.CLOSE,"⦎":c.CLOSE,"⦐":c.CLOSE,"⦒":c.CLOSE,"⦔":c.CLOSE,"⦖":c.CLOSE,"⦘":c.CLOSE,"⧽":c.CLOSE},infix:{"⦁":c.BIN3,"⦂":c.BIN3,"⦙":c.BIN3,"⦚":c.BIN3,"⦛":c.BIN3,"⦜":c.BIN3,"⦝":c.BIN3,"⦞":c.BIN3,"⦟":c.BIN3,"⦠":c.BIN3,"⦡":c.BIN3,"⦢":c.BIN3,"⦣":c.BIN3,"⦤":c.BIN3,"⦥":c.BIN3,"⦦":c.BIN3,"⦧":c.BIN3,"⦨":c.BIN3,"⦩":c.BIN3,"⦪":c.BIN3,"⦫":c.BIN3,"⦬":c.BIN3,"⦭":c.BIN3,"⦮":c.BIN3,"⦯":c.BIN3,"⦰":c.BIN3,"⦱":c.BIN3,"⦲":c.BIN3,"⦳":c.BIN3,"⦴":c.BIN3,"⦵":c.BIN3,"⦶":c.BIN4,"⦷":c.BIN4,"⦸":c.BIN4,"⦹":c.BIN4,"⦺":c.BIN4,"⦻":c.BIN4,"⦼":c.BIN4,"⦽":c.BIN4,"⦾":c.BIN4,"⦿":c.BIN4,"⧀":c.REL,"⧁":c.REL,"⧂":c.BIN3,"⧃":c.BIN3,"⧄":c.BIN4,"⧅":c.BIN4,"⧆":c.BIN4,"⧇":c.BIN4,"⧈":c.BIN4,"⧉":c.BIN3,"⧊":c.BIN3,"⧋":c.BIN3,"⧌":c.BIN3,"⧍":c.BIN3,"⧎":c.REL,"⧏":c.REL,"⧏̸":c.REL,"⧐":c.REL,"⧐̸":c.REL,"⧑":c.REL,"⧒":c.REL,"⧓":c.REL,"⧔":c.REL,"⧕":c.REL,"⧖":c.BIN4,"⧗":c.BIN4,"⧘":c.BIN3,"⧙":c.BIN3,"⧛":c.BIN3,"⧜":c.BIN3,"⧝":c.BIN3,"⧞":c.REL,"⧟":c.BIN3,"⧠":c.BIN3,"⧡":c.REL,"⧢":c.BIN4,"⧣":c.REL,"⧤":c.REL,"⧥":c.REL,"⧦":c.REL,"⧧":c.BIN3,"⧨":c.BIN3,"⧩":c.BIN3,"⧪":c.BIN3,"⧫":c.BIN3,"⧬":c.BIN3,"⧭":c.BIN3,"⧮":c.BIN3,"⧯":c.BIN3,"⧰":c.BIN3,"⧱":c.BIN3,"⧲":c.BIN3,"⧳":c.BIN3,"⧴":c.REL,"⧵":c.BIN4,"⧶":c.BIN4,"⧷":c.BIN4,"⧸":c.BIN3,"⧹":c.BIN3,"⧺":c.BIN3,"⧻":c.BIN3,"⧾":c.BIN4,"⧿":c.BIN4}}});MathJax.Ajax.loadComplete(a.optableDir+"/MiscMathSymbolsB.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{prefix:{"⨃":c.OP,"⨅":c.OP,"⨇":c.OP,"⨈":c.OP,"⨉":c.OP,"⨊":c.OP,"⨋":c.INTEGRAL2,"⨌":c.INTEGRAL,"⨍":c.INTEGRAL2,"⨎":c.INTEGRAL2,"⨏":c.INTEGRAL2,"⨐":c.OP,"⨑":c.OP,"⨒":c.OP,"⨓":c.OP,"⨔":c.OP,"⨕":c.INTEGRAL2,"⨖":c.INTEGRAL2,"⨗":c.INTEGRAL2,"⨘":c.INTEGRAL2,"⨙":c.INTEGRAL2,"⨚":c.INTEGRAL2,"⨛":c.INTEGRAL2,"⨜":c.INTEGRAL2,"⫼":c.OP,"⫿":c.OP},infix:{"⨝":c.BIN3,"⨞":c.BIN3,"⨟":c.BIN3,"⨠":c.BIN3,"⨡":c.BIN3,"⨢":c.BIN4,"⨣":c.BIN4,"⨤":c.BIN4,"⨥":c.BIN4,"⨦":c.BIN4,"⨧":c.BIN4,"⨨":c.BIN4,"⨩":c.BIN4,"⨪":c.BIN4,"⨫":c.BIN4,"⨬":c.BIN4,"⨭":c.BIN4,"⨮":c.BIN4,"⨰":c.BIN4,"⨱":c.BIN4,"⨲":c.BIN4,"⨳":c.BIN4,"⨴":c.BIN4,"⨵":c.BIN4,"⨶":c.BIN4,"⨷":c.BIN4,"⨸":c.BIN4,"⨹":c.BIN4,"⨺":c.BIN4,"⨻":c.BIN4,"⨼":c.BIN4,"⨽":c.BIN4,"⨾":c.BIN4,"⩀":c.BIN4,"⩁":c.BIN4,"⩂":c.BIN4,"⩃":c.BIN4,"⩄":c.BIN4,"⩅":c.BIN4,"⩆":c.BIN4,"⩇":c.BIN4,"⩈":c.BIN4,"⩉":c.BIN4,"⩊":c.BIN4,"⩋":c.BIN4,"⩌":c.BIN4,"⩍":c.BIN4,"⩎":c.BIN4,"⩏":c.BIN4,"⩐":c.BIN4,"⩑":c.BIN4,"⩒":c.BIN4,"⩓":c.BIN4,"⩔":c.BIN4,"⩕":c.BIN4,"⩖":c.BIN4,"⩗":c.BIN4,"⩘":c.BIN4,"⩙":c.REL,"⩚":c.BIN4,"⩛":c.BIN4,"⩜":c.BIN4,"⩝":c.BIN4,"⩞":c.BIN4,"⩟":c.BIN4,"⩠":c.BIN4,"⩡":c.BIN4,"⩢":c.BIN4,"⩣":c.BIN4,"⩤":c.BIN4,"⩥":c.BIN4,"⩦":c.REL,"⩧":c.REL,"⩨":c.REL,"⩩":c.REL,"⩪":c.REL,"⩫":c.REL,"⩬":c.REL,"⩭":c.REL,"⩮":c.REL,"⩯":c.REL,"⩰":c.REL,"⩱":c.BIN4,"⩲":c.BIN4,"⩳":c.REL,"⩴":c.REL,"⩵":c.REL,"⩶":c.REL,"⩷":c.REL,"⩸":c.REL,"⩹":c.REL,"⩺":c.REL,"⩻":c.REL,"⩼":c.REL,"⩽":c.REL,"⩽̸":c.REL,"⩾":c.REL,"⩾̸":c.REL,"⩿":c.REL,"⪀":c.REL,"⪁":c.REL,"⪂":c.REL,"⪃":c.REL,"⪄":c.REL,"⪅":c.REL,"⪆":c.REL,"⪇":c.REL,"⪈":c.REL,"⪉":c.REL,"⪊":c.REL,"⪋":c.REL,"⪌":c.REL,"⪍":c.REL,"⪎":c.REL,"⪏":c.REL,"⪐":c.REL,"⪑":c.REL,"⪒":c.REL,"⪓":c.REL,"⪔":c.REL,"⪕":c.REL,"⪖":c.REL,"⪗":c.REL,"⪘":c.REL,"⪙":c.REL,"⪚":c.REL,"⪛":c.REL,"⪜":c.REL,"⪝":c.REL,"⪞":c.REL,"⪟":c.REL,"⪠":c.REL,"⪡":c.REL,"⪡̸":c.REL,"⪢":c.REL,"⪢̸":c.REL,"⪣":c.REL,"⪤":c.REL,"⪥":c.REL,"⪦":c.REL,"⪧":c.REL,"⪨":c.REL,"⪩":c.REL,"⪪":c.REL,"⪫":c.REL,"⪬":c.REL,"⪭":c.REL,"⪮":c.REL,"⪯̸":c.REL,"⪰̸":c.REL,"⪱":c.REL,"⪲":c.REL,"⪳":c.REL,"⪴":c.REL,"⪵":c.REL,"⪶":c.REL,"⪷":c.REL,"⪸":c.REL,"⪹":c.REL,"⪺":c.REL,"⪻":c.REL,"⪼":c.REL,"⪽":c.REL,"⪾":c.REL,"⪿":c.REL,"⫀":c.REL,"⫁":c.REL,"⫂":c.REL,"⫃":c.REL,"⫄":c.REL,"⫅":c.REL,"⫆":c.REL,"⫇":c.REL,"⫈":c.REL,"⫉":c.REL,"⫊":c.REL,"⫋":c.REL,"⫌":c.REL,"⫍":c.REL,"⫎":c.REL,"⫏":c.REL,"⫐":c.REL,"⫑":c.REL,"⫒":c.REL,"⫓":c.REL,"⫔":c.REL,"⫕":c.REL,"⫖":c.REL,"⫗":c.REL,"⫘":c.REL,"⫙":c.REL,"⫚":c.REL,"⫛":c.REL,"⫝̸":c.REL,"⫝":c.REL,"⫞":c.REL,"⫟":c.REL,"⫠":c.REL,"⫡":c.REL,"⫢":c.REL,"⫣":c.REL,"⫤":c.REL,"⫥":c.REL,"⫦":c.REL,"⫧":c.REL,"⫨":c.REL,"⫩":c.REL,"⫪":c.REL,"⫫":c.REL,"⫬":c.REL,"⫭":c.REL,"⫮":c.REL,"⫯":c.REL,"⫰":c.REL,"⫱":c.REL,"⫲":c.REL,"⫳":c.REL,"⫴":c.BIN4,"⫵":c.BIN4,"⫶":c.BIN4,"⫷":c.REL,"⫸":c.REL,"⫹":c.REL,"⫺":c.REL,"⫻":c.BIN4,"⫽":c.BIN4,"⫾":c.BIN3}}});MathJax.Ajax.loadComplete(a.optableDir+"/SuppMathOperators.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{postfix:{"⃛":c.ACCENT,"⃜":c.ACCENT}}});MathJax.Ajax.loadComplete(a.optableDir+"/CombDiactForSymbols.js")})(MathJax.ElementJax.mml);(function(a){var c=a.mo.OPTYPES;var b=a.TEXCLASS;MathJax.Hub.Insert(a.mo.prototype,{OPTABLE:{postfix:{"°":c.ORD,"´":c.ACCENT,"¸":c.ACCENT}}});MathJax.Ajax.loadComplete(a.optableDir+"/Latin1Supplement.js")})(MathJax.ElementJax.mml);(function(c,b){var d="2.4.0";var a=MathJax.Hub.CombineConfig("MatchWebFonts",{matchFor:{"HTML-CSS":true,NativeMML:true,SVG:true},fontCheckDelay:500,fontCheckTimeout:15*1e3});MathJax.Extension.MatchWebFonts={version:d,config:a};c.Register.StartupHook("HTML-CSS Jax Ready",function(){var e=MathJax.OutputJax["HTML-CSS"];var f=e.postTranslate;e.Augment({postTranslate:function(h,g){if(!g&&a.matchFor["HTML-CSS"]&&this.config.matchFontHeight){b.timer.start(b,["checkFonts",this,h.jax[this.id]],a.fontCheckDelay,a.fontCheckTimeout)}return f.apply(this,arguments)},checkFonts:function(k,o){if(k.time(function(){})){return}var s=[],p,l,g=false;for(p=0,l=o.length;p<l;p++){script=o[p];if(script.parentNode&&script.MathJax.elementJax){script.parentNode.insertBefore(this.EmExSpan.cloneNode(true),script)}}for(p=0,l=o.length;p<l;p++){script=o[p];if(!script.parentNode){continue}g=true;var h=script.MathJax.elementJax;if(!h){continue}var r=script.previousSibling;var q=r.firstChild.offsetHeight/60;var j=r.lastChild.lastChild.offsetHeight/60;if(q===0||q==="NaN"){q=this.defaultEx;j=this.defaultEm}if(q!==h.HTMLCSS.ex||j!==h.HTMLCSS.em){var n=q/this.TeX.x_height/j;n=Math.floor(Math.max(this.config.minScaleAdjust/100,n)*this.config.scale);if(n/100!==h.scale){s.push(script);o[p]={}}}}o=o.concat(s);for(p=0,l=o.length;p<l;p++){script=o[p];if(script&&script.parentNode&&script.MathJax.elementJax){script.parentNode.removeChild(script.previousSibling)}}if(s.length){c.Queue(["Rerender",c,[s],{}])}if(g){setTimeout(k,k.delay)}}})});c.Register.StartupHook("SVG Jax Ready",function(){var f=MathJax.OutputJax.SVG;var e=f.postTranslate;f.Augment({postTranslate:function(h,g){if(!g&&a.matchFor.SVG){b.timer.start(b,["checkFonts",this,h.jax[this.id]],a.fontCheckDelay,a.fontCheckTimeout)}return e.apply(this,arguments)},checkFonts:function(j,l){if(j.time(function(){})){return}var q=[],n,k,g=false;for(n=0,k=l.length;n<k;n++){script=l[n];if(script.parentNode&&script.MathJax.elementJax){script.parentNode.insertBefore(this.ExSpan.cloneNode(true),script)}}for(n=0,k=l.length;n<k;n++){script=l[n];if(!script.parentNode){continue}g=true;var h=script.MathJax.elementJax;if(!h){continue}var p=script.previousSibling;var o=p.firstChild.offsetHeight/60;if(o===0||o==="NaN"){o=this.defaultEx}if(o!==h.SVG.ex){q.push(script);l[n]={}}}l=l.concat(q);for(n=0,k=l.length;n<k;n++){script=l[n];if(script.parentNode&&script.MathJax.elementJax){script.parentNode.removeChild(script.previousSibling)}}if(q.length){c.Queue(["Rerender",c,[q],{}])}if(g){setTimeout(j,j.delay)}}})});c.Register.StartupHook("NativeMML Jax Ready",function(){var e=MathJax.OutputJax.NativeMML;var f=e.postTranslate;e.Augment({postTranslate:function(g){if(!c.Browser.isMSIE&&a.matchFor.NativeMML){b.timer.start(b,["checkFonts",this,g.jax[this.id]],a.fontCheckDelay,a.fontCheckTimeout)}f.apply(this,arguments)},checkFonts:function(A,l){if(A.time(function(){})){return}var t=[],q=[],o=[],w,s,B;for(w=0,s=l.length;w<s;w++){B=l[w];if(B.parentNode&&B.MathJax.elementJax){B.parentNode.insertBefore(this.EmExSpan.cloneNode(true),B)}}for(w=0,s=l.length;w<s;w++){B=l[w];if(!B.parentNode){continue}var g=B.MathJax.elementJax;if(!g){continue}var v=document.getElementById(g.inputID+"-Frame");var k=v.getElementsByTagName("math")[0];if(!k){continue}g=g.NativeMML;var y=B.previousSibling;var z=y.firstChild.offsetWidth/60;var h=y.lastChild.offsetWidth/60;if(z===0||z==="NaN"){z=this.defaultEx;h=this.defaultMEx}var r=z!==g.ex;if(r||h!=g.mex){var C=this.config.matchFontHeight&&h>1?z/h:1;C=Math.floor(Math.max(this.config.minScaleAdjust/100,C)*this.config.scale);if(C/100!==g.scale){o.push([v.style,C])}g.scale=C/100;g.fontScale=C+"%";g.ex=z;g.mex=h}if("scrollWidth"in g&&(r||g.scrollWidth!==k.firstChild.scrollWidth)){g.scrollWidth=k.firstChild.scrollWidth;t.push([k.parentNode.style,g.scrollWidth/g.ex/g.scale])}if(k.MathJaxMtds){for(var u=0,p=k.MathJaxMtds.length;u<p;u++){if(!k.MathJaxMtds[u].parentNode){continue}if(r||k.MathJaxMtds[u].firstChild.scrollWidth!==g.mtds[u]){g.mtds[u]=k.MathJaxMtds[u].firstChild.scrollWidth;q.push([k.MathJaxMtds[u],g.mtds[u]/g.ex])}}}}for(w=0,s=l.length;w<s;w++){B=l[w];if(B.parentNode&&B.MathJax.elementJax){B.parentNode.removeChild(B.previousSibling)}}for(w=0,s=o.length;w<s;w++){o[w][0].fontSize=o[w][1]+"%"}for(w=0,s=t.length;w<s;w++){t[w][0].width=t[w][1].toFixed(3)+"ex"}for(w=0,s=q.length;w<s;w++){var x=q[w][0].getAttribute("style");x=x.replace(/(($|;)\s*min-width:).*?ex/,"$1 "+q[w][1].toFixed(3)+"ex");q[w][0].setAttribute("style",x)}setTimeout(A,A.delay)}})});c.Startup.signal.Post("MatchWebFonts Extension Ready");b.loadComplete("[MathJax]/extensions/MatchWebFonts.js")})(MathJax.Hub,MathJax.Ajax);(function(d,f,g,c,h){var e=MathJax.Extension.Help={version:"2.4.0"};var b="http://www.stixfonts.org/";var a=MathJax.Menu;var i=d.CombineConfig("HelpDialog",{closeImg:g.urlRev(c.imageDir+"/CloseX-31.png"),styles:{"#MathJax_Help":{position:"fixed",left:"50%",width:"auto","max-width":"90%","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"wrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_HelpContent":{overflow:"auto","text-align":"left","font-size":"80%",padding:".4em .6em",border:"1px inset",margin:"1em 0px","max-height":"20em","max-width":"30em","background-color":"#EEEEEE"}}});e.Dialog=function(){h.loadDomain("HelpDialog",["Post",e])};e.Post=function(){this.div=a.Background(this);var j=f.addElement(this.div,"div",{id:"MathJax_Help"},h._("HelpDialog",[["b",{style:{fontSize:"120%"}},[["Help","MathJax Help"]]],["div",{id:"MathJax_HelpContent"},[["p",{},[["MathJax","*MathJax* is a JavaScript library that allows page authors to include mathematics within their web pages.  As a reader, you don't need to do anything to make that happen."]]],["p",{},[["Browsers","*Browsers*: MathJax works with all modern browsers including IE6+, Firefox 3+, Chrome 0.2+, Safari 2+, Opera 9.6+ and most mobile browsers."]]],["p",{},[["Menu","*Math Menu*: MathJax adds a contextual menu to equations.  Right-click or CTRL-click on any mathematics to access the menu."]]],["div",{style:{"margin-left":"1em"}},[["p",{},[["ShowMath","*Show Math As* allows you to view the formula's source markup for copy & paste (as MathML or in its origianl format)."]]],["p",{},[["Settings","*Settings* gives you control over features of MathJax, such as the size of the mathematics, and the mechanism used to display equations."]]],["p",{},[["Language","*Language* lets you select the language used by MathJax for its menus and warning messages."]]]]],["p",{},[["Zoom","*Math Zoom*: If you are having difficulty reading an equation, MathJax can enlarge it to help you see it better."]]],["p",{},[["Accessibilty","*Accessibility*: MathJax will automatically work with screen readers to make mathematics accessible to the visually impaired."]]],["p",{},[["Fonts","*Fonts*: MathJax will use certain math fonts if they are installed on your computer; otherwise, it will use web-based fonts.  Although not required, locally installed fonts will speed up typesetting.  We suggest installing the [STIX fonts](%1).",b]]]]],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]],["img",{src:i.closeImg,style:{width:"21px",height:"21px",position:"absolute",top:".2em",right:".2em"},onclick:e.Remove}]]));h.setCSS(j);var l=document.documentElement||{};var k=window.innerHeight||l.clientHeight||l.scrollHeight||0;if(a.prototype.msieAboutBug){j.style.width="20em";j.style.position="absolute";j.style.left=Math.floor((document.documentElement.scrollWidth-j.offsetWidth)/2)+"px";j.style.top=Math.floor((k-j.offsetHeight)/3)+document.body.scrollTop+"px"}else{j.style.marginLeft=Math.floor(-j.offsetWidth/2)+"px";j.style.top=Math.floor((k-j.offsetHeight)/3)+"px"}};e.Remove=function(j){if(e.div){document.body.removeChild(e.div);delete e.div}};MathJax.Callback.Queue(d.Register.StartupHook("End Config",{}),["Styles",g,i.styles],["Post",d.Startup.signal,"HelpDialig Ready"],["loadComplete",g,"[MathJax]/extensions/HelpDialog.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax,MathJax.Localization);MathJax.Hub.Register.StartupHook("SVG Jax Ready",function(){MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{305:[443,0,278,26,255,"247 0Q232 3 143 3Q132 3 106 3T56 1L34 0H26V46H42Q70 46 91 49Q100 53 102 60T104 102V205V293Q104 345 102 359T88 378Q74 385 41 385H30V408Q30 431 32 431L42 432Q52 433 70 434T106 436Q123 437 142 438T171 441T182 442H185V62Q190 52 197 50T232 46H255V0H247"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/LatinExtendedA.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{9824:[727,131,778,55,723,"181 -21Q134 -21 96 27T55 193Q55 224 58 247T82 317T143 410Q172 443 234 498Q282 543 314 598T360 687T380 725Q386 727 389 727Q395 727 398 725T406 716T413 702T423 677T439 641Q481 556 544 498Q633 420 678 353T723 204Q723 142 711 94T669 12T590 -21Q520 -21 490 8T459 66V70H409V62Q409 22 416 -17T430 -82T437 -112Q437 -131 407 -131Q403 -131 397 -131T389 -130T382 -130T372 -131Q341 -131 341 -111Q341 -107 348 -82T362 -18T369 62V70H319V66Q319 57 314 44T297 16T257 -10T191 -21H181"],9825:[716,33,778,55,723,"55 490Q55 557 71 604T114 674T167 706T222 716Q279 716 322 684T389 605Q391 610 395 617T414 643T447 677T494 704T555 716Q642 716 682 652T723 490Q723 455 718 426T684 342T602 227Q573 196 537 161T485 110T449 63T412 -8Q408 -22 404 -27T389 -33Q382 -33 379 -31T372 -23T366 -8T355 18T335 54Q319 81 298 104T239 163T176 227Q102 310 79 371T55 490ZM198 674Q143 664 119 613T95 491Q95 415 137 346Q174 282 265 194T384 48L389 39Q391 42 397 54T406 71T415 86T427 104T442 122T464 146T491 172Q571 249 613 303Q683 396 683 487Q683 581 649 631Q613 676 556 676Q495 676 457 634T410 538Q407 514 390 514Q386 514 380 517Q372 520 369 536T355 581T319 635Q277 675 223 675H217H208L204 674Q200 674 198 674"],9826:[727,162,778,55,723,"370 714Q370 717 375 722T388 727Q398 727 403 721T417 697Q420 692 421 689Q536 465 709 304Q723 291 723 282T709 260Q529 93 406 -153Q402 -162 390 -162H389Q379 -162 376 -158T357 -125Q247 89 89 241L64 265Q55 272 55 282Q55 287 57 290T64 300T77 312T98 331T127 361Q197 435 258 523T344 663L370 714ZM655 299Q568 384 508 470T389 662L376 638Q362 613 341 577T289 497T215 399T123 299L105 282L123 265Q210 180 270 94T389 -98L402 -74Q416 -49 437 -13T489 67T563 165T655 265L673 282L655 299"],9827:[726,131,778,28,750,"213 532Q213 615 265 670T389 726Q461 726 513 671T565 532Q565 511 562 492T553 458T541 432T526 409T512 393T498 379L490 371L511 326Q512 326 516 330T528 341T546 353T572 363T606 368Q664 368 707 315T750 174Q750 87 699 33T579 -22Q567 -22 553 -20T517 -10T479 16T459 63V70H409V62Q409 22 416 -17T430 -82T437 -112Q437 -131 407 -131Q403 -131 397 -131T389 -130T382 -130T372 -131Q341 -131 341 -111Q341 -107 348 -82T362 -18T369 62V70H319V63Q315 25 281 2T197 -22Q132 -22 80 32T28 174Q28 255 69 311T175 368Q192 368 207 364T232 353T250 341T262 331T267 326L288 371L280 378Q272 385 267 391T253 407T238 430T226 457T217 492T213 532"],9837:[750,22,389,55,332,"200 467Q254 467 293 428T332 321Q332 147 104 -11L88 -22H75Q62 -22 56 -16L55 362V647Q55 743 60 748Q63 750 76 750H83Q87 750 95 744V434L104 440Q144 467 200 467ZM237 322Q237 360 225 388T183 417Q158 417 134 407T101 378Q96 370 96 349T95 197V34Q152 91 194 167T237 322"],9838:[734,223,389,65,324,"65 721Q78 734 94 734Q100 734 104 727V444L116 449Q129 454 157 465T208 486Q313 527 314 527Q318 527 324 521V-210Q306 -223 294 -223Q289 -223 284 -216V-13L270 -18Q257 -24 231 -34T180 -54Q77 -96 74 -96T65 -90V721ZM104 13Q282 84 283 85Q284 85 284 252Q284 418 283 418L230 396L140 360L104 346V13"],9839:[723,223,389,55,333,"101 -223Q94 -223 93 -217T91 -188V-151Q91 -88 90 -88Q87 -88 80 -92T68 -96Q62 -96 56 -90L55 -50V-22Q55 -8 58 -4T78 5L91 10V177Q91 343 90 343Q87 343 80 339T68 335Q62 335 56 341L55 381V409Q55 423 58 427T78 436L91 441V543V616Q91 643 93 648T106 656Q119 662 126 659Q130 657 130 645T131 554V456L257 503V607L258 710L260 712Q261 715 272 719T286 723Q293 723 295 715T297 671V617Q297 519 298 519Q301 519 307 522T319 526Q327 526 333 521V437L330 435Q328 432 312 427L297 421V254Q297 88 298 88Q301 88 307 91T319 95Q327 95 333 90V6L330 4Q328 1 312 -4L297 -10V-78V-122Q297 -145 295 -149T282 -156Q274 -160 268 -160Q257 -160 257 -130V-89V-25L131 -72V-210Q123 -215 116 -218T104 -222L101 -223ZM257 72V406L131 359V25L257 72"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/MiscSymbols.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{730:[715,-542,500,147,352,"147 628Q147 669 179 692T244 715Q298 715 325 689T352 629Q352 592 323 567T249 542Q202 542 175 567T147 628ZM313 628Q313 660 300 669T259 678H253Q248 678 242 678T234 679Q217 679 207 674T192 659T188 644T187 629Q187 600 198 590Q210 579 250 579H265Q279 579 288 581T305 595T313 628"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/SpacingModLetters.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{915:[680,0,625,25,582,"128 619Q121 626 117 628T101 631T58 634H25V680H554V676Q556 670 568 560T582 444V440H542V444Q542 445 538 478T523 545T492 598Q454 634 349 634H334Q264 634 249 633T233 621Q232 618 232 339L233 61Q240 54 245 52T270 48T333 46H360V0H348Q324 3 182 3Q51 3 36 0H25V46H58Q100 47 109 49T128 61V619"],916:[716,0,833,46,786,"51 0Q46 4 46 7Q46 9 215 357T388 709Q391 716 416 716Q439 716 444 709Q447 705 616 357T786 7Q786 4 781 0H51ZM507 344L384 596L137 92L383 91H630Q630 93 507 344"],920:[705,23,778,56,722,"56 340Q56 423 86 494T164 610T270 680T388 705Q521 705 621 601T722 341Q722 260 693 191T617 75T510 4T388 -22T267 3T160 74T85 189T56 340ZM610 339Q610 428 590 495T535 598T463 651T384 668Q332 668 289 638T221 566Q168 485 168 339Q168 274 176 235Q189 158 228 105T324 28Q356 16 388 16Q415 16 442 24T501 54T555 111T594 205T610 339ZM223 263V422H263V388H514V422H554V263H514V297H263V263H223"],923:[716,0,694,32,661,"320 708Q326 716 340 716H348H355Q367 716 372 708Q374 706 423 547T523 226T575 62Q581 52 591 50T634 46H661V0H653Q644 3 532 3Q411 3 390 0H379V46H392Q464 46 464 65Q463 70 390 305T316 539L246 316Q177 95 177 84Q177 72 198 59T248 46H253V0H245Q230 3 130 3Q47 3 38 0H32V46H45Q112 51 127 91Q128 92 224 399T320 708"],926:[677,0,667,42,624,"47 509L55 676Q55 677 333 677T611 676L619 509Q619 508 599 508T579 510Q579 529 575 557T564 589Q550 594 333 594T102 589Q95 586 91 558T87 510Q87 508 67 508T47 509ZM139 260V445H179V394H487V445H527V260H487V311H179V260H139ZM50 0L42 180H62Q82 180 82 178Q82 133 89 105Q92 93 95 90T108 86Q137 83 333 83Q530 83 558 86Q568 87 571 90T577 105Q584 133 584 178Q584 180 604 180H624L616 0H50"],928:[680,0,750,25,724,"128 619Q121 626 117 628T101 631T58 634H25V680H724V634H691Q651 633 640 631T622 619V61Q628 51 639 49T691 46H724V0H713Q692 3 569 3Q434 3 425 0H414V46H447Q489 47 498 49T517 61V634H232V348L233 61Q239 51 250 49T302 46H335V0H324Q303 3 180 3Q45 3 36 0H25V46H58Q100 47 109 49T128 61V619"],931:[683,0,722,55,666,"666 247Q664 244 652 126T638 4V0H351Q131 0 95 0T57 5V6Q54 12 57 17L73 36Q89 54 121 90T182 159L305 299L56 644L55 658Q55 677 60 681Q63 683 351 683H638V679Q640 674 652 564T666 447V443H626V447Q618 505 604 543T559 605Q529 626 478 631T333 637H294H189L293 494Q314 465 345 422Q400 346 400 340Q400 338 399 337L154 57Q407 57 428 58Q476 60 508 68T551 83T575 103Q595 125 608 162T624 225L626 251H666V247"],933:[705,0,778,55,722,"55 551Q55 604 91 654T194 705Q240 705 277 681T334 624T367 556T385 498L389 474L392 488Q394 501 400 521T414 566T438 615T473 659T521 692T584 705Q620 705 648 689T691 647T714 597T722 551Q722 540 719 538T699 536Q680 536 677 541Q677 542 677 544T676 548Q676 576 650 596T588 616H582Q538 616 505 582Q466 543 454 477T441 318Q441 301 441 269T442 222V61Q448 55 452 53T478 48T542 46H569V0H557Q533 3 389 3T221 0H209V46H236Q256 46 270 46T295 47T311 48T322 51T328 54T332 57T337 61V209Q337 383 333 415Q313 616 189 616Q154 616 128 597T101 548Q101 540 97 538T78 536Q63 536 59 538T55 551"],934:[683,0,722,55,665,"312 622Q310 623 307 625T303 629T297 631T286 634T270 635T246 636T211 637H184V683H196Q220 680 361 680T526 683H538V637H511Q468 637 447 635T422 631T411 622V533L425 531Q525 519 595 466T665 342Q665 301 642 267T583 209T506 172T425 152L411 150V61Q417 55 421 53T447 48T511 46H538V0H526Q502 3 361 3T196 0H184V46H211Q231 46 245 46T270 47T286 48T297 51T303 54T307 57T312 61V150H310Q309 151 289 153T232 166T160 195Q149 201 136 210T103 238T69 284T56 342Q56 414 128 467T294 530Q309 532 310 533H312V622ZM170 342Q170 207 307 188H312V495H309Q301 495 282 491T231 469T186 423Q170 389 170 342ZM415 188Q487 199 519 236T551 342Q551 384 539 414T507 459T470 481T434 491T415 495H410V188H415"],936:[683,0,778,55,722,"340 622Q338 623 335 625T331 629T325 631T314 634T298 635T274 636T239 637H212V683H224Q248 680 389 680T554 683H566V637H539Q479 637 464 635T439 622L438 407Q438 192 439 192Q443 193 449 195T474 207T507 232T536 276T557 344Q560 365 562 417T573 493Q587 536 620 544Q627 546 671 546H715L722 540V515Q714 509 708 509Q680 505 671 476T658 392T644 307Q599 177 451 153L438 151V106L439 61Q446 54 451 52T476 48T539 46H566V0H554Q530 3 389 3T224 0H212V46H239Q259 46 273 46T298 47T314 48T325 51T331 54T335 57T340 61V151Q126 178 117 406Q115 503 69 509Q55 509 55 526Q55 541 59 543T86 546H107H120Q150 546 161 543T184 528Q198 514 204 493Q212 472 213 420T226 316T272 230Q287 216 303 207T330 194L339 192Q340 192 340 407V622"],937:[705,0,722,44,677,"55 454Q55 503 75 546T127 617T197 665T272 695T337 704H352Q396 704 404 703Q527 687 596 615T666 454Q666 392 635 330T559 200T499 83V80H543Q589 81 600 83T617 93Q622 102 629 135T636 172L637 177H677V175L660 89Q645 3 644 2V0H552H488Q461 0 456 3T451 20Q451 89 499 235T548 455Q548 512 530 555T483 622T424 656T361 668Q332 668 303 658T243 626T193 560T174 456Q174 380 222 233T270 20Q270 7 263 0H77V2Q76 3 61 89L44 175V177H84L85 172Q85 171 88 155T96 119T104 93Q109 86 120 84T178 80H222V83Q206 132 162 199T87 329T55 454"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/GreekAndCoptic.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{8463:[695,13,540,42,562,"182 599Q182 611 174 615T133 619Q118 619 114 621T109 630Q109 636 114 656T122 681Q125 685 202 688Q272 695 286 695Q304 695 304 684Q304 682 295 644T282 597Q282 592 360 592H399Q430 592 445 587T460 563Q460 552 451 541L442 535H266L251 468Q247 453 243 436T236 409T233 399Q233 395 244 404Q295 441 357 441Q405 441 445 417T485 333Q485 284 449 178T412 58T426 44Q447 44 466 68Q485 87 500 130L509 152H531H543Q562 152 562 144Q562 128 546 93T494 23T415 -13Q385 -13 359 3T322 44Q318 52 318 77Q318 99 352 196T386 337Q386 386 346 386Q318 386 286 370Q267 361 245 338T211 292Q207 287 193 235T162 113T138 21Q128 7 122 4Q105 -12 83 -12Q66 -12 54 -2T42 26L166 530Q166 534 161 534T129 535Q127 535 122 535T112 534Q74 534 74 562Q74 570 77 576T84 585T96 589T109 591T124 592T138 592L182 595V599"],8465:[705,10,722,55,693,"55 507Q55 589 116 647T260 705Q395 705 526 541Q542 522 549 517T567 512Q595 512 621 521T647 550Q647 553 647 555T650 558T653 560T657 561T661 561T665 561T670 561Q681 561 685 561T691 558T693 548Q693 515 657 495T565 475Q518 475 481 495T418 543T371 599T320 647T259 667Q194 667 148 622T102 508Q102 468 119 436T164 385T220 357T273 347Q282 347 284 344T287 329Q287 317 285 314T272 310Q193 310 124 364T55 507ZM420 312Q420 367 464 399T564 431Q613 431 651 406T693 336Q693 325 689 323T667 320Q654 320 651 322T647 335Q645 360 622 376T566 393H563Q557 393 551 391T537 381T523 356T517 312Q517 287 535 265T574 229T613 190T631 132Q628 74 586 37T487 -9Q478 -10 417 -10H387Q344 -10 310 4T215 69Q130 142 71 146Q59 146 57 149T55 163Q55 177 58 180T75 183H108Q177 183 207 170T306 93Q346 56 368 40T420 13Q474 25 503 60T533 136Q533 160 516 182T477 219T438 257T420 304V312"],8467:[706,20,417,7,397,"345 104T349 104T361 95T369 80T352 59Q268 -20 206 -20Q170 -20 146 3T113 53T99 104L94 129Q94 130 79 116T48 86T28 70Q22 70 15 79T7 94Q7 98 12 103T58 147L91 179V185Q91 186 91 191T92 200Q92 282 128 400T223 612T336 705Q397 705 397 636V627Q397 453 194 233Q185 223 180 218T174 211T171 208T165 201L163 186Q159 142 159 123Q159 17 208 17Q228 17 253 30T293 56T335 94Q345 104 349 104ZM360 634Q360 655 354 661T336 668Q328 668 322 666T302 645T272 592Q252 547 229 467T192 330L179 273Q179 272 186 280T204 300T221 322Q327 453 355 590Q360 612 360 634"],8472:[453,216,636,67,625,"300 74Q300 133 338 133Q350 133 356 126T363 109Q363 88 340 76Q340 71 342 62T358 39T393 26Q435 26 474 67T532 182T551 290Q551 325 535 349T484 373Q430 373 378 348T291 289T228 218T187 157T174 130Q254 30 265 10Q276 -15 276 -41Q276 -101 235 -158T142 -216Q112 -216 90 -195T67 -118Q67 -40 104 64L110 81Q81 118 81 174Q81 268 134 360T247 453Q252 453 255 451T258 447L259 445Q259 432 253 420Q251 416 242 416Q209 411 176 341T142 203Q142 193 143 184T146 170T149 165L158 180Q215 280 303 345T485 410Q548 410 586 368T625 255Q625 157 553 74T389 -10H383Q349 -10 325 14Q302 37 300 74ZM105 -123Q105 -134 106 -141T110 -158T122 -173T145 -178Q155 -178 160 -176Q184 -163 199 -132T214 -73Q214 -69 214 -66T213 -59T212 -53T209 -47T205 -41T199 -33T193 -25T184 -14T174 -1L165 10Q156 22 148 32L139 43Q138 43 130 15T113 -54T105 -123"],8476:[716,22,722,40,715,"300 614L306 620Q311 626 316 631T332 646T356 663T386 679T425 695T473 707T531 715Q534 715 543 715T557 716Q570 716 572 714Q574 713 644 580T715 444Q715 441 713 439Q712 438 677 419T602 379T549 354L550 348Q550 337 555 238T561 128Q561 122 560 115T559 101Q559 63 591 25L599 18L631 51Q665 85 671 85Q674 85 687 78T702 68Q704 63 702 59Q702 58 659 20T613 -21Q612 -22 598 -22Q556 -22 526 -8T484 27T466 66T461 101Q461 110 462 116T463 129Q463 135 458 232T452 331V338H343V280Q342 195 333 157Q316 64 267 12Q233 -22 193 -22Q155 -22 122 2T72 74Q72 76 70 76T67 74T60 74T48 82Q40 91 40 95Q40 100 42 102T57 109V113Q57 118 66 127T81 137Q88 137 93 123Q105 127 108 126Q111 124 118 117T127 107Q127 101 123 98T113 93T107 90Q107 86 115 71T143 37T189 15H192Q230 15 239 96Q244 135 244 334Q244 510 242 542Q236 584 233 596Q223 630 205 649T166 668Q136 668 118 642T100 584Q100 567 110 554T137 522T166 486Q194 446 194 401V389Q189 243 114 243Q91 243 77 260T59 294T55 322Q55 331 59 333T75 336T91 334T95 322Q95 280 113 280Q134 280 140 305T147 375V391Q147 417 139 435T101 487Q56 540 56 572V580Q56 630 86 667T169 704Q214 704 247 676T300 614ZM324 562Q326 555 330 539T336 515T340 484T343 427V384H424L505 385Q537 396 584 422L609 435Q610 435 594 465T550 550Q536 575 520 605T496 650L488 664L476 662Q348 633 324 562"],8501:[694,0,611,55,555,"55 613Q55 643 61 663T74 688T85 694Q94 694 94 681Q98 632 134 588L412 285Q416 311 430 397T447 509V519L438 526Q407 554 398 571T388 617T394 664T407 688T418 694Q425 694 427 684Q429 675 454 635T488 586Q490 584 496 579T513 563T537 540Q555 516 555 487Q555 460 549 441T537 416T528 409Q519 409 517 415T513 435T503 463Q492 481 490 481Q454 264 454 246Q454 237 479 212T529 152T555 79Q555 32 538 9Q531 1 524 1Q516 1 516 13Q512 62 476 106Q468 115 337 258T195 412L193 406Q191 401 189 394T183 377T176 352T171 322T167 284T165 240Q165 224 166 220Q171 199 211 152T252 70Q252 45 235 29T203 8T175 1Q170 0 115 0H79Q60 0 58 3T55 20Q55 31 58 34Q60 37 76 37Q112 39 126 46T140 70Q140 96 112 148T83 236Q83 281 102 334T140 419T159 452Q55 556 55 613"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/LetterlikeSymbols.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{567:[443,205,306,-55,218,"28 -163Q58 -168 64 -168Q124 -168 135 -77Q137 -65 137 141T136 353Q132 371 120 377T72 385H52V408Q52 431 54 431L58 432Q62 432 70 432T87 433T108 434T133 436Q151 437 171 438T202 441T214 442H218V184Q217 -36 217 -59T211 -98Q195 -145 153 -175T58 -205Q9 -205 -23 -179T-55 -117Q-55 -94 -40 -79T-2 -64T36 -79T52 -118Q52 -143 28 -163"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/LatinExtendedB.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{33:[716,-1,278,78,199,"78 661Q78 682 96 699T138 716T180 700T199 661Q199 654 179 432T158 206Q156 198 139 198Q121 198 119 206Q118 209 98 431T78 661ZM79 61Q79 89 97 105T141 121Q164 119 181 104T198 61Q198 31 181 16T139 1Q114 1 97 16T79 61"],34:[694,-379,500,34,372,"34 634Q34 659 50 676T93 694Q121 694 144 668T168 579Q168 525 146 476T101 403T73 379Q69 379 60 388T50 401Q50 404 62 417T88 448T116 500T131 572Q131 584 130 584T125 581T112 576T94 573Q69 573 52 590T34 634ZM238 634Q238 659 254 676T297 694Q325 694 348 668T372 579Q372 525 350 476T305 403T277 379Q273 379 264 388T254 401Q254 404 266 417T292 448T320 500T335 572Q335 584 334 584T329 581T316 576T298 573Q273 573 256 590T238 634"],35:[694,194,833,56,778,"56 347Q56 360 70 367H313L355 524Q394 676 401 686Q406 694 416 694Q434 694 436 676Q436 672 396 522Q355 374 355 369L354 367H543L585 524Q626 679 630 685Q636 694 646 694Q653 694 659 689T665 678Q665 668 626 522Q585 374 585 369L584 367H762Q777 359 777 347Q777 334 767 331T722 327H667H572L552 251L531 174Q531 173 647 173H720Q756 173 766 170T777 153T762 133H519L477 -24Q436 -179 432 -185Q426 -194 416 -194Q409 -194 403 -189T397 -177Q397 -167 436 -21Q477 125 477 131L478 133H289L247 -24Q206 -179 202 -185Q196 -194 186 -194Q179 -194 173 -189T167 -177Q167 -167 206 -21Q247 125 247 131L248 133H70Q56 140 56 153Q56 168 72 173H260L280 249L301 326Q301 327 186 327H72Q56 332 56 347ZM531 326Q531 327 437 327H342L322 251L301 174Q301 173 395 173H490L510 249L531 326"],36:[750,56,500,55,444,"162 187Q162 164 146 149T109 133H103V130Q108 115 115 105Q122 92 131 82T150 64T170 52T190 44T206 40T220 37L227 36V313Q190 320 162 335Q116 358 86 404T55 508Q55 567 85 614T165 685Q186 696 225 704H227V750H273V704L286 703Q369 690 413 631Q441 588 444 531Q444 514 443 509Q439 490 425 479T391 468Q368 468 353 483T337 522Q337 546 353 560T390 575L394 576V578Q386 599 372 614T342 637T314 649T288 656L273 658V408L288 405Q329 394 355 376Q396 348 420 300T444 199Q444 130 408 76T313 1Q286 -9 276 -9H273V-56H227V-10H221Q202 -6 193 -4T155 11T108 41T74 94T55 176V182Q55 227 95 238Q103 240 108 240Q129 240 145 226T162 187ZM225 657Q219 657 204 651T169 632T135 594T121 538Q121 512 131 491T156 457T187 435T213 423T227 420V539Q227 657 225 657ZM378 169Q378 230 339 265T274 301Q273 301 273 169V37Q324 50 351 87T378 169"],37:[750,56,833,56,777,"465 605Q428 605 394 614T340 632T319 641Q332 608 332 548Q332 458 293 403T202 347Q145 347 101 402T56 548Q56 637 101 693T202 750Q241 750 272 719Q359 642 464 642Q580 642 650 732Q662 748 668 749Q670 750 673 750Q682 750 688 743T693 726Q178 -47 170 -52Q166 -56 160 -56Q147 -56 142 -45Q137 -36 142 -27Q143 -24 363 304Q469 462 525 546T581 630Q528 605 465 605ZM207 385Q235 385 263 427T292 548Q292 617 267 664T200 712Q193 712 186 709T167 698T147 668T134 615Q132 595 132 548V527Q132 436 165 403Q183 385 203 385H207ZM500 146Q500 234 544 290T647 347Q699 347 737 292T776 146T737 0T646 -56Q590 -56 545 0T500 146ZM651 -18Q679 -18 707 24T736 146Q736 215 711 262T644 309Q637 309 630 306T611 295T591 265T578 212Q577 200 577 146V124Q577 -18 647 -18H651"],38:[716,22,778,42,727,"156 540Q156 620 201 668T302 716Q354 716 377 671T401 578Q401 505 287 386L274 373Q309 285 416 148L429 132L437 142Q474 191 543 309L562 341V349Q562 368 541 376T498 385H493V431H502L626 428Q709 428 721 431H727V385H712Q688 384 669 379T639 369T618 354T603 337T591 316T578 295Q537 223 506 176T464 117T454 104Q454 102 471 85T497 62Q543 24 585 24Q618 24 648 48T682 113V121H722V112Q721 94 714 75T692 32T646 -7T574 -22Q491 -19 414 42L402 51L391 42Q312 -22 224 -22Q144 -22 93 25T42 135Q42 153 46 169T55 197T74 225T96 249T125 278T156 308L195 347L190 360Q185 372 182 382T174 411T165 448T159 491T156 540ZM361 576Q361 613 348 646T305 679Q272 679 252 649T232 572Q232 497 255 426L259 411L267 420Q361 519 361 576ZM140 164Q140 103 167 64T240 24Q271 24 304 36T356 61T374 77Q295 156 235 262L220 292L210 310L193 293Q177 277 169 268T151 229T140 164"],39:[694,-379,278,78,212,"78 634Q78 659 95 676T138 694Q166 694 189 668T212 579Q212 525 190 476T146 403T118 379Q114 379 105 388T95 401Q95 404 107 417T133 448T161 500T176 572Q176 584 175 584T170 581T157 576T139 573Q114 573 96 590T78 634"],42:[750,-320,500,64,436,"215 721Q216 732 225 741T248 750Q263 750 273 742T284 721L270 571L327 613Q383 654 388 657T399 660Q412 660 423 650T435 624T424 600T376 575Q363 569 355 566L289 534L355 504L424 470Q435 462 435 447Q435 431 424 420T399 409Q393 409 388 412T327 456L270 498L277 423L284 348Q280 320 250 320T215 348L229 498L172 456Q116 415 111 412T100 409Q87 409 76 420T64 447Q64 461 75 470L144 504L210 534L144 566Q136 570 122 576Q83 593 74 600T64 624Q64 639 75 649T100 660Q106 660 111 657T172 613L229 571Q229 578 222 643T215 721"],45:[252,-179,333,11,277,"11 179V252H277V179H11"],63:[705,-1,472,55,417,"226 668Q190 668 162 656T124 632L114 621Q116 621 119 620T130 616T145 607T157 591T162 567Q162 544 147 529T109 514T71 528T55 566Q55 625 100 661T199 704Q201 704 210 704T224 705H228Q281 705 320 692T378 656T407 612T416 567Q416 503 361 462Q267 395 247 303Q242 279 242 241V224Q242 205 239 202T222 198T205 201T202 218V249Q204 320 220 371T255 445T292 491T315 537Q317 546 317 574V587Q317 604 315 615T304 640T277 661T226 668ZM162 61Q162 89 180 105T224 121Q247 119 264 104T281 61Q281 31 264 16T222 1Q197 1 180 16T162 61"],64:[705,11,778,56,722,"56 347Q56 429 86 498T164 612T270 680T386 705Q522 705 622 603T722 349Q722 126 608 126Q541 126 513 176Q512 177 512 179T510 182L509 183Q508 183 503 177T487 163T464 146T429 132T385 126Q311 126 251 186T190 347Q190 448 251 508T385 568Q426 568 460 548T509 511T531 479H555Q580 479 582 478Q586 477 587 468Q588 454 588 338V260Q588 200 593 182T619 163Q641 163 655 178T674 223T680 273T682 325V330Q682 426 647 500Q611 569 544 618T388 668Q271 668 184 577T96 347Q96 216 180 121T396 26Q421 26 446 28T493 34T535 43T573 52T605 63T629 72T647 80T657 84H716Q722 78 722 74Q722 65 675 45T547 7T392 -11Q255 -11 156 90T56 347ZM274 347Q274 266 308 214T390 162Q420 162 449 182T498 235L504 245V449L498 459Q453 532 387 532Q347 532 311 483T274 347"],65:[716,0,750,32,717,"255 0Q240 3 140 3Q48 3 39 0H32V46H47Q119 49 139 88Q140 91 192 245T295 553T348 708Q351 716 366 716H376Q396 715 400 709Q402 707 508 390L617 67Q624 54 636 51T687 46H717V0H708Q699 3 581 3Q458 3 437 0H427V46H440Q510 46 510 64Q510 66 486 138L462 209H229L209 150Q189 91 189 85Q189 72 209 59T259 46H264V0H255ZM447 255L345 557L244 256Q244 255 345 255H447"],66:[683,0,708,28,651,"131 622Q124 629 120 631T104 634T61 637H28V683H229H267H346Q423 683 459 678T531 651Q574 627 599 590T624 512Q624 461 583 419T476 360L466 357Q539 348 595 302T651 187Q651 119 600 67T469 3Q456 1 242 0H28V46H61Q103 47 112 49T131 61V622ZM511 513Q511 560 485 594T416 636Q415 636 403 636T371 636T333 637Q266 637 251 636T232 628Q229 624 229 499V374H312L396 375L406 377Q410 378 417 380T442 393T474 417T499 456T511 513ZM537 188Q537 239 509 282T430 336L329 337H229V200V116Q229 57 234 52Q240 47 334 47H383Q425 47 443 53Q486 67 511 104T537 188"],67:[705,21,722,56,666,"56 342Q56 428 89 500T174 615T283 681T391 705Q394 705 400 705T408 704Q499 704 569 636L582 624L612 663Q639 700 643 704Q644 704 647 704T653 705H657Q660 705 666 699V419L660 413H626Q620 419 619 430Q610 512 571 572T476 651Q457 658 426 658Q322 658 252 588Q173 509 173 342Q173 221 211 151Q232 111 263 84T328 45T384 29T428 24Q517 24 571 93T626 244Q626 251 632 257H660L666 251V236Q661 133 590 56T403 -21Q262 -21 159 83T56 342"],68:[683,0,764,27,708,"130 622Q123 629 119 631T103 634T60 637H27V683H228Q399 682 419 682T461 676Q504 667 546 641T626 573T685 470T708 336Q708 210 634 116T442 3Q429 1 228 0H27V46H60Q102 47 111 49T130 61V622ZM593 338Q593 439 571 501T493 602Q439 637 355 637H322H294Q238 637 234 628Q231 624 231 344Q231 62 232 59Q233 49 248 48T339 46H350Q456 46 515 95Q561 133 577 191T593 338"],69:[680,0,681,25,652,"128 619Q121 626 117 628T101 631T58 634H25V680H597V676Q599 670 611 560T625 444V440H585V444Q584 447 582 465Q578 500 570 526T553 571T528 601T498 619T457 629T411 633T353 634Q266 634 251 633T233 622Q233 622 233 621Q232 619 232 497V376H286Q359 378 377 385Q413 401 416 469Q416 471 416 473V493H456V213H416V233Q415 268 408 288T383 317T349 328T297 330Q290 330 286 330H232V196V114Q232 57 237 52Q243 47 289 47H340H391Q428 47 452 50T505 62T552 92T584 146Q594 172 599 200T607 247T612 270V273H652V270Q651 267 632 137T610 3V0H25V46H58Q100 47 109 49T128 61V619"],70:[680,0,653,25,610,"128 619Q121 626 117 628T101 631T58 634H25V680H582V676Q584 670 596 560T610 444V440H570V444Q563 493 561 501Q555 538 543 563T516 601T477 622T431 631T374 633H334H286Q252 633 244 631T233 621Q232 619 232 490V363H284Q287 363 303 363T327 364T349 367T372 373T389 385Q407 403 410 459V480H450V200H410V221Q407 276 389 296Q381 303 371 307T348 313T327 316T303 317T284 317H232V189L233 61Q240 54 245 52T270 48T333 46H360V0H348Q324 3 182 3Q51 3 36 0H25V46H58Q100 47 109 49T128 61V619"],71:[705,22,785,56,735,"56 342Q56 428 89 500T174 615T283 681T391 705Q394 705 400 705T408 704Q499 704 569 636L582 624L612 663Q639 700 643 704Q644 704 647 704T653 705H657Q660 705 666 699V419L660 413H626Q620 419 619 430Q610 512 571 572T476 651Q457 658 426 658Q401 658 376 654T316 633T254 592T205 519T177 411Q173 369 173 335Q173 259 192 201T238 111T302 58T370 31T431 24Q478 24 513 45T559 100Q562 110 562 160V212Q561 213 557 216T551 220T542 223T526 225T502 226T463 227H437V273H449L609 270Q715 270 727 273H735V227H721Q674 227 668 215Q666 211 666 108V6Q660 0 657 0Q653 0 639 10Q617 25 600 42L587 54Q571 27 524 3T406 -22Q317 -22 238 22T108 151T56 342"],72:[683,0,750,25,724,"128 622Q121 629 117 631T101 634T58 637H25V683H36Q57 680 180 680Q315 680 324 683H335V637H302Q262 636 251 634T233 622L232 500V378H517V622Q510 629 506 631T490 634T447 637H414V683H425Q446 680 569 680Q704 680 713 683H724V637H691Q651 636 640 634T622 622V61Q628 51 639 49T691 46H724V0H713Q692 3 569 3Q434 3 425 0H414V46H447Q489 47 498 49T517 61V332H232V197L233 61Q239 51 250 49T302 46H335V0H324Q303 3 180 3Q45 3 36 0H25V46H58Q100 47 109 49T128 61V622"],73:[683,0,361,21,339,"328 0Q307 3 180 3T32 0H21V46H43Q92 46 106 49T126 60Q128 63 128 342Q128 620 126 623Q122 628 118 630T96 635T43 637H21V683H32Q53 680 180 680T328 683H339V637H317Q268 637 254 634T234 623Q232 620 232 342Q232 63 234 60Q238 55 242 53T264 48T317 46H339V0H328"],74:[683,22,514,25,465,"89 177Q115 177 133 160T152 112Q152 88 137 72T102 52Q99 51 101 49Q106 43 129 29Q159 15 190 15Q232 15 256 48T286 126Q286 127 286 142T286 183T286 238T287 306T287 378Q287 403 287 429T287 479T287 524T286 563T286 593T286 614V621Q281 630 263 633T182 637H154V683H166Q187 680 332 680Q439 680 457 683H465V637H449Q422 637 401 634Q393 631 389 623Q388 621 388 376T387 123Q377 61 322 20T194 -22Q188 -22 177 -21T160 -20Q96 -9 61 29T25 110Q25 144 44 160T89 177"],75:[683,0,778,25,736,"128 622Q121 629 117 631T101 634T58 637H25V683H36Q57 680 180 680Q315 680 324 683H335V637H313Q235 637 233 620Q232 618 232 462L233 307L379 449Q425 494 479 546Q518 584 524 591T531 607V608Q531 630 503 636Q501 636 498 636T493 637H489V683H499Q517 680 630 680Q704 680 716 683H722V637H708Q633 633 589 597Q584 592 495 506T406 419T515 254T631 80Q644 60 662 54T715 46H736V0H728Q719 3 615 3Q493 3 472 0H461V46H469Q515 46 515 72Q515 78 512 84L336 351Q332 348 278 296L232 251V156Q232 62 235 58Q243 47 302 46H335V0H324Q303 3 180 3Q45 3 36 0H25V46H58Q100 47 109 49T128 61V622"],76:[683,0,625,25,582,"128 622Q121 629 117 631T101 634T58 637H25V683H36Q48 680 182 680Q324 680 348 683H360V637H333Q273 637 258 635T233 622L232 342V129Q232 57 237 52Q243 47 313 47Q384 47 410 53Q470 70 498 110T536 221Q536 226 537 238T540 261T542 272T562 273H582V268Q580 265 568 137T554 5V0H25V46H58Q100 47 109 49T128 61V622"],77:[683,0,917,29,887,"132 622Q125 629 121 631T105 634T62 637H29V683H135Q221 683 232 682T249 675Q250 674 354 398L458 124L562 398Q666 674 668 675Q671 681 683 682T781 683H887V637H854Q814 636 803 634T785 622V61Q791 51 802 49T854 46H887V0H876Q855 3 736 3Q605 3 596 0H585V46H618Q660 47 669 49T688 61V347Q688 424 688 461T688 546T688 613L687 632Q454 14 450 7Q446 1 430 1T410 7Q409 9 292 316L176 624V606Q175 588 175 543T175 463T175 356L176 86Q187 50 261 46H278V0H269Q254 3 154 3Q52 3 37 0H29V46H46Q78 48 98 56T122 69T132 86V622"],78:[683,0,750,25,724,"42 46Q74 48 94 56T118 69T128 86V634H124Q114 637 52 637H25V683H232L235 680Q237 679 322 554T493 303L578 178V598Q572 608 568 613T544 627T492 637H475V683H483Q498 680 600 680Q706 680 715 683H724V637H707Q634 633 622 598L621 302V6L614 0H600Q585 0 582 3T481 150T282 443T171 605V345L172 86Q183 50 257 46H274V0H265Q250 3 150 3Q48 3 33 0H25V46H42"],79:[705,23,778,56,722,"56 340Q56 423 86 494T164 610T270 680T388 705Q521 705 621 601T722 341Q722 260 693 191T617 75T510 4T388 -22T267 3T160 74T85 189T56 340ZM467 647Q426 665 388 665Q360 665 331 654T269 620T213 549T179 439Q174 411 174 354Q174 144 277 61Q327 20 385 20H389H391Q474 20 537 99Q603 188 603 354Q603 411 598 439Q577 592 467 647"],80:[684,0,681,27,624,"130 622Q123 629 119 631T103 634T60 637H27V683H214Q237 683 276 683T331 684Q419 684 471 671T567 616Q624 563 624 489Q624 421 573 372T451 307Q429 302 328 301H234V181Q234 62 237 58Q245 47 304 46H337V0H326Q305 3 182 3Q47 3 38 0H27V46H60Q102 47 111 49T130 61V622ZM507 488Q507 514 506 528T500 564T483 597T450 620T397 635Q385 637 307 637H286Q237 637 234 628Q231 624 231 483V342H302H339Q390 342 423 349T481 382Q507 411 507 488"],81:[705,193,778,56,728,"56 341Q56 499 157 602T388 705Q521 705 621 601T722 341Q722 275 703 218T660 127T603 63T555 25T525 9Q524 8 524 8H523Q524 5 526 -1T537 -21T555 -47T581 -67T615 -76Q653 -76 678 -56T706 -3Q707 10 716 10Q721 10 728 5L727 -13Q727 -88 697 -140T606 -193Q563 -193 538 -166T498 -83Q483 -23 483 -8L471 -11Q459 -14 435 -18T388 -22Q254 -22 155 81T56 341ZM607 339Q607 429 586 496T531 598T461 649T390 665T318 649T248 598T192 496T170 339Q170 143 277 57Q301 39 305 39L304 42Q304 44 304 46Q301 53 301 68Q301 101 325 128T391 155Q454 155 495 70L501 58Q549 91 578 164Q607 234 607 339ZM385 18Q404 18 425 23T459 33T472 40Q471 47 468 57T449 88T412 115Q398 117 386 117Q367 117 353 102T338 67Q338 48 351 33T385 18"],82:[683,22,736,27,732,"130 622Q123 629 119 631T103 634T60 637H27V683H202H236H300Q376 683 417 677T500 648Q595 600 609 517Q610 512 610 501Q610 468 594 439T556 392T511 361T472 343L456 338Q459 335 467 332Q497 316 516 298T545 254T559 211T568 155T578 94Q588 46 602 31T640 16H645Q660 16 674 32T692 87Q692 98 696 101T712 105T728 103T732 90Q732 59 716 27T672 -16Q656 -22 630 -22Q481 -16 458 90Q456 101 456 163T449 246Q430 304 373 320L363 322L297 323H231V192L232 61Q238 51 249 49T301 46H334V0H323Q302 3 181 3Q59 3 38 0H27V46H60Q102 47 111 49T130 61V622ZM491 499V509Q491 527 490 539T481 570T462 601T424 623T362 636Q360 636 340 636T304 637H283Q238 637 234 628Q231 624 231 492V360H289Q390 360 434 378T489 456Q491 467 491 499"],83:[705,22,556,55,500,"55 507Q55 590 112 647T243 704H257Q342 704 405 641L426 672Q431 679 436 687T446 700L449 704Q450 704 453 704T459 705H463Q466 705 472 699V462L466 456H448Q437 456 435 459T430 479Q413 605 329 646Q292 662 254 662Q201 662 168 626T135 542Q135 508 152 480T200 435Q210 431 286 412T370 389Q427 367 463 314T500 191Q500 110 448 45T301 -21Q245 -21 201 -4T140 27L122 41Q118 36 107 21T87 -7T78 -21Q76 -22 68 -22H64Q61 -22 55 -16V101Q55 220 56 222Q58 227 76 227H89Q95 221 95 214Q95 182 105 151T139 90T205 42T305 24Q352 24 386 62T420 155Q420 198 398 233T340 281Q284 295 266 300Q261 301 239 306T206 314T174 325T141 343T112 367T85 402Q55 451 55 507"],84:[677,0,722,36,685,"36 443Q37 448 46 558T55 671V677H666V671Q667 666 676 556T685 443V437H645V443Q645 445 642 478T631 544T610 593Q593 614 555 625Q534 630 478 630H451H443Q417 630 414 618Q413 616 413 339V63Q420 53 439 50T528 46H558V0H545L361 3Q186 1 177 0H164V46H194Q264 46 283 49T309 63V339V550Q309 620 304 625T271 630H244H224Q154 630 119 601Q101 585 93 554T81 486T76 443V437H36V443"],85:[683,22,750,25,724,"128 622Q121 629 117 631T101 634T58 637H25V683H36Q57 680 180 680Q315 680 324 683H335V637H302Q262 636 251 634T233 622L232 418V291Q232 189 240 145T280 67Q325 24 389 24Q454 24 506 64T571 183Q575 206 575 410V598Q569 608 565 613T541 627T489 637H472V683H481Q496 680 598 680T715 683H724V637H707Q634 633 622 598L621 399Q620 194 617 180Q617 179 615 171Q595 83 531 31T389 -22Q304 -22 226 33T130 192Q129 201 128 412V622"],86:[683,22,750,19,730,"114 620Q113 621 110 624T107 627T103 630T98 632T91 634T80 635T67 636T48 637H19V683H28Q46 680 152 680Q273 680 294 683H305V637H284Q223 634 223 620Q223 618 313 372T404 126L490 358Q575 588 575 597Q575 616 554 626T508 637H503V683H512Q527 680 627 680Q718 680 724 683H730V637H723Q648 637 627 596Q627 595 515 291T401 -14Q396 -22 382 -22H374H367Q353 -22 348 -14Q346 -12 231 303Q114 617 114 620"],87:[683,22,1028,18,1009,"792 683Q810 680 914 680Q991 680 1003 683H1009V637H996Q931 633 915 598Q912 591 863 438T766 135T716 -17Q711 -22 694 -22Q676 -22 673 -15Q671 -13 593 231L514 477L435 234Q416 174 391 92T358 -6T341 -22H331Q314 -21 310 -15Q309 -14 208 302T104 622Q98 632 87 633Q73 637 35 637H18V683H27Q69 681 154 681Q164 681 181 681T216 681T249 682T276 683H287H298V637H285Q213 637 213 620Q213 616 289 381L364 144L427 339Q490 535 492 546Q487 560 482 578T475 602T468 618T461 628T449 633T433 636T408 637H380V683H388Q397 680 508 680Q629 680 650 683H660V637H647Q576 637 576 619L727 146Q869 580 869 600Q869 605 863 612T839 627T794 637H783V683H792"],88:[683,0,750,23,726,"270 0Q252 3 141 3Q46 3 31 0H23V46H40Q129 50 161 88Q165 94 244 216T324 339Q324 341 235 480T143 622Q133 631 119 634T57 637H37V683H46Q64 680 172 680Q297 680 318 683H329V637H324Q307 637 286 632T263 621Q263 618 322 525T384 431Q385 431 437 511T489 593Q490 595 490 599Q490 611 477 622T436 637H428V683H437Q455 680 566 680Q661 680 676 683H684V637H667Q585 634 551 599Q548 596 478 491Q412 388 412 387Q412 385 514 225T620 62Q628 53 642 50T695 46H726V0H717Q699 3 591 3Q466 3 445 0H434V46H440Q454 46 476 51T499 64Q499 67 463 124T390 238L353 295L350 292Q348 290 343 283T331 265T312 236T286 195Q219 88 218 84Q218 70 234 59T272 46H280V0H270"],89:[683,0,750,11,738,"518 0Q497 3 374 3Q253 3 232 0H221V46H254Q313 47 321 58Q324 62 324 167V273L221 446Q117 620 114 623Q106 631 91 634T31 637H11V683H20Q29 680 148 680Q273 680 294 683H305V637H287Q239 636 236 621Q236 619 321 475L407 332L483 460Q502 492 527 534Q563 594 563 604Q563 632 517 637H508V683H517H525Q533 683 545 683T571 682T600 681T626 681Q695 681 731 683H738V637H723Q640 633 613 588Q612 587 517 427L425 273V169V95Q425 66 428 59T444 49Q459 46 506 46H528V0H518"],90:[683,0,611,55,560,"69 443Q69 452 74 554T80 683H549Q555 677 555 664Q555 649 554 648Q552 645 366 348T179 50T192 49T263 49H275H302Q333 49 353 50T401 59T447 78T482 115T507 173Q513 200 520 273V282H560V274Q560 272 552 143T543 8V0H302L61 1L58 3Q55 8 55 21V35Q59 43 153 193T340 489T432 637H343Q259 637 214 625T141 573Q109 523 109 445Q109 443 89 443H69"],95:[-25,62,500,0,499,"0 -62V-25H499V-62H0"],96:[699,-505,500,106,296,"106 655Q106 671 119 685T150 699Q166 699 177 688Q190 671 222 629T275 561T295 533T282 519L267 505L196 563Q119 626 113 634Q106 643 106 655"],126:[318,-215,500,83,416,"179 251Q164 251 151 245T131 234T111 215L97 227L83 238Q83 239 95 253T121 283T142 304Q165 318 187 318T253 300T320 282Q335 282 348 288T368 299T388 318L402 306L416 295Q375 236 344 222Q330 215 313 215Q292 215 248 233T179 251"]});
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/BasicLatin.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{768:[699,-505,0,-394,-204,"-394 655Q-394 671 -381 685T-350 699Q-334 699 -323 688Q-310 671 -278 629T-225 561T-205 533T-218 519L-233 505L-304 563Q-381 626 -387 634Q-394 643 -394 655"],769:[699,-505,0,-297,-107,"-151 699Q-133 699 -120 686T-107 656Q-107 651 -108 647T-113 637T-120 627T-133 616T-149 602T-170 585T-197 563L-268 505L-283 519Q-297 533 -296 533Q-296 534 -271 567T-218 636T-187 678L-184 681Q-182 684 -179 686T-172 692T-163 697T-151 699"],770:[694,-531,0,-388,-113,"-388 560L-251 694L-243 686Q-113 562 -113 560L-139 531Q-141 532 -197 581L-250 627L-305 580Q-318 569 -331 557T-352 538L-360 532Q-362 530 -375 546L-388 560"],771:[668,-565,0,-417,-84,"-321 601Q-336 601 -349 595T-369 584T-389 565L-403 577L-417 588Q-417 589 -405 603T-379 633T-358 654Q-335 668 -313 668T-247 650T-180 632Q-165 632 -152 638T-132 649T-112 668L-98 656L-84 645Q-125 586 -156 572Q-170 565 -187 565Q-208 565 -252 583T-321 601"],772:[590,-544,0,-431,-70,"-431 544V590H-70V544H-431"],774:[694,-515,0,-408,-93,"-250 515Q-321 515 -362 565T-408 683V694H-371V689Q-371 688 -371 683T-370 675Q-363 631 -331 599T-252 567Q-196 567 -163 608T-130 689V694H-93V683Q-97 617 -139 566T-250 515"],775:[669,-549,0,-310,-191,"-310 609Q-310 637 -292 653T-248 669Q-225 667 -208 652T-191 609Q-191 579 -208 564T-250 549Q-275 549 -292 564T-310 609"],776:[669,-554,0,-405,-95,"-405 612Q-405 633 -388 651T-347 669T-307 652T-290 612Q-290 588 -306 571T-348 554L-373 560Q-405 577 -405 612ZM-211 611Q-211 634 -196 649T-165 668Q-164 668 -160 668T-154 669Q-131 669 -114 652T-96 612T-113 572T-154 554Q-177 554 -194 570T-211 611"],778:[715,-542,0,-353,-148,"-353 628Q-353 669 -321 692T-256 715Q-202 715 -175 689T-148 629Q-148 592 -177 567T-251 542Q-298 542 -325 567T-353 628ZM-187 628Q-187 660 -200 669T-241 678H-247Q-252 678 -258 678T-266 679Q-283 679 -293 674T-308 659T-312 644T-313 629Q-313 600 -302 590Q-290 579 -250 579H-235Q-221 579 -212 581T-195 595T-187 628"],779:[701,-510,0,-378,-80,"-292 701Q-278 701 -262 690T-246 658Q-246 649 -250 641Q-252 637 -297 574T-344 510L-378 528Q-378 530 -355 598T-327 676Q-316 701 -292 701ZM-126 701Q-112 701 -96 690T-80 658Q-80 649 -84 641Q-86 637 -131 574T-178 510L-212 528Q-212 530 -189 598T-161 676Q-150 701 -126 701"],780:[644,-513,0,-386,-115,"-386 611L-373 630L-364 644Q-362 644 -307 612Q-252 581 -250 581L-194 612Q-139 644 -137 644L-115 611L-182 562L-251 513L-386 611"],824:[716,215,0,-639,-140,"-612 -215T-619 -215T-631 -212T-637 -204T-639 -197Q-639 -190 -634 -183Q-621 -157 -400 274T-176 707Q-173 716 -160 716Q-153 716 -148 712T-142 703T-140 696Q-140 691 -372 241T-608 -212Q-612 -215 -619 -215"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/CombDiacritMarks.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{9651:[716,0,889,59,828,"75 0L72 2Q69 3 67 5T62 11T59 20Q59 24 62 30Q65 37 245 370T428 707Q428 708 430 710T436 714T444 716Q451 716 455 712Q459 710 644 368L828 27V20Q828 7 814 0H75ZM610 347L444 653Q443 653 278 347T113 40H775Q775 42 610 347"],9657:[505,5,500,26,473,"26 489Q33 505 43 505Q51 505 260 385Q464 266 471 259Q473 257 473 250Q473 242 469 239Q459 231 260 115Q51 -5 43 -5Q39 -5 35 -1T28 7L26 11V489ZM412 250L67 450Q66 450 66 250T67 50Q69 51 240 150T412 250"],9661:[500,215,889,59,828,"59 480Q59 485 61 489T66 495T72 498L75 500H814Q828 493 828 480V474L644 132Q458 -210 455 -212Q451 -215 444 -215T433 -212Q429 -210 342 -49T164 282T64 466Q59 478 59 480ZM775 460H113Q113 459 278 153T444 -153T610 153T775 460"],9667:[505,5,500,26,473,"473 10Q466 -5 454 -5Q451 -5 445 -3Q444 -3 343 56T140 173T35 234Q26 239 26 250T35 266Q40 269 240 384T445 503Q451 505 453 505Q466 505 473 490V10ZM433 50T433 250T432 450T259 351T87 250T258 150T432 50Q433 50 433 250"],9711:[715,215,1e3,56,944,"56 250Q56 353 95 442T196 589T335 681T491 715Q573 715 635 693Q694 673 747 635T846 543T917 412T944 250Q944 58 815 -78T500 -215Q457 -215 429 -210Q274 -183 165 -56T56 250ZM500 -176Q664 -176 784 -54T904 250Q904 418 799 536T543 674Q534 675 493 675Q425 675 357 647T229 567T133 432T96 250Q96 160 129 80T217 -56T346 -144T500 -176"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/GeometricShapes.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{8710:[716,0,833,46,786,""]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/MathOperators.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Main,{10815:[683,0,750,28,721,"28 660Q28 676 31 679T46 683H50Q87 681 182 681Q217 681 247 681T294 682T315 682Q321 682 323 682T328 679T331 673T332 660Q332 643 328 640T304 637Q239 637 231 626Q229 620 229 334V46H520V334Q520 620 518 626Q510 637 445 637Q426 637 422 640T417 660Q417 675 420 678T432 682H435Q437 682 467 682T569 681T671 681T703 682Q714 682 717 679T721 660Q721 643 717 640T693 637Q628 637 620 626Q619 623 619 342Q619 60 620 57Q628 46 693 46Q714 46 717 43T721 23Q721 5 715 1Q713 0 374 0Q36 0 34 1Q28 5 28 23Q28 40 31 43T56 46Q121 46 129 57Q131 63 131 342Q131 620 129 626Q121 637 56 637Q35 637 32 640T28 660"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Regular/SuppMathOperators.js");MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS={directory:"AMS/Regular",family:"MathJax_AMS",id:"MJAMS",Ranges:[[128,255,"Latin1Supplement"],[256,383,"LatinExtendedA"],[688,767,"SpacingModLetters"],[768,879,"CombDiacritMarks"],[880,1023,"GreekAndCoptic"],[8192,8303,"GeneralPunctuation"],[8448,8527,"LetterlikeSymbols"],[8592,8703,"Arrows"],[8704,8959,"MathOperators"],[8960,9215,"MiscTechnical"],[9312,9471,"EnclosedAlphanum"],[9472,9599,"BoxDrawing"],[9632,9727,"GeometricShapes"],[9728,9983,"MiscSymbols"],[9984,10175,"Dingbats"],[10624,10751,"MiscMathSymbolsB"],[10752,11007,"SuppMathOperators"],[57344,63743,"PUA"]],32:[0,0,250,0,0,""],65:[701,1,722,17,703,"130 -1H63Q34 -1 26 2T17 17Q17 24 22 29T35 35Q49 35 64 44T88 66Q101 93 210 383Q331 693 335 697T346 701T357 697Q358 696 493 399Q621 104 633 83Q656 35 686 35Q693 35 698 30T703 17Q703 5 693 2T643 -1H541Q388 -1 386 1Q378 6 378 16Q378 24 383 29T397 35Q412 35 434 45T456 65Q456 93 428 170L419 197H197L195 179Q184 134 184 97Q184 82 186 71T190 55T198 45T205 39T214 36L219 35Q241 31 241 17Q241 5 233 2T196 -1H130ZM493 68Q493 51 481 35H619Q604 56 515 256Q486 321 468 361L348 637Q347 637 330 592T313 543Q313 538 358 436T448 219T493 68ZM404 235Q404 239 355 355T295 488L275 430Q241 348 208 232H306Q404 232 404 235ZM155 48Q151 55 148 88V117L135 86Q118 47 117 46L110 37L135 35H159Q157 41 155 48"],66:[683,1,667,11,620,"11 665Q11 672 22 683H213Q407 681 431 677Q582 649 582 515Q582 488 573 468Q554 413 484 372L474 366H475Q620 317 620 178Q620 115 568 69T420 6Q393 1 207 -1H22Q11 10 11 18Q11 35 51 35Q79 37 88 39T102 52Q107 70 107 341T102 630Q97 640 88 643T51 648H46Q11 648 11 665ZM142 341Q142 129 141 88T134 37Q133 36 133 35H240L233 48L229 61V623L233 635L240 648H133L138 639Q142 621 142 341ZM284 370Q365 378 391 411T417 508Q417 551 406 581T378 624T347 643T320 648Q298 648 278 635Q267 628 266 611T264 492V370H284ZM546 515Q546 551 531 577T494 617T454 635T422 641L411 643L420 630Q439 604 445 579T452 510V504Q452 481 451 467T441 430T415 383Q420 383 439 391T483 413T527 455T546 515ZM585 185Q585 221 570 249T534 294T490 320T453 334T436 337L435 336L440 330Q445 325 452 315T467 288T479 246T484 188Q484 145 474 110T454 62T442 48Q442 47 444 47Q450 47 470 54T517 75T564 119T585 185ZM449 184Q449 316 358 332Q355 332 335 333T302 335H264V199Q266 68 270 57Q275 50 289 43Q300 37 324 37Q449 37 449 184"],67:[702,19,722,39,684,"684 131Q684 125 672 109T633 71T573 29T489 -5T386 -19Q330 -19 276 -3T174 46T91 134T44 261Q39 283 39 341T44 421Q66 538 143 611T341 699Q344 699 364 700T395 701Q449 698 503 677T585 655Q603 655 611 662T620 678T625 694T639 702Q650 702 657 690V481L653 474Q640 467 628 472Q624 476 618 496T595 541Q562 587 507 625T390 663H381Q337 663 299 625Q212 547 212 336Q212 249 233 179Q274 30 405 30Q533 30 641 130Q658 147 666 147Q671 147 677 143T684 131ZM250 625Q264 643 261 643Q238 635 214 620T161 579T110 510T79 414Q74 384 74 341T79 268Q89 213 113 169T164 101T217 61T260 39L277 34Q270 41 264 48Q199 111 181 254Q178 281 178 344T181 434Q200 559 250 625ZM621 565V625Q617 623 613 623Q603 619 590 619H575L588 605Q608 583 610 579L621 565"],68:[683,1,722,16,688,"16 666Q16 675 28 683H193Q329 683 364 682T430 672Q534 650 600 585T686 423Q688 406 688 352Q688 274 673 226Q641 130 565 72T381 1Q368 -1 195 -1H28Q16 5 16 16Q16 35 53 35Q68 36 75 37T87 42T95 52Q98 61 98 341T95 630Q91 640 83 643T53 648Q16 648 16 666ZM237 646Q237 648 184 648H128Q128 647 133 632Q136 620 136 341Q136 64 133 50L128 35H237L230 48L226 61V343Q228 620 231 633Q232 636 237 646ZM264 61Q278 40 310 35Q363 35 401 55T461 112T496 193T513 295Q515 333 515 349Q515 411 504 459Q481 598 373 641Q351 648 321 648Q304 648 292 643T277 635T264 621V61ZM461 628Q462 627 471 616T489 594T509 559T529 509T544 441T550 352Q550 165 479 75L468 59Q474 61 484 65T522 87T573 128T618 195T650 290Q654 322 654 354Q654 418 638 464T581 552Q559 576 529 595T480 621L461 628"],69:[683,1,667,12,640,"12 666Q12 675 24 683H582Q590 680 593 672V588Q593 514 591 502T575 490Q567 490 563 495T555 517Q552 556 517 590Q486 623 445 634T340 648H282Q266 636 264 620T260 492V370H277Q329 375 358 391T404 439Q420 480 420 506Q420 529 436 529Q445 529 451 521Q455 517 455 361Q455 333 455 298T456 253Q456 217 453 207T437 197Q420 196 420 217Q420 240 406 270Q377 328 284 335H260V201Q261 174 261 134Q262 73 264 61T278 38Q281 36 282 35H331Q400 35 449 50Q571 93 602 179Q605 203 622 203Q629 203 634 197T640 183Q638 181 624 95T604 3L600 -1H24Q12 5 12 16Q12 35 51 35Q92 38 97 52Q102 60 102 341T97 632Q91 645 51 648Q12 648 12 666ZM137 341Q137 131 136 89T130 37Q129 36 129 35H235Q233 41 231 48L226 61V623L231 635L235 648H129Q132 641 133 638T135 603T137 517T137 341ZM557 603V648H504Q504 646 515 639Q527 634 542 619L557 603ZM420 317V397L406 383Q394 370 380 363L366 355Q373 350 382 346Q400 333 409 328L420 317ZM582 61L586 88Q585 88 582 83Q557 61 526 46L511 37L542 35H577Q577 36 578 39T580 49T582 61"],70:[683,1,611,12,584,"584 499Q569 490 566 490Q558 490 552 497T546 515Q546 535 533 559Q526 574 506 593T469 621Q415 648 326 648Q293 648 287 647T275 641Q264 630 263 617Q262 609 260 492V370L275 372Q323 376 350 392T393 441Q409 473 409 506Q409 529 427 529Q437 529 442 519Q444 511 444 362Q444 212 442 206Q436 197 426 197Q409 197 409 217Q409 265 375 299Q346 328 280 335H260V206Q260 70 262 63Q265 46 276 41T326 35Q362 35 366 28Q377 17 366 3L360 -1H24Q12 5 12 16Q12 35 51 35Q92 38 97 52Q102 60 102 341T97 632Q91 645 51 648Q12 648 12 666Q12 675 24 683H573Q576 678 584 670V499ZM137 341Q137 131 136 89T130 37Q129 36 129 35H182Q233 35 233 39Q226 54 225 92T224 346L226 623L231 635L235 648H129Q132 641 133 638T135 603T137 517T137 341ZM549 603V648H495L506 641Q531 621 533 619L549 603ZM409 317V395L400 386Q390 376 375 366L357 355L373 346Q394 331 397 328L409 317"],71:[702,19,778,39,749,"737 285Q749 277 749 268Q749 260 744 255T730 250Q695 250 677 217Q666 195 666 119Q666 52 664 50Q656 36 555 3Q483 -16 415 -19Q364 -19 348 -17Q226 -3 146 70T44 261Q39 283 39 341T44 421Q66 538 143 611T341 699Q344 699 364 700T395 701Q449 698 503 677T585 655Q603 655 611 662T620 678T625 694T639 702Q650 702 657 690V481L653 474Q640 467 628 472Q624 476 618 496T595 541Q562 587 507 625T390 663H381Q337 663 299 625Q213 547 213 337Q213 75 341 23Q357 19 397 19Q440 19 462 22T492 30T513 45V119Q513 184 506 203Q491 237 435 250Q421 250 415 257Q404 267 415 281L421 285H737ZM250 43Q250 45 243 55T225 87T203 139T185 224T177 343V361Q184 533 250 625Q264 643 261 643Q238 635 214 620T161 579T110 510T79 414Q74 384 74 341T79 268Q106 117 230 52L250 43ZM621 565V625Q617 623 613 623Q603 619 590 619H575L588 605Q608 583 610 579L621 565ZM655 250H517L524 241Q548 213 548 149V114V39Q549 39 562 44T592 55T615 63L630 70V134Q632 190 634 204T648 237Q655 245 655 250"],72:[683,1,778,14,762,"14 666Q14 675 26 683H344L351 679Q361 665 351 655Q344 648 317 648Q287 645 282 641Q270 637 269 623T266 497V370H511V497Q511 519 510 553Q509 615 507 626T496 641H495Q489 645 459 648Q420 648 420 665Q420 672 426 679L433 683H751Q762 676 762 666Q762 648 724 648Q684 645 677 632Q675 626 675 341Q675 57 677 52Q684 38 724 35Q762 35 762 16Q762 6 751 -1H433L426 3Q420 10 420 17Q420 35 459 35Q501 38 506 52Q511 64 511 190V323H266V190Q266 60 271 52Q276 38 317 35Q342 35 351 28Q360 17 351 3L344 -1H26Q14 5 14 16Q14 35 53 35Q94 38 99 52Q104 60 104 341T99 632Q93 645 53 648Q14 648 14 666ZM233 341V553Q233 635 239 648H131Q134 641 135 638T137 603T139 517T139 341Q139 131 138 89T132 37Q131 36 131 35H239Q233 47 233 129V341ZM639 341V489Q639 548 639 576T640 620T642 639T646 648H537L542 639Q546 625 546 341Q546 130 545 88T538 37Q537 36 537 35H646Q643 41 643 42T641 55T639 84T639 140V341"],73:[683,1,389,20,369,"20 666Q20 676 31 683H358Q369 676 369 666Q369 648 331 648Q288 645 282 632Q278 626 278 341Q278 57 282 50Q286 42 295 40T331 35Q369 35 369 16Q369 6 358 -1H31Q20 4 20 16Q20 35 58 35Q84 37 93 39T107 50Q113 60 113 341Q113 623 107 632Q101 645 58 648Q20 648 20 666ZM249 35Q246 40 246 41T244 54T242 83T242 139V341Q242 632 244 639L249 648H140Q146 634 147 596T149 341Q149 124 148 86T140 35H249"],74:[683,77,500,6,478,"79 103Q108 103 129 83T151 38Q151 9 130 -15Q116 -34 130 -37Q133 -39 157 -39Q208 -39 219 -8L226 3V305Q226 612 224 621Q220 636 211 641T166 647Q137 647 128 654Q119 665 128 679L135 683H466Q478 677 478 666Q478 647 439 647Q399 644 393 632Q388 620 388 347Q386 69 384 59Q364 -6 316 -39T184 -77H172Q102 -77 56 -48T6 30Q6 62 26 82T79 103ZM353 354Q353 556 354 596T361 645Q362 646 362 647H253Q257 639 258 628T261 547T262 312V-4L255 -17Q248 -29 250 -29Q253 -29 258 -28T277 -20T302 -5T327 22T348 65Q350 74 353 354ZM115 36Q115 47 105 57T79 67Q73 67 67 66T52 56T44 34Q44 9 62 -8Q66 -11 71 -15T81 -22T86 -24L90 -13Q100 3 102 5Q115 22 115 36"],75:[683,1,778,22,768,"22 666Q22 676 33 683H351L358 679Q368 665 358 655Q351 648 324 648Q288 645 280 637Q275 631 274 605T273 477L275 343L382 446Q473 530 492 553T512 599Q512 617 502 631T475 648Q455 651 455 666Q455 677 465 680T510 683H593H720Q732 676 732 666Q732 659 727 654T713 648Q670 648 589 581Q567 562 490 489T413 415Q413 413 554 245T711 61Q737 35 751 35Q758 35 763 29T768 15Q768 6 758 -1H624Q491 -1 486 3Q480 10 480 17Q480 25 487 30T506 35Q518 36 520 38T520 48L400 195L302 310L286 297L273 283V170Q275 65 277 57Q280 41 300 38Q302 37 324 35Q349 35 358 28Q367 17 358 3L351 -1H33Q22 4 22 16Q22 35 60 35Q101 38 106 52Q111 60 111 341T106 632Q100 645 60 648Q22 648 22 666ZM240 341V553Q240 635 246 648H138Q141 641 142 638T144 603T146 517T146 341Q146 131 145 89T139 37Q138 36 138 35H246Q240 47 240 129V341ZM595 632L615 648H535L542 637Q542 636 544 625T549 610V595L562 606Q565 608 577 618T595 632ZM524 226L386 388Q386 389 378 382T358 361Q330 338 330 333Q330 332 330 332L331 330L533 90Q558 55 558 41V35H684L671 50Q667 54 524 226"],76:[683,1,667,12,640,"12 666Q12 675 24 683H333L340 679Q350 665 340 655Q333 648 309 648Q287 646 279 643T266 630Q264 623 264 346Q264 68 266 57Q274 40 284 35H340Q413 37 460 55Q514 78 553 117T602 197Q605 221 622 221Q629 221 634 215T640 201Q638 194 625 105T611 12Q611 6 600 -1H24Q12 5 12 16Q12 35 51 35Q92 38 97 52Q102 60 102 341T97 632Q91 645 51 648Q12 648 12 666ZM137 341Q137 131 136 89T130 37Q129 36 129 35H237Q235 41 233 48L229 61L226 339Q226 621 229 628Q230 630 231 636T233 643V648H129Q132 641 133 638T135 603T137 517T137 341ZM580 48Q580 59 583 74T586 97Q586 98 585 97T579 92T571 86Q549 64 513 43L500 35H577L580 48"],77:[683,1,944,17,926,"18 666Q18 677 27 680T73 683H146Q261 683 266 679L465 215Q469 215 566 443Q663 676 668 681Q673 683 790 683H908L915 679Q924 664 915 655Q912 648 897 648Q851 639 835 606L833 346Q833 86 835 79Q838 69 849 58T873 41Q877 40 887 38T901 35Q926 35 926 16Q926 6 915 -1H604L597 3Q588 19 597 28Q600 35 615 35Q660 42 673 68L679 79V339Q679 409 679 443T679 520T679 580T677 597Q646 521 584 375T473 117T424 3Q416 -1 410 -1T401 1Q399 3 273 301L148 599L146 343Q146 86 148 79Q152 69 163 58T186 41Q190 40 200 38T215 35Q226 35 235 28Q244 17 235 3L228 -1H28Q17 4 17 17Q17 35 39 35Q84 42 97 68L104 79V639L88 641Q72 644 53 648Q34 648 26 651T18 666ZM457 166Q451 169 449 171T435 198T404 268T344 412L244 648H157L166 637Q169 633 293 346L413 66Q424 88 435 117L457 166ZM817 646Q817 648 766 648H715V72L708 57Q701 45 697 41L695 37Q695 35 757 35H819L813 46Q802 61 800 76Q797 105 797 346L799 612L804 626Q812 638 815 641L817 646ZM124 42Q119 42 119 38Q119 35 128 35Q132 35 132 36Q125 42 124 42"],78:[683,20,722,20,702,"20 664Q20 666 31 683H142Q256 683 258 681Q259 680 279 653T342 572T422 468L582 259V425Q582 451 582 490T583 541Q583 611 573 628T522 648Q500 648 493 654Q484 665 493 679L500 683H691Q702 676 702 666Q702 657 698 652Q688 648 680 648Q633 648 627 612Q624 601 624 294V-8Q616 -20 607 -20Q601 -20 596 -15Q593 -13 371 270L156 548L153 319Q153 284 153 234T152 167Q152 103 156 78T172 44T213 34Q236 34 242 28Q253 17 242 3L236 -1H36Q24 6 24 16Q24 34 56 34Q58 35 69 36T86 40T100 50T109 72Q111 83 111 345V603L96 619Q72 643 44 648Q20 648 20 664ZM413 419L240 648H120L136 628Q137 626 361 341T587 54L589 68Q589 78 589 121V192L413 419"],79:[701,19,778,34,742,"131 601Q180 652 249 676T387 701Q485 701 562 661Q628 629 671 575T731 448Q742 410 742 341T731 234Q707 140 646 81Q549 -19 389 -19Q228 -19 131 81Q57 155 37 274Q34 292 34 341Q34 392 37 410Q58 528 131 601ZM568 341Q568 613 437 659Q406 664 395 665Q329 665 286 625Q232 571 213 439Q210 408 210 341Q210 275 213 245Q232 111 286 57Q309 37 342 23Q357 19 389 19Q420 19 437 23Q469 38 491 57Q568 132 568 341ZM174 341Q174 403 177 441T197 535T249 639Q246 639 224 627T193 608Q189 606 183 601T169 589T155 577Q69 488 69 344Q69 133 231 52Q244 45 246 45Q248 45 246 48Q231 69 222 85T200 141T177 239Q174 269 174 341ZM708 341Q708 415 684 475T635 563T582 610Q578 612 565 619T546 630Q533 637 531 637Q530 637 530 636V635L531 634Q562 591 577 543Q602 471 602 341V316Q602 264 599 230T580 144T531 48L530 47V46Q530 45 531 45Q533 45 547 52T583 75T622 105Q708 195 708 341"],80:[683,1,611,16,597,"16 666Q16 675 28 683H195Q334 683 370 682T437 672Q511 657 554 611T597 495Q597 343 404 309Q402 308 401 308Q381 303 319 303H261V181Q261 157 262 120Q262 60 267 50T304 36Q310 35 313 35Q352 35 352 17Q352 10 346 3L339 -1H28Q16 5 16 16Q16 35 53 35Q68 36 75 37T87 42T95 52Q98 61 98 341T95 630Q91 640 83 643T53 648Q16 648 16 666ZM235 35Q228 46 227 84Q226 129 226 337V621L230 635L237 648H128Q128 647 133 632Q136 620 136 341Q136 64 133 50L128 35H235ZM301 341H313Q339 341 354 344T389 362T417 410T426 498Q426 586 401 616T322 647Q301 647 293 643Q271 637 264 621Q261 617 261 479V341H301ZM429 350Q431 350 443 353T476 367T515 391T548 432T562 490Q562 550 524 592Q507 607 484 619Q481 621 448 635L433 639L439 621Q462 578 462 506Q462 448 454 413T437 366T428 350H429"],81:[701,181,778,34,742,"480 -10Q480 -13 486 -24T507 -50T541 -80T588 -104T648 -114Q666 -114 688 -110T714 -106Q724 -106 728 -114T729 -130Q723 -145 663 -163T548 -181Q503 -181 463 -169T395 -139T343 -97T307 -56T284 -19L280 -3L262 1Q188 24 131 81Q57 155 37 275Q34 292 34 342T37 410Q58 528 131 601Q179 652 248 676T388 701Q485 701 562 661Q698 595 731 448Q742 410 742 341T731 235Q707 141 646 81Q616 50 575 27T493 -5L480 -10ZM568 342Q568 613 437 659L395 666Q329 666 286 626Q232 570 213 439Q210 408 210 342T213 246Q231 113 286 57Q309 37 342 23Q357 19 389 19Q420 19 437 23Q469 38 491 57Q568 134 568 342ZM174 341V354Q174 393 175 419T183 484T205 561T246 635L249 639Q246 639 224 627T193 608Q189 606 183 601T169 589T155 577Q69 491 69 344Q69 133 231 52Q247 42 247 46Q247 46 246 48Q231 69 222 85T200 141T177 239Q174 269 174 341ZM708 341Q708 410 689 467T640 556T588 606T546 630Q532 638 531 638Q530 638 531 635Q563 590 577 543Q602 472 602 341V316Q602 264 599 230T580 144T531 48Q529 44 532 45T546 52Q575 68 596 84T642 128T683 200T706 299Q708 327 708 341ZM391 -17H333Q329 -15 326 -15Q324 -15 324 -17Q324 -21 362 -68Q424 -130 506 -143Q518 -144 544 -144Q569 -144 577 -143L589 -141L575 -139Q544 -127 509 -101T453 -37L442 -19L391 -17"],82:[683,1,722,16,705,"17 665Q17 672 28 683H221Q415 681 439 677Q461 673 481 667T516 654T544 639T566 623T584 607T597 592T607 578T614 565T618 554L621 548Q626 530 626 497Q626 447 613 419Q578 348 473 326L455 321Q462 310 473 292T517 226T578 141T637 72T686 35Q705 30 705 16Q705 7 693 -1H510Q503 6 404 159L306 310H268V183Q270 67 271 59Q274 42 291 38Q295 37 319 35Q344 35 353 28Q362 17 353 3L346 -1H28Q16 5 16 16Q16 35 55 35Q96 38 101 52Q106 60 106 341T101 632Q95 645 55 648Q17 648 17 665ZM241 35Q238 42 237 45T235 78T233 163T233 337V621L237 635L244 648H133Q136 641 137 638T139 603T141 517T141 341Q141 131 140 89T134 37Q133 36 133 35H241ZM457 496Q457 540 449 570T425 615T400 634T377 643Q374 643 339 648Q300 648 281 635Q271 628 270 610T268 481V346H284Q327 346 375 352Q421 364 439 392T457 496ZM492 537T492 496T488 427T478 389T469 371T464 361Q464 360 465 360Q469 360 497 370Q593 400 593 495Q593 592 477 630L457 637L461 626Q474 611 488 561Q492 537 492 496ZM464 243Q411 317 410 317Q404 317 401 315Q384 315 370 312H346L526 35H619L606 50Q553 109 464 243"],83:[702,12,556,28,528,"54 238Q72 238 72 212Q72 174 106 121Q113 110 132 90T166 59Q221 23 264 23Q315 23 348 41Q368 50 384 79Q393 102 393 129Q393 181 356 219T221 299Q120 343 74 390T28 501Q28 561 55 610Q98 682 212 699Q214 699 231 700T261 701Q309 698 340 687T408 675Q431 678 445 690T465 702Q474 702 481 690V497L477 490Q464 481 450 490Q446 500 446 501Q446 546 386 606T260 666Q215 666 182 639T148 565Q148 528 186 496T319 428Q352 414 370 405T418 379T468 338T506 284Q528 239 528 191Q528 102 456 46T266 -10Q211 -10 176 2T110 15Q86 9 73 -1T53 -12Q44 -12 37 -1V112V182Q37 214 40 226T54 238ZM446 619Q446 648 444 648Q439 646 435 644Q425 644 415 639H404L417 624Q435 606 439 601L446 592V619ZM124 619L128 635Q126 635 108 617Q64 576 64 502Q64 489 65 479T76 449T102 414T150 376T228 335Q335 291 381 245T427 128Q427 94 419 75L415 61Q421 61 448 88Q490 127 490 190Q490 233 475 264Q456 299 430 321Q402 349 369 367T287 404T204 441Q138 481 119 526Q113 544 113 565Q113 596 124 619ZM75 43Q76 43 90 46T110 50H119L106 64L74 101Q72 101 72 72T75 43"],84:[683,1,667,33,635,"33 672Q36 680 44 683H624Q632 680 635 672V490L631 483Q621 479 617 479Q611 479 606 485T600 499Q600 525 584 552Q577 567 558 588T524 617Q479 642 426 646L415 648V355Q415 62 422 52Q425 42 434 40T473 35Q500 35 509 28Q518 17 509 3L502 -1H166L160 3Q149 17 160 28Q167 35 195 35Q224 37 234 39T249 52Q253 66 253 355V648L242 646Q192 642 144 617Q129 609 110 588T84 552Q69 527 69 499Q69 490 64 484T50 478Q39 478 33 490V672ZM113 639L126 648H69V597L84 612Q93 623 113 639ZM389 35Q382 46 381 86Q380 134 380 350V648H289V350Q289 199 288 131T286 53T280 35H389ZM600 597V648H542L555 639Q575 623 584 612L600 597"],85:[683,19,722,16,709,"16 666Q16 677 28 683H341L348 679Q359 665 348 654Q342 648 315 648Q270 644 266 632Q262 627 262 598T261 399Q261 372 261 325T260 260Q260 149 274 99T339 30Q355 25 393 25Q430 25 457 33T494 49T519 72Q562 115 575 205Q576 219 576 379Q576 538 575 550Q568 597 550 622T506 648Q498 648 493 654T487 667T499 683H697Q709 675 709 667T704 654T690 648Q653 648 633 597Q624 573 622 546T619 377Q617 193 613 174Q596 95 544 41Q477 -19 355 -19H344Q275 -16 226 5T153 57T120 110T106 154Q101 172 99 399Q99 618 95 632Q88 644 53 648Q16 648 16 666ZM228 639L233 648H128Q128 647 133 632Q135 621 135 412Q135 197 137 185Q148 115 181 79Q209 51 235 41Q242 36 258 31T277 25Q276 27 268 38T254 59T241 92T228 145Q226 161 226 399Q226 632 228 639ZM604 621Q606 626 619 648H577L586 634Q587 632 591 625T595 614L597 608L604 621"],86:[683,20,722,0,719,"316 683Q327 676 327 666Q327 648 302 648Q272 642 258 628Q249 621 249 608Q252 589 263 556T289 485T322 406T357 325T388 256T411 205L420 185Q423 185 473 317Q547 497 547 590Q547 621 541 632T516 648Q501 648 498 654Q488 664 498 679L504 683H607H660Q695 683 707 680T719 667Q719 660 714 654T700 648Q678 648 658 628L642 614L513 301Q484 231 449 148T397 25T380 -15Q373 -20 368 -20Q361 -20 358 -15Q354 -13 287 135T149 438T67 610Q45 648 18 648Q11 648 6 653T0 666Q0 677 9 680T59 683H164H316ZM216 614Q216 620 216 622T216 628T216 633T217 635T218 638T219 640T221 644T224 648H84L96 632Q118 592 236 330L367 43L387 88L404 132L380 185Q250 468 222 568Q216 590 216 614ZM576 645Q584 628 584 597L587 568L598 597Q609 624 618 637L624 648H600Q576 648 576 645"],87:[683,19,1e3,5,994,"785 664Q785 670 795 683H982Q994 675 994 665Q994 650 975 648Q953 643 939 619Q931 593 823 292T710 -15Q706 -19 699 -19T688 -15Q682 -6 639 107T555 328T513 437Q513 438 500 409T462 325T413 212Q315 -14 310 -17Q308 -19 302 -19T288 -15L57 619Q45 643 24 648Q5 650 5 665Q5 677 17 683H146H200Q256 683 270 681T285 666Q285 659 280 654T268 648Q253 648 239 634Q230 630 230 619Q230 598 264 481L362 192Q363 193 428 341T493 492Q493 496 473 546T446 608Q426 648 399 648Q392 648 387 653T382 667Q382 678 393 683H679Q690 670 690 665Q690 662 685 655T673 648Q653 648 633 632L622 625V610Q626 576 657 479T719 300T751 218Q754 218 779 294Q847 492 847 581Q847 648 802 648Q796 648 791 652T785 664ZM194 623Q194 630 199 648H82L90 632Q99 616 199 332L302 50Q303 50 322 94T342 141Q342 142 305 245T231 467T194 623ZM585 620Q585 634 593 648H530Q466 648 466 645Q479 632 595 323L699 54Q701 56 718 103T735 154L702 245Q585 562 585 620ZM884 572L890 587Q896 602 903 620T915 645Q915 648 893 648H868L875 634Q883 598 883 576Q883 572 884 572"],88:[683,1,722,16,705,"22 666Q22 677 31 680T80 683H184H335Q346 675 346 667Q346 660 341 655Q335 648 315 648Q280 644 273 637Q273 630 300 583T356 492T386 448Q430 504 450 535T474 577T478 601Q478 620 469 634T444 648Q428 648 428 666Q428 678 436 680T488 683H559H630Q673 683 681 681T690 666Q690 648 673 648Q652 648 619 637Q571 615 517 550Q490 517 450 464T410 408Q415 399 501 273T617 106Q648 61 661 48T688 35Q705 35 705 16Q705 5 695 -1H539Q384 -1 379 3Q373 10 373 17Q373 27 380 31T408 35Q459 40 459 49Q459 59 418 129T335 259Q334 260 332 260Q328 260 273 197Q210 127 208 117Q199 104 199 82Q199 57 213 46T239 35Q247 35 252 29T257 15Q257 10 256 7T253 3T248 0L246 -1H28Q16 7 16 15T21 29T35 35Q61 35 117 88Q289 279 304 297Q307 303 255 377Q117 586 79 626Q60 648 39 648Q32 648 27 653T22 666ZM237 639V648H173Q113 647 113 646Q113 642 137 612Q186 546 302 373T453 139Q497 63 497 43Q497 39 495 35H559Q622 35 622 37Q622 38 583 94T486 233T373 399T277 552T237 639ZM553 637L566 648H504L508 637Q510 630 515 615V603L528 615Q529 616 539 625T553 637ZM170 46Q169 49 167 58T164 70V83L137 59L113 35H175Q175 38 170 46"],89:[683,1,722,16,704,"16 659T16 667T28 683H295Q306 676 306 666Q306 648 284 648Q258 648 255 641Q255 634 265 615T339 479Q418 339 421 339L455 394Q489 448 523 502L557 557Q560 566 560 582Q560 637 504 648Q489 648 486 655Q475 664 486 679L493 683H693Q704 675 704 667Q704 650 684 648Q672 645 653 623Q633 604 614 576T517 426L439 301V183Q442 62 444 59Q449 35 504 35Q521 35 528 30Q538 16 528 3L521 -1H195L188 3Q178 16 188 30Q195 35 213 35Q266 35 273 59Q274 61 277 163V261L75 621Q64 638 58 643T37 648Q28 648 22 653ZM219 637V648H101Q110 634 215 446L313 270V166Q310 59 306 48L301 35H415L410 48Q404 65 404 175V290L317 443Q230 601 226 612Q219 625 219 637ZM608 630L624 648H575Q584 632 588 623L595 610L608 630"],90:[683,1,667,29,635,"39 -1Q29 9 29 12Q29 23 60 77T219 337L410 648H364Q261 648 210 628Q168 612 142 588T109 545T97 509T88 490Q85 489 80 489Q72 489 61 503L70 588Q72 607 75 628T79 662T81 675Q84 677 88 681Q90 683 341 683H592Q604 673 604 666Q604 662 412 348L221 37Q221 35 301 35Q406 35 446 48Q504 68 543 111T597 212Q602 239 617 239Q624 239 629 234T635 223Q635 215 621 113T604 8L597 1Q595 -1 317 -1H39ZM148 637L166 648H112V632Q111 629 110 622T108 612Q108 608 110 608T116 612T129 623T148 637ZM552 646Q552 648 504 648Q452 648 450 643Q448 639 266 343T77 37Q77 35 128 35H179L366 339L552 646ZM572 35Q581 89 581 97L561 77Q542 59 526 48L508 37L539 35H572"],107:[683,1,556,17,534,"519 443Q519 426 497 426Q458 422 361 335Q328 308 315 295Q307 289 310 286T383 193T466 88Q507 35 517 35Q534 35 534 16Q534 5 524 -1H304L297 3Q288 19 297 28Q300 35 317 35Q320 36 324 36T330 37T333 39Q334 39 334 40Q334 47 304 86T244 162L215 199Q212 202 206 199Q201 195 201 137V121Q201 35 230 35Q238 35 243 29T248 15Q248 4 237 -1H28L21 3Q17 13 17 17Q17 24 22 29T35 35Q55 35 61 70Q63 78 63 341T61 612Q55 648 35 648Q27 648 22 654T17 668Q17 678 26 682Q27 683 28 683H108H147Q156 683 162 683T174 683T182 683T187 682T191 681T194 680T197 678T201 675V461L204 246L244 281Q254 291 272 307Q317 349 326 360T339 386Q340 390 340 398Q340 426 321 426Q314 426 309 431T304 445Q304 456 315 461H508Q519 448 519 443ZM166 359V648H126Q89 648 89 645Q89 644 89 644T90 643T91 640T93 634T95 626Q99 612 99 341T95 57Q94 53 93 49T91 43T90 39L89 37Q89 35 133 35Q176 35 176 37Q175 38 175 39Q175 42 170 57Q166 70 166 359ZM410 423Q412 425 407 426Q404 426 393 426Q373 426 373 423Q374 422 375 417T377 410Q377 399 379 399Q406 419 410 423ZM460 37Q460 41 368 152L281 263Q280 263 259 246L239 228Q298 157 355 79Q370 61 370 41V35H417Q460 35 460 37"]};MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/Main.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{8592:[437,-64,500,64,423,"292 419Q292 400 261 347T211 275H306Q319 275 338 275T364 276Q399 276 410 271T422 250T411 230T366 225H306H211Q214 222 232 197T271 136T292 82Q292 71 285 68T262 64H250H241Q221 64 216 67T205 83Q186 127 153 167T78 230Q64 238 64 250Q64 258 69 263T82 272T106 288T139 318Q162 342 177 365T198 402T209 425T223 436Q224 437 252 437H258Q292 437 292 419"],8594:[437,-64,500,58,417,"188 417Q188 437 221 437H233Q256 437 263 434T275 417Q294 373 327 333T402 270Q417 261 417 250Q417 241 410 236T382 217T341 182Q315 155 299 128T275 85T263 66Q259 64 231 64H219Q197 64 191 72T193 100Q202 124 215 147T239 185T257 210T267 223L269 225H174H116Q80 225 69 229T58 250T70 271T114 276Q121 276 140 276T174 275H269L267 277Q266 280 257 291T233 325T205 374Q188 408 188 417"],8602:[437,-60,1e3,56,942,"942 250Q942 244 928 230H511L457 148Q440 124 420 93Q404 68 400 64T389 60Q381 60 375 66T368 81Q368 88 415 159L462 230H175L188 214Q210 188 235 145T264 85Q264 75 260 74T231 72L206 74L191 103Q169 142 164 150Q130 195 64 239Q56 244 56 250T64 261Q115 294 142 323T191 397L206 428H231Q255 428 259 426T264 414Q260 397 235 355T188 288L175 272L331 270Q488 270 491 272Q491 275 542 352T597 432Q602 437 609 437Q617 437 622 432T628 417T582 341L537 272L735 270H931Q942 257 942 250"],8603:[437,-60,1e3,54,942,"54 250Q54 258 66 270H277L488 272L542 350Q596 431 602 435Q604 437 609 437Q617 437 622 432T628 417T582 341L537 272L608 270H751L822 272L808 288Q786 313 761 355T733 414Q733 424 737 426T766 428H793L806 397Q829 354 864 314Q896 284 928 263Q942 257 942 250T928 237Q887 208 864 185Q829 147 806 103L793 74L766 72Q742 72 738 73T733 85Q735 102 756 137T797 198L817 225L822 230H511L457 148Q440 124 420 93Q404 68 400 64T389 60Q381 60 375 66T368 81Q368 88 415 159L462 230H264L66 232Q54 239 54 250"],8606:[417,-83,1e3,56,944,"56 250Q103 277 142 322T199 417H221Q244 417 244 416Q244 414 237 397T208 344T158 278L151 270H276L285 277Q322 306 349 345T388 417H434Q434 413 424 392T393 338T349 279L340 270H634Q933 270 937 266L938 265Q944 259 944 250T938 235L937 234Q933 230 634 230H340L349 221Q372 196 393 163T424 108T434 83H388Q377 116 350 155T285 223L276 230H151L158 222Q186 191 207 156T236 104T244 84Q244 83 221 83H199Q181 133 142 178T56 250"],8608:[417,-83,1e3,55,943,"943 250Q895 221 856 177T801 83H778Q755 83 755 84Q755 86 762 103T791 156T841 222L848 230H723L714 223Q677 194 650 155T611 83H565Q565 87 575 108T606 162T650 221L659 230H365Q66 230 62 234L61 235Q55 241 55 250T61 265L62 266Q66 270 365 270H659L650 279Q627 304 606 337T575 392T565 417H611Q622 384 649 345T714 277L723 270H848L841 278Q813 309 792 344T763 396T755 416Q755 417 778 417H801Q817 367 856 323T943 250"],8610:[417,-83,1111,56,1031,"56 250Q103 277 142 322T199 417H221Q244 417 244 416Q244 414 237 397T208 344T158 278L151 270H873L882 277Q919 306 946 345T985 417H1031Q1031 413 1021 392T990 338T946 279L937 270V230L946 221Q969 196 990 163T1021 108T1031 83H985Q974 116 947 155T882 223L873 230H151L158 222Q186 191 207 156T236 104T244 84Q244 83 221 83H199Q181 133 142 178T56 250"],8611:[417,-83,1111,79,1054,"1054 250Q1006 221 967 177T912 83H889Q866 83 866 84Q866 86 873 103T902 156T952 222L959 230H237L228 223Q191 194 164 155T125 83H79Q79 87 89 108T120 162T164 221L173 230V270L164 279Q141 304 120 337T89 392T79 417H125Q136 384 163 345T228 277L237 270H959L952 278Q924 309 903 344T874 396T866 416Q866 417 889 417H912Q928 367 967 323T1054 250"],8619:[576,41,1e3,56,965,"56 250Q103 277 142 322T199 417H221Q244 417 244 416Q244 414 237 397T208 344T158 278L151 270H622V305Q622 356 624 388T635 460T661 521T709 559T785 575Q813 575 833 573T880 561T923 534T952 483T964 405Q964 374 959 350T942 307T918 276T884 255T847 242T804 235T760 231T713 230H662V-27Q654 -41 644 -41H642H640Q628 -41 622 -27V230H151L158 222Q186 191 207 156T236 104T244 84Q244 83 221 83H199Q181 133 142 178T56 250ZM924 403Q924 474 894 505T794 536Q758 536 734 526T696 500T675 453T665 395T662 319V270H699Q826 270 875 295T924 403"],8620:[575,41,1e3,35,943,"35 405Q35 454 48 489T86 542T137 567T195 575Q229 575 251 571T301 554T345 510T370 429Q377 384 377 305V270H848L841 278Q813 309 792 344T763 396T755 416Q755 417 778 417H801Q817 367 856 323T943 250Q896 221 857 177T801 83H778Q755 83 755 84Q755 86 762 103T791 156T841 222L848 230H377V-27Q369 -41 359 -41H357Q342 -41 337 -25V230H286Q247 231 225 232T169 238T115 255T75 284T45 333T35 405ZM75 406Q75 322 123 296T300 270H337V319Q335 432 317 477T240 534Q232 535 197 535Q140 535 108 507T75 406"],8621:[417,-83,1389,57,1331,"57 250Q159 311 200 417H246L242 407Q215 340 159 278L152 270H276L315 310Q354 349 358 351Q366 356 376 351Q378 350 455 273L530 196L606 273Q683 350 686 351Q694 354 703 351Q705 350 782 273L858 196L933 273Q1010 350 1012 351Q1022 356 1030 351Q1034 349 1073 310L1112 270H1236L1229 278Q1173 340 1146 407L1142 417H1188Q1233 306 1331 250Q1231 192 1188 83H1142L1146 93Q1173 160 1229 222L1236 230H1168Q1155 230 1139 230T1119 229Q1112 229 1108 229T1099 231T1092 233T1085 238T1078 245T1068 256T1056 269L1021 304L984 267Q948 230 910 191T867 149Q857 144 848 150Q844 151 770 227T694 304T618 228T540 150Q531 144 521 149Q517 152 479 191T404 267L367 304L332 269Q328 264 320 256T310 246T303 239T296 234T289 231T280 229T269 229Q265 229 249 229T220 230H152L159 222Q215 160 242 93L246 83H223L200 84L195 96Q152 190 57 250"],8622:[437,-60,1e3,56,942,"491 272Q491 275 542 352T597 432Q602 437 609 437Q617 437 622 432T628 417T582 341L537 272L608 270H751L822 272L808 288Q786 313 761 355T733 414Q733 424 737 426T766 428H793L806 397Q829 354 864 314Q896 284 928 263Q942 257 942 250T928 237Q887 208 864 185Q829 147 806 103L793 74L766 72Q742 72 738 73T733 85Q735 102 756 137T797 198L817 225L822 230H511L457 148Q440 124 420 93Q404 68 400 64T389 60Q381 60 375 66T368 81Q368 88 415 159L462 230H175L188 214Q210 188 235 145T264 85Q264 75 260 74T231 72L206 74L191 103Q169 142 164 150Q130 195 64 239Q56 244 56 250T64 261Q115 294 142 323T191 397L206 428H231Q255 428 259 426T264 414Q260 397 235 355T188 288L175 272L331 270Q488 270 491 272"],8624:[722,0,500,56,444,"56 555Q74 567 79 570T107 592T141 625T170 667T198 722H221Q244 722 244 721Q244 718 236 699T207 647T161 587L151 576L291 575H292H293H294H296H297H298H299H300H301H302H304H305H306H307H308H309H310H311H312H314H315H316H317H318H319H320H321H322H323H324H325H327H328H329H330H331H332H333H334H335H336H337H338H339H340H341H342H343H345Q435 574 438 570L439 569L440 568Q444 564 444 287Q444 15 442 12Q436 0 424 0T406 12Q404 15 404 275V535H151L162 523Q187 495 207 462T236 410T244 389H198L193 402Q171 457 131 497T56 555"],8625:[722,0,500,55,443,"301 722Q339 618 443 555L437 551Q431 547 422 541T401 526T377 504T352 477T327 443T306 402L301 389H255Q255 392 263 410T291 461T337 523L348 535H95V275Q95 15 93 12Q87 0 75 0T57 12Q55 15 55 287Q55 564 59 568L60 569Q64 573 76 573T208 575L348 576L338 587Q314 613 294 646T264 698T255 721Q255 722 278 722H301"],8630:[461,1,1e3,17,950,"361 210Q373 210 373 182V177Q373 155 370 151T348 139Q303 118 267 84T216 28T201 1Q197 -1 196 -1Q189 -1 184 8Q166 39 143 64T99 104T61 129T32 144T19 150Q17 152 17 179Q17 203 21 208Q28 210 39 206Q106 178 157 135L175 119V126Q179 130 179 155Q182 173 193 201Q228 305 312 374T510 459Q532 461 551 461H567Q678 461 784 386Q835 344 861 301Q902 245 926 173T950 32Q950 15 944 8Q930 -6 917 8Q910 12 910 43Q901 208 801 314T561 421Q453 421 359 359Q300 319 263 258T217 126L216 125Q216 124 216 123T217 122Q219 122 229 131T260 156T301 181Q314 189 336 199T361 210"],8631:[460,1,1e3,46,982,"972 209Q980 209 981 204T982 179Q982 155 979 151T957 139Q915 121 878 86T815 8Q808 -1 803 -1Q801 -1 797 1Q797 6 783 28T732 84T650 139L628 150Q626 152 626 177Q626 201 630 206Q636 210 637 210Q650 210 697 181Q727 166 764 137L784 119L782 132Q767 239 689 318T499 417Q474 421 442 421Q343 421 261 369T130 219Q86 121 86 28Q86 15 79 8Q73 1 66 1T53 8Q46 15 46 30Q46 102 77 192T186 361Q274 443 386 459Q396 460 426 460Q515 460 588 431T703 361T773 271T812 187T822 132Q822 123 825 123Q936 209 972 209"],8634:[650,83,778,56,722,"369 543T369 563T397 583Q408 583 440 579L454 577L464 581Q492 592 516 609T552 638T565 650Q604 638 607 637Q606 636 598 628T585 614T570 601T548 584T523 568L510 560L516 558Q522 555 527 553T541 546T559 536T580 523T603 506T626 485Q722 384 722 250Q722 106 622 12T387 -83Q253 -83 155 12T56 250Q56 357 110 433T235 545Q244 550 252 550Q270 550 270 531Q270 522 261 515T238 501T202 477T159 433Q95 352 95 250Q95 131 178 45T388 -42Q511 -42 596 43T682 250Q682 340 636 408T522 511Q495 526 488 526Q488 525 488 525T487 522T485 515L490 506Q505 481 516 451T531 404T535 384L532 385Q529 386 524 387T513 390L491 397L488 408Q472 483 413 542L399 543Q369 543 369 563"],8635:[650,83,778,56,721,"170 637L213 650Q270 597 313 581L323 577L337 579Q369 583 380 583Q408 583 408 563T380 543H378L364 542Q305 483 289 408L286 397L264 390Q259 389 254 388T245 385L242 384Q242 387 246 403T261 450T287 506L292 515Q291 519 291 521T290 524T289 526Q284 526 265 517T216 486T160 434T114 354T95 249Q95 132 178 45T388 -42Q513 -42 597 44T682 250Q682 337 638 404T532 506Q529 508 525 510T519 514T515 516T511 519T509 522T508 526T507 531Q507 550 525 550Q533 550 542 545Q569 532 596 511T653 454T702 366T721 250Q721 151 672 74T547 -43T388 -83Q254 -83 155 12T56 250Q56 385 151 485Q164 498 179 509T205 528T228 542T247 551T260 558L267 560L254 568Q215 590 170 637"],8638:[694,194,417,188,375,"188 258V694H208L215 682Q246 628 293 594T375 551V528Q375 505 374 505Q369 505 351 510T299 534T237 578L228 587V205Q228 -178 226 -182Q221 -194 208 -194T190 -182Q188 -178 188 258"],8639:[694,194,417,41,228,"41 551Q76 559 123 592T201 682L208 694H228V258Q228 -178 226 -182Q221 -194 208 -194T190 -182Q188 -178 188 205V587L179 578Q151 552 117 534T65 511T42 505Q41 505 41 528V551"],8642:[694,194,417,188,375,"190 682Q195 694 208 694T226 683Q228 679 228 296V-87L237 -78Q265 -52 299 -34T351 -11T374 -5Q375 -5 375 -28V-51Q340 -60 293 -92T215 -182L208 -194H188V242Q188 678 190 682"],8643:[694,194,417,41,228,"188 295V573Q188 657 189 672T200 692Q206 694 208 694Q221 694 226 683Q228 679 228 242V-194H208L201 -182Q170 -128 123 -94T41 -51V-28Q41 -5 42 -5Q47 -5 65 -10T117 -34T179 -78L188 -87V295"],8644:[667,0,1e3,55,944,"943 500Q895 471 856 427T801 333H778Q755 333 755 334Q755 336 762 353T791 406T841 472L848 480H459Q70 480 67 482Q55 488 55 500T67 518Q70 520 459 520H848L841 528Q813 559 792 594T763 646T755 666Q755 667 778 667H801Q817 617 856 573T943 500ZM56 167Q102 194 141 238T198 333H221Q244 333 244 332Q221 265 161 198L151 187H539Q928 187 930 186Q944 182 944 167Q944 155 934 149Q930 147 541 147H151L160 137Q185 110 205 77T235 24T244 1Q244 0 221 0H199Q158 106 56 167"],8646:[667,0,1e3,55,944,"56 500Q103 527 142 572T199 667H221Q244 667 244 666Q244 664 237 647T208 594T158 528L151 520H539Q928 520 932 518Q944 513 944 500T932 482Q928 480 539 480H151L158 472Q186 441 207 406T236 354T244 334Q244 333 221 333H199Q181 383 142 428T56 500ZM943 167Q835 101 801 0H778Q755 0 755 1T758 9T765 25T771 39Q800 94 839 137L848 147H458Q68 147 66 149Q55 154 55 167Q55 182 69 186Q71 187 460 187H848L838 198Q811 228 791 261T762 314L755 332Q755 333 778 333H801Q841 227 943 167"],8647:[583,83,1e3,55,944,"930 437Q944 426 944 416T934 399Q930 397 540 397H150L159 387Q185 360 205 328T234 277T243 252Q243 237 217 191T159 113L150 103H540Q930 103 934 101Q944 94 944 84Q944 71 930 64L540 63H151Q180 34 203 -2T236 -61L244 -83H198Q178 -31 142 11T66 77L55 83L65 89Q157 145 197 246Q199 250 190 269Q150 359 65 411L55 417L66 423Q106 447 142 489T198 583H244Q202 488 151 437H930"],8648:[694,193,833,83,749,"83 551Q190 590 250 694Q251 689 263 671T307 621T380 567Q409 551 416 551Q422 551 447 563T511 608T577 684L582 694Q642 591 749 551V528Q749 505 748 505Q745 505 724 515T669 546T612 590L602 599V-181Q595 -193 585 -193H582H581Q568 -193 565 -183L563 -179L562 209V598L552 589Q517 556 473 531T414 506H412Q411 506 393 514T361 530T324 553T280 589L270 598V-179Q255 -192 250 -193H247Q237 -193 230 -181V599L220 590Q197 567 164 546T110 515T84 505Q83 505 83 528V551"],8649:[583,83,1e3,55,944,"55 416Q55 427 70 437H848Q819 466 796 502T764 561L755 583H801Q821 531 857 489T933 423L944 417L934 411Q843 355 802 254Q800 250 809 231Q849 141 934 89L944 83L933 77Q893 53 857 11T801 -83H755Q797 12 848 63H459L70 64Q55 70 55 84Q55 94 65 101Q69 103 459 103H849L840 113Q806 148 779 196T756 254Q756 255 760 264T770 286T786 315T809 351T840 387L849 397H459Q69 397 65 399Q55 406 55 416"],8650:[694,194,833,83,749,"230 681Q240 694 251 694Q260 693 270 680V-98L280 -89Q297 -73 314 -60T348 -38T374 -24T397 -13T412 -6H414Q428 -6 473 -32T552 -89L562 -98V291L563 680Q570 693 582 693Q593 694 602 681V-99L612 -90Q635 -68 668 -47T723 -15T748 -5Q749 -5 749 -28V-51Q642 -91 582 -194L577 -184Q551 -141 512 -108T447 -63T416 -51T385 -63T321 -108T255 -184L250 -194Q189 -89 83 -51V-28Q83 -5 84 -5Q88 -5 109 -15T164 -46T220 -90L230 -99V681"],8651:[514,14,1e3,55,944,"195 504L198 514H221Q244 514 244 512Q244 508 239 490T215 437T171 376L162 367H545Q928 367 932 365Q944 360 944 347T932 329Q928 327 492 327H55V347L67 354Q113 379 146 420T195 504ZM67 171Q70 173 507 173H944V153L932 146Q839 95 804 -4L801 -14H778Q755 -14 755 -12Q768 59 828 124L837 133H454Q71 133 67 135Q55 140 55 153Q55 165 67 171"],8652:[514,14,1e3,55,944,"755 512Q755 514 778 514H801L804 503Q805 501 812 486T824 462T839 437T862 408T892 381T932 354L944 347V327H507Q70 327 67 329Q55 335 55 347T67 365Q70 367 454 367H837L828 376Q803 403 785 437T761 489T755 512ZM55 153V173H492Q928 173 932 171Q944 166 944 153T932 135Q928 133 545 133H162L171 124Q198 95 216 61T239 8L244 -12Q244 -14 221 -14H198L195 -4Q160 95 67 146L55 153"],8653:[535,35,1e3,54,942,"397 525Q410 525 414 524T418 516Q418 506 394 467T331 381L319 367H473L624 369L657 445Q674 487 684 507T699 531T709 534Q717 534 722 528T728 516Q728 510 695 434Q689 418 683 402T672 377T668 367H928Q942 355 942 347Q942 341 928 327H791Q651 327 651 325Q649 324 620 251T586 174Q586 172 757 172H928Q942 158 942 152Q942 143 928 132H568L537 54Q510 -9 503 -22T486 -35Q479 -35 473 -29T466 -17T495 61L526 132H319L331 118Q364 81 391 37T418 -17Q418 -23 415 -24T401 -26Q398 -26 397 -26L384 -24L377 -13Q344 49 301 97T218 170T143 210T84 233T55 245Q54 253 59 256T86 267Q281 327 377 512L384 525H397ZM606 325Q606 327 439 327H275Q258 312 179 265L148 249Q228 206 262 181L275 172H544L575 247L606 325"],8654:[534,37,1e3,32,965,"395 -24T395 -19T417 57T440 132H255L266 116Q308 64 340 -6Q342 -17 337 -21Q335 -26 320 -26T302 -19Q302 -15 294 4T265 54T217 117T145 182T49 236Q30 243 33 254Q40 261 49 263Q98 283 142 315T214 379T263 442T293 493T302 519Q305 525 320 525T337 521Q342 516 340 505Q308 435 266 383L255 370L384 367H515Q561 522 569 530Q574 534 580 534Q587 534 594 528T602 516Q602 512 580 441T557 367H651L742 370L731 383Q689 435 657 505Q655 516 660 521Q662 525 677 525T695 519Q695 515 703 496T732 446T780 383T853 317T949 263Q967 258 964 245Q959 240 949 236Q897 215 852 182T779 116T731 52T703 3T695 -19Q692 -26 677 -26T660 -21Q655 -17 657 -6Q670 21 682 42T702 77T717 99T728 114T735 122T739 126T740 130T613 132H482L460 54Q440 -9 433 -23T415 -37Q408 -37 402 -31ZM502 325Q502 327 360 327H217L195 310Q173 291 120 256L111 250Q114 248 143 229T195 190L217 172H335L453 174L502 325ZM886 250Q885 251 865 263T831 286T802 310L780 327H544L535 299Q531 283 511 223L495 174L637 172H780L802 190Q843 225 877 243L886 250"],8655:[534,36,1e3,55,943,"346 174Q348 176 378 249T411 325Q411 327 239 327H68Q55 342 55 347Q55 354 68 367H428L459 445Q487 509 494 521T510 534Q517 534 524 527T531 516Q531 515 502 438L471 367H677L666 381Q631 421 605 463T578 516Q578 522 582 523T599 525H615L619 512Q659 437 714 383T812 309T896 272T942 254Q943 246 938 243T911 232Q718 172 619 -13L615 -24L599 -26Q578 -26 578 -17Q578 -11 587 6T617 53T666 118L677 132H373L339 54Q323 12 313 -8T298 -32T288 -35Q280 -35 275 -29T269 -17Q269 -14 298 57T328 132H68Q55 145 55 152Q55 156 56 158T62 165T68 172H206Q346 172 346 174ZM848 249Q763 297 735 318L722 327H455L422 252L391 174Q391 172 557 172H722L735 181Q773 210 819 234L848 249"],8666:[611,111,1e3,76,945,"944 54Q942 44 929 36H372Q372 34 377 26T395 -4T422 -58Q442 -109 442 -110T408 -111H374L370 -100Q282 124 87 243L76 250L87 257Q284 377 370 600L374 611H408Q442 611 442 610Q423 550 381 480Q380 478 379 475T376 471T374 468T372 465V464H929Q942 456 944 446Q944 442 943 439T941 434T938 430T935 428T931 426T928 424H344L336 414Q277 336 200 277L191 270H560Q929 270 933 268Q944 262 944 250Q944 237 933 232Q929 230 560 230H191L200 223Q279 162 336 86L344 76H928Q929 76 931 75T934 73T938 70T941 66T943 61T944 54"],8667:[611,111,1e3,55,923,"56 250Q56 260 68 270H808L799 277Q720 338 663 414L655 424H363Q71 424 68 426Q55 432 55 444T68 462Q71 464 349 464H627Q627 466 622 474T604 504T577 558Q557 609 557 610T591 611H626L629 600Q717 376 912 257L923 250L912 243Q715 123 629 -100L626 -111H591Q557 -111 557 -110Q576 -50 618 20Q619 22 620 25T623 29T625 32T626 35L627 36H349Q71 36 68 38Q55 44 55 56T68 74Q71 76 363 76H655L663 86Q722 164 799 223L808 230H438L68 231Q56 236 56 250"],8669:[417,-83,1e3,56,943,"76 230Q68 230 62 237T56 250Q56 257 63 264T91 291Q102 300 108 306L159 351Q168 356 177 351L218 316L303 239L353 195Q376 214 403 239L488 316L529 351Q538 356 546 351Q548 350 594 310L638 270H848L841 278Q813 309 792 344T763 396T755 416Q755 417 778 417H801Q817 367 856 323T943 250Q895 221 856 177T801 83H778Q755 83 755 84Q755 86 762 103T791 156T841 222L848 230H737Q625 230 622 232Q620 233 599 251T558 288L537 306Q537 305 451 228T362 149Q353 146 345 149Q341 150 255 227T169 306Q167 306 129 270Q123 265 115 257T102 245T93 237T84 232T76 230"],8672:[437,-64,1334,64,1251,"292 419Q292 400 261 347T211 275H306H364Q400 275 411 271T422 250T411 230T366 225H306H211Q214 222 232 197T271 136T292 82Q292 71 285 68T262 64H250H241Q221 64 216 67T205 83Q186 127 153 167T78 230Q64 238 64 250Q64 258 69 263T82 272T106 288T139 318Q162 342 177 365T198 402T209 425T223 436Q224 437 252 437H258Q292 437 292 419ZM501 237T501 250T515 270H819Q834 262 834 250T819 230H515Q501 237 501 250ZM918 237T918 250T932 270H1236Q1251 262 1251 250T1236 230H932Q918 237 918 250"],8674:[437,-64,1334,84,1251,"84 237T84 250T98 270H402Q417 262 417 250T402 230H98Q84 237 84 250ZM501 237T501 250T515 270H819Q834 262 834 250T819 230H515Q501 237 501 250ZM1022 417Q1022 437 1055 437H1067Q1090 437 1097 434T1109 417Q1128 373 1161 333T1236 270Q1251 261 1251 250Q1251 241 1244 236T1216 217T1175 182Q1149 155 1133 128T1109 85T1097 66Q1093 64 1065 64H1053Q1031 64 1025 72T1027 100Q1036 124 1049 147T1073 185T1091 210T1101 223L1103 225H1008H950Q914 225 903 229T892 250T903 270T948 275H1008H1103L1101 277Q1100 280 1091 291T1067 325T1039 374Q1022 408 1022 417"]});
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/Arrows.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{57350:[430,23,222,-20,240,"91 417Q104 430 111 430T131 417V301L171 341Q201 373 207 378T220 384Q227 384 233 377T240 366Q240 357 187 299L131 244V-10Q116 -23 111 -23T91 -10V201L49 157Q20 127 14 121T0 115Q-8 115 -14 121T-20 132Q-20 139 17 178Q29 191 36 199L91 257V417"],57351:[431,24,389,-20,407,"56 417Q68 431 76 431L89 426L96 419V317L98 215L193 273L291 330V375L293 419Q301 431 311 431Q331 431 331 388L333 355L356 370Q381 384 388 384Q394 384 400 377T407 363Q407 354 367 328L331 308V-10Q316 -23 310 -23Q300 -23 293 -12L291 135V284L98 168L96 77V-12Q84 -24 76 -24L62 -19L58 -12L56 66V144L31 128Q5 114 -2 114Q-8 114 -14 121T-20 136Q-20 142 -14 147T20 170L56 190V417"],57352:[605,85,778,55,719,"477 261Q477 257 473 256T455 253T417 251T348 250H235L155 -77L146 -82Q137 -85 109 -85Q55 -85 55 -77L139 261Q224 596 226 598Q229 603 239 603Q240 603 254 603T290 603T341 604T405 605T477 605Q656 603 687 602T719 596Q719 589 692 588T513 585H319L282 427L242 272Q242 270 351 270Q388 270 410 270T444 269T460 267T469 265T477 261"],57353:[434,6,667,37,734,"228 325Q170 322 156 316T127 309Q108 309 104 314Q99 319 99 322T108 341Q125 376 171 400T268 425H271Q302 425 319 396Q328 377 328 358Q328 332 324 314Q311 270 286 221Q274 194 274 192H275Q339 234 484 325T639 421Q669 434 691 434T723 425T734 406Q734 394 719 381Q715 376 644 330L575 287L566 267Q543 233 526 176Q520 160 515 143T508 115T506 105Q506 103 533 103Q585 103 607 110T641 118Q670 118 670 107Q670 100 661 85Q643 50 598 27T504 3Q465 3 450 36Q441 51 441 73Q441 84 444 96Q452 146 484 205L497 236L324 125Q143 12 135 10Q103 -6 77 -6Q61 -6 49 2T37 21Q37 36 49 46T124 96L195 141L204 156Q219 179 243 248T264 323Q264 325 228 325"],57356:[752,284,778,81,694,"86 472Q93 477 381 614T673 752Q680 752 686 746T693 732T689 721Q686 715 418 590L151 461L418 332Q684 207 689 201Q693 195 693 190Q693 183 687 177T675 170Q668 170 380 307T86 450Q82 454 82 461Q82 467 86 472ZM369 101V126Q369 156 382 156H384Q385 157 386 157Q409 157 409 115V98V54H680Q693 39 693 34T680 14H409V-142H680Q693 -155 693 -162Q693 -167 680 -182H409V-273Q396 -284 388 -284Q382 -284 369 -275V-182H95Q82 -167 82 -162Q82 -155 95 -142H369V14H95Q93 17 89 21T84 27T82 34T83 40T89 47T95 54H369V101"],57357:[752,284,778,81,693,"89 745Q95 752 100 752Q106 752 394 615T689 472Q693 468 693 461T689 450Q684 445 396 308T100 170Q95 170 89 176T82 190Q82 195 86 201Q91 208 358 332L624 461L358 590Q90 715 86 721Q82 725 82 731Q82 739 89 745ZM369 101V126Q369 156 382 156H384Q385 157 386 157Q409 157 409 115V98V54H680Q693 39 693 34T680 14H409V-142H680Q693 -155 693 -162Q693 -167 680 -182H409V-273Q396 -284 388 -284Q382 -284 369 -275V-182H95Q82 -167 82 -162Q82 -155 95 -142H369V14H95Q93 17 89 21T84 27T82 34T83 40T89 47T95 54H369V101"],57358:[919,421,778,82,694,"97 172Q82 172 82 190Q82 197 86 201Q94 209 173 246T327 319T402 357Q405 360 434 448T462 539L278 628Q96 713 86 721Q82 725 82 732T88 745T102 752Q103 752 125 742T198 709T293 666Q342 642 385 622T453 590T478 579Q479 579 506 659T562 824T598 915Q602 919 609 919T622 913T629 901Q629 898 571 728Q546 656 531 608T518 559Q555 539 602 519Q664 488 679 479T694 461Q694 457 689 450Q680 443 616 413T494 356T435 326L389 190L342 57L513 55H682Q694 43 694 34Q694 28 689 21L682 17L506 15H329L322 -8Q320 -13 310 -41T295 -85L275 -141H680Q682 -143 684 -146T688 -151T691 -156T693 -162Q693 -172 682 -179L473 -181H262L220 -303Q192 -388 185 -404T166 -421Q160 -421 153 -415T146 -403Q146 -400 179 -302T220 -185Q220 -181 158 -181L93 -179L86 -174Q82 -169 82 -161Q82 -152 93 -141H164L233 -139L260 -63L286 15H189L93 17L86 21Q82 26 82 34Q82 44 93 55H198L300 57L342 179Q350 204 361 238T378 286T382 301L246 237Q111 172 97 172ZM624 461Q621 464 560 492Q512 518 503 518Q500 518 500 517Q499 513 488 479T465 413T453 379L624 461"],57359:[801,303,778,82,694,"97 54Q82 54 82 72Q82 79 86 84Q95 91 222 153L351 215L398 324L442 433L258 519Q95 597 87 604Q82 608 82 615T88 628T102 635Q107 635 424 484L458 468L524 630Q593 789 597 795Q601 801 609 801Q616 801 622 795T629 781L562 615L493 450L589 406Q665 371 679 362T694 344Q694 339 693 337T677 326T631 302T538 257Q504 241 465 223T406 195T386 186Q383 185 344 92T306 -3L486 81Q662 168 673 168Q680 168 686 162T693 148T689 137Q688 136 482 35L280 -59L233 -176Q184 -291 178 -299Q172 -303 166 -303T153 -297T146 -283Q146 -279 185 -186T224 -90Q225 -88 223 -88Q219 -88 193 -101Q109 -143 98 -143Q82 -138 82 -122Q82 -116 85 -113T108 -98T171 -67L249 -30L289 61Q297 81 307 107T321 144T326 157L218 106Q109 54 97 54ZM553 379Q480 412 480 415Q479 415 460 372T423 285T406 241Q408 240 516 291T624 344L553 379"],57360:[801,303,778,81,694,"102 168Q103 168 151 146T247 102T295 81Q299 85 322 144T344 206L218 268Q153 297 123 313T87 333T82 344T86 355Q104 369 291 455Q491 552 491 553L542 673Q581 767 590 784T609 801Q616 801 622 795T629 781Q629 773 586 677Q546 581 546 577L609 606Q669 635 673 635Q680 635 686 629T693 615Q693 610 692 608T670 593T604 561L524 521L400 226L542 157Q617 123 649 107T687 85T694 72Q694 66 690 60T679 54Q665 54 526 119Q394 186 386 186Q385 186 342 88L331 61L509 -23Q680 -105 688 -111Q693 -115 693 -122T688 -135T675 -141H673Q664 -141 491 -59Q320 21 316 21H315L249 -136Q183 -293 178 -299Q172 -303 166 -303T153 -297T146 -283Q146 -282 154 -261T181 -197T213 -119L280 41Q280 46 186 86Q157 101 121 119Q92 133 87 136T82 148Q82 155 88 161T102 168ZM418 370L466 495Q464 495 308 420T151 344T204 317T311 267T364 244Q364 247 418 370"],57361:[919,421,778,82,694,"82 34Q82 44 93 55H198L300 57L342 179Q351 207 362 238T378 286T384 303T238 377Q109 435 86 450Q82 454 82 460T86 472Q90 476 302 579L511 679Q512 679 553 795Q569 842 577 866T592 903T600 917T608 919Q615 919 622 912T629 901Q629 899 595 799Q589 777 581 753T569 717T564 703L618 728Q666 752 673 752T686 746T693 732Q693 723 683 717T615 683L546 650L491 488Q464 410 450 368T438 326Q493 297 562 266Q660 219 677 209T694 190Q694 183 690 177T678 171Q664 171 546 228L424 286Q422 286 382 172L342 57L513 55H682Q694 43 694 34Q694 28 689 21L682 17L506 15H329L322 -8Q320 -13 310 -41T295 -85L275 -141H680Q682 -143 684 -146T688 -151T691 -156T693 -162Q693 -172 682 -179L473 -181H262L220 -303Q192 -388 185 -404T166 -421Q160 -421 153 -415T146 -403Q146 -400 179 -302T220 -185Q220 -181 158 -181L93 -179L86 -174Q82 -169 82 -161Q82 -152 93 -141H164L233 -139L260 -63L286 15H189L93 17L86 21Q82 26 82 34ZM495 623Q495 626 493 626T321 544T151 461L398 343Q399 343 405 360T423 415T446 483Q457 513 469 551T488 606T495 623"],57366:[828,330,778,82,694,"82 -6Q82 1 95 14H262L295 94Q331 171 331 174Q324 175 312 178T267 194T206 227T146 283T98 368Q84 406 84 461T98 554Q126 632 194 685T349 750Q360 752 480 752H591L604 783Q620 819 624 821Q631 828 640 828Q653 825 658 810Q658 808 646 781L635 754Q635 752 658 752Q680 752 686 746Q693 739 693 732Q693 728 692 726T686 719T680 712H615L506 466Q479 407 451 344T408 248T393 214Q393 210 535 210H680Q693 194 693 190T680 170H373L340 92L304 14H680Q693 1 693 -6Q693 -11 680 -26H286L253 -103L218 -179L451 -181H682Q694 -193 694 -201Q694 -212 682 -219L440 -221H200L178 -270Q160 -309 154 -319T139 -330Q122 -330 118 -312L155 -223Q155 -221 126 -221H95Q82 -206 82 -201T95 -181H175L206 -108Q237 -35 242 -30Q242 -26 169 -26H95Q82 -11 82 -6ZM571 710Q571 712 469 712Q443 712 416 712T371 711T351 710Q279 700 221 656T138 548Q124 508 124 461T138 374Q186 245 351 212L460 459Q571 709 571 710"],57367:[752,332,778,81,694,"82 -14T82 -7T95 15H431L529 170H435Q341 170 333 175Q149 218 98 368Q84 406 84 461Q84 515 98 555Q126 633 193 686T346 750Q347 750 373 750T440 751T520 752H680Q693 739 693 732Q693 727 680 712H526Q364 712 353 710Q268 700 207 646T126 512Q123 496 123 461T126 410Q141 350 180 304T280 232Q312 217 344 214T464 210H555L589 261Q613 301 620 311T635 321Q644 321 650 315T657 301Q657 296 651 286T630 252T604 212Q604 210 642 210H680Q693 197 693 190Q693 186 692 184T686 177T680 170H578L526 92L478 17L580 15H682Q693 4 693 -4T680 -25H451L353 -179L518 -181H682Q694 -193 694 -201Q694 -211 682 -219L504 -221H326L293 -272Q257 -332 246 -332Q238 -332 232 -326T225 -313Q225 -310 226 -308Q226 -305 251 -265T278 -223Q278 -221 186 -221H95Q93 -218 89 -214T84 -208T82 -201T95 -181H306L404 -25H249L93 -23L86 -19Q82 -14 82 -7"],57368:[828,330,778,82,694,"82 732Q82 739 95 752H251H348Q420 752 460 744T551 708Q566 697 566 701Q618 815 624 821Q631 828 640 828Q653 825 658 810L600 677Q600 671 615 656T653 605T689 517Q692 496 692 461T689 406Q668 325 615 266Q572 221 513 196T391 170H373L340 92L304 14H680Q693 1 693 -6Q693 -11 680 -26H286L253 -103L218 -179L451 -181H682Q694 -193 694 -201Q694 -212 682 -219L440 -221H200L178 -270Q160 -309 154 -319T139 -330Q122 -330 118 -312L155 -223Q155 -221 126 -221H95Q82 -206 82 -201T95 -181H175L206 -108Q237 -35 242 -30Q242 -26 169 -26H95Q82 -11 82 -6Q82 1 95 14H262L295 92L331 170H95Q93 172 91 175T87 180T84 185T82 191Q82 199 93 210H220L349 212L549 659Q507 692 462 702T338 712H249H95Q82 727 82 732ZM652 473Q652 513 636 552T603 611T582 632Q581 632 487 422T393 210Q424 210 460 220T535 253T605 316T649 410Q652 427 652 461V473"],57369:[752,333,778,82,693,"82 732Q82 739 95 752H251Q415 752 426 750Q539 736 615 657Q667 599 689 517Q692 496 692 461T689 406Q668 325 615 266Q522 170 382 170H355L326 95Q319 80 311 59T298 28T293 17Q293 15 486 15H680Q693 0 693 -6T680 -25H275L213 -179L449 -181H682Q693 -192 693 -199T680 -221H198L178 -270Q153 -333 139 -333Q132 -333 126 -327T119 -314T135 -266T153 -223Q153 -221 124 -221H95Q82 -207 82 -201T95 -181H171L233 -25H162L93 -23L86 -19Q82 -14 82 -7T95 15H251L313 170H202L93 172L86 177Q82 182 82 190Q82 199 93 210H211L329 212L349 261Q366 301 372 311T386 321Q392 321 399 315T407 302Q407 295 390 254T373 210Q374 209 377 209Q412 209 444 217Q512 231 564 273T638 377Q651 414 651 461Q651 509 638 548Q613 613 555 656T422 710Q411 712 249 712H95Q82 727 82 732"],57370:[634,255,778,84,694,"693 -115T693 -122T680 -144H315L269 -199Q221 -255 213 -255H212Q203 -255 197 -248T193 -231Q195 -225 229 -184L262 -144H186L113 -142L106 -137Q102 -130 102 -125Q102 -119 115 -104H298L426 52H386Q342 54 309 63Q236 79 180 129T98 249Q84 289 84 343Q84 398 98 436Q126 514 193 567T346 632Q347 632 373 632T440 633T520 634H680Q682 631 686 627T691 621T693 614T680 594H526Q364 594 353 592Q268 581 207 528T126 394Q123 378 123 343T126 292Q141 231 181 185T280 114Q329 92 415 92H462L506 147Q554 203 562 203H563Q572 203 578 196T582 178Q579 173 546 132L513 94L598 92H682Q693 81 693 73T680 52H480L349 -102L515 -104H682Q693 -115 693 -122"],57371:[634,254,778,82,691,"82 610T82 614T83 620T89 627T95 634H251Q378 634 409 633T469 623Q540 604 596 554T678 436Q691 397 691 343T678 249Q653 181 597 131T469 63Q427 52 362 52H315L213 -102L438 -104H662Q673 -115 673 -123Q673 -129 660 -144H186L151 -197Q114 -250 109 -253Q106 -254 104 -254Q100 -254 98 -253Q91 -253 87 -248T82 -235Q82 -230 109 -186L138 -144H115Q82 -144 82 -125Q82 -119 95 -104H166L266 49Q266 52 182 52H95Q82 65 82 72Q82 76 83 78T89 85T95 92H295L329 143Q365 195 369 198Q372 203 380 203Q385 203 391 197T398 185Q398 184 398 184L399 182Q399 175 369 129L344 94Q344 92 376 92Q402 92 422 94Q496 104 554 147T638 256Q651 295 651 343Q651 390 638 429Q613 494 555 537T422 592Q411 594 249 594H95Q82 610 82 614"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/PUA.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{10003:[706,34,833,84,749,"84 231Q84 244 114 264T170 285Q176 285 183 274T224 205Q267 129 268 129Q271 141 279 163T318 250T389 378T502 523T662 673Q702 706 732 706H734Q749 706 749 695Q749 682 730 666T660 607T559 505Q387 299 328 29Q324 0 295 -17T245 -34H241Q234 -34 225 -21T185 46Q166 79 154 101Q84 223 84 231"],10016:[716,22,833,48,786,"195 702T195 706T201 716H632Q638 710 638 706T636 700T621 690Q436 581 427 374V357H430Q554 357 645 421Q682 447 711 483T755 542T770 567Q775 572 786 563V131Q777 125 774 125T762 139Q709 228 642 274T482 333Q452 337 430 337H427V320Q430 279 437 247T462 170T521 82T621 4Q630 -2 633 -4T637 -7T638 -12Q638 -16 632 -22H201Q195 -16 195 -12T197 -6T212 4Q397 113 406 320V337H403Q279 337 188 273Q151 247 122 211T78 152T63 127Q58 122 48 131V563Q54 569 59 569Q62 569 71 555Q124 466 191 420T351 361Q381 357 403 357H406V374Q403 415 396 447T371 525T312 613T212 690Q199 697 197 699"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/Dingbats.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{295:[695,13,540,42,562,"182 599Q182 611 174 615T133 619Q118 619 114 621T109 630Q109 636 114 656T122 681Q125 685 202 688Q272 695 286 695Q304 695 304 684Q304 682 295 644T282 597Q282 592 360 592H399Q430 592 445 587T460 563Q460 552 451 541L442 535H266L251 468Q247 453 243 436T236 409T233 399Q233 395 244 404Q295 441 357 441Q405 441 445 417T485 333Q485 284 449 178T412 58T426 44Q447 44 466 68Q485 87 500 130L509 152H531H543Q562 152 562 144Q562 128 546 93T494 23T415 -13Q385 -13 359 3T322 44Q318 52 318 77Q318 99 352 196T386 337Q386 386 346 386Q318 386 286 370Q267 361 245 338T211 292Q207 287 193 235T162 113T138 21Q128 7 122 4Q105 -12 83 -12Q66 -12 54 -2T42 26L166 530Q166 534 161 534T129 535Q127 535 122 535T112 534Q74 534 74 562Q74 570 77 576T84 585T96 589T109 591T124 592T138 592L182 595V599"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/LatinExtendedA.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{8245:[560,-43,275,12,244,"12 501Q12 527 31 542T63 558Q73 560 77 560Q114 560 128 528Q133 518 188 293T244 61Q244 56 223 50T195 43Q192 43 190 45T102 263T14 486Q12 496 12 501"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/GeneralPunctuation.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{9733:[694,111,944,49,895,"367 395Q374 416 398 492T442 627T463 688Q463 692 467 692Q471 694 472 694Q478 694 484 680T523 562Q553 469 576 400L577 395H731H819Q872 395 883 394T895 384Q895 380 891 376T832 333Q794 305 767 285Q643 195 643 194L690 47Q737 -96 737 -103Q737 -111 727 -111Q721 -111 594 -18L472 71L350 -18Q223 -111 217 -111Q207 -111 207 -103Q207 -96 254 47L301 194Q301 195 241 239T118 328T51 378Q49 382 49 384Q49 392 58 393T110 395H213H367"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/MiscSymbols.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{710:[845,-561,2333,-14,2346,"1 561Q-3 563 -6 577T-12 604L-14 618Q-14 625 -7 628T23 635Q31 636 36 637Q63 641 621 745Q1148 845 1165 845Q1167 845 1752 739L2338 630Q2346 630 2346 618Q2340 565 2332 561Q2329 561 1749 654Q1617 675 1466 699T1241 736T1167 748Q1165 748 1093 737T867 700T583 654Q3 561 1 561"],732:[899,-628,2333,1,2330,"804 788Q717 788 606 772T397 732T213 685T75 645T18 628Q11 628 11 632Q8 637 4 668T2 704Q2 713 36 732Q55 739 242 795Q622 898 826 898Q893 898 947 895Q1009 887 1056 872T1187 819Q1286 776 1356 758T1527 739Q1614 739 1725 755T1934 795T2118 842T2256 882T2313 899Q2320 899 2320 895Q2323 890 2327 860T2329 824Q2329 818 2296 795Q2273 787 2089 732Q1810 657 1598 632Q1562 629 1492 629Q1389 629 1320 644T1144 708Q1048 751 977 769T804 788"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/SpacingModLetters.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{8994:[378,-122,778,55,722,"77 122Q68 122 63 126T57 135T55 142Q55 151 68 176T111 235T177 302T271 356T388 378Q451 378 508 355T602 300T668 233T709 174T722 142Q722 124 704 122Q692 122 685 134T658 179T606 243Q511 338 390 338Q354 338 320 329Q251 312 193 263T97 141Q87 123 77 122"],8995:[378,-142,778,54,722,"389 143Q324 143 266 164T171 215T107 277T67 330T55 358T60 371T77 378Q85 377 92 367T116 331T158 280Q256 182 389 182Q475 182 552 227T675 351Q688 378 704 378Q722 376 722 358Q722 352 710 330T670 276T605 215T511 164T389 143"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/MiscTechnical.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{989:[605,85,778,55,719,"477 261Q477 257 473 256T455 253T417 251T348 250H235L155 -77L146 -82Q137 -85 109 -85Q55 -85 55 -77L139 261Q224 596 226 598Q229 603 239 603Q240 603 254 603T290 603T341 604T405 605T477 605Q656 603 687 602T719 596Q719 589 692 588T513 585H319L282 427L242 272Q242 270 351 270Q388 270 410 270T444 269T460 267T469 265T477 261"],1008:[434,6,667,37,734,"228 325Q170 322 156 316T127 309Q108 309 104 314Q99 319 99 322T108 341Q125 376 171 400T268 425H271Q302 425 319 396Q328 377 328 358Q328 332 324 314Q311 270 286 221Q274 194 274 192H275Q339 234 484 325T639 421Q669 434 691 434T723 425T734 406Q734 394 719 381Q715 376 644 330L575 287L566 267Q543 233 526 176Q520 160 515 143T508 115T506 105Q506 103 533 103Q585 103 607 110T641 118Q670 118 670 107Q670 100 661 85Q643 50 598 27T504 3Q465 3 450 36Q441 51 441 73Q441 84 444 96Q452 146 484 205L497 236L324 125Q143 12 135 10Q103 -6 77 -6Q61 -6 49 2T37 21Q37 36 49 46T124 96L195 141L204 156Q219 179 243 248T264 323Q264 325 228 325"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/GreekAndCoptic.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{8463:[695,13,540,42,562,"150 475Q147 475 118 466T82 457Q73 457 64 467T54 487Q54 490 55 492Q63 506 64 506Q67 512 118 526Q162 541 169 546Q173 559 175 575Q181 596 181 604Q181 613 166 617Q164 617 153 618T135 619Q119 619 114 621T109 630Q109 636 114 656T122 681Q125 685 202 688Q272 695 286 695Q304 695 304 684Q304 682 291 628L278 577L386 612Q466 635 476 635T492 627T499 607Q499 593 489 586Q485 583 373 546L262 512Q262 511 248 455T233 397T236 397T244 404Q295 441 357 441Q405 441 445 417T485 333Q485 284 449 178T412 58T426 44Q447 44 466 68Q485 87 500 130L509 152H531H543Q562 152 562 144Q562 128 546 93T494 23T415 -13Q385 -13 359 3T322 44Q318 52 318 77Q318 99 352 196T386 337Q386 386 346 386Q318 386 286 370Q267 361 245 338T211 292Q207 287 193 235T162 113T138 21Q128 7 122 4Q105 -12 83 -12Q66 -12 54 -2T42 26Q42 45 98 257L151 475H150"],8487:[685,22,722,44,675,"126 584Q119 584 110 539T97 493Q95 490 73 490Q44 490 44 501Q44 515 62 590Q75 672 82 679Q84 684 177 684Q193 684 214 684T241 685Q265 685 271 682T277 664V648Q271 572 229 434T186 231Q186 173 203 132T247 70T302 42T360 33Q391 33 419 42T474 72T517 133T533 231Q533 297 491 437T442 648Q442 675 446 679Q448 684 542 684Q635 684 637 681Q640 678 657 594T675 501Q675 490 646 490Q624 490 622 493Q620 493 609 538T593 584Q591 585 585 585T569 586T551 588H513Q514 586 518 573T538 531T582 453Q647 340 660 277Q663 259 663 232Q663 194 657 177Q652 151 629 112T560 39Q495 -5 424 -19Q403 -22 360 -22Q318 -22 297 -19Q239 -8 193 18T120 74T80 131T62 177Q56 194 56 229Q56 281 74 328T137 453Q160 491 174 518T193 555T201 575T206 588H168Q160 587 150 587T134 586T126 584"],8498:[695,1,556,55,497,"457 681Q471 695 477 695Q485 695 497 681V12L484 -1H68Q55 14 55 19T68 39H457V328H215L211 335Q198 346 211 359L217 368H457V681"],8502:[763,21,667,-22,687,"56 706V726Q56 763 76 763Q83 763 87 759T98 741Q108 726 116 721L127 717L340 715Q547 712 564 709Q575 705 587 692Q599 680 605 663L609 650V137H676Q687 124 687 115Q687 110 678 100T622 43L558 -21H-9Q-22 -6 -22 -1T-13 14T42 72L107 137H569V339Q569 541 567 546Q558 555 554 557L545 563H329Q118 566 101 569Q90 573 78 586Q54 610 54 661Q54 670 56 706"],8503:[764,43,444,-22,421,"56 750Q68 764 76 764Q88 764 97 743T125 717Q131 715 240 715T358 713Q421 691 421 640Q421 608 399 588T358 566Q353 566 352 565T351 557L356 526Q356 488 379 346T402 97Q400 21 385 -12Q366 -43 351 -43Q335 -43 329 -10Q316 40 316 64Q316 67 315 67Q313 67 269 26L222 -21H-9Q-22 -7 -22 -1Q-22 4 -14 14T42 73L107 137H311V564H211H164Q115 564 93 573T60 615Q56 630 56 690V750"],8504:[764,43,667,54,640,"62 757Q69 764 75 764Q87 764 97 741Q102 731 105 728T117 721L129 715H349Q569 715 580 710Q618 701 635 670Q640 661 640 639Q640 609 622 590Q617 583 604 575T580 566H573V553Q575 547 576 531T582 469T600 353Q624 205 624 104Q624 46 617 17T591 -32Q581 -43 573 -43Q550 -43 540 44Q535 73 533 319V564H322Q117 566 100 570Q90 573 77 586Q54 609 54 663Q54 689 55 706Q55 738 56 745T62 757"],8513:[705,23,639,37,577,"239 665Q194 665 154 653T90 629T66 617Q59 617 53 623T46 637Q46 652 66 659Q129 695 197 701Q218 705 248 705Q293 705 335 693Q371 684 435 644Q543 562 573 417Q577 393 577 341Q577 290 573 266Q531 83 384 10Q346 -9 315 -16T234 -23H206Q202 -23 183 -23T152 -21T120 -18T88 -10T63 3T44 24L37 35V297L50 310H235Q248 297 248 290Q248 285 235 270H77V103Q77 88 77 80T77 63T78 50T80 43T82 38T85 35T89 32T95 30Q126 20 206 17Q289 17 330 30Q407 55 460 120T533 275Q538 305 538 342Q538 486 452 575T239 665"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/LetterlikeSymbols.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{9484:[694,-306,500,55,444,"76 306Q62 306 59 319T55 386V500V596Q55 664 57 676T68 692Q71 694 250 694Q428 694 432 692Q444 685 444 674Q444 665 432 656Q428 654 261 654H95V487Q95 355 95 336T90 312Q84 306 76 306"],9488:[694,-306,500,55,445,"424 306Q418 306 413 310T406 318L404 321V654H238Q71 654 68 656Q55 662 55 674T68 692Q71 694 250 694H379Q432 694 438 688Q443 683 443 662T444 500T444 338T438 312Q432 306 424 306"],9492:[366,22,500,55,444,"55 172V287Q55 341 58 353T76 366Q88 366 95 351V18H261Q428 18 432 16Q444 9 444 -2Q444 -11 432 -20Q428 -22 250 -22H120Q67 -22 61 -16Q56 -11 56 10T55 172"],9496:[366,22,500,55,444,"404 351Q410 366 424 366Q437 366 440 353T444 288V172V72Q444 8 443 -4T432 -20Q428 -22 250 -22Q71 -22 68 -20Q55 -14 55 -2T68 16Q71 18 238 18H404V351"],9585:[694,195,889,0,860,"19 -195Q13 -195 7 -188T0 -176Q0 -169 18 -151L822 683Q835 694 840 694T852 688T860 674Q860 667 810 614T460 252Q57 -167 44 -179Q27 -195 19 -195"],9586:[694,195,889,0,860,"0 675Q0 681 6 687T19 694Q27 694 44 678L460 247Q759 -62 809 -115T860 -175Q860 -183 852 -189T840 -195Q835 -195 822 -184L18 649Q0 667 0 675"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/BoxDrawing.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{770:[845,-561,0,-2347,13,"-2332 561Q-2336 563 -2340 577T-2346 604L-2347 618Q-2347 625 -2340 628T-2310 635Q-2302 636 -2297 637Q-2270 641 -1712 745Q-1185 845 -1168 845Q-1166 845 -581 739L5 630Q13 630 13 618Q7 565 -1 561Q-4 561 -584 654Q-716 675 -867 699T-1092 736T-1166 748Q-1168 748 -1240 737T-1466 700T-1750 654Q-2330 561 -2332 561"],771:[899,-628,0,-2332,-3,"-1529 788Q-1616 788 -1727 772T-1936 732T-2120 685T-2258 645T-2315 628Q-2322 628 -2322 632Q-2325 637 -2329 668T-2331 704Q-2331 713 -2297 732Q-2278 739 -2091 795Q-1711 898 -1507 898Q-1440 898 -1386 895Q-1324 887 -1277 872T-1146 819Q-1047 776 -977 758T-806 739Q-719 739 -608 755T-399 795T-215 842T-77 882T-20 899Q-13 899 -13 895Q-10 890 -6 860T-4 824Q-4 818 -37 795Q-60 787 -244 732Q-523 657 -735 632Q-771 629 -841 629Q-944 629 -1013 644T-1189 708Q-1285 751 -1356 769T-1529 788"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/CombDiacritMarks.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{9632:[689,0,778,55,722,"71 0Q59 4 55 16V346L56 676Q64 686 70 689H709Q719 681 722 674V15Q719 10 709 1L390 0H71"],9633:[689,0,778,55,722,"71 0Q59 4 55 16V346L56 676Q64 686 70 689H709Q719 681 722 674V15Q719 10 709 1L390 0H71ZM682 40V649H95V40H682"],9650:[575,20,722,84,637,"99 -20Q84 -11 84 0Q84 5 148 145T278 424L342 563Q347 575 360 575Q368 575 375 570Q376 569 441 430T571 148T637 0Q637 -11 622 -20H99"],9651:[575,20,722,84,637,"99 -20Q84 -11 84 0Q84 5 148 145T278 424L342 563Q347 575 360 575Q368 575 375 570Q376 569 441 430T571 148T637 0Q637 -11 622 -20H99ZM476 260L360 509L248 266Q137 24 135 22Q135 20 360 20Q586 20 586 21L476 260"],9654:[540,41,778,83,694,"83 523Q83 524 85 527T92 535T103 539Q107 539 389 406T680 268Q694 260 694 249Q694 239 687 234Q685 232 395 95L107 -41H101Q90 -40 83 -26V523"],9660:[576,19,722,84,637,"84 556Q84 567 99 576H622Q637 567 637 556Q637 551 572 409T441 127T375 -14Q368 -19 360 -19H358Q349 -19 342 -7T296 92Q249 193 211 275Q84 550 84 556"],9661:[576,19,722,84,637,"84 556Q84 567 99 576H622Q637 567 637 556Q637 551 572 409T441 127T375 -14Q368 -19 360 -19H358Q349 -19 342 -7T296 92Q249 193 211 275Q84 550 84 556ZM586 534Q586 536 361 536Q135 536 135 535L358 52L361 47L473 290Q584 532 586 534"],9664:[539,41,778,83,694,"694 -26Q686 -40 676 -41H670L382 95Q92 232 90 234Q83 239 83 249Q83 262 96 267Q101 270 379 401T665 537Q671 539 674 539Q686 539 694 524V-26"],9674:[716,132,667,56,611,"318 709Q325 716 332 716Q340 716 344 713T474 511Q611 298 611 292Q611 285 526 152Q494 103 474 72Q347 -128 344 -130Q340 -132 333 -132T322 -130Q319 -128 257 -31T131 169T60 278Q56 285 56 292Q56 298 60 305Q73 326 194 516T318 709ZM567 290T567 291T451 475T333 658L100 293Q100 288 215 108L333 -74Q334 -74 450 108"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/GeometricShapes.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{8705:[846,22,500,56,444,"404 269Q412 269 418 267T428 261T435 253T441 245L444 240V172Q444 103 443 96Q440 81 431 65T403 27T344 -7T250 -21T156 -8T97 27T69 65T58 96Q56 103 56 413Q56 722 58 729Q74 822 215 845Q221 846 229 846H243Q282 846 290 845Q422 826 443 729Q444 722 444 653V586L442 583Q441 580 440 578T436 573T430 567T423 562T415 558T404 556Q377 556 367 583Q364 590 364 654V719Q363 721 360 726T355 733Q326 766 250 766H249Q235 766 219 765T174 752T137 719V107Q145 83 178 71T251 58H254Q340 58 364 107V172Q364 176 364 187T363 204Q363 269 404 269"],8708:[860,166,556,55,497,"55 676Q55 688 66 694H199L333 696L351 772Q364 827 370 843T386 860Q393 860 399 854T406 841Q406 836 391 765L375 696Q375 694 431 694H484Q491 688 497 681V12L493 5L486 1L353 -1H219L202 -79Q184 -153 180 -159Q175 -166 165 -166Q146 -166 146 -148Q146 -141 161 -76T177 -4Q177 -1 122 -1H68Q55 12 55 20T66 39H126L186 41L219 181Q226 215 234 251T246 305T251 325Q251 328 166 328H79Q68 345 68 347Q68 352 75 359L82 368H262L291 505Q298 539 306 575T319 630T324 650V654H68Q55 669 55 676ZM457 368V654H411Q366 654 366 652Q365 651 361 634T349 580T333 514Q303 373 302 372V368H457ZM457 39V328H375Q293 328 293 325Q292 322 260 183T228 41T344 39H457"],8709:[587,3,778,55,720,"624 470Q624 468 639 446T668 382T683 291Q683 181 612 99T437 -1Q425 -2 387 -2T337 -1Q245 18 193 70L179 81L131 39Q96 8 89 3T75 -3Q55 -3 55 17Q55 24 61 30T111 73Q154 113 151 113Q151 114 140 130T115 177T95 241Q94 253 94 291T95 341Q112 431 173 495Q265 587 385 587Q410 587 437 581Q522 571 582 513L595 501L642 541Q689 586 695 586Q696 586 697 586T699 587Q706 587 713 583T720 568Q720 560 711 551T664 510Q651 499 642 490T628 475T624 470ZM564 477Q517 522 448 539Q428 546 375 546Q290 546 229 492T144 370Q133 332 133 279Q136 228 151 195Q157 179 168 160T184 141Q186 141 375 307T564 477ZM642 290Q642 318 637 343T625 386T611 416T598 436T593 444Q590 444 402 277T213 108Q213 104 231 89T293 55T392 37Q495 37 568 111T642 290"],8717:[440,1,429,102,456,"154 -1Q122 -1 112 3T102 26Q102 63 158 63H178Q192 64 206 65T228 66T240 68Q301 85 324 146L329 157H244Q158 157 153 161Q149 162 145 169T140 183Q140 201 158 215L167 221H256L344 223L349 237Q352 262 352 287Q352 308 351 315Q341 352 315 368T256 385Q231 385 206 376T166 356T149 346Q143 346 138 364T132 388Q132 396 147 406Q198 440 252 440Q291 440 318 435Q421 404 451 301Q456 288 456 248V234Q456 151 391 86Q330 25 240 3Q212 -1 154 -1"],8722:[270,-230,500,84,417,"84 237T84 250T98 270H402Q417 262 417 250T402 230H98Q84 237 84 250"],8724:[766,93,778,57,722,"339 717Q339 739 354 752T388 766Q410 766 424 751T439 716T424 681T390 666Q369 666 354 681T339 717ZM57 237T57 250T71 270H369V425L370 581Q380 594 389 594Q402 594 409 579V270H707Q722 262 722 250T707 230H409V-79Q401 -93 391 -93H389H387Q375 -93 369 -79V230H71Q57 237 57 250"],8726:[430,23,778,91,685,"91 404T91 410T97 423T111 430Q117 430 395 224Q676 13 678 10Q685 3 685 -3T678 -16T664 -23Q658 -23 380 184T98 397Q91 404 91 410"],8733:[472,-28,778,56,722,"56 250Q56 346 122 409T276 472Q349 472 407 430T486 326L489 316Q490 317 493 326T501 345T514 367T531 393Q557 425 602 448T698 472Q722 472 722 452Q722 437 702 435T642 421T571 377Q520 323 520 250Q520 179 568 126T693 68Q722 66 722 48Q722 28 698 28Q636 28 576 67T493 174L490 184Q489 181 483 167T475 150T468 136T458 120T447 107T432 90T412 73Q350 28 277 28Q188 28 122 91T56 250ZM199 68T278 68T408 122T459 250Q459 322 414 370T308 430Q302 431 273 431Q204 431 150 380T96 250Q96 176 147 122"],8736:[694,0,722,55,666,"71 0L68 2Q65 3 63 5T58 11T55 20Q55 22 57 28Q67 43 346 361Q397 420 474 508Q595 648 616 671T647 694T661 688T666 674Q666 668 663 663Q662 662 627 622T524 503T390 350L120 41L386 40H653Q666 30 666 20Q666 8 651 0H71"],8737:[714,20,722,55,666,"71 0L68 2Q65 3 63 5T58 11T55 20Q55 22 57 28Q64 38 348 373T638 712Q644 714 646 714Q653 714 659 709T666 694V693Q666 687 633 647Q619 631 576 580Q528 524 495 485Q336 296 329 289Q328 288 348 264T395 182T433 54L434 40H651Q666 32 666 20T651 0H436Q431 -20 416 -20Q400 -20 396 -4V0H71ZM394 40Q394 51 389 76T366 149T319 234L302 256L119 41L256 40H394"],8738:[551,51,722,55,666,"666 -32Q666 -51 646 -51Q639 -51 365 85L75 228Q55 238 55 250Q55 257 59 262T68 268L72 270L611 536Q642 551 647 551T659 547T666 532Q666 521 657 515L525 449Q525 448 535 424T556 352T566 250T556 148T536 77T525 51L657 -15Q666 -21 666 -32ZM526 250Q526 297 517 342T499 409T488 431Q487 431 304 341T121 250T304 159T488 69Q526 143 526 250"],8739:[430,23,222,91,131,"91 417Q104 430 111 430T131 417V-10Q116 -23 111 -23T91 -10V417"],8740:[750,252,278,-20,296,"118 737Q131 750 138 750L151 746L158 739V579L160 421L213 470Q269 519 276 519Q284 519 290 513T296 499V498Q296 493 291 488T244 445Q225 428 213 417L158 368V-239Q143 -252 136 -252L124 -248L120 -241L118 44V328L62 279Q4 231 0 230Q-8 230 -14 236T-20 250Q-20 257 -11 265T62 332L118 384V737"],8741:[431,23,389,55,331,"55 417Q69 431 76 431T95 419V-12Q84 -23 76 -23Q72 -23 69 -22T62 -16T55 -10V417ZM293 419Q300 431 310 431L324 424L331 417V-10Q316 -23 309 -23L297 -19L293 -12V419"],8742:[751,250,500,-20,518,"131 737Q134 739 138 743T144 748T151 750T171 737V199L327 357V737Q340 750 347 750Q351 750 353 749T360 743T367 737V397L429 457Q493 518 498 519Q506 519 512 512T518 500Q518 489 442 417L367 339V-237Q352 -250 346 -250L333 -243L327 -237V301L171 143V-237Q156 -250 151 -250T131 -237V101L69 41Q24 -3 15 -12T0 -21Q-8 -21 -14 -14T-20 -2Q-20 5 -7 19T56 81L131 159V737"],8756:[471,82,667,24,643,"273 411Q273 437 291 454T334 471Q358 471 375 454T393 411T376 368T333 351Q307 351 290 368T273 411ZM84 38Q110 38 126 21T143 -22Q143 -46 127 -64T83 -82Q57 -82 41 -65T24 -22Q24 4 41 21T84 38ZM524 -22Q524 4 541 21T584 38Q608 38 625 21T643 -22Q643 -45 627 -63T583 -82Q557 -82 541 -65T524 -22"],8757:[471,82,667,23,644,"23 411Q23 437 41 454T84 471Q108 471 125 454T143 411T126 368T83 351Q57 351 40 368T23 411ZM523 411Q523 437 541 454T584 471Q608 471 625 454T643 411T626 368T583 351Q557 351 540 368T523 411ZM274 -22Q274 4 291 21T334 38Q356 38 374 22T392 -22T375 -65T333 -82Q307 -82 291 -65T274 -22"],8764:[365,-132,778,55,719,"73 132Q55 132 55 172Q55 220 79 272Q95 301 111 319Q148 353 195 363Q199 364 212 364Q262 364 294 350T408 272Q472 222 522 212Q537 208 555 208Q606 208 646 243Q671 268 680 296T691 342T702 365Q713 365 716 354T719 314Q714 236 664 179L660 176Q657 173 654 170T644 163T631 154T615 146T596 139T574 134T549 132Q510 132 465 156T386 211T307 265T223 290Q162 290 124 249T86 165Q86 155 82 144T73 132"],8765:[367,-133,778,56,722,"222 133Q147 133 102 197T56 335Q56 362 66 365Q71 369 77 364Q83 356 84 335T90 298Q102 254 137 222T223 189Q258 189 292 206T355 250T413 301T477 346T550 367Q628 367 673 309T722 171Q722 133 708 133Q703 133 699 141T694 162Q694 220 655 265T555 311Q519 311 485 293T421 248T363 196T298 152T222 133"],8769:[467,-32,778,55,719,"220 366Q258 366 297 347T361 308T391 288Q394 288 464 370Q494 407 510 425T535 454T546 465T552 467H553Q560 467 566 461T573 448Q573 439 499 350Q424 266 424 261Q424 259 442 247T492 222T554 209Q607 209 646 243Q671 268 680 295T690 341T702 366Q719 366 719 314Q716 265 695 226Q682 199 664 179Q614 132 555 132Q517 132 477 151T412 190T383 210T347 172T278 89T233 37Q228 32 220 32Q210 32 206 38T201 48Q201 57 266 137Q272 144 275 148Q351 231 351 237Q351 239 333 251T283 276T221 289Q159 289 123 248T86 166Q86 156 82 145T73 132Q55 132 55 172Q55 220 79 272Q95 301 111 319Q161 366 220 366"],8770:[463,-34,778,55,720,"55 439T55 443T56 449T62 456T68 463H706Q720 449 720 443T706 423H68Q55 439 55 443ZM56 72Q56 112 73 152T130 225T224 257Q259 257 294 240T360 199T419 149T484 107T553 90Q603 90 643 125T691 223Q693 257 704 257Q717 257 717 221Q717 147 671 91T554 34Q517 34 481 51T414 93T355 142T291 184T222 201Q172 201 131 167T84 67Q81 34 71 34Q56 37 56 72"],8774:[652,155,778,54,720,"55 417Q55 479 101 528T222 578Q259 578 294 564T393 507Q413 493 434 480T469 460T484 454L537 549Q587 639 595 647Q600 652 607 652Q615 652 621 647T628 634Q628 625 575 536Q524 446 524 443Q527 440 555 440Q603 440 644 469T691 547Q694 578 706 578T718 556Q718 555 718 551T717 545Q717 488 684 445T595 387Q582 384 558 384Q530 384 508 389L493 394L404 238L557 236H708Q720 224 720 217T706 196H379L291 43L499 41H708Q720 29 720 21T706 1H268L226 -71Q186 -143 179 -148Q173 -155 165 -155T152 -150T146 -137Q146 -133 184 -64L222 1H144L66 3L59 7Q54 14 54 20Q54 29 66 41H246L333 194Q333 196 202 196H68Q55 211 55 218T66 236H213L357 238L457 409L437 421Q432 423 393 450T307 500T222 523Q171 523 129 491T84 414Q82 383 70 383Q55 383 55 417"],8776:[481,-49,778,55,719,"55 326Q55 394 101 437T226 481Q268 479 313 460T392 419T469 379T555 361Q622 361 662 401Q686 423 688 450Q693 479 702 479H705Q719 479 719 442Q719 367 670 327T554 286Q512 286 466 304T386 345T307 385T220 404Q184 404 157 394T120 374L111 363Q86 339 86 317Q86 288 71 288Q55 288 55 326ZM55 90Q55 164 105 205T226 246Q269 243 314 224T392 183T470 144T558 126Q622 126 662 166Q686 187 688 214Q693 244 704 244Q716 244 719 210Q719 165 702 132T658 82T605 58T552 50T498 58T447 77T384 110Q322 146 302 152Q263 168 220 168Q179 168 144 152Q128 147 107 125T86 81Q86 52 71 52Q55 52 55 90"],8778:[579,39,778,51,725,"220 523Q163 523 124 486T84 412Q81 383 69 383Q56 383 56 413Q56 441 67 470Q78 508 111 537T187 575Q203 579 219 579Q248 579 271 572Q304 565 393 508Q498 439 551 439Q620 439 662 486Q688 512 693 557Q693 565 697 572T707 579Q719 579 719 548Q719 483 673 434T550 384Q512 384 467 405T386 453T305 501T220 523ZM222 288Q164 288 124 251T84 177Q81 148 69 148Q56 148 56 178Q56 206 67 235Q78 274 111 302T187 339Q198 343 220 343Q244 343 259 341T308 322T393 272Q496 203 553 203Q612 203 651 241T691 312Q693 343 705 343Q719 343 719 313Q719 245 673 199Q626 148 552 148Q513 148 467 170T385 218T304 266T222 288ZM51 -19Q51 -6 62 -1H387Q713 -1 715 -3Q725 -10 725 -20Q725 -27 718 -34Q714 -38 672 -38T387 -39H62Q51 -25 51 -19"],8782:[492,-8,778,56,723,"245 367Q251 415 288 453T392 492Q445 492 485 456T532 367H707Q722 359 722 347Q722 334 711 331T665 327H608H509Q500 332 498 336Q496 338 493 363T472 411Q443 451 389 451H387Q335 451 305 411Q290 392 287 374T282 344T268 327H72Q56 332 56 347Q56 360 70 367H245ZM56 153Q56 168 72 173H268Q277 168 279 164Q281 162 284 137T305 89Q334 49 389 49H391Q442 49 472 89Q487 108 490 126T495 156T509 173H608H666Q701 173 711 170T722 153T707 133H532Q526 81 486 45T389 8Q331 8 291 45T245 133H70Q56 140 56 153"],8783:[492,-133,778,56,722,"245 367Q251 415 288 453T392 492Q445 492 485 456T532 367H707Q722 359 722 347Q722 334 711 331T665 327H608H509Q500 332 498 336Q496 338 493 363T472 411Q443 451 389 451H387Q335 451 305 411Q290 392 287 374T282 344T268 327H72Q56 332 56 347Q56 360 70 367H245ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153"],8785:[609,108,778,56,722,"421 474T389 474T339 493T321 541Q321 566 337 587T391 609Q456 602 456 541Q456 512 439 493ZM56 347Q56 360 70 367H707Q722 359 722 347Q722 336 708 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153ZM421 -108T389 -108T339 -89T321 -41Q321 -16 337 5T391 27Q456 20 456 -41Q456 -70 439 -89"],8786:[601,101,778,15,762,"15 541Q15 569 33 585T75 601T117 585T135 541Q135 514 118 498T75 481T32 498T15 541ZM56 347Q56 360 70 367H707Q722 359 722 347Q722 336 708 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153ZM642 -41Q642 -17 658 0T702 18Q726 18 744 3T762 -41Q762 -67 745 -84T702 -101Q676 -101 659 -85T642 -41"],8787:[601,102,778,14,762,"642 541Q642 569 660 585T702 601T744 585T762 541Q762 515 745 498T702 481Q676 481 659 497T642 541ZM56 347Q56 360 70 367H707Q722 359 722 347Q722 336 708 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153ZM14 -41Q14 -15 31 1T74 18Q101 18 118 0T135 -41Q135 -64 118 -83T75 -102Q51 -102 33 -85T14 -41"],8790:[367,-133,778,56,722,"56 347Q56 360 70 367H707Q722 359 722 347Q722 334 711 331T658 327H586H465L472 318Q496 288 496 250T472 182L465 173H586H663Q700 173 711 170T722 153T707 133H70Q56 140 56 153Q56 168 72 173H312L305 182Q281 212 281 250T305 318L312 327H72Q56 332 56 347ZM473 250Q473 265 472 273T460 297T428 327H349Q328 313 318 298T306 273T304 250Q304 235 305 227T317 203T349 173H428Q449 187 459 202T471 227T473 250"],8791:[721,-133,778,56,722,"279 612Q279 656 310 688T388 721Q433 721 465 689T498 612Q498 573 470 538T389 503Q336 503 308 538T279 612ZM458 614Q458 637 452 651T433 672T411 679T383 680T352 675T333 664T324 647T321 629T320 611Q320 593 321 584T332 562T359 545Q366 543 389 543H391Q406 543 414 544T435 552T452 573T458 614ZM56 347Q56 360 70 367H707Q722 359 722 347Q722 336 708 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H708Q722 163 722 153Q722 140 707 133H70Q56 140 56 153"],8796:[859,-133,778,56,723,"192 482H190Q187 483 185 484T181 488T177 493T175 501Q175 506 178 512Q184 523 278 687T375 853Q379 857 383 857Q385 857 387 858T390 859Q397 859 403 853Q405 851 499 687T600 512Q603 506 603 501Q603 488 587 482H192ZM548 523L389 798Q388 798 309 661T230 523T389 522T548 523ZM56 347Q56 360 70 367H708Q723 359 723 347Q723 336 709 328L390 327H72Q56 332 56 347ZM56 153Q56 168 72 173H709Q723 163 723 153Q723 140 708 133H70Q56 140 56 153"],8806:[753,175,778,83,694,"674 753Q682 753 688 747T694 732T687 718Q686 717 417 589L151 463L399 345Q687 209 691 204Q694 198 694 193Q694 175 676 173H670L382 309Q92 446 90 448Q83 453 83 465Q84 476 96 482Q104 486 382 617T665 751Q669 753 674 753ZM84 39Q84 49 99 59H678Q694 53 694 39Q694 26 679 19H98Q84 26 84 39ZM83 -157Q83 -153 84 -150T86 -145T89 -141T92 -139T96 -137T99 -135H678Q694 -146 694 -155Q694 -168 679 -175H98Q84 -168 83 -157"],8807:[753,175,778,82,694,"83 733Q83 741 89 747T99 753Q107 753 253 685T543 548T687 478Q694 473 694 463T687 448Q685 446 395 309L107 173H101Q83 175 83 193Q83 194 83 196Q82 203 98 212Q117 222 248 284Q326 321 378 345L626 463L360 589Q291 622 200 665Q112 706 98 714T83 733ZM84 39Q84 49 99 59H678Q694 53 694 39Q694 26 679 19H98Q84 26 84 39ZM83 -157Q83 -153 84 -150T86 -145T89 -141T92 -139T96 -137T99 -135H678Q694 -146 694 -155Q694 -168 679 -175H98Q84 -168 83 -157"],8808:[752,286,778,82,694,"86 472Q93 477 381 614T673 752Q680 752 686 746T693 732T689 721Q686 715 418 590L151 461L418 332Q684 207 689 201Q693 195 693 190Q693 183 687 177T675 170Q668 170 380 307T86 450Q82 454 82 461Q82 467 86 472ZM82 33Q82 37 83 40T89 47T95 54H473L520 105Q569 156 571 156Q573 157 578 157Q586 157 592 151T598 136Q598 130 562 92L526 56L604 54H682Q693 43 693 35Q693 31 692 28T686 21T680 14H489L342 -139L513 -142H682Q693 -148 693 -160Q693 -167 680 -182H304L258 -230Q248 -240 237 -251T221 -268T211 -278T203 -284T197 -286Q189 -286 184 -280T178 -264Q178 -257 213 -219L249 -182H171L93 -179L86 -175Q82 -170 82 -163Q82 -155 95 -142H289L360 -64L433 14H262L93 16Q82 23 82 33"],8809:[752,286,778,82,693,"89 745Q95 752 100 752Q106 752 394 615T689 472Q693 468 693 461T689 450Q684 445 396 308T100 170Q95 170 89 176T82 190Q82 195 86 201Q91 208 358 332L624 461L358 590Q90 715 86 721Q82 725 82 731Q82 739 89 745ZM82 33Q82 37 83 40T89 47T95 54H473L520 105Q569 156 571 156Q573 157 578 157Q586 157 592 151T598 136Q598 130 562 92L526 56L604 54H682Q693 43 693 35Q693 31 692 28T686 21T680 14H489L342 -139L513 -142H682Q693 -148 693 -160Q693 -167 680 -182H304L258 -230Q248 -240 237 -251T221 -268T211 -278T203 -284T197 -286Q189 -286 184 -280T178 -264Q178 -257 213 -219L249 -182H171L93 -179L86 -175Q82 -170 82 -163Q82 -155 95 -142H289L360 -64L433 14H262L93 16Q82 23 82 33"],8812:[751,251,500,74,425,"104 730Q104 749 123 749Q130 749 138 745Q186 717 237 671L250 659L261 670Q297 703 332 726T375 750T389 744T395 730Q395 721 390 717T364 699T322 668Q290 641 283 632Q280 628 281 627T293 612Q425 454 425 250Q425 144 388 51T293 -112Q282 -125 281 -126T283 -132Q306 -162 379 -209Q395 -219 395 -230Q395 -238 389 -244T375 -250T335 -228T262 -171L250 -159L238 -170Q202 -203 167 -226T124 -250T110 -244T104 -230Q104 -219 121 -209Q199 -156 216 -132Q219 -128 218 -127T206 -112Q74 46 74 250T206 612Q217 625 218 626T216 632Q199 656 121 709Q104 719 104 730ZM249 -94Q364 61 364 250Q364 430 265 574Q253 590 249 594L242 583Q134 439 134 250Q134 114 192 -1Q212 -44 242 -83L249 -94"],8814:[709,209,778,82,693,"693 -14T693 -20T687 -33T675 -41Q667 -41 506 37L344 112Q342 112 262 -46Q184 -196 176 -205Q172 -209 168 -209T162 -208Q155 -208 151 -203T146 -190Q146 -178 171 -137Q193 -91 251 21L306 132L198 183Q142 208 118 220T88 238T82 249Q82 253 86 261Q92 267 278 357L464 443L529 572Q561 637 577 667T597 703T607 708Q615 708 622 702T629 688Q629 680 575 579L524 474Q524 473 545 482T598 508Q666 541 673 541T686 535T693 521Q693 512 679 504T589 459L493 414L360 150Q366 148 378 142T431 116T529 70Q686 -8 689 -10Q693 -14 693 -20ZM380 277L433 383Q432 385 292 319T151 250T237 209T324 170L380 277"],8815:[708,209,778,82,693,"82 514T82 520T89 533T100 541Q106 541 271 463Q434 386 435 386L515 543Q593 699 600 706Q604 708 607 708Q615 708 622 702T629 688T549 526Q509 445 491 407T473 368Q522 343 580 317Q636 291 660 278T688 261T693 250V249Q693 241 681 234T580 184Q533 161 502 146Q317 59 315 59Q312 56 246 -74Q197 -170 186 -189T168 -209Q164 -209 162 -208Q155 -208 151 -203T146 -190Q146 -187 200 -79L253 28L218 11Q182 -6 144 -23T100 -41Q95 -41 89 -35T82 -21Q82 -12 96 -4T186 41L284 88L349 217Q377 273 395 311T413 350Q413 351 253 428Q101 498 86 510Q82 514 82 520ZM624 250Q461 330 455 330Q454 331 453 329T448 321T441 308T430 287T416 259T398 223L342 114L624 250"],8816:[801,303,778,81,694,"82 -124Q82 -120 83 -117T89 -110T95 -103H220L284 50Q346 204 344 206L218 268Q153 297 123 313T87 333T82 344T86 355Q104 369 291 455Q491 552 491 553L542 673Q581 767 590 784T609 801Q616 801 622 795T629 781Q629 773 586 677Q546 581 546 577L609 606Q669 635 673 635Q680 635 686 629T693 615Q693 610 692 608T670 593T604 561L524 521L400 226L542 157Q617 123 649 107T687 85T694 72Q694 66 690 60T679 54Q664 54 526 121Q513 127 495 136T464 150T438 162T416 173T399 180T388 185L384 186Q383 186 322 41L262 -103H680Q682 -105 684 -108T688 -113T691 -118T693 -124Q693 -134 682 -141L464 -143H246L213 -219Q182 -292 178 -299Q172 -303 166 -303T153 -297T146 -283Q146 -282 174 -213T202 -143H146L93 -141Q82 -134 82 -124ZM418 370L466 495Q464 495 308 420T151 344T204 317T311 267T364 244Q364 247 418 370"],8817:[801,303,778,82,694,"97 54Q82 54 82 72Q82 79 86 84Q95 91 222 153L351 215L398 324L442 433L258 519Q95 597 87 604Q82 608 82 615T88 628T102 635Q107 635 424 484L458 468L524 630Q593 789 597 795Q601 801 609 801Q616 801 622 795T629 781L562 615L493 450L589 406Q665 371 679 362T694 344Q694 339 693 337T677 326T631 302T538 257Q504 241 465 223T406 195T386 186Q384 185 322 39L262 -103H680Q682 -105 684 -108T688 -113T691 -118T693 -124Q693 -134 682 -141L464 -143H246L213 -219Q182 -292 178 -299Q172 -303 166 -303T153 -297T146 -283Q146 -282 174 -213T202 -143H146L93 -141Q82 -134 82 -124Q82 -120 83 -117T89 -110T95 -103H220L273 26Q326 156 326 157L218 106Q109 54 97 54ZM553 379Q480 412 480 415Q479 415 460 372T423 285T406 241Q408 240 516 291T624 344L553 379"],8818:[732,228,778,56,722,"674 732Q682 732 688 726T694 711T687 697Q686 696 417 568L151 442L399 324Q687 188 691 183Q694 177 694 172Q694 154 676 152H670L382 288Q92 425 90 427Q83 432 83 444Q84 455 96 461Q104 465 382 596T665 730Q669 732 674 732ZM56 -194Q56 -107 106 -51T222 6Q260 6 296 -12T362 -56T420 -108T483 -153T554 -171Q616 -171 654 -128T694 -29Q696 6 708 6Q722 6 722 -26Q722 -102 676 -164T557 -227Q518 -227 481 -209T415 -165T358 -113T294 -69T223 -51Q163 -51 125 -93T83 -196Q81 -228 69 -228Q56 -228 56 -202V-194"],8819:[732,228,778,56,722,"90 697Q83 704 83 712T88 726T99 732Q107 732 253 664T543 527T687 457Q694 452 694 442T687 427Q685 425 395 288L107 152H101Q83 154 83 172Q83 173 83 175Q82 182 98 191Q117 201 248 263Q326 300 378 324L626 442L360 568Q91 696 90 697ZM56 -194Q56 -107 106 -51T222 6Q260 6 296 -12T362 -56T420 -108T483 -153T554 -171Q616 -171 654 -128T694 -29Q696 6 708 6Q722 6 722 -26Q722 -102 676 -164T557 -227Q518 -227 481 -209T415 -165T358 -113T294 -69T223 -51Q163 -51 125 -93T83 -196Q81 -228 69 -228Q56 -228 56 -202V-194"],8822:[681,253,778,44,734,"734 181Q734 173 728 167T714 161Q711 161 386 280T54 404Q44 408 44 421Q44 432 52 437Q66 443 388 562T714 681Q721 681 727 675T734 661Q734 651 722 645Q711 639 462 546Q441 539 420 531L122 421L420 311L723 198Q734 192 734 181ZM44 247Q44 255 50 261T63 267Q66 267 391 148T723 24Q734 18 734 7T723 -10Q716 -14 391 -133T63 -253Q56 -253 50 -247T44 -233Q44 -223 55 -217Q67 -210 317 -118Q337 -110 357 -103L655 7L357 117L54 230Q44 236 44 247"],8823:[681,253,778,83,694,"83 661Q83 668 88 674T104 681Q111 679 396 560Q686 437 687 436Q694 431 694 421T687 406Q686 405 543 344T253 222T101 161Q83 163 83 180Q83 194 95 199Q96 199 130 213T232 257T361 311L621 421L357 532Q307 553 233 584Q121 631 102 640T83 661ZM673 267Q694 267 694 248Q694 237 687 232Q684 229 420 118L156 7L416 -103L683 -215Q694 -222 694 -233Q694 -251 676 -253Q670 -253 524 -192T235 -70T90 -8Q83 -1 83 7Q83 19 94 24Q97 25 378 144T667 266Q669 267 673 267"],8828:[580,153,778,83,694,"112 270Q83 270 83 290Q83 301 94 307Q98 310 118 310Q516 310 620 464Q635 486 642 510T651 548T657 571T675 580Q693 577 693 559V552Q684 472 628 410T465 314Q436 303 372 290Q373 290 388 287T425 278T465 266Q674 199 693 28L694 17Q688 5 683 3Q677 0 673 0Q656 0 653 24Q623 270 118 270H112ZM110 116Q83 116 83 136T110 156H113Q134 156 160 155T231 146T318 128T407 95T489 44T550 -30T583 -131Q583 -153 563 -153Q556 -153 553 -152T547 -145T542 -127Q531 -54 478 0Q425 53 333 83T123 116H110"],8829:[580,154,778,83,694,"668 310Q694 310 694 290Q694 285 691 279Q684 271 664 270Q550 268 464 257T301 220T179 146T124 27Q119 0 103 0T83 16Q83 21 83 31T92 68T113 121T157 177T229 231Q295 268 405 290Q404 290 389 293T352 302T312 314Q138 371 96 500Q83 541 83 562Q83 568 89 574T103 580Q115 580 120 570T126 542T138 497T173 442Q289 310 659 310H668ZM194 -131Q201 -60 241 -6T343 82T477 133T628 155Q632 155 644 155T661 156Q685 155 690 147Q694 143 694 136Q694 132 693 129T689 124T685 120T681 117L656 116Q596 114 543 106T436 79T342 35T272 -33T235 -127Q231 -154 212 -154Q203 -153 199 -147T194 -136V-131"],8830:[732,228,778,56,722,"84 442Q84 455 91 459T117 463Q120 463 126 463T137 462Q388 466 512 526T653 705Q657 732 676 732Q685 731 689 725T694 714V708Q689 662 672 624T626 559T569 513T500 479T435 458T373 442Q379 441 404 435T440 426T477 414T533 392Q592 362 630 319T681 241T694 174Q694 153 674 153Q662 153 657 163T652 188T640 231T606 287Q500 416 137 422H114Q104 422 98 423T88 428T84 442ZM56 -194Q56 -107 106 -51T222 6Q260 6 296 -12T362 -56T420 -108T483 -153T554 -171Q616 -171 654 -128T694 -29Q696 6 708 6Q722 6 722 -26Q722 -102 676 -164T557 -227Q518 -227 481 -209T415 -165T358 -113T294 -69T223 -51Q163 -51 125 -93T83 -196Q81 -228 69 -228Q56 -228 56 -202V-194"],8831:[732,228,778,56,722,"84 710Q84 732 102 732Q115 732 119 722T125 696T137 652T171 597Q277 468 640 462H661Q694 462 694 442T661 422H640Q578 421 526 417T415 403T309 376T222 333T156 268T124 179Q122 162 118 158T103 153Q100 153 98 153T95 154T93 155T90 158T85 163Q83 167 83 176Q88 222 105 260T151 325T208 371T277 405T342 426T404 442Q401 443 380 447T345 456T302 469T245 492Q125 551 92 661Q84 695 84 710ZM56 -194Q56 -107 106 -51T222 6Q260 6 296 -12T362 -56T420 -108T483 -153T554 -171Q616 -171 654 -128T694 -29Q696 6 708 6Q722 6 722 -26Q722 -102 676 -164T557 -227Q518 -227 481 -209T415 -165T358 -113T294 -69T223 -51Q163 -51 125 -93T83 -196Q81 -228 69 -228Q56 -228 56 -202V-194"],8832:[705,208,778,82,693,"386 292Q388 292 439 393T543 598T598 703Q599 703 603 704T609 705Q616 705 622 699T629 685T533 494Q440 308 440 305Q451 310 462 312Q547 342 592 388T651 505Q654 525 658 532T673 539Q680 539 686 533T693 519Q693 495 678 450Q638 341 500 283Q433 259 418 259Q416 259 411 251T406 241T415 239Q482 224 544 190Q674 121 691 -10Q693 -28 691 -32Q684 -43 672 -43Q664 -43 658 -37Q656 -33 650 -6T634 47T589 109T500 168Q473 179 436 190T388 201H386L284 -1Q261 -45 232 -101T191 -181T178 -206Q176 -206 172 -207T166 -208Q160 -208 153 -202T146 -188Q146 -185 246 12Q344 206 344 210Q344 213 305 217T213 225T124 228H95Q82 241 82 248Q82 253 95 268H124Q172 268 236 273T343 283T386 292"],8833:[705,208,778,82,693,"103 -43Q96 -43 89 -39T82 -26L84 -10Q105 141 275 212Q342 236 355 236Q360 236 364 245L369 256H360Q284 280 275 283Q115 351 86 490Q82 507 82 517Q82 526 88 532T103 538Q110 538 115 534Q119 531 122 517T128 486T143 444T174 397T231 351T320 310Q371 292 389 292L491 496Q595 701 598 703Q599 703 603 704T609 705Q616 705 622 699T629 685Q629 684 531 485Q431 296 431 288Q431 278 520 273T651 268H680Q693 253 693 248Q693 241 680 228H651Q591 228 491 218T386 201L284 -1Q261 -45 232 -101T191 -181T178 -206Q176 -206 172 -207T166 -208Q160 -208 153 -202T146 -188Q146 -182 302 125L335 190L324 185Q313 185 289 172Q241 153 208 128T159 78T135 31T124 -11T118 -37Q112 -43 103 -43"],8840:[801,303,778,83,693,"146 -283Q146 -282 174 -213T202 -143H115Q102 -127 102 -123T115 -103H220L291 68L278 73Q203 101 153 157T86 288Q83 309 83 344Q83 380 86 399Q107 480 160 539Q222 601 298 621Q328 630 345 631T435 635L526 637L560 715Q587 778 593 789T609 801Q616 801 622 795T629 781Q629 780 625 771T614 742T600 706L571 637Q571 635 626 635H680Q693 620 693 613T689 601L682 597L618 595H553L449 346Q425 288 399 223T359 127T346 95H356Q365 95 381 95T417 94T463 93T515 93H682Q693 82 693 74T680 53H511Q420 55 335 55L329 57L262 -103H680Q682 -105 684 -108T688 -113T691 -118T693 -124Q693 -134 682 -141L464 -143H246L213 -219Q182 -292 178 -299Q172 -303 166 -303T153 -297T146 -283ZM509 590Q509 595 438 595Q354 595 318 586Q246 567 195 516T126 395Q123 378 123 344T126 293Q141 229 184 181T291 110L306 104L406 346L509 590"],8841:[801,303,778,82,691,"82 606T82 613T95 635H251H348Q408 635 435 632T502 615L515 608L520 617Q520 619 558 708Q584 774 591 787T609 801Q616 801 622 795T629 781Q629 775 562 615L551 590L569 577Q646 527 678 437Q691 398 691 344T678 250Q653 182 597 132T469 64Q427 53 366 53H326L295 -25L262 -103H660Q673 -118 673 -124Q673 -129 669 -136L662 -141L453 -143H246L213 -219Q182 -292 178 -299Q172 -303 166 -303T153 -297T146 -283Q146 -282 174 -213T202 -143H95Q82 -128 82 -123T95 -103H220L251 -25L284 53H189L93 55L86 59Q82 64 82 71T95 93H302L400 333Q498 569 498 573L444 590Q431 593 260 595L93 597L86 601Q82 606 82 613ZM652 344V354Q652 451 575 521Q571 526 557 538T537 551Q534 551 533 548Q533 543 438 319L344 95L371 93H386Q487 93 557 150T649 293Q652 309 652 344"],8842:[635,241,778,84,693,"693 72Q693 68 692 66T686 59T680 52H524Q398 52 367 53T309 63Q236 82 180 132T98 250Q84 288 84 343Q84 397 98 437Q126 515 193 568T346 632Q347 632 373 633T440 634T520 635H680Q693 620 693 615Q693 608 680 595H526Q364 595 353 592Q279 582 221 539T138 430Q124 392 124 343Q124 296 138 257Q163 192 221 149T353 95Q364 92 526 92H680Q693 79 693 72ZM102 -132T102 -125T115 -103H382L420 -68Q429 -60 438 -52T452 -39T463 -28T472 -20T478 -14T483 -10T487 -7T490 -6T493 -5T496 -5Q502 -5 508 -12T515 -28Q515 -34 513 -37Q512 -38 507 -42T492 -55T475 -70L440 -101L562 -103H682Q693 -114 693 -122T680 -143H395L355 -179Q289 -241 280 -241Q273 -241 267 -235T260 -221T265 -208T300 -174L335 -143H224L113 -141L106 -137Q102 -132 102 -125"],8843:[635,241,778,82,691,"82 615Q82 620 95 635H251Q378 635 409 634T469 623Q540 605 596 555T678 437Q691 397 691 343T678 250Q649 172 581 119T426 55Q415 52 251 52H95Q93 55 89 59T84 65T82 72Q82 79 95 92H249Q411 92 422 95Q496 105 554 148T638 257Q651 296 651 343Q651 391 638 430Q613 495 555 538T422 592Q411 595 249 595H95Q82 608 82 615ZM82 -132T82 -125T95 -103H380L420 -57Q452 -21 460 -14T474 -6Q482 -6 488 -12T495 -25T451 -81L433 -101L549 -103H662Q673 -114 673 -122T660 -143H395L355 -190Q311 -239 309 -239Q305 -241 302 -241Q294 -241 287 -235T280 -221T324 -163L342 -143H218L93 -141L86 -137Q82 -132 82 -125"],8847:[539,41,778,83,694,"83 523Q87 535 99 539H679Q694 531 694 519Q694 506 679 499H123V-1H678Q694 -7 694 -21Q694 -34 679 -41H98Q93 -38 84 -28L83 247V523"],8848:[539,41,778,64,714,"64 506T64 519T78 539H699Q706 536 714 526V-28Q706 -38 699 -41H78Q64 -34 64 -21Q64 -6 80 -1H674V499H78Q64 506 64 519"],8858:[583,82,778,57,721,"57 250Q57 327 87 392T166 497T270 560T382 582H394Q512 582 610 500Q721 401 721 250Q721 112 626 15T389 -82Q251 -82 154 13T57 250ZM682 129T682 250T596 457T390 543Q269 543 183 457T96 250Q96 132 180 45T389 -43Q511 -43 596 43ZM250 250Q250 316 295 352T384 388Q451 388 489 347T528 250Q528 192 487 152T389 112Q331 112 291 152T250 250ZM488 250Q488 290 460 319T389 349Q348 349 319 320T290 250Q290 208 320 180T389 151Q431 151 459 181T488 250"],8859:[583,82,778,57,721,"57 250Q57 327 87 392T166 497T270 560T382 582H394Q512 582 610 500Q721 401 721 250Q721 112 626 15T389 -82Q251 -82 154 13T57 250ZM682 129T682 250T596 457T390 543Q269 543 183 457T96 250Q96 132 180 45T389 -43Q511 -43 596 43ZM204 339Q204 357 215 366T238 375Q247 375 283 348Q300 336 311 328L368 286Q369 286 366 323T359 398T355 437Q357 456 379 465Q380 465 384 465T391 466Q403 465 412 457T423 437Q423 436 420 398T413 323T410 286L467 328Q476 334 486 341T501 353T513 361T523 368T529 372T535 374T541 375Q554 375 564 365T575 339Q575 325 566 318T519 292Q504 285 496 281L430 250L496 219Q552 192 559 188T572 175Q575 168 575 161Q575 148 566 137T541 126H538Q530 126 499 149Q480 163 467 172L410 214Q409 214 412 177T419 102T423 63Q423 59 421 54T411 43T389 36T368 42T357 54T355 63Q355 64 358 102T365 177T368 214L311 172Q302 165 293 159T279 148T268 140T260 134T254 131T250 128T246 127T242 126T238 126Q223 126 214 135T204 161T213 183T282 219L348 250L282 281Q226 308 219 312T206 325Q204 330 204 339"],8861:[583,82,778,57,721,"57 250Q57 327 87 392T166 497T270 560T382 582H394Q512 582 610 500Q721 401 721 250Q721 112 626 15T389 -82Q251 -82 154 13T57 250ZM682 129T682 250T596 457T390 543Q269 543 183 457T96 250Q96 132 180 45T389 -43Q511 -43 596 43ZM223 250Q223 263 233 267T280 271Q289 271 325 271T389 270H490Q535 270 545 267T555 250Q555 241 549 235Q544 231 527 231T389 230Q239 230 235 232Q223 236 223 250"],8862:[689,0,778,55,722,"71 0Q59 4 55 16V346L56 676Q64 686 70 689H709Q719 681 722 674V15Q719 10 709 1L390 0H71ZM369 365V649H95V365H369ZM682 365V649H409V365H682ZM369 40V325H95V40H369ZM682 40V325H409V40H682"],8863:[689,0,778,55,722,"71 0Q59 4 55 16V346L56 676Q64 686 70 689H709Q719 681 722 674V15Q719 10 709 1L390 0H71ZM682 365V649H95V365H682ZM682 40V325H95V40H682"],8864:[689,0,778,55,722,"71 0Q59 4 55 16V346L56 676Q64 686 70 689H707Q714 686 722 676V13Q714 3 707 0H71ZM123 649Q147 625 214 555T335 430T389 374L654 649H123ZM95 70Q99 74 229 209T360 345L95 619V70ZM682 70V619L418 346Q417 344 549 207L682 70ZM654 41L400 304L388 315L123 41L256 40H522L654 41"],8865:[689,0,778,55,722,"71 0Q59 4 55 16V346L56 676Q64 686 70 689H709Q719 681 722 674V15Q719 10 709 1L390 0H71ZM682 40V649H95V40H682ZM330 345Q330 371 347 388T390 405Q412 405 430 389T448 345Q448 317 430 301T389 285T348 301T330 345"],8872:[695,0,611,55,556,"55 678Q55 679 56 681T58 684T61 688T65 691T70 693T77 694Q88 692 95 679V464H540Q554 456 555 446Q555 442 554 439T552 434T549 430T546 428T542 426T539 424H95V270H539Q540 270 542 269T545 267T549 264T552 260T554 255T555 248Q554 238 540 230H95V15Q88 2 77 0Q73 0 70 1T65 3T61 6T59 9T57 13T55 16V678"],8873:[695,0,722,55,666,"55 678Q55 679 56 681T58 684T61 688T65 691T70 693T77 694Q88 692 95 679V15Q88 2 77 0Q73 0 70 1T65 3T61 6T59 9T57 13T55 16V678ZM249 678Q249 679 250 681T252 684T255 688T259 691T264 693T271 694Q282 692 289 679V367H651Q666 359 666 347Q666 334 651 327H289V15Q282 2 271 0Q267 0 264 1T259 3T255 6T253 9T251 13T249 16V678"],8874:[695,0,889,55,833,"55 678Q55 679 56 681T58 684T61 688T65 691T70 693T77 694Q88 692 95 679V15Q88 2 77 0Q73 0 70 1T65 3T61 6T59 9T57 13T55 16V678ZM237 678Q237 679 238 681T240 684T243 688T247 691T252 693T259 694Q270 692 277 679V15Q270 2 259 0Q255 0 252 1T247 3T243 6T241 9T239 13T237 16V678ZM419 678Q419 679 420 681T422 684T425 688T429 691T434 693T441 694Q452 692 459 679V367H818Q833 359 833 347Q833 334 818 327H459V15Q452 2 441 0Q437 0 434 1T429 3T425 6T423 9T421 13T419 16V678"],8876:[696,1,611,-55,554,"56 681Q70 695 76 695T96 681V368H243L381 530Q521 692 525 692Q537 700 547 688Q554 682 554 674Q554 671 553 669T548 661T539 649T522 631T499 604T465 565T421 512Q296 373 296 368H416H476Q525 368 539 365T554 348Q554 334 543 328H261L96 141V12Q81 -1 75 -1Q65 -1 58 10L56 50V92L18 48Q7 37 -1 28T-13 14T-19 6T-23 1T-27 0T-33 -1Q-42 -1 -48 4T-55 19Q-55 24 -47 34T12 103L56 155V681ZM205 326Q205 328 152 328H96V263Q96 203 98 203Q99 203 123 231T174 290T205 326"],8877:[695,1,611,-55,554,"56 681Q70 695 76 695T96 681V466H327L425 579Q522 692 527 692Q529 693 534 693Q542 693 547 688T553 674Q553 668 549 663Q549 662 538 650T504 611T463 563L381 468L461 466H543Q554 453 554 446T541 426H345L209 272L376 270H543Q554 257 554 251T541 230H174L96 141V12Q81 -1 75 -1Q65 -1 58 10L56 50V92L18 48Q7 37 -1 28T-13 14T-19 6T-23 1T-27 0T-33 -1Q-42 -1 -48 4T-55 19Q-55 24 -47 34T12 103L56 155V681ZM267 399L292 426H96V270H158L201 321Q256 382 267 399ZM118 228L119 229Q119 230 109 230H96V201L107 212Q118 227 118 228"],8878:[695,1,722,-55,665,"56 681Q70 695 77 695T96 683V428L98 175L252 323V681Q264 695 272 695Q278 695 292 681V526Q292 368 296 368Q298 368 447 510Q638 695 642 695H645Q651 695 658 688T665 673Q665 666 661 661Q659 660 639 641T578 582T505 512L356 370L505 368H654Q665 357 665 349Q665 343 652 328H314L303 317L292 308V12Q289 10 285 6T279 1T272 -1Q265 -1 252 12V139Q252 266 249 266L96 119V12Q80 -1 76 -1T70 0T63 6T56 12V79L29 55Q-26 -1 -35 -1Q-42 -1 -48 5T-55 19Q-55 25 -51 30T-15 66Q5 86 18 99L56 135V681"],8879:[695,1,722,-55,665,"56 681Q70 695 77 695T96 683V428L98 175L252 323V681Q264 695 272 695Q278 695 292 681V466H401L503 563L621 679Q637 695 645 695Q652 695 658 688T665 673Q665 670 663 666Q663 665 651 652T611 612T561 563L458 468L556 466H654Q665 455 665 447T652 426H416L294 308L292 288V270H652Q665 255 665 250T652 230H292V12Q289 10 285 6T279 1T272 -1Q265 -1 252 12V139Q252 266 249 266L96 119V12Q80 -1 76 -1T70 0T63 6T56 12V79L29 55Q-26 -1 -35 -1Q-42 -1 -48 5T-55 19Q-55 25 -51 30T-15 66Q5 86 18 99L56 135V681ZM358 426H292V361L325 392L358 426"],8882:[539,41,778,83,694,"694 -26Q686 -40 676 -41H670L382 95Q92 232 90 234Q83 239 83 249Q83 262 96 267Q101 270 379 401T665 537Q671 539 674 539Q686 539 694 524V-26ZM654 11T654 249T653 487T402 369T151 249L275 190Q399 131 524 72T652 11Q654 11 654 249"],8883:[540,41,778,83,694,"83 523Q83 524 85 527T92 535T103 539Q107 539 389 406T680 268Q694 260 694 249Q694 239 687 234Q685 232 395 95L107 -41H101Q90 -40 83 -26V523ZM376 368Q323 393 254 425T155 472L125 487Q123 487 123 249T125 11Q127 12 252 71T502 190L626 249L376 368"],8884:[636,138,778,83,695,"694 71Q686 58 676 56H670L382 192Q92 329 90 331Q83 336 83 346Q83 359 96 364Q101 367 379 498T665 634Q671 636 674 636Q686 636 694 621V71ZM654 108T654 346T653 584T402 466T151 346L275 287Q399 228 524 169T652 108Q654 108 654 346ZM83 -120Q83 -116 84 -113T86 -108T89 -104T92 -102T96 -100T99 -98H678Q679 -98 681 -99T684 -101T688 -104T691 -108T693 -113T694 -120Q692 -130 679 -138H98Q84 -130 83 -120"],8885:[637,138,778,83,695,"83 620Q83 621 85 624T92 632T103 636Q107 636 389 503T680 365Q694 357 694 346Q694 336 687 331Q685 329 395 192L107 56H101Q90 58 83 71V620ZM376 465Q323 490 254 522T155 570L125 584Q123 584 123 346T125 108Q127 109 252 168T502 287L626 346L376 465ZM83 -120Q83 -116 84 -113T86 -108T89 -104T92 -102T96 -100T99 -98H678Q679 -98 681 -99T684 -101T688 -104T691 -108T693 -113T694 -120Q692 -130 679 -138H98Q84 -130 83 -120"],8888:[408,-92,1111,55,1055,"1055 250Q1055 190 1012 141T896 92Q858 92 828 106T781 140T755 180T741 214L738 228V230H405Q71 230 68 232Q55 238 55 250T68 268Q71 270 405 270H738V272L740 280Q742 287 745 297T754 321T771 348T796 374T832 396T881 408H891Q969 408 1012 360T1055 250ZM896 132Q948 132 981 166T1014 250Q1014 301 985 330T920 367Q914 368 891 368Q853 368 816 338T778 250Q778 198 812 165T896 132"],8890:[431,212,556,57,501,"318 -182Q302 -212 280 -212H278H275Q249 -212 239 -182L238 84V351H162L87 352Q57 362 57 391T84 429Q89 431 280 431H470L474 429Q477 427 479 426T484 423T490 417T495 410T499 402T500 391Q500 365 470 352L394 351H318V-182"],8891:[716,0,611,55,555,"56 697Q56 706 62 711T75 716Q86 716 90 709Q91 708 104 680T147 592T199 483L305 261L411 483Q443 548 481 629Q512 694 518 705T535 716Q543 716 549 710T555 700Q555 693 501 577T388 340T325 210Q316 194 305 194Q292 194 285 210Q282 219 224 339T111 574T56 697ZM55 14T55 20T59 31T66 38T71 40H540Q555 32 555 20T540 0H71Q70 0 67 2T59 9"],8892:[716,0,611,54,555,"55 698Q56 708 70 716H540Q554 708 555 698Q555 694 554 691T552 686T549 682T546 680T542 678T539 676H71Q70 676 68 677T65 679T61 682T58 686T56 691T55 698ZM555 18Q554 12 549 6T536 0H535Q525 0 515 17T459 132Q430 194 410 235L305 455L199 233Q176 185 147 125T105 36T90 7Q85 0 75 0Q63 0 58 11Q55 15 55 21Q58 31 170 266T285 507Q295 522 305 522T320 515Q322 513 439 268L555 24V18"],8901:[189,0,278,55,222,"71 0Q59 4 55 16V96L56 176Q59 180 66 187L70 189H209Q219 181 222 174V15Q219 10 209 1L140 0H71"],8903:[545,44,778,55,720,"366 543Q374 545 382 545Q405 545 419 538Q429 534 443 521T462 496Q466 478 466 467Q466 438 444 412Q422 390 388 390Q352 390 331 412Q311 434 311 467Q311 499 331 518Q345 533 366 543ZM146 472Q146 479 153 485T166 492Q171 492 187 476T279 385L386 278L495 385Q600 492 608 492Q615 492 621 486T628 472Q628 467 614 452T531 367L435 270H706Q720 256 720 250Q720 241 706 230H435L531 132Q600 63 614 48T628 27Q628 20 622 14T608 7Q600 7 495 114L386 221L279 114Q204 39 188 23T166 7Q159 7 153 13T146 27Q146 32 160 47T244 132L339 230H68Q55 243 55 250Q55 255 68 270H339L244 367Q175 436 161 451T146 472ZM466 34Q466 4 447 -20T388 -44Q353 -44 331 -22Q311 1 311 34Q311 66 331 85Q347 101 366 110Q374 112 382 112Q405 112 419 105Q429 100 443 87T462 63Q466 45 466 34"],8905:[492,-8,778,146,628,"146 479Q159 492 166 492Q171 492 189 475T279 386L386 279L495 386Q598 492 608 492Q615 492 621 486T628 472Q628 464 522 357L415 250L522 144Q628 37 628 28Q628 21 622 15T608 8Q599 8 495 115L386 221L279 115Q204 40 188 24T166 8Q162 8 160 9T153 15T146 21V479ZM186 77L359 250L186 424V77"],8906:[492,-8,778,146,628,"146 472Q146 479 152 485T166 492Q171 492 189 475T279 386L386 279L495 386Q598 492 608 492Q615 492 628 479V21Q615 8 608 8Q599 8 495 115L386 221L279 115Q204 40 188 24T166 8Q159 8 153 14T146 28Q146 37 253 144L359 250L253 357Q146 464 146 472ZM588 77V424L499 337L415 250L588 77"],8907:[694,23,778,55,722,"55 674Q55 682 62 688T76 694H77Q83 694 100 677T208 561Q320 440 410 342Q462 286 541 201Q677 55 699 30T722 -2Q722 -9 716 -15T701 -22T688 -17Q687 -15 542 141T394 301L388 306L240 146Q119 15 101 -3T75 -22T61 -16T55 -2Q55 4 67 19T158 117Q190 151 209 172L361 336L209 500Q62 657 57 667Q55 671 55 674"],8908:[694,22,778,55,722,"84 -22T76 -22T62 -16T55 -2Q55 4 78 30T249 215Q321 293 367 342Q672 672 683 682Q695 694 702 694Q710 694 716 688T722 674Q722 668 710 653T619 555Q587 521 568 500L416 336L568 172Q715 15 720 5Q722 1 722 -2Q722 -9 716 -15T702 -22H700Q693 -22 671 1T537 146L389 306Q387 304 340 253T237 143T135 33L89 -17Q84 -22 76 -22"],8909:[464,-36,778,56,722,"56 433Q56 464 71 464Q74 464 77 461Q82 454 82 438T91 397T123 347Q166 307 222 307Q264 307 308 331T386 385T465 438T556 463Q631 463 676 408T722 283Q722 250 708 250Q704 250 699 257Q695 265 693 286T682 330Q670 350 655 367Q612 407 556 407Q514 407 470 383T393 329T314 276T222 251Q148 251 102 306T56 433ZM57 56Q57 71 73 76H706Q722 70 722 56Q722 44 707 36H71Q57 43 57 56"],8910:[578,21,760,83,676,"83 558Q83 566 89 572T104 578Q108 578 116 577T146 570T190 555T239 526T286 480Q308 453 325 420T351 358T367 304T376 265T380 251T381 253Q381 262 395 312Q428 434 492 499T642 576Q654 578 655 578Q664 578 670 572T676 558Q676 543 657 540T599 524T525 476Q406 362 400 29V8Q400 -21 380 -21Q369 -21 362 -11Q360 -7 360 12Q360 115 348 200T308 360T231 480T111 537Q83 540 83 558"],8911:[578,22,760,83,676,"104 -22Q95 -22 89 -16T83 -2Q83 11 98 16T135 23T192 46T256 103Q360 233 360 549Q360 554 360 557T361 563T362 567T364 569T367 572T371 576Q377 578 380 578Q401 578 401 547Q401 543 401 537T400 527Q409 53 648 19Q676 16 676 -2Q676 -10 670 -16T655 -22Q654 -22 642 -20Q556 -9 492 56T395 244Q381 294 381 303Q381 305 380 305T374 275T352 201T310 110T234 27T117 -20Q105 -22 104 -22"],8912:[541,41,778,84,694,"84 250Q84 372 166 450T360 539Q361 539 370 539T395 539T430 540T475 540T524 540H679Q694 532 694 520Q694 511 681 501L522 500H470H441Q366 500 338 496T266 472Q244 461 224 446T179 404T139 337T124 250V245Q124 157 185 89Q244 25 328 7Q348 2 366 2T522 0H681Q694 -10 694 -20Q694 -32 679 -40H526Q510 -40 480 -40T434 -41Q350 -41 289 -25T172 45Q84 127 84 250ZM694 134Q694 123 679 114H425H384Q350 114 326 121T277 154Q238 193 238 251Q238 322 295 361Q318 378 339 382T412 387Q423 387 459 387T520 386H679Q694 377 694 366Q694 354 679 346H519Q493 346 458 346T411 347Q360 347 341 342T303 315Q278 287 278 250Q278 210 301 187T351 156Q358 154 519 154H679Q694 146 694 134"],8913:[541,40,778,83,693,"83 520Q83 532 98 540H251Q267 540 297 540T343 541Q427 541 488 525T605 455Q693 374 693 250Q693 165 650 99T545 0T415 -39Q407 -40 251 -40H98Q83 -32 83 -20Q83 -10 96 0H255H308H337Q412 0 439 4T512 28Q533 39 553 54T599 96T639 163T654 250Q654 341 592 411Q557 449 512 472Q468 491 439 495T335 500H306H255L96 501Q83 511 83 520ZM83 366Q83 376 96 386H244Q280 386 317 386T378 386L402 387Q456 387 498 348T540 250Q540 203 512 168T446 120Q427 114 353 114H99Q84 120 84 134Q84 147 98 154H258Q284 154 319 154T366 153Q416 153 436 158T474 185Q500 214 500 250Q500 290 477 313T426 344Q419 346 258 346H98Q83 354 83 366"],8914:[598,22,667,55,611,"88 -21T75 -21T55 -7V200Q55 231 55 280Q56 414 60 428Q61 430 61 431Q77 500 152 549T332 598Q443 598 522 544T610 405Q611 399 611 194V-7Q604 -22 591 -22Q582 -22 572 -9L570 405Q563 433 556 449T529 485Q498 519 445 538T334 558Q251 558 179 518T96 401Q95 396 95 193V-7Q88 -21 75 -21ZM229 -21H227Q215 -21 209 -7V166Q209 304 209 327T215 363Q226 398 259 421T333 444Q380 444 414 416T455 347Q457 339 457 166V-7Q449 -21 439 -21H437H435Q423 -21 417 -7V164Q417 303 417 325T411 358Q387 403 333 403T255 358Q250 347 250 325T249 164V-7Q241 -21 231 -21H229"],8915:[598,22,667,55,611,"591 598H592Q604 598 611 583V376Q611 345 611 296Q610 162 606 148Q605 146 605 145Q586 68 507 23T333 -22Q268 -22 209 -1T106 66T56 173Q55 180 55 384L56 585Q66 598 75 598Q85 598 95 585V378L96 172L98 162Q112 95 181 57T332 18Q415 18 487 58T570 175Q571 180 571 383V583Q579 598 591 598ZM437 598Q450 598 457 583V410Q457 237 455 229Q448 189 414 161T333 132Q291 132 255 157T211 230Q209 237 209 412L210 585Q220 598 229 598Q242 598 249 583V412Q249 273 249 251T255 218Q279 173 333 173T411 218Q416 229 416 251T417 412V583Q425 598 437 598"],8916:[736,22,667,56,611,"76 -22Q64 -22 56 -7V176L57 360L59 370Q66 401 83 426T123 468T171 495T221 513T265 522T298 527L311 528H314V625L315 723Q325 736 334 736Q346 736 354 721V528H356L368 527Q380 526 399 523T441 515T490 498T537 472T578 433T606 379Q611 359 611 171V-7Q604 -21 591 -21T571 -7V170Q571 313 571 337T565 375Q555 408 526 432T461 467T402 482T365 487H354V-7Q347 -21 334 -21T314 -7V487H303Q251 484 207 467Q121 438 99 367L97 357L96 174V-9Q86 -22 76 -22"],8918:[541,41,778,82,694,"86 261Q92 267 381 404T673 541Q680 541 686 535T693 521T689 510Q684 504 418 379L151 250L418 121Q686 -4 689 -10Q693 -14 693 -21T687 -34T675 -41Q668 -41 380 96T86 239Q82 244 82 250Q82 257 86 261ZM610 250Q610 224 592 198T531 172Q498 172 475 195Q453 214 453 250Q453 308 513 328Q515 330 535 330Q569 328 589 304T610 250"],8919:[541,41,778,82,693,"82 521Q82 529 89 535T100 541Q107 541 395 404T689 261Q693 257 693 250T689 239Q684 234 396 97T100 -41Q95 -41 89 -35T82 -21Q82 -12 96 -4Q118 9 358 121L624 250L358 379Q91 503 86 510Q82 514 82 521ZM165 250Q165 282 188 306T239 330Q262 330 275 323Q303 312 318 283Q322 272 322 250Q322 213 300 195Q277 172 246 172Q224 172 213 177Q165 200 165 250"],8920:[568,67,1333,56,1277,"639 -48Q639 -54 634 -60T619 -67H618Q612 -67 536 -26Q430 33 329 88Q61 235 59 239Q56 243 56 250T59 261Q62 266 336 415T615 567L619 568Q622 567 625 567Q639 562 639 548Q639 540 633 534Q632 532 374 391L117 250L374 109Q632 -32 633 -34Q639 -40 639 -48ZM958 -48Q958 -54 953 -60T938 -67H937Q931 -67 855 -26Q749 33 648 88Q380 235 378 239Q375 243 375 250T378 261Q381 266 655 415T934 567L938 568Q941 567 944 567Q958 562 958 548Q958 540 952 534Q951 532 693 391L436 250L693 109Q951 -32 952 -34Q958 -40 958 -48ZM1277 -48Q1277 -54 1272 -60T1257 -67H1256Q1250 -67 1174 -26Q1068 33 967 88Q699 235 697 239Q694 243 694 250T697 261Q700 266 974 415T1253 567L1257 568Q1260 567 1263 567Q1277 562 1277 548Q1277 540 1271 534Q1270 532 1012 391L755 250L1012 109Q1270 -32 1271 -34Q1277 -40 1277 -48"],8921:[568,68,1333,55,1277,"75 -67Q65 -67 60 -61T55 -48Q55 -40 61 -34Q62 -32 329 109L595 250L329 391Q62 532 61 534Q55 540 55 548Q55 562 69 567H77Q81 567 222 493T506 342T653 264Q667 250 653 236Q649 234 504 157T220 7T77 -67H75ZM364 547Q364 563 381 567L384 568Q387 568 518 499T795 353T955 269Q967 261 967 250T955 231Q925 216 780 139T513 -3T383 -67Q373 -67 369 -60T364 -47Q364 -40 370 -34Q373 -31 639 109L904 250L639 391Q373 531 370 534Q364 540 364 547ZM674 538T674 548T681 562T693 567Q699 567 816 505Q915 453 993 412Q1050 382 1132 339Q1241 282 1259 271T1277 250Q1277 241 1263 232Q1246 221 985 84Q698 -67 692 -67Q674 -67 674 -47Q674 -38 680 -33Q683 -30 947 109L1213 250L947 391Q683 530 680 533Q674 538 674 548"],8922:[886,386,778,83,674,"674 445Q674 438 669 432T655 425T369 531T90 640Q83 645 83 655Q83 668 95 673Q644 886 654 886Q662 886 668 880T674 866Q674 856 663 850Q649 843 411 751L160 655L407 560Q474 534 561 501Q646 469 660 462T674 445ZM84 250Q84 260 99 270H658Q674 264 674 250Q674 238 659 230H98Q84 237 84 250ZM83 55Q83 68 94 73Q98 76 104 76Q108 75 383 -30T664 -138Q674 -144 674 -155Q674 -165 667 -170Q664 -173 385 -279T104 -386Q85 -386 83 -368Q83 -354 92 -349Q93 -349 347 -251L597 -155L346 -59Q296 -40 223 -12Q118 28 101 36T83 55"],8923:[886,386,778,83,674,"111 425T102 425T88 431T83 445V446Q83 455 96 461Q111 469 203 504Q287 536 350 560L597 655L346 751Q94 848 92 850Q83 856 83 866Q83 873 88 879T104 886Q109 885 386 779T667 670Q674 665 674 655T667 640Q665 638 388 532ZM84 250Q84 260 99 270H658Q674 264 674 250Q674 238 659 230H98Q84 237 84 250ZM653 76Q656 76 660 75T669 68T674 56Q674 46 665 40Q663 38 411 -59L160 -155L410 -251Q664 -349 665 -349Q674 -354 674 -368Q672 -386 654 -386Q650 -386 371 -279T90 -170Q83 -165 83 -155Q83 -144 93 -138Q645 76 653 76"],8926:[734,0,778,83,694,"113 424Q83 424 83 444Q83 453 96 464H121Q181 466 234 474T341 501T435 545T505 613T542 707Q545 734 564 734Q583 731 583 714Q583 658 560 613T500 538T414 486T321 453T229 434T156 426T113 424ZM112 270Q83 270 83 290Q83 301 94 307Q98 310 118 310Q624 310 653 556Q657 580 675 580Q693 577 693 559V552Q684 472 628 410T465 314Q436 303 372 290Q373 290 388 287T425 278T465 266Q674 199 693 28L694 17L692 14Q691 11 689 8T683 3T673 0Q657 0 653 24Q623 270 118 270H112"],8927:[734,0,778,83,694,"195 713Q195 725 201 729T214 734Q227 734 231 722T238 691T255 641T299 580Q405 474 656 464H681Q694 451 694 443Q694 424 670 424H664Q535 424 415 465T235 595Q195 657 195 713ZM668 310Q694 310 694 290Q694 285 691 279Q684 271 664 270Q550 268 464 257T301 220T179 146T124 27Q119 0 103 0T83 16Q83 21 83 31T92 68T113 121T157 177T229 231Q295 268 405 290Q404 290 389 293T352 302T312 314Q138 371 96 500Q83 541 83 562Q83 568 89 574T103 580Q115 580 120 570T126 542T138 497T173 442Q289 310 659 310H668"],8928:[801,303,778,82,693,"82 344Q82 349 95 364H124Q266 364 398 390L429 397L509 595Q519 619 536 659Q581 766 590 783T609 801Q616 801 622 795T629 781Q629 776 553 595Q533 548 516 506T489 439T480 415Q482 415 505 426T538 444Q632 498 651 601Q654 621 658 628T673 635Q680 635 686 629T693 615Q693 591 678 546Q636 433 484 375L458 364L451 348Q443 332 443 329T455 324Q480 316 503 307T560 277T619 233T664 170T691 86Q693 68 691 64Q684 53 672 53Q664 53 658 59Q657 60 650 97T617 174T538 244Q515 257 476 273T428 289Q425 289 412 256Q381 179 344 90L262 -103H680Q682 -105 684 -108T688 -113T691 -118T693 -124Q693 -134 682 -141L464 -143H246L213 -219Q182 -292 178 -299Q172 -303 166 -303T153 -297T146 -283Q146 -282 174 -213T202 -143H95Q82 -128 82 -123T95 -103H220L302 97Q384 288 384 299Q384 302 341 308T235 319T124 324H95Q82 337 82 344ZM399 338Q403 338 406 346L409 353L375 344Q375 343 384 341T399 338"],8929:[801,303,778,82,694,"146 -283Q146 -282 174 -213T202 -143H95Q82 -127 82 -123T95 -103H220L300 93Q343 196 374 270Q385 294 386 299L373 295Q331 287 289 268Q241 249 208 224T159 174T135 127T124 85T118 59Q112 53 103 53Q91 53 84 64Q82 68 84 86Q96 185 174 248T375 337L400 344Q399 344 381 348T351 355T316 364T276 379T235 398T193 424T155 456T122 497T98 546Q82 587 82 615Q82 622 88 628T102 635Q112 635 116 628T124 601Q128 579 134 562T159 515T207 463T290 418T415 384L422 381L506 586Q571 744 584 772T609 801Q616 801 622 795T629 781T544 577Q525 529 504 478T473 402T462 375Q480 373 500 373Q579 364 651 364H680Q682 361 686 357T691 351T693 344Q693 337 680 324H651Q553 324 451 310L433 308L349 104L262 -101L473 -103H682Q694 -115 694 -123Q694 -133 682 -141L464 -143H246L213 -219Q182 -292 178 -299Q172 -303 166 -303T153 -297T146 -283"],8934:[730,359,778,55,719,"86 450Q93 455 380 592T673 730Q680 730 686 724T693 710Q693 702 688 699Q686 693 417 568L151 439L417 310Q685 185 688 179Q693 176 693 168Q693 161 687 155T675 148Q668 148 380 285T86 428Q74 438 86 450ZM55 -205Q55 -175 64 -142T92 -76T145 -22T222 -1Q288 -1 362 -66Q369 -72 372 -75T378 -79T382 -81T384 -79Q389 -74 439 21Q483 100 490 111T504 122Q510 122 518 118T526 103Q526 101 510 69T467 -12T419 -99L413 -112L433 -128Q498 -180 553 -180Q605 -180 646 -139Q672 -112 681 -77T693 -21T706 -1Q719 -1 719 -33Q719 -39 717 -57Q708 -141 655 -190Q625 -224 586 -232Q568 -237 551 -237Q487 -237 413 -172L391 -155Q391 -157 335 -255Q297 -325 286 -342T268 -359Q260 -359 254 -353T248 -339T304 -230L359 -126Q359 -124 337 -107T302 -81Q262 -57 221 -57Q170 -57 130 -93T84 -201Q82 -236 70 -236Q55 -236 55 -205"],8935:[730,359,778,55,719,"88 723Q95 730 99 730Q106 730 394 593T688 450Q693 447 693 439T688 428Q683 423 395 286T99 148Q94 148 88 155T82 168Q82 175 86 179Q89 184 357 310L624 439L357 568Q88 694 86 699Q81 703 81 711T88 723ZM55 -205Q55 -175 64 -142T92 -76T145 -22T222 -1Q288 -1 362 -66Q369 -72 372 -75T378 -79T382 -81T384 -79Q389 -74 439 21Q483 100 490 111T504 122Q510 122 518 118T526 103Q526 101 510 69T467 -12T419 -99L413 -112L433 -128Q498 -180 553 -180Q605 -180 646 -139Q672 -112 681 -77T693 -21T706 -1Q719 -1 719 -33Q719 -39 717 -57Q708 -141 655 -190Q625 -224 586 -232Q568 -237 551 -237Q487 -237 413 -172L391 -155Q391 -157 335 -255Q297 -325 286 -342T268 -359Q260 -359 254 -353T248 -339T304 -230L359 -126Q359 -124 337 -107T302 -81Q262 -57 221 -57Q170 -57 130 -93T84 -201Q82 -236 70 -236Q55 -236 55 -205"],8936:[730,359,778,55,719,"95 419Q81 433 81 439T95 459H124Q318 459 455 501Q515 521 556 550T615 607T641 659T652 702T659 725Q667 730 673 730Q680 730 686 724T693 710Q693 682 677 641Q668 616 654 594T622 554T586 522T545 497T504 477T464 462T428 452T397 444T375 439Q379 437 410 430T476 411T551 379T625 321T677 237Q693 196 693 168Q693 161 687 155T673 148Q662 148 658 154T651 181Q638 253 591 300T455 377Q318 419 124 419H95ZM55 -205Q55 -175 64 -142T92 -76T145 -22T222 -1Q288 -1 362 -66Q369 -72 372 -75T378 -79T382 -81T384 -79Q389 -74 439 21Q483 100 490 111T504 122Q510 122 518 118T526 103Q526 101 510 69T467 -12T419 -99L413 -112L433 -128Q498 -180 553 -180Q605 -180 646 -139Q672 -112 681 -77T693 -21T706 -1Q719 -1 719 -33Q719 -39 717 -57Q708 -141 655 -190Q625 -224 586 -232Q568 -237 551 -237Q487 -237 413 -172L391 -155Q391 -157 335 -255Q297 -325 286 -342T268 -359Q260 -359 254 -353T248 -339T304 -230L359 -126Q359 -124 337 -107T302 -81Q262 -57 221 -57Q170 -57 130 -93T84 -201Q82 -236 70 -236Q55 -236 55 -205"],8937:[730,359,778,55,719,"679 459Q693 445 693 439Q693 430 679 419H651Q455 419 319 377Q231 347 184 300T124 181Q120 161 116 155T102 148Q95 148 89 154T82 168Q82 192 97 237Q111 275 137 306T188 355T249 391T307 414T361 429T399 439Q397 440 364 447T298 467T224 499T149 557T97 641Q82 686 82 710Q82 717 88 723T102 730L115 725Q118 722 124 697Q137 625 184 578T319 501Q456 459 651 459H679ZM55 -205Q55 -175 64 -142T92 -76T145 -22T222 -1Q288 -1 362 -66Q369 -72 372 -75T378 -79T382 -81T384 -79Q389 -74 439 21Q483 100 490 111T504 122Q510 122 518 118T526 103Q526 101 510 69T467 -12T419 -99L413 -112L433 -128Q498 -180 553 -180Q605 -180 646 -139Q672 -112 681 -77T693 -21T706 -1Q719 -1 719 -33Q719 -39 717 -57Q708 -141 655 -190Q625 -224 586 -232Q568 -237 551 -237Q487 -237 413 -172L391 -155Q391 -157 335 -255Q297 -325 286 -342T268 -359Q260 -359 254 -353T248 -339T304 -230L359 -126Q359 -124 337 -107T302 -81Q262 -57 221 -57Q170 -57 130 -93T84 -201Q82 -236 70 -236Q55 -236 55 -205"],8938:[707,208,778,82,693,"693 -30Q686 -41 673 -41Q661 -41 506 34L346 110L280 -44Q228 -162 216 -185T193 -208Q177 -208 173 -192Q173 -186 242 -30T311 128Q271 145 184 186T86 236Q82 240 82 246Q82 251 86 259Q96 267 271 350L449 434L506 565Q537 635 551 664T571 700T582 706Q587 706 593 701T600 690Q600 679 553 572Q504 463 504 461L586 501Q672 539 673 539Q679 539 693 525V-30ZM653 10V488L566 445L480 405L422 276Q415 260 405 236T388 199T376 171T368 151T366 145Q368 143 510 77T653 10ZM422 374Q422 376 420 376T285 313T151 248Q315 168 326 163Q415 356 422 374"],8939:[706,208,778,82,693,"82 525Q96 539 102 539Q103 539 122 530T186 501T266 463L426 388Q428 388 495 541Q564 694 569 699Q573 706 581 706Q587 706 593 702T600 691Q600 676 533 528Q515 486 506 465T485 418T470 381T466 370Q466 369 575 316Q676 269 689 259Q693 253 693 248Q693 242 689 236Q688 235 506 145Q328 63 324 59Q324 50 266 -70Q224 -169 214 -188T193 -208Q177 -208 173 -192Q173 -183 222 -77Q244 -29 257 2T269 34L186 -6Q108 -43 99 -43Q93 -43 82 -30V525ZM271 416Q129 485 126 485H125Q122 485 122 250Q122 10 124 10L211 50L295 92L411 350Q411 351 271 416ZM624 248L449 332L440 319Q434 297 393 214Q353 121 353 119Q355 119 489 182T624 248"],8940:[802,303,778,82,693,"82 -123Q82 -114 93 -103H166L238 -101L293 50Q349 200 349 204L220 266Q166 291 140 304T100 325T84 336T82 344Q82 353 94 360Q112 372 282 453L473 541L482 568Q487 578 529 693Q559 785 569 795Q573 802 581 802Q587 802 593 797T599 786Q599 775 564 675L526 570Q526 568 561 584T633 617T673 635Q679 635 693 621V66Q686 54 679 54Q665 54 526 119Q491 137 458 153T405 177T386 184Q385 182 334 42T282 -101T482 -103H680Q682 -105 684 -108T688 -113T691 -118T693 -124Q693 -134 682 -141L473 -143H266L238 -219Q217 -278 210 -290T193 -303Q178 -303 173 -287Q173 -279 198 -214L222 -145Q222 -143 158 -143L93 -141L86 -136Q82 -131 82 -123ZM653 106V584L506 513L453 370Q442 339 428 300T407 243T400 224Q403 222 527 164T653 106ZM453 486Q453 488 451 488T300 417T151 344L224 308Q247 298 285 279T331 257L364 241L453 486"],8941:[801,303,778,82,693,"82 621Q96 635 102 635T249 568L420 486L449 473L469 533Q563 789 569 797Q573 801 581 801Q598 801 600 786Q602 781 544 617L484 455Q531 435 584 408Q677 364 689 355Q693 351 693 344Q693 339 692 337T676 325T631 302T538 257Q504 241 465 223T406 195T386 186Q384 184 333 44T282 -101Q282 -103 482 -103H680Q682 -105 684 -108T688 -113T691 -118T693 -124Q693 -134 682 -141L473 -143H266L238 -219Q217 -278 210 -290T193 -303Q178 -303 173 -287Q173 -279 198 -214L222 -145Q222 -143 158 -143L93 -141L86 -136Q82 -131 82 -123Q82 -114 93 -103H166L238 -101L333 159Q326 159 220 106Q110 54 97 54Q89 54 82 66V621ZM298 501Q155 567 142 575L122 584V344Q122 106 124 106Q125 106 180 132T291 185T351 213Q355 217 393 326L433 435Q433 436 298 501ZM549 381Q472 417 471 417L406 241Q408 240 516 291T624 344L549 381"]});
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/MathOperators.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{10731:[716,132,667,56,611,"318 709Q325 716 332 716Q340 716 344 713T474 511Q611 298 611 292Q611 285 526 152Q494 103 474 72Q347 -128 344 -130Q340 -132 333 -132T322 -130Q319 -128 257 -31T131 169T60 278Q56 285 56 292Q56 298 60 305Q73 326 194 516T318 709"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/MiscMathSymbolsB.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{10846:[813,97,611,54,555,"55 795Q56 806 70 813H540Q554 806 555 795Q555 791 554 788T552 783T549 779T546 777T542 775T539 773H71Q70 773 68 774T65 776T61 779T58 783T56 788T55 795ZM55 601Q56 612 70 619H540Q554 612 555 601Q555 597 554 594T552 589T549 585T546 583T542 581T539 579H71Q70 579 68 580T65 582T61 585T58 589T56 594T55 601ZM75 -97Q67 -97 61 -91T55 -81Q55 -71 169 166T285 410Q295 425 305 425Q311 425 316 422T323 414L325 410Q327 404 441 167T555 -81Q555 -85 549 -91T535 -97T520 -90Q519 -89 506 -61T463 27T411 136L305 358L199 136Q167 71 129 -10Q98 -75 92 -86T75 -97"],10877:[636,138,778,83,694,"674 636Q682 636 688 630T694 615T687 601Q686 600 417 472L151 346L399 228Q687 92 691 87Q694 81 694 76Q694 58 676 56H670L382 192Q92 329 90 331Q83 336 83 348Q84 359 96 365Q104 369 382 500T665 634Q669 636 674 636ZM94 170Q102 172 104 172Q110 171 254 103T535 -30T678 -98Q694 -106 694 -118Q694 -136 676 -138H670L382 -2Q92 135 90 137Q83 142 83 154Q84 164 94 170"],10878:[636,138,778,82,694,"83 616Q83 624 89 630T99 636Q107 636 253 568T543 431T687 361Q694 356 694 346T687 331Q685 329 395 192L107 56H101Q83 58 83 76Q83 77 83 79Q82 86 98 95Q117 105 248 167Q326 204 378 228L626 346L360 472Q291 505 200 548Q112 589 98 597T83 616ZM674 172Q692 172 694 154Q694 142 687 137Q685 135 395 -2L107 -138H101Q83 -136 83 -118Q83 -106 96 -100Q100 -98 380 35T665 170T674 172"],10885:[762,290,778,55,722,"667 761Q669 762 673 762Q682 762 688 756T694 741Q694 731 687 727Q684 724 420 613L156 502L416 392Q476 367 544 338T647 295T682 280Q694 274 694 262Q694 244 676 242Q670 242 524 303T235 425T90 487Q83 493 83 501Q83 514 94 519Q97 520 378 639T667 761ZM55 -23Q55 43 103 90T223 138Q265 138 316 114Q342 100 393 68L443 36Q502 0 554 0Q609 0 650 32T694 109Q694 138 708 138Q710 138 713 136T719 127T722 108Q722 37 673 -9T557 -56Q514 -56 468 -35T387 13T308 60T223 82Q167 82 127 50T83 -27Q81 -56 69 -56Q55 -56 55 -23ZM55 -257Q55 -191 103 -144T223 -96Q265 -96 316 -120Q342 -134 393 -166L443 -198Q502 -234 554 -234Q609 -234 650 -202T694 -125Q694 -96 708 -96Q710 -96 713 -98T719 -107T722 -126Q722 -197 673 -243T557 -290Q514 -290 468 -269T387 -221T308 -174T223 -152Q167 -152 127 -184T83 -261Q80 -290 69 -290Q55 -290 55 -257"],10886:[762,290,778,55,722,"90 727Q83 734 83 743Q83 751 89 756T104 762Q111 760 396 641Q686 518 687 517Q694 512 694 502T687 487Q686 486 543 425T253 303T101 242Q83 244 83 262Q83 274 95 280Q96 280 130 294T232 338T361 392L621 502L357 613Q93 724 90 727ZM55 -23Q55 43 103 90T223 138Q265 138 316 114Q342 100 393 68L443 36Q502 0 554 0Q609 0 650 32T694 109Q694 138 708 138Q710 138 713 136T719 127T722 108Q722 37 673 -9T557 -56Q514 -56 468 -35T387 13T308 60T223 82Q167 82 127 50T83 -27Q81 -56 69 -56Q55 -56 55 -23ZM55 -257Q55 -191 103 -144T223 -96Q265 -96 316 -120Q342 -134 393 -166L443 -198Q502 -234 554 -234Q609 -234 650 -202T694 -125Q694 -96 708 -96Q710 -96 713 -98T719 -107T722 -126Q722 -197 673 -243T557 -290Q514 -290 468 -269T387 -221T308 -174T223 -152Q167 -152 127 -184T83 -261Q80 -290 69 -290Q55 -290 55 -257"],10887:[636,241,778,82,694,"380 497Q445 528 522 564T636 618T673 635Q680 635 686 628T693 615T689 603Q686 599 418 472L151 343L418 215Q686 88 689 83Q693 79 693 72T687 59T675 52Q669 52 381 189T86 332Q82 337 82 344Q82 350 86 355Q91 359 380 497ZM82 -130T82 -124T95 -103H380L431 -54Q476 -6 486 -6Q491 -6 498 -12T505 -27Q505 -28 505 -29T504 -32Q503 -33 498 -38T485 -53T469 -70L438 -103H680Q682 -106 686 -110T691 -116T693 -123Q693 -130 680 -143H398L346 -192Q300 -241 291 -241Q271 -241 271 -221Q271 -209 306 -179L340 -143H95Q82 -130 82 -124"],10888:[635,241,778,82,693,"82 614Q82 620 86 625T94 632T100 635Q106 635 394 498T689 355Q693 349 693 343Q693 338 689 332Q683 327 395 190T100 52Q95 52 89 58T82 72Q82 80 95 88Q114 99 358 215L624 343L358 472Q89 599 86 603Q82 607 82 614ZM82 -130T82 -124T95 -103H380L431 -54Q476 -6 486 -6Q491 -6 498 -12T505 -27Q505 -28 505 -29T504 -32Q503 -33 498 -38T485 -53T469 -70L438 -103H680Q682 -106 686 -110T691 -116T693 -123Q693 -130 680 -143H398L346 -192Q300 -241 291 -241Q271 -241 271 -221Q271 -209 306 -179L340 -143H95Q82 -130 82 -124"],10889:[761,387,778,57,718,"86 512Q93 518 381 639T673 761Q680 761 686 755T693 741Q693 733 688 730Q685 723 419 612L155 501L419 390Q685 277 688 272Q693 269 693 261Q693 254 687 248T675 241Q669 241 381 362T86 490Q74 500 86 512ZM70 -59Q57 -59 57 -24Q57 40 104 87Q116 102 146 118Q186 136 231 136Q232 136 242 135T258 133T276 128T302 118T334 101T377 74Q386 69 396 63T411 53T417 50Q435 87 453 134Q491 223 495 227Q498 230 505 230Q513 230 519 225T526 212Q526 203 491 118T453 30Q453 22 489 10T553 -3Q589 -3 622 14Q653 28 669 50T688 90T694 122T706 136Q718 136 718 114Q718 113 718 109T717 103Q717 31 668 -14T554 -60Q529 -60 499 -50T451 -32T433 -24Q431 -24 404 -90T375 -157Q375 -159 402 -178T473 -218T553 -239Q599 -239 641 -211T691 -130Q694 -99 706 -99T718 -122Q718 -123 718 -127T717 -133Q717 -204 668 -249T559 -295Q512 -295 470 -275T355 -206L322 -290Q313 -310 304 -332T289 -367T282 -382Q277 -387 270 -387Q262 -387 255 -382T248 -368Q248 -361 322 -186Q311 -177 280 -166T222 -155Q189 -155 153 -173Q122 -186 106 -208T87 -248T82 -280T71 -294Q57 -294 57 -259Q57 -195 104 -148Q122 -126 155 -113T220 -99Q245 -99 276 -109T324 -127T342 -135Q397 -2 397 1Q386 10 367 23T302 58T222 80Q175 80 132 52T84 -28Q82 -59 70 -59"],10890:[761,387,778,57,718,"86 730Q81 734 81 740Q81 747 88 754T99 761Q103 761 392 640T688 512Q693 509 693 501T688 490Q682 484 394 363T99 241Q94 241 88 248T82 261Q82 268 86 272Q89 277 355 390L619 501L355 612Q89 723 86 730ZM70 -59Q57 -59 57 -24Q57 40 104 87Q116 102 146 118Q186 136 231 136Q232 136 242 135T258 133T276 128T302 118T334 101T377 74Q386 69 396 63T411 53T417 50Q435 87 453 134Q491 223 495 227Q498 230 505 230Q513 230 519 225T526 212Q526 203 491 118T453 30Q453 22 489 10T553 -3Q589 -3 622 14Q653 28 669 50T688 90T694 122T706 136Q718 136 718 114Q718 113 718 109T717 103Q717 31 668 -14T554 -60Q529 -60 499 -50T451 -32T433 -24Q431 -24 404 -90T375 -157Q375 -159 402 -178T473 -218T553 -239Q599 -239 641 -211T691 -130Q694 -99 706 -99T718 -122Q718 -123 718 -127T717 -133Q717 -204 668 -249T559 -295Q512 -295 470 -275T355 -206L322 -290Q313 -310 304 -332T289 -367T282 -382Q277 -387 270 -387Q262 -387 255 -382T248 -368Q248 -361 322 -186Q311 -177 280 -166T222 -155Q189 -155 153 -173Q122 -186 106 -208T87 -248T82 -280T71 -294Q57 -294 57 -259Q57 -195 104 -148Q122 -126 155 -113T220 -99Q245 -99 276 -109T324 -127T342 -135Q397 -2 397 1Q386 10 367 23T302 58T222 80Q175 80 132 52T84 -28Q82 -59 70 -59"],10891:[1003,463,778,83,694,"674 1003Q681 1003 687 999T694 983Q694 973 683 967Q669 959 420 868L162 772L422 676Q683 579 685 577Q694 571 694 560Q694 550 687 546T673 541Q669 542 384 647T93 755Q83 760 83 772Q83 783 91 788Q98 791 383 897T674 1003ZM84 354T84 367T98 387H679Q694 379 694 367Q694 354 679 347H98Q84 354 84 367ZM84 160T84 173T98 193H679Q694 185 694 173Q694 160 679 153H98Q84 160 84 173ZM94 -3Q102 -1 104 -1Q107 -2 392 -107T684 -215Q694 -219 694 -232Q694 -241 687 -247Q686 -248 395 -357Q106 -463 101 -463Q83 -461 83 -443Q83 -431 94 -426Q97 -423 357 -328L615 -232L355 -136Q94 -39 92 -37Q83 -31 83 -21Q83 -9 94 -3"],10892:[1003,463,778,83,694,"104 541Q98 541 91 545T83 560Q83 571 92 577Q94 579 355 676L615 772L357 868Q108 959 94 967Q83 973 83 983Q83 989 87 996T104 1003Q109 1002 396 896T687 787Q694 781 694 772Q694 759 684 755Q678 752 393 647T104 541ZM84 367Q84 380 98 387H679Q694 379 694 367Q694 356 680 348L390 347H100Q84 352 84 367ZM84 173Q84 188 100 193H680Q694 183 694 173Q694 160 679 153H98Q84 160 84 173ZM674 -1Q682 -1 688 -6T694 -20Q694 -31 685 -37Q683 -39 422 -136L162 -232L420 -328Q680 -423 683 -426Q694 -431 694 -443Q694 -461 676 -463Q671 -463 382 -357Q91 -248 90 -247Q83 -242 83 -232Q83 -220 93 -215Q667 -1 674 -1"],10901:[636,138,778,83,694,"674 636Q682 636 688 631T694 616Q694 605 687 601Q685 599 395 462L107 326H101Q83 328 83 345Q83 358 96 365Q102 367 382 500T665 634Q671 636 674 636ZM674 442Q692 442 694 424Q694 412 687 407Q686 406 417 278L151 152L399 34Q687 -102 691 -107Q694 -113 694 -118Q694 -136 676 -138H670L382 -2Q92 135 90 137Q83 142 83 154Q84 165 96 171Q104 175 382 306T665 440Q669 442 674 442"],10902:[636,138,778,83,694,"83 616Q83 624 89 630T99 636Q107 636 253 568T543 431T687 361Q694 354 694 346Q694 328 676 326H670L382 462Q317 493 226 535Q119 585 101 595T83 616ZM94 440Q102 442 104 442Q110 441 254 373T535 240T678 172Q679 172 680 171Q694 164 694 153T687 137Q685 135 395 -2L107 -138H101Q83 -136 83 -118Q83 -106 93 -101L128 -84Q163 -68 230 -36T361 26L626 152L360 278Q91 406 90 407Q83 412 83 424Q84 434 94 440"],10933:[752,286,778,82,693,"653 734Q653 738 660 745T673 752T686 745T693 723Q672 555 466 485Q390 463 378 463Q373 463 373 461Q373 458 378 458Q390 458 466 436Q562 404 620 350Q682 283 693 198Q693 183 686 176Q681 170 674 170T660 176T653 187Q653 192 652 200T646 228T631 265T602 307T555 350Q435 431 151 441H95Q82 454 82 460T95 481H151Q165 482 197 483T238 485Q427 500 528 554T649 707Q653 729 653 734ZM82 33Q82 37 83 40T89 47T95 54H473L520 105Q569 156 571 156Q573 157 578 157Q586 157 592 151T598 136Q598 130 562 92L526 56L604 54H682Q693 43 693 35Q693 31 692 28T686 21T680 14H489L342 -139L513 -142H682Q693 -148 693 -160Q693 -167 680 -182H304L258 -230Q248 -240 237 -251T221 -268T211 -278T203 -284T197 -286Q189 -286 184 -280T178 -264Q178 -257 213 -219L249 -182H171L93 -179L86 -175Q82 -170 82 -163Q82 -155 95 -142H289L360 -64L433 14H262L93 16Q82 23 82 33"],10934:[752,286,778,82,693,"693 466T693 460T680 441H624Q608 439 577 438T538 436Q349 421 248 367T126 214Q122 192 122 187Q122 183 116 177T102 170Q95 170 89 176Q82 183 82 198Q93 283 155 350Q213 404 309 436Q385 458 398 458Q402 458 402 461Q402 463 398 463Q385 463 309 485Q103 555 82 723Q82 738 89 745T102 752T115 745T122 734Q122 721 126 701T155 640T220 572Q340 490 624 481H680Q693 466 693 460ZM82 33Q82 37 83 40T89 47T95 54H473L520 105Q569 156 571 156Q573 157 578 157Q586 157 592 151T598 136Q598 130 562 92L526 56L604 54H682Q693 43 693 35Q693 31 692 28T686 21T680 14H489L342 -139L513 -142H682Q693 -148 693 -160Q693 -167 680 -182H304L258 -230Q248 -240 237 -251T221 -268T211 -278T203 -284T197 -286Q189 -286 184 -280T178 -264Q178 -257 213 -219L249 -182H171L93 -179L86 -175Q82 -170 82 -163Q82 -155 95 -142H289L360 -64L433 14H262L93 16Q82 23 82 33"],10935:[761,294,778,57,717,"82 494T82 501T95 521H171Q405 527 511 569Q630 618 651 732Q652 734 653 740T655 748T658 754T663 759T672 761L686 754Q693 747 693 734Q684 668 648 623Q627 591 573 557T442 507L417 501Q428 496 442 494Q520 478 573 444T648 378Q684 333 693 267Q693 254 686 247Q673 234 659 245Q657 247 651 269Q630 383 511 432Q406 474 171 481H95Q82 494 82 501ZM70 -59Q57 -59 57 -26Q57 30 90 73T177 132Q191 136 226 136Q228 136 239 136T253 135T267 132T287 125T311 113T346 95T391 67Q462 20 502 5Q519 1 553 1Q586 1 602 5Q641 18 664 45T691 107Q694 136 704 136Q717 136 717 115V105Q717 39 671 -9T554 -58Q518 -58 481 -43T382 14Q302 63 273 74Q255 78 222 78Q188 78 173 74Q90 46 84 -28Q82 -59 70 -59ZM71 -294Q57 -294 57 -262Q57 -205 90 -162T177 -104Q191 -99 226 -99Q266 -103 277 -106Q310 -119 391 -168Q455 -212 502 -231Q519 -235 553 -235Q586 -235 602 -231Q640 -218 661 -195T686 -151T693 -115T704 -99Q717 -99 717 -121V-131Q717 -198 671 -246T556 -294Q519 -294 482 -279T382 -222Q307 -175 273 -162Q255 -157 222 -157Q188 -157 173 -162Q133 -175 110 -201T84 -264Q82 -294 71 -294"],10936:[761,294,778,57,717,"693 501Q693 493 679 481H604Q369 474 264 432Q143 382 124 269Q116 246 115 245Q101 234 88 247Q82 254 82 267Q89 329 126 378Q147 410 201 444T333 494L357 501Q354 502 340 505T318 510T295 516T269 525T243 535T215 548T188 565Q142 599 126 623Q89 672 82 734Q82 761 102 761L115 756Q116 755 124 732Q143 619 264 569Q371 527 604 521H679Q693 507 693 501ZM70 -59Q57 -59 57 -26Q57 30 90 73T177 132Q191 136 226 136Q228 136 239 136T253 135T267 132T287 125T311 113T346 95T391 67Q462 20 502 5Q519 1 553 1Q586 1 602 5Q641 18 664 45T691 107Q694 136 704 136Q717 136 717 115V105Q717 39 671 -9T554 -58Q518 -58 481 -43T382 14Q302 63 273 74Q255 78 222 78Q188 78 173 74Q90 46 84 -28Q82 -59 70 -59ZM71 -294Q57 -294 57 -262Q57 -205 90 -162T177 -104Q191 -99 226 -99Q266 -103 277 -106Q310 -119 391 -168Q455 -212 502 -231Q519 -235 553 -235Q586 -235 602 -231Q640 -218 661 -195T686 -151T693 -115T704 -99Q717 -99 717 -121V-131Q717 -198 671 -246T556 -294Q519 -294 482 -279T382 -222Q307 -175 273 -162Q255 -157 222 -157Q188 -157 173 -162Q133 -175 110 -201T84 -264Q82 -294 71 -294"],10937:[761,337,778,57,718,"82 494T82 501T95 521H171Q256 523 317 528T441 548T543 584T613 644T651 732Q652 734 653 740T655 748T658 754T663 759T672 761L686 754Q693 747 693 734Q686 686 664 647T615 586T548 545T482 518T417 501Q419 500 451 493T517 471T590 434T657 367T693 267Q693 241 673 241Q664 241 659 245Q656 249 650 273T635 323T593 380T511 432Q406 474 171 481H95Q82 494 82 501ZM57 -26Q57 39 101 87T219 136Q254 136 277 130Q320 114 382 72Q419 50 424 45Q426 45 459 110Q496 178 497 179Q500 180 504 180Q509 180 517 175T526 161Q526 158 495 90L462 25Q462 21 502 5Q519 1 553 1Q586 1 602 5Q641 18 664 45T691 107Q694 136 706 136T718 115Q718 114 718 111T717 105Q717 39 671 -9T554 -58L459 -33Q450 -29 444 -27T437 -26L371 -155L391 -168Q485 -235 538 -235H553Q586 -235 602 -230Q683 -204 691 -128Q694 -99 706 -99T718 -120Q718 -121 718 -124T717 -130Q717 -199 670 -246T557 -294T393 -228Q353 -205 351 -201Q348 -201 315 -266Q294 -310 285 -323T268 -337Q259 -337 254 -331T248 -317Q248 -305 282 -246L313 -181Q313 -177 273 -161Q255 -157 222 -157Q188 -157 173 -161Q134 -174 113 -198T88 -242T82 -278T71 -294Q57 -294 57 -261Q57 -204 91 -161T179 -104Q195 -99 228 -99Q274 -102 315 -124Q337 -132 337 -130L404 -1L384 12Q319 58 273 74Q255 79 222 79Q188 79 173 74Q133 61 112 37T88 -7T82 -43T70 -59Q57 -59 57 -26"],10938:[761,337,778,57,718,"693 501Q693 493 679 481H604Q548 479 509 477T418 469T331 454T257 429T194 392T150 340T124 270Q117 247 115 245Q101 236 88 247Q82 254 82 267Q89 330 126 379Q147 411 202 444T333 494L357 501Q239 531 188 565Q142 599 126 623Q89 672 82 734Q82 761 102 761L115 756Q116 755 124 732Q133 678 166 640T241 579T349 544T470 527T604 521H679Q693 507 693 501ZM57 -26Q57 39 101 87T219 136Q254 136 277 130Q320 114 382 72Q419 50 424 45Q426 45 459 110Q496 178 497 179Q500 180 504 180Q509 180 517 175T526 161Q526 158 495 90L462 25Q462 21 502 5Q519 1 553 1Q586 1 602 5Q641 18 664 45T691 107Q694 136 706 136T718 115Q718 114 718 111T717 105Q717 39 671 -9T554 -58L459 -33Q450 -29 444 -27T437 -26L371 -155L391 -168Q485 -235 538 -235H553Q586 -235 602 -230Q683 -204 691 -128Q694 -99 706 -99T718 -120Q718 -121 718 -124T717 -130Q717 -199 670 -246T557 -294T393 -228Q353 -205 351 -201Q348 -201 315 -266Q294 -310 285 -323T268 -337Q259 -337 254 -331T248 -317Q248 -305 282 -246L313 -181Q313 -177 273 -161Q255 -157 222 -157Q188 -157 173 -161Q134 -174 113 -198T88 -242T82 -278T71 -294Q57 -294 57 -261Q57 -204 91 -161T179 -104Q195 -99 228 -99Q274 -102 315 -124Q337 -132 337 -130L404 -1L384 12Q319 58 273 74Q255 79 222 79Q188 79 173 74Q133 61 112 37T88 -7T82 -43T70 -59Q57 -59 57 -26"],10949:[754,215,778,84,694,"84 463Q84 585 166 663T360 752Q361 752 370 752T395 752T430 752T475 753T524 753H679Q694 746 694 733Q694 724 681 714L522 713H470H441Q366 713 338 709T266 685Q244 674 224 659T179 617T139 550T124 463V458Q124 370 185 302Q244 238 328 220Q348 215 366 215T522 213H681Q694 203 694 193Q694 180 679 173H526Q510 173 480 173T434 172Q350 172 289 188T172 258Q84 340 84 463ZM84 -14T84 -1T98 19H679Q694 11 694 -1Q694 -14 679 -21H98Q84 -14 84 -1ZM84 -208T84 -195T98 -175H679Q694 -183 694 -195Q694 -208 679 -215H98Q84 -208 84 -195"],10950:[754,215,778,83,694,"83 733Q83 746 98 753H251Q267 753 297 753T343 754Q427 754 488 738T605 668Q693 587 693 463Q693 378 650 312T545 213T415 174Q407 173 251 173H98Q83 180 83 193Q83 203 96 213H255H308H337Q412 213 439 217T512 241Q533 252 553 267T599 309T639 376T654 463Q654 554 592 624Q557 662 512 685Q468 704 439 708T335 713H306H255L96 714Q83 724 83 733ZM84 -14T84 -1T98 19H679Q694 11 694 -1Q694 -14 679 -21H98Q84 -14 84 -1ZM84 -208T84 -195T98 -175H679Q694 -183 694 -195Q694 -208 679 -215H98Q84 -208 84 -195"],10955:[783,385,778,82,694,"693 221Q693 214 680 201H524Q398 201 367 202T309 212Q236 230 180 280T98 398Q84 438 84 492T98 585Q126 663 193 716T346 781Q347 781 373 781T440 782T520 783H680Q682 780 686 776T691 770T693 763T680 743H526Q364 743 353 741Q279 730 221 687T138 578Q124 540 124 492T138 405Q163 340 221 297T353 243Q364 241 526 241H680Q682 238 686 234T691 228T693 221ZM82 -48T82 -41T95 -19H462L513 41L569 105Q574 110 582 110T596 104T602 90Q602 87 600 83Q600 77 555 30L515 -17L600 -19H682Q693 -30 693 -38T680 -59H480L415 -137L349 -213L515 -215H682Q693 -226 693 -233T680 -255H313L260 -317Q224 -360 212 -372T192 -385Q184 -385 179 -377T173 -362Q174 -361 218 -306L260 -255H178L93 -253L86 -248Q82 -243 82 -235Q82 -226 93 -215H195L295 -213L362 -137L426 -59H260L93 -57L86 -53Q82 -48 82 -41"],10956:[783,385,778,82,693,"82 759T82 763T83 769T89 776T95 783H251Q378 783 409 782T469 772Q540 753 596 703T678 585Q691 546 691 492T678 398Q649 320 581 267T426 203Q415 201 251 201H95Q82 214 82 221Q82 225 83 227T89 234T95 241H249Q411 241 422 243Q496 253 554 296T638 405Q651 444 651 492Q651 539 638 578Q613 643 555 686T422 741Q411 743 249 743H95Q82 759 82 763ZM82 -48T82 -41T95 -19H462L513 41L569 105Q574 110 582 110T596 104T602 90Q602 87 600 83Q600 77 555 30L515 -17L600 -19H682Q693 -30 693 -38T680 -59H480L415 -137L349 -213L515 -215H682Q693 -226 693 -233T680 -255H313L260 -317Q224 -360 212 -372T192 -385Q184 -385 179 -377T173 -362Q174 -361 218 -306L260 -255H178L93 -253L86 -248Q82 -243 82 -235Q82 -226 93 -215H195L295 -213L362 -137L426 -59H260L93 -57L86 -53Q82 -48 82 -41"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/SuppMathOperators.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{165:[683,0,750,11,738,"515 0Q494 3 374 3Q256 3 235 0H224V46H257Q316 47 324 58Q327 62 327 137V213H133Q121 213 113 213T97 213T86 213T78 213T73 214T70 215T69 216T68 218T67 220Q64 225 66 231T73 240Q76 242 202 242H327V273L247 407H115Q81 407 75 408T67 414Q64 419 66 425T73 434Q76 436 153 436Q228 436 228 437Q227 440 173 530T115 623Q101 637 31 637H11V683H20Q66 681 153 681Q169 681 202 681T262 682L288 683H298V637H280Q230 636 230 621Q230 619 250 584Q255 576 264 561T286 526T305 494L340 437L403 436H467L513 514Q564 596 564 605Q564 608 560 616Q550 634 517 637H508V683H516Q531 680 633 680Q722 680 731 683H738V637H723Q644 632 617 595Q614 591 568 515T521 437T597 436T676 434Q681 432 683 426T682 414T671 409T589 407H503L422 273V242H547Q673 242 676 240Q681 238 683 232T682 220Q682 219 682 218T681 217T679 216T677 215T672 214T664 213T652 213T637 213T616 213H422V139V87Q422 64 425 58T441 49Q456 46 503 46H525V0H515ZM449 406Q449 407 403 407Q358 407 358 406L370 387Q381 368 392 350L404 331Q447 404 449 406"],174:[709,176,947,32,915,"915 266Q915 140 852 38T689 -120T474 -175Q312 -175 188 -71T38 190Q32 220 32 266V287Q32 345 57 416T129 545Q192 624 282 666T464 709Q513 709 522 708Q599 698 665 666T776 590T853 493T900 387T915 287V266ZM875 285Q875 339 853 399T789 517T676 616T519 668Q510 669 465 669Q380 669 299 630T155 514T77 336Q72 312 72 285V266V256Q72 123 163 11Q290 -135 474 -135Q614 -135 727 -46Q875 81 875 266V285ZM276 457Q275 458 274 460T272 463T270 465T267 467T264 469T258 471T252 472T243 473T232 474T218 474H204V514H335Q477 514 499 510Q560 502 610 467T661 375Q661 362 658 350T648 327T635 308T618 292T601 280T583 269T568 262T554 256L547 253Q548 252 556 247T570 237T586 223T602 202T614 174Q616 169 626 123T638 72Q652 23 683 23Q715 23 720 68Q721 78 724 81T740 84T756 82T760 70Q760 47 747 25T715 -7Q700 -14 673 -14Q672 -14 662 -14T643 -12T619 -7T593 2T568 16T547 37T534 67Q531 80 531 97Q531 103 531 116T532 136Q532 218 472 236Q466 238 413 239H360V148L361 58Q366 47 375 44T418 40H432V0H424Q409 3 318 3T212 0H204V40H218Q242 40 253 42T268 47T276 58V457ZM376 473Q365 471 363 464T360 430V366V276H416Q421 276 434 276T453 276T469 277T486 279T501 282T517 287T529 294T542 305Q561 324 561 375Q561 424 545 444T482 472Q478 473 427 474Q415 474 403 474T384 474L376 473"],240:[749,21,556,42,509,"75 566V604Q75 624 79 629T102 635Q124 635 127 629T131 588L133 550L191 588L249 628L231 635Q176 654 124 657Q116 657 106 658L95 659Q94 661 94 687T95 715Q99 717 113 717Q195 717 282 679L309 668L331 681Q351 697 391 721Q428 748 435 748Q437 749 446 749Q470 749 473 746Q478 744 478 681V621Q466 615 456 615Q435 615 424 624L422 661V699L382 675L344 648Q353 639 366 630Q480 538 504 413Q509 393 509 333V313Q509 284 507 257T495 184T466 102T413 33T329 -16Q311 -21 275 -21Q226 -21 195 -10Q150 7 110 50T53 141Q42 179 42 227Q42 332 101 403T245 474Q282 474 314 461T359 436T380 415Q386 405 389 408Q389 426 378 475Q368 505 355 529T329 567T306 590T288 603L282 606L120 501Q116 500 102 500Q84 500 75 506V566ZM388 225Q388 376 309 410Q299 416 273 419Q216 419 191 390Q174 371 168 342T162 218Q162 112 184 79Q212 39 273 39Q312 39 342 62T380 121Q388 159 388 225"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/Latin1Supplement.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_AMS,{9416:[709,175,902,8,894,"451 -175Q328 -175 226 -115T66 47T8 267Q8 303 15 342T39 431T94 531T186 622Q239 663 307 686T424 709H440Q604 709 716 622Q757 592 788 555T838 482T869 414T886 350T892 301T894 267Q894 147 835 45T674 -116T451 -175ZM854 268Q854 375 802 467T657 614T450 670Q283 670 166 552T49 267Q49 99 167 -18T453 -136Q617 -136 735 -18T854 268ZM273 378Q273 430 309 474T409 527Q411 527 417 527T428 528Q498 528 549 484L567 505Q583 528 590 528H594Q600 528 606 522V350L600 344H586Q577 344 574 344T569 347T566 357Q542 491 432 491Q389 491 365 465T340 407Q340 391 344 378T358 356T377 340T400 328T421 321T443 316T459 313Q499 305 517 300T559 279T601 238Q629 195 629 148Q629 80 583 33T471 -14Q392 -14 330 30Q312 6 293 -13Q292 -14 285 -14Q279 -14 273 -8V77V138Q273 160 275 165T286 170H294H307Q313 164 313 158Q313 108 350 67T471 26Q512 26 537 54T562 119Q562 137 558 151T544 176T527 193T504 205T483 212T459 218T441 222Q391 232 368 241T318 273Q273 316 273 378"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/AMS/Regular/EnclosedAlphanum.js");MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Typewriter={directory:"Typewriter/Regular",family:"MathJax_Typewriter",id:"MJTT",Ranges:[[0,127,"BasicLatin"],[128,65535,"Other"],[768,879,"CombDiacritMarks"]]};MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Typewriter/Regular/Main.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Typewriter,{305:[432,-1,525,72,462,"411 76Q441 76 451 69T462 38Q462 29 462 26T460 18T453 9T440 1H94Q72 8 72 33V38Q72 46 72 49T74 58T81 68T94 76H233V355H167L102 356Q80 363 80 393Q80 418 91 425T138 432Q145 432 165 432T200 431H295Q297 429 303 425T310 420T314 415T317 404T317 389T318 363Q318 354 318 314T317 241V76H378H411"],567:[432,228,525,48,377,"75 -91T100 -91T138 -107T152 -144V-150L160 -151H193H203Q241 -151 267 -121Q284 -97 288 -73T292 23V151V355H218L145 356Q123 365 123 387V393Q123 422 145 430H148Q151 430 156 430T169 430T185 430T205 431T227 431T251 431H354Q356 430 360 427T365 424T369 420T372 416T373 410T375 402T376 391T377 376T377 356Q377 345 377 286T376 176Q376 -67 371 -88Q362 -123 342 -151T299 -194Q254 -228 180 -228Q84 -226 56 -177Q49 -162 48 -148Q48 -122 61 -107"],915:[611,0,525,25,488,"466 611Q468 609 473 606T479 602T483 598T486 593T487 586T488 576T488 562V526V488Q488 452 470 444Q466 442 446 442Q421 442 413 450Q406 457 405 463T404 501V535H185V76H222H239Q260 76 270 69T281 38Q281 12 270 6T209 0H155H104Q48 0 37 5T25 38Q25 59 35 69Q44 76 76 76H101V535H76H64Q36 535 27 552Q25 557 25 573T27 594Q33 606 43 608T106 611H258H466"],916:[623,0,525,35,489,"232 622H237Q242 622 249 622T264 623H293Q295 622 300 619T308 613T314 608T319 601Q322 597 405 316T489 19Q489 9 473 1Q471 0 262 0T51 1Q35 9 35 19Q35 34 118 315T205 601Q214 616 232 622ZM267 501Q266 504 265 510T263 521T261 526V523Q261 508 211 332Q142 91 138 82H386Q385 84 345 224Q281 439 267 501"],920:[621,10,525,56,468,"102 588Q140 621 240 621Q323 621 335 620Q393 613 422 588Q450 560 459 493T468 306Q468 185 460 118T422 23Q382 -10 289 -10H262H235Q142 -10 102 23Q74 50 65 118T56 306Q56 427 64 494T102 588ZM262 66Q285 66 300 67T329 74T351 86T366 108T376 138T381 181T383 235T384 306Q384 452 371 492T304 544Q296 545 251 545Q230 545 215 543T188 534T169 520T155 497T147 466T143 423T141 371T140 306Q140 247 141 215T146 151T158 107T179 82T212 69T262 66ZM179 356Q187 378 219 378H223Q240 377 249 372T260 360L261 355Q261 353 262 353T263 355Q263 362 272 369Q280 377 304 377H310Q325 377 331 374T346 356V256Q338 241 331 238T309 234H304Q280 234 272 242Q263 249 263 256Q263 258 262 258T261 256Q261 249 252 242Q244 234 220 234H216Q186 234 179 256V356"],923:[623,-1,525,30,495,"30 38Q30 57 38 66T70 76Q88 76 88 78Q89 79 117 207T173 466T205 602Q213 617 231 622H236Q241 622 249 622T264 623H294Q315 609 319 602Q321 598 350 468T407 208T435 78Q436 76 454 76Q470 76 478 73Q495 62 495 38Q495 10 473 1H313Q290 10 290 38Q290 56 297 65T310 74T331 76Q350 76 350 78Q349 80 328 176T285 383T263 520Q263 526 262 527Q261 527 261 521Q261 497 240 388T198 181T174 78Q174 76 193 76Q220 75 227 65Q234 56 234 38Q234 28 234 24T228 13T212 1H52Q30 9 30 32V38"],926:[612,-1,525,33,491,"37 555V569Q37 605 60 610H66Q71 610 81 610T105 610T137 610T175 611T217 611T264 611H465Q467 609 471 606T477 602T481 599T484 594T485 588T487 580T487 570T487 554Q487 526 486 520T478 506Q470 498 445 498T412 506Q403 515 403 531V539H121V531Q121 498 86 498H79H71Q48 498 39 517Q37 522 37 555ZM109 318V346Q109 366 113 374T132 389H170Q193 379 193 359V354H331V359Q331 379 354 389H392Q407 381 411 373T415 342V318V290Q415 270 411 262T392 247H354Q331 257 331 277V282H193V277Q193 257 170 247H132Q117 255 113 263T109 294V318ZM56 1Q41 7 37 15T33 42V58V80Q33 101 41 110T77 119Q87 118 91 118T103 114T114 103T117 83V72H407V83Q407 101 416 110T449 119T482 110Q489 103 490 97T491 59V41Q491 24 487 16T469 1H56"],928:[611,-1,525,16,508,"60 535Q45 535 38 536T24 545T16 571Q16 603 36 609Q41 611 264 611H486Q501 602 504 596T508 573Q508 559 505 551T495 540T482 536T464 535H443V76H464H470Q482 76 489 75T502 64T508 38Q508 10 486 1H317Q306 5 301 11T296 21T295 38V44Q295 66 311 73Q318 76 338 76H359V535H165V76H186H192Q204 76 211 75T224 64T230 38Q230 10 208 1H39Q28 5 23 11T18 21T17 38V44Q17 66 33 73Q40 76 60 76H81V535H60"],931:[612,-1,525,39,484,"40 575Q40 576 40 579T41 583T41 588T43 593T46 597T50 602T55 606T63 610H68Q74 610 84 610T108 610T139 610T176 611T219 611T264 611H462Q464 609 469 606T475 602T479 598T482 593T483 586T484 576T484 562V526V488Q484 452 466 444Q462 442 442 442Q417 442 409 450Q402 457 401 463T400 501V535H153Q153 533 218 430Q233 405 250 378T276 336T286 319Q290 311 290 307Q290 296 239 211Q229 194 223 184L161 78H400V112Q400 142 401 149T409 163Q418 172 442 172Q473 172 482 152Q484 147 484 86V49Q484 25 481 17T462 1H63Q41 10 41 31Q41 39 43 44Q43 45 81 109T157 238L195 303Q195 307 119 430T41 557T40 575"],933:[623,-1,525,38,486,"38 494Q38 549 74 585T152 621Q168 621 179 619T209 606T241 566T262 492Q262 494 265 507T270 526T276 547T285 569T298 589T315 606T337 617T365 622Q416 622 451 584T486 494Q486 470 469 461Q464 459 445 459H437Q416 459 406 476Q404 479 403 502T393 541T365 558Q350 558 340 548T323 519T312 475T307 419T305 354T304 282Q304 254 304 239V76H358Q372 67 376 60T380 38Q380 10 358 1H167Q145 9 145 32V38Q145 54 148 60T167 76H220V239Q220 256 220 289T220 338T219 383T217 426T214 463T209 497T201 522T189 543T174 555Q168 558 159 558Q139 558 131 541T121 502T118 476Q108 459 84 459H79H71Q38 459 38 494"],934:[612,-1,525,41,483,"139 573V578Q139 603 161 610H166Q172 610 182 610T204 610T232 611T264 611H364Q379 602 382 595T385 573Q385 544 364 536L334 535H304V441H306Q313 440 325 438T367 426T421 403T464 364T483 306Q483 251 430 216T317 172Q315 172 313 172T308 170H306H304V76H364Q379 67 382 60T385 38Q385 28 385 24T379 12T364 1H161Q139 8 139 33V38Q139 46 139 49T141 58T148 68T161 76H220V170H218Q211 171 199 173T157 185T103 208T60 248T41 306Q41 361 94 396T208 439Q210 439 212 439T216 440L218 441H220V535H190L161 536Q139 543 139 573ZM124 306Q124 286 147 271T194 252L218 247Q220 247 220 306V364H218Q212 364 192 359T148 340T124 306ZM400 305Q400 325 377 340T330 360L306 364Q304 364 304 306Q304 247 306 247Q312 247 332 252T376 271T400 305"],936:[611,-1,525,37,487,"37 439Q38 451 40 457T52 469T77 475H79Q96 475 107 473T132 456T152 411Q152 409 153 396T154 372V365Q154 291 198 261Q215 251 219 251Q220 251 220 393V535H193L167 536Q145 545 145 567V573Q145 602 167 610Q168 611 264 611H358Q372 602 376 595T380 573Q380 545 358 536L331 535H304V393Q304 251 305 251Q307 251 310 252T323 259T339 272T355 295T367 331Q368 337 370 372Q370 382 371 395T372 411Q376 434 384 448T404 467T425 474T447 475Q461 474 467 473T480 463T487 437Q487 419 481 412Q476 403 459 398Q457 390 453 344T431 263Q415 228 383 205T332 177T306 172H304V76H358Q372 67 376 60T380 38Q380 10 358 1H167Q145 9 145 32V38Q145 54 148 60T167 76H220V172H218Q211 172 192 177T141 205T93 263Q74 298 71 343T67 391L66 398Q47 403 42 411T37 433V439"],937:[622,-1,525,32,492,"40 404Q40 498 106 560T258 622Q357 622 420 558T484 406Q484 359 469 311T428 205T392 117Q382 84 382 78Q382 76 402 76H421V87Q421 110 431 116T457 123Q474 123 483 114Q490 107 491 100T492 61V42Q492 11 474 3Q470 1 397 1H324Q302 9 302 32V39Q302 104 351 225T400 405Q400 462 361 504T262 546Q200 546 162 504T124 405Q124 346 171 230T223 42V36Q223 11 205 3Q201 1 128 1H55Q39 7 33 23L32 60V80Q32 94 34 102T44 116T68 123Q103 123 103 87V76H123Q142 76 142 78Q142 100 117 156T66 282T40 404"],2018:[611,-287,525,175,349,"205 554Q205 577 221 594T263 611Q302 611 325 577T349 490Q349 409 298 347Q285 330 258 309T214 287Q203 289 189 302T175 327Q175 341 185 349T213 369T245 402Q269 437 273 483V497Q264 496 263 496Q240 496 223 513T205 554"],2019:[681,-357,525,176,350,"176 479Q176 563 227 622T310 681Q324 680 337 667T350 641Q350 627 340 619T312 599T280 566Q256 531 252 485V471Q261 472 262 472Q285 472 302 455T320 414Q320 389 303 373T261 357Q223 357 200 391T176 479"],8242:[623,-334,525,211,313,"211 572Q211 593 226 608T262 623Q281 623 297 610T313 573Q313 561 307 465Q301 370 299 357T284 336Q279 334 262 334Q240 334 231 343Q226 350 225 362T217 465Q211 549 211 572"],8710:[623,0,525,35,489,""]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Typewriter/Regular/Other.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Typewriter,{32:[0,0,250,0,0,""],33:[622,0,525,206,320,"206 565Q206 590 222 606T265 622Q287 621 303 606T319 565T314 392L308 216Q299 194 273 194H262Q247 194 241 195T228 200T217 216L211 392Q206 539 206 565ZM206 56Q206 83 223 99T265 115Q288 113 304 99T320 58Q320 33 303 17T262 0Q237 0 222 17T206 56"],34:[623,-333,525,122,402,"122 575Q122 593 137 608T173 623Q196 623 210 608T225 575Q225 562 218 464Q212 373 211 361T201 341Q193 333 173 333Q154 333 146 341Q138 348 137 360T129 464Q122 561 122 575ZM299 575Q299 593 314 608T350 623Q373 623 387 608T402 575Q402 562 395 464Q389 373 388 361T378 341Q370 333 350 333Q331 333 323 341Q315 348 314 360T306 464Q299 561 299 575"],35:[612,0,525,36,489,"93 163Q74 163 65 164T46 173T36 198Q36 210 40 215T61 233H131V236Q132 239 140 307T149 377Q149 379 105 379L61 380Q36 392 36 414Q36 450 86 450Q91 450 99 450T112 449H159Q163 480 167 517Q168 524 170 545T174 573T180 591T191 607T210 611Q223 611 232 604T243 588L245 580Q245 565 238 511T230 451Q230 449 282 449H333Q337 480 341 517Q342 524 343 537T345 556T348 573T352 589T359 600T370 608T384 611Q395 611 406 602T419 580Q419 565 412 511T404 451Q404 449 431 449H442Q477 449 485 429Q489 421 489 414Q489 392 463 380L428 379H394V376Q393 373 385 305T376 235Q376 233 419 233H463L468 230Q472 227 473 227T477 223T482 218T486 213T488 206T489 198Q489 162 436 162Q430 162 422 162T412 163H366V161Q364 159 357 92Q356 85 355 73T353 54T350 37T346 22T339 11T328 3T314 0Q303 0 292 9T279 31Q279 37 287 96T295 162Q295 163 244 163H192V161Q190 159 183 92Q182 85 181 73T179 54T176 37T172 22T165 11T154 3T140 0Q129 0 118 9T105 31Q105 37 113 96T121 162Q121 163 93 163ZM323 377Q323 379 272 379H220V376Q219 373 211 305T202 235Q202 233 253 233H305V236Q306 239 314 307T323 377"],36:[694,82,525,58,466,"415 397Q392 397 377 411T362 448Q362 464 376 485Q369 498 362 506T346 520T332 528T315 533T300 538V445L301 353L311 350Q382 334 424 284T466 174Q466 115 425 65T303 -2L300 -3V-30Q300 -64 291 -74Q283 -82 262 -82H255Q234 -82 225 -60L224 -32V-4L213 -2Q152 6 106 51T59 170V180Q59 197 74 213Q89 227 110 227T146 213T162 174Q162 156 147 137Q153 123 161 112T176 95T191 85T205 79T216 76T224 74V283L213 285Q147 298 103 343T58 449Q58 516 108 560T224 614V643V654Q224 666 226 673T237 687T264 694Q289 693 294 683T300 642V615H303Q355 607 390 587T440 540T460 493T466 453Q466 425 451 411T415 397ZM137 452Q137 425 158 404T198 376T223 369Q224 369 224 453T223 537Q198 532 168 509T137 452ZM301 75Q307 75 325 83T365 116T387 171Q387 238 300 267V171Q300 75 301 75"],37:[694,83,525,35,489,"35 560Q35 607 54 645T110 693Q111 693 116 693T125 694Q165 692 187 651T210 560Q210 506 186 467T123 428Q84 428 60 466T35 560ZM139 560Q139 574 136 587T130 608T124 615Q122 617 120 614Q106 595 106 561Q106 516 121 506Q123 504 125 507Q139 526 139 560ZM123 -83Q107 -83 98 -73T88 -48Q88 -43 89 -41Q90 -37 229 316T370 675Q381 694 400 694Q416 694 426 684T436 659Q436 654 435 652Q434 647 295 294T153 -65Q144 -83 123 -83ZM314 50Q314 104 338 143T400 183Q439 183 464 144T489 50T465 -43T402 -82Q358 -82 336 -41T314 50ZM417 50Q417 71 413 85T405 102L401 106Q386 95 386 50Q386 29 390 15T398 -2L402 -6Q417 5 417 50"],38:[622,11,525,28,490,"96 462Q96 546 132 584T211 622Q255 622 284 583T314 474Q314 395 224 305L208 288Q213 275 226 251L265 185L269 179Q273 184 299 246L332 333L342 363Q342 364 341 365Q334 365 334 393Q334 406 334 410T340 420T356 431H412H440Q467 431 478 424T490 393Q490 376 484 367T470 357T448 355H441H415L399 312Q349 176 322 127L315 115L323 106Q360 65 393 65Q405 65 410 80T416 109Q416 140 452 140Q487 140 487 105Q487 56 460 23T391 -11L286 41L273 53L262 42Q212 -11 151 -11Q97 -11 63 33T28 143Q28 161 30 176T38 205T47 227T60 247T72 261T84 274T94 283L122 311L119 323Q96 392 96 462ZM243 474Q243 533 218 545L215 546Q212 546 210 546Q182 546 169 501Q167 492 167 466Q167 419 179 368L188 377Q234 425 242 461Q243 465 243 474ZM217 129Q185 174 154 235Q121 214 115 176Q113 168 113 143Q113 83 139 67Q141 66 152 66Q191 66 228 112L217 129"],39:[611,-287,525,175,349,"205 554Q205 577 221 594T263 611Q302 611 325 577T349 490Q349 409 298 347Q285 330 258 309T214 287Q203 289 189 302T175 327Q175 341 185 349T213 369T245 402Q269 437 273 483V497Q264 496 263 496Q240 496 223 513T205 554"],40:[694,82,525,166,437,"437 -53Q437 -82 399 -82H394Q377 -82 342 -55Q259 7 213 102T166 306Q166 412 211 507T342 667Q377 694 393 694H399Q437 694 437 665Q437 654 426 643T397 620T356 584T311 525Q301 511 290 488T264 412T250 306Q250 191 300 105T422 -27Q437 -37 437 -53"],41:[694,82,525,87,358,"87 664Q87 694 126 694Q138 694 147 690T183 667Q266 605 312 510T358 306Q358 193 307 93T161 -70Q142 -82 126 -82Q105 -82 96 -73T87 -53Q87 -47 88 -44Q92 -36 116 -19T173 34T230 119Q273 206 273 306Q273 408 231 494T109 635Q87 649 87 664"],42:[520,-89,525,68,456,"222 487Q224 501 235 510T262 520Q279 520 289 510T302 487Q302 458 301 429Q301 421 301 413T301 398T300 386T300 377V374Q300 373 301 373Q304 373 353 403T416 434Q432 434 444 423T456 393Q456 389 456 386T454 379T451 373T448 368T442 363T436 358T427 353T417 348T405 342T391 334Q345 309 339 305L388 279Q400 273 412 266T432 255T441 250Q456 238 456 218Q456 200 445 189T417 177Q403 177 354 207T301 238Q300 238 300 237V234Q300 231 300 226T300 214T301 199T301 182Q302 153 302 124Q300 109 289 100T262 90T235 100T222 124Q222 153 223 182Q223 190 223 198T223 213T224 225T224 234V237Q224 238 223 238Q220 238 171 208T108 177Q92 177 80 188T68 218Q68 237 79 246T134 277Q180 303 185 306L136 332Q124 338 112 345T92 356T83 361Q68 373 68 393Q68 411 79 422T107 434Q121 434 170 404T223 373Q224 373 224 374V377Q224 380 224 385T224 397T223 412T223 429Q222 458 222 487"],43:[531,-81,525,38,487,"147 271Q138 271 122 271T98 270Q68 270 53 277T38 306T53 335T98 342Q105 342 121 342T147 341H227V423L228 505Q241 531 262 531Q268 531 273 530T282 525T287 519T293 511L297 505V341H377H430Q457 341 467 338T483 321Q487 313 487 306Q487 295 480 286T463 273Q457 271 377 271H297V107Q281 81 262 81Q250 81 242 87T230 100L228 107L227 189V271H147"],44:[140,139,525,173,353,"193 37T193 70T213 121T260 140Q302 140 327 108T353 36Q353 -7 336 -43T294 -98T249 -128T215 -139Q204 -139 189 -125Q177 -111 174 -101Q172 -84 183 -77T217 -61T253 -33Q261 -24 272 1L265 0Q234 0 214 18"],45:[341,-271,525,57,468,"57 306Q57 333 86 341H438Q468 332 468 306T438 271H86Q57 280 57 306"],46:[140,-1,525,193,332,"193 70Q193 105 214 122T258 140Q291 140 311 120T332 70Q332 44 314 23T262 1Q234 1 214 18T193 70"],47:[694,83,525,58,466,"94 -83Q78 -83 68 -73T58 -48Q58 -44 60 -36Q62 -31 227 314T399 673Q410 694 431 694Q445 694 455 684T466 659Q466 656 464 648Q463 643 298 298T125 -62Q114 -83 94 -83"],48:[621,10,525,42,482,"42 305Q42 450 111 535T257 621Q335 621 390 562Q482 468 482 306Q482 174 418 82T262 -10T106 82T42 305ZM257 545Q209 545 168 481T126 320Q126 220 162 147Q204 65 262 65Q318 65 358 139T398 320V328Q395 411 364 470T284 543Q270 545 257 545"],49:[622,-1,525,99,450,"99 461Q99 470 99 474T104 487T120 498T151 502Q213 517 251 596Q264 622 283 622Q308 622 319 597V76H373H401Q428 76 439 69T450 38Q450 11 428 1H127Q104 10 104 38Q104 62 115 69T153 76H181H235V269Q235 461 234 461Q184 426 137 424H133Q124 424 119 425T109 431T99 447V461"],50:[622,-1,525,52,472,"52 462Q52 528 110 575T247 622H250Q343 622 407 565T472 421Q472 371 446 324T390 248T308 178Q307 177 275 151T214 101L185 77Q185 76 286 76H388V87Q388 105 397 114T430 123T463 114Q470 107 471 100T472 61V42Q472 24 468 16T450 1H75Q53 10 53 32V38V48Q53 57 63 67T127 122Q153 144 169 157L289 256Q388 345 388 419Q388 473 346 509T231 545H224Q176 545 146 499L144 494Q155 476 155 459Q154 459 155 455T154 444T148 430T136 417T114 408Q113 408 110 408T104 407Q80 407 66 422T52 462"],51:[622,11,525,44,479,"260 546Q233 546 211 541T180 531T171 524L174 514Q177 505 177 497Q177 476 162 461T125 446Q106 446 90 459T73 504Q76 540 98 565T150 601T203 616T239 621Q241 622 265 622Q322 620 362 602T420 558T444 513T451 478Q451 386 369 329L375 326Q381 323 386 320T401 311T419 298T436 283T452 263T466 240T475 212T479 180Q479 99 416 44T259 -11T105 28T44 130Q44 154 59 168T95 183Q117 183 132 169T148 131Q148 119 139 101Q175 65 260 65Q316 65 355 97T395 179Q395 211 375 240Q336 292 253 292H234H215Q194 292 185 299T175 330Q175 350 184 359Q192 368 238 370T309 384Q336 398 351 423T367 474Q367 496 350 513Q321 546 260 546"],52:[623,-1,525,29,495,"235 1Q213 10 213 32V38V46Q213 65 230 73Q236 76 274 76H314V168H183L52 169Q37 175 33 182T29 205V218L30 244Q53 283 155 443T264 613Q276 623 298 623H323H363Q378 616 385 601V244H429H450Q474 244 484 237T495 206Q495 179 477 171Q471 168 429 168H385V76H425H442Q466 76 476 69T487 38Q487 10 465 1H235ZM314 244V554L117 245L215 244H314"],53:[612,10,525,52,472,"387 189Q387 244 354 278T273 313Q230 313 205 301T163 271T138 249H120Q102 249 97 251Q85 258 83 266T80 311Q80 320 80 359T81 430Q81 587 82 591Q88 605 103 610H108Q112 610 120 610T138 610T163 610T192 611T225 611T260 611H415Q416 610 421 607T428 602T432 596T436 587T437 573Q437 567 437 562T434 554T431 548T427 543T423 540T418 538L415 536L289 535H164V363L170 366Q175 368 184 372T207 380T238 386T276 389Q357 389 414 331T472 187Q472 116 412 53T245 -10Q218 -10 209 -9Q126 5 89 48T52 137Q52 164 68 177T104 191Q130 191 143 175T156 141Q156 132 154 125T149 113T146 107Q146 104 155 95T188 76T245 65Q298 65 342 98T387 189"],54:[622,11,525,44,479,"357 536Q357 546 318 546Q258 546 205 497T133 357V353L144 361Q210 402 285 402Q362 402 414 350Q479 285 479 193Q479 111 418 50T263 -11Q234 -11 207 -3T149 26T97 81T60 171T45 301Q45 444 129 533T319 622Q388 622 421 589T454 510Q454 491 442 475T402 458Q373 458 362 475T350 510Q350 520 354 528L357 536ZM319 326T269 326T179 298T136 223Q136 202 143 174T176 112T237 68Q246 66 265 66Q319 66 360 107Q395 146 395 197Q395 250 356 289Q319 326 269 326"],55:[627,10,525,44,480,"204 -10Q162 -10 162 40Q162 146 198 261T310 477Q311 478 321 491T342 517T358 535H128V524Q128 506 119 497Q111 489 86 489H78Q55 489 46 508Q44 513 44 557V580Q44 605 52 616T88 627H93Q114 627 125 611H458Q474 598 477 593T480 573Q480 559 478 553T469 543T446 521T408 477Q252 290 246 49Q246 43 246 37T246 27T245 22Q243 11 233 1T204 -10"],56:[621,10,525,45,480,"58 460Q58 523 117 572T254 621Q290 621 298 620Q376 607 421 560T466 460Q466 441 460 424T443 393T421 370T397 352T374 340T357 332L350 330L356 328Q363 325 371 321T392 310T415 295T439 274T459 249T473 217T479 179Q479 102 418 46T262 -10T106 46T45 179Q45 202 52 222T70 257T96 284T123 305T148 319T167 328L174 330L170 332Q166 333 159 336T145 343Q104 362 81 393T58 460ZM382 458Q382 491 349 518T263 546Q215 546 179 521T142 458Q142 421 178 395T262 368Q315 368 348 396T382 458ZM396 178Q396 223 358 257T263 292Q206 292 167 258T128 178Q128 137 163 102T262 66Q324 66 360 101T396 178"],57:[622,11,525,46,479,"392 259Q333 210 236 210H233Q163 210 109 262Q46 325 46 411T99 550Q164 622 264 622Q293 622 319 615T376 587T428 532T464 440T479 304Q479 167 400 78T217 -11Q140 -11 105 22T70 101Q70 124 84 138T122 153Q150 153 162 137T174 101Q174 91 168 76Q179 65 216 65Q267 65 300 93Q322 109 339 130T366 173T380 210T388 242T392 259ZM388 389Q388 438 357 492T268 546T185 520Q129 479 129 415Q129 384 138 363Q145 349 156 334T195 302T255 285Q305 285 345 313T388 389"],58:[431,-1,525,193,332,"193 361Q193 396 214 413T258 431Q291 431 311 411T332 361Q332 335 314 314T262 292Q234 292 214 309T193 361ZM193 70Q193 105 214 122T258 140Q291 140 311 120T332 70Q332 44 314 23T262 1Q234 1 214 18T193 70"],59:[431,139,525,175,337,"193 361Q193 396 214 413T258 431Q291 431 311 411T332 361Q332 335 314 314T262 292Q234 292 214 309T193 361ZM193 70Q193 105 214 122T259 140Q301 140 319 108T337 33Q337 -38 291 -88T214 -139Q203 -139 189 -126T175 -97Q175 -85 182 -78T200 -66T225 -50T249 -17Q256 -3 256 0Q252 1 248 1Q242 2 235 5T218 15T200 36T193 70"],60:[557,-55,525,57,469,"468 90Q468 76 458 66T433 55Q426 55 419 58Q413 61 243 168T68 280Q57 291 57 306T68 332Q72 335 241 442T416 553Q424 557 432 557Q447 557 457 547T468 522T456 496Q454 494 305 399L158 306L305 213Q341 190 390 159Q443 125 452 119T464 106V105Q468 97 468 90"],61:[417,-195,525,38,487,"38 382Q38 409 67 417H457Q487 408 487 382Q487 358 461 348H64Q51 352 45 360T38 376V382ZM67 195Q38 204 38 230Q38 255 62 264Q66 265 264 265H461L464 264Q467 262 469 261T475 256T481 249T485 240T487 230Q487 204 457 195H67"],62:[557,-55,525,57,468,"57 522Q57 539 67 548T90 557Q98 557 105 554Q111 551 281 444T456 332Q468 320 468 306T456 280Q452 276 282 169T105 58Q98 55 91 55Q79 55 68 63T57 90Q57 105 68 116Q70 118 219 213L366 306L219 399Q75 491 71 494Q57 507 57 522"],63:[617,1,525,62,462,"62 493Q62 540 107 578T253 617Q366 617 414 578T462 490Q462 459 445 434T411 400L394 390Q315 347 296 287Q294 278 293 247V217Q285 201 278 198T246 194T216 197T201 215V245V253Q201 379 351 456Q366 464 375 477Q377 482 377 490Q377 517 339 528T251 540Q182 540 159 517Q166 503 166 490Q166 468 151 453T114 438Q96 438 79 451T62 493ZM190 58Q190 85 208 100T249 115Q272 113 288 99T304 58Q304 33 287 17T246 0T206 16T190 58"],64:[617,6,525,44,481,"44 306Q44 445 125 531T302 617Q332 617 358 607T411 574T456 502T479 387Q481 361 481 321Q481 203 421 143Q381 103 332 103Q266 103 225 165T183 307Q183 390 227 449T332 508Q358 508 378 498Q350 541 304 541Q229 541 172 473T115 305Q115 208 171 140T306 71H310Q358 71 397 105Q409 115 436 115Q458 115 462 113Q481 106 481 86Q481 73 468 61Q401 -6 305 -6Q262 -6 217 14T133 71T69 170T44 306ZM410 306Q410 361 386 396T333 431Q300 431 277 394T254 305Q254 256 276 218T332 180Q364 180 387 217T410 306"],65:[623,-1,525,28,496,"191 76Q212 75 220 68T229 38Q229 10 208 1H129H80Q48 1 38 7T28 38Q28 51 29 57T40 69T70 76Q89 76 89 78Q90 79 117 205T173 461T205 599Q212 623 250 623H262H273Q312 623 319 599Q322 591 350 461T406 205T435 78Q435 76 454 76H458Q484 76 493 59Q496 53 496 38Q496 11 478 3Q474 1 395 1H317Q295 8 295 38Q295 65 311 73Q316 75 333 76L348 77V78Q348 80 341 112L334 143H190L183 112Q176 80 176 78Q175 76 178 76Q180 76 191 76ZM318 221Q313 238 288 366T263 519Q263 526 262 527Q261 527 261 520Q261 493 236 365T206 221Q206 219 262 219T318 221"],66:[611,-1,525,17,482,"39 1Q17 10 17 32V38V46Q17 65 34 73Q40 76 61 76H84V535H61H54Q27 535 19 553Q17 557 17 573Q17 583 17 587T23 599T39 610Q40 611 179 611Q320 610 332 607Q332 607 339 605Q394 591 427 547T461 454Q461 413 436 378T369 325L358 320Q405 311 443 270T482 169Q482 112 445 64T345 3L334 1H39ZM309 533Q302 535 234 535H168V356H230Q284 357 296 358T323 368Q346 380 361 402T377 452Q377 482 358 505T309 533ZM398 176Q396 218 371 246T315 279Q310 280 237 280H168V76H239Q316 77 327 81Q329 82 334 84Q398 107 398 176"],67:[622,11,525,40,485,"40 305Q40 437 110 529T281 622Q315 622 343 611T387 589T404 578Q409 585 415 596T425 611T435 618T452 622Q472 622 478 609T485 566Q485 559 485 540T484 508V460Q484 413 478 403T442 393Q417 393 409 402Q400 409 400 420Q400 428 395 445T380 487T347 528T295 546Q235 546 180 483T124 306Q124 245 141 197T186 121T241 80T296 66Q346 66 373 103T400 178Q400 209 435 209H442H450Q484 209 484 172Q480 96 421 43T281 -11Q177 -11 109 84T40 305"],68:[612,-1,525,16,485,"38 1Q16 8 16 38Q16 62 32 73Q39 76 58 76H78V535H58Q40 535 32 538Q16 548 16 573Q16 587 17 591Q23 604 34 607T83 611H166H176Q188 611 209 611T239 612Q299 612 337 597T415 530Q485 438 485 300Q485 180 431 100T301 3L291 1H38ZM400 301Q400 363 385 410T346 482T303 519T267 534Q261 535 210 535H162V76H214L267 77Q323 89 361 148T400 301"],69:[612,-1,525,18,502,"374 271Q374 241 367 232T332 223Q307 223 299 231Q290 240 290 263V279H173V76H418V118V144Q418 167 426 176T460 186Q491 186 500 166Q502 161 502 93V52Q502 25 499 17T480 1H41Q19 9 19 32V38Q19 63 36 73Q42 76 65 76H89V535H65H55Q44 535 38 537T25 548T19 573Q19 602 41 610H47Q53 610 63 610T88 610T121 610T160 611T204 611T251 611H458Q460 609 465 606T471 602T475 598T478 593T479 586T480 576T480 562V526V488Q480 452 462 444Q458 442 438 442Q413 442 405 450Q398 457 397 463T396 501V535H173V355H290V371Q290 394 299 403T332 412Q363 412 372 392Q374 387 374 317V271"],70:[612,-1,525,22,490,"384 260Q384 230 377 221T342 212Q317 212 309 220Q300 229 300 252V268H179V76H249Q264 67 267 61T271 38Q271 10 249 1H44Q22 9 22 32V38Q22 63 39 73Q45 76 69 76H95V535H69H59Q42 535 32 542T22 573Q22 602 44 610H50Q56 610 66 610T91 610T125 610T164 611T208 611T257 611H468Q470 609 475 606T481 602T485 598T488 593T489 586T490 576T490 562V526V488Q490 452 472 444Q468 442 448 442Q423 442 415 450Q408 457 407 463T406 501V535H179V344H300V360Q300 383 309 392T342 401Q373 401 382 381Q384 376 384 306V260"],71:[623,11,525,38,496,"38 306Q38 447 105 534T261 622Q280 622 298 618T329 608T350 596T366 585L371 581Q373 581 377 591T390 612T417 622Q437 622 443 609T450 566Q450 559 450 540T449 508V460Q449 413 443 403T407 393Q392 393 386 394T373 402T364 426Q360 472 335 509T271 546Q214 546 168 477T121 308Q121 210 164 138T271 65Q293 65 310 78T337 109T352 147T360 180T362 195Q362 196 333 196L304 197Q282 204 282 227V234Q282 247 282 251T288 261T304 272H474Q488 263 492 256T496 234Q496 211 479 199Q475 197 461 196H449V21Q441 6 434 3T412 -1H407H402Q385 -1 379 3T364 28Q350 14 322 2T260 -11Q173 -11 106 76T38 306"],72:[611,-1,525,16,508,"16 571Q16 597 27 604T74 611H125H208Q223 602 226 596T230 573Q230 559 227 551T217 540T204 536T186 535H165V356H359V535H338H333Q306 535 297 552Q295 556 295 573Q295 586 295 590T301 600T317 611H486Q501 602 504 596T508 573Q508 559 505 551T495 540T482 536T464 535H443V76H464H470Q482 76 489 75T502 64T508 38Q508 10 486 1H317Q306 5 301 11T296 21T295 38V44Q295 66 311 73Q318 76 338 76H359V280H165V76H186H192Q204 76 211 75T224 64T230 38Q230 10 208 1H39Q28 5 23 11T18 21T17 38V44Q17 66 33 73Q40 76 60 76H81V535H60Q45 535 38 536T24 545T16 571"],73:[611,-1,525,72,452,"400 76Q431 76 441 69T452 38Q452 29 452 26T450 18T443 9T430 1H95Q84 6 79 12T73 23T72 38Q72 65 90 73Q96 76 157 76H220V535H157H124Q93 535 83 542T72 573Q72 603 93 610Q97 611 264 611H430Q432 609 436 607T444 602T449 594Q452 588 452 573Q452 546 434 538Q428 535 367 535H304V76H367H400"],74:[612,11,525,57,479,"202 543T202 573T224 610H228Q231 610 237 610T251 610T269 610T291 611T315 611T342 611H457Q471 602 475 595T479 573Q479 549 462 538Q454 535 432 535H408V328Q408 159 408 133T402 93Q386 48 340 19T229 -11Q158 -11 108 16T57 100Q57 129 73 141T108 154Q128 154 143 140T159 102Q159 93 155 79Q188 65 228 65H230Q290 65 318 106Q323 115 323 139T324 329V535H274L224 536Q202 543 202 573"],75:[611,-1,525,18,495,"18 549T18 573T29 604T70 611H118H193Q207 603 210 596T214 573Q214 549 198 538Q191 535 172 535H152V421Q152 344 152 326T153 309L242 422L329 534Q327 535 322 536T314 538T308 542T303 548T300 558T298 573Q298 600 316 608Q322 611 392 611H463Q477 602 481 595T485 573Q485 535 446 535H441H420L281 357L436 77L454 76Q473 75 478 73Q495 62 495 38Q495 10 473 1H345Q334 5 329 11T324 21T323 38Q323 51 324 56T332 68T355 77L233 296L152 192V76H172Q191 76 198 73Q214 63 214 38Q214 9 193 1H41Q18 8 18 38Q18 61 35 73Q42 76 61 76H81V535H61Q42 535 35 538Q18 549 18 573"],76:[611,0,525,25,488,"27 594Q34 605 43 608T84 611H154H213Q258 611 269 605T281 573Q281 546 263 538Q257 535 222 535H185V76H404V118V145Q404 168 411 177T446 186H453Q478 186 486 167Q488 161 488 93V50Q488 24 485 17T466 1L258 0H147H99Q47 0 36 6T25 38Q25 59 35 69Q44 76 76 76H101V535H76H64Q36 535 27 552Q25 557 25 573T27 594"],77:[611,-1,525,11,512,"50 535Q37 536 31 537T18 547T12 573Q12 598 22 604T62 611H91H121Q147 611 158 607T178 587Q183 579 222 446T261 293Q261 289 262 288Q263 288 263 292Q263 311 298 434T346 588Q353 603 365 607T402 611H435H450Q488 611 500 605T512 573Q512 556 506 547T493 537T474 535H459V76H474Q487 75 493 74T505 64T512 38Q512 11 494 3Q490 1 424 1H386Q355 1 345 7T335 38Q335 55 341 64T354 74T373 76H388V302Q388 512 387 519Q382 482 346 359T304 228Q292 204 262 204T220 228Q215 237 179 359T137 519Q136 512 136 302V76H151Q164 75 170 74T182 64T189 38Q189 11 171 3Q167 1 101 1H63Q32 1 22 7T12 38Q12 55 18 64T31 74T50 76H65V535H50"],78:[611,0,525,20,504,"20 571Q20 598 30 604T73 611H105H136Q152 611 160 611T177 607T189 601T198 587T206 568T217 537T231 497Q354 142 365 95L368 84V535H347H342Q314 535 306 552Q304 556 304 573Q304 586 304 590T310 600T326 611H482Q497 602 500 596T504 573Q504 559 501 551T491 540T478 536T460 535H439V25Q432 7 424 4T389 0H374Q334 0 322 31L293 115Q171 468 159 517L156 528V76H177H183Q195 76 202 75T215 64T221 38Q221 10 199 1H43Q32 5 27 11T22 21T21 38V44Q21 66 37 73Q44 76 64 76H85V535H64Q49 535 42 536T28 545T20 571"],79:[621,10,525,56,468,"102 588Q140 621 240 621Q323 621 335 620Q393 613 422 588Q450 560 459 493T468 306Q468 185 460 118T422 23Q382 -10 289 -10H262H235Q142 -10 102 23Q74 50 65 118T56 306Q56 427 64 494T102 588ZM363 513Q357 523 347 530T324 540T302 544T280 546H268Q192 546 167 521Q150 501 145 452T140 300Q140 235 142 197T151 130T172 89T207 71T262 65Q317 65 341 81T374 144T384 300Q384 474 363 513"],80:[612,-1,525,19,480,"41 1Q19 9 19 32V38Q19 63 36 73Q42 76 65 76H89V535H65H55Q38 535 29 543T19 576Q19 603 41 610H49Q57 610 70 610T100 610T136 611T175 611Q190 611 216 611T255 612Q321 612 363 598T441 537Q480 486 480 427V421Q480 354 447 311T378 251Q339 230 275 230H239H173V76H197Q220 76 227 73Q244 62 244 38Q244 10 222 1H41ZM396 421Q396 461 369 491T300 533Q294 534 233 535H173V306H233Q294 307 300 308Q345 319 370 352T396 421"],81:[622,138,525,56,468,"56 306Q56 380 58 426T68 510T87 568T120 600T170 617T240 621Q323 621 335 620Q393 613 422 588Q450 560 459 493T468 306Q468 124 447 66Q433 23 394 6L424 -53Q454 -112 454 -118Q454 -128 441 -138H377Q367 -135 363 -129T333 -69L304 -11H254Q205 -10 180 -8T128 6T91 36T70 92T58 178T56 306ZM227 151Q227 171 262 171H276H281Q292 171 296 171T305 170T313 165T317 158T323 145T332 127L353 88Q356 88 361 95T372 131T382 202Q384 228 384 306Q384 452 371 492T304 544Q296 545 251 545Q230 545 215 543T188 534T169 520T155 497T147 466T143 423T141 371T140 306Q140 248 141 217T146 154T157 109T178 83T212 68T262 65H266L264 70Q261 75 256 85T247 105Q227 145 227 151"],82:[612,11,525,16,522,"16 571Q16 598 27 605T76 612Q84 612 108 612T148 611Q268 611 294 605Q346 592 389 550T432 440Q432 394 410 359Q393 329 366 310L358 303Q387 273 399 239Q405 219 405 178T408 106T421 68Q426 65 428 65Q433 65 435 74T438 96T441 112Q450 130 480 130H485Q519 130 522 100Q522 79 516 56T488 11T434 -11Q421 -11 408 -8T377 5T344 37T324 93Q322 101 322 154L321 209Q304 257 257 267Q252 268 207 268H165V76H186H192Q204 76 211 75T224 64T230 38Q230 10 208 1H39Q28 5 23 11T18 21T17 38V44Q17 66 33 73Q40 76 60 76H81V535H60Q45 535 38 536T24 545T16 571ZM348 440Q348 478 321 502T260 532Q252 534 208 535H165V344H208Q212 344 223 344T239 345T252 346T266 348T278 351T293 358Q348 387 348 440"],83:[622,11,525,51,472,"52 454Q52 524 107 572T229 621Q266 621 274 620Q326 610 360 588L371 581Q377 594 379 598T386 610T397 619T412 622Q433 622 439 610T446 570Q446 563 446 545T445 515V479Q445 441 444 432T436 417Q428 408 403 408T370 417Q361 424 361 434Q361 439 360 448T351 476T331 509T295 535T238 546Q194 546 163 522T132 458Q132 435 148 412Q155 401 166 393T192 380T218 371T247 364T270 359Q341 342 349 339Q389 325 418 296T461 229Q472 201 472 164Q469 92 417 41T287 -11Q240 -11 200 -1T143 19L126 29Q117 6 109 -2Q100 -11 84 -11Q64 -11 58 1T51 42Q51 49 51 66T52 95V135Q52 173 53 180T61 194Q70 203 95 203Q119 203 127 194Q136 186 136 168Q143 66 284 66H290Q325 66 350 85Q391 115 391 165Q391 204 369 228T322 260Q320 260 255 275T185 293Q123 309 88 355T52 454"],84:[612,-1,525,26,498,"129 38Q129 51 129 55T135 65T151 76H220V535H110V501Q110 470 109 464T101 450Q93 442 68 442H60Q37 442 28 461Q26 466 26 527L27 589Q36 607 49 610H55Q61 610 72 610T97 610T131 610T170 611T215 611T264 611H476Q478 609 483 606T489 602T493 598T496 593T497 586T498 576T498 562V526V488Q498 452 480 444Q476 442 456 442Q431 442 423 450Q416 457 415 463T414 501V535H304V76H374Q389 67 392 61T396 38Q396 10 374 1H151Q140 5 135 11T130 21T129 38"],85:[612,11,525,-4,528,"-3 573Q-3 597 8 604T50 612Q57 612 77 612T111 611H200Q214 602 218 595T222 573Q222 549 205 538Q198 535 175 535H151V359Q151 333 151 291Q152 177 156 162Q157 160 157 159Q165 123 193 95T262 66Q303 66 330 94T367 159Q371 175 371 191T373 359V535H349H339Q328 535 322 537T309 548T303 573T306 595T325 611H506Q520 602 524 595T528 573Q528 549 511 538Q504 535 481 535H457V364Q457 189 456 182Q448 101 394 45T262 -11Q189 -11 132 43T68 182Q67 189 67 364V535H43H33Q22 535 16 537T3 548T-3 573"],86:[613,7,525,19,505,"19 578Q19 585 20 590T23 598T29 604T38 608T48 610T62 611T78 612T97 611T119 611H195Q210 602 213 596T217 573Q217 561 216 555T206 542T179 535H164Q166 529 188 435T235 231T261 94L262 84V88Q263 91 263 94Q265 121 289 231T336 438L360 535H345Q308 535 308 566V573Q308 586 308 590T314 600T330 611H484Q499 602 502 595T505 573Q505 560 504 554T493 541T465 535H447L384 278Q321 19 319 14Q309 -7 278 -7H262H246Q215 -7 205 14Q203 19 140 278L78 535H59Q45 535 38 536T25 547T19 573V578"],87:[611,7,525,12,512,"459 611Q491 611 501 605T512 573Q512 538 482 535H474L439 276Q406 26 402 11Q398 2 389 -3Q387 -3 386 -4L380 -7H359H349Q324 -7 313 13Q307 29 285 139T263 275Q263 283 262 283Q261 282 261 274Q261 248 239 137T211 13Q200 -7 175 -7H165H144Q136 -3 127 3Q121 10 117 36T85 276L50 535H42Q26 536 19 545T12 564V573Q12 603 33 610Q37 611 101 611H134Q165 611 175 604T186 573Q186 563 186 559T182 547T169 538T143 535H122V531Q124 517 133 446T155 266T172 96V84L173 102Q176 157 192 243T215 346Q227 367 259 367H262H265Q297 367 309 346Q316 329 332 243T351 102L352 84V96Q356 161 368 266T390 444T402 531V535H381Q366 535 359 536T345 547T338 573Q338 600 356 608Q362 611 425 611H459"],88:[611,-1,525,28,495,"39 571Q39 597 49 604T93 611H141H218Q233 602 236 595T239 573Q239 538 210 535Q202 535 202 534T215 507T243 454L257 428L307 535H298Q266 538 266 573Q266 584 267 588T273 598T289 611H366H401Q442 611 454 605T466 573Q466 546 448 538Q442 535 421 535H398L299 327Q299 323 362 201L426 77L449 76Q467 76 475 75T489 65T495 38Q495 11 477 3Q473 1 395 1H317Q295 8 295 38Q295 73 325 76L334 77Q333 78 314 117T276 196L257 235L239 196Q221 157 204 118T186 77Q190 76 196 76Q211 74 218 67T227 55T228 38Q228 28 227 24T221 13T206 1H50Q28 9 28 32V38Q28 63 45 73Q51 76 73 76H96L214 324Q215 327 162 431L108 535H85H79Q67 535 60 536T46 546T39 571"],89:[611,-1,525,20,505,"20 573Q20 597 30 604T72 611H121H198Q212 602 216 595T220 573Q220 568 219 563T217 555T214 549T211 544T207 541T203 538T198 537T194 536T190 536L188 535Q179 535 179 534L188 516Q196 497 208 470T232 415T252 363T261 332Q261 329 262 329T263 332Q263 354 333 508L345 534Q345 535 336 535Q305 538 305 567V573Q305 589 308 595T327 611H483Q505 598 505 573Q505 549 488 538Q481 535 460 535H438L304 245V76H325H331Q343 76 350 75T363 64T369 38Q369 10 347 1H178Q167 5 162 11T157 21T156 38V44Q156 66 172 73Q180 76 199 76H220V245L86 535H64Q44 535 36 538Q20 548 20 573"],90:[612,-1,525,48,481,"71 1Q60 5 55 11T49 23T48 39V46Q48 56 58 73T131 183Q171 242 197 282L366 535H144V501Q144 470 143 464T135 450Q127 442 102 442H94Q71 442 62 461Q60 466 60 527L61 589Q70 607 83 610H88Q93 610 102 610T124 610T154 610T188 611T227 611T270 611H454Q456 609 461 606T467 601T471 597T474 591T475 584T476 572V565Q476 555 466 538T393 428Q353 369 327 329L158 76H397V120V146Q397 169 405 179T439 189Q470 189 479 169Q481 164 481 95V48Q481 24 478 16T459 1H71"],91:[694,82,525,214,484,"237 -82Q221 -78 214 -58V305Q214 669 216 673Q220 687 231 690T278 694H350H461Q462 693 467 690T474 685T478 679T482 670T483 656Q483 632 471 625T428 617Q422 617 406 617T379 618H298V-7H379H420Q459 -7 471 -13T483 -45Q483 -55 483 -59T477 -70T461 -82H237"],92:[694,83,525,58,466,"58 659Q58 673 68 683T93 694Q114 694 125 673Q132 659 297 314T464 -36Q466 -44 466 -48Q466 -66 454 -74T431 -83Q410 -83 399 -62Q391 -47 226 298T60 648Q58 656 58 659"],93:[695,82,525,41,310,"41 656Q41 681 53 688T99 695Q107 695 133 695T177 694H288Q307 681 310 669V-58Q303 -76 288 -82H64Q41 -73 41 -45Q41 -21 53 -14T96 -6Q102 -6 118 -6T145 -7H226V618H145H100Q67 618 54 625T41 656"],94:[611,-460,525,96,428,"138 460Q121 460 109 479T96 512Q96 527 106 534Q109 536 178 571T253 609Q256 611 264 611Q272 610 343 574Q357 567 369 561T389 550T402 543T411 538T416 535T420 532T422 529T425 525Q428 518 428 512Q428 498 416 479T386 460H384Q377 460 316 496L262 526L208 496Q147 460 138 460"],95:[-25,95,525,57,468,"57 -60Q57 -33 86 -25H438Q468 -34 468 -60T438 -95H86Q57 -86 57 -60"],96:[681,-357,525,176,350,"176 479Q176 563 227 622T310 681Q324 680 337 667T350 641Q350 627 340 619T312 599T280 566Q256 531 252 485V471Q261 472 262 472Q285 472 302 455T320 414Q320 389 303 373T261 357Q223 357 200 391T176 479"],97:[439,6,525,48,524,"126 306Q105 306 90 321T74 359Q74 439 211 439Q268 439 276 438Q343 426 383 390T430 306Q431 301 431 190V81Q446 79 465 78T492 76T509 72T521 60T524 38Q524 11 506 3Q502 1 466 1Q426 1 406 5T379 14T355 36L345 30Q284 -6 205 -6Q135 -6 92 39T48 141Q48 182 79 212T158 256T252 278T342 285H347V290Q347 315 325 335T267 362Q258 363 224 363Q189 363 185 362H179L178 358Q178 353 178 352T176 345T174 337T170 330T165 322T158 316T150 311T139 308T126 306ZM132 140Q132 115 157 93T224 70Q269 70 302 87T344 133Q346 139 347 175V211H339Q256 209 194 190T132 140"],98:[611,6,525,4,492,"4 573Q4 596 15 603T52 611H90H124Q146 611 155 608T171 591Q173 586 173 491V396L182 402Q217 424 256 431Q280 437 309 437Q376 437 434 379T492 217Q492 162 473 118T422 47T358 8T293 -6Q229 -6 174 38Q171 13 163 7T135 1H131H122Q99 1 90 23L89 279V535H58L27 536Q4 543 4 573ZM409 215Q409 269 377 315T283 361Q255 361 224 344T177 297L173 290V167Q189 124 213 97T278 70Q330 70 369 111T409 215"],99:[440,6,525,66,466,"291 -6Q196 -6 131 60T66 216Q66 296 119 361Q154 403 200 421T273 439Q275 440 293 440H313Q400 440 433 409Q454 388 454 359Q454 335 439 321T402 306Q380 306 365 321T350 357V362L340 363Q339 363 326 363T303 364Q280 364 266 362Q217 352 184 313T151 215Q151 153 199 112T313 70Q341 70 357 85T381 118T394 140Q402 146 424 146Q443 146 447 144Q466 137 466 117Q466 106 457 88T429 47T374 10T291 -6"],100:[611,6,525,31,520,"266 573Q266 596 277 603T314 611H352H385Q411 611 419 607T435 586V76H498Q512 67 516 60T520 38Q520 9 498 1H436Q429 1 417 1T398 0Q375 0 363 7T351 34V43L342 36Q288 -6 223 -6Q143 -6 87 58T31 216Q31 307 88 372T230 437Q292 437 342 405L351 399V535H320L289 536Q266 543 266 573ZM351 290Q347 302 337 316T302 346T244 361Q193 361 154 319T115 215Q115 152 152 111T235 70Q314 70 351 170V290"],101:[440,6,525,48,465,"48 217Q48 295 100 361T248 439L258 440Q268 440 274 440Q329 438 369 416T428 359T456 292T464 228Q464 215 461 208T454 198T442 190L288 189H135L138 179Q153 132 199 102T303 71Q336 71 353 86T380 120T398 143Q404 146 422 146Q453 146 462 126Q464 120 464 116Q464 84 416 39T285 -6Q187 -6 118 59T48 217ZM377 264Q371 291 365 306T341 338T294 362Q288 363 264 363Q225 363 190 336T139 264H377"],102:[617,-1,525,35,437,"43 395Q44 405 44 408T47 416T53 423T66 431H176V461Q176 500 182 518Q201 570 252 593T353 617Q399 614 418 593T437 548Q437 528 424 514T387 499Q365 499 353 511T338 537V541H328Q275 536 261 494Q260 490 260 460V431H327Q334 431 346 431T364 432Q392 432 404 425T416 393T405 362T365 355H327H260V76H319Q375 76 388 71T401 38Q401 27 400 23T395 12T379 1H58Q47 6 42 12T36 23T35 38Q35 65 53 73Q59 76 117 76H176V355H121H93Q64 355 54 362T43 395"],103:[442,229,525,28,510,"60 274Q60 337 107 386T233 436Q278 436 316 417L329 410L338 416Q384 442 427 442T489 423T509 381T494 345T460 332Q449 332 440 338Q432 341 427 348T419 360T415 365Q414 364 410 364L383 355Q406 320 406 274Q406 211 358 162T233 112Q189 112 155 128L146 133Q142 125 142 115Q142 99 150 85T175 71Q182 72 187 70Q188 70 195 70T218 70T254 69Q259 69 275 69T297 69T318 68T340 66T361 62T384 57T405 49T428 38Q495 -1 495 -76Q495 -143 427 -186T262 -229Q161 -229 94 -185T29 -73Q30 -60 33 -48T39 -26T47 -8T57 8T67 20T77 30T86 38L91 43Q91 44 86 53T75 80T70 117Q70 142 89 183L83 194Q60 232 60 274ZM321 274Q321 312 296 337T230 362Q197 362 171 338T145 274Q145 235 170 211T233 187Q273 187 297 212T321 274ZM422 -78Q422 -54 408 -38T366 -15T315 -6T255 -4H200Q198 -4 193 -4T183 -3Q148 -3 125 -26T102 -78Q102 -110 151 -132T261 -154Q321 -154 371 -132T422 -78"],104:[611,-1,525,4,520,"4 573Q4 596 15 603T52 611H90H124Q146 611 155 608T171 591Q173 586 173 489Q173 394 175 394L186 402Q197 410 219 420T269 434Q278 436 306 436Q343 436 371 423Q411 402 423 365T436 265Q436 257 436 239T435 211V198V76H498Q512 67 516 60T520 38Q520 9 498 1H308Q286 10 286 32V38V46Q286 65 303 73Q309 76 329 76H351V188Q351 204 351 230T352 266Q352 321 341 341T288 361Q253 361 222 341T176 274L174 264L173 170V76H236Q250 67 254 60T258 38Q258 9 236 1H27Q4 8 4 38Q4 53 8 60T27 76H89V535H58L27 536Q4 543 4 573"],105:[612,-1,525,72,462,"202 538T202 559T218 596T260 612Q283 612 300 597T317 560Q317 538 300 523T260 507Q235 507 219 522ZM411 76Q441 76 451 69T462 38Q462 29 462 26T460 18T453 9T440 1H94Q72 8 72 33V38Q72 46 72 49T74 58T81 68T94 76H233V355H167L102 356Q80 363 80 393Q80 418 91 425T138 432Q145 432 165 432T200 431H295Q297 429 303 425T310 420T314 415T317 404T317 389T318 363Q318 354 318 314T317 241V76H378H411"],106:[612,228,525,48,377,"261 559Q261 580 277 596T319 612Q342 612 359 597T376 560T360 523T320 507Q296 507 279 523T261 559ZM75 -91T100 -91T138 -107T152 -144V-150L160 -151H193H203Q241 -151 267 -121Q284 -97 288 -73T292 23V151V355H218L145 356Q123 365 123 387V393Q123 422 145 430H148Q151 430 156 430T169 430T185 430T205 431T227 431T251 431H354Q356 430 360 427T365 424T369 420T372 416T373 410T375 402T376 391T377 376T377 356Q377 345 377 286T376 176Q376 -67 371 -88Q362 -123 342 -151T299 -194Q254 -228 180 -228Q84 -226 56 -177Q49 -162 48 -148Q48 -122 61 -107"],107:[611,0,525,13,507,"13 42Q13 63 23 69T69 76H102V535H69H54Q34 535 24 542T13 573Q13 588 15 593Q22 605 29 608T56 611H95Q113 611 122 611T140 610T152 609T159 607T163 603T167 597T173 589V413L174 237L295 355H275Q260 355 253 356T239 367T232 393Q232 419 243 425T304 431H359H464Q479 422 482 415T485 393Q485 364 464 356L431 355H398L293 254L427 76H486Q501 67 504 60T507 38Q507 28 507 24T501 12T486 1H314Q292 8 292 38Q292 62 308 73Q312 75 326 76L338 77L290 140Q279 154 267 171T248 196L242 204L207 171L173 139V76H206H221Q241 76 251 69T262 38Q262 11 244 3Q240 1 138 1Q123 1 100 1T70 0Q32 0 23 7T13 42"],108:[612,-1,525,51,474,"51 573Q51 602 73 610H76Q79 610 84 610T97 610T113 610T133 611T155 611T179 611H282Q301 598 304 586V76H452Q466 67 470 60T474 38Q474 10 452 1H73Q51 9 51 32V38Q51 54 54 60T73 76H220V535H146L73 536Q51 545 51 567V573"],109:[437,-1,525,-12,536,"133 76Q156 74 164 67T172 38Q172 9 151 1H11Q-12 8 -12 38Q-12 61 5 73Q10 75 28 76H45V355H28Q10 356 5 358Q-12 370 -12 393Q-12 419 11 431H52H70Q91 431 100 427T116 405Q163 436 200 436Q255 436 281 390L285 394Q289 398 292 400T301 407T314 415T329 423T346 429T366 434T389 436H392Q425 436 448 411Q469 390 474 360T480 268V232V203V76H497Q520 74 528 67T536 38Q536 9 515 1H396Q374 9 374 32V38Q374 73 402 76H409V191V242Q409 317 404 339T375 361Q343 361 323 332T299 264Q298 258 298 165V76H315Q338 74 346 67T354 38Q354 9 333 1H214Q192 9 192 32V38Q192 73 220 76H227V191V242Q227 317 222 339T193 361Q161 361 141 332T117 264Q116 258 116 165V76H133"],110:[436,-1,525,4,520,"89 431Q94 431 105 431T122 432Q173 432 173 399Q173 394 175 394Q176 394 190 404T233 425T298 436Q343 436 371 423Q411 402 423 365T436 265Q436 257 436 239T435 211V198V76H498Q512 67 516 60T520 38Q520 9 498 1H308Q286 9 286 32V38V45Q286 65 303 73Q309 76 329 76H351V188Q351 204 351 230T352 266Q352 321 341 341T288 361Q253 361 222 341T176 274L174 264L173 170V76H236Q250 67 254 60T258 38Q258 9 236 1H27Q4 8 4 38Q4 53 8 60T27 76H89V355H58L27 356Q4 363 4 393Q4 408 8 415T27 431H89"],111:[440,6,525,52,472,"52 216Q52 318 118 379T261 440Q343 440 407 378T472 216Q472 121 410 58T262 -6Q176 -6 114 58T52 216ZM388 225Q388 281 351 322T261 364Q213 364 175 325T136 225Q136 158 174 114T262 70T350 114T388 225"],112:[437,221,525,4,492,"89 431Q93 431 104 431T121 432Q173 432 173 401V396L182 402Q237 437 305 437Q376 437 434 378T492 217Q492 146 459 93T382 17T291 -6Q261 -6 232 5T188 26L174 37Q173 37 173 -54V-146H236Q250 -155 254 -162T258 -184Q258 -213 236 -221H27Q4 -214 4 -184Q4 -169 8 -162T27 -146H89V355H58L27 356Q4 363 4 393Q4 408 8 415T27 431H89ZM409 215Q409 269 377 315T283 361Q255 361 224 344T177 297L173 290V167Q189 124 213 97T278 70Q330 70 369 111T409 215"],113:[437,222,525,34,545,"34 215Q34 309 91 368T222 436Q224 436 231 436T242 437Q309 437 372 390V401Q372 419 381 428T414 437Q426 437 432 436T444 430T456 412V-146H489H504Q524 -146 534 -153T545 -184Q545 -211 527 -219Q523 -221 414 -221Q398 -221 374 -221T342 -222Q304 -222 294 -216T283 -184Q283 -157 301 -149Q307 -146 339 -146H372V-51Q372 43 371 43L364 38Q357 33 345 26T318 12T280 -1T236 -6Q155 -6 95 55T34 215ZM117 215Q117 152 157 111T250 70Q289 70 318 92T363 146Q372 163 372 192V215L371 263Q339 360 254 360Q206 360 162 321T117 215"],114:[437,-1,525,24,487,"327 76Q359 76 369 70T380 38Q380 10 359 1H47Q24 8 24 38Q24 54 28 61T47 76H145V355H96L47 356Q24 363 24 393Q24 409 28 416T47 431H207Q223 419 226 414T229 393V387V369Q297 437 394 437Q436 437 461 417T487 368Q487 347 473 332T438 317Q428 317 420 320T407 327T398 337T393 347T390 356L388 361Q348 356 324 345Q228 299 228 170Q228 161 228 151T229 138V76H293H327"],115:[440,6,525,71,458,"72 317Q72 361 108 396T229 439Q231 439 245 439T268 440Q303 439 324 435T353 427T363 423L372 432Q380 440 397 440Q430 440 430 395Q430 390 430 380T429 366V335Q429 311 422 302T387 293Q364 293 355 300T346 316T343 336T325 353Q306 364 257 364Q209 364 178 351T147 317Q147 284 231 272Q327 256 357 247Q458 210 458 129V121Q458 74 413 34T271 -6Q246 -6 224 -3T189 5T165 14T150 22T144 26Q142 23 139 18T135 11T132 6T128 1T124 -2T119 -4T113 -5T104 -6Q84 -6 78 6T71 43Q71 48 71 60T72 79Q72 132 73 141T81 157Q90 166 115 166Q135 166 142 162T157 140Q168 108 191 90T260 70Q297 70 323 76T361 91T379 110T384 129Q384 157 346 171T247 195T165 212Q119 228 96 256T72 317"],116:[554,6,525,25,448,"25 395Q26 405 26 408T29 416T35 423T48 431H145V481L146 532Q154 547 161 550T184 554H189Q218 554 227 534Q229 529 229 480V431H405Q406 430 411 427T418 422T422 416T426 407T427 393Q427 387 427 382T424 374T421 368T417 363T413 360T408 358L405 356L317 355H229V249Q229 237 229 214T228 179Q228 126 241 98T295 70Q354 70 365 149Q366 167 375 174Q383 182 407 182H415Q438 182 446 166Q448 161 448 148Q448 84 398 39T282 -6Q226 -6 189 29T146 128Q145 134 145 247V355H96H72Q45 355 35 362T25 395"],117:[431,5,525,4,520,"4 393Q4 416 15 423T52 431H90Q141 431 151 429T168 417Q171 412 173 409V254L174 100Q182 70 244 70Q320 70 344 119Q349 130 350 144T351 248V355H320L289 356Q266 363 266 393Q266 408 270 415T289 431H351H386Q409 431 418 428T433 411Q435 406 435 241V76H498Q512 67 516 60T520 38Q520 9 498 1H436H394Q372 1 364 5T351 26L342 21Q293 -5 227 -5Q118 -5 96 67Q91 82 90 101T89 227V355H58L27 356Q4 363 4 393"],118:[432,4,525,24,500,"24 392Q24 417 36 424T79 432Q85 432 103 432T132 431H215Q229 422 233 415T237 393Q237 355 198 355H193H172L262 77L352 355H331H323Q288 355 288 393Q288 409 291 415T310 431H478Q491 423 495 416T500 393Q500 364 478 356L452 355H426L374 190Q320 24 318 20Q307 -4 273 -4H262H251Q217 -4 206 20Q204 24 150 190L98 355H72L47 356Q24 363 24 392"],119:[431,4,525,16,508,"54 355Q16 355 16 388V393Q16 423 37 430Q41 431 125 431H162Q206 431 218 425T230 393Q230 366 212 358Q206 355 174 355Q141 355 141 354L150 296Q181 110 181 89V84Q182 85 183 96Q185 118 199 173T218 237Q223 247 245 259H264H268Q294 259 309 240Q315 229 329 174T343 92Q343 84 344 84V86Q344 88 344 91T345 97Q347 125 356 187T374 301T383 354Q383 355 350 355H333Q314 355 304 362T294 393Q294 420 312 428Q318 431 401 431H440Q485 431 496 425T508 393Q508 382 508 377T498 363T470 355L455 354Q455 353 441 271T413 104T396 16Q384 -4 355 -4H351Q315 -4 305 9T280 79Q278 90 276 96Q265 149 265 169Q265 176 264 169Q263 166 263 162Q261 130 248 79T230 18Q220 -4 183 -4H175L151 -3Q134 5 127 17L112 102Q97 188 83 270T69 354Q62 355 54 355"],120:[432,-1,525,29,495,"35 393Q35 417 46 424T89 432Q95 432 112 432T141 431H223Q238 422 241 415T244 393Q244 389 244 383T237 367T216 355Q209 355 209 354L234 319Q259 286 260 286L308 354Q308 355 301 355Q285 356 278 365T270 384L271 393Q271 420 289 428Q295 431 376 431H459Q460 430 465 427T472 422T476 416T480 407T481 393Q481 368 470 362T434 355H425H392L344 290Q295 225 295 223Q294 223 309 203T350 149L405 77L439 76H453Q474 76 484 69T495 38Q495 10 473 1H303Q281 9 281 32V38Q281 49 282 54T290 67T313 76Q324 76 324 77L259 173L197 77Q202 76 209 76Q225 75 233 68T241 55T242 38Q242 28 242 24T236 12T221 1H51Q29 9 29 32V38Q29 48 29 51T31 59T38 67T51 76H117L171 149Q224 222 224 223L124 355H90H78Q54 355 45 361T35 393"],121:[431,228,525,26,501,"26 393Q26 417 37 424T80 431H134H217Q232 422 235 416T239 393Q239 379 236 371T226 360T214 356T197 355L179 354V353L188 330Q197 306 209 272T235 201T259 133T271 89V84L274 95Q279 122 298 185T335 300T352 354Q352 355 331 355Q312 355 304 358Q288 368 288 393Q288 408 291 415T310 431H478Q479 430 484 427T491 422T495 416T499 407T500 393Q500 376 493 367T479 357T458 355H452Q426 355 425 353Q420 337 351 124T280 -94Q240 -195 168 -220Q147 -228 125 -228Q89 -228 66 -201T42 -139Q42 -116 56 -102T93 -87Q117 -87 130 -102T144 -135V-138H126Q121 -148 121 -150T130 -152Q182 -147 207 -87Q211 -78 223 -40T236 1Q230 10 102 355H75L49 356Q26 363 26 393"],122:[432,-1,525,34,475,"56 1Q40 7 37 14T34 41Q34 59 36 64Q39 67 43 73Q65 95 191 213T341 355H133V334Q133 306 124 297Q116 289 91 289H83Q60 289 51 308Q49 313 49 361L50 409Q59 427 72 430H78Q83 430 92 430T115 430T144 430T179 431T219 431T262 431H450Q452 430 455 428T459 424T463 422T466 419T468 416T469 413T470 409T471 404T472 398T472 391Q472 374 469 368L462 358Q453 349 315 218Q210 122 164 76H391V103Q391 136 400 146Q409 155 433 155Q464 155 473 135Q475 130 475 78V46Q475 24 472 16T453 1H56"],123:[694,83,525,50,475,"430 -7H436Q449 -7 456 -8T469 -19T475 -45Q475 -69 466 -76T434 -83H419Q386 -82 363 -80T308 -69T253 -41T223 7L221 17L220 118V220L218 224Q215 229 214 230T210 235T204 241T195 246T184 252T170 257T151 262T127 265Q118 267 100 267T69 270T52 283Q50 288 50 306V314Q50 335 67 341Q68 342 102 343T172 355T217 386L220 392V493L221 595Q225 611 230 621T251 650T304 679T395 693L406 694Q418 694 426 694Q458 694 466 685Q475 676 475 656T466 627Q458 618 430 618Q319 618 305 587L304 486Q304 476 304 458T305 431Q305 385 295 358T251 311L243 306Q243 305 254 298T281 274T302 231Q304 223 304 125L305 25Q309 16 316 10T352 -1T430 -7"],124:[694,82,525,228,297,"228 668Q241 694 262 694Q268 694 273 693T282 688T287 682T293 674L297 668V-57Q282 -82 262 -82Q239 -82 228 -57V668"],125:[694,83,525,49,475,"49 655Q49 674 56 682T73 692T106 694Q141 693 167 690T224 677T275 647T303 595L305 392Q313 367 347 356T417 344T457 341Q475 335 475 306Q475 292 473 285T464 273T451 269T430 267Q352 262 327 246Q311 236 305 220L303 17L301 7Q294 -16 277 -33T242 -60T196 -74T150 -80T106 -83Q78 -83 72 -82T58 -74Q49 -65 49 -44Q49 -24 58 -16Q66 -7 94 -7Q143 -7 171 -1T207 10T220 25V125Q220 223 222 231Q228 257 243 274T270 299L281 306Q234 329 222 381Q220 387 220 486V587Q212 597 207 601T173 612T94 618Q66 618 58 627Q49 635 49 655"],126:[611,-466,525,87,437,"125 467Q113 467 100 480T87 509Q88 520 111 543Q172 602 209 609Q219 611 224 611Q246 611 263 596T290 566T304 551Q319 551 367 594Q383 610 396 610H400Q411 610 424 597T437 568Q436 557 413 534Q348 469 305 466Q278 466 260 481T234 511T220 526Q205 526 157 483Q141 467 129 467H125"],127:[612,-519,525,104,421,"104 565Q104 590 120 600T155 611Q175 611 180 610Q217 599 217 565Q217 545 202 532T166 519H159H155Q120 519 107 547Q104 553 104 565ZM307 565Q307 580 317 593T346 610Q348 610 350 610T354 611Q355 612 367 612Q395 611 408 597T421 565T409 534T365 519H358Q336 519 322 532T307 565"]});
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Typewriter/Regular/BasicLatin.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Typewriter,{768:[611,-485,0,-409,-195,"-409 569Q-409 586 -399 596T-377 610Q-376 610 -372 610T-365 611Q-355 610 -284 588T-210 563Q-195 556 -195 537Q-195 533 -197 522T-208 498T-229 485Q-238 485 -312 508T-388 533Q-400 538 -405 552Q-409 559 -409 569"],769:[611,-485,0,-331,-117,"-297 485Q-315 485 -323 505T-331 537Q-331 556 -316 563Q-307 569 -170 610Q-169 610 -165 610T-157 611Q-141 609 -131 600T-119 584T-117 569Q-117 555 -124 545T-138 533Q-140 531 -214 508T-297 485"],770:[611,-460,0,-429,-97,"-387 460Q-404 460 -416 479T-429 512Q-429 527 -419 534Q-416 536 -347 571T-272 609Q-269 611 -261 611Q-254 610 -182 574Q-168 567 -156 561T-136 550T-123 543T-114 538T-109 535T-105 532T-103 529T-100 525Q-97 518 -97 512Q-97 498 -109 479T-139 460H-141Q-148 460 -209 496L-263 526L-317 496Q-378 460 -387 460"],771:[611,-466,0,-438,-88,"-400 467Q-412 467 -425 480T-438 509Q-437 520 -414 543Q-353 602 -316 609Q-306 611 -301 611Q-279 611 -262 596T-235 566T-221 551Q-206 551 -158 594Q-142 610 -129 610H-125Q-114 610 -101 597T-88 568Q-89 557 -112 534Q-177 469 -220 466Q-247 466 -265 481T-291 511T-305 526Q-320 526 -368 483Q-384 467 -396 467H-400"],772:[578,-500,0,-452,-74,"-429 500Q-440 504 -445 511T-450 522T-452 536Q-452 552 -451 556Q-445 571 -434 574T-379 578Q-369 578 -330 578T-261 577H-96Q-94 575 -90 573T-85 569T-81 564T-77 558T-75 550T-74 538Q-74 522 -78 515T-96 500H-429"],774:[611,-504,0,-447,-79,"-446 579Q-446 611 -412 611H-407Q-383 609 -378 599T-358 587Q-340 583 -263 583H-235Q-159 583 -152 593Q-145 611 -120 611H-117H-115Q-79 611 -79 577Q-80 552 -95 536T-140 514T-191 506T-251 504H-263H-274Q-311 504 -334 505T-386 513T-431 536T-446 579"],776:[612,-519,0,-421,-104,"-421 565Q-421 590 -405 600T-370 611Q-350 611 -345 610Q-308 599 -308 565Q-308 545 -323 532T-359 519H-366H-370Q-405 519 -418 547Q-421 553 -421 565ZM-218 565Q-218 580 -208 593T-179 610Q-177 610 -175 610T-171 611Q-170 612 -158 612Q-130 611 -117 597T-104 565T-116 534T-160 519H-167Q-189 519 -203 532T-218 565"],778:[619,-499,0,-344,-182,"-344 558Q-344 583 -321 601T-262 619Q-225 619 -204 600T-182 560Q-182 536 -205 518T-264 499Q-301 499 -322 519T-344 558ZM-223 559Q-223 570 -234 579T-261 588T-289 580T-303 559Q-303 549 -293 540T-263 530T-234 539T-223 559"],780:[577,-449,0,-427,-99,"-427 525Q-427 542 -417 559T-392 577Q-385 577 -323 553L-263 530L-203 553Q-143 576 -136 576Q-118 576 -109 559T-99 525Q-99 508 -107 502T-161 481Q-177 475 -186 472Q-256 449 -263 449Q-272 449 -339 472T-412 498Q-420 501 -423 508T-427 520V525"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Typewriter/Regular/CombDiacritMarks.js");MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Fraktur={directory:"Fraktur/Regular",family:"MathJax_Fraktur",id:"MJFRAK",Ranges:[[0,127,"BasicLatin"],[128,57343,"Other"],[58112,58128,"PUA"]]};MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Regular/Main.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Fraktur,{58112:[683,32,497,75,431,"427 436Q427 434 427 425T429 398T430 362Q430 222 396 109L393 99L305 33Q218 -32 216 -32Q208 -29 142 22L91 68L78 81L77 94Q75 130 75 173Q75 245 87 347L135 385Q178 418 184 424L177 428Q174 429 170 431Q116 454 96 473T75 534Q79 608 154 683Q164 677 164 673Q164 670 157 662T144 637T137 598Q137 552 182 518T280 470T380 447T427 436ZM342 371L275 394L208 417Q203 417 192 399T168 334T156 229Q153 187 153 157Q153 141 156 135Q158 125 208 88T280 51Q306 51 326 120T346 297Q346 339 344 354T342 371"],58113:[616,30,498,35,432,"39 551L35 569L52 577Q72 586 98 595T140 610T158 616Q174 612 200 604T293 560T412 477Q414 475 417 472Q428 462 430 450T432 376Q432 223 401 124Q395 106 393 103T382 92Q351 68 281 20T206 -29Q201 -31 137 26L100 60L78 83L77 112Q76 132 76 170Q76 259 86 342L88 360L101 371Q116 386 163 422T215 459Q216 459 224 455T233 450L229 446Q225 442 218 434T203 419Q179 394 175 389T168 372Q156 334 156 262Q156 167 164 137Q168 125 196 102T252 62L278 45Q279 45 285 52T302 78T322 126T339 205T346 316Q346 367 344 389L343 406L326 423Q228 520 113 559L100 564L70 557L39 551"],58114:[680,215,333,29,339,"123 386L120 431Q116 476 116 511V520Q116 593 174 649Q207 680 236 680Q258 680 284 664T312 648Q318 648 327 656Q328 657 330 659Q337 664 337 661Q337 660 338 657Q338 652 339 648L268 566L260 574Q234 600 206 600Q182 600 164 585T145 541Q145 492 211 386L267 385H324L299 354H214V312Q214 86 193 -58L192 -69L116 -215H108Q92 -215 92 -212Q93 -211 100 -189T116 -135T128 -80Q134 -41 134 22Q134 54 130 185T125 349V354H29L59 385H91Q123 385 123 386"],58115:[679,224,329,28,318,"91 530Q91 564 116 600T164 656T194 678Q195 678 200 678T209 679Q268 679 316 639L293 593Q267 547 263 546H262Q260 546 256 553Q222 613 180 613Q160 613 146 599T132 564T170 474T210 388H318L296 356H206V322Q204 284 204 255Q202 221 202 161V99Q202 28 194 -22T160 -124Q148 -146 116 -199L101 -224L91 -220Q85 -218 84 -217T83 -215L101 -161Q116 -114 119 -73T122 108Q119 334 117 352V356H72L28 357L66 388H92Q118 388 118 389L109 433Q91 514 91 530"],58116:[471,214,503,52,449,"254 -150Q293 -150 328 -126T363 -54Q363 -38 352 29T339 98L250 34Q160 -30 159 -30L77 64V71Q74 95 74 174Q74 212 75 243T79 294T83 328T87 352T90 366L117 384Q206 446 238 464L250 471Q277 455 306 443T350 427L365 423Q367 423 405 443T443 465L449 455Q431 414 426 362T418 201Q418 135 420 121Q438 -4 438 -19Q438 -26 438 -31T434 -42T429 -51T420 -63T408 -77T391 -95T370 -119T346 -147T325 -170T309 -187T291 -200T274 -207T252 -213T225 -214Q175 -214 132 -196T70 -160L52 -143Q52 -138 90 -48Q90 -47 95 -47H101Q108 -81 146 -115T254 -150ZM341 136Q341 157 344 242T347 348V355L334 356Q299 359 262 367T203 383T179 391Q177 391 173 377T163 323T158 227Q158 164 161 128V121L174 106Q203 75 223 59L341 127V136"],58117:[686,20,333,26,315,"92 446Q92 603 82 664Q94 670 95 670L96 666Q98 661 101 651T108 633Q121 598 121 597L141 612Q247 686 250 686Q251 686 266 679Q261 674 243 659T213 632T190 597T173 546Q172 541 171 530T170 511T170 502Q171 502 222 542L273 582Q308 522 315 504L279 449L269 462Q231 506 215 506Q202 506 190 490Q164 458 164 395V390H279L266 373L254 355H167V306Q169 252 169 217Q170 195 170 147V117L200 92Q234 64 237 64Q243 64 277 81L311 99V75Q310 75 242 27L174 -20L156 -3Q88 60 81 60L79 62Q80 60 82 62Q87 67 87 290V355H57L26 356L73 390H92V446"],58118:[577,21,334,29,347,"117 531Q117 533 137 544T178 566L198 577Q200 577 204 575T208 572V570Q208 568 208 566T207 560Q197 496 197 397V392H321L295 353H199V260Q199 157 200 145V122L269 68Q271 67 274 67Q282 67 310 83T342 100Q343 100 345 92T346 83L211 -21L172 12Q117 59 117 63Q117 65 117 87T119 150T120 238V353H75L29 354L65 391H118V460Q117 498 117 531"],58119:[475,22,501,10,514,"337 91V78L324 71Q288 53 256 29T206 -8T180 -22Q174 -22 158 -9Q82 46 60 46H59L63 51Q67 56 73 68T85 96Q101 158 101 254Q101 300 95 330T83 370T66 394L53 388Q48 385 41 382T24 374Q22 376 20 378T16 381T13 383T10 385V386L119 475Q150 439 160 430L171 422V409Q173 377 173 300Q173 228 166 183T152 122T145 102Q207 81 242 58L337 104V111Q340 146 340 227Q340 320 339 351T338 408V423L422 469Q425 465 429 462L426 438Q413 354 413 251Q413 152 423 119Q426 110 435 96T452 82Q454 82 509 103Q514 98 514 89Q514 87 507 81T472 51T409 -7L395 -20Q393 -18 390 -17Q386 -14 382 -6Q380 -2 379 1Q369 24 361 40T348 62T341 73T338 84L337 91"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Regular/PUA.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Fraktur,{8216:[708,-410,215,45,158,"117 410Q97 410 71 455T45 539Q45 588 129 694L140 708Q142 708 153 694L147 682Q106 609 106 582V577V571Q106 548 132 511T158 455Q158 434 143 422T117 410"],8217:[692,-395,215,49,163,"105 529Q105 546 77 588T49 651Q49 658 51 666Q53 672 67 682T92 692Q111 692 137 644T163 563Q163 534 143 497T99 428T74 395Q72 395 65 400T58 407Q105 476 105 523V529"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Regular/Other.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Fraktur,{32:[0,0,250,0,0,""],33:[689,12,296,91,204,"102 582T102 620T112 673T152 689Q190 689 190 638Q190 605 167 373L148 187L133 184Q102 582 102 620ZM91 24T91 48T107 88T148 104Q171 104 187 87T204 48Q204 22 188 5T149 -12Q124 -12 108 6"],34:[695,-432,215,8,196,"33 436Q8 603 8 648Q8 663 9 671T19 687T43 695Q63 695 74 681Q76 678 76 650V623L66 532Q57 443 55 436V432H33V436ZM128 666Q128 691 162 691T196 668Q196 634 186 531Q176 441 176 432H166Q155 432 155 434L142 545Q135 603 130 647Q128 664 128 666"],38:[698,11,738,49,733,"181 520Q181 604 231 650T328 697L330 698Q333 698 335 698Q336 698 340 698T346 697Q390 697 418 670T446 604Q446 554 414 511Q384 467 300 417L283 406Q281 405 296 374T347 286T425 182Q466 135 469 135Q470 135 473 140T480 152T486 165Q509 210 509 263Q509 282 507 292Q498 317 488 332T465 352T443 359T418 361Q388 361 357 358L346 356L347 374Q347 394 348 396V399H355Q366 396 535 396Q663 396 689 398L703 399Q703 398 702 375T700 351L688 353Q655 356 601 357Q553 357 553 355Q562 332 562 294Q562 280 561 267T555 241T548 218T539 195T529 175T518 156T508 141T497 126L489 115L496 107Q549 54 596 54Q623 54 644 67T677 101T697 140T708 174L710 187Q710 188 710 188L711 190Q714 190 723 187T733 183Q733 179 732 172T726 145T714 107T694 66T665 27T623 0T569 -11Q500 -11 443 41L434 49L425 42Q348 -9 275 -9Q251 -9 233 -6Q187 -1 152 18T98 60T67 111T52 159T49 195Q49 231 60 261T96 315T141 354T197 390L208 397Q181 459 181 520ZM374 577Q374 607 356 629T311 651Q289 651 271 636Q242 614 242 559Q242 533 249 502T262 453T270 435T279 440T298 453T314 464Q374 503 374 577ZM127 217Q127 145 173 89T291 32Q318 32 347 42T393 63T409 75Q384 100 325 184T227 351Q223 366 220 366Q215 366 178 338Q127 298 127 217"],39:[695,-436,212,69,134,"69 666Q69 680 79 687T104 695Q112 695 117 694T128 684T134 659L104 438Q104 436 96 436T88 438Q88 447 79 540T69 655V666"],40:[737,186,389,114,293,"293 737V719Q291 718 285 714T276 708T268 702T258 695T250 686T241 674Q164 570 164 282Q164 -37 230 -119Q273 -171 292 -171Q293 -171 293 -179V-186H289Q270 -180 259 -175Q175 -132 145 -23T114 275Q114 491 157 598T293 737"],41:[735,187,389,89,276,"223 259Q223 386 212 474T178 609T136 677T89 714V735Q121 726 139 713Q276 622 276 273Q276 98 246 -23Q225 -106 189 -139T89 -187V-170L101 -165Q148 -146 172 -110T210 13T223 259"],42:[692,-449,278,34,234,"118 573Q118 575 76 602L34 629L50 647L55 652L66 642Q76 633 91 620T117 598L128 590Q128 663 125 687V692H151V689V687Q151 685 151 683T150 678T150 672Q145 628 144 605V592L219 652L232 634Q232 632 220 624Q195 610 155 582L146 575L158 567Q178 552 197 540T225 523T233 516Q233 515 226 506T217 495L152 549L143 555V530Q144 509 145 492T148 466T149 454Q149 449 142 449H125V462Q128 522 128 549V562L115 552Q88 531 59 506L45 495Q44 495 39 505T34 516L118 573"],43:[598,82,756,47,709,"357 584L399 598V282H709L702 263L696 243H399V-64L379 -73L358 -82Q357 -82 357 81V243H47L51 253Q52 256 54 263T58 272L62 282H357V584"],44:[107,191,278,99,213,"99 62Q99 82 114 94T144 107Q159 107 178 77T205 26Q213 5 213 -23Q213 -49 207 -65T181 -113Q128 -189 122 -191Q121 -191 116 -184T111 -174Q111 -173 122 -155T145 -111T156 -62Q156 -44 152 -34T127 4L104 37Q99 49 99 62"],45:[275,-236,756,46,706,"46 236L62 274Q62 275 384 275H706L699 255L693 236H46"],46:[102,15,278,87,200,"87 43Q87 69 104 85T142 102Q164 102 182 86T200 44Q200 20 183 3T141 -15Q118 -15 103 2T87 43"],47:[721,182,502,34,466,"230 270Q426 721 428 721Q437 719 447 717L466 713L448 672Q78 -180 77 -181Q77 -182 55 -182L34 -181L230 270"],48:[492,13,502,42,456,"212 -13Q184 -13 156 -2T101 32T59 97T42 195Q42 311 132 396Q170 433 211 462T262 492Q272 492 301 477T366 434T429 360T456 258Q456 161 378 74T212 -13ZM381 209Q381 257 365 295T328 355T282 390T243 408T223 413Q220 413 204 403T167 376T137 341Q119 305 119 250Q119 168 159 114T263 59Q308 59 344 93T381 209"],49:[468,2,502,47,460,"123 459Q145 459 170 460T217 462T256 464T284 466L295 467Q296 467 296 467T297 468Q299 468 302 466T307 462L309 459Q307 454 304 424T299 341T297 235Q297 139 298 101T302 55T313 44Q316 43 367 43L460 46Q460 35 459 22V-1H450Q402 2 281 6Q222 6 171 4T91 1T56 -1L47 -2V43H121H170Q195 43 201 45T209 56Q212 69 212 214Q212 333 209 365T194 409Q183 417 161 423T121 430L104 432Q103 432 103 446V459H123"],50:[474,-1,502,60,484,"104 384Q115 394 133 409T199 449T281 474Q321 474 351 447T385 378Q385 328 333 255T228 127T176 72Q176 67 183 65Q184 65 203 65T260 67T331 69L475 73L484 67Q484 64 472 33L460 1H60V17L107 61Q210 159 249 208Q309 283 309 331Q309 363 285 389T228 415Q212 415 184 403T134 379L114 367L104 384"],51:[473,182,502,39,429,"305 328Q305 372 279 396T214 421H211Q172 421 128 384L107 398L116 405Q151 437 191 455T251 473H260Q314 473 341 455T382 394Q384 386 384 367T382 338Q362 263 271 217L256 210L257 206L259 202Q260 202 272 201T296 198T324 192T355 179T384 157T410 123T427 75Q429 64 429 41Q429 -59 353 -120T183 -182L88 -164Q81 -162 69 -157T48 -147T39 -141Q39 -139 46 -127L53 -114L69 -122Q129 -149 171 -149Q218 -149 253 -131T305 -83T330 -26T338 29Q338 41 336 55T328 89T308 127T273 153Q228 171 162 171Q158 171 152 171T142 170H127V204H134Q232 214 275 257Q305 292 305 328"],52:[476,191,502,10,481,"299 -179Q306 -156 306 -48V0H11V7Q10 10 10 18Q10 23 154 236L298 449Q298 450 339 463L379 476Q385 473 384 470V466Q384 463 384 457T384 444T383 427T383 408Q381 328 381 248Q381 46 384 40H387Q422 40 460 44Q465 44 470 44T478 44L481 45Q481 43 478 24T473 1Q473 -1 464 -1Q462 -1 451 -1T430 0H387V-76L389 -156V-161L311 -191Q299 -181 299 -179ZM299 364H287L277 352Q234 297 186 224T112 104T79 43Q79 42 192 42H306V115Q306 300 299 359V364"],53:[458,185,502,47,441,"334 25Q334 99 296 134T207 169Q154 169 107 123L98 114L89 120L80 125V458H420Q420 456 409 418L397 379Q397 378 264 378H131Q130 377 128 376T125 374T124 371T122 368T122 363T121 356T121 345V279V190L130 186L140 190Q196 214 260 214Q311 214 348 197T404 153T431 99T440 42T433 -16T406 -76T356 -130T276 -169T163 -184H156Q110 -184 57 -163L47 -159L53 -147L58 -134Q61 -134 74 -139T110 -148T156 -153Q206 -153 243 -135T299 -87T326 -30T334 25"],54:[700,13,502,45,471,"45 240Q45 328 73 406T143 536T235 626T327 681T399 699Q400 699 404 699T411 700Q424 700 441 696T459 689Q459 671 451 637Q451 633 447 632L444 629L434 633Q413 640 384 640H377Q299 640 222 565Q182 531 156 463T129 315V306H136L149 315Q229 376 316 376H318Q393 376 432 326T471 213Q471 129 402 58T237 -13T93 59T45 240ZM391 172Q391 231 354 272T258 314Q230 314 200 302T154 279T133 262L134 249Q154 32 266 32Q315 32 353 64T391 172"],55:[468,181,502,37,498,"395 377L391 382H225Q59 382 59 383L74 423Q89 464 89 465Q90 468 94 468Q146 460 350 458H498V442L473 406Q241 75 125 -156L113 -181H40L37 -168L57 -140Q115 -58 199 70T339 287T395 377"],56:[705,10,502,40,461,"220 -10Q168 -10 131 6T75 50T48 103T40 157Q40 223 77 266Q103 295 156 328T225 375Q247 393 247 394L206 361Q205 361 193 368T164 391T131 426T102 474T90 531Q90 580 114 615Q146 660 238 698L254 705L262 704Q288 704 332 693T402 656Q434 620 434 568Q434 518 401 475T321 402L305 391L336 368Q339 366 353 356T372 343T389 330T406 316T420 301T434 283T445 265T454 244T458 222T461 195Q461 106 389 48T220 -10ZM350 545Q350 578 337 601T304 634T266 649T234 653L224 654L204 639Q196 634 191 629T182 621T176 614T173 609T170 603T168 597Q165 585 165 567Q165 497 261 424L273 415Q350 467 350 545ZM261 405L263 407Q262 407 261 405ZM258 403Q257 403 255 401L254 399L256 400Q258 402 258 403ZM252 398Q251 398 249 396L248 394L250 395Q252 397 252 398ZM245 36Q276 36 300 45T338 69T360 102T371 136T374 168Q374 211 341 255Q324 275 305 289T235 332Q231 330 215 321T193 307T173 292T153 271T138 247T127 216T123 177Q123 146 132 117T170 62T245 36"],57:[469,182,502,28,466,"353 93T352 93T320 79T251 49T201 34Q127 37 87 79Q28 138 28 234Q28 273 37 304T60 355T101 396T152 429T218 462L234 469H243Q348 461 395 417Q466 348 466 201Q466 72 397 -29T211 -163Q155 -179 91 -182H72V-154H80Q144 -154 202 -131T297 -60Q318 -31 333 7T352 68L357 92Q353 93 352 93ZM369 208Q369 240 362 272T339 339T290 394T214 415Q171 415 144 372T116 266Q116 193 154 144T238 95H249Q369 95 369 208"],58:[457,12,216,50,168,"50 377T50 400T64 440T99 457Q128 457 146 440T165 399Q165 375 146 359T102 342T64 359ZM53 19T53 43T66 86T103 105Q129 105 148 87T168 41Q168 17 147 3T102 -12Q80 -12 67 3"],59:[458,189,216,47,179,"47 399Q47 424 62 441T101 458T143 442T162 400T144 359T101 343Q78 343 63 360T47 399ZM76 86Q76 88 80 91T91 96T106 99Q119 99 131 86Q179 35 179 -25Q179 -64 146 -115T89 -189Q86 -187 83 -185T79 -182T76 -180T75 -177T77 -173T80 -168Q121 -108 121 -64Q121 -44 94 -5T66 52Q66 66 71 75T76 86"],61:[368,-132,756,54,725,"725 366Q724 365 721 349T716 331V329H385Q54 329 54 331Q55 332 59 349T63 368H394Q725 368 725 366ZM725 169Q724 168 721 152T716 134V132H385Q54 132 54 134Q55 135 59 152T63 171H394Q725 171 725 169"],63:[693,11,362,46,357,"46 557Q46 613 103 653T227 693Q287 693 322 659T357 564Q357 517 326 469T259 390T191 326T160 272Q160 240 187 221Q193 217 193 216Q182 209 170 200L147 184Q127 192 113 209T98 250Q98 290 193 376Q287 454 287 542Q287 581 262 616T188 652Q143 652 126 631T108 588Q108 559 140 527L79 490Q46 515 46 557ZM108 47Q108 68 123 85T160 103Q179 103 198 90T217 46Q215 24 201 7T164 -11Q142 -11 125 6T108 47"],65:[696,26,718,22,707,"22 505Q22 563 94 624T271 685H280Q416 685 443 560Q447 535 447 504Q444 414 405 330L399 319L229 155Q233 154 241 153T253 150T265 145T281 135T301 119T328 93L357 64L402 92Q438 116 473 137L500 154V339Q500 528 495 593V601L559 649Q621 696 624 696L638 686L629 677Q599 650 593 638Q582 614 581 504Q580 490 580 443Q580 314 584 238Q584 235 584 224T584 210T585 199T586 187T588 176T591 164T595 152T601 137T609 121Q630 77 640 77Q661 77 703 101Q704 95 706 90L707 86V84L636 29Q618 15 601 2T574 -19T564 -25L500 121Q499 121 399 48L299 -26Q298 -26 291 -15T272 11T245 42T209 69T165 80Q120 80 58 43L48 37L40 42L32 48L122 117Q196 173 241 211Q319 280 343 327T368 447Q368 535 317 582Q264 633 199 633Q155 633 122 605T86 542Q86 518 133 467T181 387Q181 348 140 309Q113 281 73 260L64 255L50 265L59 273Q112 307 112 345Q112 363 90 387T45 441T22 505"],66:[691,27,884,48,820,"48 506Q48 568 120 629T268 691Q362 691 425 594L431 585L441 594Q478 628 528 657T629 686Q665 686 687 670Q703 658 718 584T753 506Q756 505 763 505Q778 505 804 512L815 516L820 496Q820 494 808 490T774 476T732 454Q720 445 708 437L675 415L640 394L625 383Q626 382 635 382Q652 382 670 379T712 364T754 336T784 289T797 220Q797 172 776 122Q769 106 766 102T745 84Q654 11 619 -8T538 -27Q483 -27 387 10T249 47Q218 47 186 34T133 8T112 -5T104 7T97 21L196 82Q259 120 284 140Q333 181 351 214Q368 251 368 353Q368 588 228 620Q222 621 205 621Q160 621 139 596Q117 569 117 548Q117 526 162 470T208 387Q208 352 179 320T104 264Q88 256 86 256Q83 256 70 266L82 274Q134 309 134 343Q134 352 130 359Q118 377 100 401T72 439T56 470T48 506ZM453 528Q457 496 457 419L458 357L488 367Q554 390 622 425Q673 449 673 453L671 454Q669 456 665 460T657 473T648 498T639 541Q629 597 616 613Q599 633 567 633Q534 633 493 599Q471 577 457 540L453 528ZM713 176Q713 252 661 295T528 339Q512 339 494 336T466 330T455 325Q454 325 452 311T444 270T425 217L420 207L304 118L319 116Q381 111 475 74T602 37Q655 37 684 79T713 176"],67:[685,24,613,59,607,"299 585Q333 609 384 634T470 672L505 685Q506 685 513 662T531 613T548 580Q553 576 563 576Q575 576 605 585Q607 585 607 575V564Q537 532 496 527Q475 542 456 567T427 610T415 627Q410 627 398 618T382 603Q373 588 373 558T386 475T400 399Q400 337 366 303Q343 281 309 266T254 247T226 242L214 257Q214 258 223 260T251 272T287 299Q304 316 304 360Q304 396 289 451T274 532Q274 553 277 561V564H269Q205 558 172 501T139 358Q139 207 226 127T443 46Q448 46 457 46T470 47L485 48L601 106Q602 106 602 93V80Q551 48 517 25T474 -4T460 -13T443 -19Q409 -24 367 -24Q360 -24 351 -24T335 -23T326 -22Q190 -2 125 87T59 319V328Q62 412 96 487L101 500L118 512Q189 563 245 591L266 601L299 585"],68:[685,27,832,27,745,"346 611Q300 611 261 604T194 584T144 555T107 519T82 481T65 443T55 410T50 383T48 367L37 372L27 378V393Q33 524 115 603Q160 648 230 666T365 685Q423 685 434 684Q745 653 745 405Q745 281 694 151L687 133L657 103Q524 -27 470 -27Q456 -27 331 18T157 64Q122 64 84 28Q67 9 57 -6L50 -16L43 -8L35 0Q35 3 46 22T83 74T141 133H154Q208 136 253 161T299 230Q299 259 277 290T232 348T209 392Q209 434 254 479T358 556L368 561L382 550Q382 549 381 548T377 545T371 541Q353 527 326 496T298 444Q298 430 343 365T389 277Q389 240 353 202T267 136L252 127Q304 118 400 83T513 47Q548 47 582 79T635 145Q671 208 671 323Q671 390 651 441T599 524T523 576T436 603T346 611"],69:[685,24,663,86,634,"301 564Q240 564 203 507T165 361Q165 280 190 218T260 119T358 64T474 46Q491 46 499 47L511 48L628 106V80L499 -5Q498 -6 497 -7T494 -10T490 -12T485 -15T478 -17T468 -19T456 -21T439 -22T418 -23T392 -24Q252 -20 169 67T86 315Q86 409 124 491Q128 500 139 508Q211 560 272 591L293 601L325 585L338 594Q374 617 422 639T502 674L532 685Q533 685 540 663T557 614T574 581Q580 575 591 575Q600 575 616 580T634 585V564L623 559Q572 535 532 529L522 527Q491 547 442 627Q442 628 440 627T435 624T428 620Q410 610 405 597T399 559V553Q399 534 409 487Q419 431 427 369L476 400Q526 431 526 432Q531 426 537 420Q565 382 602 359Q611 353 610 352Q609 351 575 332T537 312Q536 312 505 335T463 358Q451 358 439 352T425 337Q394 243 263 223L251 221L243 229L235 236L245 239Q274 247 303 266Q320 277 325 290T330 336Q330 394 315 451T300 531Q300 549 303 561Q303 564 301 564"],70:[686,153,611,11,612,"198 617Q177 617 159 609T128 587T106 557T91 524T82 494T76 472L75 463Q74 463 67 468T59 474Q59 488 63 510T80 564T114 622T170 667T253 686Q272 686 295 680Q330 672 384 645T468 598Q498 580 524 580Q549 580 595 626L612 643V616L599 599Q522 500 482 500Q466 500 435 514L420 521Q388 516 349 486T309 415Q309 396 323 366T352 315T367 294Q367 293 375 301T398 322T429 352L490 410Q537 355 542 332Q542 330 531 315T510 286L499 273Q479 313 449 313Q437 313 419 303T390 282L378 271L394 250Q444 183 470 129Q484 96 484 71Q484 -19 402 -86T223 -153H220Q175 -153 137 -120Q103 -89 103 -8Q103 12 106 40T109 96Q109 132 103 146T72 161Q46 161 16 143L14 154L11 165Q88 219 143 219Q163 219 177 197T192 127Q192 102 186 65T179 4Q179 -60 210 -88T272 -117Q319 -117 362 -75T405 33Q405 72 363 139T278 271T235 368Q235 385 243 404T264 439T292 472T324 500T353 522T374 538L382 543Q382 544 351 562T274 598T198 617"],71:[690,26,785,66,710,"373 560Q373 543 378 509T388 448T394 421Q396 421 416 433T474 474T548 537L538 543Q481 570 452 628L487 659Q521 690 522 690L526 684Q529 677 535 667T551 646T575 625T607 608Q617 606 621 606Q644 606 660 622L664 600L497 455Q495 453 527 453H546Q628 453 665 407L666 406Q710 357 710 297Q710 196 631 109L621 98L577 69Q471 -7 452 -15Q413 -26 370 -26Q239 -26 155 59Q66 148 66 319Q66 442 113 505L191 552Q269 600 270 600H271Q273 600 280 596T293 589T299 586Q300 586 357 623Q413 659 415 659L426 649Q373 604 373 560ZM219 228Q305 262 305 329V343Q305 384 294 434T282 519Q282 562 287 567Q287 569 286 569Q222 556 191 520Q144 464 144 362Q144 213 228 128T420 42Q514 42 568 103T622 255V260Q622 320 578 357Q526 400 453 400Q434 400 410 396L399 394L400 378V372Q400 330 388 301T348 254T305 232T252 217Q245 215 242 214L234 213L226 220L219 228"],72:[666,133,720,1,644,"11 -16L1 0Q7 6 25 27T57 62T91 88T128 101Q159 99 195 66L203 59L211 67Q239 95 239 133Q239 158 210 213T152 330T123 430Q123 477 173 536T269 630T320 666Q376 610 440 606H443Q457 606 466 611T519 647L542 664Q543 664 543 654V643L522 622Q434 537 403 537Q388 537 366 543T329 555T293 570T270 580L261 585L253 574Q206 517 206 475Q206 452 218 416T242 356L255 331Q256 331 270 345T324 391T421 459L437 468H453Q545 463 608 421L618 415L623 392Q644 307 644 233Q644 97 612 9Q604 -10 601 -15T581 -35Q505 -104 467 -124Q446 -133 431 -133Q414 -132 399 -126T376 -115T368 -107Q368 -106 392 -75L415 -43Q432 -67 444 -73T472 -79H474Q479 -79 484 -78T501 -69T521 -50T538 -13T551 46Q558 97 558 180Q558 232 557 245Q553 277 547 300T528 349T488 389T424 404Q344 404 276 295Q272 288 273 285Q300 216 300 168Q300 161 300 156T298 145T297 137T293 129T289 123T283 116T277 107Q212 23 178 -13L166 -26L149 -9Q108 32 81 32Q63 32 21 -7L11 -16"],73:[686,26,554,30,532,"190 601Q161 601 137 587T97 553T71 512T55 477T48 463Q44 465 39 468L30 473L35 488Q73 594 106 636T199 685Q200 686 211 686Q250 686 326 652T417 617Q435 617 455 626T497 652T522 670Q532 660 532 654Q469 591 390 550L378 543L343 556Q223 601 190 601ZM378 208Q378 249 369 318T360 424Q360 430 360 439T361 451L362 462Q416 526 482 571L495 580L503 577L511 575L499 562Q442 502 442 465Q442 436 452 368T462 246Q462 169 442 128T385 56Q292 -26 195 -26Q150 -26 104 14L96 21L43 -16Q43 -15 43 -14T41 -10T38 0L48 13Q76 50 123 97L150 125Q154 131 159 131Q166 131 171 116T182 81T193 53Q199 43 216 33T261 22Q307 22 344 68Q378 113 378 208"],74:[686,139,552,-10,522,"194 601Q175 601 155 590T121 564T95 533T76 506L69 495Q55 503 55 507Q55 509 60 521Q87 586 132 636T222 686Q251 686 289 660T363 607T422 580Q442 580 466 588T506 604L522 612V591L487 574Q371 517 359 517H357Q332 522 280 561T194 601ZM383 39Q383 96 356 203T329 361Q329 364 329 370T330 378L331 388L339 399Q362 429 394 462T446 513T469 531Q470 531 477 527T484 521L474 509Q411 434 411 379Q411 341 434 223T458 82Q458 1 390 -69T239 -139Q191 -139 162 -123T123 -83T108 -30T101 23T88 64T52 80Q27 80 -4 64L-10 80Q-5 85 13 98T63 128T118 144Q149 144 163 129T179 93T182 38T187 -19Q199 -96 278 -96Q294 -96 309 -91T343 -73T372 -31T383 39"],75:[680,27,668,17,682,"154 37Q219 41 219 142Q219 203 190 302T160 434Q160 445 172 472T209 534T269 602T354 657T460 680H472Q576 680 618 617V599Q618 578 615 555T608 517T602 501Q596 495 587 495Q586 495 586 499Q586 500 586 505T585 513Q567 628 415 628Q384 628 356 621T302 596T260 546T244 466Q244 416 258 377L261 367L276 382Q294 401 317 422T386 471T468 500Q500 500 518 477T544 422T554 386Q555 382 560 376T576 364T601 357Q612 357 623 361Q623 360 621 351T617 340L541 305L465 272Q469 271 476 270T488 266T502 260L512 255L519 242Q533 211 546 157T564 93Q584 53 617 53Q649 53 682 74V54L675 46Q646 17 612 -5T554 -27Q546 -27 538 -23T517 -9T494 28T478 91Q465 172 448 200T378 228Q337 228 289 207L288 196Q288 160 284 138Q283 125 262 98Q185 1 112 -24L102 -27L91 -25Q47 -13 17 31Q17 33 49 69L80 106Q111 37 154 37ZM421 434Q411 436 405 436Q370 436 336 407T275 337L267 325L271 313Q288 257 288 234Q289 234 395 276T502 319Q501 320 499 323T493 330T485 345T475 371Q473 378 468 388T449 416T421 434"],76:[686,26,666,33,644,"251 231Q251 254 206 341T160 468Q160 529 238 605Q313 677 425 685L432 686Q440 686 445 686Q520 686 545 657T571 576Q571 548 568 517T564 480Q564 466 572 460T608 452H623V431L619 430Q618 430 611 428T591 423T566 417L516 404Q497 415 491 419T480 433T475 461Q475 470 477 498T480 546Q480 561 480 569T474 592T459 615T429 631T379 638Q322 638 283 606T239 526Q237 480 280 394Q319 310 320 268V250Q308 235 244 169L203 128H210Q215 128 256 112T357 80T466 64Q526 64 564 88T625 186L629 196Q643 187 644 186Q618 70 604 41Q577 -15 513 -24Q496 -26 476 -26Q418 -26 344 -3T211 45T133 69Q115 69 97 50T65 7T49 -20L45 -16Q41 -11 37 -6T33 0Q33 8 66 69T111 134Q251 156 251 231"],77:[692,27,1050,27,1048,"687 578Q690 586 719 612T794 665T877 692Q909 692 926 670T953 614T973 570Q983 561 1000 560Q1023 560 1048 569V553L1034 546Q1003 528 972 504T933 466Q905 403 905 264Q905 205 909 172T920 126T940 91Q951 74 959 74T997 87L1027 100V79L956 27Q940 15 922 2T894 -19L885 -26Q883 -26 854 27L825 80V192Q826 314 830 341Q831 345 833 356Q840 398 844 404Q871 444 920 489L917 491Q914 493 911 495T903 501T898 508Q893 516 877 562T852 616Q840 628 818 628Q751 628 702 541L697 532L700 515Q708 467 708 419Q706 348 690 276T662 169T643 126L634 116Q626 105 611 87T581 51L522 -22L514 -15Q470 21 452 21Q431 21 394 -16L384 5L386 9L426 60Q449 87 460 95T486 104Q487 104 491 104T497 103Q514 99 541 81L559 69Q595 96 606 169T618 350Q618 486 598 543T517 601Q484 601 458 570T432 523Q432 516 434 492T436 443Q436 250 369 133L363 122L280 50Q207 -16 192 -27L182 -18Q136 26 106 26Q83 26 62 9T37 -16L27 0L33 10Q41 22 54 39T94 81T143 106Q178 106 225 62L235 53Q283 82 307 117Q352 190 352 359Q352 408 345 451T320 534T267 597T183 621Q159 621 147 617T120 598Q97 574 96 556Q96 528 143 469T191 377T161 311T102 262T70 245Q69 245 59 252T49 260L56 264Q63 268 73 275T94 291T111 312T118 338Q118 355 95 384T50 446T27 506Q31 567 101 626T255 686Q297 686 330 671T382 632T409 595T421 572V571L430 580Q454 610 496 634T588 659H590Q655 659 683 585L687 578"],78:[686,25,832,27,825,"112 334Q112 356 70 410T27 497Q27 553 94 619T229 685Q230 685 236 685T246 686Q303 686 349 654Q373 636 392 607T419 558L426 538L454 576Q474 604 486 618T520 651T569 678T633 686Q668 684 687 673T713 651T730 609Q730 608 732 600T736 588T741 578T747 568T754 561T765 555T779 553Q789 553 817 562Q819 557 819 555V547L790 526Q743 492 730 479T712 447Q697 369 697 281Q697 166 726 108Q741 76 755 68Q759 66 767 66Q789 66 825 93V82Q825 71 822 70Q821 69 763 27T701 -18L692 -25L668 15Q662 25 650 45T635 70L627 85V107Q627 122 626 162T624 285Q624 381 632 398Q638 409 651 425T675 454T696 477T707 489H696Q683 490 679 492T669 507T653 551Q642 588 627 608T584 628Q572 628 560 625T538 616T519 602T502 586T486 568T473 549T463 532T454 517T448 504L445 497Q437 480 437 474Q437 472 439 461T444 421T446 348Q446 205 405 124Q396 105 392 100T368 78Q312 32 278 9T235 -18T214 -22Q191 -22 170 -10T139 12T129 25T160 66T192 105Q193 102 194 98T200 83T213 64T233 49T261 42Q303 42 339 90Q373 134 373 268Q373 397 339 493T235 618Q215 628 191 628Q155 628 126 604T97 548Q97 524 120 493T168 431T192 381Q192 346 164 318T86 260L70 250L54 266L63 272Q112 300 112 334"],79:[729,27,827,12,744,"428 596Q412 596 386 595T350 593Q289 593 270 625Q267 632 267 640Q267 656 280 672T312 705T336 729H343Q351 729 351 728Q342 710 342 703Q342 683 382 676T493 662T604 643Q648 627 677 599T720 535T739 466T744 392Q744 317 732 260T696 166T659 116T621 83Q617 80 615 78Q485 -27 377 -27Q320 -25 272 -9T187 21T122 36H116Q65 36 29 -13L27 -15L12 0Q12 1 32 26T76 78T109 109Q145 123 166 150T187 207Q187 244 134 318T80 412Q80 454 112 498T176 566T213 590Q216 590 224 585L234 580L225 573Q216 566 207 557T188 536T172 511T165 484Q165 448 213 368T261 259Q261 241 252 219T228 179T200 146T176 122L167 112Q170 111 174 111Q188 110 233 91T339 55T453 37Q508 37 556 68T626 152Q655 219 655 328Q655 543 532 582Q484 596 428 596"],80:[692,218,828,28,804,"112 339Q112 354 91 380T49 438T28 497Q28 565 95 628T242 692Q261 692 277 689T307 682T331 670T351 655T367 637T379 619T388 600T395 582T401 565T405 550Q409 554 422 570T453 603T500 641Q573 692 637 692Q656 692 670 686T692 672T705 647T713 618T718 584Q720 568 721 562T728 546T742 534T768 530Q776 531 782 532T791 535T796 536Q799 536 804 521Q801 519 789 513T764 499T738 480Q697 447 680 414Q677 407 677 396Q677 370 713 312T750 210Q750 125 686 57T560 -11Q540 -11 475 13L410 37V31Q410 -9 412 -50T417 -118T420 -150Q419 -150 373 -184T326 -218L305 -208Q305 -207 307 -196T314 -165T322 -116T328 -46T331 43V63L318 66Q270 80 250 80Q233 80 213 70Q183 57 138 -3L128 -16L118 5L125 20Q193 154 282 154Q309 154 331 146V287Q331 444 327 469Q321 522 301 560Q284 590 251 611T184 633Q146 633 119 607T92 550Q92 539 94 534Q100 516 143 460T186 386Q186 366 170 336T119 281Q102 264 70 250L49 260L56 266Q64 271 72 278T90 296T106 317T112 339ZM602 345Q602 357 608 371T622 397T642 421T661 441T678 456L686 462Q663 473 652 486T639 512T634 553Q631 594 624 608T593 631Q587 632 567 632Q539 632 497 600T416 497L410 484V122L467 103Q481 99 502 92T533 82T557 75T578 69T594 66T610 64Q647 64 672 87T697 144Q697 180 650 250T602 345"],81:[729,69,827,11,782,"428 596Q412 596 386 595T350 593Q313 593 291 605T268 638Q268 644 269 648T274 658T284 669T301 689T326 718L336 729H343Q351 729 351 728Q342 710 342 703Q342 683 382 676T493 662T604 643Q744 592 744 398Q744 299 708 213T646 104L603 68L614 55Q670 -5 710 -5Q726 -5 744 1T772 14L781 20Q782 20 782 7V-6L771 -13Q673 -69 665 -69L647 -63Q552 -30 514 8H512Q509 8 500 3T471 -9T428 -23Q405 -27 377 -27Q305 -24 228 6T124 36Q69 36 27 -16Q23 -13 19 -8L11 0L27 20Q93 102 109 109Q145 123 166 150T187 207Q187 244 134 318T80 412Q80 454 112 498T176 566T213 590Q216 590 224 585L234 580L225 573Q216 566 207 557T188 536T172 511T165 484Q165 448 213 368T261 259Q261 241 252 219T228 179T200 146T176 122L167 112Q170 111 174 111Q188 110 233 91T339 55T453 37Q508 37 556 68T626 152Q655 219 655 328Q655 543 532 582Q484 596 428 596"],82:[686,26,828,27,824,"27 496Q31 569 102 627T234 685Q236 685 241 685T251 686Q287 686 318 672T367 638T399 598T418 564L423 550Q424 554 434 567T463 601T505 639T561 671T626 685Q672 685 688 659T710 572Q713 533 721 523T766 513Q781 513 787 514T794 516Q796 512 798 509T801 504T802 501T787 493Q702 461 624 401L607 389Q655 383 688 358L697 352V342Q699 330 699 297Q704 209 710 173T734 103Q751 69 765 69Q769 69 806 83L824 90V74Q823 73 759 24T693 -26Q692 -26 660 32L628 90L629 111Q631 159 631 177Q631 278 614 300Q584 340 523 340Q500 340 467 333T431 325Q429 325 429 322Q428 321 426 308T420 275T410 230T392 178T366 125L358 112L342 99Q306 70 269 38T213 -10T193 -26Q192 -26 163 0T116 26Q82 26 50 -8L42 -16L35 -8L27 0L35 10Q43 21 58 38T104 80T158 106Q179 106 218 65L235 48Q238 48 255 60T295 99T329 158Q352 231 352 359Q352 555 242 614Q210 628 187 628Q140 628 116 600T91 548Q91 522 138 464T185 382V376Q185 345 158 313T103 263L76 246Q74 244 64 253L54 260L65 267Q91 285 100 302Q111 318 111 337Q111 355 69 410T27 496ZM562 628Q504 628 443 507L435 491L436 479Q437 471 437 446Q437 396 432 351L529 389L602 426Q673 462 673 463H672Q644 470 637 483T622 553Q608 628 562 628"],83:[692,27,829,66,756,"750 276Q750 141 645 57T378 -27Q224 -27 146 67Q66 163 66 307Q66 361 80 412T127 515T217 609T356 676L388 684L420 692L442 681Q545 625 586 608T654 591Q688 591 710 609T737 646L742 665Q742 665 756 654L752 642Q736 594 706 566T621 515L607 510Q580 513 528 542T421 599T335 627Q272 627 214 569Q139 500 139 373Q139 308 159 247T217 136T316 56T455 26Q520 26 566 43T634 90T666 148T676 207Q676 264 649 297T580 338Q574 339 552 339Q516 339 442 325T327 310H324Q303 310 290 312T259 328T232 369Q230 375 230 390Q230 426 259 461Q286 488 338 507Q351 498 351 495L346 492Q342 490 339 488T330 482T320 473T312 462T305 447T303 428Q303 368 366 368Q393 368 487 388T613 409Q656 409 696 385T748 306Q750 294 750 276"],84:[701,27,669,34,676,"289 686Q338 686 439 668T565 649Q606 649 641 672Q656 683 664 690T674 700L675 701Q676 698 676 692V681L641 636Q608 591 602 588Q577 575 528 575Q490 575 438 583L426 585L416 578Q335 520 335 465Q335 437 393 366T452 259Q452 226 406 171Q387 146 351 115L341 106L358 97Q438 58 475 58Q525 58 598 124L608 133Q617 119 617 118Q617 114 606 103Q513 0 448 -27L438 -25Q401 -19 337 14T234 48Q186 48 122 -3L112 -11L106 -3L101 5L110 15Q160 63 209 105L224 117H310Q384 163 384 210Q384 238 329 303T263 398Q262 400 262 404Q262 427 290 476T368 580Q383 596 381 596Q315 622 228 622Q159 622 118 593T76 516Q76 482 96 461T139 431L107 399L75 367Q34 403 34 472Q34 525 64 572T148 652Q207 686 289 686"],85:[697,27,646,-25,665,"160 247Q160 291 110 382T59 505Q59 542 106 597T207 690L218 697L229 682Q229 680 216 669T187 644T158 604T144 552Q144 526 165 482T207 387T228 291Q228 277 228 267T224 247T219 232T210 217T199 202T184 184T166 163L118 107Q124 105 132 105T160 98T220 77Q298 47 317 47Q354 47 409 105Q444 142 451 161T458 244V277Q458 339 455 457T447 596L575 686L591 676L583 668Q550 632 541 587T532 449V372V298Q532 198 550 147Q572 79 605 79Q617 79 631 84T656 95L665 100V79L595 27Q578 15 560 2T532 -19L523 -26Q522 -26 490 42L458 111L397 50Q389 42 374 27T355 8T340 -5T325 -16T311 -22T294 -26T274 -27Q232 -25 152 6T35 37Q28 36 19 30T4 18T-8 4T-16 -5Q-25 10 -25 11T-20 18Q-5 34 15 57L54 101Q70 103 86 116Q94 121 113 140T137 166Q160 201 160 247"],86:[687,26,831,26,825,"54 266Q118 307 118 339Q118 360 74 413T27 493Q26 530 59 578T133 651Q187 686 256 686Q299 686 332 673T382 640T409 600T424 567T429 553Q431 553 463 586T542 653T624 686Q663 686 715 652T798 617Q812 617 825 622V606L815 599Q785 576 762 546Q724 495 724 432Q724 397 737 317T750 217Q750 148 711 96Q697 75 639 34T578 -10Q563 -21 555 -23T522 -26Q458 -26 363 29Q253 89 211 89Q192 89 173 83T139 67T114 49T96 34L90 27L80 43L95 59Q121 87 148 110T191 143T213 154Q261 154 300 195Q328 222 340 267T352 406Q352 562 255 611Q222 627 187 627H182Q143 627 115 598Q96 579 96 559Q96 528 144 470T192 381Q192 348 156 314T80 256L70 250L54 266ZM727 548Q701 550 650 583T567 617Q560 617 554 615Q532 610 501 580T445 501L437 485V465Q432 326 378 223L294 150Q321 143 421 87T560 31Q608 31 634 64Q660 102 660 198Q660 226 655 292T650 387Q650 418 658 452L660 462L735 548H727ZM264 150Q265 151 263 151H261Q261 150 264 150ZM280 150H276V149Q280 149 280 150"],87:[686,27,1046,32,1054,"32 501Q35 564 103 625T264 686Q326 686 365 652Q402 618 420 564L441 585Q486 630 539 670L559 686L572 672Q637 606 665 559L682 576Q787 686 845 686Q877 686 929 656T992 623Q999 621 1016 621Q1041 621 1054 628L1051 617L1047 606Q1042 602 1037 597Q983 557 969 522T954 434Q954 394 961 336T968 221Q968 201 966 184T963 155T956 131T948 113T936 96T923 82T906 66T887 50L816 -2Q815 -3 810 -6T801 -11T791 -16T777 -20T759 -23T735 -25Q691 -25 619 4T505 37H496L463 21Q420 0 389 -20L378 -27H362Q316 -27 275 -9T202 28T150 46H146Q114 46 59 -5L48 -16L41 -6Q40 -4 38 -2T34 2L33 4Q33 8 77 54Q111 87 142 112L154 122H166Q239 127 288 182Q346 244 346 406Q346 489 326 537T259 610Q227 628 195 628Q155 628 128 606T101 549Q101 517 146 465T192 382Q192 348 156 310T85 254L75 250L64 258L55 266Q56 267 74 276T105 301T118 339Q118 362 75 413T32 501ZM952 547Q927 555 877 586T796 617Q744 617 682 525L676 516L677 498Q678 486 678 425Q678 301 652 206Q649 195 613 151T577 102Q577 100 582 100Q618 100 720 51Q761 32 790 32H794Q843 32 869 83Q884 110 884 189Q884 233 879 294T873 400Q874 433 879 451T889 478T915 507T952 547ZM241 105Q249 98 263 88T317 60T393 42Q478 42 547 109Q607 171 607 358Q607 371 607 380T604 417T595 467T577 517T546 566T500 601L479 580Q449 550 433 526L426 516V503Q426 311 357 200L352 191L296 149Q241 107 241 105"],88:[688,27,719,28,709,"96 511L78 527L149 603Q207 666 227 686L237 685Q278 680 306 667T351 631T376 588T395 533L400 516L406 527Q439 600 523 653Q538 664 587 688Q589 688 596 672T613 635T629 606Q643 588 665 588Q677 588 693 596L709 603V585L607 526Q583 536 554 564T512 614Q461 571 435 507T405 381V367H581L563 347Q561 344 558 341T553 335T549 330T546 326L545 325H541Q537 325 488 329T411 334H405V325Q405 198 454 123Q497 54 568 54Q594 54 619 64T660 84L676 95V74L565 -16L553 -20Q528 -27 512 -27Q492 -27 475 -21T444 -5T418 19T398 47T382 77T371 105T363 128T358 145L357 151Q354 151 339 136T294 91T232 37Q152 -22 113 -22Q90 -22 69 -9T38 17T28 32Q28 33 58 68L86 101Q94 81 115 64T165 47Q206 47 249 84Q302 128 325 222Q334 263 336 312V334H312Q198 334 163 324H161Q162 326 182 348L198 367H336V398Q333 508 308 550Q295 570 274 585T227 601Q204 601 181 589T145 565T115 533T96 511"],89:[686,218,833,27,740,"123 345Q123 358 75 415T27 496Q27 533 63 578T121 639Q181 685 256 685Q305 685 332 676T384 635Q419 588 425 542Q468 585 526 628T618 686Q632 667 658 645T704 609T724 594Q740 512 740 385V375V361Q740 128 682 -3Q656 -64 554 -141T361 -218Q319 -218 287 -203T243 -173T230 -150Q230 -148 267 -109L304 -69Q311 -115 341 -142T411 -170Q474 -170 534 -119T624 11Q660 111 660 312Q660 447 633 528L612 549Q578 583 552 596L543 601L528 592Q501 574 483 558Q454 528 436 494L431 484V473Q431 330 376 230Q366 213 359 206T306 159L250 112Q278 105 327 82T399 58Q421 58 440 69T471 92T484 104H485L493 90L480 73Q453 39 429 13Q393 -22 372 -22Q342 -22 260 15T153 53Q97 53 48 -16L38 5Q46 22 74 54T128 108L143 122H155Q226 127 275 168Q352 236 352 399Q352 501 309 564T197 628Q156 628 129 607T102 553Q102 517 147 463T192 383Q192 323 75 250L59 266Q123 314 123 345"],90:[729,139,602,11,532,"148 590Q95 592 91 627V633L160 729H176Q169 713 169 705Q169 670 244 670Q269 670 305 672T357 675Q405 675 432 661T468 609Q469 605 469 596Q469 572 460 540Q433 463 301 372Q325 378 359 378Q431 378 472 350T519 297Q532 249 532 198Q532 115 500 40T442 -57Q335 -139 202 -139Q165 -139 125 -131L112 -129V-100Q112 -49 106 -33T75 -17Q55 -17 31 -35L22 -42L11 -26L22 -18Q94 36 151 36H160Q171 36 178 33T188 27T194 13T196 -5T197 -32Q198 -79 206 -90Q217 -107 251 -107Q336 -107 389 -33T442 155Q442 240 407 274Q362 319 285 319Q236 319 192 298Q188 298 181 309L224 372Q227 373 234 374T246 376T257 379T271 384T285 391T302 402T321 417Q384 471 384 540Q384 562 366 581T306 600Q292 600 233 595T148 590"],91:[740,130,278,117,278,"262 -119Q224 -120 191 -123T141 -128T118 -130Q117 -130 117 305V740H122Q141 737 219 736H278V723Q278 711 277 711L159 699V-93H162Q167 -93 220 -96T276 -100Q278 -100 278 -109V-119H262"],93:[739,131,278,-4,160,"64 733Q89 733 110 734T143 737T158 738H160V-131H154Q101 -125 40 -124H-4V-103H1Q3 -102 57 -98T113 -92H118V700L64 703Q7 707 3 708H-4V732H21Q34 733 64 733"],94:[734,-452,500,0,495,"0 464L250 734L262 722Q274 712 384 598L495 486Q483 478 467 467L456 459L248 672L154 580L23 452Q17 454 10 458T0 464"],97:[470,35,500,66,497,"86 363Q86 365 128 391T212 444L255 470Q256 470 263 465T283 453T308 442Q338 431 346 431Q350 431 358 436L414 465L421 459L418 434Q404 339 404 262Q404 147 408 119L425 97Q443 74 444 74L467 86L491 97Q492 97 497 83L436 28Q377 -26 374 -26L331 46L329 91L155 -35Q152 -35 114 10T68 65L67 86Q66 100 66 156Q66 177 66 198T68 236T71 268T74 296T77 320T80 338T83 351T86 360V363ZM314 365Q285 367 255 374T206 386L187 392Q181 392 172 376T154 311T145 197Q145 124 151 118Q156 110 187 78L208 56H214Q221 57 253 76L308 109L329 123V136Q328 143 328 257V365H314"],98:[685,31,513,87,442,"177 427Q177 364 181 364Q184 364 192 370T223 395T271 433Q317 469 323 469Q325 469 338 462T377 440T432 413L440 409L441 396Q441 394 441 372T442 334Q442 203 425 108L423 97L400 83Q347 49 296 21T222 -19T196 -31Q192 -29 149 12T87 71L89 89Q100 155 100 319Q100 500 94 627Q94 632 94 638T94 648T94 656T93 662V664Q93 668 97 669T106 670H110Q114 653 118 633L127 596Q127 595 132 597Q136 599 195 642L255 685L272 673Q269 670 256 659T233 637T211 609T190 565T179 508Q177 494 177 427ZM295 377L274 385Q273 385 264 381T242 370T223 361Q213 355 188 340L178 333V123L198 103Q259 42 285 42Q299 42 314 55T339 85Q363 132 363 232Q363 310 358 343V349L345 355Q330 363 295 377"],99:[466,29,389,72,358,"72 208Q72 323 84 361Q84 363 167 414Q248 466 250 466Q255 465 260 465Q283 460 307 450T344 430L357 422L306 343L301 342L296 340Q267 362 247 372T216 384T177 390Q154 349 154 238Q154 220 156 158V145L168 132Q179 121 208 93T244 59Q245 58 246 58Q255 58 302 83T350 108L352 104Q355 100 356 96L358 92Q358 91 274 32T187 -29L177 -20Q160 -6 120 36T77 84Q77 87 75 118T72 208"],100:[609,33,499,13,428,"13 542Q13 544 77 576T147 609Q154 609 185 598T283 551T414 464L427 454V440Q427 436 427 412T428 372Q428 315 426 270T418 197T409 152T400 121T394 103L304 35Q285 21 261 2T225 -25L214 -33Q149 7 97 59L76 80L75 91V171Q75 221 76 254T79 299T80 313Q80 315 78 321Q78 323 78 326L77 330Q79 336 132 384T211 447L219 445Q221 445 224 444L228 443Q229 443 228 441T221 432T206 415L191 395Q175 378 162 339Q152 306 152 250Q152 217 159 140V134L171 121Q194 99 235 74T284 48Q296 48 310 75T337 156T349 267Q349 346 336 400L315 420Q246 489 176 525Q127 545 94 545H73L27 527L13 542"],101:[467,30,401,70,364,"353 103Q353 97 358 87L337 71Q293 38 247 6Q191 -30 189 -30Q188 -30 173 -16T130 26T76 85L74 99Q70 139 70 190Q70 228 73 271T79 338T84 365L94 372Q105 378 126 392T166 417L246 467Q283 417 349 369L364 358L355 349Q249 249 169 180L151 166L152 152V139L165 126Q186 105 215 84T260 62Q267 62 309 82L353 103ZM267 323Q246 337 230 350T204 371T189 385T179 394T174 397Q149 381 149 219V211Q151 211 171 223T220 258T268 299L282 313L267 323"],102:[681,221,326,30,323,"128 387Q128 391 112 456T92 546V555L101 568Q133 617 183 670L193 681L204 673Q238 648 262 648Q276 648 292 656L302 661L308 653Q308 652 278 618L249 585H234Q194 587 159 595Q158 595 156 596H153L150 597Q151 593 152 581T154 564T157 547T164 524T176 494Q199 436 203 400V392H207L323 386Q323 384 309 368L296 351H203V176Q201 -9 198 -32Q194 -61 166 -114Q158 -129 153 -138Q114 -214 110 -221Q105 -221 98 -220L87 -219V-216Q88 -215 106 -150T124 -82Q128 -73 129 155V351H30L64 386H96Q128 386 128 387"],103:[470,209,504,17,455,"27 -144L17 -131L82 -75L146 -20L126 6Q99 37 92 48L78 65L77 79Q75 103 75 158Q75 217 78 268T86 343T91 368Q92 370 109 382T157 413T222 452Q240 465 249 469L251 470Q296 443 350 428L365 424L437 465L442 459Q442 456 441 453T437 444T432 424T427 385T423 317T421 215V133L423 119Q423 111 455 -17Q455 -21 380 -108T290 -201Q290 -202 284 -204T269 -207T252 -209Q172 -209 75 -135L62 -126Q60 -126 44 -135L27 -144ZM349 351Q267 359 178 389Q177 387 173 376T166 358T161 337T157 303T155 259Q155 195 159 135L160 124L170 112Q180 101 204 77T230 53Q231 53 286 88L340 123V141Q340 235 348 329Q348 334 348 339T348 348L349 351ZM364 -59Q364 -37 358 -1T347 64T341 93Q336 93 252 28T149 -57Q226 -134 293 -134Q325 -134 344 -118T364 -69V-59"],104:[688,205,521,77,434,"88 427Q88 486 87 545T84 634T81 667Q81 673 82 673T89 676H94L117 600L200 661Q208 667 218 674T233 684L238 688L254 678Q222 646 216 637Q164 572 164 483V442V371Q187 390 244 431T312 478Q344 446 411 423L428 417L429 396Q434 297 434 218Q430 8 406 -34Q346 -111 262 -195L251 -205L249 -203Q248 -203 244 -199T236 -193Q226 -183 227 -182Q228 -182 244 -169T278 -140T301 -121Q330 -89 340 -22Q355 60 355 171Q355 200 353 244T348 321T344 354Q333 363 307 376T260 390Q241 390 179 350L164 341V121Q180 96 201 66L213 50Q210 46 172 11T131 -24Q130 -24 123 -11T102 25T77 65V78Q80 104 84 227T88 427"],105:[673,20,279,14,267,"72 617Q72 618 102 645T133 673H134Q134 668 175 627L187 615L130 555L116 568Q72 615 72 617ZM27 369Q21 376 14 382L26 392Q83 440 119 474Q158 435 169 427L179 420L176 395Q166 302 166 227Q166 171 174 139Q178 119 186 103T202 81L208 75Q255 100 261 100Q262 100 264 92T267 83Q267 80 208 30T145 -20Q143 -20 118 17L91 55Q98 117 98 193Q98 339 88 369Q71 390 68 390Q63 390 39 376L27 369"],106:[672,208,281,-9,196,"101 644L132 672L145 657Q155 642 169 628L182 614L169 600Q148 579 140 570L125 555L112 568Q109 570 91 592T72 615Q72 617 101 644ZM19 -208Q-9 -185 -9 -183Q57 -134 80 -106Q103 -81 110 -19T118 179Q118 294 113 329T86 383Q78 389 76 389Q73 389 57 379L39 367Q26 380 26 381L33 387Q40 393 53 405T79 428L130 474Q147 457 186 428L195 422L196 376Q196 130 192 58T174 -35Q172 -39 104 -114T19 -208"],107:[689,25,389,24,362,"93 348Q93 379 90 503T87 658V670Q87 671 94 671L100 672L112 636Q124 603 124 600L144 616Q196 659 234 682L246 689Q252 686 256 685T268 680L254 667Q225 641 211 626T184 579T168 505V497L178 504Q203 523 237 544L300 584L310 573Q359 522 359 481Q359 476 359 472T358 464T355 456T351 448T346 440T340 433T332 424T323 414T312 402T299 389L255 343L300 342H346L320 309H177V128L193 113Q214 92 244 68L254 60L303 84Q351 108 352 108L362 96Q355 85 277 30T194 -25L170 -4Q146 18 120 41T89 68Q94 85 94 168Q94 184 94 218T93 268V309H58L24 310L51 342H93V348ZM172 342Q217 342 252 374T287 445Q287 472 255 504Q242 517 241 517Q202 498 187 468T168 365V342H172"],108:[685,20,280,98,277,"221 76L267 99Q268 98 269 96T271 88T270 82L262 76Q255 69 241 57T214 34L148 -20L98 56L99 89Q107 247 107 373Q107 494 101 621Q101 653 99 659V665L106 668L113 672L118 655Q122 642 131 617L138 597Q140 597 157 611L240 670L264 685Q265 685 270 680T276 674T269 667T247 647T219 617Q197 587 186 551T173 493T171 438Q171 376 175 282T179 147V117Q184 109 201 93T221 76"],109:[475,26,767,8,753,"20 367L8 379Q9 380 63 425T118 471Q130 460 143 446L168 421V398L169 376L295 475Q362 433 415 418V399Q415 380 416 380T437 394T484 428T529 462L544 474L556 467Q590 449 614 438T646 424L653 421L665 417L664 412Q664 411 664 407T664 397T663 384Q660 342 660 335Q658 303 658 245Q658 186 660 152L661 126L669 115Q680 96 697 79L707 83Q716 87 723 90T735 96T741 100T746 102L747 103V102L750 95Q753 88 753 87L631 -18Q630 -17 622 -3T589 43L576 60L579 72Q592 146 592 218Q592 265 584 321Q581 345 578 350T560 363Q535 376 496 386L481 390Q475 387 425 358L415 351V238V157Q415 142 415 135T417 120T421 110T430 98T441 81L465 47Q462 44 458 41T443 28T420 8L380 -26L333 47L336 62Q339 77 342 109T345 184Q345 223 341 285T333 348Q322 364 258 382L240 388L169 347L168 240Q168 118 171 110L174 106Q178 101 183 93T195 78L217 48Q217 47 196 30T154 -5T133 -21L130 -16Q127 -10 122 0T111 19Q89 56 89 60Q95 76 95 153Q95 239 88 337V365L62 391L20 367"],110:[475,22,527,20,514,"31 368Q20 379 20 380T72 427L121 470L129 463Q137 455 155 441T176 425V367L320 475L329 469Q351 454 385 437T434 417L432 402Q429 362 429 231V128L439 111Q442 107 445 102T449 95T453 90T456 86T459 84T463 82T467 82Q468 82 489 93T511 105T514 95V88L395 -18L340 65L341 77Q347 111 348 178Q348 343 343 353V358L332 363Q298 377 264 382Q260 382 254 382L249 383Q247 383 211 362L176 341V229V147Q176 134 176 127T177 115T179 106T183 99T189 91T197 81Q201 76 206 69T214 57L217 53Q217 52 175 15T132 -22Q132 -20 114 5T88 41Q84 45 84 50Q94 116 94 203Q94 227 93 263T92 324L90 364L67 388L50 378Q32 368 31 368"],111:[480,28,489,67,412,"67 121Q70 265 84 359V364L97 371Q137 394 177 421T238 464T260 480L278 468Q295 457 327 442T394 418L406 414Q412 388 412 300Q412 263 410 228T405 170T399 130T393 103T391 92L381 86Q274 19 165 -28L161 -24Q157 -21 151 -15T136 -2T118 14T101 30T86 46T74 60L67 68V121ZM335 278Q335 286 335 303T334 335L333 349V356H326Q288 360 208 388L183 397Q178 393 172 383T154 333T142 239Q142 192 151 134Q152 124 155 120T175 99Q197 77 219 64T251 47T267 44T281 52T302 80T320 124Q335 182 335 278"],112:[541,212,500,12,430,"23 25Q15 33 12 38L35 59Q82 102 87 105V351L68 378Q42 414 42 422Q42 437 67 472T114 530L125 541Q126 541 132 537T138 532Q121 507 121 488Q121 453 160 413L167 405L166 390L165 372Q169 372 233 421T305 478Q307 479 315 472Q395 421 423 415Q424 415 424 415T425 414L426 410Q426 407 426 401T426 388Q430 335 430 272Q430 139 408 80Q407 78 340 22L273 -33Q200 23 165 23Q164 23 164 -32Q165 -89 168 -155V-170L93 -212L78 -203Q85 -48 87 16V47H79Q53 44 23 25ZM319 41Q346 94 349 212Q349 278 343 343V351L330 357Q318 363 270 381L255 387L245 383Q212 370 178 345L166 336V287Q165 260 165 166V94H175Q219 90 299 51L319 41ZM132 57L129 60Q130 58 132 57ZM158 29Q159 29 155 34T145 45T138 50Q155 29 158 29"],113:[479,219,489,60,419,"399 19Q399 -123 407 -174V-179L332 -219L322 -210L312 -202L314 -185Q320 -83 323 54V95L311 85Q255 40 162 -19Q146 -29 145 -27Q140 -22 103 20L63 65V73Q61 83 61 115Q61 122 61 135T60 154Q60 263 79 353L83 368L94 375Q123 391 147 405T186 429T212 446T229 458T238 466T243 470T247 471L260 464Q274 457 295 448T330 434L341 432L410 479L412 478Q414 476 416 475T419 473L417 461Q399 358 399 19ZM316 367Q287 370 252 377T196 391L176 397H175Q173 397 166 382T149 314T139 187V158Q139 138 141 132T155 114Q158 111 160 109Q210 58 211 58L218 62Q226 67 240 75T266 91L319 124V196Q319 334 325 361V367H316"],114:[474,21,389,17,387,"357 398Q364 398 375 403L386 408Q386 404 387 400V393L369 377Q361 370 350 360T336 347T327 340T316 336T303 335Q270 335 234 371L224 379Q220 375 214 370T198 355L182 340V243Q182 164 183 152T189 129Q195 117 211 100T239 72T254 60T298 81Q342 101 343 101Q344 100 345 92T346 82L200 -21Q174 -5 117 55L97 75L99 92Q106 147 106 196Q106 216 104 282T97 355Q95 359 95 361Q95 364 77 378L65 387L48 380Q30 372 29 372Q28 371 23 375T17 380Q17 384 50 415T107 467L115 474L128 461Q171 421 182 414V382L235 425Q247 435 261 446T283 462L290 468L295 460Q335 398 357 398"],115:[478,29,443,-18,406,"272 33Q284 33 290 70T296 138Q296 181 290 198T262 230Q257 232 246 232Q231 232 218 227T156 194L108 167L101 176Q90 192 75 219L69 230V284Q69 346 70 357V377L146 427Q181 450 202 464T223 477L225 476Q227 475 229 474Q231 472 242 466T270 450T296 431Q309 418 326 418Q342 418 361 429T392 450T403 459Q406 445 406 442Q406 440 384 421T338 382L316 363Q315 362 310 362Q292 362 251 371T173 396Q156 403 155 403Q143 386 143 342Q143 305 150 278T168 244Q171 242 181 242L190 243L315 300Q330 295 357 274Q358 273 362 270T366 266T369 261T372 253T373 239T374 217T374 185Q374 157 372 133T368 98T363 71T358 50L336 40Q288 20 255 2T211 -22T198 -29L190 -22Q181 -14 168 -3T138 19T104 38T70 46Q50 46 32 37T3 20T-9 11L-18 23L-1 41Q46 89 62 99T112 110Q141 110 157 103T225 62Q268 33 272 33"],116:[640,20,333,27,348,"228 640L242 627L227 613Q213 599 211 593T203 553Q197 500 196 435V389H301L272 353H195V274Q195 178 196 159L197 123Q249 71 273 68H280L312 83Q344 99 345 99Q348 99 348 78Q348 76 314 52T246 4L212 -20Q211 -20 164 19T112 62Q112 122 113 196Q113 228 113 262T114 318T114 341V353H27L62 389H116L117 431V558L228 640"],117:[474,23,517,9,513,"171 315Q171 252 165 199T153 124L147 103Q147 102 196 80L244 57L335 107V116Q339 161 339 268Q339 315 338 351T337 412V424L420 468Q424 465 427 461L424 435Q412 331 412 226Q412 170 415 145T434 96Q442 84 452 83Q461 83 492 96L506 102Q507 102 510 96T513 88L493 71Q445 32 401 -9Q392 -18 388 -17L384 -16Q358 39 355 44Q336 77 333 77Q261 45 203 -9Q186 -23 181 -23Q177 -23 162 -11T121 18T69 44L57 48L61 54Q65 60 71 73T82 102Q100 156 100 262Q100 305 93 335T80 373T62 396L23 376Q18 377 9 386L119 474Q149 437 171 421V339V315"],118:[530,28,512,55,434,"55 418Q55 443 100 503Q121 530 123 530Q125 528 127 528T131 528T134 528T135 524T131 516Q123 499 123 486Q123 457 159 416L169 405L170 388L171 372Q171 371 244 424L317 477L334 466Q394 428 432 416L433 402Q433 400 433 377T434 336V305Q434 195 420 131Q413 94 406 87Q403 84 298 29L192 -28L172 -8Q139 25 106 52L92 64V70Q95 97 95 198Q95 293 94 318L92 355L84 367Q55 406 55 418ZM174 306Q174 297 173 255T171 184Q171 153 175 136T198 100Q207 94 224 80T255 57T282 49Q304 49 328 80Q359 129 359 243Q359 284 352 345Q351 358 348 360Q333 373 304 384T265 396L251 390Q215 372 186 351L175 344V337Q175 319 174 306"],119:[532,28,774,45,688,"45 425Q45 439 82 485T126 532Q127 532 128 532T131 531T137 529L132 519Q121 499 121 483Q121 473 131 454T156 419L167 408L169 376L185 388Q237 425 291 473L301 466Q337 443 394 416L419 405L418 387V369Q419 369 487 418T560 471L581 459Q597 450 621 437T664 415T684 406Q688 406 688 323Q688 254 679 193T662 103T648 71Q647 70 554 20L464 -28L443 -15Q416 1 386 17T343 40T331 49Q331 52 333 73T337 133T339 216Q339 309 334 339Q333 341 316 353T277 377T246 389Q235 389 201 369T166 346Q166 345 164 247Q164 232 164 210T163 179Q163 139 170 116T205 57L212 48L136 -27Q115 16 87 44L78 53L80 67Q88 124 88 211Q88 282 87 315T83 356T74 371Q45 410 45 425ZM591 352Q580 359 565 365T540 374T517 381T504 385L418 342L417 318V220Q417 212 417 194T417 170T418 152T420 134T424 120T431 106T440 95T454 83Q508 44 544 44Q566 44 583 77Q603 120 605 235Q605 289 600 322Q598 343 597 345T591 352"],120:[472,188,389,10,363,"14 377Q63 428 117 472Q130 462 144 449L193 408V392V376L247 420Q300 464 301 464L310 451Q331 417 363 390L333 365Q303 340 301 340Q293 343 277 364T250 386Q241 386 215 361L195 341Q194 333 193 327T191 318T190 304T188 269Q188 220 192 148Q193 122 195 118T210 101Q255 60 271 60Q276 60 278 61L318 82Q327 86 336 91T351 98L356 101Q359 82 356 79Q354 77 283 27T210 -24L192 -7Q160 23 137 40L126 49L116 40Q66 -13 66 -54Q66 -117 167 -140L179 -142V-147L180 -152L123 -188L112 -185Q58 -170 31 -145Q10 -122 10 -96Q10 -80 22 -53Q44 -10 95 49Q97 51 100 54T104 59T107 64T109 71T111 81T112 97T113 119T114 149T114 188Q114 284 108 347V354L96 365Q76 385 67 385Q62 385 45 377L27 368L14 377"],121:[528,218,499,45,431,"74 58Q89 124 89 241Q89 265 89 278T89 305T88 324T87 336T84 346T81 352T77 359T71 368Q57 388 52 398L45 409Q62 454 98 507L113 528Q128 528 128 524Q128 523 125 518T120 503T117 483V471Q123 456 130 445Q135 438 140 432T148 422T153 415T157 409T160 405T162 402T163 399T163 395V384V365Q165 365 237 419L311 473Q383 430 420 416Q426 414 426 411V404Q426 398 426 388T427 367Q431 233 431 201Q431 -3 391 -52Q387 -58 305 -138T221 -218L218 -217Q216 -216 211 -214T202 -210L184 -202L199 -194Q259 -162 288 -127T334 -19T350 184Q350 257 342 328L340 356Q282 390 262 390Q248 390 178 346L163 336V111L216 45L131 -26L124 -15Q114 3 85 44L74 58"],122:[471,214,391,-7,314,"47 335L36 347L52 362Q112 421 167 461L181 471L192 465Q236 444 260 417T284 369Q284 355 276 343T233 291Q195 246 195 245T205 242T241 228T300 198L302 187Q314 138 314 74Q314 -24 291 -95Q290 -100 222 -157L154 -214H145Q102 -214 53 -189T-7 -117Q41 -21 183 122L207 147Q205 149 186 157T140 172T100 180H97V192L140 231Q192 280 199 293Q205 303 205 315Q205 339 185 363T137 388Q119 388 63 347L47 335ZM179 -153Q212 -153 226 -113T240 14Q240 67 233 98T223 132T211 143L222 130Q216 125 206 116T170 82T124 33T88 -20T72 -70Q72 -99 105 -126T179 -153"]});
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Regular/BasicLatin.js");MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Fraktur-bold"]={directory:"Fraktur/Bold",family:"MathJax_Fraktur",id:"MJFRAKB",weight:"bold",Ranges:[[0,127,"BasicLatin"],[128,57343,"Other"],[58112,58128,"PUA"]]};MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Bold/Main.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Fraktur-bold"],{58113:[630,27,587,64,512,"388 427Q320 485 242 524T128 563H116Q95 563 87 561L77 559Q72 563 69 566T65 570T65 572L75 576Q106 592 154 611T212 630Q230 630 262 622T358 581T492 498L508 486Q512 463 512 396Q512 246 469 112L465 102Q453 94 341 25Q252 -27 247 -27Q243 -27 174 24T97 84Q90 100 90 214Q90 285 98 345Q100 360 102 363T118 377Q175 422 262 465Q264 463 270 460L277 456Q277 455 267 447T244 428T228 414Q206 382 206 269Q206 187 214 164T259 110Q286 89 342 58Q391 131 391 313Q391 355 388 412V427"],58114:[693,212,394,37,408,"39 362L37 366L38 368L82 405H133V474Q135 563 143 589T198 658Q210 669 224 676T247 687L255 690H253Q241 690 253 692Q254 692 256 692T260 693Q263 693 262 691L261 690Q300 690 361 662L373 656L388 666Q404 675 405 675L406 674Q406 672 406 670T406 664L408 655L301 555Q300 555 287 564T254 584T221 597Q190 597 176 583T161 550Q161 525 184 495T232 440T261 405H387V399Q377 389 364 379L340 359H258V315Q258 52 228 -18L172 -120L121 -211H109Q102 -212 96 -212L109 -174Q131 -108 135 -80T139 53V76V157V362H39"],58115:[681,219,387,36,384,"41 352Q40 354 39 355T37 358L36 360H37Q48 370 61 380L84 400H108Q131 400 131 402Q121 424 104 501L100 519Q109 560 134 602T196 664Q230 681 271 681Q291 681 316 669T358 644L373 631Q373 630 304 553Q299 548 294 547Q292 547 290 546H287Q286 546 274 562T243 593T205 609Q180 609 165 596T150 562Q150 526 191 488L217 462Q248 431 253 405V400H381L384 394L349 352H251V332Q249 271 231 17L227 -37L120 -217L109 -218Q103 -219 97 -219Q97 -218 101 -206T110 -177T118 -151Q126 -129 128 -120T136 -46T141 127Q141 250 136 340V352H41"],58116:[474,212,593,67,531,"107 370Q127 384 172 409T255 454T294 473L306 468Q356 446 425 431L435 429L524 468Q528 465 531 461Q499 395 499 271V263Q499 146 509 71T519 -8Q519 -28 512 -45Q510 -50 435 -123T355 -197Q296 -212 257 -212Q209 -212 164 -196T98 -167T67 -143L133 -44H144Q167 -88 216 -111T320 -134Q371 -134 390 -118T410 -69Q410 -52 404 -12T392 60T385 92L193 -29L158 5Q124 39 110 51L96 63V71Q94 79 94 121Q94 130 94 148T93 174Q93 230 96 275T103 344T107 370ZM221 397Q200 334 200 254Q200 170 210 140Q216 126 234 109T268 81L283 71L383 119V127Q384 132 384 241L385 347L368 349Q325 357 290 369T240 389T221 397"],58117:[684,27,393,33,387,"103 453Q103 631 95 661Q95 663 102 667T110 672L114 664Q117 655 123 641T131 621L140 597L154 606Q208 641 275 673L297 684Q300 683 302 682T307 679T310 678L314 676Q283 658 256 625Q238 601 231 579T223 515L224 512L282 548Q339 583 341 583T365 548T386 509Q326 443 318 443L316 446Q314 448 311 452T304 460T294 470T283 480T272 488T260 494T248 497Q231 497 223 474Q220 468 218 440T215 407V401H345L309 360H218V314Q218 181 221 139V129L253 108Q306 73 310 73Q315 73 343 83L373 92L374 87Q375 82 375 79T375 74T360 65T308 36T229 -13L208 -27L192 -13Q149 24 90 61Q89 61 89 62L90 68Q91 73 93 87T97 125T100 191T103 291V360H33V366L34 371L85 405H94L103 404V453"],58120:[679,220,981,31,875,"602 575Q505 508 505 489Q505 488 505 482T506 463T507 432Q507 314 456 237L449 226L434 216Q420 208 325 143L316 137Q453 82 488 82Q527 82 585 127L596 136Q597 136 599 126L602 115Q578 85 511 27T428 -31Q400 -31 308 10T170 51Q143 51 123 43T92 24T54 -15L34 6L41 14Q65 41 170 129L188 144L204 145Q254 147 293 164T350 208Q378 249 378 344Q378 422 362 478T320 563T268 605T213 618Q177 618 156 600T134 561Q134 539 162 508T217 446T245 394Q245 368 213 337T85 250L62 262Q73 269 86 279T116 308T133 338T108 378T57 439T32 499Q32 556 117 617T291 679Q350 679 393 658Q415 647 433 631T462 600T480 572T490 550T494 541T499 544T516 556T547 578T603 613T689 662L720 679L730 670Q742 659 756 649T785 629T810 615T836 601T855 590Q855 587 860 536T870 419T875 312Q875 114 800 -25Q794 -35 781 -47Q584 -220 398 -220Q322 -220 278 -190Q253 -173 239 -155L244 -150Q248 -145 255 -138T271 -120T290 -100T310 -80T328 -63T341 -51T349 -46Q350 -46 351 -46T354 -47Q357 -47 357 -52Q359 -68 364 -83T383 -118T424 -151T491 -166Q559 -166 613 -129Q629 -118 641 -108T674 -68T710 1T735 107T746 260Q746 433 727 507Q727 512 685 535T615 570L602 575"],58121:[717,137,727,17,633,"351 571Q317 571 247 563T171 555Q153 555 133 563T107 584Q94 605 98 609Q101 615 138 658T190 717H207Q204 710 204 699Q204 673 231 666Q235 665 264 665Q296 665 345 667T426 669Q474 669 501 660T545 626Q553 612 553 594Q553 531 498 474T379 384Q371 379 371 378Q371 376 390 376H411H434Q520 376 602 318Q621 303 627 288T633 234Q633 59 540 -34Q465 -109 348 -130Q308 -137 235 -137Q159 -136 143 -129Q132 -125 132 -118V-53Q118 -24 90 -24Q69 -24 37 -39L27 -44L25 -42Q23 -39 21 -35T17 -30Q17 -28 40 -14T103 19T177 44Q183 45 205 45Q219 45 227 44T245 37T259 20T264 -12Q264 -33 262 -48T259 -80Q259 -93 260 -95Q271 -110 305 -110Q343 -110 383 -86T443 -33Q491 34 491 154Q491 223 467 249Q428 288 334 288H322Q288 288 237 276L222 273L206 286L262 367Q279 369 303 377T358 403T410 452T431 524Q431 531 431 533T427 545T416 558T392 566T351 571"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Bold/PUA.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Fraktur-bold"],{8216:[708,-411,254,53,187,"187 456Q187 437 169 424T138 411Q114 411 84 454T53 538Q53 565 75 597Q109 648 155 697L166 708L181 694L173 681Q124 610 124 577Q124 549 155 511T187 456"],8217:[692,-394,254,58,193,"125 524Q125 545 92 588T58 651Q58 661 61 667Q65 674 80 683T107 692Q131 692 162 645T193 564Q193 540 176 509T144 460T87 394L78 400L68 406L79 421Q125 489 125 524"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Bold/Other.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Fraktur-bold"],{32:[0,0,250,0,0,""],33:[689,12,349,107,241,"121 621Q121 657 132 673T177 689Q223 689 223 644V635Q223 604 222 595Q221 590 210 490T187 292T175 190V186L166 185L156 184Q156 185 139 393T121 621ZM107 47Q107 70 127 87T174 104Q201 104 221 89T241 48Q241 24 222 6T174 -12Q147 -12 127 6T107 47"],34:[695,-432,254,10,231,"53 695Q74 695 90 679V622L65 433L52 432H39L27 516Q10 626 10 655Q10 680 26 688Q33 693 39 693Q49 695 53 695ZM151 668Q151 691 191 691Q217 691 224 685T231 661V652Q230 634 219 531L207 433L195 432Q183 432 183 433L168 541Q151 664 151 668"],38:[696,17,871,44,839,"290 -14Q186 -14 115 41T44 185Q44 222 54 249T88 300T131 336T189 371Q216 387 216 388Q185 459 185 510Q185 563 206 601T263 659T334 687T405 696Q476 696 503 668T531 603Q531 565 513 536T450 476Q423 459 370 432L334 413L354 384Q474 212 560 139L563 137Q611 185 611 250Q611 295 577 329Q549 356 496 357Q439 357 433 354Q432 354 432 379V403L437 402Q443 402 479 401T557 400Q653 400 735 403T831 407H836Q833 352 833 351L821 352Q809 352 792 352T756 352T720 353T696 354Q680 354 680 353L681 346Q682 339 683 327T685 306Q685 283 681 260T669 218T653 182T635 152T619 129T606 114L602 109Q604 107 618 99T659 81T707 71Q742 71 767 99T804 155L815 183Q815 184 821 183T833 180T839 177Q837 169 834 156T816 110T782 52T727 5T648 -16Q569 -16 499 35H498Q496 35 466 23T387 -1T290 -14ZM418 592Q418 617 398 639T352 661T302 642T278 574Q278 545 288 514T306 465T319 444Q342 456 353 463T382 488T409 529T418 584V592ZM159 239Q159 158 222 98T364 38Q386 38 447 57L469 63L434 98Q349 185 286 275Q258 316 238 345Q233 353 232 353Q159 316 159 239"],39:[695,-436,250,80,158,"80 645T80 662T93 687T123 695Q158 695 158 659Q158 649 157 643L123 437Q123 436 114 436H104Q104 442 92 538Q80 645 80 662"],40:[737,186,459,134,347,"347 719Q325 708 311 698T272 656T233 580T207 455T195 267Q195 30 247 -79Q261 -110 291 -136Q320 -163 347 -172V-179Q347 -186 344 -186Q338 -186 328 -184T287 -165T230 -123Q134 -25 134 271Q134 417 158 514T226 662T335 734L346 737Q347 737 347 728V719"],41:[735,187,459,105,326,"264 262Q264 366 253 446T226 572T186 649T145 692T105 714V725Q105 735 107 735Q108 734 121 731T154 719T196 692T242 641T284 560T314 437T326 268Q326 112 299 7Q279 -78 239 -124T116 -185L105 -187V-179L106 -171L109 -169Q130 -161 138 -158T165 -146T190 -127T210 -101T229 -64T243 -12T255 58T261 148T264 262"],42:[692,-449,328,40,277,"40 516L62 529Q85 542 110 556T140 574L126 582Q112 591 104 595T80 607T40 629Q53 642 57 645L65 652L78 642Q106 620 132 603L152 589V595Q152 630 149 681V692H179V689Q178 681 174 638T171 593Q173 593 240 639L258 652Q260 652 267 643L276 633L260 625Q190 587 175 576Q173 575 180 570Q183 569 186 567Q213 549 256 527L277 515L256 495Q246 501 228 515T194 539T170 554V543Q170 486 178 449H148V456Q152 492 152 550L151 562Q150 562 102 528L53 495Q40 514 40 516"],43:[598,82,893,56,837,"422 584L471 598Q472 598 472 440V282H837Q833 273 829 263L821 244L647 243H472V-63L448 -73L423 -82Q422 -82 422 81V243H239Q56 243 56 244Q60 253 65 263L73 282H422V584"],44:[107,191,328,118,253,"118 61Q118 80 135 93T169 107Q190 107 221 65T253 -23Q253 -39 251 -49T237 -80T198 -133Q148 -191 144 -191Q142 -191 137 -182T132 -172Q143 -161 160 -131T183 -83Q185 -77 185 -62Q185 -54 184 -48T182 -38T177 -28T171 -19T162 -8T150 6Q130 28 124 38T118 61"],45:[275,-236,893,54,833,"54 236L73 275H453Q833 275 833 274Q830 265 825 255L818 236H54"],46:[102,15,328,103,237,"103 23T103 44T120 83T170 102Q200 102 218 84T237 44Q237 20 216 3T168 -15Q138 -15 121 4"],47:[721,182,593,41,550,"272 270Q503 721 506 721L509 720Q512 720 518 719T529 717L550 713L91 -181L66 -182Q41 -182 41 -181L272 270"],48:[501,12,593,42,533,"238 -12Q162 -12 102 42T42 185Q42 303 130 393Q163 425 208 452T284 490L313 501Q323 499 339 495T395 472T464 426Q533 357 533 273Q533 201 483 133T364 27T238 -12ZM428 208Q428 255 402 297T342 365T280 404T241 419Q214 419 178 374T142 259Q142 206 168 164T225 99Q259 74 310 74Q326 74 337 75T366 82T396 103T417 141Q428 171 428 208"],49:[489,0,593,54,548,"95 481Q102 481 217 485T383 489Q384 489 384 485Q367 397 367 165Q367 58 369 54Q374 46 380 44T410 42H466H546V40Q547 38 547 19L548 0H54V23Q54 29 54 34T54 44L55 47Q79 47 134 46T202 45Q226 45 234 52Q240 57 241 64T245 105Q254 236 254 320V347Q254 369 252 382T240 409T211 431L97 450L96 465Q95 480 95 481"],50:[491,-2,593,44,563,"307 335Q307 374 283 397T224 421Q187 421 112 387Q105 384 100 382T95 381Q90 387 86 394L77 407L86 413Q219 491 298 491Q370 491 399 460T428 388Q428 373 424 358T409 326T391 297T363 264T335 235T301 202T269 171L199 104Q194 99 205 97Q209 96 214 96Q527 105 544 105Q553 107 563 102Q563 100 557 79T545 34T537 2H377Q338 2 247 2T130 4H44V26L104 77Q185 145 212 172T267 235Q307 291 307 335"],51:[487,193,593,31,523,"102 402L108 408Q115 413 122 418T141 431T165 447T194 461T227 474T263 483T302 487H307Q413 487 452 420Q465 400 465 371Q465 334 445 303T396 253T347 225T317 213Q314 213 314 211Q316 209 316 205Q317 201 320 201Q337 201 359 198T411 184T465 156T506 109T523 39Q523 -62 436 -127T229 -193Q179 -193 130 -178T56 -150T31 -133Q31 -132 41 -122L52 -112L63 -117Q128 -148 201 -148Q282 -148 331 -104T381 20Q381 71 363 100T304 145Q243 166 149 166H137V204H146Q179 204 211 210T275 229T326 268T346 329Q346 372 314 401Q292 423 245 423Q188 423 125 383L102 402"],52:[495,196,593,13,565,"346 -196Q344 -196 335 -187L336 -148Q337 -127 337 -55V0H13V29L187 253Q362 477 362 479L368 480Q375 481 387 483T411 487T434 491T452 494L459 495Q460 495 470 482V453Q470 389 466 230T461 62Q461 61 513 61T565 60L555 29L546 -1H461V-15Q461 -48 463 -100T465 -154L457 -157Q449 -160 434 -165T405 -175Q347 -196 346 -196ZM339 265V341Q339 362 335 362Q327 362 219 217T110 65V61H337V117Q338 133 338 187T339 265"],53:[481,190,593,18,519,"232 192Q176 192 122 152L95 162V481H306Q516 481 516 479Q514 477 501 433L486 389L319 388H152V386V382Q152 379 152 374T151 365Q147 329 146 260V218H149Q211 242 284 242Q353 242 402 224T474 176T508 117T518 55Q518 -62 432 -126T220 -190Q184 -190 151 -185T96 -172T57 -157T31 -145T20 -139T19 -138Q19 -136 27 -125L35 -112L51 -120Q114 -152 174 -152Q257 -152 314 -100T371 46Q371 107 340 149T232 192"],54:[704,12,593,48,547,"48 251Q48 330 76 403T150 529T253 623T370 683T485 704Q494 704 520 701T547 695Q547 692 542 659T536 625Q531 624 524 624L512 623L502 628Q489 635 468 640Q452 645 423 645Q403 645 379 640T320 617T255 568T201 481T171 348Q170 341 170 330V325L183 333Q275 385 357 385H361Q464 385 514 312Q546 267 546 217Q546 127 457 58T262 -12Q225 -12 189 3T120 49T68 132T48 251ZM448 165Q448 228 406 274T289 320Q264 320 236 312T190 295T173 284Q173 266 176 241T189 178T214 112T259 61T326 39Q372 39 410 75T448 165"],55:[479,197,593,54,591,"57 376L87 479H591V455L584 446Q544 399 491 328T349 117T185 -169L171 -196H159Q152 -197 102 -197Q58 -197 58 -196T56 -185L54 -175L299 158L443 359Q446 367 444 370H254L71 365L57 376"],56:[714,5,593,45,542,"88 533Q88 573 120 610T194 668T268 701T307 714Q324 714 352 711T422 695T486 659Q518 625 518 585Q518 536 479 489T384 406L371 398L385 390Q387 389 400 382T420 370T442 356T466 339T489 319T510 295T526 269T538 238T542 204Q542 125 463 60T256 -5Q145 -5 92 52Q45 97 45 165Q45 204 64 237T109 290T163 324T209 345T228 353L214 364Q199 375 179 392T138 431T103 480T88 533ZM405 557Q405 568 402 581T387 612T350 644T286 663Q283 663 280 663T274 664H272Q256 664 228 636T199 572Q199 547 238 507Q268 475 320 437L334 427Q345 433 358 443T388 483T405 549V557ZM304 42Q366 42 398 76T431 155Q431 178 420 200T396 238T359 270T321 296T283 318L263 328Q262 328 230 312Q190 290 175 266T160 198Q160 132 202 87T304 42"],57:[487,195,593,29,549,"549 220Q549 23 429 -82T105 -195H84V-189Q84 -179 85 -174V-164H93Q184 -156 238 -132T334 -56Q361 -23 376 16T394 78L397 100L363 88Q329 75 291 61T244 45Q237 44 218 44Q154 44 94 97Q29 152 29 240Q29 350 108 404Q145 429 257 480Q270 487 279 487Q403 487 470 421Q549 347 549 220ZM408 217Q408 276 390 320T346 385T297 415T259 424Q218 424 185 393T151 286Q151 216 213 154Q252 115 321 115Q368 115 388 134T408 217"],58:[457,12,255,57,197,"57 398Q57 419 72 438T117 457Q154 457 174 439T194 398Q194 379 176 361T119 343Q85 343 71 362T57 398ZM62 19T62 43T77 85T115 104Q153 104 175 86T197 42Q197 14 171 1T119 -12Q96 -12 79 3"],59:[458,190,255,56,211,"56 399Q56 424 73 440T104 456Q114 458 120 458Q149 458 170 440T192 399Q192 380 174 362T120 344Q85 344 71 362T56 399ZM78 53Q78 67 84 76T90 86Q90 88 98 92T116 98Q117 98 121 98T128 99Q152 97 181 58T211 -24Q211 -77 128 -165Q124 -170 121 -173T116 -178T113 -181T110 -185T106 -190L97 -184L88 -177L95 -168Q143 -104 143 -65Q143 -51 137 -40T113 -7T81 35Q78 41 78 53"],61:[343,-168,582,22,559,"559 342L549 304H22L27 319Q29 328 30 333T33 343H296Q559 343 559 342ZM559 206L549 168H22L27 183Q29 192 30 197T33 207H296Q559 207 559 206"],63:[697,14,428,40,422,"121 590Q121 575 128 562T144 542T152 533T115 512L78 491Q55 499 47 516Q40 530 40 553Q40 601 77 632Q155 697 257 697H268Q316 697 355 679Q422 646 422 576Q422 518 388 476Q383 468 376 461T358 444T340 428T316 410T290 390L230 344Q180 307 180 275Q180 261 187 248T202 227L209 219Q209 215 176 193L142 170Q114 177 100 194T84 226V239Q84 259 93 276T113 302T150 331T192 362Q203 370 219 382T247 403T267 422Q312 471 312 546Q312 593 282 623T207 653Q170 653 146 636T121 590ZM95 23T95 49T117 94T173 113Q204 113 223 96T242 54Q242 27 221 7T167 -14Q136 -14 116 4"],65:[686,31,847,29,827,"821 97Q822 97 824 88T827 77L793 53Q676 -25 670 -28Q669 -29 656 -27L583 123Q583 124 467 46L352 -31L341 -20Q305 18 264 47T192 77Q161 77 60 32L49 40Q37 47 38 49Q39 49 93 83T212 160T297 219Q411 312 411 452Q411 519 360 571T233 624Q180 624 157 601T133 548Q133 524 160 496T214 441T241 393Q241 356 199 321T100 256L86 249L77 256Q68 263 67 263L84 274Q101 286 118 304T135 339T109 384T56 446T29 504Q29 566 118 624Q207 686 309 686Q349 686 360 685Q405 678 439 661T491 625T520 583T534 543T537 511Q537 436 491 344L478 318L455 299Q420 272 308 179L284 160L294 158Q348 154 426 89L437 79Q513 110 579 153V175Q579 183 579 227T580 330T581 446T582 542L583 582L664 630Q681 640 703 653T734 673L744 679Q750 678 756 676L767 674L716 623V585Q716 568 712 463T708 289V250Q708 237 709 218T710 195L711 180L739 130Q768 79 771 79Q775 79 796 88T821 97"],66:[684,31,1044,56,965,"160 345Q160 357 144 376T109 413T73 458T57 509Q57 544 95 584Q142 631 205 657T331 684Q382 684 427 658T500 585L505 577L521 588Q537 599 562 614T616 646T679 673T738 684Q790 684 807 666T840 587Q850 552 863 532T888 508Q894 505 906 505Q917 505 930 507T953 512T963 514L964 504Q965 495 965 494T914 467T808 413T745 384H751Q782 380 802 377T854 362T904 334T937 287T951 217Q951 178 937 143T908 91Q903 86 820 34L734 -21L718 -24Q679 -31 639 -31Q561 -31 451 4T271 40Q190 40 119 -2L99 -13L91 1L84 15L86 16Q88 18 132 42T233 100T315 152Q377 199 386 233Q388 240 393 297T399 363Q399 487 353 551Q337 573 306 597T238 622Q201 622 179 602T157 557T214 476T272 396Q272 371 229 334T143 272T96 246Q95 246 85 252T74 259T95 273T138 306T160 345ZM529 443Q529 409 528 385T526 353L525 346Q526 346 649 390T773 435Q749 451 742 464T727 518Q727 519 725 532T721 548T717 562T712 577T706 589T698 601T688 608T675 614T658 616Q626 616 576 582T525 528Q525 527 526 518T528 489T529 443ZM772 57Q774 57 778 58T792 64T808 77T821 103T827 144Q827 222 784 266T660 322Q652 323 611 323H596Q577 323 535 316L523 314Q520 291 505 255L500 241L356 138L366 137Q443 131 518 110T650 72T748 54Q763 54 772 57"],67:[676,32,723,71,726,"460 -32Q373 -32 305 -11T193 45T122 124T83 214T72 303Q72 395 114 476L119 486L313 592L338 568L359 580Q418 615 479 638T568 668T606 675Q607 675 608 676H610Q612 676 615 661T630 621T660 578Q673 568 694 568Q717 568 721 570H726Q724 565 722 559L717 549L706 545Q608 513 583 513Q568 517 559 522T533 546T493 603L490 609Q452 599 452 558Q452 537 469 481T486 393Q486 353 474 331T422 285T296 231L272 223L262 230L253 237Q279 246 314 274T351 338Q351 376 334 442T316 532Q316 546 319 552Q319 554 316 554Q304 554 288 547T250 523T214 466T199 371Q199 218 299 133T541 47Q571 47 585 51T652 81L712 108Q716 104 716 81L706 74Q695 68 673 54T633 29L550 -22L540 -24Q492 -32 460 -32"],68:[683,29,982,31,896,"380 596Q307 596 250 582T158 546T100 493T67 433T56 373V361Q55 361 43 366L31 372V384Q31 455 69 523T173 627Q213 650 284 666T444 683H452Q629 683 735 629Q896 548 896 369Q896 263 839 163Q835 155 818 140Q746 82 662 27T563 -29Q525 -29 386 16T183 62Q147 62 127 52T63 1L48 -14L40 -4L31 5Q83 73 172 149L186 161H199Q291 161 329 181Q357 199 357 231Q357 258 301 316T245 396Q245 423 282 458T349 512T403 543L413 548L425 545L438 541Q373 491 373 462Q373 446 399 415T453 349T480 288Q480 251 433 212Q394 180 348 156L334 148L353 145Q408 134 513 105T654 76Q711 76 745 132T780 277Q780 434 676 517Q637 549 562 572T380 596"],69:[686,29,783,74,728,"527 55Q574 55 619 69T691 97L717 111V85L562 -18Q520 -29 443 -29Q379 -29 325 -15T235 21T180 61T146 98Q74 186 74 307Q74 395 109 472Q113 482 123 489T190 533Q251 568 295 591L308 598L350 580L361 586Q403 612 464 636T564 673T609 686Q610 686 610 685Q612 683 616 670T627 636T646 601Q666 572 686 572H692Q713 572 726 576H728L725 565L723 554L692 544Q660 535 629 526T595 516Q585 514 574 519Q563 527 543 552T507 597T490 617Q467 604 456 579V564Q456 535 473 471T492 393L494 381L613 460L622 446Q630 433 650 411T696 371L703 365L614 312H596L580 322Q568 329 553 340T528 355T510 360Q496 358 491 354T484 345T471 326T435 297Q408 278 370 261T307 235T277 227Q273 227 266 234L256 240L267 245Q280 251 294 258T330 288T353 336Q353 373 335 444T316 530V537Q316 549 322 567Q270 554 233 499T196 370Q196 253 287 157Q392 55 527 55"],70:[684,146,722,17,727,"424 522Q265 596 208 596Q193 596 180 593T150 579T116 542T89 474Q86 465 86 463L59 481L63 494Q87 578 137 627Q191 684 285 684Q334 684 406 658T538 607T621 581Q644 581 706 629L721 640Q722 640 725 630L727 620Q701 592 654 548T582 486L569 487Q533 490 485 504L468 508Q449 503 429 495T387 466T365 422Q365 373 439 299L453 310Q473 325 528 370L588 418Q614 398 642 368T668 331Q667 331 628 296L590 262L582 274Q557 311 526 311Q511 311 487 297T462 278Q462 277 492 244T551 166T581 88Q581 54 570 25T536 -27T505 -56T478 -76Q376 -146 274 -146H270Q199 -146 162 -118T124 -15Q124 12 128 30T132 96V107Q132 144 117 157Q102 169 85 169Q74 169 59 165T32 156T20 151Q20 152 19 158T17 167Q17 168 17 168T17 169T19 170T22 172T27 175T35 179Q131 230 195 230Q231 230 259 202Q270 190 270 171Q269 150 253 87T236 -16Q236 -67 261 -87T322 -107Q380 -107 428 -68Q467 -35 467 30Q467 60 447 91T383 171T316 251Q290 286 278 308T263 339T261 359Q261 384 284 418Q322 469 424 522"],71:[687,29,927,74,844,"742 611Q784 611 812 631V611Q807 607 783 591T718 544T629 476L606 458Q608 458 628 457T667 453T713 443T762 423T804 388T836 335Q844 313 844 289Q844 231 814 182T746 103Q720 82 655 48T546 -18L520 -21Q456 -29 432 -29Q313 -29 223 33Q204 45 183 65T135 119T91 207T74 320Q74 428 109 480Q116 491 127 497T215 546L308 595L343 583L355 591Q387 613 433 636T488 660H489L491 659Q493 658 495 657T500 655L509 650L500 645Q479 635 460 612T441 552Q441 535 447 498T459 433T466 405L625 513L643 526Q620 530 585 546T535 586Q535 587 532 592T527 602T525 610Q525 613 577 649L630 687Q632 687 638 675T653 649T686 623T742 611ZM349 313Q349 328 327 413T305 510V516Q305 531 308 542T314 559T317 566T315 567Q297 567 270 548Q233 524 212 490T191 392Q191 337 206 288T244 207T284 156T316 128Q410 51 535 51Q632 51 675 102T718 217Q718 269 690 314T599 375Q574 381 535 381Q501 381 477 377L466 376Q469 364 469 349Q469 314 457 295T408 258Q366 236 308 219L288 213L279 220L270 227Q284 232 294 236T309 243T320 252T326 260T331 270T336 281Q349 310 349 313"],72:[683,126,851,6,752,"288 139Q288 172 255 224T189 335T156 442Q156 495 242 579Q289 625 361 668Q364 671 368 673T376 678T380 681L384 683L392 676Q401 670 414 661T443 642T477 626T509 619Q543 619 618 668Q625 672 628 674T631 675Q632 673 633 663T633 651L564 595Q556 589 545 580T528 566T516 556T505 548T497 543T488 539T481 537T472 535T463 534T451 534H442Q385 534 304 581L291 589Q290 588 285 583T277 575T269 566T262 555T257 543T255 529V522Q255 507 260 487T276 446T293 409T311 376L321 359Q321 358 322 358T324 359T327 361T333 366Q386 409 481 460L503 472L543 471Q586 471 599 470Q692 459 714 430Q725 416 738 360T752 245Q752 184 742 127T725 51T703 -8Q700 -13 619 -64T518 -123Q508 -126 493 -126Q438 -126 398 -86L427 -52Q456 -17 457 -17Q460 -17 465 -16H473Q474 -21 481 -32T504 -56T539 -69Q572 -69 599 -34Q625 4 625 158Q625 264 609 311T532 378Q508 386 484 386Q455 386 419 372T360 345T337 330L346 313Q375 263 386 227Q389 215 389 202Q389 192 388 184T384 168T376 152T365 138T350 121T331 103T307 81T278 54L194 -24Q130 30 99 30Q85 30 64 20T31 1T16 -10Q15 -11 13 -7Q12 -6 11 -3Q8 4 6 8L32 35Q88 88 117 107T169 126Q177 126 182 125Q218 118 252 84L263 73Q288 113 288 139"],73:[681,25,655,32,623,"500 615Q523 615 550 628T595 655T614 668L623 654L607 642Q512 569 440 534L427 527L413 529Q384 535 340 547T265 565T209 572Q173 572 145 556T101 522T60 465Q58 460 54 460T41 468L32 477L37 487Q96 599 139 640Q187 681 247 681Q275 681 283 680Q313 674 398 645T500 615ZM418 170Q418 186 410 260T401 382Q403 418 403 424L405 433L415 444Q482 515 571 571L582 578Q591 573 607 568L597 560Q522 504 522 450Q522 427 533 357T545 241V228Q545 190 536 159T508 106T478 73T446 48Q343 -25 238 -25Q179 -25 118 15L107 22L79 5Q51 -12 51 -12L38 2L55 18Q106 67 175 122L192 136Q202 130 206 123Q223 91 252 61Q263 50 266 48T278 39T297 32T320 30Q357 30 389 68Q415 102 418 170"],74:[681,141,652,-8,616,"65 510Q68 517 74 528T101 569T144 620T202 661T274 680Q308 680 389 628T503 576Q530 576 596 600Q615 607 616 607Q616 602 615 596V585Q605 581 576 568T531 548T485 531T418 509L400 503L358 522Q347 527 327 537T299 550T277 560T257 568T239 573T220 577T201 578H196Q181 578 169 575T135 554T88 502L83 496Q82 496 74 502T65 510ZM424 4Q424 50 395 151T365 313V320Q365 352 369 361T405 403Q431 432 465 462T521 508T547 525L549 524Q551 524 554 523T560 521L571 517L552 498Q515 461 499 430Q485 399 485 366Q485 326 512 231T539 84Q539 -14 460 -77T273 -141Q248 -141 234 -140T198 -131T160 -106T134 -59Q128 -40 124 -16T117 22T108 49T91 69T59 75T15 65L1 59Q-8 76 -7 77Q4 85 22 97T88 129T170 149Q218 149 234 125Q242 112 242 43V21Q242 -17 248 -41T274 -85T322 -105H325H330Q363 -105 396 -75Q424 -47 424 4"],75:[681,27,789,20,806,"234 109Q234 144 194 245T153 404Q153 445 180 490Q232 572 325 626T517 681H524Q612 681 661 658Q683 647 699 632T717 604Q717 600 708 545L699 490L690 489Q681 488 679 488Q675 488 669 504T640 546T577 592Q520 620 446 620Q415 620 386 614T327 594T280 553T262 487Q262 468 265 447T271 413T279 384T285 362L295 371Q320 396 352 421T439 474T538 502Q577 502 596 484T627 428Q642 386 651 373T677 360H682Q698 360 727 369L724 357Q724 354 724 351T722 346V344Q559 289 539 283Q582 272 589 271L615 265L637 189Q662 109 663 108Q668 97 682 84Q698 68 722 68H730H738Q762 68 799 91L803 80L806 70Q795 59 770 40T703 -3T631 -26Q598 -26 578 -8Q548 24 536 92Q524 154 509 183T477 218T428 224Q409 224 385 220T346 212L331 207Q330 205 330 201T331 189T332 178Q332 158 325 116L305 96Q269 60 240 38Q171 -21 123 -21Q72 -21 33 18L20 32L62 74Q96 107 102 112T116 118Q120 118 122 113T131 95T150 69Q171 48 190 48Q198 48 206 51T224 69T234 109ZM519 367Q497 432 450 432Q379 432 313 333L300 314L304 299Q306 294 309 280T315 260L321 235L542 313Q530 325 519 367"],76:[683,28,786,30,764,"277 226Q277 248 253 286T203 369T178 449Q178 490 212 533T284 607Q380 683 532 683Q610 683 639 660T668 583Q668 568 666 546T663 509Q663 478 683 460Q691 452 719 452L738 450Q732 437 729 437Q728 437 652 416T573 394Q554 394 541 409T527 444Q527 449 532 487T538 542Q536 584 501 606T418 628Q389 628 364 620T317 587T295 523Q295 478 333 401T372 276Q372 269 371 267Q371 264 318 206L264 149Q284 141 317 130T433 101T577 82Q619 82 652 95T701 127T728 164T742 196L744 209Q744 210 749 208T759 203T764 199T760 185T751 154T744 129Q714 42 680 13Q628 -28 566 -28Q490 -28 403 -5T249 42T153 66T106 53T70 15T47 -16Q46 -17 30 -5L39 13Q85 100 138 148L147 156L161 157Q218 165 246 179T277 226"],77:[683,32,1239,27,1232,"134 338Q134 357 81 417T27 504Q27 516 34 530Q55 568 110 615Q190 683 305 683H314Q445 683 495 580L501 569L512 577Q608 646 681 646Q759 646 801 585L808 576L816 583Q860 619 921 650T1041 682Q1063 682 1077 675T1096 660T1112 631T1132 596Q1160 555 1188 555Q1204 555 1228 564Q1230 565 1231 562Q1231 560 1232 554V547L1215 538Q1179 521 1114 475Q1112 474 1106 470T1099 464T1093 459T1088 452T1085 441T1082 425T1081 404T1079 376T1079 339Q1079 282 1084 236T1098 160T1117 112T1138 85T1159 77Q1166 77 1180 81T1207 90L1219 94Q1220 94 1221 86T1222 76L1045 -32Q1044 -32 1004 15L964 64V167Q965 334 970 372V378L994 402Q1032 440 1057 460Q1061 463 1066 467Q1070 469 1070 470T1068 471T1060 474T1050 481Q1040 488 1021 531T996 583Q979 609 947 609Q922 609 887 592T820 537L821 524Q825 484 825 448Q825 268 768 155L759 137L589 -28L579 -20Q533 17 507 17Q475 17 449 -7L436 -18L424 2L441 20Q446 25 456 36T471 52T484 65T497 79T509 90T522 99T534 106T548 112T561 115T576 117Q602 117 639 86Q648 81 648 81Q650 82 657 94T668 112Q711 202 711 373Q711 484 677 533T600 583Q592 583 583 581T569 577T554 568T542 560T528 549T516 539L519 523Q527 485 527 461Q527 444 522 407Q506 266 447 150L437 130L217 -25L208 -15Q165 28 126 28Q89 28 62 1Q47 -14 43 -14Q42 -14 36 -8L28 0L44 17Q96 73 120 92T166 117Q182 123 204 123Q239 123 284 78L295 67Q307 72 337 102Q400 178 400 346Q400 508 325 571Q270 618 208 618Q180 618 168 614T140 594Q124 578 124 564Q124 540 182 480T240 396Q240 359 197 321Q154 285 94 252L80 245L76 248L67 257L61 262L71 268Q82 275 94 284T120 309T134 338"],78:[679,30,983,25,973,"522 492Q521 492 517 502T512 513Q542 444 542 333Q542 226 503 137L498 125L396 53Q308 -8 292 -17T260 -27Q226 -27 191 -9T136 29L145 39Q162 56 192 89L230 129L235 128H241Q276 57 332 57Q358 57 391 80Q403 89 409 100T422 143T428 227Q428 329 406 408T347 530T272 594T196 615Q152 615 135 596T118 558Q118 535 146 502T203 438T232 385Q232 357 195 322T122 265T83 243Q82 242 72 249T61 258L66 262Q72 265 82 273T103 292Q125 314 125 333Q125 351 101 376T51 432T26 492Q26 549 108 614T290 679Q326 679 335 678Q353 675 370 670T400 658T425 642T445 625T463 606T477 588T487 571T495 556T500 543L504 535L523 553Q553 581 569 595T619 632T686 667T757 678Q778 678 793 675T819 664T833 651T844 633T852 617Q884 548 910 548H916Q938 548 962 556L967 542Q967 540 947 531Q909 509 883 492T847 467T838 458Q825 419 825 328Q825 234 833 191T858 121Q875 94 892 77Q898 71 907 71Q912 71 928 76T957 87T971 91L972 88Q972 84 972 81L973 73L957 63Q891 21 806 -23L794 -30L783 -14Q766 13 728 60L713 79V372L724 384Q743 406 765 427T800 460L813 471Q809 472 806 472Q783 479 766 503T741 551T715 594T672 614Q644 614 622 595Q597 576 572 550T534 508L522 492"],79:[726,30,976,12,881,"254 595Q269 583 269 581L262 577Q256 573 247 566T228 549T212 527T205 502Q205 480 266 386T328 277Q328 234 239 150L221 134L231 133Q264 131 376 99T516 62Q567 50 604 50Q614 50 626 52Q643 57 662 71T703 115T739 198T753 323Q753 454 692 517Q652 555 584 565T382 577Q365 577 357 577H308L300 591L292 606Q292 608 342 665L392 724L403 725Q406 725 411 726H416L417 725L412 715Q408 705 408 698Q408 684 423 679Q431 677 516 672T663 655Q757 634 806 593T873 463Q881 421 881 380Q881 340 874 306Q859 223 809 147Q801 134 789 124Q595 -30 456 -30Q395 -30 289 3T147 36Q134 36 121 33T98 26T76 15T59 4T44 -8T32 -17L22 -7L12 4L56 59L100 114L116 118Q217 142 217 199Q217 230 185 276T120 365T87 430Q87 435 109 464T172 534T254 595"],80:[688,223,977,33,943,"247 398Q247 372 206 334T126 272T83 247Q82 247 72 253T61 261Q60 261 61 262T66 265Q127 306 127 343Q127 364 63 430Q42 451 38 458T33 480V490V497Q33 526 63 567Q112 632 170 660T282 688Q341 688 384 667Q454 633 482 566Q483 565 484 566T496 574Q562 623 630 653Q699 681 751 681Q778 681 797 673Q818 662 830 609Q835 580 843 564Q863 524 895 524H901Q917 524 932 528Q936 522 938 518T942 513T942 511Q873 480 836 454Q789 423 789 395Q789 362 834 298T880 200Q880 170 867 145T820 81Q733 -20 647 -20Q581 -20 499 21V9Q499 -16 502 -53T509 -116L512 -141L370 -223L357 -216Q344 -209 344 -208L348 -196Q370 -113 370 33V52L355 58Q307 76 284 76Q258 76 228 60T183 29T141 -11Q137 -7 133 -2L126 7L134 18Q181 89 210 121T278 170Q304 179 328 179Q336 179 358 177L370 175Q368 268 367 359Q367 416 363 434Q362 438 362 441Q348 527 302 574T203 621Q169 621 148 599T127 557Q127 535 187 476T247 398ZM673 315Q673 357 786 442Q786 443 776 444T750 449T727 462Q719 471 716 484V496Q715 507 715 515Q715 571 698 588Q680 611 643 611Q592 611 547 571Q534 558 511 522L499 505V139L543 123Q702 64 744 64Q770 64 781 79T793 112Q793 143 733 217T673 315"],81:[726,83,976,12,918,"254 595Q269 583 269 581L262 577Q256 573 247 566T228 549T212 527T205 502Q205 480 266 386T328 277Q328 234 239 150L221 134L231 133Q264 131 376 99T516 62Q567 50 604 50Q614 50 626 52Q643 57 662 71T703 115T739 198T753 323Q753 454 692 517Q652 555 584 565T382 577Q365 577 357 577H308L300 591L292 606Q292 608 342 665L392 724L403 725Q406 725 411 726H416L417 725L412 715Q408 705 408 698Q408 684 423 679Q431 677 516 672T663 655Q757 634 806 593T873 463Q881 421 881 380Q881 340 874 306Q864 250 838 196T791 126Q748 93 733 82L715 69Q714 68 723 60T748 40T774 23Q806 2 832 2Q849 2 870 6T904 14L917 17Q917 12 918 6V-3L882 -22Q806 -60 778 -73L755 -83Q640 -36 596 -7L586 0L576 -4Q513 -30 457 -30Q394 -30 289 2T149 35Q119 35 93 22T52 -4T36 -17T24 -7T12 4L56 59L100 114L116 118Q217 142 217 199Q217 230 185 276T120 365T87 430Q87 435 109 464T172 534T254 595"],82:[688,28,978,31,978,"31 498Q34 541 76 586T176 659T279 688H290Q377 688 429 653T506 569L511 558L526 572Q620 663 707 682Q722 685 737 685Q781 685 804 665T830 619T838 565T854 525Q866 511 897 511Q917 511 925 513L937 515Q938 515 941 509T944 501T925 493T870 470T803 438Q735 406 735 401Q735 400 741 399T767 390T814 374L828 367L829 307Q829 233 833 202T852 144Q873 109 896 90Q906 82 928 82T976 95V92Q976 88 978 72L807 -28Q768 39 733 87L718 108V149Q718 230 714 257T693 298Q654 333 580 333Q524 333 520 329Q520 300 489 224T443 133Q441 131 333 53T223 -27Q221 -26 204 -11T169 16T136 28Q110 28 66 -8L56 -16Q52 -13 40 -1L48 7Q165 124 211 124Q232 124 287 77L298 67Q309 73 337 97Q397 150 397 347Q397 419 379 474T330 560T269 604T207 619Q177 619 152 601T126 563Q126 540 185 479T244 387Q240 336 160 289Q144 278 98 255L80 246L62 261L79 272Q96 283 113 301T130 337Q130 353 115 373T81 410T47 451T31 498ZM524 358Q537 358 657 405T777 457Q777 459 768 459Q749 462 738 474T723 499T714 539Q706 585 697 599Q681 618 657 618Q632 618 597 595T532 515L525 502L524 441Q524 375 523 369Q523 358 524 358"],83:[685,31,978,82,905,"457 -31Q356 -31 272 6T135 120T82 304Q82 372 106 430T170 527T241 588T305 626Q341 643 386 657T460 678T495 685T554 660T674 609T778 584Q800 584 818 591T848 610T866 633T878 651T883 659L893 649L901 639Q879 574 803 532T666 490Q661 490 657 490T650 491T641 492T633 495T622 500T610 505T595 513T577 522T554 533T527 547Q436 594 415 602Q393 608 374 608Q303 608 253 545T202 386Q202 229 307 135T568 41Q674 41 748 85T822 198Q822 244 779 283T639 322Q595 322 499 303T383 283Q358 283 335 290T291 318T270 374Q270 418 313 460T424 510H431L435 505L440 500Q425 496 403 475T380 427Q380 382 431 373Q437 372 475 372Q543 372 626 388T742 404Q831 404 868 362T905 260Q905 182 831 108Q692 -31 457 -31"],84:[686,30,790,30,802,"666 641Q737 641 794 686L802 662Q790 648 734 596L677 541L664 538Q630 528 583 528Q540 528 482 537L461 541Q402 512 402 456Q402 427 439 387T512 311T549 253Q549 220 455 139L440 126Q541 75 586 75Q600 75 619 80T654 94T685 110T709 124T719 130Q722 125 725 119L730 108Q700 72 568 -18Q551 -30 542 -30Q495 -30 404 6T270 42H263Q213 42 142 -11L131 -19L129 -8Q126 1 126 4Q218 84 301 126L316 134H406L413 142Q436 165 436 189Q436 202 421 221T364 281Q336 307 318 328T296 356T283 381L290 394Q338 478 410 540Q419 549 417 549Q415 550 369 558T268 575T195 584Q153 584 127 567T100 523Q100 499 116 479T151 447T170 433Q170 429 171 428Q171 427 131 394T88 359Q82 363 73 370T47 403T31 457Q31 513 79 565T197 648T332 679Q369 679 490 660T666 641"],85:[688,39,851,18,871,"273 244Q273 281 244 331T186 428T155 502Q155 524 165 536Q239 634 333 688Q338 684 345 680L356 672L344 664Q310 642 295 624T280 582Q280 550 303 505T348 407T371 300Q371 270 362 248L247 123L358 92Q452 64 484 64Q507 64 523 72Q553 87 573 109Q583 121 586 146T593 283Q594 303 594 344Q594 401 591 461T584 558L581 595Q598 600 623 611T672 634T719 659T754 678L768 686Q770 686 784 673L782 670Q781 668 777 664T768 655Q747 635 738 616T721 535T714 359Q714 205 723 176Q727 164 744 133T771 89Q780 75 804 75Q814 75 853 87L867 92L871 73L671 -39L654 -10Q636 20 619 50T600 83Q600 84 589 75T539 34Q478 -16 475 -19Q469 -22 449 -28T414 -34Q410 -34 394 -32Q356 -28 282 -2L237 15Q169 38 126 38Q106 38 85 27T51 4T37 -8T27 -1T18 8Q18 10 70 63T124 116Q154 123 176 131T223 154T260 191T273 244"],86:[685,29,982,25,966,"133 343Q133 360 79 416T25 496Q25 523 58 563T118 624Q197 685 293 685Q331 685 339 684Q453 665 489 558L493 546Q521 570 553 596T640 653T725 684Q753 684 783 672T844 641T889 618Q895 616 912 616Q924 616 936 617T956 620T965 622T966 612V604L952 595Q924 576 895 549Q864 517 856 496T847 448V434Q847 395 848 388L859 323Q874 241 874 212Q874 142 830 96Q796 62 724 14Q661 -29 603 -29Q555 -29 421 28T242 86Q182 86 110 31Q105 28 102 26T99 25Q88 36 88 42Q95 54 222 142Q252 163 262 165Q319 183 344 218Q378 266 378 377Q378 444 362 494T319 571T266 610T212 623Q181 623 156 603T131 562Q131 539 154 512T206 458T243 416Q246 409 246 399Q246 387 242 377T225 351T178 311T94 259L79 251Q72 256 68 261T62 268L61 270L70 277Q131 318 133 343ZM822 526Q778 531 719 564T628 597Q611 597 579 574Q543 543 513 506L505 495L506 473Q506 469 506 461T507 449Q507 348 467 271L462 261L404 218L348 174Q349 173 356 173Q384 169 450 144L546 105Q665 56 708 56Q737 56 746 72T756 118Q756 129 755 135L741 219Q725 314 725 334V344Q725 416 736 431Q748 450 815 510L832 526H822"],87:[683,30,1235,26,1240,"133 317T133 338T80 413T26 496Q26 532 83 591Q100 608 111 616T151 644T219 672T304 682Q381 682 434 646T506 564L510 557Q513 557 534 573L677 665L707 683L790 561L803 572Q933 682 1001 682Q1037 682 1098 650T1193 616Q1208 616 1222 619L1235 622Q1239 622 1239 616Q1239 611 1240 609Q1240 608 1206 577T1138 503T1104 430Q1104 409 1123 330T1142 208Q1142 183 1136 147Q1127 118 1117 106Q1114 103 1031 48T935 -14Q930 -18 908 -22T862 -27Q826 -27 759 -6T647 26Q597 38 578 38Q573 38 561 33T533 20T505 4T480 -10L469 -16L452 -26L439 -28Q423 -30 411 -30Q358 -30 279 7T169 45Q125 45 58 -5L47 -14L41 -4L35 8Q35 11 56 29T113 75T181 125L200 139H217Q279 143 320 180T377 270T394 393Q394 453 378 498T334 568T277 605T213 617Q177 617 155 607Q140 600 130 587T119 560Q119 545 137 522T177 479T217 434T236 393Q236 324 98 251L89 246L76 253L63 261Q91 275 112 296ZM1088 526Q1066 526 1004 556T909 586Q863 586 816 539L802 526L804 514Q814 461 814 411Q814 319 781 238Q772 214 760 198T730 165T702 136L715 133Q759 122 848 90T973 57Q1003 57 1017 80Q1022 93 1022 116Q1022 152 1003 241T983 377V391Q983 405 985 409T1002 429Q1019 450 1045 475T1090 514L1107 528Q1104 527 1102 527T1096 527T1088 526ZM699 358Q699 391 696 419T688 467T675 503T660 530T642 550T626 563T608 574T593 582Q581 575 559 554T524 512Q523 510 523 477Q523 315 444 218L435 207L368 169Q301 132 301 131Q307 128 315 125L377 99Q476 57 515 57Q534 57 608 94L627 102L636 111Q699 187 699 358"],88:[681,35,849,32,835,"273 679Q354 674 408 633T477 525L484 533Q496 548 524 574T571 615Q594 633 625 649T675 673T699 681Q724 632 747 607Q754 601 756 599T765 594T777 591T794 590Q818 590 834 594V585L835 577L704 513L693 518Q657 534 631 560T597 599Q596 601 581 584Q495 490 489 379V366H562L681 369Q682 369 679 366T668 355T651 341L620 314H485V295Q490 190 543 125T686 60Q720 60 789 88L801 93V89Q798 83 798 66Q781 59 685 -10L665 -25L634 -30Q596 -35 594 -35Q570 -35 536 -23T477 19Q461 37 445 67T418 118L409 138Q401 131 388 120T340 79T273 28T206 -12T151 -31Q129 -31 90 -12T32 22L113 101Q114 101 120 96T136 84T160 69T189 56T221 51Q256 51 305 90Q376 149 376 301V315H293Q276 315 251 315T210 314T190 313L168 312Q168 313 200 340L231 368L238 367Q275 367 311 366H378V387Q376 470 355 512T291 572Q274 579 252 579Q223 579 197 568T156 544T131 519T117 508Q112 512 108 518L99 527L117 545Q177 604 255 665L273 679"],89:[688,214,984,34,878,"34 496Q34 518 53 549T107 610T195 661T310 682Q357 682 398 663T460 611Q467 600 475 583T489 554T495 542Q495 544 531 570T617 629T700 676L724 688Q742 670 756 657T784 635T806 621T830 606T856 592Q878 416 878 340Q878 154 805 -3L798 -20L779 -40Q706 -113 613 -163T421 -214Q359 -214 317 -196T256 -160L306 -63L313 -64L320 -66L326 -79Q337 -104 349 -120T392 -151T470 -166Q576 -166 644 -101Q750 7 750 292Q750 426 721 495T617 565H611Q563 565 513 509L506 501L508 493Q508 490 509 475T510 445Q510 319 458 236L451 225L436 216Q406 198 365 169T318 134L332 127Q336 126 397 103T489 80H493Q527 80 593 129L604 137L607 127Q610 119 610 116Q610 114 592 95T543 46T484 -4Q450 -27 446 -27Q441 -27 402 -18Q365 -9 290 20T188 50Q135 50 64 -7L52 -17L43 -7L34 2L51 19Q118 87 177 132L192 143H215Q259 145 289 155T335 184T355 214T366 245Q382 306 382 388Q382 426 381 436Q368 520 318 570T214 621Q184 621 165 608T142 583T137 562Q137 541 163 508L201 469Q245 425 251 408Q253 403 253 398Q253 383 240 366T212 335T161 295Q128 271 99 253L89 247L77 256L65 266L76 273Q125 301 134 329Q136 334 136 342Q136 357 124 372T88 410T49 455Q34 479 34 496"],90:[677,148,711,-5,624,"278 601Q242 601 212 591T167 570T121 533Q114 528 111 525L93 550Q223 661 244 667Q299 677 356 677Q415 677 456 666T515 634T541 596T549 555Q549 513 529 478T480 421T424 388T377 372Q365 370 365 367Q365 365 389 365T450 358T523 337T588 282T623 183Q624 177 624 161Q624 20 524 -60Q415 -148 285 -148Q242 -148 213 -139Q181 -131 159 -109Q136 -87 127 -56T114 6T104 49Q94 69 57 69Q38 69 13 58L1 53Q1 55 0 59T-3 68T-4 76Q78 130 138 142Q150 144 162 144Q213 144 227 120T242 31Q242 -30 263 -66T345 -102Q397 -102 444 -52T491 107Q491 172 471 211T428 265Q392 288 306 288Q269 288 233 284L218 282Q208 289 208 291L229 324L251 359Q250 360 248 360Q239 360 248 371L256 381H273Q344 385 378 409T413 495Q413 537 384 569T278 601"],91:[740,130,257,36,226,"226 711T225 711T86 699V-93H89Q94 -93 157 -96T223 -100H226V-119H223Q134 -119 42 -130H36V740H42Q61 738 156 736H226V723Q226 711 225 711"],93:[738,132,257,14,208,"69 732Q116 733 146 734T184 736T197 737T206 738H208V-132Q190 -129 160 -127T99 -125T66 -124H14V-103H19Q20 -103 84 -98T152 -92H158V699H151Q148 700 85 703T18 708H14V732H69"],94:[734,-452,590,1,584,"1 463T1 464T148 599T296 734Q584 486 584 485L561 472Q538 459 537 461Q296 672 293 672L161 563Q133 539 97 509T44 466L28 452Q27 452 14 457"],97:[472,32,603,80,586,"80 129V151Q80 241 99 363Q99 367 111 372T172 401T285 465L297 472Q340 455 405 443L423 440L455 453Q486 467 489 467L497 461L494 451Q480 390 480 292V283Q480 207 483 155L484 143L535 80L558 90L582 99Q586 95 586 83Q586 81 513 25L443 -29Q410 16 386 40L371 55V61Q371 63 371 67T370 74V80L278 25Q186 -29 184 -31Q182 -32 160 -12T112 35T80 75V129ZM359 366Q334 366 300 371T243 382L221 388Q218 388 212 375T200 323T194 228Q194 191 197 152L198 139L217 120Q245 92 269 74L279 66L304 78Q338 95 349 100L369 110V152Q368 164 368 210T367 275Q367 358 366 361V366H359"],98:[690,32,590,86,504,"99 398Q99 610 86 662Q86 665 95 669T106 674L108 669Q109 664 112 654T119 635Q122 626 125 616T130 601L131 596Q214 649 273 678Q295 690 298 690Q299 690 304 688T313 682L317 679Q275 653 240 612Q210 569 210 469V459Q210 450 210 432T211 406L212 378L285 425Q301 435 321 447T350 466L360 472Q360 473 361 473T368 471T401 456T465 429L501 414V408Q504 386 504 309Q504 255 500 203T491 125T485 97Q485 95 445 74T343 23T237 -24L214 -32Q197 -22 165 3T109 49T87 73Q99 169 99 398ZM386 251Q386 320 380 347V350L305 374L282 382L214 348L213 274Q213 184 214 165V131L230 119Q288 76 349 54Q386 137 386 251"],99:[473,26,464,87,424,"227 393Q215 393 210 351T205 269Q205 161 213 153Q220 145 244 125T290 88L312 72L365 92Q414 113 418 113V93L365 60Q255 -9 221 -26L211 -18Q158 21 91 88L90 107Q87 167 87 225Q87 267 90 302T96 351T100 366L295 473L311 470Q340 464 368 454T410 437T424 429L347 334L342 333H337L325 342Q299 363 271 378T228 393H227"],100:[632,28,589,-1,511,"88 117Q88 177 91 231T97 310T102 341Q102 343 118 357T168 397T239 447L257 459L268 454L278 449Q242 416 238 412L219 394Q219 391 216 378T211 349T206 307T203 249Q203 211 206 166L208 148Q224 132 261 108T333 70Q341 66 342 67T350 79Q393 157 393 302Q393 368 388 406V411L371 424Q199 558 101 558Q69 558 28 545L18 542L8 549L-1 557L24 569Q61 587 147 621L177 632Q179 631 194 627T216 621T240 613T269 602T302 589T340 571T382 549T431 522T484 488Q504 475 504 472Q511 449 511 365Q511 248 474 129L468 108L451 96Q427 77 347 28T254 -28Q235 -20 174 21T89 86L88 117"],101:[471,27,472,81,428,"309 69Q391 98 416 108Q418 106 422 100T425 92Q419 86 326 30T229 -27Q228 -27 207 -13T154 27T97 76L85 87L84 106Q81 152 81 194Q81 295 93 359L95 369L286 471L313 449Q376 397 414 372L428 362Q428 360 375 318L188 181V170Q188 156 189 153V148L203 138Q228 119 266 94T309 69ZM209 389Q208 388 204 366T194 307T187 244Q187 225 188 225T201 233L245 261Q283 284 291 291Q324 313 324 316L296 334Q280 343 259 357T224 380L210 390Q209 390 209 389"],102:[687,222,388,35,372,"128 400Q127 401 121 422T108 478T99 540V555L111 569Q135 597 165 626T214 671T235 687L249 678Q263 668 282 659T315 650Q335 650 362 666L372 654L286 569H271Q205 576 173 586V583Q173 558 208 492T252 401Q253 399 310 399T367 398L332 355H254V311Q251 160 235 16Q230 -28 226 -36Q225 -38 221 -45Q171 -140 121 -211L113 -222H104Q94 -222 94 -220Q94 -215 105 -187L121 -145Q139 -80 139 35V93Q139 222 135 314L134 354Q134 355 84 355H35L84 399H106Q128 399 128 400"],103:[472,208,595,17,541,"92 71Q92 74 91 88T88 128T86 183Q86 230 91 275T102 342T109 366Q115 372 207 422T305 472Q407 426 431 426Q435 426 476 445L519 465L525 463L532 461Q497 392 497 268Q496 255 496 233Q496 179 516 92T539 -10L541 -22L526 -38Q441 -126 355 -194L339 -206L327 -207Q324 -207 319 -207T310 -208Q242 -208 171 -179T73 -131L56 -141Q40 -150 38 -150Q17 -140 17 -137Q17 -136 18 -136T98 -79L176 -23Q174 -21 134 24T92 71ZM226 393Q224 393 221 372T214 312T210 235Q210 182 214 144L215 132L230 118Q281 70 301 66Q304 66 331 80T373 105L384 112L383 165Q383 224 387 309Q387 314 387 319T387 329T388 336T388 341V343Q388 344 381 344T339 354T249 384Q246 385 243 386T236 389T231 391T228 392L226 393ZM414 -80Q414 -64 411 -43T403 -1T394 37T386 66T382 79Q381 79 286 15T189 -52Q312 -125 365 -125Q397 -125 405 -115T414 -80"],104:[687,207,615,89,507,"95 661Q95 662 103 667T113 672L126 634L137 596L147 602Q235 656 275 677L292 687L303 680Q305 679 307 677T312 674L313 672L310 670Q307 669 301 667T289 660T274 649T259 634Q250 622 244 611T233 585T226 560T222 528T221 497T220 456T219 413V377L232 384Q244 391 271 409T339 455L362 471L383 461Q425 440 491 415L504 410V406Q507 399 507 269Q507 76 486 -21Q485 -30 483 -33T461 -57Q382 -139 299 -207L281 -197L263 -186L266 -185Q268 -184 280 -177T312 -155Q344 -130 353 -116Q394 -59 394 117Q394 162 391 216T386 301T382 335Q382 338 365 346T323 364T281 376L250 362Q220 347 219 347Q213 336 213 232Q213 177 217 144L218 128L224 119Q244 92 263 71L272 60Q206 21 157 -24Q156 -24 151 -16T132 11T98 52L89 62L91 103Q104 289 104 436Q104 471 103 506T101 568T99 616T96 649L95 661"],105:[686,25,331,3,327,"73 613L164 686L184 666Q200 650 214 637T235 620T242 614T203 577T162 540Q158 540 122 570T73 613ZM92 58Q92 63 94 83T98 142T101 234Q101 318 97 358V366L59 387L40 379L21 371Q20 371 12 376T3 382L38 406Q78 431 125 466L138 477Q149 468 186 444L219 422V389Q215 324 215 247Q215 136 222 123Q226 113 238 98T258 83Q263 83 292 94L322 104Q322 103 324 97T327 89Q327 88 317 82T272 52T190 -7Q166 -25 164 -25L112 35Q92 55 92 58"],106:[682,203,332,-19,238,"74 611L155 682Q172 666 186 655T208 636L235 614Q227 606 191 574L154 540L135 556Q101 582 84 601L74 611ZM10 377L144 477Q145 476 184 453T229 428L233 425V416Q238 346 238 252Q238 93 215 -16L213 -30L185 -57Q29 -203 19 -203Q17 -203 -19 -189L-9 -183Q52 -146 78 -116T114 -37Q120 31 120 192V237Q120 327 113 351T72 380L53 372Q34 362 32 364L10 377"],107:[682,25,464,34,432,"106 72Q110 105 111 193T114 294V308H74L34 309L83 346H115V430Q114 591 106 652Q105 662 107 665T114 668T123 672Q125 672 139 635L152 597L154 598Q156 600 160 602T167 607Q193 625 226 644T279 672T302 682L312 676L321 670L312 665Q281 649 263 626T241 587T233 547Q232 541 231 530T230 510T230 501Q231 501 265 522T334 564T369 583L380 570Q428 509 428 481Q428 475 427 470T423 459T416 448T404 434T389 418T369 397T344 371L321 347L365 346H409L372 308H227V294Q227 272 230 208T234 138Q234 136 256 119T302 84L324 68L372 88Q421 108 422 108T432 90L421 83Q373 53 270 -5L234 -25L204 -1Q172 25 124 60L106 72ZM336 434Q336 452 327 472T308 503T297 514Q296 514 290 510T275 499T264 490Q230 458 230 358V346H247Q268 346 276 350T302 372Q328 398 335 423Q335 424 335 428T336 434"],108:[681,24,337,100,312,"111 275Q111 406 108 518T104 650V657Q105 657 109 660T117 665T122 666L133 629L144 594L161 606Q218 642 272 670L294 681Q295 681 300 677T306 672L302 669Q298 666 292 662T278 651T263 637T251 621Q232 587 227 530T222 343Q222 226 230 125L231 112L244 98L258 83Q271 87 285 92L312 102V84Q297 72 231 24T163 -23L100 55Q110 141 111 275"],109:[476,31,921,16,900,"115 203Q115 257 114 291T112 338T111 355Q111 357 93 370L75 384L54 375Q32 366 31 365Q27 365 16 378Q25 383 89 430L152 476Q175 453 228 420Q229 420 229 418T229 410T227 394L225 369Q279 400 315 425T363 461T376 471Q480 424 514 416V412Q514 411 514 404T513 392L511 376L520 382Q529 387 548 399T584 422Q599 432 618 444T648 463L657 469H658Q661 469 681 461T735 440T796 420Q803 418 803 416Q801 414 798 390T791 325T788 247Q788 220 790 172T794 123Q799 115 814 97T835 78H838Q841 78 867 89L895 101Q896 101 896 100T897 92T900 78L873 62Q810 23 761 -12L736 -30Q735 -30 729 -22T707 7T671 48L661 59Q674 93 674 207V219Q674 341 670 344Q655 353 591 372L576 376L544 364Q511 351 510 351Q507 349 507 224V132L535 95Q541 87 548 78T560 63L563 58Q563 57 504 15T444 -28L385 53L387 67Q396 114 396 206Q396 289 393 334Q393 346 390 348Q369 358 306 373Q301 373 265 361L228 349V335Q227 322 227 284Q227 206 231 157Q231 151 231 144T232 133V129Q232 125 259 90Q286 56 286 53Q287 53 284 51T273 43T258 31L173 -31L166 -20Q160 -11 145 7T119 38T108 59Q108 62 110 81T113 133T115 203"],110:[473,28,654,5,608,"608 88Q572 65 535 37T477 -8T455 -25Q432 7 389 53L375 68L378 82Q386 160 386 195V221Q386 284 385 307L384 344Q352 359 306 373L286 379L213 353V273Q214 229 214 161V129L275 62L163 -28L150 -14Q136 0 121 16T91 44Q86 48 86 50Q95 83 96 148Q96 224 89 340L88 366L79 374Q69 384 67 385L64 388L55 383Q52 382 44 378T33 373L21 367L13 374Q5 379 5 381Q5 384 69 428L133 473Q135 473 147 464T179 443T215 424L214 400V376Q271 404 342 457L363 472Q363 473 364 473Q366 473 375 469T418 449T502 414L512 411V407Q502 330 502 217V197V132L523 109Q527 104 533 97T543 87T547 83L550 80L578 92Q603 103 604 103Q606 103 608 88"],111:[482,35,609,107,515,"107 102Q107 178 112 242T123 334T129 362Q129 363 140 368T199 400T315 469L336 482L346 476Q409 439 498 414L514 410L515 389Q515 208 502 141Q494 101 491 94Q490 89 478 81Q430 51 375 23T288 -20T254 -34Q250 -34 200 -1T119 56L108 65L107 76V102ZM389 355Q367 358 346 363T309 372T282 381T264 388L257 390H256Q254 390 249 381T238 348T227 293Q226 280 226 237Q226 183 231 146L232 131L244 122Q285 91 323 74T374 57H377L380 68Q405 154 405 267Q405 315 401 349V354L389 355"],112:[557,207,604,-1,519,"66 435Q66 445 117 501T173 557Q174 557 183 555T193 551Q174 526 174 509Q174 496 190 472T233 428V386L377 482L399 471Q450 445 509 425Q519 421 519 420L518 419Q518 418 518 416T517 410Q517 405 518 381T519 335Q519 222 501 137Q492 84 489 84L473 75Q457 66 423 44T354 -6L338 -19L329 -13Q320 -8 313 -4T297 4T284 10T270 14T258 17T245 20T233 22V12L241 -161L214 -172Q187 -184 160 -195T131 -207Q127 -207 112 -202L113 -188Q113 -182 115 -77T118 31Q118 32 109 32Q63 27 23 0L10 -9Q5 -4 -1 8Q1 13 52 57T114 101H115L117 123Q117 141 117 230V359L110 367Q85 394 71 421Q66 433 66 435ZM384 83Q386 83 389 110T396 180T400 254Q400 294 395 339L394 349L379 355Q308 383 294 383Q290 383 263 372L234 360L233 245V130Q270 125 305 113T361 92T384 83"],113:[485,211,596,87,515,"362 -196Q375 -92 375 47V78L282 24Q189 -29 188 -30Q187 -30 139 21T90 75Q87 84 87 158Q88 206 94 259T107 342L113 372L308 478L322 473Q374 452 421 444L433 442L503 485Q515 479 515 477Q485 378 485 56Q485 -100 494 -164V-171L381 -211L371 -207L362 -202V-196ZM280 72Q301 77 323 86T358 101T372 110Q372 268 377 346L378 358H374Q368 360 358 360T323 365T257 380L234 386Q231 386 229 379Q215 353 211 310T207 180Q207 152 208 150Q210 142 235 114T280 72"],114:[472,26,460,13,453,"23 367Q21 370 18 374T14 380L13 382L151 472L236 411L238 381L290 426Q298 432 307 439T322 452T333 461T342 467L344 469Q382 410 404 399Q410 397 416 397Q423 397 432 399T446 403L451 405Q453 405 453 399V393Q430 374 404 356T364 328T350 318L349 317Q321 320 276 356Q257 371 256 371Q253 374 249 366T242 351Q232 321 232 236Q232 214 232 205T232 182T233 162T235 148T238 137T242 129T249 120T257 114T268 105T281 95Q313 70 314 70L358 85Q377 92 389 96T402 100V90L403 80L229 -26L221 -18Q195 6 166 29T121 63T105 76T106 82T110 97T114 121T117 158T119 208Q119 269 114 329L113 341L103 350Q90 362 67 380L45 374L23 367"],115:[479,34,523,-24,481,"189 331Q190 304 196 282T207 252T214 244Q239 244 348 292L371 302L382 297Q398 290 415 279T433 265Q442 238 442 166Q442 103 423 45Q416 42 380 29T310 3T244 -26L227 -34Q139 40 73 40Q61 40 48 37T24 30T6 22T-8 14L-13 11Q-14 11 -18 18T-23 26T38 75T102 125Q107 128 146 131H153Q192 131 296 56Q318 40 318 43Q323 48 323 114Q323 157 321 177L319 194Q308 208 291 216T261 225Q239 225 160 185L123 167Q85 205 79 227Q78 230 78 304V377L171 428Q264 479 265 478Q268 478 287 465T334 440T384 427Q423 427 475 463L478 453Q481 446 481 442Q481 439 410 391L339 342H331Q309 345 277 361T222 391T198 406T195 399T191 372T189 331"],116:[648,27,393,43,406,"328 69Q401 102 403 102Q404 102 405 94T406 84Q406 83 318 28L230 -27Q223 -21 206 -5T171 25T132 54L124 60V71Q129 154 129 297V359H43L44 363Q44 365 44 367L45 369L48 372Q51 374 57 378T68 387L90 405H129V553L285 648Q304 641 306 640L260 598V592Q259 589 255 505T249 413V405H353V402Q353 399 328 379L303 360H245V319Q245 150 253 125Q257 115 276 101T311 78T328 69"],117:[472,32,589,9,603,"444 -31Q444 -29 384 66Q382 66 364 58T309 30T231 -17Q214 -29 212 -29L197 -20Q172 -4 140 11T88 34L68 42Q68 43 73 49T85 67T100 98T113 149T118 221Q118 272 105 332L100 356L58 383L23 365L9 379L76 425Q141 472 144 472Q144 471 183 443L221 414V404Q224 365 224 275V253Q224 159 196 113Q191 104 193 104Q203 104 285 72L308 62L374 89L375 106Q375 266 373 340Q373 364 371 396V424L430 445L491 467Q493 467 499 463T505 457Q505 456 503 442Q488 335 488 187V158L529 81L534 80Q541 80 568 90L598 101Q605 94 602 87L524 27Q445 -32 444 -31"],118:[546,27,604,56,507,"95 67Q104 80 104 193Q104 261 100 321L98 355L91 363Q56 402 56 421Q56 441 82 472T132 524T159 546Q174 542 175 542Q159 520 159 501Q159 481 205 432L221 415L220 401Q219 394 219 387L288 429Q309 441 325 451T347 465T358 472T365 476L504 415V409Q504 408 505 374T507 318Q507 155 474 91L469 80L343 26Q314 14 281 0T232 -20L216 -27L202 -15Q192 -5 152 28Q141 35 126 45T103 60T95 67ZM386 349Q302 389 287 389Q271 383 253 375L220 361V136Q226 120 256 100T312 68T342 56Q355 56 360 68Q389 134 389 258Q389 310 386 341V349"],119:[549,32,918,55,815,"90 58T90 59T92 64T97 78T102 105T107 150T109 218Q109 290 103 350V356L83 377Q55 407 55 425Q55 445 138 528Q158 549 162 549L164 548Q165 548 167 548T170 547L175 546L172 540Q168 533 165 523T161 502Q161 479 216 430L229 419V382Q232 382 366 471Q407 445 500 408L511 404V387L512 370L595 420Q678 469 679 469L693 462Q756 431 795 417L815 409L814 380Q812 187 782 96Q774 71 766 62T744 48T684 25T577 -23L557 -32L546 -26Q536 -19 519 -10T481 10T436 31T393 47Q384 50 380 50Q380 52 381 58T384 77T387 104Q391 174 391 256V292L390 333L377 340Q350 357 304 373L294 376L227 355V348Q224 322 224 243Q228 117 232 112L235 108Q238 103 245 95T257 80L281 50Q281 49 227 10T172 -29L159 -13Q133 19 116 36T94 56ZM652 64Q658 64 667 84T685 162T697 303V336L686 341Q653 356 619 367L591 376Q590 376 553 361T514 344T512 324T510 275T508 221Q508 167 510 152T521 126Q537 112 590 88T652 64"],120:[471,188,459,8,441,"8 -90Q8 -68 13 -63Q13 -56 53 -8T120 63L128 71L129 85Q133 120 134 182Q134 308 131 331T106 365Q100 367 97 369L75 381L35 365L20 377Q20 378 47 397T110 440T161 471L253 413V396Q253 378 254 378L309 422Q364 466 365 466Q365 467 366 466T370 461T376 454Q403 419 426 396L441 380L438 377Q438 376 433 372T420 359T404 344L372 314Q351 320 338 327T310 344T277 364Q261 364 252 316Q251 306 251 235Q251 136 255 129Q257 127 258 124T268 113T298 92Q334 68 335 68Q340 70 349 73T377 84T408 95T421 99Q422 99 422 90L423 82L334 26Q246 -28 243 -28L200 8Q156 43 148 43Q144 43 130 36T99 9T83 -36Q83 -67 121 -89T198 -118L237 -124V-129L238 -133L193 -160Q183 -166 171 -173T152 -184L146 -188Q140 -187 131 -185T98 -173T56 -154T23 -127T8 -90"],121:[557,221,589,60,512,"280 53Q272 47 246 27T199 -10T176 -27L167 -18Q137 17 107 44L90 60L93 71Q108 130 109 290V331Q109 339 109 344T108 353T107 359T105 364T102 369T97 374T91 381Q60 412 60 432Q60 448 86 479T138 534L164 557Q168 553 180 553Q163 532 163 511Q165 491 186 468Q206 443 231 423V404L232 385L371 477L389 468Q439 441 498 418L512 412V386Q512 360 507 190T500 14Q488 -26 445 -67Q401 -111 355 -148T282 -203T249 -221Q247 -220 230 -210T213 -199T229 -191T269 -172T306 -151Q361 -120 379 14Q391 92 391 182Q391 218 386 305Q384 339 380 341Q363 353 330 366T288 379Q282 379 258 368L230 356V181V141Q230 127 232 120T236 108T251 89T275 59L280 53"],122:[471,214,461,-7,378,"153 371Q141 371 126 365T100 354T78 340L65 331L57 338L50 346L62 356Q133 419 222 471Q274 453 306 422T338 366Q338 356 329 346T283 301L243 264L262 257Q298 246 361 214Q378 154 378 73Q378 33 371 -9T356 -74T345 -104Q340 -106 267 -160L191 -214H177Q60 -214 13 -150Q-7 -122 -7 -115Q-7 -112 19 -77T106 25T241 149Q241 152 227 158T181 173T109 185V190L108 194L158 229Q212 267 223 278T234 306Q234 329 208 350T153 371ZM258 1Q258 42 257 68T254 105T252 118Q235 105 210 85T144 22T102 -45Q102 -79 146 -106T234 -133H238Q248 -128 254 -80Q258 -58 258 1"]});
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Bold/BasicLatin.js");MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Math-bold-italic"]={directory:"Math/BoldItalic",family:"MathJax_Math",id:"MJMATHBI",weight:"bold",style:"italic",skew:{65:.16,66:.0958,67:.0958,68:.0639,69:.0958,70:.0958,71:.0958,72:.0639,73:.128,74:.192,75:.0639,76:.0319,77:.0958,78:.0958,79:.0958,80:.0958,81:.0958,82:.0958,83:.0958,84:.0958,85:.0319,88:.0958,90:.0958,99:.0639,100:.192,101:.0639,102:.192,103:.0319,104:-.0319,108:.0958,111:.0639,112:.0958,113:.0958,114:.0639,115:.0639,116:.0958,117:.0319,118:.0319,119:.0958,120:.0319,121:.0639,122:.0639,915:.0958,916:.192,920:.0958,923:.192,926:.0958,928:.0639,931:.0958,933:.0639,934:.0958,936:.0639,937:.0958,945:.0319,946:.0958,948:.0639,949:.0958,950:.0958,951:.0639,952:.0958,953:.0639,956:.0319,957:.0319,958:.128,959:.0639,961:.0958,962:.0958,964:.0319,965:.0319,966:.0958,967:.0639,968:.128,977:.0958,981:.0958,1009:.0958,1013:.0639},32:[0,0,250,0,0,""],47:[711,210,894,160,733,"189 -210Q179 -210 170 -203T160 -179Q160 -171 162 -166Q164 -163 420 266T679 698Q686 711 704 711Q714 711 723 704T733 681Q733 672 730 667Q723 654 469 228T211 -201Q202 -210 189 -210"],65:[711,0,869,45,839,"65 0Q45 0 45 18Q48 52 61 60Q65 62 81 62Q155 62 165 74Q166 74 265 228T465 539T569 699Q576 707 583 709T611 711T637 710T649 700Q650 697 695 380L741 63L784 62H827Q839 50 839 45L835 29Q831 9 827 5T806 0Q803 0 790 0T743 1T657 2Q585 2 547 1T504 0Q481 0 481 17Q484 54 497 60Q501 62 541 62Q580 62 580 63Q580 68 573 121T564 179V181H308L271 124Q236 69 236 67T283 62H287Q316 62 316 46Q316 26 307 8Q302 3 295 0L262 1Q242 2 168 2Q119 2 93 1T65 0ZM537 372Q533 402 528 435T521 486T518 504V505Q517 505 433 375L348 244L451 243Q555 243 555 244L537 372"],66:[686,0,866,43,853,"258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 449 686H477H586Q684 686 733 677T817 634Q853 598 853 547Q853 499 826 460T761 401T695 371T654 360H653L662 358Q670 357 683 354T712 344T744 327T774 303T795 269T804 224Q804 148 732 79T533 1Q524 0 288 0H58Q47 5 43 15Q47 54 60 60Q64 62 113 62H162L302 623Q302 624 258 624ZM703 550Q703 571 695 586T675 609T656 619T643 623L545 624H447L417 504Q386 384 386 383T470 382Q554 383 565 385Q632 397 667 447T703 550ZM651 240Q651 265 645 282T626 309T608 322T592 329Q587 330 479 331H373L340 198Q307 65 306 64Q306 62 406 62L507 63L519 65Q565 76 596 107T639 171T651 240"],67:[704,17,817,55,855,"380 -17Q335 -17 293 -10T207 16T130 65T76 144T55 256Q55 306 70 361T122 476T211 582T345 663T525 702H545Q673 702 731 634L777 668Q783 672 789 677T800 685T808 691T814 695T818 698T822 700T825 702T828 703T830 703T833 703Q855 703 855 690Q855 686 823 558T789 426Q786 421 782 420T756 419Q734 420 729 421T724 432Q724 434 725 447T726 472Q726 552 678 604Q640 640 586 640H574Q533 640 494 632T409 604T324 541T260 437Q243 397 227 333T210 219Q210 152 237 117Q255 90 299 68T420 46H429Q506 46 580 100T678 234Q683 249 687 251T712 254H723Q743 254 743 240Q743 232 736 213T710 162T663 100T586 40T477 -5Q433 -17 380 -17"],68:[686,0,938,43,914,"258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 437 686Q659 686 668 685Q727 680 772 662T842 621T883 568T905 517T913 475Q914 466 914 434Q914 373 892 307T828 179T712 69T548 7Q517 2 494 2T279 0H58Q47 5 43 15Q47 54 60 60Q64 62 113 62H162L302 623Q302 624 258 624ZM768 475Q768 515 753 544T718 588T666 611T613 622T563 624H538H532H452L382 344Q311 64 311 63T363 62H405Q490 62 545 76T656 142Q696 185 724 265T760 399T768 475"],69:[680,0,810,43,825,"257 618H231Q198 618 198 636Q202 672 214 678L219 680H811Q817 677 820 673T824 666L825 664Q825 659 814 549T799 433Q793 424 771 424Q752 424 746 427T740 441Q740 445 742 466T744 505Q744 561 722 585T646 616Q639 617 545 618H456Q456 617 427 502T398 385Q398 384 435 384Q461 385 471 385T499 391T526 405T545 433T562 478Q566 494 571 497T595 501H604Q622 501 626 486Q626 482 593 349T557 213Q552 205 530 205Q499 205 499 219Q499 222 503 242T508 281Q508 308 491 314T429 322Q425 322 423 322H382L317 64Q317 62 390 62Q460 62 493 64T569 80T640 124Q665 149 686 187T719 253T733 283Q739 289 760 289Q791 289 791 274Q791 267 763 201T706 71L678 8Q676 4 667 0H58Q47 5 43 15Q47 54 60 60Q64 62 113 62H162L163 66Q163 67 231 341T301 616Q301 618 257 618"],70:[680,0,689,43,809,"257 618H231Q198 618 198 636Q202 672 214 678L219 680H795Q801 677 804 673T808 666L809 664Q809 659 798 549T783 433Q777 424 755 424Q736 424 730 427T724 444Q724 448 725 468T727 507V524Q727 541 724 554T713 577T698 594T676 605T653 612T625 616T597 617T566 618T538 618H456L455 614Q455 611 424 491L394 371H429Q454 372 463 372T491 378T517 392T536 419T552 464Q556 481 561 484T586 488Q603 488 607 486Q616 482 616 473Q616 467 584 337T549 201Q542 192 521 192Q503 192 497 195T490 209Q490 212 492 224Q499 251 499 269Q499 288 489 296T465 306T417 308L379 309L348 188Q341 161 334 129T322 80L318 65L317 62H375H409Q430 62 438 59T447 45Q444 8 431 2L426 0L377 1Q347 2 231 2Q152 2 111 1T65 0Q48 0 43 15Q47 54 60 60Q64 62 113 62H162L163 66Q163 67 231 341T301 616Q301 618 257 618"],71:[704,16,887,56,854,"379 -16Q233 -16 145 52T56 255Q56 310 73 368T127 483T216 586T347 663T518 702H540Q562 702 582 700T616 696T644 689T667 681T686 670T702 659T717 647T731 635L776 668Q782 672 788 677T799 685T807 691T813 695T817 698T821 700T824 702T827 703T829 703T832 703Q854 703 854 690Q854 686 822 558T788 426Q785 421 781 420T755 419Q734 420 729 422T723 432Q723 434 724 446T725 469Q725 531 702 571T642 628Q616 640 575 640Q468 640 390 593T272 464Q247 415 229 340T210 214Q210 166 228 132T277 79T343 54T419 46Q445 46 465 50T500 59T526 76T544 96T557 123T566 150T574 182T581 214H519Q511 214 498 214T479 213Q443 213 443 230Q443 250 452 268Q457 273 464 276L514 275Q546 274 657 274Q735 274 768 275T803 276Q826 276 826 258Q823 224 810 216Q806 214 771 214H736Q736 211 710 109T683 5Q678 0 671 0Q666 0 637 14T597 36Q593 38 590 40T585 44T582 44T576 40Q511 -16 379 -16"],72:[686,0,982,43,1027,"258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 239 686Q290 684 403 684Q475 684 512 685T553 686Q576 686 576 668Q572 632 560 626Q555 624 506 624H457L399 389Q399 388 547 388H695L753 623Q753 624 709 624H686Q665 624 660 626T650 639Q653 678 668 684Q672 686 681 686Q685 686 726 685T847 684Q902 684 937 684T986 685T1004 686Q1027 686 1027 668Q1023 632 1011 626Q1006 624 957 624H908L839 344Q768 64 768 63T812 62H839Q871 62 871 44Q867 6 854 2L850 0L808 1Q782 2 675 2Q600 2 560 1T516 0Q499 0 494 15Q498 54 511 60Q515 62 564 62H613L614 66L679 324Q679 326 531 326H383L382 322L317 64Q317 62 361 62H388Q420 62 420 44Q416 6 403 2L399 0L357 1Q331 2 224 2Q149 2 109 1T65 0Q48 0 43 15Q47 54 60 60Q64 62 113 62H162L302 623Q302 624 258 624"],73:[686,0,511,30,573,"247 624Q242 624 233 624T220 623Q186 623 186 640Q186 647 190 664T202 684Q206 686 226 686Q277 684 393 684Q435 684 471 684T528 685T553 686Q573 686 573 670Q573 650 564 632Q556 624 537 624H501H449L380 344Q309 64 309 63T356 62Q361 62 370 62T384 63Q417 63 417 46Q417 26 408 8Q403 3 396 0L352 1Q325 2 216 2T82 1L45 0Q30 7 30 16Q33 51 46 60Q51 62 102 62H154L294 623Q294 624 247 624"],74:[686,17,631,42,694,"205 131Q205 105 192 84T165 54L152 45Q152 44 160 42T182 37T213 35H216Q255 35 289 65Q314 90 329 129Q331 136 392 378T453 623Q453 624 393 624H332Q318 631 318 640Q318 647 322 664T334 684Q338 686 359 686Q413 684 533 684Q566 684 605 685T652 686Q677 686 685 683T694 669Q694 664 691 652Q686 631 681 628T647 624H602L542 380Q531 336 518 285T500 212T487 161T475 122T463 97T448 74T429 55Q351 -17 213 -17Q142 -17 99 7T43 70Q42 75 42 93Q42 143 73 168T139 194Q168 194 186 177T205 131"],75:[686,1,971,43,1003,"536 0Q522 6 522 18Q522 35 533 57Q539 62 557 62Q595 62 601 65L472 330L365 255L342 160Q318 65 317 64Q317 62 361 62H388Q420 62 420 44Q416 6 403 2L399 0L357 1Q331 2 224 2Q149 2 109 1T65 0Q48 0 43 15Q47 54 60 60Q64 62 113 62H162L302 623Q302 624 258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 239 686Q290 684 403 684Q475 684 512 685T553 686Q576 686 576 668Q572 632 560 626Q555 624 506 624H457L422 481Q386 339 386 337L785 621Q779 624 749 624Q726 624 726 641Q726 645 730 659Q734 675 736 679T747 686L786 685Q812 684 888 684Q908 684 934 685T968 686Q1003 686 1003 669Q1003 646 991 629Q985 624 967 624Q918 624 888 617Q884 617 874 613L865 609Q864 608 732 515T599 420Q599 418 686 242T775 65Q784 62 829 62Q847 62 850 61T860 54Q862 52 862 43Q862 10 845 1Q844 1 842 1T836 0T797 1T694 2Q599 2 573 1L536 0"],76:[686,0,756,43,711,"258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 239 686Q290 684 409 684Q454 684 492 684T552 685T579 686Q603 686 603 668Q599 632 587 626Q583 624 520 624H457L388 344Q317 64 317 63T353 62H390Q418 62 440 64T493 78T548 110T598 169T643 261Q651 282 655 285T680 289Q696 289 700 288T709 279Q711 274 711 269Q710 265 663 138T613 8Q611 4 602 0H58Q47 5 43 15Q47 54 60 60Q64 62 113 62H162L302 623Q302 624 258 624"],77:[686,0,1142,43,1219,"258 624H231Q214 624 208 626T199 639Q203 678 216 684Q220 686 347 686H473Q474 685 478 682T484 677Q487 673 535 413L584 153L608 187Q631 221 672 281T761 410Q935 663 943 671Q949 678 962 686H1082H1166Q1201 686 1210 683T1219 668Q1215 632 1203 626Q1199 624 1149 624H1100L1031 344Q960 64 960 63T1004 62H1031Q1063 62 1063 44Q1060 7 1046 2Q1042 0 1034 0Q1030 0 990 1T875 2Q804 2 767 1T725 0H723Q707 0 703 15Q707 54 720 60Q724 62 773 62H822Q961 618 961 619L754 318Q546 15 543 12Q531 0 510 0Q500 0 495 0T484 5T477 19Q477 20 421 315L367 604L299 335Q234 72 234 68Q234 62 302 62Q334 62 334 46Q332 8 317 2Q313 0 306 0Q301 0 267 1T181 2Q125 2 96 1T63 0Q48 0 43 15Q43 19 47 35Q52 55 57 58T94 62Q147 64 164 69L233 345Q302 619 302 622Q302 624 258 624"],78:[686,0,950,43,1027,"258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 344 686H434Q464 686 477 680Q480 677 607 454Q738 227 739 227Q742 227 789 418T836 618Q836 620 835 620L821 622Q811 622 779 624Q755 624 749 625T740 632Q737 635 737 644Q737 656 742 669T754 685Q755 685 757 685T763 686Q768 686 803 685T890 684Q925 684 951 684T990 685T1006 686Q1014 686 1016 684Q1027 679 1027 668Q1023 632 1011 626Q1007 624 978 624Q912 622 907 617Q907 616 831 314T753 8Q749 0 723 0H712Q699 0 692 7Q692 8 671 44T607 155T526 296L361 580L296 323Q234 74 234 68T302 62H307Q334 62 334 44Q330 6 317 2L313 0L280 1Q260 2 181 2Q125 2 96 1T63 0Q48 0 43 15Q43 19 47 35Q52 55 57 58T94 62Q147 64 164 69L233 345Q302 619 302 622Q302 624 258 624"],79:[703,17,837,53,815,"53 245Q53 297 70 356T125 478T216 590T349 671T523 703Q656 703 735 637T815 445Q815 378 791 307Q727 104 527 17Q437 -17 344 -17Q289 -17 242 -5T150 35T79 116T53 245ZM664 489Q664 575 618 611T511 648Q463 648 416 627T334 570Q297 531 270 472T230 355T213 261T208 206Q208 177 215 151T237 98T284 56T358 40Q440 40 510 98T618 270Q664 400 664 489"],80:[686,0,723,43,847,"162 62L302 623Q302 624 258 624H234Q214 624 209 626T200 638Q200 677 217 684Q220 686 439 686Q667 685 684 682Q686 681 693 680Q713 677 733 671T782 649T829 602T847 528Q847 450 784 382T604 293Q571 288 469 287H373L346 176Q340 151 333 122T321 78L317 64Q317 62 361 62H387Q420 62 420 44Q417 10 404 2L399 0L357 1Q331 2 224 2Q149 2 109 1T65 0Q43 0 43 17Q43 21 47 33Q52 54 57 58T89 62H113H162ZM692 558Q692 611 617 622Q610 623 529 624H452L381 343H458H492Q604 343 641 389Q662 414 677 471T692 558"],81:[703,194,869,52,815,"53 245Q53 297 70 356T125 478T216 590T349 671T523 703Q656 703 735 637T815 445Q815 410 808 370T781 277T729 178T643 87T519 14L525 4Q540 -19 553 -25T592 -32Q632 -32 654 -24T680 -7T689 10T704 18Q713 18 717 12T722 0Q722 -8 711 -36T681 -101T624 -166T541 -194Q513 -194 494 -183T465 -157T450 -118T444 -79T443 -41V-7L433 -9Q391 -17 344 -17Q301 -17 263 -10T185 15T118 62T71 138T53 245ZM666 482Q666 529 652 563T614 615T565 640T512 648Q412 648 335 573Q268 506 235 389T201 202Q201 164 210 136T230 95T259 66L262 76Q269 109 302 135T382 162Q401 162 415 159T449 140T484 92L491 78L496 82Q502 86 505 88T515 97T528 107T541 120T555 137T570 156T585 179T599 205T612 235Q629 278 647 351T666 482ZM439 56Q439 58 439 62T435 75T426 92T410 106T383 112Q353 112 332 96T311 63Q311 38 355 38H366Q391 39 415 45T439 56"],82:[686,17,872,43,881,"258 624H235Q214 624 209 626T199 639Q203 678 216 684Q220 686 422 686H446H525Q634 686 698 674T806 620Q843 583 843 535Q843 505 833 478T805 432T768 396T728 370T690 352T662 342L651 338L654 336Q658 334 667 327T688 310Q719 278 719 237Q719 222 710 165T701 94Q701 35 748 35Q775 35 793 57T819 101Q822 112 826 114T843 117H849Q881 117 881 99Q881 78 852 39T781 -11Q765 -17 728 -17Q537 -13 537 94Q537 110 552 169T567 243Q567 292 529 309Q517 316 508 316T441 318H375L374 314Q374 312 343 189T311 64Q311 62 355 62H382Q414 62 414 44Q410 6 397 2L393 0L351 1Q325 2 221 2Q147 2 108 1T65 0Q48 0 43 15Q47 54 60 60Q64 62 113 62H162L302 623Q302 624 258 624ZM687 555Q687 617 589 623Q581 624 513 624H451L420 498Q413 468 405 436T392 388L388 371Q388 369 458 369Q464 369 485 369T515 369T541 372T570 377T596 386T624 400Q649 417 664 457T683 522T687 555"],83:[703,17,693,63,714,"354 45Q429 45 467 91T506 184Q506 225 477 250Q461 262 384 279T294 300Q238 318 210 362T182 452Q182 493 202 540T257 623Q338 702 449 702Q491 702 501 701Q571 690 610 654Q614 649 617 650Q618 650 650 675T683 702Q685 703 692 703Q714 703 714 690Q714 686 687 578T658 466Q653 458 629 458Q606 458 602 463Q600 465 599 466Q599 467 599 469T598 473Q598 475 599 487T600 511Q600 584 557 614T454 645Q386 645 347 606T308 520Q308 506 311 496T323 477T338 464T360 454T384 446T413 439T441 433Q523 416 549 401Q581 384 602 352Q631 309 631 254Q631 214 615 170T567 83T478 12T347 -16Q322 -16 300 -14T261 -8T230 0T205 10T187 20T172 30L162 37L130 11Q124 7 119 3T110 -4T104 -9T100 -13T96 -15T93 -16T91 -17T88 -17H82Q76 -17 73 -16T69 -14T66 -10T63 -5L90 107Q97 133 106 170Q116 211 120 219T136 228H148Q167 228 173 227T179 218Q179 216 176 200T173 168Q173 102 227 74T354 45"],84:[675,0,637,22,772,"498 62Q511 58 511 43Q511 10 494 1L490 0Q487 0 482 0T424 1T271 2Q201 2 157 2T94 1T72 0H70Q46 0 46 17Q49 54 62 60L66 62H137Q208 62 209 63L218 98Q227 134 244 203T278 339L347 613H300Q262 612 246 611T198 599T146 564Q128 545 114 512T91 454T79 425Q73 419 52 419Q22 419 22 434Q22 440 41 498T80 611L100 666Q105 673 111 675H434Q758 675 762 673Q772 668 772 657Q772 655 756 549T738 434Q735 419 711 419H707Q690 419 686 421Q677 425 677 434Q676 436 678 449T683 485T686 529Q686 553 679 569T662 594T631 607T593 612T544 613H502L433 340Q418 279 400 207T374 100L365 65L364 62H498"],85:[686,16,800,63,877,"856 686Q877 686 877 668Q877 663 873 649T867 631Q861 624 828 624Q762 622 757 617Q757 613 705 409T651 200Q620 112 540 48T328 -16Q251 -16 196 2T113 51T75 112T63 176Q63 202 70 232T117 422Q129 469 141 520T160 598L167 623Q167 624 123 624H96Q79 624 73 626T64 639Q68 678 81 684Q85 686 104 686Q155 684 268 684Q340 684 377 685T418 686Q441 686 441 668Q437 632 425 626Q421 624 371 624H322L270 415Q224 232 217 198T209 141Q209 45 336 45Q372 45 406 52T475 77T540 128T585 211L590 229Q594 247 601 274T617 336T636 409T654 482T670 547T681 595T686 618Q686 620 685 620H683Q681 621 678 621T671 622Q660 622 630 624Q616 624 610 624T598 626T589 630T587 640Q587 647 590 659Q594 677 598 681T613 686Q618 686 653 685T740 684Q775 684 801 684T840 685T856 686"],86:[686,16,678,62,886,"401 686Q415 680 415 668Q415 651 404 629Q398 624 356 624Q318 624 318 623Q318 620 337 508T377 284L397 174L472 285Q548 396 623 507T699 620Q698 621 652 624Q634 624 627 627T619 641Q619 648 622 658Q627 677 631 681T650 686Q654 686 686 685T766 684Q794 684 823 684T858 685Q874 685 878 683T886 671Q886 667 882 651Q877 632 873 628T850 624Q800 624 779 617Q774 617 770 613Q767 610 560 304T350 -5Q346 -9 332 -16H306H291Q270 -16 267 -2Q267 -1 260 37T238 161T210 313L156 624H116H94Q62 624 62 642Q66 678 78 684Q82 686 99 686Q144 684 246 684Q330 684 368 685L401 686"],87:[686,17,1093,61,1207,"111 624Q109 624 102 624T91 623Q61 623 61 640Q61 660 70 678Q78 686 98 686Q140 684 239 684Q277 684 309 684T360 685T383 686H385Q407 686 407 668Q404 634 391 626Q387 624 348 624Q307 624 307 622Q307 618 332 409Q359 198 359 195L570 532L564 576L558 622V624H522H504Q472 624 472 641Q475 678 488 684L493 686L529 685Q551 684 645 684Q716 684 753 685T795 686Q818 686 818 669Q815 632 802 626Q798 624 759 624Q718 624 718 622Q718 615 743 410Q770 199 770 196Q770 195 806 253T903 406Q1035 618 1035 619Q1025 624 968 624Q943 624 943 641Q943 648 946 659Q950 675 952 679T963 686L998 685Q1020 684 1093 684Q1113 684 1139 685T1173 686Q1207 686 1207 669Q1207 664 1204 652Q1199 631 1194 628T1164 624Q1113 622 1101 615Q1098 612 905 305Q715 -1 709 -7Q699 -17 673 -17Q645 -17 639 -8L581 441Q581 444 442 221Q331 44 314 18T288 -14Q279 -17 263 -17H254Q229 -17 227 -5Q225 2 186 311L147 620V624H111"],88:[686,0,947,38,953,"931 686Q953 686 953 670Q953 650 944 632Q936 624 924 624H914Q823 624 803 611Q800 609 696 503T591 396Q591 394 667 229L743 62H787H814Q846 62 846 44Q843 7 829 2Q825 0 817 0Q813 0 775 1T664 2Q590 2 551 1T508 0H507Q484 0 484 18Q484 19 488 37Q492 56 497 58T534 62L566 63Q567 64 520 169T471 274Q469 274 369 172T268 67L315 62Q320 62 328 62L335 61Q347 58 347 44Q344 10 331 2L326 0L287 1Q263 2 177 2Q95 2 78 1L53 0Q38 6 38 17Q38 40 50 57Q56 62 78 62Q169 62 188 75Q194 77 435 324L444 334L439 347Q437 351 373 492L313 624H268H246Q220 624 212 632Q210 636 210 642Q210 655 215 669T227 684Q230 686 247 686Q295 684 398 684Q438 684 472 684T527 685T551 686Q567 686 572 671Q572 667 568 651Q563 631 558 628T523 624T492 623H488L526 540Q563 457 564 457Q564 456 574 466T604 496T645 537L724 619Q716 622 677 624H673Q645 624 645 640Q645 660 654 678Q659 683 666 686L704 685Q728 684 813 684Q847 684 873 684T913 685T931 686"],89:[686,0,675,40,876,"97 624H73Q40 624 40 640Q40 660 49 678Q57 686 77 686Q122 684 228 684Q269 684 304 684T360 685T385 686Q406 686 406 668Q406 662 403 653Q398 631 393 628T361 624H353Q321 624 321 623T376 491T432 360L448 377Q465 394 493 424T553 490L673 620Q662 624 630 624Q606 624 606 640Q608 678 623 684Q627 686 634 686Q638 686 671 685T755 684Q777 684 805 685T841 686Q861 686 868 683T876 669Q876 664 873 652Q868 631 863 628T829 624Q764 622 747 611Q727 590 590 441L437 275L411 170Q385 65 384 64Q384 62 429 62H453Q473 62 478 60T487 48Q488 44 484 29Q479 6 473 3Q468 0 454 0Q450 0 436 0T386 1T294 2Q220 2 181 1T138 0Q121 0 116 15Q120 54 133 60Q137 62 187 62H236L289 275L142 624H97"],90:[686,1,773,68,805,"223 430Q192 430 192 448Q192 450 225 561T261 677Q265 683 270 684Q273 686 534 686Q796 686 797 685Q805 682 805 673Q805 668 804 661T800 648T798 641Q796 637 531 352L266 67L329 66H364Q412 66 446 70T523 96T596 157Q617 186 630 220T649 273T663 297Q667 299 684 299H688Q715 299 715 281Q715 278 673 145T628 8Q626 4 617 0H348Q289 0 221 0T139 -1Q112 -1 99 -1T78 1T69 5T68 12Q68 16 71 31T77 49L84 57Q91 65 104 79T133 110T170 151T213 196L610 624H540Q533 624 514 624T488 624T467 623T443 620T422 616T398 609T373 600Q292 560 255 449Q251 436 246 433T223 430"],97:[452,9,633,38,607,"222 -8Q140 -8 89 34T38 158Q38 191 48 227Q72 329 151 390T327 452Q361 452 385 443T421 425T433 416H434L441 421Q448 426 460 430T486 435Q509 435 523 422T538 386Q538 380 522 315T488 179T467 93Q466 87 466 72Q466 42 483 42Q505 42 521 75Q531 94 541 134Q546 155 550 158T571 162H576H587Q607 162 607 148Q606 142 604 132T590 94T566 47T528 9T474 -8Q396 -8 358 40Q295 -8 222 -8ZM404 351Q383 401 324 401Q300 401 270 385T221 330Q206 296 186 220Q166 136 166 106Q166 72 184 58T228 43Q256 43 284 57T328 84T343 103Q343 106 374 228L404 351"],98:[694,8,521,45,513,"220 -8Q142 -8 94 35T45 155V167Q45 187 52 218T104 426L153 622H149Q148 622 144 622T134 623T122 624T111 624T101 624T96 625Q84 628 84 642Q84 647 88 661T94 679Q98 684 109 685T185 690Q258 694 272 694Q289 694 293 679Q293 676 263 553L232 429L244 434Q256 440 281 446T331 452Q417 452 465 407T513 285Q513 235 494 184T439 90T346 20T220 -8ZM385 337Q385 400 318 400Q269 400 226 360Q214 349 211 341T191 268Q162 149 162 113Q162 44 226 44Q269 44 299 76T339 135T362 215Q364 222 365 226Q385 303 385 337"],99:[451,8,513,40,509,"362 325Q362 344 371 361T390 386L399 394Q390 401 355 401Q276 401 231 338Q207 301 189 230T170 122Q170 43 264 43Q392 43 457 105Q472 120 480 117Q486 114 497 102T509 83Q509 79 502 70T477 47T432 21T360 1T259 -8Q194 -8 148 9T80 54T49 109T40 167Q40 280 129 365T352 451Q390 451 396 450Q448 442 473 416T499 358T477 302T421 274H417Q393 274 378 288T362 325"],100:[694,9,610,38,612,"222 -8Q140 -8 89 34T38 158Q38 220 68 285T151 391Q230 452 329 452Q382 452 416 428L422 424Q423 424 447 523L472 622H468Q467 622 463 622T453 623T441 624T430 624T420 624T415 625Q403 628 403 642Q403 647 407 661T413 679Q417 684 428 685T504 690Q577 694 591 694Q608 694 612 679L467 91Q466 87 466 72Q466 43 483 43Q518 43 541 134Q546 155 550 158T571 162H576H587Q607 162 607 148Q606 142 604 132T590 94T566 47T528 9T474 -8Q396 -8 358 40Q295 -8 222 -8ZM404 351Q383 401 324 401Q300 401 270 385T221 330Q206 296 186 220Q166 136 166 106Q166 72 184 58T228 43Q256 43 284 57T328 84T343 103Q343 106 374 228L404 351"],101:[452,8,554,42,509,"260 -8Q196 -8 151 9T83 54T52 111T42 169Q42 188 44 210Q50 240 58 266Q127 434 335 451L338 452Q342 452 345 452Q347 452 353 452T363 451Q426 451 464 424T502 352Q502 289 442 250Q381 211 222 211H184Q184 210 181 196T175 162T171 126Q171 43 264 43Q391 43 457 105Q472 120 480 117Q486 114 497 102T509 83Q509 79 502 70T477 47T432 21T360 1T260 -8ZM237 262Q427 266 427 349Q427 368 409 384T354 401Q316 401 287 388T242 354T216 314T202 278L197 263Q197 262 237 262"],102:[701,201,568,63,624,"584 444Q597 439 597 426Q597 409 586 387Q580 382 505 382H434V380Q432 378 421 314T395 162T368 30Q324 -164 203 -199Q194 -201 175 -201Q123 -201 94 -177T64 -117T88 -58T145 -33Q169 -33 184 -47T200 -84Q200 -122 166 -150L174 -151H185Q202 -148 217 -112Q222 -94 240 9Q246 40 262 132T293 303T307 382H247H210Q190 382 182 385T173 400Q177 436 189 442Q193 444 256 444H318L319 446Q337 565 355 602Q373 640 404 664T458 694T503 701Q569 701 596 676T624 617Q624 581 599 557T544 533Q520 533 504 547T488 585Q488 596 491 606T499 624T508 637T516 646L520 650Q515 650 509 651Q459 651 459 561V554L458 518L452 484Q446 448 445 447V444H584"],103:[452,202,545,0,540,"227 0Q142 0 93 43T43 166Q43 207 58 252T104 341T188 414T310 451L313 452Q316 452 319 452Q321 452 326 452T335 451Q367 451 390 443T425 425L436 416L443 421Q450 426 462 430T488 435Q511 435 525 422T540 386Q540 378 483 151T424 -82Q401 -139 335 -170T167 -202Q72 -202 36 -183T0 -125Q0 -90 24 -67T81 -43Q103 -43 119 -56T136 -99Q133 -124 114 -149L123 -150H183Q222 -150 254 -127T299 -74Q300 -71 306 -47T318 -1T324 23Q323 23 310 18T274 6T227 0ZM407 353Q406 354 404 358T400 365T395 371T388 379T381 385T371 391T360 396T346 400T329 401Q300 401 277 389T240 355T219 317T205 280Q171 148 171 109Q171 77 190 64T235 51T296 67Q322 82 337 98L345 106L407 353"],104:[694,8,668,45,642,"477 56Q477 48 479 46T490 43Q522 45 544 75T577 140Q582 156 585 159T605 162H611H622Q642 162 642 148Q642 138 632 114T602 62T550 13T478 -8Q429 -8 394 17T358 83Q358 95 395 199T433 350Q433 400 394 400H388H383Q335 400 291 363Q256 332 236 298Q233 293 202 170T169 40Q160 18 141 5T99 -8Q70 -8 58 9T45 39Q45 51 116 336L188 622H184Q183 622 179 622T169 623T157 624T146 624T136 624T131 625Q119 628 119 642Q119 647 123 661T129 679Q133 684 144 685T220 690Q293 694 307 694Q324 694 328 679Q328 672 294 540Q286 507 278 473T264 420L260 403Q260 400 269 408Q327 451 393 451H401H410Q425 451 439 450T476 442T515 424T544 391T556 337Q556 286 517 179T477 56"],105:[694,8,405,24,367,"205 615Q205 646 229 670T283 694Q310 694 324 679T339 641Q339 610 315 586T258 562Q235 562 220 577T205 615ZM24 296Q24 305 34 328T63 380T115 430T187 452Q205 452 223 448T262 435T295 406T308 360Q308 345 287 290T240 170T207 87Q202 67 202 57Q202 42 215 42Q235 42 257 64Q288 92 302 140Q307 156 310 159T330 162H336H347Q367 162 367 148Q367 140 357 117T329 65T276 14T201 -8Q158 -8 121 15T83 84Q83 104 133 229T184 358Q189 376 189 388Q189 402 177 402Q156 402 134 380Q103 352 89 304Q84 288 81 285T61 282H55H44Q24 282 24 296"],106:[694,202,471,-12,456,"321 616Q321 648 346 671T400 694Q425 694 440 680T456 640Q456 609 431 586T376 562Q353 562 337 577T321 616ZM297 360T297 373T294 392T288 400T278 401H276Q241 399 210 372T158 303Q151 287 148 285T129 282H123H116Q102 282 97 284T92 298Q96 331 153 391T279 451Q357 451 388 422T420 354V339L371 142Q363 111 353 71T339 13T329 -30T318 -64T308 -88T296 -109T283 -125T264 -142Q190 -202 88 -202Q44 -202 16 -181T-12 -125Q-12 -93 11 -68T68 -43Q92 -43 108 -58T124 -93Q124 -121 106 -144Q101 -150 103 -150Q120 -150 147 -128T191 -64Q194 -57 242 136T294 345Q297 360 297 373"],107:[694,8,604,45,578,"99 -8Q71 -8 58 9T45 39Q45 51 116 336L188 622H184Q183 622 179 622T169 623T157 624T146 624T136 624T131 625Q119 628 119 642Q119 647 123 661T129 679Q133 684 144 685T220 690Q293 694 307 694Q324 694 328 679Q328 674 280 482Q231 290 231 287Q231 285 234 286Q259 302 294 334T356 390T420 433T493 452Q528 452 546 427T564 364Q564 308 538 282T480 256Q456 256 441 269T425 308Q425 339 444 359T483 384L502 389Q502 395 496 398Q493 400 483 400Q465 400 449 395T409 374T373 347T323 305T268 257Q274 256 282 256Q312 251 329 247T371 232T411 202Q431 181 431 146Q431 132 427 110T422 73Q422 44 440 44H442Q462 44 478 64T502 102T514 141Q518 157 522 159T547 162H558Q578 162 578 148Q578 118 537 56T440 -7H432Q374 -7 337 21T299 94Q299 103 301 116T304 139Q304 164 281 181T235 202L212 206H211Q176 47 160 24Q137 -8 99 -8"],108:[694,9,348,26,296,"157 -8Q138 -8 118 -4T77 11T41 42T27 91V106L156 622H152Q151 622 147 622T137 623T125 624T114 624T104 624T99 625Q87 628 87 642Q87 647 91 661T97 679Q101 684 112 685T188 690Q261 694 275 694Q292 694 296 679L151 91Q150 85 150 71Q150 42 167 42Q186 42 205 75Q216 96 225 134Q230 155 234 158T255 162H260H271Q291 162 291 148Q290 145 289 140T283 118T271 87T254 54T229 23T197 1T157 -8"],109:[453,8,1032,24,1006,"24 296Q25 302 27 312T41 350T65 397T104 435T159 452Q203 452 234 435Q268 419 285 384L295 392Q305 401 317 410T349 429T389 445Q411 451 446 451Q560 451 592 383Q593 380 594 379L595 375L604 384Q675 452 762 452Q893 452 916 367Q918 356 918 334Q918 285 881 183T841 66Q838 43 849 43Q876 43 901 69T940 138Q945 156 949 159T969 162H975H986Q1006 162 1006 148Q1006 138 996 115T966 63T914 13T841 -8Q794 -8 758 16T721 82Q721 96 758 199T796 351Q796 401 753 401Q702 401 662 369T599 298Q597 294 567 172T533 40Q525 22 506 7T462 -8Q435 -8 422 8T409 39Q409 48 425 114T458 248T476 320Q478 330 478 348T474 377T462 393T449 399T433 400H428Q380 400 336 363Q301 332 281 298Q278 293 247 170T214 40Q206 22 187 7T143 -8T104 7T90 39Q90 47 108 124T146 274L164 347Q166 355 166 372Q166 401 149 401Q129 401 115 379T89 306Q84 288 80 285T55 282H44Q24 282 24 296"],110:[453,8,713,24,687,"24 296Q25 302 27 312T41 350T65 397T104 435T159 452Q203 452 234 435Q268 419 285 384L293 391Q363 452 454 452Q575 446 597 367Q599 356 599 334Q599 285 562 183T522 66Q519 43 530 43Q557 43 582 69T621 138Q626 156 630 159T650 162H656H667Q687 162 687 148Q687 138 677 115T647 63T595 13T522 -8Q475 -8 439 16T402 82Q402 96 439 199T477 351Q477 401 434 401Q421 401 409 398Q341 388 285 305L278 295L247 170Q216 46 214 40Q206 22 187 7T143 -8T104 7T90 39Q90 47 108 124T146 274L164 347Q166 355 166 372Q166 401 149 401Q129 401 115 379T89 306Q84 288 80 285T55 282H44Q24 282 24 296"],111:[452,8,585,39,576,"254 -8Q191 -8 146 9T80 54T49 111T39 169Q39 206 53 247T96 329T176 402T292 446Q317 451 336 451L344 452Q353 452 359 452Q457 452 516 408T576 279Q576 169 488 81T254 -8ZM349 400Q321 400 287 385T231 338Q206 301 188 228T170 126Q170 99 178 83Q198 44 260 44Q367 44 409 157Q419 185 432 238T445 317Q445 336 443 348Q435 372 416 384T384 398T349 400"],112:[453,194,601,-23,594,"24 296Q25 302 27 312T41 350T65 397T103 435T157 452Q235 452 273 404Q336 452 409 452Q434 452 458 448T507 432T550 402T581 354T593 285Q593 221 564 159T480 53Q401 -8 302 -8Q290 -8 279 -7T259 -3T242 3T228 9T218 14T212 18L209 20Q208 19 190 -55T171 -131T198 -132H213Q240 -132 240 -150Q237 -187 223 -192Q219 -194 212 -194Q208 -194 176 -193T95 -192Q48 -192 24 -193T-3 -194Q-11 -194 -16 -190T-22 -182T-23 -176Q-20 -142 -7 -134Q-3 -132 20 -132H44L164 354Q165 357 165 372Q165 401 148 401Q113 401 90 310Q85 289 82 286T60 282H55H44Q24 282 24 296ZM465 339Q465 373 447 387T403 401Q375 401 347 387T303 360T288 341Q288 338 257 216L227 93Q248 43 306 43Q332 43 361 59T410 115Q425 147 445 224Q465 309 465 339"],113:[452,194,542,38,550,"38 159Q38 209 58 260T113 355T205 425T327 452Q338 452 348 451T366 449T382 444T394 440T405 434T414 429T422 423T429 418Q440 429 481 440T533 452Q540 452 545 447T550 437Q550 432 481 152Q410 -130 410 -131T437 -132H452Q479 -132 479 -150Q476 -187 462 -192Q458 -194 451 -194Q447 -194 414 -193T330 -192Q277 -192 249 -193T217 -194Q202 -194 197 -179Q197 -175 201 -159Q206 -139 211 -136T243 -132H283L319 15L307 10Q295 4 270 -2T220 -8Q134 -8 86 37T38 159ZM402 353Q402 358 395 368T369 390T324 401Q301 401 282 394T249 369T226 338T208 297T196 258T186 218Q166 141 166 107Q166 44 229 44Q265 44 294 61T337 95Q341 100 371 222T402 353"],114:[452,8,529,24,500,"24 296Q24 298 28 313T42 352T67 398T104 436T154 452Q198 452 230 437T273 404L282 411Q334 452 393 452Q441 452 470 423T500 350Q500 301 473 279T418 256Q395 256 379 270T363 308Q363 366 424 386Q424 388 420 391T405 398T385 401Q363 401 343 390Q321 380 289 341L252 192Q214 42 212 39Q190 -8 142 -8Q117 -8 103 7T89 39Q89 52 127 202T165 369Q165 402 148 402Q139 402 128 393T110 369Q100 348 90 310Q85 289 82 286T60 282H55H44Q24 282 24 296"],115:[451,8,531,57,476,"140 290Q140 311 148 336T176 388T235 433T326 451H336Q355 451 373 449T418 439T460 412T476 363Q476 333 456 311T406 289Q384 289 371 302T357 335Q357 351 364 364T379 384L386 391Q386 392 381 394T362 398T330 400Q299 400 278 393T247 373T235 352T232 335Q232 322 242 312Q258 299 315 290T403 260Q457 224 457 167Q457 152 453 134T435 90T397 43T330 7T229 -8Q133 -8 95 22T57 91Q57 127 81 152T139 177Q161 177 177 164T194 121Q189 80 153 56Q179 43 236 43Q275 43 303 52T343 75T361 101T366 124Q366 148 338 161T272 180T232 186Q187 198 164 227T140 290"],116:[643,8,415,21,387,"82 382H55Q21 382 21 399Q21 422 33 439Q39 444 93 444H144L162 517Q163 522 167 541T174 567T181 589T192 611T206 627T226 639T253 643Q276 643 291 630T306 594Q306 586 288 514Q284 499 280 481T273 454L271 445Q271 444 317 444Q322 444 331 444T345 445Q377 445 377 428Q377 408 368 390Q360 382 341 382H306H255Q182 86 182 75Q182 43 201 43H204Q242 46 279 81Q298 101 309 119T323 145T330 157T350 162H356H363Q377 162 382 160T387 146Q385 136 372 114T337 64T275 14T192 -7Q131 -7 95 19T59 90V105L128 381Q128 382 82 382"],117:[452,9,681,24,655,"189 389Q189 397 187 399T176 401Q150 399 126 372T89 304Q84 288 81 285T61 282H55H44Q24 282 24 296Q24 307 35 331T65 383T117 431T187 452Q237 452 272 427T308 362Q308 347 273 254T238 111Q238 43 291 43Q319 43 344 58T380 86T391 103T426 247T464 396Q472 414 491 429T535 444T574 429T588 397Q588 390 570 315T534 168L516 97Q514 89 514 72Q514 42 531 42Q544 42 556 56Q574 76 589 134Q594 155 598 158T619 162H624H635Q655 162 655 148Q654 142 652 132T638 94T614 47T575 9T520 -8Q509 -8 498 -7T478 -3T461 2T446 8T434 16T424 23T416 29T410 35T406 39L405 41L397 34Q347 -7 288 -7H281Q148 -7 122 78Q116 95 116 125V136Q116 174 152 273T189 389"],118:[453,8,567,24,540,"380 367Q380 397 406 425T465 453Q493 453 516 430T540 357Q540 314 524 250T467 115T373 13Q338 -8 292 -8Q218 -8 167 23T116 129Q116 178 152 275T189 388Q189 396 187 398T176 401Q148 398 125 372T89 304Q84 288 81 285T61 282H55H44Q24 282 24 296Q24 306 34 330T64 382T116 431T189 452Q231 452 269 429T308 362Q308 346 273 255T238 114Q238 43 306 43Q336 43 363 65T407 118T437 182T456 239T462 268Q462 290 417 315Q380 335 380 367"],119:[453,8,831,24,796,"636 367Q636 400 664 426T719 453Q748 453 772 431T796 357Q796 321 782 256T727 112T633 6Q604 -8 567 -8Q466 -8 415 43Q414 42 410 38T403 31T396 25T388 18T378 11T367 5T355 0T340 -4T324 -7T306 -8Q249 -8 209 5T151 40T125 84T117 129Q117 176 153 274T190 388Q190 408 158 396Q112 376 90 306Q85 288 81 285T61 282H55H44Q24 282 24 296Q24 305 34 328T63 380T114 430T187 452Q240 452 274 427T309 362Q309 346 275 255T240 117Q240 43 317 43Q325 43 333 45T347 50T359 57T369 66T377 75T383 83T388 90L390 95Q390 99 389 110T387 129Q387 139 391 167Q393 177 419 282T448 396Q456 414 475 429T519 444Q546 444 559 428T572 397Q572 384 542 265T511 114Q511 43 579 43Q608 43 633 66T673 122T699 188T714 244L718 267Q718 291 673 315Q636 335 636 367"],120:[452,9,659,43,599,"74 282H63Q43 282 43 296Q43 298 45 307T56 332T76 365T110 401T159 433Q200 451 233 451H236Q273 451 282 450Q358 437 382 400L392 410Q434 452 483 452Q538 452 568 421T599 346Q599 303 573 280T517 256Q494 256 478 270T462 308Q462 343 488 367Q501 377 520 385Q520 386 516 389T502 396T480 400T462 398Q429 383 415 341Q354 116 354 80T405 44Q449 44 485 74T535 142Q539 156 542 159T562 162H568H579Q599 162 599 148Q599 135 586 111T550 60T485 12T397 -8Q313 -8 266 35L258 44Q215 -7 161 -7H156Q99 -7 71 25T43 95Q43 143 70 165T125 188Q148 188 164 174T180 136Q180 101 154 77Q141 67 122 59Q124 54 136 49T161 43Q183 43 200 61T226 103Q287 328 287 364T236 400Q200 400 164 377T107 302Q103 288 100 285T80 282H74"],121:[452,202,590,24,587,"206 -150Q240 -150 268 -134T314 -95T344 -48T362 -7T367 14Q339 -7 280 -7Q230 -7 195 5T144 39T122 79T115 122Q115 175 152 274T189 388Q189 396 187 398T176 401Q148 398 125 372T89 304Q84 288 81 285T61 282H55H44Q24 282 24 296Q24 306 34 329T64 381T116 431T188 452Q239 452 273 427T308 361Q308 347 273 253T237 109Q237 43 291 43T388 98Q388 99 425 246T463 396Q471 414 490 429T534 444T573 430T587 399Q587 386 537 186T483 -25Q461 -84 410 -126T296 -188Q248 -202 204 -202Q127 -202 96 -175T64 -114Q64 -82 86 -57T144 -31Q169 -31 184 -45T199 -83Q199 -89 198 -94T196 -104T193 -113T189 -120T184 -128T179 -134T173 -141T168 -147Q189 -150 206 -150"],122:[452,8,555,34,539,"66 -8H60Q34 -8 34 5Q34 9 42 22T70 59T115 110Q162 156 255 229T381 332L389 339H381Q348 332 298 329T212 325T172 321Q168 318 151 318H146Q116 318 116 332Q116 334 118 342Q128 374 154 402Q205 452 265 452Q304 452 352 422T426 392Q441 392 462 421T485 451T508 452H518Q539 452 539 438Q539 431 516 401T458 334Q412 289 312 210Q229 146 191 111L183 103H195Q203 103 213 104T240 107T268 110Q301 114 337 116T391 119T428 123T455 134T469 157Q473 166 495 166Q521 166 525 161Q532 156 528 141Q510 81 456 37T337 -7Q297 -7 251 22T177 52Q154 52 134 38T100 8L88 -7Q86 -8 66 -8"],915:[680,0,657,43,777,"257 618H231Q198 618 198 636Q202 672 214 678L219 680H763Q769 677 772 673T776 666L777 664Q777 659 766 549T751 433Q745 424 723 424Q704 424 699 427T693 441Q693 444 695 467T697 513Q697 543 689 563T670 594T636 610T592 617T534 618H516H456L455 614Q455 613 387 339T317 64Q317 62 375 62H411Q430 62 438 59T447 44Q444 7 430 2Q426 0 416 0Q409 0 359 1T231 2Q152 2 111 1T65 0Q48 0 43 15Q47 54 60 60Q64 62 113 62H162L163 66Q163 67 231 341T301 616Q301 618 257 618"],916:[711,0,958,59,904,"65 0Q59 6 59 9T61 16Q64 20 334 357T608 698Q616 706 629 710Q630 710 634 710T644 710T656 711Q686 711 694 703Q698 699 700 693Q706 674 805 345T904 14Q904 7 894 1L479 0H65ZM630 342L567 551L232 134L462 133H693Q693 137 630 342"],920:[702,17,867,54,844,"358 -17Q218 -17 136 49T54 243Q54 298 70 356T123 474T211 582T338 663T504 702H527Q578 702 590 701Q709 688 776 622T844 441Q844 379 825 315T765 192T668 86T532 11T358 -17ZM700 474Q700 525 685 561T642 616T587 643T528 652Q390 652 301 534Q252 472 225 373T198 210Q198 160 214 125T256 71T311 44T372 36Q484 36 571 119Q639 189 669 299T700 474ZM366 428Q366 425 364 419T362 411H466L570 412L573 422Q576 437 581 441T604 445Q620 445 623 444Q636 440 636 429Q636 423 616 340T593 253Q586 243 572 243H566Q545 243 539 249Q536 251 535 253T534 258T534 263T535 270T537 277H329L326 266Q323 251 318 247T295 243Q279 243 276 244Q263 248 263 259Q263 265 283 346Q288 366 295 394Q304 431 308 438T326 445H334H338Q366 445 366 428"],923:[711,0,806,44,776,"439 0Q425 6 425 18Q425 35 436 57Q442 62 485 62Q525 62 525 64L478 483Q478 484 465 463T422 394T350 277Q222 69 222 68Q223 67 224 67Q229 64 271 62Q290 62 297 59T305 45Q305 38 302 28Q297 9 293 5T274 0Q270 0 238 1T159 2Q133 2 105 2T72 1Q56 1 52 3T44 15Q44 19 48 35Q53 55 58 58T89 62Q142 64 151 73Q154 76 345 387T538 699Q550 711 570 711H580H592Q613 711 618 695Q619 692 654 379T690 63Q690 62 726 62H746Q776 62 776 44Q773 7 759 2Q755 0 747 0Q743 0 707 1T600 2Q502 2 476 1L439 0"],926:[675,0,841,62,867,"206 466Q175 466 175 484Q175 487 201 574T230 666Q235 673 241 675H547Q853 675 857 673Q867 668 867 657Q867 655 850 569T832 478Q827 466 808 466H802H795Q773 466 771 481Q771 486 775 508T779 541V549H774Q755 552 505 552Q281 551 267 548Q262 548 255 533T242 496T233 472Q228 466 206 466ZM259 255H252Q231 255 228 270Q228 275 248 355T270 439Q277 448 288 448H298Q321 448 326 440Q331 434 326 414Q326 413 486 413H647L650 424Q654 441 658 444T678 448H683H693Q702 448 705 446T714 432L694 348Q674 267 669 261Q664 255 652 255H643Q622 255 617 261Q613 265 613 272T613 283T616 289Q616 290 456 290H295L294 285Q293 280 292 275T288 265T281 257Q278 255 259 255ZM150 131Q150 124 281 123Q346 123 390 123Q640 123 664 126Q668 127 675 127Q686 131 704 198Q708 213 713 216T733 220H738Q755 220 759 218Q768 213 768 203Q768 198 741 105T710 8Q708 4 699 0H388Q77 0 73 2Q62 7 62 18Q62 27 81 115Q99 206 102 212Q106 220 120 220H129Q140 220 145 220T155 215T160 202Q160 196 159 192Q150 145 150 131"],928:[680,0,982,43,1026,"257 618H231Q198 618 198 636Q202 672 214 678L219 680H1011Q1022 675 1026 665Q1022 626 1009 620Q1005 618 956 618H907L906 614Q906 613 838 339T768 64Q768 62 812 62H839Q871 62 871 44Q867 6 854 2L850 0L808 1Q782 2 675 2Q600 2 560 1T516 0Q499 0 494 15Q498 54 511 60Q515 62 564 62H613L614 66Q614 67 682 341T752 616Q752 618 604 618H456L455 614Q455 613 387 339T317 64Q317 62 361 62H388Q420 62 420 44Q416 6 403 2L399 0L357 1Q331 2 224 2Q149 2 109 1T65 0Q48 0 43 15Q47 54 60 60Q64 62 113 62H162L163 66Q163 67 231 341T301 616Q301 618 257 618"],931:[686,0,885,69,902,"847 430Q828 430 823 434T817 450Q817 454 817 466T818 487Q818 526 809 551T784 591T737 613T675 622T590 624H528H430L513 487Q594 351 596 345Q596 335 590 330Q583 323 418 204L250 81L363 80Q533 80 591 89T694 142Q739 185 765 252Q772 268 776 271T799 274Q816 274 820 272Q832 266 830 254Q829 250 784 130T736 7Q732 3 725 0H405Q84 0 80 2Q69 7 69 18Q69 26 75 32Q76 32 98 48T168 100T255 164L432 293Q429 300 329 465T225 637Q223 675 245 686H888Q900 680 902 671Q902 667 890 556T876 441Q871 430 847 430"],933:[703,0,671,32,802,"32 544Q32 586 91 644T229 703Q277 703 311 683T363 628T389 560T397 491V478L404 491Q455 589 526 646T677 703Q730 703 766 671T802 584Q802 551 793 541T766 531H757L736 532L732 535L729 539V549Q731 569 715 575T658 581H650Q545 581 477 443Q453 392 443 351Q441 345 424 273T389 133T371 64Q371 62 428 62H461Q483 62 492 59T501 44Q498 10 485 2L480 0L431 1Q401 2 278 2T127 1L85 0Q71 5 71 17Q71 24 74 33Q77 46 78 49T84 57T95 61T118 62H154H216Q232 126 249 193T273 287T287 345T296 388T299 416T300 452Q294 581 198 581Q154 581 132 575T106 562T99 546T86 533Q82 531 60 531L39 532Q32 537 32 544"],934:[686,0,767,29,737,"323 624H293Q267 624 261 626T251 639Q255 678 268 684Q272 686 293 686Q348 684 475 684Q557 684 600 685T647 686H648Q671 686 671 668Q667 632 655 626Q650 624 588 624H525L500 520Q500 519 520 518T579 507T656 480Q737 440 737 372Q737 294 648 237Q562 180 426 169L412 168L399 118Q386 66 386 65L385 62H443H479Q498 62 506 59T515 44Q511 8 499 2L494 0L447 1Q417 2 298 2Q212 2 167 1T118 0Q100 0 95 15Q99 54 112 60Q116 62 179 62H241Q242 64 254 114T266 167Q266 168 262 168Q256 168 237 170T180 181T110 205T54 249T29 316Q29 391 112 446T327 516Q345 518 349 518Q351 518 353 518L355 519Q356 520 368 570T381 623Q381 624 323 624ZM342 466Q341 467 339 467Q320 467 283 455T225 420Q181 361 181 296Q181 273 193 257T222 233T254 222T277 219L280 220Q281 220 311 342T342 466ZM583 389Q583 409 576 423T557 444T533 456T509 463T492 467H486L455 343Q444 300 437 271T428 231T426 219Q430 219 445 222T483 232T521 250Q551 269 567 310T583 389"],936:[686,0,714,22,790,"205 471Q205 445 196 403T186 333Q186 303 194 281T218 248T240 233T262 224L361 623Q361 624 303 624Q296 624 284 624T266 623Q232 623 232 641Q232 648 235 657Q240 678 244 682T268 686H273Q329 684 457 684Q502 684 540 684T599 685T626 686H628Q651 686 651 668Q649 633 631 624H505L407 227Q410 228 416 229T439 239T472 259T507 294T539 345Q549 365 563 416T597 498T649 538Q657 540 717 540Q725 540 737 540T755 541Q790 541 790 524Q790 512 784 497Q780 491 767 490T742 477Q736 471 731 463T722 449T715 433T710 419T705 403T701 389Q686 340 658 302T599 240T530 201T463 179T404 169L391 168L379 116Q365 67 365 63Q365 62 422 62H455Q477 62 486 59T495 44Q492 10 479 2L474 0L427 1Q397 2 278 2T131 1L90 0Q76 5 76 17Q76 24 79 33Q82 46 83 49T89 57T100 61T123 62H159H221Q247 162 247 168H244Q241 169 239 169Q202 176 178 182T123 207T74 252Q46 291 46 351Q46 375 52 404T59 454Q59 489 40 489Q32 489 27 494T22 507Q22 535 37 538Q40 540 99 540H128Q168 540 186 528T205 471"],937:[703,0,879,93,887,"162 119Q181 115 235 115L273 116Q273 133 231 222T180 345Q173 368 173 391V406V414Q173 477 214 540Q255 600 315 635Q353 661 423 682T585 703Q656 703 711 690T799 656T851 608T879 555T886 503Q886 449 860 401Q840 359 810 322T725 230T643 146Q619 117 619 116T650 115Q707 115 722 120Q730 123 750 165T775 210Q779 212 796 212Q828 212 828 196Q828 191 807 144T764 52L743 7Q740 4 740 4T733 2T717 0T686 0H632H573Q535 0 526 3T517 17Q517 44 544 103T617 243T671 341Q729 454 729 535Q729 599 686 625T583 652Q549 652 517 645T450 616T388 561T344 470T327 340Q327 304 331 237T336 135Q336 93 330 50T313 2Q308 0 208 0H142Q107 0 100 4T93 25Q93 28 93 41T95 77T96 118L100 199Q105 208 109 210T131 212Q147 212 151 210T161 199V160Q161 131 162 125V119"],945:[452,8,761,39,712,"39 166Q39 213 59 261T117 353T219 424T362 452Q420 452 466 433T536 384T573 325T586 269V265Q593 272 609 308T636 381Q640 397 644 399T669 402H680Q700 402 700 388Q700 379 691 351T659 276T604 188L593 173L595 153Q600 79 612 43H618Q634 45 642 51T653 64T658 71Q661 73 684 73Q712 73 712 59Q712 39 685 16T603 -7Q588 -7 575 -5T551 2T532 12T516 24T503 37T494 49T487 60T481 69L469 61Q362 -8 251 -8Q159 -8 99 36T39 166ZM260 43Q310 43 361 63T438 101T465 124Q458 240 453 277Q435 401 354 401Q291 401 245 355Q230 337 217 313Q201 279 186 216T170 126Q170 72 208 54Q230 43 260 43"],946:[701,194,660,28,638,"59 -194H49Q31 -194 28 -182Q28 -178 107 139T192 473Q212 533 248 580T324 652T395 689T450 701H461Q514 701 551 688T605 652T630 607T637 561Q637 546 634 526T611 465T556 393Q572 382 590 347T608 262Q608 146 522 69T299 -8Q279 -8 261 -6T228 2T204 13T183 26T169 37T157 48L150 56L120 -64Q113 -90 104 -128Q93 -175 89 -184T73 -194H59ZM531 592Q531 651 463 651Q399 651 341 600T253 466Q250 458 217 327T182 185Q180 176 180 159Q180 108 212 76T301 44Q330 44 354 51T393 65T423 91T444 118T459 151T468 179T475 206Q490 264 491 296Q491 313 489 326T484 345L482 350Q481 350 477 348T464 344T444 340T413 335T372 333T334 334T301 340T274 355T265 380Q265 444 397 444Q425 444 445 441T476 436L485 433Q489 433 499 458Q509 482 520 527T531 592ZM424 390Q424 393 389 393Q383 393 374 393T362 392Q348 392 333 388Q345 384 379 384Q424 384 424 390"],947:[451,211,590,5,617,"5 269Q5 285 19 312T57 368T124 421T215 451H241Q274 451 303 439T353 406T389 361T416 311T432 266T442 232L444 220L446 216L450 226Q473 278 513 357T561 441Q566 444 584 444H594Q617 444 617 430Q617 426 596 389T536 273T462 110L452 84L451 70Q447 12 427 -76T388 -192Q375 -211 355 -211Q339 -211 332 -198T325 -171Q325 -114 386 64L393 84V98Q393 181 371 241Q360 280 319 303T210 327Q158 327 126 317T84 296T68 272T59 258Q55 256 36 256Q23 256 18 256T9 260T5 269"],948:[726,8,522,39,513,"216 610Q216 640 229 664T262 700T299 719T327 725Q330 725 406 709T487 690Q513 681 513 651Q513 627 494 607T450 587Q417 587 378 631Q346 663 314 663Q286 663 272 639Q271 637 271 634Q271 609 344 536L397 484Q438 448 458 410T478 313Q478 234 443 147T338 18Q298 -8 249 -8Q214 -8 180 0T113 26T60 81T39 168Q39 200 50 237T87 316T160 391T272 442L260 465Q216 553 216 610ZM348 235Q348 274 336 313T310 372L298 392Q295 391 290 390T269 380T241 359T212 323T185 267Q157 168 157 130Q157 83 186 63T255 43Q280 43 300 67Q317 89 332 138T348 235"],949:[461,18,529,36,481,"224 -17Q126 -17 81 22T36 112Q36 178 84 226L93 236L88 246Q79 264 79 289Q79 341 124 388Q201 461 333 461Q402 461 455 425Q480 409 481 390Q481 365 464 350T428 334Q415 334 387 352T313 370Q141 370 141 293Q141 275 146 270Q147 270 148 270T155 272Q202 291 263 291H270Q349 291 349 244Q349 195 281 183Q274 182 239 182Q201 182 184 185T137 200Q123 188 112 168T100 129T112 98T148 81T189 75T237 74H243H251Q288 74 310 75T359 86T398 112Q405 124 417 124Q426 124 432 117T439 100Q439 88 427 70T390 32T322 -3T224 -17ZM286 238Q286 240 253 240Q245 240 234 239T216 237T209 235Q209 232 250 232Q286 232 286 238"],950:[711,202,508,48,521,"361 711Q373 711 381 703T389 683Q389 681 388 676T383 656T376 618V612H379Q385 618 429 618Q521 618 521 572Q521 551 506 534Q483 510 415 507Q385 507 371 511T336 536L326 528Q254 472 204 381T154 209Q154 190 157 177Q159 165 162 154T170 135T182 119T195 106T212 95T229 86T249 78T269 72T290 66T311 60Q385 37 388 36Q437 14 454 -36Q456 -46 456 -64Q456 -83 455 -90Q445 -132 413 -167T333 -202Q300 -202 257 -191T206 -169Q203 -164 203 -158Q203 -148 210 -140T231 -130Q239 -130 263 -139T326 -151H329Q337 -151 342 -150T352 -143T357 -123Q356 -117 355 -113T350 -104T344 -96T335 -90T324 -85T310 -80T294 -74T275 -68T254 -62Q253 -62 231 -56T205 -48T179 -39T150 -26T125 -10T100 11T80 37T62 70T53 109T48 157Q48 281 123 396T317 586V612Q319 638 320 649T325 678T338 703T361 711ZM454 564Q445 567 424 567Q407 567 398 565T387 563Q387 558 411 558Q434 558 450 562L454 564"],951:[453,211,600,24,600,"24 296Q25 302 27 312T41 350T65 397T103 435T157 452Q202 452 233 435Q267 419 284 384L294 392Q304 401 316 410T348 429T388 445Q410 451 445 451H453Q468 451 482 450T519 443T558 425T587 391T600 337V327Q600 311 538 64Q484 -158 478 -168Q457 -211 409 -211Q386 -211 372 -197T357 -161Q357 -158 415 80Q476 330 477 348Q477 366 473 377T461 393T448 399T432 400H427Q379 400 335 363Q300 332 280 298Q277 293 246 170T213 40Q205 22 186 7T142 -8T103 7T89 39Q89 49 106 117T142 260T164 351Q166 363 166 372Q166 402 148 402Q126 402 110 369Q100 350 90 310Q85 289 82 286T60 282H55H44Q24 282 24 296"],952:[702,8,562,40,554,"213 -8Q130 -8 85 50T40 200V207Q40 303 83 428Q122 535 189 608Q279 702 381 702Q410 702 437 693T492 661T537 593T554 486Q554 428 539 362T495 230T425 111T330 25T213 -8ZM433 562Q433 600 419 625T377 651Q363 651 348 644T311 619T268 557T229 453Q225 441 217 411T208 378H401Q433 500 433 562ZM161 140Q161 43 217 43Q249 43 280 74Q310 103 332 150T378 287Q385 313 385 315Q385 316 289 316H192Q191 308 183 275T169 205T161 140"],953:[452,8,412,38,386,"161 -8Q111 -8 75 16T38 85Q38 95 48 121T80 214T123 368L124 374Q126 381 127 386T132 399T139 414T149 428T162 440T180 448T203 452Q226 452 241 439T257 404Q257 386 230 290T171 111Q157 73 157 57Q157 43 166 43Q209 43 258 69T322 144Q326 157 330 159T348 162H355H366Q386 162 386 148Q386 143 383 132T367 100T335 61Q301 27 253 10T161 -8"],954:[452,8,668,45,642,"258 405Q258 394 251 364T237 308T230 281T238 284T270 306T330 349Q365 377 389 394T450 427T519 444Q545 444 559 430T574 391Q574 360 551 336T491 312Q469 312 454 326T439 364Q439 372 438 372Q433 372 395 344T320 289T283 260H285Q287 260 290 260T297 259Q495 248 495 146Q495 132 491 110T486 74Q486 43 505 43Q520 43 531 53Q559 72 578 141Q582 157 586 159T611 162H622Q642 162 642 148T627 100T578 29T504 -7H495Q435 -7 399 22T363 96Q363 111 366 122T369 142Q369 155 364 165T347 182T326 193T298 200T269 204T238 207T212 210L211 206L190 123L169 40Q161 22 142 7T98 -8T59 7T45 39Q45 48 67 139T112 317L134 404Q142 424 161 438T204 452Q226 452 242 440T258 405"],955:[694,13,671,40,652,"95 -13Q70 -13 55 4T40 41Q40 65 61 88Q65 92 210 207T357 322L235 602Q217 640 185 643Q182 643 178 644T173 645Q161 651 161 666Q161 677 167 684T181 692Q189 694 212 694Q335 694 358 660Q362 653 500 340T647 18Q652 10 652 6Q652 -8 622 -8H589H538L526 -5Q506 1 500 8Q494 16 444 128Q442 133 440 138L387 259L265 134Q156 20 137 4T95 -13"],956:[452,211,708,34,682,"294 -8Q265 -8 244 -5T213 1T201 4Q200 4 192 -32T172 -111T155 -168Q134 -211 86 -211Q62 -211 48 -196T34 -158Q37 -144 103 123T174 404Q182 424 201 438T244 452Q271 452 284 436T298 404Q298 392 267 269T235 114Q235 43 305 43Q342 43 375 68T418 110Q420 112 455 253T492 397Q514 444 562 444Q587 444 601 429T615 397Q615 387 599 320T563 178T542 93Q540 81 540 72Q540 42 558 42Q580 42 596 75Q606 94 616 134Q621 155 624 158T646 162H651H662Q682 162 682 148Q681 142 679 132T665 94T641 47T602 9T548 -8Q523 -8 502 -3T468 11T446 27T432 40L429 46Q367 -8 294 -8"],957:[452,2,577,38,608,"88 382Q70 382 65 385T59 402T64 427T78 443Q79 444 157 448T247 452Q256 452 261 448T266 440L267 437Q267 432 223 252L177 71L192 77Q293 117 371 199T480 388Q489 424 511 438T556 452Q579 452 593 438T608 402Q608 378 593 340T540 251T446 152T299 62T96 -1Q91 -2 78 -2Q38 -2 38 15Q38 22 82 198L127 379Q124 382 88 382"],958:[711,201,508,23,490,"287 648Q291 671 293 680T305 700T329 711Q339 711 347 705T356 687Q356 680 351 653T345 619Q345 615 346 615Q358 618 398 618Q490 618 490 572Q490 553 476 536T434 512Q411 508 378 508H366Q332 508 306 534L298 525Q271 496 254 456T237 375Q237 336 244 336Q272 346 319 346H325Q354 346 372 344T406 331T422 300Q422 252 350 238Q332 236 303 236Q286 236 269 238T240 242T218 247T202 252L196 254Q191 254 174 237T141 191T124 139Q124 108 151 92T267 46Q285 40 295 37Q308 33 332 25T366 13T392 3T415 -8T432 -20T445 -36T451 -55T454 -80Q454 -118 427 -153T358 -199Q349 -201 327 -201Q313 -201 298 -200T271 -196T246 -191T226 -185T210 -180T200 -176L196 -174Q187 -170 187 -158T196 -138T216 -130Q217 -130 254 -140T329 -151Q349 -151 349 -135Q349 -127 340 -122T293 -104Q260 -93 238 -85Q130 -48 115 -41Q71 -19 47 15T23 88Q23 126 48 179T130 277L144 288L136 297Q99 336 99 390Q99 456 148 514T285 602V619Q285 624 286 635T287 648ZM355 563Q362 560 376 558Q424 558 423 564Q405 567 390 567Q369 567 355 563ZM279 292Q297 287 315 287Q355 287 355 293Q355 296 321 296Q316 296 308 296L301 295Q295 295 289 294L279 292"],959:[452,8,585,39,576,"254 -8Q191 -8 146 9T80 54T49 111T39 169Q39 206 53 247T96 329T176 402T292 446Q317 451 336 451L344 452Q353 452 359 452Q457 452 516 408T576 279Q576 169 488 81T254 -8ZM349 400Q321 400 287 385T231 338Q206 301 188 228T170 126Q170 99 178 83Q198 44 260 44Q367 44 409 157Q419 185 432 238T445 317Q445 336 443 348Q435 372 416 384T384 398T349 400"],960:[444,8,682,23,674,"55 289H43Q23 289 23 303Q23 308 33 322Q116 434 199 443Q200 444 418 444Q591 444 617 444T652 439Q674 426 674 400Q674 378 661 360T625 335Q621 334 549 333H479L477 321Q476 312 476 279Q476 219 491 174T521 104T536 65Q536 38 511 15T457 -8Q403 -8 386 94Q384 110 384 139Q384 181 391 229T406 304L413 331Q413 333 365 333H316L315 329Q315 328 312 314T301 272T288 220Q274 167 258 103Q244 49 240 38T228 18Q225 16 224 14Q200 -8 172 -8Q146 -8 132 7T118 44Q118 54 121 61Q122 65 142 102T190 195T235 293Q250 329 250 333Q177 333 166 332Q115 328 88 301L77 290L55 289"],961:[451,211,612,34,603,"307 -8Q277 -8 251 0T215 14L205 20Q203 18 193 -25T171 -114T155 -168Q134 -211 87 -211Q64 -211 49 -198T34 -162Q34 -158 137 254Q153 299 179 334T232 390T277 419T311 434Q357 451 403 451Q435 451 455 449T506 435T560 400Q603 357 603 285Q603 172 520 82T307 -8ZM474 343Q474 364 458 382T409 400H406Q339 400 299 341Q281 313 264 257Q261 248 242 170T222 89Q222 84 230 74T260 54T308 43Q334 43 365 57T417 110Q437 145 456 228Q474 298 474 332V343"],962:[451,105,424,33,457,"33 209Q33 277 80 334T195 421T330 451H344Q410 451 439 429Q457 417 457 402Q457 386 445 375T420 363Q415 363 406 368T383 383T354 398Q347 400 330 400Q256 400 196 361T135 265V257Q135 242 147 225T174 199L358 107Q400 77 400 28T362 -63T271 -105Q254 -105 229 -99T195 -86Q188 -82 188 -71Q188 -56 197 -50T216 -44Q225 -44 237 -48T270 -53H282Q293 -44 293 -31Q293 -19 283 -10Q278 -4 200 33T115 76Q77 98 55 133T33 209"],963:[445,8,686,35,677,"35 151Q35 190 51 236T99 327T184 404T306 443Q307 443 316 443T342 443T378 444T425 444T476 444Q606 444 626 444T655 439Q677 426 677 400Q677 358 639 340Q625 333 563 333Q510 333 510 331Q518 319 518 272Q518 155 437 74T226 -8Q123 -8 79 41T35 151ZM396 278Q396 314 375 323T305 332Q249 332 222 310T180 243Q171 219 162 178T153 116V110Q153 43 234 43Q347 43 382 199Q383 203 383 204Q396 255 396 278"],964:[444,13,521,23,610,"55 289H43Q23 289 23 303Q23 308 33 322Q116 434 199 443Q200 444 386 444Q571 444 577 442Q588 441 599 432T610 402Q610 359 572 340Q561 335 547 334T452 333H353V331Q352 330 342 261T320 119T306 40Q300 18 281 3Q257 -13 233 -13Q210 -13 196 0T181 35Q181 44 182 48Q183 53 229 187T279 331Q279 333 228 333H209Q163 333 136 328T88 301L77 290L55 289"],965:[453,9,631,24,604,"189 388Q189 396 187 398T176 401Q144 399 122 369T89 304Q84 288 81 285T61 282H55H44Q24 282 24 296Q24 306 34 330T64 382T116 431T188 452Q232 452 270 430T308 361Q308 345 275 258T241 123Q241 44 336 44H344Q380 44 415 73T474 140T511 214T526 267Q526 280 513 292Q505 301 486 311T456 333T444 367Q444 400 471 426T529 453Q555 453 579 431T604 358Q604 327 592 271T557 172Q550 157 541 142T510 97T464 47T404 9T328 -8Q264 -8 219 5T154 41T125 85T117 131Q117 182 153 277T189 388"],966:[452,216,747,52,703,"238 4Q230 5 218 8T174 26T118 58T73 112T53 190Q53 219 60 246Q77 313 103 362T143 426T163 443Q165 444 186 444Q217 444 217 432Q217 425 188 392Q157 351 137 291T116 206Q116 127 263 109L276 107L288 139Q347 304 414 378T566 452Q621 449 662 412T703 286Q698 167 598 82T357 -8H332V-11Q332 -12 327 -46T317 -116T310 -157Q306 -180 286 -198T234 -216Q211 -216 197 -203T183 -168Q183 -160 184 -155Q184 -152 198 -112T225 -34T238 4ZM637 260Q637 303 607 322T541 341Q502 341 466 319T405 264Q368 218 356 159Q348 111 348 104Q348 103 361 103Q502 103 569 152T637 260"],967:[452,201,718,32,685,"58 -194Q32 -194 32 -164Q32 -153 46 -139L175 -13Q296 104 296 106Q271 232 226 308Q165 401 141 401Q128 401 117 390T100 365Q94 350 91 349T69 346H45Q35 348 35 359Q35 380 62 411T133 450Q143 452 165 452Q286 452 329 402Q347 379 366 333T394 254T404 215Q404 213 405 213Q405 212 420 227T463 268T520 324Q637 437 640 438Q647 444 661 444Q667 444 676 438T685 419Q685 405 670 389T549 271L420 145Q433 85 444 53Q466 -25 509 -88T575 -151Q590 -151 600 -140T617 -114T626 -98Q629 -96 650 -96H655Q681 -96 681 -108Q681 -114 679 -119Q670 -148 646 -169T591 -199Q581 -201 550 -201Q422 -201 381 -143Q345 -88 316 20L311 39L230 -40Q144 -126 114 -153Q85 -182 77 -188T58 -194"],968:[695,202,758,24,732,"244 141Q244 117 254 98T277 70T305 55T329 48T342 47L344 48L424 366Q501 678 505 686Q508 691 512 692T533 694T555 693T562 688T565 683Q565 678 486 362T406 45Q406 43 415 43Q467 49 514 78T590 143T636 213T653 266Q653 282 641 293T613 311T585 332T572 367Q572 397 598 425T657 453Q684 453 708 430T732 358Q732 330 723 287T706 225Q671 124 578 58T401 -8H393L370 -101Q346 -196 345 -197Q340 -202 316 -202H306Q286 -202 286 -188Q286 -187 296 -144T318 -57T331 -8Q331 -6 328 -6Q290 -6 233 11T148 62Q119 97 119 146Q119 181 154 275T190 388Q190 401 181 401Q154 401 129 375T90 306Q85 288 81 285T61 282H55H44Q24 282 24 296Q24 306 34 329T64 381T116 431T189 452Q237 452 273 428T309 362Q309 343 277 260T244 141"],969:[453,8,718,24,691,"532 367Q532 399 559 426T618 453Q645 453 668 430T691 357Q691 319 677 261T649 171Q640 149 626 125T586 68T521 14T438 -7Q401 -7 372 7T333 30T311 57Q246 -8 165 -8Q119 -8 82 19T30 102Q24 126 24 163V178Q24 210 37 255Q61 346 118 424Q141 451 161 451Q174 451 184 443T194 419Q194 402 179 387Q91 273 91 206Q91 159 122 138T189 117T281 145V173Q283 223 294 253Q304 276 323 289T364 303Q386 303 400 287T415 250Q415 219 385 157L378 144Q378 142 388 136T419 124T462 117Q522 117 566 165T610 255Q610 288 561 320Q532 337 532 367"],977:[701,8,692,24,656,"114 132Q114 153 140 253T166 372Q166 402 148 402Q126 402 110 369Q100 350 90 310Q85 289 82 286T60 282H55H44Q24 282 24 296Q25 302 27 312T41 350T65 397T104 435T158 452Q184 452 211 445T263 414T288 354V339L265 245Q237 134 237 118V107V102Q237 87 239 77T257 56T300 43Q395 43 455 254Q479 346 479 347L460 354Q294 408 294 528Q294 606 350 653T464 701Q536 701 579 659Q634 601 634 491Q634 468 630 438T623 388L620 370Q624 370 631 369T647 364T656 352Q656 347 653 335Q647 317 642 316Q640 315 637 315Q635 315 619 317Q606 319 605 316Q605 315 603 308Q587 248 550 177T457 57Q379 -8 293 -8Q192 -8 153 23T114 116V132ZM519 566Q519 600 507 625T464 651Q425 651 391 617T356 529Q356 501 370 478T404 441T443 417T477 404L491 400Q493 400 499 428T512 497T519 566"],981:[694,202,712,50,693,"274 -7Q232 -4 195 7T125 38T71 94T51 176V190Q51 213 60 242T95 307T156 373T255 425T393 451L397 452L427 568Q434 597 443 636Q452 677 456 685T472 694H486H495Q517 694 517 680L514 665Q510 650 503 621T489 564L460 451H469Q527 447 574 430T657 370T693 266Q693 163 599 82T350 -7H346L322 -100Q301 -190 295 -197Q291 -202 283 -202H269H258Q238 -202 238 -188Q238 -186 260 -96L283 -7H274ZM449 400Q448 400 404 225T359 47T366 45Q464 55 516 119Q542 149 558 199T575 295Q575 387 462 398L449 400ZM384 398Q384 399 381 399Q350 399 298 378T214 308Q168 236 168 149Q168 68 259 49Q282 44 294 44H295L384 398"],982:[444,8,975,23,961,"55 289H43Q23 289 23 303Q23 308 33 322Q116 434 199 443Q200 444 562 444Q922 444 928 442Q961 434 961 400Q961 376 944 355T886 333H870Q872 322 872 295V279Q872 230 842 165T751 46T618 -8Q581 -8 554 6T513 45T494 84T484 119Q484 121 478 114Q477 113 476 111Q384 -7 268 -7H265Q251 -7 237 -4T199 11T162 54T147 132Q147 149 149 166T155 198T165 229T176 256T189 281T200 301T211 319T220 333H199Q120 333 88 301L77 290L55 289ZM639 103Q674 103 712 122T780 188T811 295Q811 318 808 330V333H289Q274 318 244 263T214 169Q214 133 236 118T288 103Q351 103 412 153T494 278Q497 290 502 292T529 295Q546 295 551 293T556 283Q556 281 553 260T550 218Q550 153 576 128T639 103"],1009:[451,194,612,75,603,"371 -168Q357 -168 323 -171T245 -175Q143 -175 109 -150T75 -66Q75 -5 100 108T137 254Q153 299 179 334T232 390T277 419T311 434Q357 451 403 451Q435 451 455 449T506 435T560 400Q603 357 603 282Q603 213 569 148T465 38T304 -8Q273 -8 247 -2T204 14T176 31T159 46T152 53Q152 52 148 27T144 -16Q144 -36 150 -44T189 -58T293 -64Q405 -65 432 -75Q466 -88 466 -127Q466 -140 459 -172Q455 -188 451 -191T426 -194H420Q405 -194 400 -191T395 -176Q396 -170 394 -169T378 -168Q373 -168 371 -168ZM236 116Q236 77 258 60T311 43Q369 43 407 94Q429 123 451 206T474 331Q474 400 409 400H406Q339 400 299 341Q276 305 256 227T236 116"],1013:[444,7,483,44,450,"415 89Q423 89 429 74T436 46Q436 43 434 39Q432 36 420 29T380 11T322 -5Q311 -7 281 -7Q216 -7 168 10T94 54T56 110T44 167V181Q44 262 94 329Q104 343 119 357T162 391T234 425T327 443Q328 443 348 443T383 444Q434 444 442 438Q450 430 450 416Q446 392 424 383L376 382Q306 381 278 369Q230 349 208 294Q199 274 199 268Q199 267 291 267Q305 267 325 267T353 268Q383 268 394 263T406 241Q406 214 380 206Q375 205 279 205T183 203Q174 176 174 140Q174 87 208 65T292 43Q295 43 300 43T307 44Q337 49 372 69T415 89"],8710:[711,0,958,59,904,""]};
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Math/BoldItalic/Main.js");MathJax.OutputJax.SVG.FONTDATA.FONTS.MathJax_Caligraphic={directory:"Caligraphic/Regular",family:"MathJax_Caligraphic",id:"MJCAL",skew:{65:.194,66:.139,67:.139,68:.0833,69:.111,70:.111,71:.111,72:.111,73:.0278,74:.167,75:.0556,76:.139,77:.139,78:.0833,79:.111,80:.0833,81:.111,82:.0833,83:.139,84:.0278,85:.0833,86:.0278,87:.0833,88:.139,89:.0833,90:.139},32:[0,0,250,0,0,""],48:[452,22,500,39,460,"39 213Q39 274 53 319T89 389T139 429T192 448T242 452Q347 452 400 400Q460 335 460 213Q460 -22 250 -22Q39 -22 39 213ZM364 242Q364 279 363 301T355 348T338 385T306 406T254 415Q250 415 245 415T238 416Q217 416 190 404T150 368Q136 339 136 221Q136 114 146 78T200 23Q219 16 250 16Q280 16 299 23Q341 41 352 77T364 221V242"],49:[453,0,500,86,426,"116 410Q176 412 215 423T269 443T288 453H291Q293 453 301 447V254Q301 62 303 60Q307 52 322 49T394 46Q418 46 422 43T426 23Q426 8 424 4T411 0Q407 0 369 1T258 2T148 1T106 0Q96 0 94 4T91 23Q91 40 95 43T123 46Q180 46 195 49T215 61Q216 63 216 220V376Q192 367 119 364H93L86 371V403L92 410H116"],50:[453,0,500,44,449,"55 334Q55 386 105 419T236 453Q333 453 390 413T448 307Q448 278 437 256T406 218T365 193T318 172T277 151L248 134Q219 118 191 102T163 84T267 83L382 85H391Q399 99 406 126Q410 143 413 145T429 148Q440 148 442 147T449 139Q449 137 435 73T420 7Q420 6 414 0H233Q94 0 71 0T46 5Q46 5 46 6Q44 8 44 24Q44 39 46 41Q47 44 98 78T212 155T294 212Q347 257 347 304Q347 354 306 380T203 407Q150 407 120 377Q118 375 123 373Q146 362 146 332Q146 315 133 302T101 288Q85 288 70 298T55 334"],51:[452,216,500,42,457,"69 312Q69 377 122 414T233 452Q333 452 381 409T430 313Q430 268 402 223T311 149L301 144Q307 143 317 140T355 123T402 92T439 44T456 -25Q456 -101 396 -158T241 -216Q154 -216 98 -173T42 -68Q42 -58 44 -50T50 -35T57 -25T66 -17T75 -13T82 -10L87 -8Q92 -7 102 -7Q132 -7 147 -25T162 -66Q162 -112 118 -125L113 -126Q113 -129 127 -140T173 -162T239 -173Q268 -173 292 -158Q345 -124 345 -24Q345 33 329 67Q298 125 229 125H210H172Q166 131 166 142Q166 159 172 161Q178 161 208 164T244 169Q251 169 263 176T291 199T316 245T327 314Q327 413 238 413Q182 413 130 369Q177 350 181 312Q181 289 166 273T125 257Q102 257 86 272T69 312"],52:[464,194,500,28,471,"163 0Q139 0 109 0T71 -1Q43 -1 36 2T28 15V27V46L190 270Q325 457 330 462Q333 464 352 464H371L377 458V46H464L471 40V6L464 0H377V-65V-108Q377 -131 379 -137T391 -144Q409 -148 446 -148H464Q468 -151 471 -155V-187L464 -194H453Q395 -192 325 -192Q222 -192 210 -194H199L193 -188V-154L199 -148H228Q241 -148 250 -148T265 -146T275 -145T281 -143T284 -141T286 -138T289 -134V0H163ZM295 46V350L75 46H295"],53:[453,216,500,50,448,"159 -44Q159 -66 145 -80T109 -96H102L107 -105Q148 -173 228 -173Q255 -173 280 -162Q351 -128 351 -6V8Q351 67 344 98T316 151Q288 176 255 176Q175 176 136 109Q129 100 114 100Q97 100 95 106Q93 110 93 277V403Q93 451 98 451Q100 452 103 452Q105 452 124 445T177 431T251 423Q294 423 328 430T380 445T401 453Q410 453 410 435V422Q332 331 203 331Q152 331 140 339Q139 339 139 254V168Q194 214 256 214Q332 214 390 154T448 0Q448 -95 381 -155T229 -216Q153 -216 104 -166T50 -49Q50 -15 66 -1T105 13Q128 13 143 -3T159 -44"],54:[665,22,500,41,456,"42 313Q42 401 68 472T133 583T215 644T296 665H304Q317 665 329 664T360 657T393 640T418 608T432 557Q432 533 422 519T401 502T380 498Q358 498 343 512T328 550Q328 591 367 601L372 602Q372 604 365 609T341 620T307 626Q260 626 226 600T174 537Q147 483 143 376V356Q192 434 266 434Q317 434 357 409Q406 375 435 317Q456 268 456 210V192Q456 169 451 149Q440 90 387 34T253 -22Q225 -22 199 -14T143 16T92 75T56 172T42 313ZM251 396Q211 396 178 354T145 217Q145 159 152 122T166 73T187 47Q216 21 252 21Q294 21 321 47Q342 68 349 99T356 203V232Q356 264 354 285T345 331T322 373T280 395Q274 396 251 396"],55:[463,216,500,55,485,"75 246Q64 246 62 247T55 255Q55 259 72 357T90 458L94 462H99Q104 463 109 463H121Q128 460 128 452Q128 445 134 441T165 435T233 432T356 431H478L485 425V392L414 298Q408 290 385 260T358 223T337 191T317 154T302 116T289 68T282 14T275 -55T274 -137Q274 -173 272 -177Q262 -216 223 -216Q170 -216 170 -157V-148Q172 -78 189 -12T237 109T288 196T338 266Q345 275 348 279Q395 340 395 342Q396 343 376 343T274 343Q122 342 117 339T103 294T90 248Q88 246 75 246"],56:[666,22,500,43,456,"69 496Q69 570 124 618T247 666Q321 666 375 624T429 515Q429 468 405 433T320 361L346 344Q385 320 403 301T439 250Q456 212 456 181V172V160Q456 141 449 119T426 71T386 26T326 -8T246 -21Q160 -21 102 30T43 155Q43 265 167 332L176 337L161 347Q105 384 87 423Q69 458 69 496ZM371 513Q371 567 334 596T249 626Q198 626 163 598T127 532Q127 521 129 511T138 492T150 476T167 460T185 447T207 433T228 420L284 384L294 391Q346 424 363 469Q371 486 371 513ZM190 21T250 21T351 56T393 140Q393 180 362 213Q354 221 317 246T246 292L212 313Q210 313 200 307T173 287T142 256T117 212T106 157Q106 100 148 61"],57:[453,216,500,42,457,"171 -101Q171 -118 163 -130T146 -146T134 -151Q132 -151 132 -152Q132 -154 140 -159T167 -168T206 -173Q274 -173 317 -108Q356 -50 356 79V86L350 77Q308 9 231 9Q150 9 92 81Q42 141 42 228Q42 289 64 333Q93 390 142 421T235 452Q237 452 244 452T255 453Q289 453 321 439T386 391T437 290T457 128Q457 -29 381 -122T206 -216Q148 -216 108 -187T67 -104Q67 -75 84 -62T119 -49Q141 -49 156 -63T171 -101ZM242 46Q293 46 324 94T355 223Q355 323 337 356Q316 401 275 410Q267 412 248 412Q206 412 179 386Q155 360 149 328T143 224Q143 120 163 88Q192 46 242 46"],65:[728,51,798,30,819,"576 668Q576 688 606 708T660 728Q676 728 675 712V571Q675 409 688 252Q696 122 720 57Q722 53 723 50T728 46T732 43T737 41T743 39L754 45Q788 61 803 61Q819 61 819 47Q818 43 814 35Q799 15 755 -7T675 -30Q659 -30 648 -25T630 -8T621 11T614 34Q603 77 599 106T594 146T591 160V163H460L329 164L316 145Q241 35 196 -7T119 -50T59 -24T30 43Q30 75 46 100T74 125Q81 125 83 120T88 104T96 84Q118 57 151 57Q189 57 277 182Q432 400 542 625L559 659H567Q574 659 575 660T576 668ZM584 249Q579 333 577 386T575 473T574 520V581L563 560Q497 426 412 290L372 228L370 224H371L383 228L393 232H586L584 249"],66:[705,23,657,32,664,"304 342Q292 342 292 353Q292 372 323 391Q331 396 417 428T533 487Q563 512 563 555V562Q563 575 557 589T530 618T475 636Q429 636 396 613T330 539Q263 446 210 238Q196 183 173 120Q135 31 121 16Q108 1 85 -10T47 -22T32 -10Q32 -5 44 18T77 93T112 206Q135 296 154 395T182 550T191 615Q191 616 190 616Q188 616 179 611T157 601T131 594Q113 594 113 605Q113 623 144 644Q154 650 205 676T267 703Q277 705 279 705Q295 705 295 693Q295 686 288 635T278 575Q278 572 287 582Q336 635 402 669T540 704Q603 704 633 673T664 599Q664 559 638 523T580 462Q553 440 504 413L491 407L504 402Q566 381 596 338T627 244Q627 172 575 110T444 13T284 -22Q208 -22 158 28Q144 42 146 50Q150 67 178 85T230 103Q236 103 246 95T267 75T302 56T357 47Q436 47 486 93Q526 136 526 198V210Q526 228 518 249T491 292T436 330T350 345Q335 345 321 344T304 342"],67:[705,25,527,12,533,"201 -25Q167 -25 136 -14T75 23T29 94T12 202Q12 290 50 394T161 574Q227 642 303 673T433 704Q435 705 457 705Q533 701 533 640Q533 606 507 548T464 474Q431 444 396 444Q381 444 381 453Q381 459 388 473T407 513T428 563Q433 580 433 594Q433 636 381 636Q314 636 260 594T175 489T128 363T112 247Q112 157 153 101T273 44Q347 44 398 121Q413 144 437 157T481 171Q496 171 496 160Q496 150 476 123Q426 56 350 16T201 -25"],68:[683,1,771,19,766,"37 475Q19 475 19 487Q19 536 103 604T327 682H356Q386 683 408 683H419Q475 683 506 681T582 668T667 633Q766 571 766 450Q766 365 723 287T611 152T455 57T279 6Q248 1 160 0Q148 0 131 0T108 -1Q72 -1 72 11Q72 24 90 40T133 64L144 68L152 88Q247 328 272 587Q275 613 272 613Q272 613 269 613Q225 610 195 602T149 579T129 556T119 532Q118 530 116 525T113 518Q102 502 80 490T37 475ZM665 407Q665 596 412 613Q403 614 383 614Q370 614 370 612Q370 598 363 542T323 357T242 103L228 69H265Q391 73 481 119Q536 148 575 188T633 268T658 338T665 392V407"],69:[705,22,528,30,564,"144 470Q144 556 240 630T451 705Q564 705 564 637Q564 611 540 573Q529 559 505 547T464 534Q448 534 448 545Q448 552 455 562Q463 577 463 591Q463 600 462 604T456 616T436 627T400 635Q396 635 390 635T380 636Q291 636 258 568Q245 544 245 516Q245 463 290 438T391 410Q415 410 415 398Q415 392 407 380T376 356T326 341Q288 340 260 327Q218 311 187 276T143 208T130 151Q130 113 156 88T211 55T268 47Q349 47 403 125Q415 144 439 157T483 171Q499 171 499 160Q499 148 475 120T413 59T315 3T197 -22Q124 -22 77 14T30 105Q30 126 39 154T66 216T122 288T209 354L223 362Q144 400 144 470"],70:[684,32,719,18,829,"199 579Q181 579 181 590Q181 598 188 611T212 639T260 666T335 682Q336 682 349 682T383 682T431 682T493 683T561 683Q776 682 784 681Q826 673 829 647Q829 620 797 600T744 580Q728 580 728 595Q729 607 713 610Q698 613 598 614H500L499 610Q499 598 467 486T428 367Q428 365 551 365H674Q683 360 684 355Q687 346 677 329Q666 312 642 299T598 285Q586 285 582 296H402L394 277Q386 258 373 229T346 167T315 102T286 51Q265 22 225 -5T133 -32Q108 -32 87 -25T54 -7T33 15T21 35T18 47Q18 60 44 80T98 103Q108 103 111 101T119 88Q130 66 150 54T179 39T195 37Q199 37 203 43Q217 67 245 125T318 300T391 532Q393 543 398 564T406 598T409 613T339 614H269Q229 579 199 579"],71:[704,119,595,43,599,"216 68Q155 68 115 100T59 177T44 273Q44 299 50 333T73 421T133 533T239 632Q346 704 466 704Q508 704 515 703Q555 696 577 681T599 635Q599 605 570 560T523 496Q490 466 455 466Q440 466 440 475T469 526T499 589Q499 605 489 617Q460 636 403 636Q343 636 295 611T220 548T174 464T150 382T144 318Q144 241 180 189T287 137Q325 137 359 160Q428 205 466 322Q472 342 501 359T551 376Q557 376 560 373T564 368L565 365Q560 341 551 302T512 173T451 31Q359 -119 204 -119Q163 -118 127 -109T74 -91T53 -77Q52 -75 52 -71Q52 -54 79 -35T132 -14H140L151 -19Q210 -49 281 -49H289Q312 -49 329 -31Q351 -7 372 36T405 109T416 142L408 136Q401 131 392 125T369 111T338 96T303 82T261 72T216 68"],72:[683,48,845,18,803,"18 487Q18 496 29 517T67 566T127 621T216 665T330 683Q359 683 376 669T397 643T400 622Q400 584 382 488T348 343Q348 342 467 342H587L594 366Q615 440 648 534T690 641Q701 656 723 669T764 683Q783 683 783 672L750 578Q716 485 677 346T625 101Q624 92 623 82T622 65T621 56Q621 20 658 20Q666 20 701 25Q709 52 736 69T785 87Q803 87 803 75T791 44T754 3T685 -33T588 -48Q568 -48 562 -46Q522 -31 522 13V23Q531 129 562 250L569 281L565 280Q561 278 556 277T549 274L438 273H328L321 249Q307 202 275 107T232 0Q219 -16 196 -28T155 -41Q149 -41 145 -39T140 -34T139 -29Q139 -24 148 -3T181 86T233 247Q240 270 240 272Q240 273 194 273H169Q139 273 139 285Q139 295 153 308T187 332Q206 341 236 342L260 343L264 359Q278 414 289 482T300 578Q300 613 260 613H254Q198 613 169 592Q148 578 127 544T104 508Q72 478 37 475Q18 475 18 487"],73:[683,0,545,-30,642,"174 0H31Q-13 0 -21 2T-30 12Q-30 23 -17 36Q9 60 42 68L155 70Q187 102 214 179T257 333T302 491T366 610L369 614H305Q221 611 188 607T145 596T128 569Q119 543 94 529T47 512Q28 512 28 524Q28 527 32 539Q56 614 159 654Q218 678 312 682Q314 682 339 682T404 682T481 683H632Q642 678 642 671Q642 657 621 641T577 617Q570 615 507 614H444Q427 592 406 542Q382 478 355 366T310 209Q280 123 238 78L230 69H330Q442 70 442 74Q443 74 443 77T447 87T460 105Q490 134 527 137Q545 137 545 125Q545 120 542 112Q531 78 491 49T399 7Q379 2 360 2T174 0"],74:[683,119,678,47,839,"148 78Q148 16 189 -17T286 -50Q319 -50 348 -33T396 10T426 59T444 101L471 204Q498 306 521 372Q575 532 649 605L659 614H591Q517 613 494 607Q433 591 400 550T360 477Q353 454 325 437T275 419Q256 419 260 435Q280 523 376 597T583 681Q603 683 713 683H830Q839 674 839 671Q839 654 810 634T754 614Q735 614 721 601Q688 571 654 495T600 351T561 209T541 132Q507 29 412 -45T213 -119Q141 -119 94 -77T47 33Q47 55 50 69T58 90T71 103Q105 131 135 131Q152 131 152 120Q152 119 151 114T149 99T148 78"],75:[705,22,762,32,732,"194 618Q193 618 182 613T156 601T131 594Q113 594 113 605Q113 623 144 644Q154 650 205 676T267 703Q277 705 279 705Q295 705 295 691Q295 569 250 397Q225 306 197 217T151 81T128 25Q120 8 94 -7T47 -22Q32 -22 32 -10L64 76Q95 163 133 295T185 530Q198 611 194 618ZM331 429Q331 383 364 290T449 117T542 36Q574 36 607 51T652 103Q660 124 677 133T709 143Q727 143 727 128Q727 119 723 111Q704 56 639 17T497 -22H493Q463 -22 425 16Q401 40 382 71Q335 138 296 243T256 399Q256 434 288 473Q342 540 471 622T670 705Q691 704 703 696Q732 678 732 644Q732 613 714 600T677 586Q671 586 667 587T660 592T657 604V619Q657 647 629 647Q623 647 620 646Q576 635 495 583T365 482Q331 448 331 429"],76:[705,22,690,32,656,"62 -22T47 -22T32 -11Q32 -1 56 24T83 55Q113 96 138 172T180 320T234 473T323 609Q364 649 419 677T531 705Q559 705 578 696T604 671T615 645T618 623V611Q618 582 615 571T598 548Q581 531 558 520T518 509Q503 509 503 520Q503 523 505 536T507 560Q507 590 494 610T452 630Q423 630 410 617Q367 578 333 492T271 301T233 170Q211 123 204 112L198 103L224 102Q281 102 369 79T509 52H523Q535 64 544 87T579 128Q616 152 641 152Q656 152 656 142Q656 101 588 40T433 -22Q381 -22 289 1T156 28L141 29L131 20Q111 0 87 -11"],77:[705,50,1201,28,1137,"28 9Q28 37 43 63T73 90Q77 90 83 84T103 70T141 57H146Q162 57 178 79T222 167Q266 279 295 371T334 513T349 598T358 651T371 677Q397 705 432 705Q442 705 445 699T452 666Q453 661 453 659Q475 538 509 405T568 207L574 192Q581 178 587 164T594 150Q596 150 635 189T693 248Q765 324 863 438T1024 626T1089 701Q1093 705 1100 705Q1111 705 1111 682Q1111 675 1108 660T1099 611T1086 540Q1041 277 1041 144Q1041 98 1044 75T1050 48T1059 42Q1064 41 1075 46Q1102 61 1121 61Q1137 61 1137 50Q1137 28 1087 0T1000 -29Q983 -29 972 -23T955 -9T945 16T942 45T941 83V96Q941 158 952 256T974 422L985 489Q984 489 939 436T821 300T698 164Q665 128 620 85T568 37Q564 34 558 34Q550 34 546 37T535 54Q512 91 496 127T450 259T389 498L384 518Q349 367 294 223T198 15Q155 -50 117 -50Q87 -50 61 -35T30 -6Q28 2 28 9"],78:[789,51,820,-27,979,"343 705Q358 705 358 698Q360 696 370 658T411 524T484 319Q536 174 590 82L595 73L615 152Q646 274 683 407Q729 571 752 637T799 727Q852 780 937 788Q939 788 947 788T958 789H962Q979 789 979 765Q979 722 951 692Q942 683 924 683Q888 681 859 672T818 654T803 639Q784 608 708 322T631 15Q631 14 630 15Q630 17 629 15Q628 14 628 12Q621 -4 601 -17T560 -31Q550 -31 546 -28T530 -7Q484 67 458 123T398 272Q352 392 314 514L306 535V534Q306 533 296 488T272 379T234 239T185 100T127 -7T61 -50Q34 -50 4 -34T-27 8Q-27 33 -12 61T18 90Q21 90 36 77T87 57H92Q109 57 123 78T162 173Q206 299 232 417T265 599T276 667Q284 681 304 693T343 705"],79:[705,22,796,58,777,"308 428Q289 428 289 438Q289 457 318 508T378 593Q417 638 475 671T599 705Q688 705 732 643T777 483Q777 380 733 285T620 123T464 18T293 -22Q188 -22 123 51T58 245Q58 327 87 403T159 533T249 626T333 685T388 705Q404 705 404 693Q404 674 363 649Q333 632 304 606T239 537T181 429T158 290Q158 179 214 114T364 48Q489 48 583 165T677 438Q677 473 670 505T648 568T601 617T528 636Q518 636 513 635Q486 629 460 600T419 544T392 490Q383 470 372 459Q341 430 308 428"],80:[683,57,696,19,733,"37 475Q19 475 19 487Q19 536 103 604T327 682Q329 682 344 682T380 682T421 683H463Q625 683 695 615Q718 591 726 564Q733 547 733 525Q733 412 607 312T321 205H312Q293 205 293 217Q293 224 302 236T333 260T385 274Q558 287 614 407Q633 445 633 477Q633 515 612 543T556 585T481 607T399 614H370L368 603Q352 463 312 312T242 82T202 -13Q190 -33 164 -45T121 -57Q108 -57 108 -45Q108 -40 120 -10T151 73T192 190T233 349T266 539Q267 546 269 565T272 598T274 613H270Q209 613 163 588Q131 572 113 518Q102 502 80 490T37 475"],81:[705,131,817,114,787,"114 286Q114 358 151 433T249 569T392 667T558 705Q653 705 713 641T774 460Q774 389 750 322T687 206T600 114T504 46T412 4L399 -2Q542 -62 636 -62Q660 -62 670 -54T686 -27T700 0Q734 34 770 34Q787 34 787 23Q787 -18 720 -74T563 -131Q485 -131 350 -83T145 -34Q127 -34 127 -22Q127 -12 144 5T190 31L200 34L237 35Q386 38 467 79Q550 120 612 210T675 416Q675 510 625 573T484 636Q410 636 346 587T248 469T214 333Q214 306 221 281T243 229T288 188T360 172Q403 172 441 188T490 205Q510 205 510 192Q505 162 432 132T287 102Q206 102 160 155T114 286"],82:[683,22,848,19,837,"37 475Q19 475 19 487Q19 503 35 530T83 589T180 647T327 682H374Q387 682 417 682T464 683Q519 683 559 679T642 663T708 625T731 557Q731 481 668 411T504 300Q506 296 512 286T528 257T553 202Q594 105 611 82Q635 47 665 47Q708 47 742 93Q758 113 786 128Q804 136 819 137Q837 137 837 125Q837 115 818 92T767 43T687 -2T589 -22Q549 -22 517 22T467 120T422 221T362 273Q346 273 346 287Q348 301 373 320T436 342Q437 342 446 343T462 345T481 348T504 353T527 362T553 375T577 393Q598 412 614 443T630 511Q630 545 613 566T541 600T393 614Q370 614 370 613L366 584Q349 446 311 307T243 96L213 25Q205 8 179 -7T132 -22Q125 -22 120 -18T117 -8Q117 -5 130 26T163 113T205 239T246 408T274 606V614Q273 614 259 613T231 609T198 602T163 588Q131 572 113 518Q102 502 80 490T37 475"],83:[705,22,606,18,642,"554 512Q536 512 536 522Q536 525 539 539T542 564Q542 588 528 604Q515 616 482 625T410 635Q374 635 349 624T312 594T295 561T290 532Q290 505 303 482T342 442T378 419T409 404Q435 391 451 383T494 357T535 323T562 282T574 231Q574 133 464 56T220 -22Q138 -22 78 21T18 123Q18 184 61 227T156 274Q178 274 178 263Q178 260 177 258Q172 247 164 239T151 227T136 218L127 213L124 202Q118 186 118 163Q120 124 165 86T292 48Q374 48 423 86T473 186V193Q473 267 347 327Q268 364 239 389Q191 431 191 486Q191 547 242 600T356 679T470 705Q472 705 478 705T489 704Q551 704 596 682T642 610Q642 566 621 545Q592 516 554 512"],84:[717,68,545,34,833,"49 475Q34 475 34 490Q34 552 106 611T261 681Q272 683 507 683H742Q790 717 816 717Q833 717 833 708Q833 682 795 653T714 615Q691 610 588 609Q490 609 490 607L483 580Q476 554 462 496T435 392Q410 289 395 231T363 116T335 34T309 -15T279 -47T242 -64Q231 -68 218 -68Q203 -68 203 -57Q203 -52 211 -38Q224 -7 234 20T251 66T268 123T283 179T304 261T328 360Q342 415 360 488Q380 567 384 582T397 605Q400 607 401 609H302H244Q200 609 188 607T167 596Q145 572 145 541Q145 520 109 498T49 475"],85:[683,28,626,-17,687,"8 592Q8 616 70 649T193 683Q246 683 246 631Q246 587 205 492T124 297T83 143Q83 101 100 75T154 48Q202 48 287 135T450 342T560 553Q589 635 593 640Q603 656 626 668T669 683H670Q687 683 687 672T670 616T617 463T547 220Q525 137 521 68Q521 54 522 50T533 42L543 47Q573 61 588 61Q604 61 604 47Q599 16 506 -22Q486 -28 468 -28T436 -18T421 18Q421 92 468 258Q468 259 467 257T459 248Q426 206 391 167T303 81T194 6T83 -22Q66 -22 58 -20Q25 -11 4 19T-17 99Q-17 146 8 220T64 358T120 488T146 586Q146 604 141 608T123 613H120Q99 613 72 597T25 580Q8 580 8 592"],86:[683,52,613,25,658,"25 633Q25 647 47 665T100 683Q291 683 291 306Q291 264 288 213T282 132L279 102Q281 102 308 126T378 191T464 279T545 381T596 479Q600 490 600 502Q600 527 581 550T523 577Q505 577 505 601Q505 622 516 647T542 681Q546 683 558 683Q605 679 631 645T658 559Q658 423 487 215Q409 126 308 37T190 -52Q177 -52 177 -28Q177 -26 183 15T196 127T203 270Q203 356 192 421T165 523T126 583T83 613T41 620Q25 620 25 633"],87:[683,54,988,25,1035,"25 633Q25 647 46 665T103 683Q168 683 207 632Q228 608 243 568Q269 485 269 374Q269 324 265 271T256 184L251 150L252 152Q254 153 257 157T264 167T274 180T286 197Q359 293 424 398T519 558T549 616Q549 618 547 624T545 638Q550 654 572 668T615 683Q626 683 632 672T657 595Q726 370 741 128L742 110Q752 122 767 142T823 217T894 321T950 424T976 511Q976 544 958 560T918 577Q906 577 906 602Q906 629 918 651T942 681Q948 683 954 683Q983 683 1008 658T1034 569T999 421T915 257T813 109T724 -3T681 -49Q666 -59 660 -45Q659 -41 657 35T639 233T591 477Q573 551 570 551Q569 551 554 523T507 439T433 315T323 155T182 -25Q160 -52 151 -53Q137 -53 137 -30Q137 -29 148 25T170 168T181 338Q181 424 168 483T131 571T87 609T40 620Q25 620 25 633"],88:[683,0,713,52,807,"324 614Q291 576 250 573Q231 573 231 584Q231 589 232 592Q235 601 244 614T271 643T324 671T400 683H403Q462 683 481 610Q485 594 490 545T498 454L501 413Q504 413 551 442T648 509T705 561Q707 565 707 578Q707 610 682 614Q667 614 667 626Q667 641 695 662T755 683Q765 683 775 680T796 662T807 623Q807 596 792 572T713 499T530 376L505 361V356Q508 346 511 278T524 148T557 75Q569 69 580 69Q585 69 593 77Q624 108 660 110Q667 110 670 110T676 106T678 94Q668 59 624 30T510 0Q487 0 471 9T445 32T430 71T422 117T417 173Q416 183 416 188Q413 214 411 244T407 286T405 299Q403 299 344 263T223 182T154 122Q152 118 152 105Q152 69 180 69Q183 69 187 66T191 60L192 58V56Q192 41 163 21T105 0Q94 0 84 3T63 21T52 60Q52 77 56 90T85 131T155 191Q197 223 259 263T362 327T402 352L391 489Q391 492 390 505T387 526T384 547T379 568T372 586T361 602T348 611Q346 612 341 613T333 614H324"],89:[683,143,668,31,714,"65 599Q65 618 107 650T204 683Q267 683 312 643T380 533T414 385T424 217Q424 186 423 160T422 123Q426 123 468 170T567 304T650 469Q661 503 661 519Q661 546 639 570Q615 591 583 591Q569 591 569 616Q569 640 582 661T613 683Q624 683 638 679T671 664T702 625T714 558Q714 472 639 329T426 45Q361 -21 282 -82T154 -143Q97 -143 64 -104T31 -20Q31 4 44 25T70 46Q78 46 81 39T87 16T97 -9Q127 -51 182 -51Q184 -51 187 -50H190Q233 -41 314 25Q330 36 330 40Q336 79 336 178Q336 508 223 594Q199 614 158 619L148 620L139 611Q111 586 83 586Q65 586 65 599"],90:[683,0,725,37,767,"694 220Q708 220 708 210Q708 195 695 167T658 105T593 42T502 3Q492 1 458 1Q400 1 293 11T150 22Q116 22 92 11T51 0Q37 0 37 10Q37 21 63 44T179 146T367 319L391 343H343L296 344Q285 350 285 358Q285 365 289 372T300 383T313 392T324 398L329 400H450L561 518Q597 558 607 571L621 587H596Q553 589 484 599T383 609Q342 609 326 596T301 555Q294 533 263 514T208 492Q189 492 189 503Q189 510 197 528T215 559Q249 607 318 645T466 683Q504 683 573 673T669 662L690 661Q734 682 748 683Q767 683 767 673Q767 666 746 640Q655 531 555 428L529 400Q529 399 543 399Q604 397 604 366Q604 350 587 337T551 322Q541 322 539 323Q529 328 529 334Q529 339 487 342L470 343L446 320Q272 153 200 96L235 95Q297 95 392 86T533 74H554Q586 116 597 159Q604 179 635 199T694 220"]};MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Caligraphic/Regular/Main.js");MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Caligraphic-bold"]={directory:"Caligraphic/Bold",family:"MathJax_Caligraphic",id:"MJCALB",weight:"bold",skew:{65:.224,66:.16,67:.16,68:.0958,69:.128,70:.128,71:.128,72:.128,73:.0319,74:.192,75:.0639,76:.16,77:.16,78:.0958,79:.128,80:.0958,81:.128,82:.0958,83:.16,84:.0319,85:.0958,86:.0319,87:.0958,88:.16,89:.0958,90:.16},32:[0,0,250,0,0,""],48:[460,17,575,46,528,"259 460H279Q352 460 403 444T491 378Q528 320 528 219Q528 100 475 45Q417 -17 287 -17Q152 -17 99 44T46 219Q46 246 47 265T57 318T82 376T131 422T210 454Q234 460 259 460ZM389 229V271Q389 351 371 380T280 409Q232 409 208 385Q194 371 190 345T185 229V210Q185 108 194 83Q208 35 287 35Q317 35 336 42Q372 55 380 85T389 204V229"],49:[461,0,575,80,494,"119 417Q191 417 240 428T310 450T338 461Q353 461 357 452T361 400Q361 389 361 342T360 254V62H420H456Q483 62 488 58T494 35V29Q494 13 491 7T473 0Q468 0 424 1T295 2T167 1T117 0Q114 0 111 0T107 1Q96 8 96 27V35Q96 54 102 58T140 62H170H229V213Q229 363 228 363Q220 360 196 358T150 356L130 355H93Q84 360 82 365T80 386Q80 404 81 407T95 417H119"],50:[460,0,575,51,517,"214 399Q202 399 191 398T175 395T170 392L171 390Q172 389 174 386T178 379T181 369T182 355Q182 328 165 312T123 296Q99 296 82 312T64 356Q64 397 105 428T253 460Q301 460 337 456T411 441T476 403T514 338Q516 328 516 310V304Q516 257 470 227Q456 217 427 205T376 184L354 176Q350 174 325 162T277 139L254 128Q414 129 428 130H439Q450 148 453 166T460 188T486 193H493Q515 193 517 178Q517 171 502 94T484 11Q481 3 472 2T410 0H269Q65 0 62 2Q55 5 53 10T51 32Q51 54 56 58Q60 62 173 131Q296 207 318 224Q368 264 368 308Q368 342 342 363T283 392T214 399"],51:[461,212,575,48,526,"80 309Q80 367 131 414T276 461Q388 461 441 417T494 313Q494 265 463 223T373 155L361 151L376 147Q436 132 480 92T525 -15T487 -127T393 -192T274 -211Q179 -211 114 -167T48 -53Q48 -18 69 5T128 29Q168 29 188 5T208 -50Q208 -59 207 -67T203 -81T197 -92T190 -101T183 -109T177 -114T170 -118L167 -121Q160 -125 164 -127Q167 -129 176 -133Q215 -152 268 -152H273Q337 -152 356 -92Q364 -69 364 -14Q364 45 352 74T303 120Q287 125 240 125H230Q201 125 196 127T191 146V152Q192 170 196 173T233 178Q234 178 241 178T252 179T262 181T274 183T285 188T297 195T308 205T319 218T328 235T337 257Q345 280 345 320V330Q345 345 343 355T335 379T312 399T270 407Q226 407 177 377Q226 356 226 310Q226 270 204 253T153 235Q123 235 102 253T80 309"],52:[469,194,575,32,542,"180 0Q155 0 124 0T84 -1Q48 -1 40 3T32 27V37Q32 59 34 63T204 265T377 465Q380 468 383 468H387Q391 468 398 468T411 469Q432 469 438 468T449 459Q451 455 451 258V62H489H498Q531 62 536 58T542 31Q542 9 537 5T504 0H489H451V-132H489H498Q530 -132 536 -136T542 -163Q542 -181 538 -187T522 -194Q518 -194 483 -193T378 -192Q281 -192 256 -193L217 -194Q203 -189 203 -169V-163V-158Q203 -140 209 -136T246 -132H265H314V0H180ZM325 62V320L105 63L215 62H325"],53:[461,211,575,57,517,"131 29Q159 26 175 12T194 -13T197 -35V-41Q197 -58 195 -66Q191 -76 185 -84T173 -97T161 -105T152 -109L148 -110Q148 -112 158 -121T195 -141T252 -152Q274 -152 280 -151Q335 -137 349 -104T363 9Q363 85 356 114T322 157Q305 166 286 166Q251 166 223 154T182 131T162 109Q154 98 150 96T130 93Q107 93 102 104Q100 107 100 279V371V424Q100 461 110 461Q114 461 123 458T149 450T183 441Q234 429 286 429Q313 429 340 432T387 440T422 449T447 457T458 461Q472 461 472 435Q472 420 470 418Q464 405 438 379T352 325T226 297Q189 297 171 301H168V182Q169 182 174 185T190 194T213 205T248 213T292 217Q391 217 454 159T517 5Q517 -92 444 -151T255 -211Q167 -211 112 -160T57 -44Q57 -12 76 8T131 29"],54:[660,17,575,48,526,"48 316Q48 398 70 462T124 562T198 621T274 652T339 660Q377 660 384 659Q497 632 497 532Q497 507 482 487T431 466Q397 466 381 486T365 530Q365 569 405 593Q382 603 381 603Q361 607 350 607Q316 607 279 589T221 533Q199 489 196 385L195 370Q196 371 203 379T217 395T237 410T263 424Q283 431 313 431Q409 431 468 368Q526 310 526 208Q526 131 492 81T405 5Q359 -17 289 -17Q256 -17 227 -11T163 17T105 73T65 170T48 316ZM293 380Q244 380 220 331T196 212Q196 104 216 80Q240 41 292 41Q295 41 301 41T309 42Q338 46 355 62Q372 81 375 108T379 230Q378 314 372 333Q358 375 299 380H293"],55:[476,211,575,64,558,"95 210H88Q66 210 64 225Q64 229 82 345T102 465Q106 476 125 476H131Q162 476 162 458Q162 451 213 448Q221 448 238 447T260 446Q261 446 410 444Q436 444 468 444T509 445Q544 445 551 440T558 413V404Q558 395 547 380T478 301L392 202Q354 150 339 81T321 -104V-132Q321 -187 286 -203Q273 -211 255 -211Q236 -211 217 -199T190 -160Q189 -153 189 -130Q194 17 282 156Q309 200 370 270Q404 307 400 307H293Q151 306 146 303Q140 300 132 259T120 215Q115 210 95 210"],56:[661,17,575,48,526,"48 164Q48 199 59 228T92 277T128 307T163 329Q159 332 155 336Q135 346 110 382Q80 427 80 477Q80 564 147 620Q202 660 264 660Q266 660 275 660T290 661Q384 661 439 619T494 506Q494 486 489 468T477 437T459 413T440 395T421 380T406 370L410 368Q414 365 421 361T437 351T456 335T476 316T495 291T511 262T522 228T526 189Q526 93 460 38T282 -17Q242 -17 205 -9T130 19T71 75T48 164ZM406 506Q406 545 379 576T283 607Q218 606 193 585T168 536Q168 522 172 513T195 490T224 471T275 443L346 403Q406 446 406 506ZM291 42Q365 42 395 70T425 134V141Q425 170 401 190T319 242Q308 248 302 251Q286 260 266 271T235 288L225 294Q222 292 217 289T198 274T175 249T157 212T148 163Q148 116 179 79T291 42"],57:[461,210,575,48,526,"175 -140Q198 -152 236 -152Q294 -152 332 -116Q356 -91 366 -54T379 62V78L376 74Q372 70 366 64T352 50T333 35T308 23Q289 17 262 17Q168 17 108 77T48 235Q48 273 59 317Q81 381 141 421T276 461Q279 461 285 461T295 460Q326 460 354 454T415 426T471 371T510 277T526 136Q526 42 501 -28T432 -136T341 -192T240 -210Q199 -210 169 -201T121 -178T94 -146T80 -112T77 -82Q77 -51 95 -33T143 -15Q170 -15 189 -33T209 -81Q209 -116 175 -140ZM377 244V274Q377 300 376 316T368 352T348 384T312 405Q307 406 283 406Q257 406 238 396T213 376T205 361Q196 341 196 259V233V181Q196 122 211 96T278 69H298Q330 82 345 104Q367 134 376 190Q377 200 377 244"],65:[751,49,921,39,989,"761 751Q784 751 784 728V711Q784 570 795 417T820 191Q844 76 865 76Q868 76 902 93T962 112H973Q989 104 989 94Q989 92 987 86Q978 47 846 -11Q812 -25 779 -26Q722 -26 708 9Q688 47 669 161H524L379 162L359 136Q286 43 234 -3T142 -49T71 -19T39 55Q39 92 60 131T103 174Q113 174 117 167T124 149T136 128T166 110Q183 105 190 105Q230 105 341 246Q401 322 453 397T531 514T582 601T611 651H640V663Q640 692 676 718T745 750Q747 750 752 750T761 751ZM658 266Q653 312 649 377T644 489T641 541V556L557 415Q500 325 448 253Q467 261 524 261H568H658V266"],66:[706,17,748,40,739,"441 83Q571 83 571 195Q571 246 538 279T466 322T386 333Q378 333 357 330T329 327Q307 327 307 345Q307 354 313 365T347 396T419 430Q546 472 581 498Q594 508 594 535Q594 574 567 589T508 604Q469 604 442 583Q390 546 342 457T265 256Q237 148 186 60Q167 29 144 13Q105 -15 68 -17H65Q40 -17 40 1Q40 7 53 29T87 100T124 210Q162 373 190 575Q188 575 174 567T138 550T98 542Q75 542 75 560Q75 588 123 618Q135 625 203 659T281 696Q299 703 316 703Q339 703 339 685Q339 656 328 583L333 588Q338 592 346 599T367 615T394 634T428 654T467 674T511 690T559 701T611 705Q651 704 681 689Q739 659 739 598Q739 507 595 427L584 421Q585 420 595 416T610 410T626 402T644 392T660 380T677 365T691 347T703 325T710 299T715 268Q717 193 665 130Q622 73 531 28T348 -17Q275 -17 225 10Q206 19 200 24T193 36Q193 57 231 86T311 119H322Q386 83 441 83"],67:[704,20,613,20,599,"243 -20Q135 -20 78 48T20 218Q20 280 39 344T98 470T193 580T324 661T488 702H490Q491 702 493 702T498 703T507 703T518 702H526Q599 702 599 631Q599 597 577 550T541 486Q523 463 490 447T431 430Q423 430 419 433Q409 437 409 450Q410 456 432 499T454 567Q454 586 446 594T415 603Q316 603 254 532Q216 487 190 421T164 284Q164 228 181 186T226 122T282 90T340 80Q377 80 405 96T449 131T492 167T553 187H555Q580 187 580 168Q580 153 551 123T476 60T367 4T243 -20"],68:[686,0,892,20,885,"107 0Q92 5 92 18Q92 33 113 53T160 86Q170 91 182 94T197 100L206 120Q248 226 273 337T304 501T309 585Q278 585 234 577T179 557Q172 550 166 532T156 509Q140 484 105 466T44 447Q20 447 20 465Q20 482 34 510T76 565Q122 608 173 632Q281 686 447 686H480H517Q692 686 784 631Q885 571 885 450Q885 339 805 239T586 75T286 1Q276 0 187 0H107ZM741 391Q741 424 731 452T694 510T613 558T481 584Q476 584 468 584T457 585L449 586V579Q441 501 425 424T391 292T357 193T330 125T319 100H324Q511 100 628 175Q688 215 714 275T741 391"],69:[703,16,607,37,627,"495 516Q485 516 478 520T470 532Q470 537 476 550T482 570Q482 589 465 596T401 603Q344 603 319 582Q295 558 295 519Q295 493 312 474T355 445T407 432T455 427Q477 427 477 409Q477 395 453 371T389 333Q380 330 345 327T279 312T223 272Q181 223 181 176Q181 131 225 107T324 83Q366 83 395 98T448 136T487 167Q517 185 547 187H551Q574 187 574 170Q574 151 535 113T421 36T271 -15Q260 -16 226 -16Q181 -16 152 -9Q104 4 71 33T37 111Q37 140 50 176T106 263T216 356Q215 357 207 362T190 374T172 392T156 419T150 456Q150 521 208 580T341 670T474 702Q475 703 499 703Q528 703 547 701T586 693T615 673T627 637Q627 584 581 550T495 516"],70:[686,30,814,17,930,"812 567Q804 567 795 570T786 579Q786 586 647 586H559L558 582Q558 575 539 510T506 407L498 384H775Q788 378 790 368Q790 328 746 298T665 268Q646 268 642 284H457L447 261Q396 150 360 94Q329 46 270 8T149 -30Q123 -30 100 -24T63 -10T37 9T22 26T17 36Q17 59 56 88T135 119Q145 119 149 117T165 104Q187 78 227 72Q232 72 234 76Q245 93 273 145T350 323T424 570L428 586H276Q265 575 239 563T190 551Q180 551 174 556T167 569Q167 580 179 597T213 634T278 668T371 685Q374 686 624 686Q863 685 888 682Q917 678 927 663Q930 658 930 650Q930 624 888 596T812 567"],71:[703,114,682,50,671,"50 279Q50 361 88 438T190 570T335 661T503 702H514Q524 703 532 703Q671 703 671 626Q671 580 614 514T495 447Q472 447 472 465Q472 477 499 511T527 562Q527 582 507 592T433 602Q351 602 302 569Q252 535 223 469T194 344Q194 266 237 217T352 168Q401 168 442 205T505 316Q515 345 551 368T622 393H625Q649 393 649 376Q649 371 635 318T612 237Q580 129 540 62T442 -49Q353 -114 264 -114Q259 -114 252 -114L246 -113Q190 -113 142 -107T81 -96Q71 -90 71 -81Q71 -57 110 -30T187 2Q196 2 236 -4T338 -14Q371 -14 377 -9Q410 24 446 113L451 127Q353 68 253 68Q157 68 104 129T50 279"],72:[686,48,987,20,946,"42 447Q20 447 20 465Q20 481 47 515T119 589T239 657T392 686Q443 686 463 664T484 616Q484 570 473 506T452 401L441 360Q441 359 550 359H660L663 370Q684 435 716 522T758 624Q771 646 806 666T870 686Q894 686 894 668Q894 667 867 597T804 416T752 218Q737 135 737 93Q737 77 746 65T778 53Q799 53 803 54T814 63Q831 86 864 103T924 120Q946 120 946 100Q945 85 931 63T888 16T806 -27T684 -48H681Q625 -48 603 -10Q593 4 593 29Q593 71 603 131T624 230L634 269Q632 269 624 266Q610 261 600 261T507 259H411L399 222Q344 62 322 21Q301 -7 268 -24T209 -41H207Q187 -41 185 -25Q185 -17 192 2T220 71T261 184Q284 256 284 258Q284 259 227 259H170Q169 259 166 261T162 264T158 266T156 271T155 277Q155 296 184 320T250 356Q259 358 286 359Q312 359 312 360Q314 372 318 385Q332 450 339 526Q339 530 339 535T340 543Q340 586 296 586Q255 586 227 576T188 553T165 523T146 497Q127 476 97 462T42 447"],73:[687,0,642,-27,746,"56 499Q32 499 32 516Q32 540 64 580T165 649Q241 682 365 685Q366 685 376 685T405 685T445 686T496 686T553 686H732Q746 677 746 668Q746 646 711 620T642 587L572 586H503Q479 546 458 479T424 352T383 224T318 111L309 101L412 100H514L523 109Q567 150 618 153Q644 153 644 135Q644 132 642 124Q629 86 581 52T476 6Q454 2 433 2T216 0Q-11 0 -15 2Q-27 6 -27 18Q-27 37 2 61T59 93Q77 100 142 100H198Q255 177 299 369Q337 513 382 574L391 586H348Q261 586 176 576Q163 543 124 521T56 499"],74:[687,114,779,53,937,"286 390Q263 390 263 407Q263 432 293 481T367 566Q511 687 724 687Q738 687 761 687T793 686H923Q937 677 937 668Q937 648 905 623T842 589Q829 587 817 586T802 585T795 583T788 578Q709 506 632 189Q622 153 615 134T588 81T537 17Q482 -39 404 -76T247 -114Q192 -114 158 -100Q53 -61 53 32Q53 59 58 73T79 102Q126 147 177 147Q200 147 200 128Q200 123 198 112T196 96Q196 47 238 17T345 -13Q362 -13 377 -9T404 0T426 16T444 34T459 55T470 76T478 97T483 116T488 132L490 141Q511 222 520 257T554 364T608 486T675 576L685 586H634H612Q532 586 484 564Q453 549 436 526T409 478T395 447Q378 424 345 407T286 390"],75:[703,17,871,40,834,"98 542Q75 542 75 560Q75 588 123 618Q132 624 199 657T275 694Q291 703 315 703Q327 703 332 699T338 690T339 670Q339 596 323 505T283 337T237 194T198 90L181 53Q170 31 136 8T68 -17H65Q40 -17 40 0L76 92Q112 185 150 322T194 564V578L168 565Q125 542 98 542ZM834 142Q834 125 819 100T774 48T692 3T576 -16H560Q540 -16 508 6Q469 33 422 108T342 267T309 398Q309 411 310 417T320 442T347 482Q401 542 517 615T710 702Q712 702 721 702T735 703Q772 703 791 690Q819 674 819 646T792 597T733 574H722Q704 584 704 599Q706 607 700 610T672 617L660 613Q609 595 524 538T423 450V440Q423 376 488 247T604 83Q621 70 640 70Q677 70 701 82Q713 87 718 101T737 132T783 160Q792 163 807 163Q834 163 834 142"],76:[703,17,788,41,751,"63 -17Q41 -17 41 0Q41 22 85 54Q101 68 113 92T133 141T154 219T182 315Q230 462 306 553Q345 599 391 632T478 678T543 697T582 703Q584 703 589 703T598 702Q643 702 666 676T689 613Q689 588 683 575Q674 551 632 524T552 496Q530 496 530 512Q530 517 531 525T533 538Q533 559 522 577T480 596H476Q462 596 451 588T415 544Q350 447 310 281Q284 181 261 136L255 124H285Q342 123 441 107T583 90L596 89Q603 116 647 144T729 173Q751 173 751 157Q751 118 685 60T523 -15Q514 -16 479 -16Q421 -16 320 0T171 18H155L142 10Q98 -17 63 -17"],77:[703,49,1378,38,1353,"38 20Q38 59 60 99T104 139Q106 139 126 125T176 106H181Q200 106 221 139T286 281Q322 370 342 451T368 581T376 634Q384 657 420 680T487 703Q502 703 507 696T522 649Q538 589 554 537Q579 453 609 372T660 248T686 202Q687 201 739 244T830 322L1166 642Q1225 700 1230 701Q1230 701 1237 703Q1258 703 1258 667L1253 637Q1248 607 1241 558T1227 451T1214 326T1209 202Q1209 77 1232 77Q1237 77 1269 94T1326 112H1329Q1353 112 1353 94Q1353 81 1334 60Q1311 37 1248 7T1150 -24H1141H1135Q1085 -24 1074 26Q1064 75 1064 134Q1064 239 1086 426Q1087 430 1087 434L1061 410Q871 227 783 149L694 76Q653 44 647 40T631 34Q620 34 616 37T594 63Q546 125 514 198Q467 307 423 449L418 466L412 444Q376 310 306 153Q278 88 251 45T201 -18T163 -43T131 -49Q102 -48 70 -31T38 20"],78:[840,49,937,-24,1105,"47 139Q81 105 122 105Q137 105 147 117Q159 134 182 199T234 381T274 610Q275 634 284 647Q297 666 327 684T389 703Q403 703 408 695T428 645Q480 490 567 298Q628 163 673 103Q674 102 674 102T675 106Q732 331 803 551Q842 674 875 725Q908 775 966 807T1081 840H1084Q1105 840 1105 803Q1105 768 1088 733T1051 689Q1045 686 1032 686Q986 683 948 663T901 624Q881 579 837 430T760 154L726 28Q725 28 725 28T723 25Q716 0 682 -24T611 -48Q600 -48 595 -45T576 -23Q522 44 480 124Q417 243 332 463L328 473L325 457Q291 293 227 124Q159 -49 72 -49Q38 -49 5 -28Q-24 -8 -24 21Q-24 58 -3 98T41 139H47"],79:[704,17,906,63,882,"433 703Q456 703 456 685Q456 672 441 655T407 627Q402 623 378 611T328 579T276 524Q207 434 207 324Q207 222 270 153T441 84Q566 84 651 177T737 400V405Q737 496 693 549T576 603Q542 603 510 560Q490 537 472 502T442 454Q397 412 346 409Q320 409 320 427Q320 430 322 436Q331 465 360 507T433 594T542 671T677 703Q776 703 829 636T882 468Q882 369 831 277T702 122T528 21T343 -17Q214 -17 139 61T63 257Q63 336 94 409T173 534T272 625T367 684T432 703H433"],80:[686,67,810,20,846,"170 -67Q147 -67 147 -49Q147 -42 162 -8T204 99T253 254Q274 332 288 415T305 542L308 585Q277 585 234 577T179 557Q172 550 166 532T156 509Q140 484 105 466T44 447Q20 447 20 465Q20 482 34 510T76 565Q122 608 173 632Q279 686 448 686H495H537Q622 686 678 677T784 637Q846 598 846 533Q846 452 776 375T597 252T378 206H366L358 181Q341 130 316 68T282 -7Q262 -33 230 -50T170 -67ZM701 468Q701 512 661 540T570 577T461 586H448V582Q446 576 443 545T428 447T395 301L389 280Q390 280 398 284T419 295T441 303Q443 304 484 306T572 321T651 359Q701 402 701 468"],81:[703,146,939,120,905,"874 453Q874 372 836 298T750 177T638 89T543 33T486 8L483 7Q485 5 523 -7T622 -32T726 -46Q741 -46 746 -45T755 -41T762 -27Q770 -1 806 23T878 50H890Q905 42 905 33Q905 -8 838 -68T670 -145Q662 -146 628 -146Q538 -146 389 -100T164 -50Q132 -50 132 -32T162 11T227 47Q231 48 286 51T394 62T518 100T641 180Q730 271 730 387Q730 478 673 540T520 602Q410 602 337 525T264 355Q264 284 310 244T420 203Q476 203 568 222Q594 222 594 204Q594 184 565 161T508 128Q433 103 316 103Q227 103 174 157T120 290Q120 382 182 471T343 620T548 697Q578 703 601 703Q604 703 611 703T623 702Q663 702 687 696Q760 679 817 618T874 453"],82:[686,17,990,20,981,"159 0Q159 5 172 34T205 114T245 229T284 386T309 575V585H304Q303 585 295 585T282 584Q233 579 207 570T175 553T165 531T156 509Q140 484 105 466T44 447Q20 447 20 465Q20 482 34 510T76 565Q122 608 173 632Q279 686 448 686H505H582Q683 686 745 672T834 611Q842 594 842 565Q842 523 824 484T780 419T722 370T669 336T632 318L619 312L626 302Q640 279 667 227T696 172Q717 133 735 112T762 88T784 84Q824 84 872 118T957 153Q981 153 981 136Q981 114 937 78T820 13T684 -17Q646 -17 616 8T569 66T526 151T477 234Q461 256 446 265Q437 272 421 274Q400 274 400 291Q400 311 430 336T495 371Q496 371 543 374T627 392T681 436Q699 467 699 503Q699 550 644 568T471 586H449V582Q449 581 447 559T438 499T422 413T393 298T348 165Q313 73 296 45Q282 24 249 4T185 -17Q159 -17 159 0"],83:[703,16,696,25,722,"204 476Q204 525 248 577T372 666T539 703T674 683T721 612Q721 588 714 569Q704 547 669 524T601 499Q573 499 573 516Q573 521 575 527T577 543Q577 563 568 574T548 588L539 590Q490 603 444 603Q418 603 394 597T364 583Q348 567 348 533Q348 493 382 466T459 425T555 387T633 330Q662 292 662 249Q662 153 544 69T257 -16Q218 -16 208 -15Q118 1 64 46Q25 76 25 126Q25 185 82 235T203 290H207Q229 290 231 274Q231 243 180 213Q173 209 172 206T170 189T171 170T183 150T216 121Q273 83 356 83Q412 83 459 100Q493 111 507 141Q518 165 518 185Q518 208 506 228T478 262T437 288T398 306T360 320Q316 335 285 352T239 384T215 416T205 443T204 467V476"],84:[720,69,644,38,947,"61 462H59Q38 462 38 479Q38 528 109 594T289 683L304 685L837 687L846 693Q889 720 923 720Q947 720 947 702Q945 671 892 631T776 583Q774 583 772 583T769 582T766 582L764 581H758Q753 581 744 581T722 580T693 580T662 580H563L514 385Q507 355 493 299T475 225T460 172T443 119T426 76T402 24Q386 -11 355 -33T304 -61T266 -69Q242 -69 242 -50Q243 -45 253 -25T278 32T307 115L364 340Q405 511 413 538T436 580H207Q202 572 200 568T197 561T195 552T190 537Q176 511 135 487T61 462"],85:[686,24,715,-10,771,"124 586Q107 586 74 569T15 552H13Q-10 552 -10 570Q-10 605 70 645T222 686Q283 686 283 631Q283 590 246 504T172 326T135 181Q135 130 157 107T205 83Q221 83 259 106Q347 165 453 301T604 548Q607 557 612 569T619 587T624 600T628 612T632 621T637 628T641 634T647 640T654 645T662 652Q706 686 748 686Q771 686 771 669Q771 656 754 614T700 467T630 229Q615 168 610 105Q610 88 617 78L641 90Q681 111 706 112Q733 112 733 95Q733 82 714 60Q694 40 633 10Q567 -23 532 -24Q507 -24 495 -17Q466 -4 466 32Q466 96 500 225Q277 -17 102 -17Q56 -17 23 17T-10 118Q-10 164 13 234T64 363T115 481T139 567Q139 586 124 586"],86:[686,77,737,25,774,"25 608Q25 628 60 657T148 686Q184 683 213 671T273 625T327 538T363 394T380 184L381 134L399 148Q503 226 574 302T667 415T689 467Q688 474 684 482T672 502T645 521T600 532Q576 532 576 567Q576 604 597 644T641 685H649Q701 685 737 648T774 545Q774 457 703 333T461 66Q397 13 332 -32T255 -77Q237 -77 237 -30V-23Q241 20 241 109Q241 483 115 569Q91 586 50 589Q25 589 25 608"],87:[686,77,1169,25,1206,"25 607Q25 629 62 657T142 686Q205 686 248 647T312 541T339 411T347 275Q347 249 345 203V189Q375 219 449 316T587 516Q629 584 629 587Q629 589 626 597T622 607Q622 629 658 656T732 686H744Q755 680 757 678Q757 677 769 649T799 577T835 475T874 339T904 183Q908 157 910 151L925 169Q997 252 1059 343T1121 474Q1120 498 1103 513T1059 532Q1036 532 1036 568Q1036 600 1053 636T1090 683L1097 686H1109Q1147 684 1176 652T1206 551Q1206 460 1131 320T897 7Q859 -33 840 -52T816 -74T804 -77Q788 -77 784 -32Q783 -28 783 -26Q774 108 744 239T691 436T665 501Q664 501 649 475T602 400T528 289T420 146T280 -15Q243 -56 231 -66T210 -77Q191 -77 191 -40Q191 -38 195 -4T204 91T209 217Q209 290 202 351T177 469T126 557T45 589Q25 589 25 607"],88:[687,-1,817,56,906,"762 562Q762 579 737 584T711 604Q711 630 753 658T834 686Q864 686 885 669T906 627Q906 580 834 522T614 379L584 362V357Q585 354 589 315T597 233T603 183Q610 132 627 116T671 100Q678 100 704 113T754 126T778 107Q776 79 733 45T626 2Q615 1 578 1Q542 1 535 3Q521 7 510 15T491 31T477 54T467 78T460 108T456 137T452 170T449 201Q447 220 445 240T442 270L441 281Q435 281 357 233Q240 165 206 135Q200 128 200 124Q200 113 208 108T226 101T244 96T252 82Q252 61 214 31T129 1H120Q97 1 77 16T56 60Q56 105 133 168T414 345Q428 352 431 354T433 359Q422 493 414 522Q407 551 395 566T373 583T350 586H341L332 580Q290 560 265 560Q243 560 243 577Q243 585 248 596T269 624T306 653T365 676T447 686H456Q472 686 484 683T514 671T543 637T562 576Q565 557 570 501L577 437Q577 436 613 457T694 506T756 551Q762 558 762 562"],89:[686,164,759,36,797,"73 555Q49 555 49 573Q49 602 110 644T239 686Q319 686 376 624Q416 584 444 511T483 361T499 240T503 173Q503 165 504 165Q506 165 524 184T556 218Q631 297 674 377T718 485Q718 505 699 526Q673 552 628 552Q619 552 613 562T607 590Q607 617 621 645T658 685Q661 686 671 686Q718 686 757 652T797 545Q797 476 749 369T602 146Q500 29 371 -67T176 -164Q112 -164 74 -120T36 -29Q36 5 55 36T95 67Q104 67 108 59T115 39T128 12T154 -12Q183 -30 216 -30Q239 -30 305 7L361 44L367 49V54Q367 95 364 143T351 273T312 429T243 546Q206 581 156 588L146 581Q108 555 73 555"],90:[686,0,818,46,853,"622 574Q522 579 420 579H396Q373 579 364 574T351 550Q339 516 297 490T218 462Q195 462 195 479Q195 487 197 492Q218 565 313 625T509 685Q564 685 650 683T755 680Q787 680 807 683T831 686Q853 686 853 669Q853 657 826 626Q742 532 641 437L619 415L622 414Q626 414 631 414T642 414Q697 411 697 388Q697 367 670 345T607 323Q605 323 592 325T546 329H522L490 302Q457 274 400 226T289 136L260 113L318 112Q345 111 452 109T587 106H627Q650 143 656 170Q666 197 710 225T788 253Q811 253 811 237Q811 211 781 160T710 77Q619 0 515 0Q507 0 497 0T484 1Q434 1 319 3T177 6Q123 6 95 2Q83 2 71 0H68Q46 0 46 17Q46 28 58 44Q68 56 100 80T210 165T383 307L408 329H361L314 330Q297 338 297 350Q297 368 320 388T368 413Q375 415 441 415H506L647 555L664 574H622"]};
MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Caligraphic/Bold/Main.js");MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"]={directory:"Main/Italic",family:"MathJax_Main",id:"MJMAINI",style:"italic",Ranges:[[32,127,"BasicLatin"],[256,383,"LatinExtendedA"],[384,591,"LatinExtendedB"],[768,879,"CombDiacritMarks"],[880,1023,"GreekAndCoptic"],[8192,8303,"GeneralPunctuation"],[8448,8527,"LetterlikeSymbols"],[8704,8959,"MathOperators"]],163:[714,11,769,88,699,"699 578Q699 473 635 473Q597 473 595 508Q595 559 654 569V576Q654 619 637 648T581 677Q545 677 513 647T463 561Q460 554 437 464T414 371Q414 370 458 370H502Q508 364 508 362Q505 334 495 324H402L382 241Q377 224 373 206T366 180T361 163T358 151T354 142T350 133T344 120Q340 112 338 107T336 101L354 90Q398 63 422 54T476 44Q515 44 539 73T574 133Q578 144 580 146T598 148Q622 148 622 139Q622 138 620 130Q602 74 555 32T447 -11Q395 -11 317 38L294 51Q271 28 233 9T155 -10Q117 -10 103 5T88 39Q88 73 126 106T224 139Q236 139 247 138T266 134L273 132Q275 132 302 239L323 324H259Q253 330 253 332Q253 350 265 370H300L334 371L355 453Q356 457 360 477T366 501T372 522T379 545T387 565T397 587T409 606T425 627Q453 664 497 689T583 714Q640 714 669 676T699 578ZM245 76Q211 85 195 85Q173 85 158 71T142 42Q142 26 160 26H163Q211 30 245 76"]};MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Italic/Main.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"],{305:[441,10,307,75,341,"75 287Q75 292 82 313T103 362T142 413T196 441H214Q248 441 270 419T293 357Q292 338 289 330T245 208Q193 72 193 46Q193 26 209 26Q228 26 247 43Q273 71 292 136Q295 148 297 150T311 153H317Q327 153 330 153T337 150T340 143Q340 133 330 105T292 41T228 -8Q220 -10 204 -10Q160 -10 141 15T122 71Q122 98 171 227T221 384Q221 396 218 400T203 405Q175 403 156 374T128 312T116 279Q115 278 97 278H81Q75 284 75 287"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Italic/LatinExtendedA.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"],{8211:[285,-248,511,91,554,"98 248Q91 252 91 259Q91 279 100 284Q102 285 324 285H442H500Q536 285 545 283T554 274Q554 260 548 254Q546 250 538 249Q520 248 319 248H98"],8212:[285,-248,1022,117,1038,"124 248Q117 252 117 259Q117 279 126 284Q128 285 579 285T1033 284Q1037 280 1037 278Q1038 276 1038 274Q1038 253 1029 250Q1026 248 575 248H124"],8216:[694,-379,307,197,362,"249 379Q228 379 213 396T197 448Q197 533 271 627L278 635Q286 643 295 652T314 671T332 687T344 694Q349 694 355 685T362 671Q362 668 345 654T301 608T256 537Q238 493 240 491Q241 491 245 493T258 498T275 500Q296 500 311 488T326 454Q326 426 304 403T249 379"],8217:[694,-378,307,212,377,"250 620Q250 647 272 670T325 694Q348 694 362 677T377 633V624Q377 566 343 506T275 412T231 379Q226 379 220 388T213 401T232 421T279 472T323 547Q335 573 335 582L331 580Q327 578 318 576T300 573Q277 573 264 585T250 620"],8220:[694,-379,514,243,606,"295 379Q274 379 259 396T243 448Q243 533 317 627Q326 638 354 666T391 694Q395 694 402 686T409 673Q409 668 392 654T348 608T302 537Q284 493 286 491Q287 491 291 493T304 498T321 500Q342 500 357 488T372 454Q372 426 350 403T295 379ZM492 379Q471 379 456 396T440 448Q440 533 514 627Q523 638 551 666T588 694Q592 694 599 685T606 672T589 654T544 608T499 537Q481 493 483 491Q484 491 488 493T501 498T518 500Q539 500 554 488T569 454Q569 426 547 403T492 379"],8221:[694,-379,514,176,538,"214 620Q214 647 236 670T289 694Q312 694 326 677T341 633V624Q341 588 327 550T294 482T253 428T216 392T196 379Q191 379 184 388T176 401Q176 404 195 421T243 472T287 547Q299 576 299 582L295 580Q291 578 282 576T264 573Q241 573 228 585T214 620ZM411 620Q411 647 433 670T486 694Q509 694 523 677T538 633V624Q538 588 524 550T491 482T450 428T413 392T393 379Q388 379 381 388T373 401Q373 404 392 421T440 472T484 547Q496 576 496 582L492 580Q488 578 479 576T461 573Q438 573 425 585T411 620"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Italic/GeneralPunctuation.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"],{915:[680,0,627,54,705,"337 46Q339 46 342 46Q360 46 363 45T367 34Q367 13 359 5Q356 0 343 0Q339 0 320 0T268 1T196 2Q98 2 72 0H61Q54 7 54 11Q54 27 61 41Q65 46 95 46Q131 47 142 50T159 62L194 200Q229 337 264 477T299 623Q299 630 292 631T248 634Q216 634 214 638Q213 641 213 646Q213 674 224 678Q226 680 462 680H698Q705 676 705 669Q705 665 691 557T675 447Q673 440 652 440H637Q630 445 630 451Q630 452 632 467T636 504T638 543Q638 569 632 586T615 613T586 627T549 633T500 634Q491 634 487 634Q426 634 414 633T399 625Q397 621 327 342T257 59Q257 54 261 52T283 48T337 46"],916:[716,0,818,70,751,"409 0H145Q117 0 103 0T81 1T72 3T70 6Q70 9 310 354T557 707Q559 711 565 713Q570 716 587 716Q608 716 613 710Q616 704 683 358Q752 9 750 6Q750 2 747 2Q745 0 409 0ZM581 342L531 597Q530 597 352 342T174 85T403 84T632 86Q632 87 581 342"],920:[704,22,767,149,788,"149 237Q149 326 186 413T282 563T412 665T552 704Q619 704 667 678T741 611T777 528T788 444Q788 328 728 219T572 44T377 -22Q275 -22 212 50T149 237ZM691 480Q691 569 652 618T551 668Q458 668 367 562Q307 485 277 382T246 202Q246 147 260 108T298 51T343 24T387 16Q408 16 433 22T494 51T562 109T626 211T677 363Q691 423 691 480ZM302 275Q302 281 317 346T338 415L341 418H356Q380 418 380 408Q380 405 378 398T375 385Q375 384 480 384H585L588 398Q592 412 598 418H613Q636 418 636 409Q636 406 621 340Q617 326 612 306Q603 272 598 267L597 266H582Q558 266 558 276Q558 279 560 286T563 299Q563 300 458 300H353L350 286Q346 272 340 266H325Q302 266 302 275"],923:[716,0,692,58,646,"71 0Q58 0 58 11Q58 33 68 43Q71 46 77 46Q106 46 128 59T156 79T173 104Q174 106 255 256T416 556T497 707Q502 716 519 716H525Q543 716 547 711Q550 707 561 398T572 65Q573 57 574 54T587 49T623 46Q646 46 646 36Q646 35 643 23Q642 21 641 17T640 12T639 8T638 5T636 3T633 1T629 1T624 0Q622 0 612 0T578 1T514 2Q466 2 434 2T398 1Q381 1 381 11Q381 13 383 23Q387 40 390 43T406 46Q460 46 472 63L464 298Q457 533 455 536V537Q452 537 335 317T214 90Q211 80 211 75Q211 53 244 47Q246 47 251 47T258 46Q270 46 270 34Q270 33 268 19Q264 6 258 0H247Q185 2 143 2Q77 2 71 0"],926:[678,0,664,74,755,"243 668Q243 670 250 677H640Q661 677 687 677T719 678Q741 678 747 676T754 667T740 595T726 522Q725 521 724 520T723 517T720 516T714 515T704 514Q690 514 685 515T680 525Q680 531 683 543Q690 578 690 590V597H686Q670 600 468 600Q282 599 275 596Q267 591 251 539Q246 521 243 518T228 514H224Q200 511 200 525Q200 526 220 594T243 668ZM535 277Q535 282 538 296T543 312Q543 314 411 314H278L277 310Q277 309 272 291T266 272Q264 267 245 267Q237 267 233 268T228 269T225 272T222 277L241 354Q245 368 250 389Q261 432 266 437L267 438H299Q306 431 306 428Q306 426 306 424T304 417T302 409L297 391H430L562 392L567 412Q572 431 579 438H611Q615 434 616 432L618 430Q618 423 599 352Q581 275 577 270Q574 267 568 267H558Q535 267 535 277ZM81 0Q74 4 74 11Q74 14 89 89T106 168Q112 174 127 174Q138 174 142 174T148 171T151 164Q151 163 147 143Q140 101 139 92Q139 81 140 81Q143 78 265 78H349H484Q518 78 532 78T555 80T566 83T570 91Q575 103 589 145Q595 166 598 170T611 174H617H622Q641 174 641 163Q641 162 619 86T595 7Q593 2 584 1T530 0H334H81"],928:[680,0,743,54,859,"248 634Q216 634 214 638Q213 641 213 646Q213 674 224 678Q226 680 539 680H852Q859 676 859 669Q859 653 852 639Q848 634 818 634Q782 633 771 630T754 618L719 480Q684 343 649 203T614 57Q614 50 621 49T666 46Q697 46 699 40Q701 37 698 21Q693 3 689 1Q686 0 677 0Q673 0 657 0T611 1T546 2Q453 2 428 0H418Q411 7 411 11Q411 27 418 41Q422 46 452 46Q488 47 499 50T516 62Q518 67 553 209T624 491T660 632Q660 634 530 634H400L399 630Q399 629 390 593T363 484T328 344Q257 60 257 57Q257 50 264 49T309 46Q340 46 342 40Q344 37 341 21Q336 3 332 1Q329 0 320 0Q316 0 300 0T254 1T189 2Q96 2 71 0H61Q54 7 54 11Q54 27 61 41Q65 46 95 46Q131 47 142 50T159 62L194 200Q229 337 264 477T299 623Q299 630 292 631T248 634"],931:[683,1,716,80,782,"87 0Q80 7 80 11Q80 14 81 15Q81 16 231 161Q381 304 381 305L310 475Q239 646 239 648T242 662T247 677Q247 681 251 681Q253 683 514 683H775Q780 678 782 674Q782 668 767 559T751 448Q747 443 729 443Q715 443 711 444T707 453Q707 454 710 479T713 529Q713 555 709 573T691 604T663 622T619 632T564 636T492 637H457Q356 637 356 635Q358 634 417 489T478 343Q478 340 474 335T436 297T330 196L185 57L294 56H339Q450 56 499 65T581 109Q603 131 620 164T646 221T657 248Q660 250 675 250Q699 253 699 239L681 188Q663 138 643 81T617 9Q614 2 605 1T552 -1Q541 -1 475 -1T348 0H87"],933:[706,0,767,213,832,"213 543Q213 576 262 640T379 705Q507 705 507 531Q507 514 505 492L504 482L514 505Q524 528 543 561T587 626T653 682T738 705Q783 705 807 675T832 594Q832 535 808 535H802Q780 535 780 542Q780 543 781 550T783 563Q783 589 765 606T716 623Q588 623 521 354Q521 353 485 208T448 59Q448 46 529 46Q559 46 559 36Q559 31 556 22Q552 4 547 1Q546 1 544 1T538 0Q534 0 514 0T458 1T380 2Q271 2 241 0H228Q222 6 222 9T224 27Q228 40 234 46H257Q322 46 336 52Q346 54 349 62Q351 64 372 145T416 324T445 461Q446 471 446 506Q446 528 445 541T436 577T410 610T361 622Q319 622 295 600T261 552Q257 539 249 536Q245 535 233 535T218 536L214 540V541Q213 542 213 543"],934:[683,0,716,159,729,"467 624Q467 631 454 633T400 637Q361 637 359 643Q358 644 358 649Q358 673 369 682Q371 683 387 683Q430 681 532 681Q569 681 600 681T650 682T672 683Q689 683 689 672Q689 670 686 658T681 643Q679 637 640 637Q595 636 579 633T558 617Q556 613 547 575T538 533Q538 532 541 532Q555 532 582 524T643 500T703 450T728 374Q728 311 673 256Q621 203 550 177T445 151Q443 151 441 149Q440 146 430 104T419 59Q419 46 500 46Q530 46 530 36Q530 31 527 22Q523 4 518 1Q517 1 515 1T510 0Q505 0 486 0T431 1T355 2Q248 2 218 0H205Q199 6 199 9T201 27Q205 40 211 46H234Q300 46 313 52Q323 54 326 62Q328 64 334 86T344 129L349 150Q349 151 346 151Q333 151 307 158T245 182T185 231T159 309V314Q159 325 162 338T174 374T207 421T264 468Q334 518 435 531L446 533L457 577Q467 620 467 624ZM436 494Q429 494 417 492T373 477T319 442Q288 408 274 362T260 284Q260 257 269 239T298 210T328 196T359 188L436 494ZM626 398Q626 438 605 460T539 493L528 495Q527 495 489 342T451 188Q455 188 462 189T490 197T528 212T566 241T598 285Q626 341 626 398"],936:[683,0,767,207,824,"494 626Q493 627 493 628T491 629T489 631T484 632T477 634T465 635T449 636T426 637Q387 637 385 643Q384 644 384 649Q384 673 395 682Q397 683 413 683Q456 681 558 681Q595 681 626 681T676 682T698 683Q715 683 715 672Q715 670 712 658T707 643Q705 637 666 637Q621 636 605 633T584 617L478 193Q486 195 498 199T542 229T597 291Q626 335 646 415Q669 500 694 523T759 546H777H801Q824 546 824 536Q822 509 809 509Q762 509 735 406Q707 300 642 234T481 153L467 151L456 106Q445 62 445 59Q445 46 526 46Q556 46 556 36Q556 31 553 22Q549 4 544 1Q543 1 541 1T536 0Q531 0 512 0T457 1T381 2Q274 2 244 0H231Q225 6 225 9T227 27Q231 40 237 46H260Q326 46 339 52Q349 54 352 62Q354 64 365 106T376 151Q374 152 371 152Q360 153 347 156T310 172T270 201T239 250T225 323Q225 359 235 405T245 470T239 498T226 507T213 510T207 520Q207 528 209 534T215 544L218 546H257Q305 546 314 540Q338 530 338 485Q338 455 326 402T313 312Q313 218 379 193Q386 192 387 192Q387 196 441 408Q494 621 494 626"],937:[705,0,716,100,759,"183 393Q183 451 206 502T267 590T348 652T435 691T510 704Q513 705 525 705Q631 705 695 650T759 505Q759 454 732 397T672 299T593 203T527 117Q503 81 503 76Q503 75 521 75Q576 75 588 77Q589 77 592 78T595 79T598 80T602 82T605 86T609 92T614 101T620 112T627 127T636 147Q646 169 649 170Q651 172 667 172H682Q689 167 689 162Q689 158 654 81T617 2Q614 0 530 0H447Q441 5 441 9T444 28Q461 85 498 158T569 285T628 408T654 534Q654 592 621 630T527 668Q488 668 448 649T371 593T310 487T286 330Q286 302 290 247T294 137Q294 34 280 6Q278 1 268 1T190 0H107Q100 5 100 12Q100 24 103 94T108 165Q110 172 131 172H146Q150 169 153 165L152 141V116Q152 84 153 82Q156 75 217 75H252V84Q252 126 218 231T183 393"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Italic/GreekAndCoptic.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"],{8463:[695,13,540,42,562,"150 475Q147 475 118 466T82 457Q73 457 64 467T54 487Q54 490 55 492Q63 506 64 506Q67 512 118 526Q162 541 169 546Q173 559 175 575Q181 596 181 604Q181 613 166 617Q164 617 153 618T135 619Q119 619 114 621T109 630Q109 636 114 656T122 681Q125 685 202 688Q272 695 286 695Q304 695 304 684Q304 682 291 628L278 577L386 612Q466 635 476 635T492 627T499 607Q499 593 489 586Q485 583 373 546L262 512Q262 511 248 455T233 397T236 397T244 404Q295 441 357 441Q405 441 445 417T485 333Q485 284 449 178T412 58T426 44Q447 44 466 68Q485 87 500 130L509 152H531H543Q562 152 562 144Q562 128 546 93T494 23T415 -13Q385 -13 359 3T322 44Q318 52 318 77Q318 99 352 196T386 337Q386 386 346 386Q318 386 286 370Q267 361 245 338T211 292Q207 287 193 235T162 113T138 21Q128 7 122 4Q105 -12 83 -12Q66 -12 54 -2T42 26Q42 45 98 257L151 475H150"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Italic/LetterlikeSymbols.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"],{567:[442,204,332,-32,327,"75 284T75 287T81 305T101 343T133 389T180 426T240 442Q273 440 300 420T327 350V332L278 134Q267 92 253 37T233 -45T225 -73Q208 -123 162 -163T54 -204Q8 -204 -15 -181Q-32 -164 -32 -140Q-32 -112 -14 -96T27 -79Q48 -79 57 -91T67 -114Q67 -146 39 -166L44 -167H59H60Q112 -167 145 -74Q148 -65 198 134T251 347Q252 353 252 370Q252 382 251 388T245 399T230 405Q204 405 175 378Q157 360 145 337T126 298T117 280T98 278H81Q75 284 75 287"]});MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Main/Italic/LatinExtendedB.js");MathJax.Hub.Insert(MathJax.OutputJax.SVG.FONTDATA.FONTS["MathJax_Main-italic"],{32:[0,0,250,0,0,""],33:[716,0,307,107,380,"330 716Q351 716 365 703T380 670V659L304 433Q230 207 227 204Q225 198 205 198Q184 198 184 207T220 439T260 669Q270 694 297 708Q300 709 304 710T311 713T316 714Q324 716 330 716ZM107 51Q110 83 133 102T179 121Q207 121 219 105T231 72Q231 45 209 23T156 0Q138 0 123 11T107 51"],34:[694,-379,514,176,538,"214 620Q214 647 236 670T289 694Q312 694 326 677T341 633V624Q341 588 327 550T294 482T253 428T216 392T196 379Q191 379 184 388T176 401Q176 404 195 421T243 472T287 547Q299 576 299 582L295 580Q291 578 282 576T264 573Q241 573 228 585T214 620ZM411 620Q411 647 433 670T486 694Q509 694 523 677T538 633V624Q538 588 524 550T491 482T450 428T413 392T393 379Q388 379 381 388T373 401Q373 404 392 421T440 472T484 547Q496 576 496 582L492 580Q488 578 479 576T461 573Q438 573 425 585T411 620"],35:[694,194,818,115,828,"281 327H228Q186 327 175 330T164 347Q164 359 176 365Q179 367 292 367H404L563 688Q569 694 578 694T593 686T597 670Q597 667 531 535L448 367H614L773 688Q779 694 787 694Q796 694 802 688T808 674V672L807 670Q807 667 732 517L658 368L736 367H814Q828 357 828 347Q828 336 812 327H637L599 250Q561 174 561 173H662H724Q760 173 769 170T779 153T770 136T729 132Q721 132 696 132T651 133H540L380 -188Q374 -194 366 -194Q357 -194 351 -188T345 -174L346 -172V-170Q346 -167 412 -35L495 133H330L170 -188Q164 -194 156 -194Q147 -194 141 -188T135 -174L136 -172V-170Q136 -167 211 -17L285 133H207L130 134Q115 140 115 153Q115 164 131 173H306L344 250Q382 326 382 327H281ZM592 327H427L389 250Q351 174 351 173H516L554 250Q592 326 592 327"],37:[750,56,818,145,847,"301 348Q257 348 231 383T205 480Q205 553 244 629T346 736Q370 750 394 750Q416 750 429 742T458 714Q512 644 606 644Q722 644 802 732Q817 750 827 750Q835 750 841 744T847 730Q847 725 827 700T689 540Q586 421 512 335Q180 -50 176 -52Q172 -56 165 -56Q157 -56 151 -50T145 -35Q145 -29 162 -9T330 186Q392 258 430 302Q711 627 711 628L701 624Q652 607 604 607Q551 607 494 634L479 642V624Q479 544 439 467Q414 416 377 382T301 348ZM270 443Q270 385 303 385H306H308Q326 385 348 407Q384 441 409 504T434 627Q434 713 390 713Q358 713 328 663Q307 631 289 556T270 451V443ZM608 -56Q573 -56 543 -23T513 76Q513 129 536 190T604 296L627 318Q670 347 704 347Q747 347 767 310T788 222Q788 126 732 35T608 -56ZM742 222Q742 310 699 310Q677 310 655 285T620 227Q608 197 593 138T578 42V36Q578 -18 613 -18Q657 -18 699 64T742 222"],38:[716,23,767,127,802,"209 444Q209 546 278 631T424 716Q473 716 501 683T530 601Q530 554 511 535T467 515Q446 515 437 527T427 553Q427 578 446 594T481 610H483V617Q480 641 464 660T419 679Q367 679 328 603Q316 578 305 538T288 470L282 443L295 449Q308 455 330 462T371 469Q397 469 413 450T430 404Q430 363 400 329T331 295Q291 295 256 322Q255 322 246 293T227 223T217 158Q217 117 232 88T273 43T327 22T387 15Q457 15 512 37T599 93T652 169T680 248T688 317T678 380T659 423T647 437Q643 435 637 431T613 416T581 392T554 364T538 332Q540 310 541 310Q554 335 587 335Q601 335 613 327T626 300Q626 290 622 279T603 255T563 242Q532 245 512 263T491 320Q494 351 511 377T547 418T600 456T652 494Q676 512 697 539T728 582T738 601Q738 602 736 602Q732 602 726 604T714 616T707 638Q707 661 724 677T764 694Q799 694 802 660Q802 625 767 562T688 467L694 458Q700 449 702 444T711 428T720 408T727 385T733 358T735 327Q735 281 724 235T685 141T617 59T515 1T375 -22Q270 -22 199 34T127 181Q127 216 147 270T207 374L216 386Q209 421 209 444ZM386 412Q386 432 366 432Q345 432 325 418T294 390T284 375Q284 371 289 362T306 343T335 332Q355 332 367 350T383 384T386 412"],39:[694,-378,307,212,377,"250 620Q250 647 272 670T325 694Q348 694 362 677T377 633V624Q377 566 343 506T275 412T231 379Q226 379 220 388T213 401T232 421T279 472T323 547Q335 573 335 582L331 580Q327 578 318 576T300 573Q277 573 264 585T250 620"],40:[750,250,409,144,517,"241 -250Q203 -212 174 -140T144 39Q144 158 180 288T296 544T481 746L487 750H499Q517 750 517 740Q517 736 495 716Q399 630 331 491T236 228T208 3Q208 -73 224 -130T255 -214T271 -244Q271 -250 252 -250H241"],41:[750,250,409,17,390,"326 497Q326 546 320 588T304 655T285 699T269 728T262 740Q262 746 267 749L272 750Q276 750 281 750H293Q331 712 360 640T390 461Q390 332 339 171T188 -116Q161 -150 121 -188T47 -250H35Q17 -250 17 -240Q17 -236 39 -216Q135 -130 203 9T298 272T326 497"],42:[750,-320,511,195,584,"560 658Q569 658 576 649T584 631Q584 625 583 620T577 611T569 603T556 595T540 587T519 578T494 566L428 536Q427 535 433 531T479 502Q525 475 532 469T539 450Q538 435 525 424T497 412Q489 412 482 418T442 456Q400 497 400 494L387 420Q376 353 373 343T352 323Q345 320 336 320H331Q322 320 316 327T309 343Q309 347 334 420L359 496Q358 496 297 456T234 414Q228 411 221 411Q212 411 204 417T195 439Q198 458 209 465T283 502L353 534L300 566Q255 593 247 599T239 616Q239 631 252 644T282 658Q290 658 295 654T335 615L378 573L391 647Q393 657 395 671T398 691T400 706T404 720T408 730T414 739T423 744T434 749Q435 749 439 749T445 750Q467 748 469 728Q469 723 457 685T432 610L420 573L481 613Q548 658 560 658"],43:[557,57,767,139,753,"139 237T139 250T151 266T198 270H293H431L465 407Q469 424 476 452Q494 528 500 542T519 557Q526 557 532 552T538 538Q538 536 507 409T472 272Q472 270 604 270Q737 270 741 268Q753 261 753 250Q753 237 742 233T696 229Q687 229 655 229T599 230H462L461 226Q461 224 427 91T392 -47Q387 -57 374 -57Q367 -57 361 -51T355 -37Q355 -31 388 99L421 230H288Q267 230 238 230T199 229Q163 229 151 233"],44:[121,194,307,69,232,"106 46Q106 68 121 90T167 120Q168 120 173 120T180 121Q232 121 232 59V54Q232 18 219 -20T186 -88T145 -143T109 -181T88 -194Q84 -194 77 -185T69 -171Q69 -168 70 -166T76 -161T85 -154T101 -139T124 -114Q146 -88 162 -58T183 -12T188 7Q187 7 183 5T172 2T156 0Q129 0 118 14T106 46"],45:[251,-180,358,84,341,"205 180H131Q102 180 93 181T84 190Q90 238 103 251H334Q341 244 341 241Q341 236 336 214T327 186Q325 181 312 181T205 180"],46:[121,0,307,107,231,"107 50Q107 76 129 98T181 121Q203 121 217 108T231 72Q231 47 210 24T156 0Q135 0 121 13T107 50"],47:[750,250,511,19,617,"596 750Q604 750 610 744T617 730L616 728Q616 727 616 726Q615 723 337 244T55 -242Q49 -250 40 -250Q30 -250 25 -243Q18 -238 20 -226Q21 -223 299 256T581 742Q589 750 596 750"],48:[665,21,511,110,562,"414 665Q562 665 562 490Q562 426 534 318Q451 -21 251 -21Q222 -21 202 -15Q155 2 134 40T110 144Q110 201 127 286T187 470T287 614Q348 665 414 665ZM187 98Q187 59 208 37T260 15Q320 15 365 83Q394 128 440 312T487 547Q487 580 471 600T433 627Q428 628 408 628Q381 628 353 609T311 569Q279 526 239 364T190 143Q187 120 187 98"],49:[666,0,511,110,468,"248 491Q228 491 228 502Q228 516 236 532Q237 536 246 537T275 541T314 552Q350 567 382 595T430 644L446 664Q450 666 454 666Q468 666 468 658Q468 647 395 359Q321 63 321 59Q321 52 334 50T388 46H422Q428 37 428 35Q428 19 421 5Q416 0 405 0Q400 0 361 1T263 2Q215 2 185 2T142 1T127 0Q110 0 110 11Q110 13 113 25T118 40Q120 46 146 46Q196 46 212 49T235 61Q238 66 295 295L353 526L340 519Q328 512 302 503T248 491"],50:[666,22,511,76,551,"159 404Q159 433 176 476T222 562T297 635T395 666Q466 666 508 617T551 497Q551 473 545 446Q534 388 482 333Q441 292 355 240T264 184Q216 151 179 101L171 91Q171 90 177 90Q206 90 269 77T366 64Q385 64 390 65Q418 73 441 98T475 156Q479 168 481 170T495 173H518Q524 167 524 166T521 152Q502 86 459 32T353 -22Q315 -22 259 15T172 53Q156 53 143 36T126 1L121 -16Q119 -22 98 -22H82Q76 -16 76 -13T80 5T98 50T132 111T189 178T274 242Q327 273 364 305T420 370T447 427T460 483Q466 514 466 538Q466 586 443 607T389 629Q338 629 293 584T226 487T204 399Q204 390 204 386T209 378T222 373Q258 376 282 422T307 493Q307 506 302 517T297 531Q297 537 308 546T327 551Q329 550 333 543T340 523T344 497Q344 450 306 393T216 336Q186 336 173 355T159 396V404"],51:[666,22,511,96,562,"296 531Q296 536 307 544T322 553Q330 553 338 534T346 501Q346 468 319 440T258 412Q232 412 216 430T200 478Q200 552 281 618Q345 666 416 666Q489 666 525 625T562 530Q562 473 525 419T430 335L416 329Q479 288 479 206Q479 142 440 89T344 7T229 -22Q173 -22 135 12T96 106Q96 192 157 192Q192 192 197 157Q197 134 184 117T142 96Q153 47 180 29Q201 15 232 15Q249 15 275 22Q307 34 331 57Q363 90 379 153T396 246Q396 261 393 272T384 290T371 301T355 308T341 311T326 312H316H307Q287 312 282 313T276 320Q276 323 279 337T283 352Q284 356 290 357T325 358Q364 359 368 360Q386 365 400 372T433 397T464 448T485 527Q487 535 487 556Q487 629 414 629Q350 629 298 580T245 476Q245 450 263 450H264Q280 450 294 463T308 496Q308 508 302 518T296 531"],52:[666,195,511,46,478,"448 34Q453 34 463 22T473 5Q473 -2 457 -7Q417 -22 383 -23H366L350 -91Q348 -98 345 -111T340 -130T335 -146T330 -161T325 -172T318 -182T310 -188T299 -193T286 -194Q256 -194 253 -165Q253 -159 271 -83T292 -5Q231 29 169 29Q114 29 91 14Q72 -2 65 1Q46 20 46 28Q46 35 55 43T77 60T96 74Q306 257 396 623Q410 666 444 666Q459 666 468 657T478 634Q478 627 470 595T440 504T387 381T303 239T187 99L164 75H178Q217 75 260 59L304 43Q304 48 325 127Q342 195 346 207T358 228Q372 242 391 242Q403 242 413 235T423 214Q423 205 402 116T378 25Q378 23 387 23Q405 23 418 25T439 31T448 34"],53:[667,22,511,106,567,"196 304Q189 309 189 314Q189 317 231 487T275 660Q278 666 283 666Q287 666 302 658T346 643T413 635Q447 635 481 642T537 658T559 666Q561 666 564 663T567 658Q565 637 557 629Q528 600 474 573T359 545Q342 545 327 546T304 550T294 552L291 540Q288 529 283 507T273 465L251 379Q307 420 364 420Q415 420 456 382T497 261Q497 165 429 82T262 -20Q256 -20 247 -21T233 -22Q176 -22 141 15T106 112Q106 208 173 208Q192 208 203 197T214 169Q214 143 195 125T156 107H153V100Q155 73 174 47T239 21Q245 21 259 23Q355 46 392 200Q393 205 394 207Q412 276 412 312Q412 352 396 367T358 383Q288 383 233 314Q226 306 224 305T209 304H196"],54:[665,22,511,120,565,"377 434Q425 434 457 404T499 341T509 278Q509 243 496 194T456 105T383 27Q322 -22 256 -22Q142 -22 122 114Q120 130 120 159Q120 221 135 292T195 452T310 599Q390 665 465 665Q565 665 565 583V574Q565 543 546 524Q528 506 504 506Q491 506 478 514T465 543Q465 585 515 602Q505 626 466 626Q419 626 372 587Q334 557 305 503T266 409L255 370Q287 410 339 429Q361 434 377 434ZM424 333Q424 359 411 378T365 397Q318 397 282 356T230 257T205 157T197 94Q197 67 211 45T260 22Q313 22 341 57T386 151Q424 283 424 333"],55:[666,22,511,136,634,"466 519Q448 519 435 528T416 550T400 571T376 581Q324 581 271 540T186 437Q185 435 183 432T181 428T179 426T177 424T174 423T171 422T165 422H159Q141 422 141 423Q136 423 136 431Q136 433 190 548T247 665Q249 666 266 666H282Q288 660 288 657Q288 655 284 646T276 628L273 620Q337 666 390 666Q413 666 425 652T438 620T444 584T457 559Q460 557 470 557Q497 557 524 582T571 635T594 665Q595 666 612 666H628Q634 660 634 657Q634 653 618 629T572 556T510 441T437 269T367 43Q356 -22 304 -22Q291 -22 278 -14T263 14Q263 36 281 95T354 269T486 507Q497 524 495 524Q482 519 466 519"],56:[666,21,511,99,553,"209 449Q209 545 278 605T416 666Q482 666 517 631T553 546Q553 513 539 482T504 430T463 394T426 370L410 360L430 343Q471 309 483 278T495 211Q495 141 441 75Q363 -21 253 -21Q182 -21 141 18T99 117Q99 161 119 201T170 268T222 308T259 331L272 338L259 349Q212 389 209 449ZM492 542Q492 586 469 605T415 625Q360 625 320 587T279 505Q279 495 281 487T286 474T295 460T306 449T321 436T337 422Q379 386 380 386Q389 386 420 412T472 471Q492 513 492 542ZM163 118Q163 76 189 49T258 21Q316 21 368 64T420 170Q420 193 412 208T395 233T350 271L302 312Q298 312 284 303T249 276T209 235T177 181T163 118"],57:[666,22,511,107,554,"297 211Q258 211 230 228T189 273T169 323T163 367Q163 411 183 472T254 585Q327 656 401 665Q403 665 412 665T427 666Q458 664 481 652T518 622T539 580T550 535T553 491Q553 448 544 395T515 277T454 148T358 37Q282 -22 213 -22Q166 -22 137 -1T107 55V64Q107 88 114 104T134 127T154 136T169 138Q185 138 196 128T207 101Q207 82 196 68T172 48L161 43Q161 40 167 36T187 26T219 21Q286 21 344 99Q364 126 382 169T408 241T417 275L412 269Q406 263 395 253T370 234T337 218T297 211ZM476 552Q476 626 417 626Q368 626 330 584Q312 563 300 533T270 433Q248 341 248 312Q248 286 262 267T310 248Q353 248 387 287T440 380T467 480T476 552"],58:[431,0,307,107,308,"184 358Q184 385 206 408T258 431Q279 431 293 418T308 383Q308 354 284 332T233 310Q212 310 198 324T184 358ZM107 50Q107 76 129 98T181 121Q203 121 217 108T231 72Q231 47 210 24T156 0Q135 0 121 13T107 50"],59:[431,195,307,70,308,"184 358Q184 385 206 408T258 431Q279 431 293 418T308 383Q308 354 284 332T233 310Q212 310 198 324T184 358ZM107 47Q107 77 130 99T180 121Q226 121 226 61Q226 25 214 -14T182 -84T144 -140T109 -180T88 -194T77 -185T70 -172Q70 -169 84 -155T121 -112T161 -48Q180 -10 180 3Q180 4 174 2Q172 2 166 1T156 0Q135 0 121 13T107 47"],61:[367,-133,767,116,776,"776 357T776 347T761 327H470Q180 327 176 329Q164 334 164 347Q164 359 176 365Q179 367 470 367H761Q776 357 776 347ZM116 143T116 153T131 173H422Q713 173 717 171Q728 166 728 153T717 135Q713 133 422 133H131Q116 143 116 153"],63:[716,0,511,195,551,"235 431Q217 431 206 442T195 468Q195 490 215 537T280 638T380 707Q403 716 423 716Q425 716 429 716T436 715Q485 715 518 681T551 590Q551 543 530 503T482 439Q471 428 400 375T318 310Q300 287 300 259Q300 236 315 236Q333 236 352 251T384 300Q386 306 407 306H423Q429 300 429 297Q429 272 393 235T308 198Q287 198 269 215T251 270Q251 330 293 374L374 436Q377 438 401 456T432 480T457 503T481 531T494 561T501 598Q501 614 499 626Q482 678 430 678H426Q392 678 362 660T311 615T280 571T264 540L259 528Q259 527 266 526T283 516T294 492Q294 466 276 449T235 431ZM209 51Q212 83 235 102T281 121Q309 121 321 105T333 72Q333 45 311 23T258 0Q240 0 225 11T209 51"],64:[705,12,767,152,789,"198 250Q198 155 248 91T394 26Q514 26 640 80L650 84H675H683Q709 84 709 76Q709 73 708 71Q706 64 660 45T534 8T383 -11T260 24T181 115Q152 168 152 248Q152 410 268 552Q303 590 324 608Q439 705 551 705Q611 705 658 683T733 623T775 543T789 454Q789 380 766 304T720 192Q677 125 617 125Q591 125 573 137T548 160T541 176Q541 178 540 178L534 173Q527 168 515 160T488 144T454 131T417 125Q361 125 320 166T279 284Q279 393 356 481T523 569Q570 569 603 537Q623 515 632 490L637 480L657 479Q684 479 684 470Q684 465 650 333L617 199V185Q616 162 628 162Q677 162 712 278Q743 381 743 442Q743 555 687 611T553 668Q467 668 385 608T250 450T198 250ZM598 445Q598 453 594 470T569 510T518 532Q463 532 410 448T356 271Q356 220 374 191T423 162Q482 162 552 255L575 348Q598 440 598 445"],65:[716,0,743,58,696,"85 46Q112 48 132 56T161 73T176 92T185 104Q185 106 353 407T524 709Q527 716 551 716Q568 716 572 712Q573 711 574 710Q576 708 594 384Q613 54 617 52H618Q626 46 672 46H689Q696 41 696 36Q696 13 683 0H670Q639 2 557 2Q526 2 500 2T459 2T441 1Q425 1 425 10Q425 12 427 24Q428 27 429 31T430 36T432 40T434 43T437 45T443 46T450 46Q514 46 514 69Q514 74 511 136L506 209H292L260 152Q222 84 222 74Q222 48 264 46Q280 46 280 35Q280 33 278 21Q275 7 272 4T259 0Q256 0 232 1T159 2Q135 2 109 1T78 0Q58 0 58 10Q58 14 61 26T66 40Q68 46 85 46ZM504 260Q503 263 496 407T486 553L466 520Q446 486 402 406L318 256Q318 255 411 255H504V260"],66:[683,0,704,57,732,"57 11Q57 38 69 45L74 46Q78 46 85 46T99 46Q134 47 145 50T162 62Q164 66 233 344T303 626Q303 627 302 629V631Q296 637 241 637H223Q217 642 217 645T219 664Q223 677 229 683H411L593 682L605 680Q616 678 628 675T660 662T694 639T720 601T732 547Q732 519 726 503Q710 452 662 414T556 360L545 357L556 355Q604 346 641 312T678 221Q678 155 622 92T482 8Q459 2 439 2T256 0H154H105Q74 0 66 2T57 11ZM629 549Q628 550 629 557T627 576T619 600T601 622T570 636Q564 637 490 637Q472 637 454 637T424 636T411 636Q399 635 395 622T364 500Q333 377 332 376Q332 374 408 374L485 375L495 377Q547 390 588 437T629 549ZM504 336Q500 337 410 337Q323 337 322 336Q322 334 305 263T270 122T252 51Q252 47 337 46Q346 46 361 46T384 45Q425 45 455 55T515 95Q574 156 574 235Q574 276 555 304T504 336"],67:[705,21,716,150,812,"395 -21Q279 -21 215 56T150 244Q150 402 265 543Q339 630 421 667T562 704Q596 704 604 703Q627 698 647 689T679 669T699 649T711 633T716 627L753 665Q790 704 792 704Q793 705 798 705Q812 705 812 698Q812 694 780 561Q744 422 744 421Q742 416 739 415T721 413H705Q699 419 699 426Q701 432 701 444Q705 464 705 493Q705 524 700 551T681 604T643 644T583 659Q480 659 387 570Q321 502 287 397T252 213Q252 123 297 74Q347 24 421 24Q500 24 564 89T653 240Q656 253 659 255T677 257Q700 257 700 248Q700 242 694 222Q681 183 656 143T593 65T504 3T395 -21"],68:[683,0,755,56,775,"56 11Q56 38 68 45L72 46Q77 46 84 46T98 46Q133 47 144 50T161 62Q163 66 232 344T302 626Q302 627 302 629L301 631Q295 637 240 637H222Q216 642 216 645T218 664Q222 677 228 683H403Q582 683 589 682Q672 674 723 608T775 440Q775 312 709 209T562 54Q502 14 432 2Q423 1 243 0H148H102Q72 0 64 2T56 11ZM254 51Q254 46 348 46Q395 46 422 50T484 71Q585 121 633 255Q679 396 679 477Q679 522 665 554T629 603T587 626T548 636Q547 636 536 636T510 636T480 637Q420 637 411 636T398 627Q396 623 325 339T254 51"],69:[680,0,678,54,743,"248 634Q216 634 214 638Q213 641 213 646Q213 674 224 678Q226 680 481 680H736Q743 676 743 669Q743 665 729 557T713 447Q711 440 690 440H675Q667 445 667 454Q667 455 671 481T675 536Q675 583 658 604T592 632Q574 634 475 634Q439 634 424 633T405 631T399 625Q397 622 367 501T336 377Q336 376 367 376H388Q451 376 477 389Q493 399 503 419T520 462T528 489Q531 493 549 493Q557 493 561 492T566 491T569 488T572 483L539 351Q507 221 503 216Q503 216 500 213H484Q468 213 465 216Q461 219 461 225Q461 228 466 250T472 290Q472 317 452 323T368 330H324Q323 326 289 191T255 51T331 46H360Q413 46 444 49T511 67T570 113Q589 137 608 175T638 242T652 272Q656 274 670 274Q693 274 693 262L648 148Q590 4 588 2Q585 0 323 0H61Q54 4 54 11Q54 27 61 41Q65 46 95 46Q131 47 142 50T159 62L194 200Q229 337 264 477T299 623Q299 630 292 631T248 634"],70:[680,-1,653,54,731,"299 623Q299 630 292 631T247 634H219Q213 640 213 642T215 661Q218 673 225 680H724Q731 676 731 669Q731 665 717 557T701 447Q699 440 678 440H663Q656 444 656 452Q656 457 659 485T663 538Q663 586 644 607T566 633Q564 633 535 633T486 634H458Q404 634 399 625Q396 620 364 492L332 363H380Q446 365 464 373Q496 389 514 458Q518 477 523 479Q527 480 541 480H556Q563 475 563 470Q563 467 532 339T498 207Q496 200 475 200H460Q453 207 453 212Q454 213 456 225T461 254T464 278Q464 304 445 310T369 317H321L289 190Q257 66 257 59Q257 54 261 52T283 48T337 46Q348 46 352 46T360 45T366 42T368 37Q368 32 365 23Q360 4 355 2Q352 1 342 1Q336 1 297 1T199 2Q138 2 106 2T71 1H68Q54 1 54 11Q54 38 66 45L70 46Q75 46 82 46T96 46Q131 47 142 50T159 62L194 200Q229 337 264 477T299 623"],71:[705,22,774,150,812,"632 -1Q629 -1 622 5T604 25T583 53Q508 -22 394 -22Q287 -22 219 52T150 244Q150 402 265 543Q339 630 421 667T562 704Q596 704 604 703Q627 698 647 689T679 669T699 649T711 633T716 627L753 665Q790 704 792 704Q793 705 798 705Q812 705 812 698Q812 694 780 561Q744 422 744 421Q742 416 739 415T721 413H705Q699 419 699 426Q701 432 701 444Q705 464 705 493Q705 524 700 551T681 604T643 644T583 659Q480 659 387 570Q319 501 286 394T252 208Q252 156 269 118T314 61T369 33T425 24Q470 24 509 46T566 104Q571 116 583 162T595 214Q595 222 583 223Q561 227 517 227H495Q488 230 488 238Q488 254 495 268Q500 273 511 273Q515 273 532 273T581 272T649 271Q731 271 752 273H761Q767 267 767 264T765 246Q761 233 755 227H742Q698 227 693 213L639 4Q636 -1 632 -1"],72:[683,0,743,54,860,"61 0Q54 7 54 11Q54 27 61 41Q65 46 95 46Q131 47 142 50T159 62Q161 66 230 344T300 626Q300 627 300 629L299 631Q293 637 238 637H220Q214 642 214 645T216 664Q220 677 226 683H239Q307 681 372 681Q480 681 486 683H496Q502 677 502 674T500 656Q496 643 490 637H472Q418 637 406 630Q400 627 396 612T367 500Q360 474 352 442T340 395L336 380Q336 378 466 378H596Q657 622 657 626Q657 627 656 629V631Q650 637 595 637H577Q571 642 571 645T573 664Q577 677 583 683H596Q664 681 729 681Q837 681 843 683H853Q860 676 860 672Q858 647 848 637H819Q783 636 772 634T756 623Q753 618 684 340T614 57Q614 50 621 49T666 46Q697 46 699 40Q701 37 698 21Q693 3 689 1Q686 0 677 0Q673 0 657 0T611 1T546 2Q453 2 428 0H418Q411 7 411 11Q411 27 418 41Q422 46 452 46Q488 47 499 50T516 62Q517 64 550 196T584 331Q584 332 454 332H324L291 197Q257 64 257 56Q257 50 265 49T309 46Q340 46 342 40Q344 37 341 21Q336 3 332 1Q329 0 320 0Q316 0 300 0T254 1T189 2Q96 2 71 0H61"],73:[683,0,386,49,508,"235 637Q217 637 213 638T209 649Q209 673 220 682Q222 683 237 683Q278 681 369 681Q404 681 441 682T483 683Q499 683 503 681T508 672Q508 670 505 658T500 643Q498 637 464 637Q425 635 415 633T398 621Q396 618 327 340T257 58T260 52T278 48T322 46Q349 46 349 36Q349 31 346 22Q342 4 337 1Q336 1 334 1T329 0Q325 0 307 0T258 1T190 2Q95 2 67 0H56Q49 7 49 11Q51 38 62 46H91Q129 47 141 50T159 62Q161 66 230 344T300 625Q300 637 235 637"],74:[683,22,525,78,622,"361 637Q333 637 331 641Q330 644 330 649Q330 673 341 682Q343 683 360 683Q405 681 500 681Q551 681 577 681T607 682Q622 682 622 673Q622 665 616 647Q614 640 610 639T587 637Q547 636 541 624Q538 618 477 374T413 124Q391 64 333 22T207 -21T109 12T78 86Q78 130 101 150T149 170Q193 170 196 129Q196 100 178 80T137 58L132 57Q134 52 138 46T160 28T205 16Q242 16 273 48T319 122Q322 129 383 371T444 627Q444 637 361 637"],75:[683,0,769,54,859,"668 621Q668 635 645 637Q629 637 629 648Q629 650 632 662T637 677Q640 682 653 682Q657 682 688 681T764 680Q786 680 810 681T839 682Q859 682 859 672Q859 655 852 643Q849 637 839 637Q804 637 768 621T717 595T697 578Q696 578 600 497L505 417L508 408Q543 311 574 227T618 106T632 69Q645 47 688 46H707Q713 38 713 37T710 19Q706 6 700 0H688Q659 2 587 2Q557 2 532 2T492 2T474 1Q458 1 458 10Q458 13 460 23Q464 39 466 42T480 46Q526 46 526 72Q526 75 476 213L427 350Q426 350 396 325T334 272T302 242Q302 241 299 230T290 194T279 150Q257 61 257 55Q257 50 265 49T309 46H337Q343 40 343 38T341 19Q337 6 331 0H316Q280 2 190 2Q158 2 131 2T89 2T70 1Q54 1 54 11Q54 38 66 45L70 46Q75 46 82 46T96 46Q131 47 142 50T159 62Q161 66 230 344T300 626Q300 627 300 629L299 631Q293 637 238 637H220Q214 642 214 645T216 664Q220 677 226 683H239Q307 681 372 681Q386 681 414 681T464 682L487 683H496Q502 677 502 674T500 656Q495 641 491 637H462Q426 636 415 634T399 623Q396 618 358 467L320 314Q321 314 484 452Q510 474 552 509Q625 570 646 590T668 621"],76:[683,0,627,54,628,"61 0Q54 4 54 11Q54 27 61 41Q65 46 95 46Q131 47 142 50T159 62Q161 66 230 344T300 626Q300 627 300 629L299 631Q293 637 238 637H220Q214 642 214 645T216 664Q220 677 226 683H240Q275 681 371 681Q407 681 438 681T487 682T509 682Q527 682 527 674Q527 670 524 659Q523 657 523 654T522 649T520 645T519 642T517 640T515 639T512 638T507 637T502 637T494 637H478Q433 636 417 633T396 617Q395 614 325 334T255 51Q255 47 319 47Q387 47 410 52Q459 65 494 98T543 163T570 229T589 273H622Q628 264 628 262Q628 259 584 133T539 5Q537 1 511 1Q482 0 296 0H61"],77:[683,0,897,58,1010,"72 1Q58 1 58 11Q58 33 66 41Q68 46 87 46Q150 50 168 84Q172 91 238 356T304 626Q304 627 304 629L303 631Q297 637 242 637H224Q218 642 218 645T220 664Q224 677 230 683H326H394Q417 683 422 682T429 676L480 127L502 163Q523 199 560 262T642 400Q801 668 805 676L817 683H1003Q1010 678 1010 672Q1010 650 997 637H979Q915 637 906 623Q903 618 834 340T764 57Q764 50 771 49T817 46H845Q851 38 851 37T848 19Q845 7 838 0H824Q789 2 701 2Q670 2 644 2T603 2T584 1Q569 1 569 11Q569 13 571 25Q576 42 581 45L586 46Q590 46 597 46T611 46Q646 47 657 50T674 62L813 616L634 313Q453 7 452 7Q446 0 428 0Q409 0 407 6Q405 10 379 304T351 604L285 348Q220 83 220 82Q220 65 233 57T279 46H295Q301 38 301 37T298 19Q295 7 288 0H275Q244 2 171 2Q145 2 123 2T88 2T72 1"],78:[683,1,743,54,860,"633 637Q624 637 621 639T617 650Q617 670 630 683H641Q682 680 736 680Q836 680 845 683H853Q860 676 860 672Q858 647 848 637H832Q764 633 750 598Q746 590 673 300Q656 230 638 156T610 44L600 7Q598 0 576 0H559Q553 6 448 297L342 588Q341 588 279 336T216 81Q216 49 274 46Q293 46 295 40Q297 37 294 21Q293 19 292 16T291 11T290 7T289 4T287 2T284 1T280 1T275 0T263 0T229 1T167 2Q91 2 70 0H61Q54 7 54 11T57 27Q61 41 64 43T83 46Q146 50 164 84Q167 90 235 362L303 634Q300 635 253 637H220Q214 643 214 645T216 664Q220 677 226 683H314Q386 683 397 683T410 677Q412 675 501 428L591 179Q591 178 592 180T595 189T600 209T610 246T624 303T645 385Q698 595 698 606Q698 618 683 627T633 637"],79:[704,22,767,149,788,"149 237Q149 326 186 413T282 563T412 665T552 704Q619 704 667 678T741 611T777 528T788 444Q788 328 728 219T572 44T377 -22Q275 -22 212 50T149 237ZM688 487Q688 570 650 617T548 665Q467 665 398 592T291 413T253 203Q253 119 290 70T387 20Q440 20 489 52T573 135T635 249T675 373T688 487"],80:[683,0,678,55,729,"62 0Q55 7 55 11Q55 27 62 41Q66 46 96 46Q132 47 143 50T160 62Q162 66 231 344T301 626Q301 627 300 629V631Q294 637 239 637H221Q215 642 215 645T217 664Q221 677 227 683H